/*
 * Decompiled with CFR 0.152.
 */
package com.aspect.snoop.ui.choose.process;

import com.aspect.org.jdesktop.application.Action;
import com.aspect.org.jdesktop.application.Application;
import com.aspect.org.jdesktop.application.ApplicationActionMap;
import com.aspect.org.jdesktop.application.ResourceMap;
import com.aspect.snoop.JavaSnoop;
import com.aspect.snoop.SnoopSession;
import com.aspect.snoop.ui.choose.process.JVMDescriptor;
import com.aspect.snoop.util.ClasspathUtil;
import com.aspect.snoop.util.UIUtil;
import com.sun.tools.attach.VirtualMachineDescriptor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.URISyntaxException;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;
import sun.jvmstat.monitor.HostIdentifier;
import sun.jvmstat.monitor.MonitorException;
import sun.jvmstat.monitor.MonitoredHost;
import sun.jvmstat.monitor.MonitoredVm;
import sun.jvmstat.monitor.MonitoredVmUtil;
import sun.jvmstat.monitor.VmIdentifier;

public class ChooseProcessView
extends JDialog {
    private static final Logger logger = Logger.getLogger(ChooseProcessView.class);
    private String pid;
    SnoopSession session;
    private JButton btnCopyToClipboard;
    private JButton btnUseAndAttach;
    private JButton btnUseAndAttachAndClobber;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JScrollPane jScrollPane1;
    private JLabel lblJar;
    private JLabel lblMainArgs;
    private JLabel lblMainClass;
    private JLabel lblPid;
    private JLabel lblVmArgs;
    private JLabel lblVmVersion;
    private JList lstJavaProcesses;
    private static final boolean JPS_SHOW_JVM_ARGS = false;
    private static final boolean JPS_SHOW_LONG_PATHS = true;
    private static final boolean JPS_DEBUG = true;

    public ChooseProcessView(JFrame parent, boolean modal) {
        super((Frame)parent, modal);
        this.initComponents();
        this.lstJavaProcesses.setListData(new String[0]);
        this.lstJavaProcesses.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, selected, hasFocus);
                this.setText(this.getValueString(value));
                return this;
            }

            private String getValueString(Object value) {
                String returnString = "null";
                if (value != null) {
                    if (value instanceof VirtualMachineDescriptor) {
                        VirtualMachineDescriptor vmd = (VirtualMachineDescriptor)value;
                        returnString = "[PID=" + vmd.id() + "] " + vmd.displayName();
                    } else if (value instanceof JVMDescriptor) {
                        JVMDescriptor vmd = (JVMDescriptor)value;
                        returnString = "[PID=" + vmd.getId() + "] " + vmd.getTitle();
                        if (!vmd.isAttachable()) {
                            this.setForeground(Color.gray);
                        }
                    } else {
                        returnString = "???: " + value.toString();
                    }
                }
                return returnString;
            }
        });
        this.pid = null;
        this.loadProcesses();
        final JFrame p = parent;
        this.lstJavaProcesses.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!ChooseProcessView.this.lstJavaProcesses.isSelectionEmpty()) {
                    JVMDescriptor desc = (JVMDescriptor)ChooseProcessView.this.lstJavaProcesses.getSelectedValue();
                    ChooseProcessView.this.lblMainArgs.setText(desc.getMainArguments());
                    ChooseProcessView.this.lblVmArgs.setText(desc.getJVMArguments());
                    ChooseProcessView.this.lblPid.setText(desc.getId());
                    ChooseProcessView.this.lblVmVersion.setText(desc.getVMVersion());
                    ChooseProcessView.this.lblMainClass.setText(desc.getMainClass());
                    ChooseProcessView.this.lblJar.setText(desc.getJar());
                    ChooseProcessView.this.btnCopyToClipboard.setEnabled(true);
                    ChooseProcessView.this.btnUseAndAttach.setEnabled(true);
                } else {
                    String nsy = "(none selected yet)";
                    ChooseProcessView.this.lblMainArgs.setText(nsy);
                    ChooseProcessView.this.lblVmArgs.setText(nsy);
                    ChooseProcessView.this.lblPid.setText(nsy);
                    ChooseProcessView.this.lblVmVersion.setText(nsy);
                    ChooseProcessView.this.lblMainClass.setText(nsy);
                    ChooseProcessView.this.lblJar.setText(nsy);
                    ChooseProcessView.this.btnCopyToClipboard.setEnabled(false);
                    ChooseProcessView.this.btnUseAndAttach.setEnabled(false);
                }
            }
        });
        this.lstJavaProcesses.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    JVMDescriptor selection = (JVMDescriptor)ChooseProcessView.this.lstJavaProcesses.getSelectedValue();
                    if (!selection.isAttachable()) {
                        UIUtil.showErrorMessage(p, "Sorry, can't attach to that VM. It's probably running on an old version of Java.");
                        return;
                    }
                    ChooseProcessView.this.finalizeSelection();
                    ChooseProcessView.this.dispose();
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.lstJavaProcesses = new JList();
        this.jLabel1 = new JLabel();
        this.lblPid = new JLabel();
        this.jLabel3 = new JLabel();
        this.lblVmArgs = new JLabel();
        this.jLabel5 = new JLabel();
        this.lblMainArgs = new JLabel();
        this.jLabel2 = new JLabel();
        this.lblVmVersion = new JLabel();
        this.jLabel4 = new JLabel();
        this.lblMainClass = new JLabel();
        this.btnUseAndAttach = new JButton();
        this.btnCopyToClipboard = new JButton();
        this.jLabel6 = new JLabel();
        this.lblJar = new JLabel();
        this.btnUseAndAttachAndClobber = new JButton();
        this.setDefaultCloseOperation(2);
        ResourceMap resourceMap = Application.getInstance(JavaSnoop.class).getContext().getResourceMap(ChooseProcessView.class);
        this.setTitle(resourceMap.getString("Form.title", new Object[0]));
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setName("Form");
        this.setResizable(false);
        this.jScrollPane1.setName("jScrollPane1");
        this.lstJavaProcesses.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.lstJavaProcesses.setName("lstJavaProcesses");
        this.jScrollPane1.setViewportView(this.lstJavaProcesses);
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        this.lblPid.setText(resourceMap.getString("lblPid.text", new Object[0]));
        this.lblPid.setName("lblPid");
        this.jLabel3.setText(resourceMap.getString("jLabel3.text", new Object[0]));
        this.jLabel3.setName("jLabel3");
        this.lblVmArgs.setText(resourceMap.getString("lblVmArgs.text", new Object[0]));
        this.lblVmArgs.setName("lblVmArgs");
        this.jLabel5.setText(resourceMap.getString("jLabel5.text", new Object[0]));
        this.jLabel5.setName("jLabel5");
        this.lblMainArgs.setText(resourceMap.getString("lblMainArgs.text", new Object[0]));
        this.lblMainArgs.setName("lblMainArgs");
        this.jLabel2.setText(resourceMap.getString("jLabel2.text", new Object[0]));
        this.jLabel2.setName("jLabel2");
        this.lblVmVersion.setText(resourceMap.getString("lblVmVersion.text", new Object[0]));
        this.lblVmVersion.setName("lblVmVersion");
        this.jLabel4.setText(resourceMap.getString("jLabel4.text", new Object[0]));
        this.jLabel4.setName("jLabel4");
        this.lblMainClass.setText(resourceMap.getString("lblMainClass.text", new Object[0]));
        this.lblMainClass.setName("lblMainClass");
        ApplicationActionMap actionMap = Application.getInstance(JavaSnoop.class).getContext().getActionMap(ChooseProcessView.class, this);
        this.btnUseAndAttach.setAction(actionMap.get("useAndAttach"));
        this.btnUseAndAttach.setText(resourceMap.getString("btnUseAndAttach.text", new Object[0]));
        this.btnUseAndAttach.setToolTipText(resourceMap.getString("btnUseAndAttach.toolTipText", new Object[0]));
        this.btnUseAndAttach.setName("btnUseAndAttach");
        this.btnCopyToClipboard.setAction(actionMap.get("copyToClipboard"));
        this.btnCopyToClipboard.setText(resourceMap.getString("btnCopyToClipboard.text", new Object[0]));
        this.btnCopyToClipboard.setToolTipText(resourceMap.getString("btnCopyToClipboard.toolTipText", new Object[0]));
        this.btnCopyToClipboard.setName("btnCopyToClipboard");
        this.jLabel6.setText(resourceMap.getString("jLabel6.text", new Object[0]));
        this.jLabel6.setName("jLabel6");
        this.lblJar.setText(resourceMap.getString("lblJar.text", new Object[0]));
        this.lblJar.setName("lblJar");
        this.btnUseAndAttachAndClobber.setAction(actionMap.get("useAndAttachWithClobbering"));
        this.btnUseAndAttachAndClobber.setText(resourceMap.getString("btnUseAndAttachAndClobber.text", new Object[0]));
        this.btnUseAndAttachAndClobber.setToolTipText(resourceMap.getString("btnUseAndAttachAndClobber.toolTipText", new Object[0]));
        this.btnUseAndAttachAndClobber.setName("btnUseAndAttachAndClobber");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 598, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel3).addComponent(this.jLabel5).addComponent(this.jLabel4).addComponent(this.jLabel2).addComponent(this.jLabel6)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblPid, -2, 134, -2).addComponent(this.lblVmArgs, -2, 357, -2).addComponent(this.lblMainArgs, -2, 357, -2).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblVmVersion, -2, 186, -2).addComponent(this.lblJar, -2, 357, -2).addComponent(this.lblMainClass, -2, 346, -2)).addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.btnUseAndAttach).addComponent(this.btnCopyToClipboard))))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(421, Short.MAX_VALUE).addComponent(this.btnUseAndAttachAndClobber))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -2, 112, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addGap(6, 6, 6).addComponent(this.jLabel3).addGap(7, 7, 7).addComponent(this.jLabel5).addGap(7, 7, 7).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel4).addGap(6, 6, 6).addComponent(this.jLabel2).addGap(7, 7, 7).addComponent(this.jLabel6)).addGroup(layout.createSequentialGroup().addGap(3, 3, 3).addComponent(this.btnCopyToClipboard).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnUseAndAttach)))).addGroup(layout.createSequentialGroup().addComponent(this.lblPid).addGap(6, 6, 6).addComponent(this.lblVmArgs).addGap(6, 6, 6).addComponent(this.lblMainArgs, -2, 16, -2).addGap(6, 6, 6).addComponent(this.lblMainClass).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblVmVersion, -2, 15, -2).addGap(6, 6, 6).addComponent(this.lblJar))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnUseAndAttachAndClobber).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProcesses() {
        Vector<JVMDescriptor> vmds = new Vector<JVMDescriptor>();
        try {
            HostIdentifier hostId = null;
            try {
                hostId = new HostIdentifier("localhost");
            }
            catch (URISyntaxException e1) {
                e1.printStackTrace();
            }
            MonitoredHost monitoredHost = MonitoredHost.getMonitoredHost(hostId);
            Set<Integer> jvmids = monitoredHost.activeVms();
            for (Integer jvmid : jvmids) {
                MonitoredVm vm;
                String jvmIdString;
                StringBuilder output;
                block17: {
                    output = new StringBuilder();
                    Exception lastError = null;
                    jvmIdString = jvmid.toString();
                    output.append(jvmIdString);
                    vm = null;
                    String vmidString = "//" + jvmIdString + "?mode=r";
                    try {
                        VmIdentifier id = new VmIdentifier(vmidString);
                        vm = monitoredHost.getMonitoredVm(id, 0);
                    }
                    catch (Exception e) {
                        lastError = e;
                    }
                    finally {
                        if (vm != null) break block17;
                        output.append(" -- process information unavailable");
                        if (lastError == null || lastError.getMessage() == null) continue;
                        output.append("\n\t");
                        output.append(lastError.getMessage());
                        continue;
                    }
                }
                output.append(" ");
                output.append(MonitoredVmUtil.mainClass(vm, true));
                String mainClassName = MonitoredVmUtil.mainClass(vm, true);
                boolean isAttachable = this.isAttachable(jvmIdString);
                JVMDescriptor desc = new JVMDescriptor(jvmIdString, mainClassName, isAttachable);
                desc.setJVMArguments(MonitoredVmUtil.jvmArgs(vm));
                desc.setMainArguments(MonitoredVmUtil.mainArgs(vm));
                desc.setCommandLine(MonitoredVmUtil.commandLine(vm));
                desc.setVMVersion(MonitoredVmUtil.vmVersion(vm));
                if (mainClassName.length() == 0) {
                    mainClassName = desc.getCommandLine();
                } else if (mainClassName.endsWith(".jar")) {
                    desc.setJar(mainClassName);
                    try {
                        desc.setMainClass(ClasspathUtil.getMainClassFromJarFile(mainClassName));
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                } else {
                    desc.setMainClass(mainClassName);
                    desc.setJar("");
                }
                desc.setMainClass(MonitoredVmUtil.mainClass(vm, true));
                String currentPid = ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
                if (!currentPid.equals(desc.getId())) {
                    vmds.add(desc);
                }
                monitoredHost.detach(vm);
            }
        }
        catch (MonitorException e) {
            logger.error((Object)e);
        }
        this.lstJavaProcesses.setListData(vmds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAttachable(String id) {
        boolean attachable = false;
        MonitoredVm mvm = null;
        try {
            VmIdentifier vmid = new VmIdentifier(id);
            MonitoredHost host = MonitoredHost.getMonitoredHost(vmid);
            mvm = host.getMonitoredVm(vmid);
            if (MonitoredVmUtil.isAttachable(mvm)) {
                attachable = true;
            } else if (MonitoredVmUtil.isKernelVM((MonitoredVm)mvm)) {
                logger.trace((Object)"Kernel VM does not support the attach mechanism");
            } else {
                logger.trace((Object)("The VM does not support the attach mechanism for pid " + id));
            }
        }
        catch (Throwable t) {
            if (t instanceof ThreadDeath) {
                ThreadDeath td = (ThreadDeath)t;
                throw td;
            }
        }
        finally {
            if (mvm != null) {
                mvm.detach();
            }
        }
        return attachable;
    }

    private void finalizeSelection() {
        JVMDescriptor desc = (JVMDescriptor)this.lstJavaProcesses.getSelectedValue();
        this.pid = desc.getId();
    }

    public String getPid() {
        return this.pid;
    }

    @Action
    public void useAndAttach() {
        if (this.lstJavaProcesses.isSelectionEmpty()) {
            return;
        }
        JVMDescriptor jvm = (JVMDescriptor)this.lstJavaProcesses.getSelectedValue();
        this.session = this.toSession(jvm);
        this.finalizeSelection();
        this.dispose();
    }

    @Action
    public void useAndDispose() {
        if (this.lstJavaProcesses.isSelectionEmpty()) {
            return;
        }
        JVMDescriptor jvm = (JVMDescriptor)this.lstJavaProcesses.getSelectedValue();
        this.session = this.toSession(jvm);
        this.dispose();
    }

    public SnoopSession getSession() {
        return this.session;
    }

    private SnoopSession toSession(JVMDescriptor jvm) {
        SnoopSession sess = new SnoopSession();
        sess.setArguments(jvm.getMainArguments());
        sess.setJavaArguments(jvm.getJVMArguments());
        sess.setProcessId(Integer.parseInt(jvm.getId()));
        sess.setClasspathString(jvm.getJar());
        sess.setMainClass(jvm.getMainClass());
        return sess;
    }

    @Action
    public void copyToClipboard() {
        if (this.lstJavaProcesses.isSelectionEmpty()) {
            return;
        }
        String nl = System.getProperty("line.separator");
        JVMDescriptor jvm = (JVMDescriptor)this.lstJavaProcesses.getSelectedValue();
        StringBuilder sb = new StringBuilder(200);
        sb.append("PID: ").append(jvm.getId()).append(nl);
        sb.append("Main class: ").append(jvm.getMainClass()).append(nl);
        sb.append("Main arguments: ").append(jvm.getMainArguments()).append(nl);
        if (jvm.getJar().length() > 0) {
            sb.append("Jar file: ").append(jvm.getJar()).append(nl);
        }
        sb.append("JVM arguments: ").append(jvm.getJVMArguments()).append(nl);
        sb.append("VM version: ").append(jvm.getVMVersion());
        StringSelection buffer = new StringSelection(sb.toString());
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(buffer, buffer);
    }

    @Action
    public void useAndAttachWithClobbering() {
        if (this.lstJavaProcesses.isSelectionEmpty()) {
            return;
        }
        JVMDescriptor jvm = (JVMDescriptor)this.lstJavaProcesses.getSelectedValue();
        this.session = this.toSession(jvm);
        this.session.setCloberLookAndFeel(true);
        this.finalizeSelection();
        this.dispose();
    }
}

