---
# Do not remove front matter.
---

## Prerequisites

Although not required in all cases, [Git], [Go], and [Dart Sass] are commonly used when working with Hugo.

Git is required to:

- Build Hugo from source
- Use the [Hugo Modules] feature
- Install a theme as a Git submodule
- Access [commit information] from a local Git repository
- Host your site with services such as [CloudCannon], [Cloudflare Pages], [GitHub Pages], [GitLab Pages], and [Netlify]

Go is required to:

- Build Hugo from source
- Use the Hugo Modules feature

Dart Sass is required to transpile Sass to CSS when using the latest features of the Sass language.

Please refer to the relevant documentation for installation instructions:

- [Git][git install]
- [Go][go install]
- [Dart Sass][dart sass install]

[cloudcannon]: https://cloudcannon.com/
[cloudflare pages]: https://pages.cloudflare.com/
[dart sass install]: /hugo-pipes/transpile-sass-to-css/#dart-sass
[dart sass]: https://sass-lang.com/dart-sass
[git install]: https://git-scm.com/book/en/v2/Getting-Started-Installing-Git
[git]: https://git-scm.com/
[github pages]: https://pages.github.com/
[gitlab pages]: https://docs.gitlab.com/ee/user/project/pages/
[go install]: https://go.dev/doc/install
[go]: https://go.dev/
[netlify]: https://www.netlify.com/
