// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/maps/playablelocations/v3/sample/resources.proto

package sample

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	latlng "google.golang.org/genproto/googleapis/type/latlng"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Specifies whether the playable location's geographic coordinates (latitude
// and longitude) correspond to its center-point, or to its location snapped
// to the sidewalk of the nearest road.
type SpacingOptions_PointType int32

const (
	// Unspecified point type. Do not use this value.
	SpacingOptions_POINT_TYPE_UNSPECIFIED SpacingOptions_PointType = 0
	// The geographic coordinates correspond to the center of the location.
	SpacingOptions_CENTER_POINT SpacingOptions_PointType = 1
	// The geographic coordinates correspond to the location snapped to the
	// sidewalk of the nearest road (when a nearby road exists).
	SpacingOptions_SNAPPED_POINT SpacingOptions_PointType = 2
)

var SpacingOptions_PointType_name = map[int32]string{
	0: "POINT_TYPE_UNSPECIFIED",
	1: "CENTER_POINT",
	2: "SNAPPED_POINT",
}

var SpacingOptions_PointType_value = map[string]int32{
	"POINT_TYPE_UNSPECIFIED": 0,
	"CENTER_POINT":           1,
	"SNAPPED_POINT":          2,
}

func (x SpacingOptions_PointType) String() string {
	return proto.EnumName(SpacingOptions_PointType_name, int32(x))
}

func (SpacingOptions_PointType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_73697bf40b7fa1b5, []int{1, 0}
}

// A geographical point suitable for placing game objects in location-based
// games.
type PlayableLocation struct {
	// Required. The name of this playable location.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required.
	// Each location has one of the following identifiers:
	//
	// Types that are valid to be assigned to LocationId:
	//	*PlayableLocation_PlaceId
	//	*PlayableLocation_PlusCode
	LocationId isPlayableLocation_LocationId `protobuf_oneof:"location_id"`
	// A collection of [Playable Location Types](/maps/tt/games/types) for this
	// playable location. The first type in the collection is the primary type.
	//
	// Type information might not be available for all playable locations.
	Types []string `protobuf:"bytes,4,rep,name=types,proto3" json:"types,omitempty"`
	// Required. The latitude and longitude associated with the center of the playable
	// location.
	//
	// By default, the set of playable locations returned from
	// [SamplePlayableLocations][google.maps.playablelocations.v3.PlayableLocations.SamplePlayableLocations] use
	// center-point coordinates.
	CenterPoint *latlng.LatLng `protobuf:"bytes,5,opt,name=center_point,json=centerPoint,proto3" json:"center_point,omitempty"`
	// The playable location's coordinates, snapped to the sidewalk of the
	// nearest road, if a nearby road exists.
	SnappedPoint         *latlng.LatLng `protobuf:"bytes,6,opt,name=snapped_point,json=snappedPoint,proto3" json:"snapped_point,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *PlayableLocation) Reset()         { *m = PlayableLocation{} }
func (m *PlayableLocation) String() string { return proto.CompactTextString(m) }
func (*PlayableLocation) ProtoMessage()    {}
func (*PlayableLocation) Descriptor() ([]byte, []int) {
	return fileDescriptor_73697bf40b7fa1b5, []int{0}
}

func (m *PlayableLocation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PlayableLocation.Unmarshal(m, b)
}
func (m *PlayableLocation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PlayableLocation.Marshal(b, m, deterministic)
}
func (m *PlayableLocation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PlayableLocation.Merge(m, src)
}
func (m *PlayableLocation) XXX_Size() int {
	return xxx_messageInfo_PlayableLocation.Size(m)
}
func (m *PlayableLocation) XXX_DiscardUnknown() {
	xxx_messageInfo_PlayableLocation.DiscardUnknown(m)
}

var xxx_messageInfo_PlayableLocation proto.InternalMessageInfo

func (m *PlayableLocation) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

type isPlayableLocation_LocationId interface {
	isPlayableLocation_LocationId()
}

type PlayableLocation_PlaceId struct {
	PlaceId string `protobuf:"bytes,2,opt,name=place_id,json=placeId,proto3,oneof"`
}

type PlayableLocation_PlusCode struct {
	PlusCode string `protobuf:"bytes,3,opt,name=plus_code,json=plusCode,proto3,oneof"`
}

func (*PlayableLocation_PlaceId) isPlayableLocation_LocationId() {}

func (*PlayableLocation_PlusCode) isPlayableLocation_LocationId() {}

func (m *PlayableLocation) GetLocationId() isPlayableLocation_LocationId {
	if m != nil {
		return m.LocationId
	}
	return nil
}

func (m *PlayableLocation) GetPlaceId() string {
	if x, ok := m.GetLocationId().(*PlayableLocation_PlaceId); ok {
		return x.PlaceId
	}
	return ""
}

func (m *PlayableLocation) GetPlusCode() string {
	if x, ok := m.GetLocationId().(*PlayableLocation_PlusCode); ok {
		return x.PlusCode
	}
	return ""
}

func (m *PlayableLocation) GetTypes() []string {
	if m != nil {
		return m.Types
	}
	return nil
}

func (m *PlayableLocation) GetCenterPoint() *latlng.LatLng {
	if m != nil {
		return m.CenterPoint
	}
	return nil
}

func (m *PlayableLocation) GetSnappedPoint() *latlng.LatLng {
	if m != nil {
		return m.SnappedPoint
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*PlayableLocation) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*PlayableLocation_PlaceId)(nil),
		(*PlayableLocation_PlusCode)(nil),
	}
}

// A set of options that specifies the separation between playable locations.
type SpacingOptions struct {
	// Required. The minimum spacing between any two playable locations, measured in meters.
	// The minimum value is 200.
	// The maximum value is 1000.
	//
	// Inputs will be rounded up to the next 10 meter interval.
	//
	// The default value is 200m.
	//
	// Set this field to remove tight clusters of playable locations.
	//
	// Note:
	//
	// The spacing is a greedy algorithm. It optimizes for selecting the highest
	// ranking locations first, not to maximize the number of locations selected.
	// Consider the following scenario:
	//
	//   * Rank: A: 2, B: 1, C: 3.
	//   * Distance: A--200m--B--200m--C
	//
	// If spacing=250, it will pick the highest ranked location [B], not [A, C].
	//
	//
	// Note:
	//
	// Spacing works within the game object type itself, as well as the previous
	// ones.
	// Suppose three game object types, each with the following spacing:
	//
	//   * X: 400m, Y: undefined, Z: 200m.
	//
	// 1. Add locations for X, within 400m of each other.
	// 2. Add locations for Y, without any spacing.
	// 3. Finally, add locations for Z within 200m of each other as well X and Y.
	//
	// The distance diagram between those locations end up as:
	//
	//   * From->To.
	//   * X->X: 400m
	//   * Y->X, Y->Y: unspecified.
	//   * Z->X, Z->Y, Z->Z: 200m.
	MinSpacingMeters float64 `protobuf:"fixed64,1,opt,name=min_spacing_meters,json=minSpacingMeters,proto3" json:"min_spacing_meters,omitempty"`
	// Specifies whether the minimum spacing constraint applies to the
	// center-point or to the snapped point of playable locations. The default
	// value is `CENTER_POINT`.
	//
	// If a snapped point is not available for a playable location, its
	// center-point is used instead.
	//
	// Set this to the point type used in your game.
	PointType            SpacingOptions_PointType `protobuf:"varint,2,opt,name=point_type,json=pointType,proto3,enum=google.maps.playablelocations.v3.sample.SpacingOptions_PointType" json:"point_type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *SpacingOptions) Reset()         { *m = SpacingOptions{} }
func (m *SpacingOptions) String() string { return proto.CompactTextString(m) }
func (*SpacingOptions) ProtoMessage()    {}
func (*SpacingOptions) Descriptor() ([]byte, []int) {
	return fileDescriptor_73697bf40b7fa1b5, []int{1}
}

func (m *SpacingOptions) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SpacingOptions.Unmarshal(m, b)
}
func (m *SpacingOptions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SpacingOptions.Marshal(b, m, deterministic)
}
func (m *SpacingOptions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SpacingOptions.Merge(m, src)
}
func (m *SpacingOptions) XXX_Size() int {
	return xxx_messageInfo_SpacingOptions.Size(m)
}
func (m *SpacingOptions) XXX_DiscardUnknown() {
	xxx_messageInfo_SpacingOptions.DiscardUnknown(m)
}

var xxx_messageInfo_SpacingOptions proto.InternalMessageInfo

func (m *SpacingOptions) GetMinSpacingMeters() float64 {
	if m != nil {
		return m.MinSpacingMeters
	}
	return 0
}

func (m *SpacingOptions) GetPointType() SpacingOptions_PointType {
	if m != nil {
		return m.PointType
	}
	return SpacingOptions_POINT_TYPE_UNSPECIFIED
}

// Specifies the filters to use when searching for playable locations.
type Filter struct {
	// Specifies the maximum number of playable locations to return. This value
	// must not be greater than 500. The default value is 100.
	//
	// Only the top-ranking playable locations are returned.
	MaxLocationCount int32 `protobuf:"varint,1,opt,name=max_location_count,json=maxLocationCount,proto3" json:"max_location_count,omitempty"`
	// A set of options that control the spacing between playable locations. By
	// default the minimum distance between locations is 200m.
	Spacing *SpacingOptions `protobuf:"bytes,2,opt,name=spacing,proto3" json:"spacing,omitempty"`
	// Restricts the set of playable locations to just the
	// [types](/maps/tt/games/types) that you want.
	IncludedTypes        []string `protobuf:"bytes,3,rep,name=included_types,json=includedTypes,proto3" json:"included_types,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Filter) Reset()         { *m = Filter{} }
func (m *Filter) String() string { return proto.CompactTextString(m) }
func (*Filter) ProtoMessage()    {}
func (*Filter) Descriptor() ([]byte, []int) {
	return fileDescriptor_73697bf40b7fa1b5, []int{2}
}

func (m *Filter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Filter.Unmarshal(m, b)
}
func (m *Filter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Filter.Marshal(b, m, deterministic)
}
func (m *Filter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Filter.Merge(m, src)
}
func (m *Filter) XXX_Size() int {
	return xxx_messageInfo_Filter.Size(m)
}
func (m *Filter) XXX_DiscardUnknown() {
	xxx_messageInfo_Filter.DiscardUnknown(m)
}

var xxx_messageInfo_Filter proto.InternalMessageInfo

func (m *Filter) GetMaxLocationCount() int32 {
	if m != nil {
		return m.MaxLocationCount
	}
	return 0
}

func (m *Filter) GetSpacing() *SpacingOptions {
	if m != nil {
		return m.Spacing
	}
	return nil
}

func (m *Filter) GetIncludedTypes() []string {
	if m != nil {
		return m.IncludedTypes
	}
	return nil
}

// Encapsulates a filter criterion for searching for a set of playable
// locations.
type Criterion struct {
	// Required. An arbitrary, developer-defined identifier of the type of game object that
	// the playable location is used for. This field allows you to specify
	// criteria per game object type when searching for playable locations.
	//
	// You should assign a unique `game_object_type` ID across all
	// `request_criteria` to represent a distinct type of game object. For
	// example, 1=monster location, 2=powerup location.
	//
	// The response contains a map<game_object_type, Response>.
	GameObjectType int32 `protobuf:"varint,1,opt,name=game_object_type,json=gameObjectType,proto3" json:"game_object_type,omitempty"`
	// Specifies filtering options, and specifies what will be included in the
	// result set.
	Filter *Filter `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Specifies which `PlayableLocation` fields are returned.
	//
	// `name` (which is used for logging impressions), `center_point` and
	// `place_id` (or `plus_code`) are always returned.
	//
	// The following fields are omitted unless you specify them here:
	//
	//   * snapped_point
	//   * types
	//
	// Note: The more fields you include, the more expensive in terms of data and
	// associated latency your query will be.
	FieldsToReturn       *field_mask.FieldMask `protobuf:"bytes,3,opt,name=fields_to_return,json=fieldsToReturn,proto3" json:"fields_to_return,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *Criterion) Reset()         { *m = Criterion{} }
func (m *Criterion) String() string { return proto.CompactTextString(m) }
func (*Criterion) ProtoMessage()    {}
func (*Criterion) Descriptor() ([]byte, []int) {
	return fileDescriptor_73697bf40b7fa1b5, []int{3}
}

func (m *Criterion) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Criterion.Unmarshal(m, b)
}
func (m *Criterion) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Criterion.Marshal(b, m, deterministic)
}
func (m *Criterion) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Criterion.Merge(m, src)
}
func (m *Criterion) XXX_Size() int {
	return xxx_messageInfo_Criterion.Size(m)
}
func (m *Criterion) XXX_DiscardUnknown() {
	xxx_messageInfo_Criterion.DiscardUnknown(m)
}

var xxx_messageInfo_Criterion proto.InternalMessageInfo

func (m *Criterion) GetGameObjectType() int32 {
	if m != nil {
		return m.GameObjectType
	}
	return 0
}

func (m *Criterion) GetFilter() *Filter {
	if m != nil {
		return m.Filter
	}
	return nil
}

func (m *Criterion) GetFieldsToReturn() *field_mask.FieldMask {
	if m != nil {
		return m.FieldsToReturn
	}
	return nil
}

// Specifies the area to search for playable locations.
type AreaFilter struct {
	// Required. The S2 cell ID of the area you want. This must be between cell level 11 and
	// 14 (inclusive).
	//
	// S2 cells are 64-bit integers that identify areas on the Earth. They are
	// hierarchical, and can therefore be used for spatial indexing.
	//
	// The S2 geometry library is available in a number of languages:
	//
	//   * [C++](https://github.com/google/s2geometry)
	//   * [Java](https://github.com/google/s2-geometry-library-java)
	//   * [Go](https://github.com/golang/geo)
	//   * [Python](https://github.com/google/s2geometry/tree/master/src/python)
	S2CellId             uint64   `protobuf:"fixed64,1,opt,name=s2_cell_id,json=s2CellId,proto3" json:"s2_cell_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AreaFilter) Reset()         { *m = AreaFilter{} }
func (m *AreaFilter) String() string { return proto.CompactTextString(m) }
func (*AreaFilter) ProtoMessage()    {}
func (*AreaFilter) Descriptor() ([]byte, []int) {
	return fileDescriptor_73697bf40b7fa1b5, []int{4}
}

func (m *AreaFilter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AreaFilter.Unmarshal(m, b)
}
func (m *AreaFilter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AreaFilter.Marshal(b, m, deterministic)
}
func (m *AreaFilter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AreaFilter.Merge(m, src)
}
func (m *AreaFilter) XXX_Size() int {
	return xxx_messageInfo_AreaFilter.Size(m)
}
func (m *AreaFilter) XXX_DiscardUnknown() {
	xxx_messageInfo_AreaFilter.DiscardUnknown(m)
}

var xxx_messageInfo_AreaFilter proto.InternalMessageInfo

func (m *AreaFilter) GetS2CellId() uint64 {
	if m != nil {
		return m.S2CellId
	}
	return 0
}

// A list of PlayableLocation objects that satisfies a single Criterion.
type PlayableLocationList struct {
	// A list of playable locations for this game object type.
	Locations            []*PlayableLocation `protobuf:"bytes,1,rep,name=locations,proto3" json:"locations,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *PlayableLocationList) Reset()         { *m = PlayableLocationList{} }
func (m *PlayableLocationList) String() string { return proto.CompactTextString(m) }
func (*PlayableLocationList) ProtoMessage()    {}
func (*PlayableLocationList) Descriptor() ([]byte, []int) {
	return fileDescriptor_73697bf40b7fa1b5, []int{5}
}

func (m *PlayableLocationList) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PlayableLocationList.Unmarshal(m, b)
}
func (m *PlayableLocationList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PlayableLocationList.Marshal(b, m, deterministic)
}
func (m *PlayableLocationList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PlayableLocationList.Merge(m, src)
}
func (m *PlayableLocationList) XXX_Size() int {
	return xxx_messageInfo_PlayableLocationList.Size(m)
}
func (m *PlayableLocationList) XXX_DiscardUnknown() {
	xxx_messageInfo_PlayableLocationList.DiscardUnknown(m)
}

var xxx_messageInfo_PlayableLocationList proto.InternalMessageInfo

func (m *PlayableLocationList) GetLocations() []*PlayableLocation {
	if m != nil {
		return m.Locations
	}
	return nil
}

func init() {
	proto.RegisterEnum("google.maps.playablelocations.v3.sample.SpacingOptions_PointType", SpacingOptions_PointType_name, SpacingOptions_PointType_value)
	proto.RegisterType((*PlayableLocation)(nil), "google.maps.playablelocations.v3.sample.PlayableLocation")
	proto.RegisterType((*SpacingOptions)(nil), "google.maps.playablelocations.v3.sample.SpacingOptions")
	proto.RegisterType((*Filter)(nil), "google.maps.playablelocations.v3.sample.Filter")
	proto.RegisterType((*Criterion)(nil), "google.maps.playablelocations.v3.sample.Criterion")
	proto.RegisterType((*AreaFilter)(nil), "google.maps.playablelocations.v3.sample.AreaFilter")
	proto.RegisterType((*PlayableLocationList)(nil), "google.maps.playablelocations.v3.sample.PlayableLocationList")
}

func init() {
	proto.RegisterFile("google/maps/playablelocations/v3/sample/resources.proto", fileDescriptor_73697bf40b7fa1b5)
}

var fileDescriptor_73697bf40b7fa1b5 = []byte{
	// 737 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x54, 0xc1, 0x6e, 0xdb, 0x46,
	0x10, 0x35, 0x25, 0x5b, 0xb6, 0x46, 0x96, 0xc0, 0x6e, 0x8d, 0x42, 0x50, 0x51, 0x54, 0x15, 0x50,
	0x58, 0x40, 0x5b, 0x12, 0x95, 0x80, 0xba, 0x45, 0x4f, 0x92, 0x2c, 0xbb, 0x02, 0x24, 0x99, 0xa5,
	0xd4, 0x16, 0xed, 0x65, 0xbb, 0x22, 0xd7, 0x2c, 0xeb, 0x25, 0x77, 0xc1, 0xa5, 0x0c, 0xfb, 0x77,
	0x72, 0xcc, 0x29, 0x7f, 0x90, 0x73, 0xfe, 0x22, 0xff, 0x90, 0x53, 0x6e, 0xc1, 0x2e, 0x97, 0x0e,
	0xe2, 0x20, 0x88, 0x90, 0x13, 0xc9, 0x99, 0xf7, 0x66, 0xe6, 0xbd, 0x9d, 0x25, 0x9c, 0x45, 0x9c,
	0x47, 0x8c, 0xba, 0x09, 0x11, 0xd2, 0x15, 0x8c, 0xdc, 0x93, 0x0d, 0xa3, 0x8c, 0x07, 0x24, 0x8f,
	0x79, 0x2a, 0xdd, 0xdb, 0xa1, 0x2b, 0x49, 0x22, 0x18, 0x75, 0x33, 0x2a, 0xf9, 0x36, 0x0b, 0xa8,
	0x74, 0x44, 0xc6, 0x73, 0x8e, 0x4e, 0x0b, 0xa2, 0xa3, 0x88, 0xce, 0x7b, 0x44, 0xe7, 0x76, 0xe8,
	0x14, 0xc4, 0xce, 0xd7, 0xa6, 0x03, 0x11, 0xb1, 0x7b, 0x1d, 0x53, 0x16, 0xe2, 0x0d, 0xfd, 0x8f,
	0xdc, 0xc6, 0x3c, 0x2b, 0x2a, 0x75, 0xba, 0x06, 0xa0, 0xbf, 0x36, 0xdb, 0x6b, 0x83, 0x4a, 0x88,
	0xbc, 0x31, 0x88, 0xb6, 0x41, 0xe4, 0xf7, 0x82, 0xba, 0x8c, 0xe4, 0x2c, 0x8d, 0x8a, 0x4c, 0xef,
	0xb5, 0x05, 0xb6, 0x67, 0x9a, 0xcf, 0x4d, 0x73, 0x84, 0x60, 0x3f, 0x25, 0x09, 0x6d, 0x5b, 0x5d,
	0xab, 0x5f, 0xf7, 0xf5, 0x3b, 0xfa, 0x12, 0x8e, 0x04, 0x23, 0x01, 0xc5, 0x71, 0xd8, 0xae, 0xa8,
	0xf8, 0x6f, 0x7b, 0xfe, 0xa1, 0x8e, 0xcc, 0x42, 0xf4, 0x15, 0xd4, 0x05, 0xdb, 0x4a, 0x1c, 0xf0,
	0x90, 0xb6, 0xab, 0x26, 0x7b, 0xa4, 0x42, 0x13, 0x1e, 0x52, 0x74, 0x02, 0x07, 0xaa, 0xb3, 0x6c,
	0xef, 0x77, 0xab, 0xfd, 0xba, 0x5f, 0x7c, 0xa0, 0x9f, 0xe0, 0x38, 0xa0, 0x69, 0x4e, 0x33, 0x2c,
	0x78, 0x9c, 0xe6, 0xed, 0x83, 0xae, 0xd5, 0x6f, 0x0c, 0x3e, 0x77, 0x8c, 0x2f, 0x0a, 0xe4, 0xcc,
	0x49, 0x3e, 0x4f, 0x23, 0xbf, 0x51, 0x00, 0x3d, 0x85, 0x43, 0x3f, 0x43, 0x53, 0xa6, 0x44, 0x08,
	0x1a, 0x1a, 0x62, 0xed, 0xc3, 0xc4, 0x63, 0x83, 0xd4, 0xcc, 0x71, 0x13, 0x1a, 0xa5, 0xc1, 0x38,
	0x0e, 0x7b, 0xaf, 0x2c, 0x68, 0xad, 0x04, 0x09, 0xe2, 0x34, 0xba, 0x12, 0xda, 0x75, 0xf4, 0x23,
	0xa0, 0x24, 0x4e, 0xb1, 0x2c, 0xa2, 0x38, 0xa1, 0x39, 0xcd, 0xa4, 0xf6, 0xc1, 0x1a, 0x57, 0x5f,
	0x8e, 0x2a, 0xbe, 0x9d, 0xc4, 0xa9, 0xe1, 0x2c, 0x74, 0x12, 0xfd, 0x0b, 0xa0, 0xc7, 0xc0, 0xaa,
	0xaf, 0xb6, 0xa6, 0x35, 0x18, 0x39, 0x3b, 0x1e, 0xae, 0xf3, 0x6e, 0x7f, 0x47, 0xcf, 0xb9, 0xbe,
	0x17, 0xd4, 0xaf, 0x8b, 0xf2, 0xb5, 0x37, 0x87, 0xfa, 0x43, 0x1c, 0x75, 0xe0, 0x0b, 0xef, 0x6a,
	0xb6, 0x5c, 0xe3, 0xf5, 0xdf, 0xde, 0x14, 0xff, 0xb1, 0x5c, 0x79, 0xd3, 0xc9, 0xec, 0x62, 0x36,
	0x3d, 0xb7, 0xf7, 0x90, 0x0d, 0xc7, 0x93, 0xe9, 0x72, 0x3d, 0xf5, 0xb1, 0x86, 0xd8, 0x16, 0xfa,
	0x0c, 0x9a, 0xab, 0xe5, 0xc8, 0xf3, 0xa6, 0xe7, 0x26, 0x54, 0xe9, 0x3d, 0xb3, 0xa0, 0x76, 0x11,
	0xb3, 0x9c, 0x66, 0xe8, 0x7b, 0x40, 0x09, 0xb9, 0xc3, 0x0f, 0x9e, 0x04, 0x7c, 0x9b, 0xe6, 0x5a,
	0xed, 0x81, 0x6f, 0x27, 0xe4, 0xae, 0x5c, 0x88, 0x89, 0x8a, 0xa3, 0xdf, 0xe1, 0xd0, 0xf8, 0xa2,
	0x55, 0x36, 0x06, 0x67, 0x9f, 0xa8, 0xd2, 0x2f, 0xeb, 0xa0, 0x6f, 0xa1, 0x15, 0xa7, 0x01, 0xdb,
	0x86, 0x34, 0xc4, 0xc5, 0x86, 0x54, 0xf5, 0x86, 0x34, 0xcb, 0xa8, 0x92, 0x2c, 0x7b, 0x2f, 0x2c,
	0xa8, 0x4f, 0xb2, 0x38, 0xa7, 0x99, 0xda, 0xce, 0x1f, 0xc0, 0x8e, 0x48, 0x42, 0x31, 0xdf, 0xfc,
	0x4f, 0x03, 0x63, 0xbb, 0x9e, 0xb9, 0x38, 0xa1, 0x96, 0x4a, 0x5e, 0xe9, 0x9c, 0x36, 0xec, 0x12,
	0x6a, 0xd7, 0x5a, 0xae, 0x99, 0xda, 0xdd, 0x79, 0xea, 0xc2, 0x25, 0xdf, 0xd0, 0xd1, 0x39, 0xd8,
	0xfa, 0x62, 0x49, 0x9c, 0x73, 0x9c, 0xd1, 0x7c, 0x9b, 0xa5, 0x7a, 0xd7, 0x1b, 0x83, 0x4e, 0x59,
	0xb2, 0xbc, 0x81, 0xce, 0x85, 0x02, 0x2e, 0x88, 0xbc, 0xf1, 0x5b, 0x05, 0x67, 0xcd, 0x7d, 0xcd,
	0xe8, 0xb9, 0x00, 0xa3, 0x8c, 0x12, 0x73, 0x02, 0xdf, 0x00, 0xc8, 0x01, 0x0e, 0x28, 0x63, 0xea,
	0x5e, 0x29, 0x15, 0xb5, 0x42, 0xc5, 0x91, 0x1c, 0x4c, 0x28, 0x63, 0xb3, 0xb0, 0xc7, 0xe1, 0xe4,
	0xf1, 0x05, 0x9d, 0xc7, 0x32, 0x47, 0x7f, 0x41, 0xfd, 0x61, 0xe8, 0xb6, 0xd5, 0xad, 0xf6, 0x1b,
	0x83, 0x5f, 0x76, 0x96, 0xf6, 0xb8, 0xa2, 0xff, 0xb6, 0xd6, 0xf8, 0xb9, 0x05, 0xdf, 0x05, 0x3c,
	0xd9, 0xb5, 0xd6, 0xb8, 0xe5, 0x97, 0x7f, 0x36, 0x4f, 0xc9, 0xf7, 0xac, 0x7f, 0x16, 0x86, 0x1a,
	0x71, 0x46, 0xd2, 0xc8, 0xe1, 0x59, 0xe4, 0x46, 0x34, 0xd5, 0xe6, 0xb8, 0x45, 0x8a, 0x88, 0x58,
	0x7e, 0xf4, 0x97, 0xf9, 0x6b, 0xf1, 0x78, 0x52, 0xd9, 0xbf, 0x5c, 0x78, 0xf3, 0xa7, 0x95, 0xd3,
	0xcb, 0xa2, 0xec, 0x42, 0x4d, 0xf4, 0x58, 0x81, 0x74, 0xfe, 0x1c, 0x3a, 0x2b, 0x4d, 0xd8, 0xd4,
	0x74, 0xab, 0xe1, 0x9b, 0x00, 0x00, 0x00, 0xff, 0xff, 0x99, 0x02, 0x02, 0x8b, 0x9c, 0x05, 0x00,
	0x00,
}
