// Code generated by *generator.VersionedSegmentUnmarshalerGenerator; DO NOT EDIT.

package segment

import (
	"bytes"
	"fmt"

	"github.com/mitch000001/go-hbci/element"
)

func (s *SignatureEndSegment) UnmarshalHBCI(value []byte) error {
	elements, err := ExtractElements(value)
	if err != nil {
		return err
	}
	header := &element.SegmentHeader{}
	err = header.UnmarshalHBCI(elements[0])
	if err != nil {
		return err
	}
	var segment signatureEndSegment
	switch header.Version.Val() {
	case 1:
		segment = &SignatureEndV1{}
		err = segment.UnmarshalHBCI(value)
		if err != nil {
			return err
		}
	case 2:
		segment = &SignatureEndV2{}
		err = segment.UnmarshalHBCI(value)
		if err != nil {
			return err
		}
	default:
		return fmt.Errorf("Unknown segment version: %d", header.Version.Val())
	}
	s.signatureEndSegment = segment
	return nil
}

func (s *SignatureEndV1) UnmarshalHBCI(value []byte) error {
	elements, err := ExtractElements(value)
	if err != nil {
		return err
	}
	if len(elements) == 0 {
		return fmt.Errorf("Malformed marshaled value")
	}
	seg, err := SegmentFromHeaderBytes(elements[0], s)
	if err != nil {
		return err
	}
	s.ClientSegment = seg
	if len(elements) > 1 && len(elements[1]) > 0 {
		s.SecurityControlRef = &element.AlphaNumericDataElement{}
		err = s.SecurityControlRef.UnmarshalHBCI(elements[1])
		if err != nil {
			return err
		}
	}
	if len(elements) > 2 && len(elements[2]) > 0 {
		s.Signature = &element.BinaryDataElement{}
		err = s.Signature.UnmarshalHBCI(elements[2])
		if err != nil {
			return err
		}
	}
	if len(elements) > 3 && len(elements[3]) > 0 {
		s.PinTan = &element.PinTanDataElement{}
		if len(elements)+1 > 3 {
			err = s.PinTan.UnmarshalHBCI(bytes.Join(elements[3:], []byte("+")))
		} else {
			err = s.PinTan.UnmarshalHBCI(elements[3])
		}
		if err != nil {
			return err
		}
	}
	return nil
}

func (s *SignatureEndV2) UnmarshalHBCI(value []byte) error {
	elements, err := ExtractElements(value)
	if err != nil {
		return err
	}
	if len(elements) == 0 {
		return fmt.Errorf("Malformed marshaled value")
	}
	seg, err := SegmentFromHeaderBytes(elements[0], s)
	if err != nil {
		return err
	}
	s.ClientSegment = seg
	if len(elements) > 1 && len(elements[1]) > 0 {
		s.SecurityControlRef = &element.AlphaNumericDataElement{}
		err = s.SecurityControlRef.UnmarshalHBCI(elements[1])
		if err != nil {
			return err
		}
	}
	if len(elements) > 2 && len(elements[2]) > 0 {
		s.Signature = &element.BinaryDataElement{}
		err = s.Signature.UnmarshalHBCI(elements[2])
		if err != nil {
			return err
		}
	}
	if len(elements) > 3 && len(elements[3]) > 0 {
		s.CustomSignature = &element.CustomSignatureDataElement{}
		if len(elements)+1 > 3 {
			err = s.CustomSignature.UnmarshalHBCI(bytes.Join(elements[3:], []byte("+")))
		} else {
			err = s.CustomSignature.UnmarshalHBCI(elements[3])
		}
		if err != nil {
			return err
		}
	}
	return nil
}
