// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// An array of key-value pairs to set for advanced control over Amazon Redshift
// Serverless.
type ConfigParameter struct {

	// The key of the parameter. The options are datestyle,
	// enable_user_activity_logging, query_group, search_path, and
	// max_query_execution_time.
	ParameterKey *string

	// The value of the parameter to set.
	ParameterValue *string

	noSmithyDocumentSerde
}

// The VPC endpoint object.
type Endpoint struct {

	// The DNS address of the VPC endpoint.
	Address *string

	// The port that Amazon Redshift Serverless listens on.
	Port *int32

	// An array of VpcEndpoint objects.
	VpcEndpoints []VpcEndpoint

	noSmithyDocumentSerde
}

// Information about an Amazon Redshift Serverless VPC endpoint.
type EndpointAccess struct {

	// The DNS address of the endpoint.
	Address *string

	// The Amazon Resource Name (ARN) of the VPC endpoint.
	EndpointArn *string

	// The time that the endpoint was created.
	EndpointCreateTime *time.Time

	// The name of the VPC endpoint.
	EndpointName *string

	// The status of the VPC endpoint.
	EndpointStatus *string

	// The port number on which Amazon Redshift Serverless accepts incoming
	// connections.
	Port *int32

	// The unique identifier of subnets where Amazon Redshift Serverless choose to
	// deploy the VPC endpoint.
	SubnetIds []string

	// The connection endpoint for connecting to Amazon Redshift Serverless.
	VpcEndpoint *VpcEndpoint

	// The security groups associated with the endpoint.
	VpcSecurityGroups []VpcSecurityGroupMembership

	// The name of the workgroup associated with the endpoint.
	WorkgroupName *string

	noSmithyDocumentSerde
}

// A collection of database objects and users.
type Namespace struct {

	// The username of the administrator for the first database created in the
	// namespace.
	AdminUsername *string

	// The date of when the namespace was created.
	CreationDate *time.Time

	// The name of the first database created in the namespace.
	DbName *string

	// The Amazon Resource Name (ARN) of the IAM role to set as a default in the
	// namespace.
	DefaultIamRoleArn *string

	// A list of IAM roles to associate with the namespace.
	IamRoles []string

	// The ID of the Amazon Web Services Key Management Service key used to encrypt
	// your data.
	KmsKeyId *string

	// The types of logs the namespace can export. Available export types are User log,
	// Connection log, and User activity log.
	LogExports []LogExport

	// The Amazon Resource Name (ARN) associated with a namespace.
	NamespaceArn *string

	// The unique identifier of a namespace.
	NamespaceId *string

	// The name of the namespace. Must be between 3-64 alphanumeric characters in
	// lowercase, and it cannot be a reserved word. A list of reserved words can be
	// found in Reserved Words
	// (https://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html) in the
	// Amazon Redshift Database Developer Guide.
	NamespaceName *string

	// The status of the namespace.
	Status NamespaceStatus

	noSmithyDocumentSerde
}

// Contains information about a network interface in an Amazon Redshift Serverless
// managed VPC endpoint.
type NetworkInterface struct {

	// The availability Zone.
	AvailabilityZone *string

	// The unique identifier of the network interface.
	NetworkInterfaceId *string

	// The IPv4 address of the network interface within the subnet.
	PrivateIpAddress *string

	// The unique identifier of the subnet.
	SubnetId *string

	noSmithyDocumentSerde
}

// The automatically created recovery point of a namespace. Recovery points are
// created every 30 minutes and kept for 24 hours.
type RecoveryPoint struct {

	// The name of the namespace the recovery point is associated with.
	NamespaceName *string

	// The time the recovery point is created.
	RecoveryPointCreateTime *time.Time

	// The unique identifier of the recovery point.
	RecoveryPointId *string

	// The total size of the data in the recovery point in megabytes.
	TotalSizeInMegaBytes *float64

	// The name of the workgroup the recovery point is associated with.
	WorkgroupName *string

	noSmithyDocumentSerde
}

// The resource policy object. Currently, you can use policies to share snapshots
// across Amazon Web Services accounts.
type ResourcePolicy struct {

	// The resource policy.
	Policy *string

	// The Amazon Resource Name (ARN) of the policy.
	ResourceArn *string

	noSmithyDocumentSerde
}

// A snapshot object that contains databases.
type Snapshot struct {

	// All of the Amazon Web Services accounts that have access to restore a snapshot
	// to a provisioned cluster.
	AccountsWithProvisionedRestoreAccess []string

	// All of the Amazon Web Services accounts that have access to restore a snapshot
	// to a namespace.
	AccountsWithRestoreAccess []string

	// The size of the incremental backup in megabytes.
	ActualIncrementalBackupSizeInMegaBytes *float64

	// The username of the database within a snapshot.
	AdminUsername *string

	// The size in megabytes of the data that has been backed up to a snapshot.
	BackupProgressInMegaBytes *float64

	// The rate at which data is backed up into a snapshot in megabytes per second.
	CurrentBackupRateInMegaBytesPerSecond *float64

	// The amount of time it took to back up data into a snapshot.
	ElapsedTimeInSeconds *int64

	// The estimated amount of seconds until the snapshot completes backup.
	EstimatedSecondsToCompletion *int64

	// The unique identifier of the KMS key used to encrypt the snapshot.
	KmsKeyId *string

	// The Amazon Resource Name (ARN) of the namespace the snapshot was created from.
	NamespaceArn *string

	// The name of the namepsace.
	NamespaceName *string

	// The owner Amazon Web Services; account of the snapshot.
	OwnerAccount *string

	// The Amazon Resource Name (ARN) of the snapshot.
	SnapshotArn *string

	// The timestamp of when the snapshot was created.
	SnapshotCreateTime *time.Time

	// The name of the snapshot.
	SnapshotName *string

	// The amount of days until the snapshot is deleted.
	SnapshotRemainingDays *int32

	// The period of time, in days, of how long the snapshot is retained.
	SnapshotRetentionPeriod *int32

	// The timestamp of when data within the snapshot started getting retained.
	SnapshotRetentionStartTime *time.Time

	// The status of the snapshot.
	Status SnapshotStatus

	// The total size, in megabytes, of how big the snapshot is.
	TotalBackupSizeInMegaBytes *float64

	noSmithyDocumentSerde
}

// A map of key-value pairs.
type Tag struct {

	// The key to use in the tag.
	//
	// This member is required.
	Key *string

	// The value of the tag.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// The usage limit object.
type UsageLimit struct {

	// The limit amount. If time-based, this amount is in RPUs consumed per hour. If
	// data-based, this amount is in terabytes (TB). The value must be a positive
	// number.
	Amount *int64

	// The action that Amazon Redshift Serverless takes when the limit is reached.
	BreachAction UsageLimitBreachAction

	// The time period that the amount applies to. A weekly period begins on Sunday.
	// The default is monthly.
	Period UsageLimitPeriod

	// The Amazon Resource Name (ARN) that identifies the Amazon Redshift Serverless
	// resource.
	ResourceArn *string

	// The Amazon Resource Name (ARN) of the resource associated with the usage limit.
	UsageLimitArn *string

	// The identifier of the usage limit.
	UsageLimitId *string

	// The Amazon Redshift Serverless feature to limit.
	UsageType UsageLimitUsageType

	noSmithyDocumentSerde
}

// The connection endpoint for connecting to Amazon Redshift Serverless through the
// proxy.
type VpcEndpoint struct {

	// One or more network interfaces of the endpoint. Also known as an interface
	// endpoint.
	NetworkInterfaces []NetworkInterface

	// The connection endpoint ID for connecting to Amazon Redshift Serverless.
	VpcEndpointId *string

	// The VPC identifier that the endpoint is associated with.
	VpcId *string

	noSmithyDocumentSerde
}

// Describes the members of a VPC security group.
type VpcSecurityGroupMembership struct {

	// The status of the VPC security group.
	Status *string

	// The unique identifier of the VPC security group.
	VpcSecurityGroupId *string

	noSmithyDocumentSerde
}

// The collection of computing resources from which an endpoint is created.
type Workgroup struct {

	// The base data warehouse capacity of the workgroup in Redshift Processing Units
	// (RPUs).
	BaseCapacity *int32

	// An array of parameters to set for finer control over a database. The options are
	// datestyle, enable_user_activity_logging, query_group, search_path, and
	// max_query_execution_time.
	ConfigParameters []ConfigParameter

	// The creation date of the workgroup.
	CreationDate *time.Time

	// The endpoint that is created from the workgroup.
	Endpoint *Endpoint

	// The value that specifies whether to enable enhanced virtual private cloud (VPC)
	// routing, which forces Amazon Redshift Serverless to route traffic through your
	// VPC.
	EnhancedVpcRouting *bool

	// The namespace the workgroup is associated with.
	NamespaceName *string

	// A value that specifies whether the workgroup can be accessible from a public
	// network
	PubliclyAccessible *bool

	// An array of security group IDs to associate with the workgroup.
	SecurityGroupIds []string

	// The status of the workgroup.
	Status WorkgroupStatus

	// An array of subnet IDs the workgroup is associated with.
	SubnetIds []string

	// The Amazon Resource Name (ARN) that links to the workgroup.
	WorkgroupArn *string

	// The unique identifier of the workgroup.
	WorkgroupId *string

	// The name of the workgroup.
	WorkgroupName *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
