// Code generated by smithy-go-codegen DO NOT EDIT.

package opensearch

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/opensearch/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a new Amazon OpenSearch Service domain. For more information, see
// Creating and managing Amazon OpenSearch Service domains
// (http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html)
// in the Amazon OpenSearch Service Developer Guide.
func (c *Client) CreateDomain(ctx context.Context, params *CreateDomainInput, optFns ...func(*Options)) (*CreateDomainOutput, error) {
	if params == nil {
		params = &CreateDomainInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateDomain", params, optFns, c.addOperationCreateDomainMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateDomainOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateDomainInput struct {

	// The name of the Amazon OpenSearch Service domain you're creating. Domain names
	// are unique across the domains owned by an account within an AWS region. Domain
	// names must start with a lowercase letter and can contain the following
	// characters: a-z (lowercase), 0-9, and - (hyphen).
	//
	// This member is required.
	DomainName *string

	// IAM access policy as a JSON-formatted string.
	AccessPolicies *string

	// Option to allow references to indices in an HTTP request body. Must be false
	// when configuring access to individual sub-resources. By default, the value is
	// true. See Advanced cluster parameters
	// (http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options)
	// for more information.
	AdvancedOptions map[string]string

	// Specifies advanced security options.
	AdvancedSecurityOptions *types.AdvancedSecurityOptionsInput

	// Specifies Auto-Tune options.
	AutoTuneOptions *types.AutoTuneOptionsInput

	// Configuration options for a domain. Specifies the instance type and number of
	// instances in the domain.
	ClusterConfig *types.ClusterConfig

	// Options to specify the Cognito user and identity pools for OpenSearch Dashboards
	// authentication. For more information, see Configuring Amazon Cognito
	// authentication for OpenSearch Dashboards
	// (http://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html).
	CognitoOptions *types.CognitoOptions

	// Options to specify configurations that will be applied to the domain endpoint.
	DomainEndpointOptions *types.DomainEndpointOptions

	// Options to enable, disable, and specify the type and size of EBS storage
	// volumes.
	EBSOptions *types.EBSOptions

	// Options for encryption of data at rest.
	EncryptionAtRestOptions *types.EncryptionAtRestOptions

	// String of format Elasticsearch_X.Y or OpenSearch_X.Y to specify the engine
	// version for the Amazon OpenSearch Service domain. For example, "OpenSearch_1.0"
	// or "Elasticsearch_7.9". For more information, see Creating and managing Amazon
	// OpenSearch Service domains
	// (http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomains).
	EngineVersion *string

	// Map of LogType and LogPublishingOption, each containing options to publish a
	// given type of OpenSearch log.
	LogPublishingOptions map[string]types.LogPublishingOption

	// Node-to-node encryption options.
	NodeToNodeEncryptionOptions *types.NodeToNodeEncryptionOptions

	// Option to set time, in UTC format, of the daily automated snapshot. Default
	// value is 0 hours.
	SnapshotOptions *types.SnapshotOptions

	// A list of Tag added during domain creation.
	TagList []types.Tag

	// Options to specify the subnets and security groups for a VPC endpoint. For more
	// information, see Launching your Amazon OpenSearch Service domains using a VPC
	// (http://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html).
	VPCOptions *types.VPCOptions

	noSmithyDocumentSerde
}

// The result of a CreateDomain operation. Contains the status of the newly created
// Amazon OpenSearch Service domain.
type CreateDomainOutput struct {

	// The status of the newly created domain.
	DomainStatus *types.DomainStatus

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateDomainMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateDomain{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateDomain{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpCreateDomainValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateDomain(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateDomain(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "es",
		OperationName: "CreateDomain",
	}
}
