// Code generated by smithy-go-codegen DO NOT EDIT.

package macie2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/macie2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves a subset of information about one or more classification jobs.
func (c *Client) ListClassificationJobs(ctx context.Context, params *ListClassificationJobsInput, optFns ...func(*Options)) (*ListClassificationJobsOutput, error) {
	if params == nil {
		params = &ListClassificationJobsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListClassificationJobs", params, optFns, c.addOperationListClassificationJobsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListClassificationJobsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListClassificationJobsInput struct {

	// The criteria to use to filter the results.
	FilterCriteria *types.ListJobsFilterCriteria

	// The maximum number of items to include in each page of the response.
	MaxResults int32

	// The nextToken string that specifies which page of results to return in a
	// paginated response.
	NextToken *string

	// The criteria to use to sort the results.
	SortCriteria *types.ListJobsSortCriteria

	noSmithyDocumentSerde
}

type ListClassificationJobsOutput struct {

	// An array of objects, one for each job that meets the filter criteria specified
	// in the request.
	Items []types.JobSummary

	// The string to use in a subsequent request to get the next page of results in a
	// paginated response. This value is null if there are no additional pages.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListClassificationJobsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListClassificationJobs{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListClassificationJobs{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListClassificationJobs(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

// ListClassificationJobsAPIClient is a client that implements the
// ListClassificationJobs operation.
type ListClassificationJobsAPIClient interface {
	ListClassificationJobs(context.Context, *ListClassificationJobsInput, ...func(*Options)) (*ListClassificationJobsOutput, error)
}

var _ ListClassificationJobsAPIClient = (*Client)(nil)

// ListClassificationJobsPaginatorOptions is the paginator options for
// ListClassificationJobs
type ListClassificationJobsPaginatorOptions struct {
	// The maximum number of items to include in each page of the response.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListClassificationJobsPaginator is a paginator for ListClassificationJobs
type ListClassificationJobsPaginator struct {
	options   ListClassificationJobsPaginatorOptions
	client    ListClassificationJobsAPIClient
	params    *ListClassificationJobsInput
	nextToken *string
	firstPage bool
}

// NewListClassificationJobsPaginator returns a new ListClassificationJobsPaginator
func NewListClassificationJobsPaginator(client ListClassificationJobsAPIClient, params *ListClassificationJobsInput, optFns ...func(*ListClassificationJobsPaginatorOptions)) *ListClassificationJobsPaginator {
	if params == nil {
		params = &ListClassificationJobsInput{}
	}

	options := ListClassificationJobsPaginatorOptions{}
	if params.MaxResults != 0 {
		options.Limit = params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListClassificationJobsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListClassificationJobsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListClassificationJobs page.
func (p *ListClassificationJobsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListClassificationJobsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	params.MaxResults = p.options.Limit

	result, err := p.client.ListClassificationJobs(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListClassificationJobs(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "macie2",
		OperationName: "ListClassificationJobs",
	}
}
