// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by ent, DO NOT EDIT.

package ent

import (
	"context"
	"fmt"
	"math"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/entc/integration/customid/ent/blob"
	"entgo.io/ent/entc/integration/customid/ent/bloblink"
	"entgo.io/ent/entc/integration/customid/ent/predicate"
	"github.com/google/uuid"
)

// BlobLinkQuery is the builder for querying BlobLink entities.
type BlobLinkQuery struct {
	config
	limit      *int
	offset     *int
	unique     *bool
	order      []OrderFunc
	fields     []string
	predicates []predicate.BlobLink
	withBlob   *BlobQuery
	withLink   *BlobQuery
	// intermediate query (i.e. traversal path).
	sql  *sql.Selector
	path func(context.Context) (*sql.Selector, error)
}

// Where adds a new predicate for the BlobLinkQuery builder.
func (blq *BlobLinkQuery) Where(ps ...predicate.BlobLink) *BlobLinkQuery {
	blq.predicates = append(blq.predicates, ps...)
	return blq
}

// Limit adds a limit step to the query.
func (blq *BlobLinkQuery) Limit(limit int) *BlobLinkQuery {
	blq.limit = &limit
	return blq
}

// Offset adds an offset step to the query.
func (blq *BlobLinkQuery) Offset(offset int) *BlobLinkQuery {
	blq.offset = &offset
	return blq
}

// Unique configures the query builder to filter duplicate records on query.
// By default, unique is set to true, and can be disabled using this method.
func (blq *BlobLinkQuery) Unique(unique bool) *BlobLinkQuery {
	blq.unique = &unique
	return blq
}

// Order adds an order step to the query.
func (blq *BlobLinkQuery) Order(o ...OrderFunc) *BlobLinkQuery {
	blq.order = append(blq.order, o...)
	return blq
}

// QueryBlob chains the current query on the "blob" edge.
func (blq *BlobLinkQuery) QueryBlob() *BlobQuery {
	query := &BlobQuery{config: blq.config}
	query.path = func(ctx context.Context) (fromU *sql.Selector, err error) {
		if err := blq.prepareQuery(ctx); err != nil {
			return nil, err
		}
		selector := blq.sqlQuery(ctx)
		if err := selector.Err(); err != nil {
			return nil, err
		}
		step := sqlgraph.NewStep(
			sqlgraph.From(bloblink.Table, bloblink.BlobColumn, selector),
			sqlgraph.To(blob.Table, blob.FieldID),
			sqlgraph.Edge(sqlgraph.M2O, false, bloblink.BlobTable, bloblink.BlobColumn),
		)
		fromU = sqlgraph.SetNeighbors(blq.driver.Dialect(), step)
		return fromU, nil
	}
	return query
}

// QueryLink chains the current query on the "link" edge.
func (blq *BlobLinkQuery) QueryLink() *BlobQuery {
	query := &BlobQuery{config: blq.config}
	query.path = func(ctx context.Context) (fromU *sql.Selector, err error) {
		if err := blq.prepareQuery(ctx); err != nil {
			return nil, err
		}
		selector := blq.sqlQuery(ctx)
		if err := selector.Err(); err != nil {
			return nil, err
		}
		step := sqlgraph.NewStep(
			sqlgraph.From(bloblink.Table, bloblink.LinkColumn, selector),
			sqlgraph.To(blob.Table, blob.FieldID),
			sqlgraph.Edge(sqlgraph.M2O, false, bloblink.LinkTable, bloblink.LinkColumn),
		)
		fromU = sqlgraph.SetNeighbors(blq.driver.Dialect(), step)
		return fromU, nil
	}
	return query
}

// First returns the first BlobLink entity from the query.
// Returns a *NotFoundError when no BlobLink was found.
func (blq *BlobLinkQuery) First(ctx context.Context) (*BlobLink, error) {
	nodes, err := blq.Limit(1).All(ctx)
	if err != nil {
		return nil, err
	}
	if len(nodes) == 0 {
		return nil, &NotFoundError{bloblink.Label}
	}
	return nodes[0], nil
}

// FirstX is like First, but panics if an error occurs.
func (blq *BlobLinkQuery) FirstX(ctx context.Context) *BlobLink {
	node, err := blq.First(ctx)
	if err != nil && !IsNotFound(err) {
		panic(err)
	}
	return node
}

// Only returns a single BlobLink entity found by the query, ensuring it only returns one.
// Returns a *NotSingularError when more than one BlobLink entity is found.
// Returns a *NotFoundError when no BlobLink entities are found.
func (blq *BlobLinkQuery) Only(ctx context.Context) (*BlobLink, error) {
	nodes, err := blq.Limit(2).All(ctx)
	if err != nil {
		return nil, err
	}
	switch len(nodes) {
	case 1:
		return nodes[0], nil
	case 0:
		return nil, &NotFoundError{bloblink.Label}
	default:
		return nil, &NotSingularError{bloblink.Label}
	}
}

// OnlyX is like Only, but panics if an error occurs.
func (blq *BlobLinkQuery) OnlyX(ctx context.Context) *BlobLink {
	node, err := blq.Only(ctx)
	if err != nil {
		panic(err)
	}
	return node
}

// All executes the query and returns a list of BlobLinks.
func (blq *BlobLinkQuery) All(ctx context.Context) ([]*BlobLink, error) {
	if err := blq.prepareQuery(ctx); err != nil {
		return nil, err
	}
	return blq.sqlAll(ctx)
}

// AllX is like All, but panics if an error occurs.
func (blq *BlobLinkQuery) AllX(ctx context.Context) []*BlobLink {
	nodes, err := blq.All(ctx)
	if err != nil {
		panic(err)
	}
	return nodes
}

// Count returns the count of the given query.
func (blq *BlobLinkQuery) Count(ctx context.Context) (int, error) {
	if err := blq.prepareQuery(ctx); err != nil {
		return 0, err
	}
	return blq.sqlCount(ctx)
}

// CountX is like Count, but panics if an error occurs.
func (blq *BlobLinkQuery) CountX(ctx context.Context) int {
	count, err := blq.Count(ctx)
	if err != nil {
		panic(err)
	}
	return count
}

// Exist returns true if the query has elements in the graph.
func (blq *BlobLinkQuery) Exist(ctx context.Context) (bool, error) {
	if err := blq.prepareQuery(ctx); err != nil {
		return false, err
	}
	return blq.sqlExist(ctx)
}

// ExistX is like Exist, but panics if an error occurs.
func (blq *BlobLinkQuery) ExistX(ctx context.Context) bool {
	exist, err := blq.Exist(ctx)
	if err != nil {
		panic(err)
	}
	return exist
}

// Clone returns a duplicate of the BlobLinkQuery builder, including all associated steps. It can be
// used to prepare common query builders and use them differently after the clone is made.
func (blq *BlobLinkQuery) Clone() *BlobLinkQuery {
	if blq == nil {
		return nil
	}
	return &BlobLinkQuery{
		config:     blq.config,
		limit:      blq.limit,
		offset:     blq.offset,
		order:      append([]OrderFunc{}, blq.order...),
		predicates: append([]predicate.BlobLink{}, blq.predicates...),
		withBlob:   blq.withBlob.Clone(),
		withLink:   blq.withLink.Clone(),
		// clone intermediate query.
		sql:    blq.sql.Clone(),
		path:   blq.path,
		unique: blq.unique,
	}
}

// WithBlob tells the query-builder to eager-load the nodes that are connected to
// the "blob" edge. The optional arguments are used to configure the query builder of the edge.
func (blq *BlobLinkQuery) WithBlob(opts ...func(*BlobQuery)) *BlobLinkQuery {
	query := &BlobQuery{config: blq.config}
	for _, opt := range opts {
		opt(query)
	}
	blq.withBlob = query
	return blq
}

// WithLink tells the query-builder to eager-load the nodes that are connected to
// the "link" edge. The optional arguments are used to configure the query builder of the edge.
func (blq *BlobLinkQuery) WithLink(opts ...func(*BlobQuery)) *BlobLinkQuery {
	query := &BlobQuery{config: blq.config}
	for _, opt := range opts {
		opt(query)
	}
	blq.withLink = query
	return blq
}

// GroupBy is used to group vertices by one or more fields/columns.
// It is often used with aggregate functions, like: count, max, mean, min, sum.
//
// Example:
//
//	var v []struct {
//		CreatedAt time.Time `json:"created_at,omitempty"`
//		Count int `json:"count,omitempty"`
//	}
//
//	client.BlobLink.Query().
//		GroupBy(bloblink.FieldCreatedAt).
//		Aggregate(ent.Count()).
//		Scan(ctx, &v)
func (blq *BlobLinkQuery) GroupBy(field string, fields ...string) *BlobLinkGroupBy {
	grbuild := &BlobLinkGroupBy{config: blq.config}
	grbuild.fields = append([]string{field}, fields...)
	grbuild.path = func(ctx context.Context) (prev *sql.Selector, err error) {
		if err := blq.prepareQuery(ctx); err != nil {
			return nil, err
		}
		return blq.sqlQuery(ctx), nil
	}
	grbuild.label = bloblink.Label
	grbuild.flds, grbuild.scan = &grbuild.fields, grbuild.Scan
	return grbuild
}

// Select allows the selection one or more fields/columns for the given query,
// instead of selecting all fields in the entity.
//
// Example:
//
//	var v []struct {
//		CreatedAt time.Time `json:"created_at,omitempty"`
//	}
//
//	client.BlobLink.Query().
//		Select(bloblink.FieldCreatedAt).
//		Scan(ctx, &v)
func (blq *BlobLinkQuery) Select(fields ...string) *BlobLinkSelect {
	blq.fields = append(blq.fields, fields...)
	selbuild := &BlobLinkSelect{BlobLinkQuery: blq}
	selbuild.label = bloblink.Label
	selbuild.flds, selbuild.scan = &blq.fields, selbuild.Scan
	return selbuild
}

func (blq *BlobLinkQuery) prepareQuery(ctx context.Context) error {
	for _, f := range blq.fields {
		if !bloblink.ValidColumn(f) {
			return &ValidationError{Name: f, err: fmt.Errorf("ent: invalid field %q for query", f)}
		}
	}
	if blq.path != nil {
		prev, err := blq.path(ctx)
		if err != nil {
			return err
		}
		blq.sql = prev
	}
	return nil
}

func (blq *BlobLinkQuery) sqlAll(ctx context.Context, hooks ...queryHook) ([]*BlobLink, error) {
	var (
		nodes       = []*BlobLink{}
		_spec       = blq.querySpec()
		loadedTypes = [2]bool{
			blq.withBlob != nil,
			blq.withLink != nil,
		}
	)
	_spec.ScanValues = func(columns []string) ([]any, error) {
		return (*BlobLink).scanValues(nil, columns)
	}
	_spec.Assign = func(columns []string, values []any) error {
		node := &BlobLink{config: blq.config}
		nodes = append(nodes, node)
		node.Edges.loadedTypes = loadedTypes
		return node.assignValues(columns, values)
	}
	for i := range hooks {
		hooks[i](ctx, _spec)
	}
	if err := sqlgraph.QueryNodes(ctx, blq.driver, _spec); err != nil {
		return nil, err
	}
	if len(nodes) == 0 {
		return nodes, nil
	}
	if query := blq.withBlob; query != nil {
		if err := blq.loadBlob(ctx, query, nodes, nil,
			func(n *BlobLink, e *Blob) { n.Edges.Blob = e }); err != nil {
			return nil, err
		}
	}
	if query := blq.withLink; query != nil {
		if err := blq.loadLink(ctx, query, nodes, nil,
			func(n *BlobLink, e *Blob) { n.Edges.Link = e }); err != nil {
			return nil, err
		}
	}
	return nodes, nil
}

func (blq *BlobLinkQuery) loadBlob(ctx context.Context, query *BlobQuery, nodes []*BlobLink, init func(*BlobLink), assign func(*BlobLink, *Blob)) error {
	ids := make([]uuid.UUID, 0, len(nodes))
	nodeids := make(map[uuid.UUID][]*BlobLink)
	for i := range nodes {
		fk := nodes[i].BlobID
		if _, ok := nodeids[fk]; !ok {
			ids = append(ids, fk)
		}
		nodeids[fk] = append(nodeids[fk], nodes[i])
	}
	query.Where(blob.IDIn(ids...))
	neighbors, err := query.All(ctx)
	if err != nil {
		return err
	}
	for _, n := range neighbors {
		nodes, ok := nodeids[n.ID]
		if !ok {
			return fmt.Errorf(`unexpected foreign-key "blob_id" returned %v`, n.ID)
		}
		for i := range nodes {
			assign(nodes[i], n)
		}
	}
	return nil
}
func (blq *BlobLinkQuery) loadLink(ctx context.Context, query *BlobQuery, nodes []*BlobLink, init func(*BlobLink), assign func(*BlobLink, *Blob)) error {
	ids := make([]uuid.UUID, 0, len(nodes))
	nodeids := make(map[uuid.UUID][]*BlobLink)
	for i := range nodes {
		fk := nodes[i].LinkID
		if _, ok := nodeids[fk]; !ok {
			ids = append(ids, fk)
		}
		nodeids[fk] = append(nodeids[fk], nodes[i])
	}
	query.Where(blob.IDIn(ids...))
	neighbors, err := query.All(ctx)
	if err != nil {
		return err
	}
	for _, n := range neighbors {
		nodes, ok := nodeids[n.ID]
		if !ok {
			return fmt.Errorf(`unexpected foreign-key "link_id" returned %v`, n.ID)
		}
		for i := range nodes {
			assign(nodes[i], n)
		}
	}
	return nil
}

func (blq *BlobLinkQuery) sqlCount(ctx context.Context) (int, error) {
	_spec := blq.querySpec()
	_spec.Unique = false
	_spec.Node.Columns = nil
	return sqlgraph.CountNodes(ctx, blq.driver, _spec)
}

func (blq *BlobLinkQuery) sqlExist(ctx context.Context) (bool, error) {
	switch _, err := blq.First(ctx); {
	case IsNotFound(err):
		return false, nil
	case err != nil:
		return false, fmt.Errorf("ent: check existence: %w", err)
	default:
		return true, nil
	}
}

func (blq *BlobLinkQuery) querySpec() *sqlgraph.QuerySpec {
	_spec := &sqlgraph.QuerySpec{
		Node: &sqlgraph.NodeSpec{
			Table:   bloblink.Table,
			Columns: bloblink.Columns,
		},
		From:   blq.sql,
		Unique: true,
	}
	if unique := blq.unique; unique != nil {
		_spec.Unique = *unique
	}
	if fields := blq.fields; len(fields) > 0 {
		_spec.Node.Columns = make([]string, 0, len(fields))
		for i := range fields {
			_spec.Node.Columns = append(_spec.Node.Columns, fields[i])
		}
	}
	if ps := blq.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if limit := blq.limit; limit != nil {
		_spec.Limit = *limit
	}
	if offset := blq.offset; offset != nil {
		_spec.Offset = *offset
	}
	if ps := blq.order; len(ps) > 0 {
		_spec.Order = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	return _spec
}

func (blq *BlobLinkQuery) sqlQuery(ctx context.Context) *sql.Selector {
	builder := sql.Dialect(blq.driver.Dialect())
	t1 := builder.Table(bloblink.Table)
	columns := blq.fields
	if len(columns) == 0 {
		columns = bloblink.Columns
	}
	selector := builder.Select(t1.Columns(columns...)...).From(t1)
	if blq.sql != nil {
		selector = blq.sql
		selector.Select(selector.Columns(columns...)...)
	}
	if blq.unique != nil && *blq.unique {
		selector.Distinct()
	}
	for _, p := range blq.predicates {
		p(selector)
	}
	for _, p := range blq.order {
		p(selector)
	}
	if offset := blq.offset; offset != nil {
		// limit is mandatory for offset clause. We start
		// with default value, and override it below if needed.
		selector.Offset(*offset).Limit(math.MaxInt32)
	}
	if limit := blq.limit; limit != nil {
		selector.Limit(*limit)
	}
	return selector
}

// BlobLinkGroupBy is the group-by builder for BlobLink entities.
type BlobLinkGroupBy struct {
	config
	selector
	fields []string
	fns    []AggregateFunc
	// intermediate query (i.e. traversal path).
	sql  *sql.Selector
	path func(context.Context) (*sql.Selector, error)
}

// Aggregate adds the given aggregation functions to the group-by query.
func (blgb *BlobLinkGroupBy) Aggregate(fns ...AggregateFunc) *BlobLinkGroupBy {
	blgb.fns = append(blgb.fns, fns...)
	return blgb
}

// Scan applies the group-by query and scans the result into the given value.
func (blgb *BlobLinkGroupBy) Scan(ctx context.Context, v any) error {
	query, err := blgb.path(ctx)
	if err != nil {
		return err
	}
	blgb.sql = query
	return blgb.sqlScan(ctx, v)
}

func (blgb *BlobLinkGroupBy) sqlScan(ctx context.Context, v any) error {
	for _, f := range blgb.fields {
		if !bloblink.ValidColumn(f) {
			return &ValidationError{Name: f, err: fmt.Errorf("invalid field %q for group-by", f)}
		}
	}
	selector := blgb.sqlQuery()
	if err := selector.Err(); err != nil {
		return err
	}
	rows := &sql.Rows{}
	query, args := selector.Query()
	if err := blgb.driver.Query(ctx, query, args, rows); err != nil {
		return err
	}
	defer rows.Close()
	return sql.ScanSlice(rows, v)
}

func (blgb *BlobLinkGroupBy) sqlQuery() *sql.Selector {
	selector := blgb.sql.Select()
	aggregation := make([]string, 0, len(blgb.fns))
	for _, fn := range blgb.fns {
		aggregation = append(aggregation, fn(selector))
	}
	// If no columns were selected in a custom aggregation function, the default
	// selection is the fields used for "group-by", and the aggregation functions.
	if len(selector.SelectedColumns()) == 0 {
		columns := make([]string, 0, len(blgb.fields)+len(blgb.fns))
		for _, f := range blgb.fields {
			columns = append(columns, selector.C(f))
		}
		columns = append(columns, aggregation...)
		selector.Select(columns...)
	}
	return selector.GroupBy(selector.Columns(blgb.fields...)...)
}

// BlobLinkSelect is the builder for selecting fields of BlobLink entities.
type BlobLinkSelect struct {
	*BlobLinkQuery
	selector
	// intermediate query (i.e. traversal path).
	sql *sql.Selector
}

// Scan applies the selector query and scans the result into the given value.
func (bls *BlobLinkSelect) Scan(ctx context.Context, v any) error {
	if err := bls.prepareQuery(ctx); err != nil {
		return err
	}
	bls.sql = bls.BlobLinkQuery.sqlQuery(ctx)
	return bls.sqlScan(ctx, v)
}

func (bls *BlobLinkSelect) sqlScan(ctx context.Context, v any) error {
	rows := &sql.Rows{}
	query, args := bls.sql.Query()
	if err := bls.driver.Query(ctx, query, args, rows); err != nil {
		return err
	}
	defer rows.Close()
	return sql.ScanSlice(rows, v)
}
