// Code generated by smithy-go-codegen DO NOT EDIT.

package drs

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/drs/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns an array of staging accounts for existing extended source servers.
func (c *Client) ListStagingAccounts(ctx context.Context, params *ListStagingAccountsInput, optFns ...func(*Options)) (*ListStagingAccountsOutput, error) {
	if params == nil {
		params = &ListStagingAccountsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListStagingAccounts", params, optFns, c.addOperationListStagingAccountsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListStagingAccountsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListStagingAccountsInput struct {

	// The maximum number of staging Accounts to retrieve.
	MaxResults *int32

	// The token of the next staging Account to retrieve.
	NextToken *string

	noSmithyDocumentSerde
}

type ListStagingAccountsOutput struct {

	// An array of staging AWS Accounts.
	Accounts []types.Account

	// The token of the next staging Account to retrieve.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListStagingAccountsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListStagingAccounts{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListStagingAccounts{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListStagingAccounts"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListStagingAccounts(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListStagingAccountsAPIClient is a client that implements the
// ListStagingAccounts operation.
type ListStagingAccountsAPIClient interface {
	ListStagingAccounts(context.Context, *ListStagingAccountsInput, ...func(*Options)) (*ListStagingAccountsOutput, error)
}

var _ ListStagingAccountsAPIClient = (*Client)(nil)

// ListStagingAccountsPaginatorOptions is the paginator options for
// ListStagingAccounts
type ListStagingAccountsPaginatorOptions struct {
	// The maximum number of staging Accounts to retrieve.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListStagingAccountsPaginator is a paginator for ListStagingAccounts
type ListStagingAccountsPaginator struct {
	options   ListStagingAccountsPaginatorOptions
	client    ListStagingAccountsAPIClient
	params    *ListStagingAccountsInput
	nextToken *string
	firstPage bool
}

// NewListStagingAccountsPaginator returns a new ListStagingAccountsPaginator
func NewListStagingAccountsPaginator(client ListStagingAccountsAPIClient, params *ListStagingAccountsInput, optFns ...func(*ListStagingAccountsPaginatorOptions)) *ListStagingAccountsPaginator {
	if params == nil {
		params = &ListStagingAccountsInput{}
	}

	options := ListStagingAccountsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListStagingAccountsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListStagingAccountsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListStagingAccounts page.
func (p *ListStagingAccountsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListStagingAccountsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListStagingAccounts(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListStagingAccounts(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListStagingAccounts",
	}
}
