//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armlogz

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// SubAccountClient contains the methods for the SubAccount group.
// Don't use this type directly, use NewSubAccountClient() instead.
type SubAccountClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewSubAccountClient creates a new instance of SubAccountClient with the specified values.
// subscriptionID - The ID of the target subscription.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewSubAccountClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*SubAccountClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &SubAccountClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// BeginCreate - Create sub account under a given monitor resource. This create operation can take upto 10 minutes to complete.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-10-01
// resourceGroupName - The name of the resource group. The name is case insensitive.
// monitorName - Monitor resource name
// subAccountName - Sub Account resource name
// options - SubAccountClientBeginCreateOptions contains the optional parameters for the SubAccountClient.BeginCreate method.
func (client *SubAccountClient) BeginCreate(ctx context.Context, resourceGroupName string, monitorName string, subAccountName string, options *SubAccountClientBeginCreateOptions) (*runtime.Poller[SubAccountClientCreateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.create(ctx, resourceGroupName, monitorName, subAccountName, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller(resp, client.pl, &runtime.NewPollerOptions[SubAccountClientCreateResponse]{
			FinalStateVia: runtime.FinalStateViaAzureAsyncOp,
		})
	} else {
		return runtime.NewPollerFromResumeToken[SubAccountClientCreateResponse](options.ResumeToken, client.pl, nil)
	}
}

// Create - Create sub account under a given monitor resource. This create operation can take upto 10 minutes to complete.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-10-01
func (client *SubAccountClient) create(ctx context.Context, resourceGroupName string, monitorName string, subAccountName string, options *SubAccountClientBeginCreateOptions) (*http.Response, error) {
	req, err := client.createCreateRequest(ctx, resourceGroupName, monitorName, subAccountName, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusCreated) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// createCreateRequest creates the Create request.
func (client *SubAccountClient) createCreateRequest(ctx context.Context, resourceGroupName string, monitorName string, subAccountName string, options *SubAccountClientBeginCreateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logz/monitors/{monitorName}/accounts/{subAccountName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if monitorName == "" {
		return nil, errors.New("parameter monitorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{monitorName}", url.PathEscape(monitorName))
	if subAccountName == "" {
		return nil, errors.New("parameter subAccountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subAccountName}", url.PathEscape(subAccountName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if options != nil && options.Body != nil {
		return req, runtime.MarshalAsJSON(req, *options.Body)
	}
	return req, nil
}

// BeginDelete - Delete a sub account resource. This delete operation can take upto 10 minutes to complete.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-10-01
// resourceGroupName - The name of the resource group. The name is case insensitive.
// monitorName - Monitor resource name
// subAccountName - Sub Account resource name
// options - SubAccountClientBeginDeleteOptions contains the optional parameters for the SubAccountClient.BeginDelete method.
func (client *SubAccountClient) BeginDelete(ctx context.Context, resourceGroupName string, monitorName string, subAccountName string, options *SubAccountClientBeginDeleteOptions) (*runtime.Poller[SubAccountClientDeleteResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deleteOperation(ctx, resourceGroupName, monitorName, subAccountName, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller(resp, client.pl, &runtime.NewPollerOptions[SubAccountClientDeleteResponse]{
			FinalStateVia: runtime.FinalStateViaLocation,
		})
	} else {
		return runtime.NewPollerFromResumeToken[SubAccountClientDeleteResponse](options.ResumeToken, client.pl, nil)
	}
}

// Delete - Delete a sub account resource. This delete operation can take upto 10 minutes to complete.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-10-01
func (client *SubAccountClient) deleteOperation(ctx context.Context, resourceGroupName string, monitorName string, subAccountName string, options *SubAccountClientBeginDeleteOptions) (*http.Response, error) {
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, monitorName, subAccountName, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted, http.StatusNoContent) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// deleteCreateRequest creates the Delete request.
func (client *SubAccountClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, monitorName string, subAccountName string, options *SubAccountClientBeginDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logz/monitors/{monitorName}/accounts/{subAccountName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if monitorName == "" {
		return nil, errors.New("parameter monitorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{monitorName}", url.PathEscape(monitorName))
	if subAccountName == "" {
		return nil, errors.New("parameter subAccountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subAccountName}", url.PathEscape(subAccountName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Get - Get a sub account under a given monitor resource.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-10-01
// resourceGroupName - The name of the resource group. The name is case insensitive.
// monitorName - Monitor resource name
// subAccountName - Sub Account resource name
// options - SubAccountClientGetOptions contains the optional parameters for the SubAccountClient.Get method.
func (client *SubAccountClient) Get(ctx context.Context, resourceGroupName string, monitorName string, subAccountName string, options *SubAccountClientGetOptions) (SubAccountClientGetResponse, error) {
	req, err := client.getCreateRequest(ctx, resourceGroupName, monitorName, subAccountName, options)
	if err != nil {
		return SubAccountClientGetResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return SubAccountClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return SubAccountClientGetResponse{}, runtime.NewResponseError(resp)
	}
	return client.getHandleResponse(resp)
}

// getCreateRequest creates the Get request.
func (client *SubAccountClient) getCreateRequest(ctx context.Context, resourceGroupName string, monitorName string, subAccountName string, options *SubAccountClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logz/monitors/{monitorName}/accounts/{subAccountName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if monitorName == "" {
		return nil, errors.New("parameter monitorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{monitorName}", url.PathEscape(monitorName))
	if subAccountName == "" {
		return nil, errors.New("parameter subAccountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subAccountName}", url.PathEscape(subAccountName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *SubAccountClient) getHandleResponse(resp *http.Response) (SubAccountClientGetResponse, error) {
	result := SubAccountClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.MonitorResource); err != nil {
		return SubAccountClientGetResponse{}, err
	}
	return result, nil
}

// NewListPager - List the sub account under a given monitor resource.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-10-01
// resourceGroupName - The name of the resource group. The name is case insensitive.
// monitorName - Monitor resource name
// options - SubAccountClientListOptions contains the optional parameters for the SubAccountClient.List method.
func (client *SubAccountClient) NewListPager(resourceGroupName string, monitorName string, options *SubAccountClientListOptions) *runtime.Pager[SubAccountClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[SubAccountClientListResponse]{
		More: func(page SubAccountClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *SubAccountClientListResponse) (SubAccountClientListResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listCreateRequest(ctx, resourceGroupName, monitorName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return SubAccountClientListResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return SubAccountClientListResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return SubAccountClientListResponse{}, runtime.NewResponseError(resp)
			}
			return client.listHandleResponse(resp)
		},
	})
}

// listCreateRequest creates the List request.
func (client *SubAccountClient) listCreateRequest(ctx context.Context, resourceGroupName string, monitorName string, options *SubAccountClientListOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logz/monitors/{monitorName}/accounts"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if monitorName == "" {
		return nil, errors.New("parameter monitorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{monitorName}", url.PathEscape(monitorName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *SubAccountClient) listHandleResponse(resp *http.Response) (SubAccountClientListResponse, error) {
	result := SubAccountClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.MonitorResourceListResponse); err != nil {
		return SubAccountClientListResponse{}, err
	}
	return result, nil
}

// NewListMonitoredResourcesPager - List the resources currently being monitored by the Logz sub account resource.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-10-01
// resourceGroupName - The name of the resource group. The name is case insensitive.
// monitorName - Monitor resource name
// subAccountName - Sub Account resource name
// options - SubAccountClientListMonitoredResourcesOptions contains the optional parameters for the SubAccountClient.ListMonitoredResources
// method.
func (client *SubAccountClient) NewListMonitoredResourcesPager(resourceGroupName string, monitorName string, subAccountName string, options *SubAccountClientListMonitoredResourcesOptions) *runtime.Pager[SubAccountClientListMonitoredResourcesResponse] {
	return runtime.NewPager(runtime.PagingHandler[SubAccountClientListMonitoredResourcesResponse]{
		More: func(page SubAccountClientListMonitoredResourcesResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *SubAccountClientListMonitoredResourcesResponse) (SubAccountClientListMonitoredResourcesResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listMonitoredResourcesCreateRequest(ctx, resourceGroupName, monitorName, subAccountName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return SubAccountClientListMonitoredResourcesResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return SubAccountClientListMonitoredResourcesResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return SubAccountClientListMonitoredResourcesResponse{}, runtime.NewResponseError(resp)
			}
			return client.listMonitoredResourcesHandleResponse(resp)
		},
	})
}

// listMonitoredResourcesCreateRequest creates the ListMonitoredResources request.
func (client *SubAccountClient) listMonitoredResourcesCreateRequest(ctx context.Context, resourceGroupName string, monitorName string, subAccountName string, options *SubAccountClientListMonitoredResourcesOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logz/monitors/{monitorName}/accounts/{subAccountName}/listMonitoredResources"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if monitorName == "" {
		return nil, errors.New("parameter monitorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{monitorName}", url.PathEscape(monitorName))
	if subAccountName == "" {
		return nil, errors.New("parameter subAccountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subAccountName}", url.PathEscape(subAccountName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listMonitoredResourcesHandleResponse handles the ListMonitoredResources response.
func (client *SubAccountClient) listMonitoredResourcesHandleResponse(resp *http.Response) (SubAccountClientListMonitoredResourcesResponse, error) {
	result := SubAccountClientListMonitoredResourcesResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.MonitoredResourceListResponse); err != nil {
		return SubAccountClientListMonitoredResourcesResponse{}, err
	}
	return result, nil
}

// NewListVMHostUpdatePager - Sending request to update the collection when Logz.io agent has been installed on a VM for a
// given monitor.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-10-01
// resourceGroupName - The name of the resource group. The name is case insensitive.
// monitorName - Monitor resource name
// subAccountName - Sub Account resource name
// options - SubAccountClientListVMHostUpdateOptions contains the optional parameters for the SubAccountClient.ListVMHostUpdate
// method.
func (client *SubAccountClient) NewListVMHostUpdatePager(resourceGroupName string, monitorName string, subAccountName string, options *SubAccountClientListVMHostUpdateOptions) *runtime.Pager[SubAccountClientListVMHostUpdateResponse] {
	return runtime.NewPager(runtime.PagingHandler[SubAccountClientListVMHostUpdateResponse]{
		More: func(page SubAccountClientListVMHostUpdateResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *SubAccountClientListVMHostUpdateResponse) (SubAccountClientListVMHostUpdateResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listVMHostUpdateCreateRequest(ctx, resourceGroupName, monitorName, subAccountName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return SubAccountClientListVMHostUpdateResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return SubAccountClientListVMHostUpdateResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return SubAccountClientListVMHostUpdateResponse{}, runtime.NewResponseError(resp)
			}
			return client.listVMHostUpdateHandleResponse(resp)
		},
	})
}

// listVMHostUpdateCreateRequest creates the ListVMHostUpdate request.
func (client *SubAccountClient) listVMHostUpdateCreateRequest(ctx context.Context, resourceGroupName string, monitorName string, subAccountName string, options *SubAccountClientListVMHostUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logz/monitors/{monitorName}/accounts/{subAccountName}/vmHostUpdate"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if monitorName == "" {
		return nil, errors.New("parameter monitorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{monitorName}", url.PathEscape(monitorName))
	if subAccountName == "" {
		return nil, errors.New("parameter subAccountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subAccountName}", url.PathEscape(subAccountName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if options != nil && options.Body != nil {
		return req, runtime.MarshalAsJSON(req, *options.Body)
	}
	return req, nil
}

// listVMHostUpdateHandleResponse handles the ListVMHostUpdate response.
func (client *SubAccountClient) listVMHostUpdateHandleResponse(resp *http.Response) (SubAccountClientListVMHostUpdateResponse, error) {
	result := SubAccountClientListVMHostUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.VMResourcesListResponse); err != nil {
		return SubAccountClientListVMHostUpdateResponse{}, err
	}
	return result, nil
}

// NewListVMHostsPager - List the compute resources currently being monitored by the Logz sub account resource.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-10-01
// resourceGroupName - The name of the resource group. The name is case insensitive.
// monitorName - Monitor resource name
// subAccountName - Sub Account resource name
// options - SubAccountClientListVMHostsOptions contains the optional parameters for the SubAccountClient.ListVMHosts method.
func (client *SubAccountClient) NewListVMHostsPager(resourceGroupName string, monitorName string, subAccountName string, options *SubAccountClientListVMHostsOptions) *runtime.Pager[SubAccountClientListVMHostsResponse] {
	return runtime.NewPager(runtime.PagingHandler[SubAccountClientListVMHostsResponse]{
		More: func(page SubAccountClientListVMHostsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *SubAccountClientListVMHostsResponse) (SubAccountClientListVMHostsResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listVMHostsCreateRequest(ctx, resourceGroupName, monitorName, subAccountName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return SubAccountClientListVMHostsResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return SubAccountClientListVMHostsResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return SubAccountClientListVMHostsResponse{}, runtime.NewResponseError(resp)
			}
			return client.listVMHostsHandleResponse(resp)
		},
	})
}

// listVMHostsCreateRequest creates the ListVMHosts request.
func (client *SubAccountClient) listVMHostsCreateRequest(ctx context.Context, resourceGroupName string, monitorName string, subAccountName string, options *SubAccountClientListVMHostsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logz/monitors/{monitorName}/accounts/{subAccountName}/listVMHosts"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if monitorName == "" {
		return nil, errors.New("parameter monitorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{monitorName}", url.PathEscape(monitorName))
	if subAccountName == "" {
		return nil, errors.New("parameter subAccountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subAccountName}", url.PathEscape(subAccountName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listVMHostsHandleResponse handles the ListVMHosts response.
func (client *SubAccountClient) listVMHostsHandleResponse(resp *http.Response) (SubAccountClientListVMHostsResponse, error) {
	result := SubAccountClientListVMHostsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.VMResourcesListResponse); err != nil {
		return SubAccountClientListVMHostsResponse{}, err
	}
	return result, nil
}

// Update - Update a monitor resource.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-10-01
// resourceGroupName - The name of the resource group. The name is case insensitive.
// monitorName - Monitor resource name
// subAccountName - Sub Account resource name
// options - SubAccountClientUpdateOptions contains the optional parameters for the SubAccountClient.Update method.
func (client *SubAccountClient) Update(ctx context.Context, resourceGroupName string, monitorName string, subAccountName string, options *SubAccountClientUpdateOptions) (SubAccountClientUpdateResponse, error) {
	req, err := client.updateCreateRequest(ctx, resourceGroupName, monitorName, subAccountName, options)
	if err != nil {
		return SubAccountClientUpdateResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return SubAccountClientUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return SubAccountClientUpdateResponse{}, runtime.NewResponseError(resp)
	}
	return client.updateHandleResponse(resp)
}

// updateCreateRequest creates the Update request.
func (client *SubAccountClient) updateCreateRequest(ctx context.Context, resourceGroupName string, monitorName string, subAccountName string, options *SubAccountClientUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logz/monitors/{monitorName}/accounts/{subAccountName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if monitorName == "" {
		return nil, errors.New("parameter monitorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{monitorName}", url.PathEscape(monitorName))
	if subAccountName == "" {
		return nil, errors.New("parameter subAccountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subAccountName}", url.PathEscape(subAccountName))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if options != nil && options.Body != nil {
		return req, runtime.MarshalAsJSON(req, *options.Body)
	}
	return req, nil
}

// updateHandleResponse handles the Update response.
func (client *SubAccountClient) updateHandleResponse(resp *http.Response) (SubAccountClientUpdateResponse, error) {
	result := SubAccountClientUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.MonitorResource); err != nil {
		return SubAccountClientUpdateResponse{}, err
	}
	return result, nil
}

// VMHostPayload - Returns the payload that needs to be passed as a request for installing Logz.io agent on a VM.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-10-01
// resourceGroupName - The name of the resource group. The name is case insensitive.
// monitorName - Monitor resource name
// subAccountName - Sub Account resource name
// options - SubAccountClientVMHostPayloadOptions contains the optional parameters for the SubAccountClient.VMHostPayload
// method.
func (client *SubAccountClient) VMHostPayload(ctx context.Context, resourceGroupName string, monitorName string, subAccountName string, options *SubAccountClientVMHostPayloadOptions) (SubAccountClientVMHostPayloadResponse, error) {
	req, err := client.vmHostPayloadCreateRequest(ctx, resourceGroupName, monitorName, subAccountName, options)
	if err != nil {
		return SubAccountClientVMHostPayloadResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return SubAccountClientVMHostPayloadResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return SubAccountClientVMHostPayloadResponse{}, runtime.NewResponseError(resp)
	}
	return client.vmHostPayloadHandleResponse(resp)
}

// vmHostPayloadCreateRequest creates the VMHostPayload request.
func (client *SubAccountClient) vmHostPayloadCreateRequest(ctx context.Context, resourceGroupName string, monitorName string, subAccountName string, options *SubAccountClientVMHostPayloadOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logz/monitors/{monitorName}/accounts/{subAccountName}/vmHostPayload"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if monitorName == "" {
		return nil, errors.New("parameter monitorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{monitorName}", url.PathEscape(monitorName))
	if subAccountName == "" {
		return nil, errors.New("parameter subAccountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subAccountName}", url.PathEscape(subAccountName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// vmHostPayloadHandleResponse handles the VMHostPayload response.
func (client *SubAccountClient) vmHostPayloadHandleResponse(resp *http.Response) (SubAccountClientVMHostPayloadResponse, error) {
	result := SubAccountClientVMHostPayloadResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.VMExtensionPayload); err != nil {
		return SubAccountClientVMHostPayloadResponse{}, err
	}
	return result, nil
}
