//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armfrontdoor

import "time"

// AzureAsyncOperationResult - The response body contains the status of the specified asynchronous operation, indicating whether
// it has succeeded, is in progress, or has failed. Note that this status is distinct from the HTTP
// status code returned for the Get Operation Status operation itself. If the asynchronous operation succeeded, the response
// body includes the HTTP status code for the successful request. If the
// asynchronous operation failed, the response body includes the HTTP status code for the failed request and error information
// regarding the failure.
type AzureAsyncOperationResult struct {
	Error *Error `json:"error,omitempty"`

	// Status of the Azure async operation.
	Status *NetworkOperationStatus `json:"status,omitempty"`
}

// Backend address of a frontDoor load balancer.
type Backend struct {
	// Location of the backend (IP address or FQDN)
	Address *string `json:"address,omitempty"`

	// The value to use as the host header sent to the backend. If blank or unspecified, this defaults to the incoming host.
	BackendHostHeader *string `json:"backendHostHeader,omitempty"`

	// Whether to enable use of this backend. Permitted values are 'Enabled' or 'Disabled'
	EnabledState *BackendEnabledState `json:"enabledState,omitempty"`

	// The HTTP TCP port number. Must be between 1 and 65535.
	HTTPPort *int32 `json:"httpPort,omitempty"`

	// The HTTPS TCP port number. Must be between 1 and 65535.
	HTTPSPort *int32 `json:"httpsPort,omitempty"`

	// Priority to use for load balancing. Higher priorities will not be used for load balancing if any lower priority backend
	// is healthy.
	Priority *int32 `json:"priority,omitempty"`

	// The Alias of the Private Link resource. Populating this optional field indicates that this backend is 'Private'
	PrivateLinkAlias *string `json:"privateLinkAlias,omitempty"`

	// A custom message to be included in the approval request to connect to the Private Link
	PrivateLinkApprovalMessage *string `json:"privateLinkApprovalMessage,omitempty"`

	// The location of the Private Link resource. Required only if 'privateLinkResourceId' is populated
	PrivateLinkLocation *string `json:"privateLinkLocation,omitempty"`

	// The Resource Id of the Private Link resource. Populating this optional field indicates that this backend is 'Private'
	PrivateLinkResourceID *string `json:"privateLinkResourceId,omitempty"`

	// Weight of this endpoint for load balancing purposes.
	Weight *int32 `json:"weight,omitempty"`

	// READ-ONLY; The Approval status for the connection to the Private Link
	PrivateEndpointStatus *PrivateEndpointStatus `json:"privateEndpointStatus,omitempty" azure:"ro"`
}

// BackendPool - A backend pool is a collection of backends that can be routed to.
type BackendPool struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Resource name.
	Name *string `json:"name,omitempty"`

	// Properties of the Front Door Backend Pool
	Properties *BackendPoolProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// BackendPoolListResult - Result of the request to list Backend Pools. It contains a list of Backend Pools objects and a
// URL link to get the next set of results.
type BackendPoolListResult struct {
	// URL to get the next set of BackendPool objects if there are any.
	NextLink *string `json:"nextLink,omitempty"`

	// READ-ONLY; List of Backend Pools within a Front Door.
	Value []*BackendPool `json:"value,omitempty" azure:"ro"`
}

// BackendPoolProperties - The JSON object that contains the properties required to create a Backend Pool.
type BackendPoolProperties struct {
	// The set of backends for this pool
	Backends []*Backend `json:"backends,omitempty"`

	// L7 health probe settings for a backend pool
	HealthProbeSettings *SubResource `json:"healthProbeSettings,omitempty"`

	// Load balancing settings for a backend pool
	LoadBalancingSettings *SubResource `json:"loadBalancingSettings,omitempty"`

	// READ-ONLY; Resource status.
	ResourceState *FrontDoorResourceState `json:"resourceState,omitempty" azure:"ro"`
}

// BackendPoolUpdateParameters - A collection of backends that can be routed to.
type BackendPoolUpdateParameters struct {
	// The set of backends for this pool
	Backends []*Backend `json:"backends,omitempty"`

	// L7 health probe settings for a backend pool
	HealthProbeSettings *SubResource `json:"healthProbeSettings,omitempty"`

	// Load balancing settings for a backend pool
	LoadBalancingSettings *SubResource `json:"loadBalancingSettings,omitempty"`
}

// BackendPoolsSettings - Settings that apply to all backend pools.
type BackendPoolsSettings struct {
	// Whether to enforce certificate name check on HTTPS requests to all backend pools. No effect on non-HTTPS requests.
	EnforceCertificateNameCheck *EnforceCertificateNameCheckEnabledState `json:"enforceCertificateNameCheck,omitempty"`

	// Send and receive timeout on forwarding request to the backend. When timeout is reached, the request fails and returns.
	SendRecvTimeoutSeconds *int32 `json:"sendRecvTimeoutSeconds,omitempty"`
}

// CacheConfiguration - Caching settings for a caching-type route. To disable caching, do not provide a cacheConfiguration
// object.
type CacheConfiguration struct {
	// The duration for which the content needs to be cached. Allowed format is in ISO 8601 format (http://en.wikipedia.org/wiki/ISO_8601#Durations).
	// HTTP requires the value to be no more than a year
	CacheDuration *string `json:"cacheDuration,omitempty"`

	// Whether to use dynamic compression for cached content
	DynamicCompression *DynamicCompressionEnabled `json:"dynamicCompression,omitempty"`

	// Treatment of URL query terms when forming the cache key.
	QueryParameterStripDirective *FrontDoorQuery `json:"queryParameterStripDirective,omitempty"`

	// query parameters to include or exclude (comma separated).
	QueryParameters *string `json:"queryParameters,omitempty"`
}

// CertificateSourceParameters - Parameters required for enabling SSL with Front Door-managed certificates
type CertificateSourceParameters struct {
	// Defines the type of the certificate used for secure connections to a frontendEndpoint
	CertificateType *FrontDoorCertificateType `json:"certificateType,omitempty"`
}

// CheckNameAvailabilityInput - Input of CheckNameAvailability API.
type CheckNameAvailabilityInput struct {
	// REQUIRED; The resource name to validate.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The type of the resource whose name is to be validated.
	Type *ResourceType `json:"type,omitempty"`
}

// CheckNameAvailabilityOutput - Output of check name availability API.
type CheckNameAvailabilityOutput struct {
	// READ-ONLY; The detailed error message describing why the name is not available.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; Indicates whether the name is available.
	NameAvailability *Availability `json:"nameAvailability,omitempty" azure:"ro"`

	// READ-ONLY; The reason why the name is not available.
	Reason *string `json:"reason,omitempty" azure:"ro"`
}

// CustomHTTPSConfiguration - Https settings for a domain
type CustomHTTPSConfiguration struct {
	// REQUIRED; Defines the source of the SSL certificate
	CertificateSource *FrontDoorCertificateSource `json:"certificateSource,omitempty"`

	// REQUIRED; The minimum TLS version required from the clients to establish an SSL handshake with Front Door.
	MinimumTLSVersion *MinimumTLSVersion `json:"minimumTlsVersion,omitempty"`

	// REQUIRED; Defines the TLS extension protocol that is used for secure delivery
	ProtocolType *FrontDoorTLSProtocolType `json:"protocolType,omitempty"`

	// Parameters required for enabling SSL with Front Door-managed certificates (if certificateSource=FrontDoor)
	FrontDoorCertificateSourceParameters *CertificateSourceParameters `json:"frontDoorCertificateSourceParameters,omitempty"`

	// KeyVault certificate source parameters (if certificateSource=AzureKeyVault)
	KeyVaultCertificateSourceParameters *KeyVaultCertificateSourceParameters `json:"keyVaultCertificateSourceParameters,omitempty"`
}

// CustomRule - Defines contents of a web application rule
type CustomRule struct {
	// REQUIRED; Describes what action to be applied when rule matches.
	Action *ActionType `json:"action,omitempty"`

	// REQUIRED; List of match conditions.
	MatchConditions []*MatchCondition `json:"matchConditions,omitempty"`

	// REQUIRED; Describes priority of the rule. Rules with a lower value will be evaluated before rules with a higher value.
	Priority *int32 `json:"priority,omitempty"`

	// REQUIRED; Describes type of rule.
	RuleType *RuleType `json:"ruleType,omitempty"`

	// Describes if the custom rule is in enabled or disabled state. Defaults to Enabled if not specified.
	EnabledState *CustomRuleEnabledState `json:"enabledState,omitempty"`

	// Describes the name of the rule.
	Name *string `json:"name,omitempty"`

	// Time window for resetting the rate limit count. Default is 1 minute.
	RateLimitDurationInMinutes *int32 `json:"rateLimitDurationInMinutes,omitempty"`

	// Number of allowed requests per client within the time window.
	RateLimitThreshold *int32 `json:"rateLimitThreshold,omitempty"`
}

// CustomRuleList - Defines contents of custom rules
type CustomRuleList struct {
	// List of rules
	Rules []*CustomRule `json:"rules,omitempty"`
}

// Endpoint - Defines the endpoint properties
type Endpoint struct {
	// The endpoint URL
	Endpoint *string `json:"endpoint,omitempty"`

	// The name of the endpoint
	Name *string `json:"name,omitempty"`
}

// EndpointsClientBeginPurgeContentOptions contains the optional parameters for the EndpointsClient.BeginPurgeContent method.
type EndpointsClientBeginPurgeContentOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

type Error struct {
	Code       *string         `json:"code,omitempty"`
	Details    []*ErrorDetails `json:"details,omitempty"`
	InnerError *string         `json:"innerError,omitempty"`
	Message    *string         `json:"message,omitempty"`
	Target     *string         `json:"target,omitempty"`
}

type ErrorDetails struct {
	Code    *string `json:"code,omitempty"`
	Message *string `json:"message,omitempty"`
	Target  *string `json:"target,omitempty"`
}

// ErrorResponse - Error response indicates Front Door service is not able to process the incoming request. The reason is
// provided in the error message.
type ErrorResponse struct {
	// READ-ONLY; Error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; Error message indicating why the operation failed.
	Message *string `json:"message,omitempty" azure:"ro"`
}

// Experiment - Defines the properties of an Experiment
type Experiment struct {
	// Resource location.
	Location *string `json:"location,omitempty"`

	// The properties of an Experiment
	Properties *ExperimentProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ExperimentList - Defines a list of Experiments. It contains a list of Experiment objects and a URL link to get the next
// set of results.
type ExperimentList struct {
	// URL to get the next set of Experiment objects if there are any.
	NextLink *string `json:"nextLink,omitempty"`

	// READ-ONLY; List of Experiments within a resource group.
	Value []*Experiment `json:"value,omitempty" azure:"ro"`
}

// ExperimentProperties - Defines the properties of an experiment
type ExperimentProperties struct {
	// The description of the details or intents of the Experiment
	Description *string `json:"description,omitempty"`

	// The state of the Experiment
	EnabledState *State `json:"enabledState,omitempty"`

	// The endpoint A of an experiment
	EndpointA *Endpoint `json:"endpointA,omitempty"`

	// The endpoint B of an experiment
	EndpointB *Endpoint `json:"endpointB,omitempty"`

	// READ-ONLY; Resource status.
	ResourceState *NetworkExperimentResourceState `json:"resourceState,omitempty" azure:"ro"`

	// READ-ONLY; The uri to the Script used in the Experiment
	ScriptFileURI *string `json:"scriptFileUri,omitempty" azure:"ro"`

	// READ-ONLY; The description of Experiment status from the server side
	Status *string `json:"status,omitempty" azure:"ro"`
}

// ExperimentUpdateModel - Defines modifiable attributes of an Experiment
type ExperimentUpdateModel struct {
	// The properties of a Profile
	Properties *ExperimentUpdateProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// ExperimentUpdateProperties - Defines the properties of an experiment
type ExperimentUpdateProperties struct {
	// The description of the intent or details of the Experiment
	Description *string `json:"description,omitempty"`

	// The state of the Experiment
	EnabledState *State `json:"enabledState,omitempty"`
}

// ExperimentsClientBeginCreateOrUpdateOptions contains the optional parameters for the ExperimentsClient.BeginCreateOrUpdate
// method.
type ExperimentsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ExperimentsClientBeginDeleteOptions contains the optional parameters for the ExperimentsClient.BeginDelete method.
type ExperimentsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ExperimentsClientBeginUpdateOptions contains the optional parameters for the ExperimentsClient.BeginUpdate method.
type ExperimentsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ExperimentsClientGetOptions contains the optional parameters for the ExperimentsClient.Get method.
type ExperimentsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ExperimentsClientListByProfileOptions contains the optional parameters for the ExperimentsClient.ListByProfile method.
type ExperimentsClientListByProfileOptions struct {
	// placeholder for future optional parameters
}

// ForwardingConfiguration - Describes Forwarding Route.
type ForwardingConfiguration struct {
	// REQUIRED
	ODataType *string `json:"@odata.type,omitempty"`

	// A reference to the BackendPool which this rule routes to.
	BackendPool *SubResource `json:"backendPool,omitempty"`

	// The caching configuration associated with this rule.
	CacheConfiguration *CacheConfiguration `json:"cacheConfiguration,omitempty"`

	// A custom path used to rewrite resource paths matched by this rule. Leave empty to use incoming path.
	CustomForwardingPath *string `json:"customForwardingPath,omitempty"`

	// Protocol this rule will use when forwarding traffic to backends.
	ForwardingProtocol *FrontDoorForwardingProtocol `json:"forwardingProtocol,omitempty"`
}

// GetRouteConfiguration implements the RouteConfigurationClassification interface for type ForwardingConfiguration.
func (f *ForwardingConfiguration) GetRouteConfiguration() *RouteConfiguration {
	return &RouteConfiguration{
		ODataType: f.ODataType,
	}
}

// FrontDoor - Front Door represents a collection of backend endpoints to route traffic to along with rules that specify how
// traffic is sent there.
type FrontDoor struct {
	// Resource location.
	Location *string `json:"location,omitempty"`

	// Properties of the Front Door Load Balancer
	Properties *Properties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// FrontDoorsClientBeginCreateOrUpdateOptions contains the optional parameters for the FrontDoorsClient.BeginCreateOrUpdate
// method.
type FrontDoorsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// FrontDoorsClientBeginDeleteOptions contains the optional parameters for the FrontDoorsClient.BeginDelete method.
type FrontDoorsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// FrontDoorsClientGetOptions contains the optional parameters for the FrontDoorsClient.Get method.
type FrontDoorsClientGetOptions struct {
	// placeholder for future optional parameters
}

// FrontDoorsClientListByResourceGroupOptions contains the optional parameters for the FrontDoorsClient.ListByResourceGroup
// method.
type FrontDoorsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// FrontDoorsClientListOptions contains the optional parameters for the FrontDoorsClient.List method.
type FrontDoorsClientListOptions struct {
	// placeholder for future optional parameters
}

// FrontDoorsClientValidateCustomDomainOptions contains the optional parameters for the FrontDoorsClient.ValidateCustomDomain
// method.
type FrontDoorsClientValidateCustomDomainOptions struct {
	// placeholder for future optional parameters
}

// FrontendEndpoint - A frontend endpoint used for routing.
type FrontendEndpoint struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Resource name.
	Name *string `json:"name,omitempty"`

	// Properties of the Frontend endpoint
	Properties *FrontendEndpointProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// FrontendEndpointLink - Defines the Resource ID for a Frontend Endpoint.
type FrontendEndpointLink struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`
}

// FrontendEndpointProperties - The JSON object that contains the properties required to create a frontend endpoint.
type FrontendEndpointProperties struct {
	// The host name of the frontendEndpoint. Must be a domain name.
	HostName *string `json:"hostName,omitempty"`

	// Whether to allow session affinity on this host. Valid options are 'Enabled' or 'Disabled'
	SessionAffinityEnabledState *SessionAffinityEnabledState `json:"sessionAffinityEnabledState,omitempty"`

	// UNUSED. This field will be ignored. The TTL to use in seconds for session affinity, if applicable.
	SessionAffinityTTLSeconds *int32 `json:"sessionAffinityTtlSeconds,omitempty"`

	// Defines the Web Application Firewall policy for each host (if applicable)
	WebApplicationFirewallPolicyLink *FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLink `json:"webApplicationFirewallPolicyLink,omitempty"`

	// READ-ONLY; The configuration specifying how to enable HTTPS
	CustomHTTPSConfiguration *CustomHTTPSConfiguration `json:"customHttpsConfiguration,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning status of Custom Https of the frontendEndpoint.
	CustomHTTPSProvisioningState *CustomHTTPSProvisioningState `json:"customHttpsProvisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning substate shows the progress of custom HTTPS enabling/disabling process step by step.
	CustomHTTPSProvisioningSubstate *CustomHTTPSProvisioningSubstate `json:"customHttpsProvisioningSubstate,omitempty" azure:"ro"`

	// READ-ONLY; Resource status.
	ResourceState *FrontDoorResourceState `json:"resourceState,omitempty" azure:"ro"`
}

// FrontendEndpointUpdateParameters - Frontend endpoint used in routing rule
type FrontendEndpointUpdateParameters struct {
	// The host name of the frontendEndpoint. Must be a domain name.
	HostName *string `json:"hostName,omitempty"`

	// Whether to allow session affinity on this host. Valid options are 'Enabled' or 'Disabled'
	SessionAffinityEnabledState *SessionAffinityEnabledState `json:"sessionAffinityEnabledState,omitempty"`

	// UNUSED. This field will be ignored. The TTL to use in seconds for session affinity, if applicable.
	SessionAffinityTTLSeconds *int32 `json:"sessionAffinityTtlSeconds,omitempty"`

	// Defines the Web Application Firewall policy for each host (if applicable)
	WebApplicationFirewallPolicyLink *FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLink `json:"webApplicationFirewallPolicyLink,omitempty"`
}

// FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLink - Defines the Web Application Firewall policy for each
// host (if applicable)
type FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLink struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`
}

// FrontendEndpointsClientBeginDisableHTTPSOptions contains the optional parameters for the FrontendEndpointsClient.BeginDisableHTTPS
// method.
type FrontendEndpointsClientBeginDisableHTTPSOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// FrontendEndpointsClientBeginEnableHTTPSOptions contains the optional parameters for the FrontendEndpointsClient.BeginEnableHTTPS
// method.
type FrontendEndpointsClientBeginEnableHTTPSOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// FrontendEndpointsClientGetOptions contains the optional parameters for the FrontendEndpointsClient.Get method.
type FrontendEndpointsClientGetOptions struct {
	// placeholder for future optional parameters
}

// FrontendEndpointsClientListByFrontDoorOptions contains the optional parameters for the FrontendEndpointsClient.ListByFrontDoor
// method.
type FrontendEndpointsClientListByFrontDoorOptions struct {
	// placeholder for future optional parameters
}

// FrontendEndpointsListResult - Result of the request to list frontend endpoints. It contains a list of Frontend endpoint
// objects and a URL link to get the next set of results.
type FrontendEndpointsListResult struct {
	// URL to get the next set of frontend endpoints if there are any.
	NextLink *string `json:"nextLink,omitempty"`

	// READ-ONLY; List of Frontend endpoints within a Front Door.
	Value []*FrontendEndpoint `json:"value,omitempty" azure:"ro"`
}

// HeaderAction - An action that can manipulate an http header.
type HeaderAction struct {
	// REQUIRED; Which type of manipulation to apply to the header.
	HeaderActionType *HeaderActionType `json:"headerActionType,omitempty"`

	// REQUIRED; The name of the header this action will apply to.
	HeaderName *string `json:"headerName,omitempty"`

	// The value to update the given header name with. This value is not used if the actionType is Delete.
	Value *string `json:"value,omitempty"`
}

// HealthProbeSettingsListResult - Result of the request to list HealthProbeSettings. It contains a list of HealthProbeSettings
// objects and a URL link to get the next set of results.
type HealthProbeSettingsListResult struct {
	// URL to get the next set of HealthProbeSettings objects if there are any.
	NextLink *string `json:"nextLink,omitempty"`

	// READ-ONLY; List of HealthProbeSettings within a Front Door.
	Value []*HealthProbeSettingsModel `json:"value,omitempty" azure:"ro"`
}

// HealthProbeSettingsModel - Load balancing settings for a backend pool
type HealthProbeSettingsModel struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Resource name.
	Name *string `json:"name,omitempty"`

	// Properties of the health probe settings
	Properties *HealthProbeSettingsProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// HealthProbeSettingsProperties - The JSON object that contains the properties required to create a health probe settings.
type HealthProbeSettingsProperties struct {
	// Whether to enable health probes to be made against backends defined under backendPools. Health probes can only be disabled
	// if there is a single enabled backend in single enabled backend pool.
	EnabledState *HealthProbeEnabled `json:"enabledState,omitempty"`

	// Configures which HTTP method to use to probe the backends defined under backendPools.
	HealthProbeMethod *FrontDoorHealthProbeMethod `json:"healthProbeMethod,omitempty"`

	// The number of seconds between health probes.
	IntervalInSeconds *int32 `json:"intervalInSeconds,omitempty"`

	// The path to use for the health probe. Default is /
	Path *string `json:"path,omitempty"`

	// Protocol scheme to use for this probe
	Protocol *FrontDoorProtocol `json:"protocol,omitempty"`

	// READ-ONLY; Resource status.
	ResourceState *FrontDoorResourceState `json:"resourceState,omitempty" azure:"ro"`
}

// HealthProbeSettingsUpdateParameters - L7 health probe settings for a backend pool
type HealthProbeSettingsUpdateParameters struct {
	// Whether to enable health probes to be made against backends defined under backendPools. Health probes can only be disabled
	// if there is a single enabled backend in single enabled backend pool.
	EnabledState *HealthProbeEnabled `json:"enabledState,omitempty"`

	// Configures which HTTP method to use to probe the backends defined under backendPools.
	HealthProbeMethod *FrontDoorHealthProbeMethod `json:"healthProbeMethod,omitempty"`

	// The number of seconds between health probes.
	IntervalInSeconds *int32 `json:"intervalInSeconds,omitempty"`

	// The path to use for the health probe. Default is /
	Path *string `json:"path,omitempty"`

	// Protocol scheme to use for this probe
	Protocol *FrontDoorProtocol `json:"protocol,omitempty"`
}

// KeyVaultCertificateSourceParameters - Parameters required for bring-your-own-certification via Key Vault
type KeyVaultCertificateSourceParameters struct {
	// The name of the Key Vault secret representing the full certificate PFX
	SecretName *string `json:"secretName,omitempty"`

	// The version of the Key Vault secret representing the full certificate PFX
	SecretVersion *string `json:"secretVersion,omitempty"`

	// The Key Vault containing the SSL certificate
	Vault *KeyVaultCertificateSourceParametersVault `json:"vault,omitempty"`
}

// KeyVaultCertificateSourceParametersVault - The Key Vault containing the SSL certificate
type KeyVaultCertificateSourceParametersVault struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`
}

// LatencyMetric - Defines the properties of a latency metric used in the latency scorecard
type LatencyMetric struct {
	// READ-ONLY; The lower end of the 95% confidence interval for endpoint A
	ACLower95CI *float32 `json:"aCLower95CI,omitempty" azure:"ro"`

	// READ-ONLY; The upper end of the 95% confidence interval for endpoint A
	AHUpper95CI *float32 `json:"aHUpper95CI,omitempty" azure:"ro"`

	// READ-ONLY; The metric value of the A endpoint
	AValue *float32 `json:"aValue,omitempty" azure:"ro"`

	// READ-ONLY; The lower end of the 95% confidence interval for endpoint B
	BCLower95CI *float32 `json:"bCLower95CI,omitempty" azure:"ro"`

	// READ-ONLY; The upper end of the 95% confidence interval for endpoint B
	BUpper95CI *float32 `json:"bUpper95CI,omitempty" azure:"ro"`

	// READ-ONLY; The metric value of the B endpoint
	BValue *float32 `json:"bValue,omitempty" azure:"ro"`

	// READ-ONLY; The difference in value between endpoint A and B
	Delta *float32 `json:"delta,omitempty" azure:"ro"`

	// READ-ONLY; The percent difference between endpoint A and B
	DeltaPercent *float32 `json:"deltaPercent,omitempty" azure:"ro"`

	// READ-ONLY; The end time of the Latency Scorecard in UTC
	EndDateTimeUTC *string `json:"endDateTimeUTC,omitempty" azure:"ro"`

	// READ-ONLY; The name of the Latency Metric
	Name *string `json:"name,omitempty" azure:"ro"`
}

// LatencyScorecard - Defines the LatencyScorecard
type LatencyScorecard struct {
	// Resource location.
	Location *string `json:"location,omitempty"`

	// The properties of a latency scorecard
	Properties *LatencyScorecardProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// LatencyScorecardProperties - Defines a the properties of a Latency Scorecard
type LatencyScorecardProperties struct {
	// The latency metrics of the Latency Scorecard
	LatencyMetrics []*LatencyMetric `json:"latencyMetrics,omitempty"`

	// READ-ONLY; The country associated with the Latency Scorecard. Values are country ISO codes as specified here- https://www.iso.org/iso-3166-country-codes.html
	Country *string `json:"country,omitempty" azure:"ro"`

	// READ-ONLY; The description of the Latency Scorecard
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The end time of the Latency Scorecard in UTC
	EndDateTimeUTC *time.Time `json:"endDateTimeUTC,omitempty" azure:"ro"`

	// READ-ONLY; The A endpoint in the scorecard
	EndpointA *string `json:"endpointA,omitempty" azure:"ro"`

	// READ-ONLY; The B endpoint in the scorecard
	EndpointB *string `json:"endpointB,omitempty" azure:"ro"`

	// READ-ONLY; The unique identifier of the Latency Scorecard
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the Latency Scorecard
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The start time of the Latency Scorecard in UTC
	StartDateTimeUTC *time.Time `json:"startDateTimeUTC,omitempty" azure:"ro"`
}

// ListResult - Result of the request to list Front Doors. It contains a list of Front Door objects and a URL link to get
// the next set of results.
type ListResult struct {
	// URL to get the next set of Front Door objects if there are any.
	NextLink *string `json:"nextLink,omitempty"`

	// READ-ONLY; List of Front Doors within a resource group.
	Value []*FrontDoor `json:"value,omitempty" azure:"ro"`
}

// LoadBalancingSettingsListResult - Result of the request to list load balancing settings. It contains a list of load balancing
// settings objects and a URL link to get the next set of results.
type LoadBalancingSettingsListResult struct {
	// URL to get the next set of LoadBalancingSettings objects if there are any.
	NextLink *string `json:"nextLink,omitempty"`

	// READ-ONLY; List of Backend Pools within a Front Door.
	Value []*LoadBalancingSettingsModel `json:"value,omitempty" azure:"ro"`
}

// LoadBalancingSettingsModel - Load balancing settings for a backend pool
type LoadBalancingSettingsModel struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Resource name.
	Name *string `json:"name,omitempty"`

	// Properties of the load balancing settings
	Properties *LoadBalancingSettingsProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// LoadBalancingSettingsProperties - The JSON object that contains the properties required to create load balancing settings
type LoadBalancingSettingsProperties struct {
	// The additional latency in milliseconds for probes to fall into the lowest latency bucket
	AdditionalLatencyMilliseconds *int32 `json:"additionalLatencyMilliseconds,omitempty"`

	// The number of samples to consider for load balancing decisions
	SampleSize *int32 `json:"sampleSize,omitempty"`

	// The number of samples within the sample period that must succeed
	SuccessfulSamplesRequired *int32 `json:"successfulSamplesRequired,omitempty"`

	// READ-ONLY; Resource status.
	ResourceState *FrontDoorResourceState `json:"resourceState,omitempty" azure:"ro"`
}

// LoadBalancingSettingsUpdateParameters - Round-Robin load balancing settings for a backend pool
type LoadBalancingSettingsUpdateParameters struct {
	// The additional latency in milliseconds for probes to fall into the lowest latency bucket
	AdditionalLatencyMilliseconds *int32 `json:"additionalLatencyMilliseconds,omitempty"`

	// The number of samples to consider for load balancing decisions
	SampleSize *int32 `json:"sampleSize,omitempty"`

	// The number of samples within the sample period that must succeed
	SuccessfulSamplesRequired *int32 `json:"successfulSamplesRequired,omitempty"`
}

// ManagedRuleDefinition - Describes a managed rule definition.
type ManagedRuleDefinition struct {
	// READ-ONLY; Describes the default action to be applied when the managed rule matches.
	DefaultAction *ActionType `json:"defaultAction,omitempty" azure:"ro"`

	// READ-ONLY; Describes the default state for the managed rule.
	DefaultState *ManagedRuleEnabledState `json:"defaultState,omitempty" azure:"ro"`

	// READ-ONLY; Describes the functionality of the managed rule.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; Identifier for the managed rule.
	RuleID *string `json:"ruleId,omitempty" azure:"ro"`
}

// ManagedRuleExclusion - Exclude variables from managed rule evaluation.
type ManagedRuleExclusion struct {
	// REQUIRED; The variable type to be excluded.
	MatchVariable *ManagedRuleExclusionMatchVariable `json:"matchVariable,omitempty"`

	// REQUIRED; Selector value for which elements in the collection this exclusion applies to.
	Selector *string `json:"selector,omitempty"`

	// REQUIRED; Comparison operator to apply to the selector when specifying which elements in the collection this exclusion
	// applies to.
	SelectorMatchOperator *ManagedRuleExclusionSelectorMatchOperator `json:"selectorMatchOperator,omitempty"`
}

// ManagedRuleGroupDefinition - Describes a managed rule group.
type ManagedRuleGroupDefinition struct {
	// READ-ONLY; Description of the managed rule group.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; Name of the managed rule group.
	RuleGroupName *string `json:"ruleGroupName,omitempty" azure:"ro"`

	// READ-ONLY; List of rules within the managed rule group.
	Rules []*ManagedRuleDefinition `json:"rules,omitempty" azure:"ro"`
}

// ManagedRuleGroupOverride - Defines a managed rule group override setting.
type ManagedRuleGroupOverride struct {
	// REQUIRED; Describes the managed rule group to override.
	RuleGroupName *string `json:"ruleGroupName,omitempty"`

	// Describes the exclusions that are applied to all rules in the group.
	Exclusions []*ManagedRuleExclusion `json:"exclusions,omitempty"`

	// List of rules that will be disabled. If none specified, all rules in the group will be disabled.
	Rules []*ManagedRuleOverride `json:"rules,omitempty"`
}

// ManagedRuleOverride - Defines a managed rule group override setting.
type ManagedRuleOverride struct {
	// REQUIRED; Identifier for the managed rule.
	RuleID *string `json:"ruleId,omitempty"`

	// Describes the override action to be applied when rule matches.
	Action *ActionType `json:"action,omitempty"`

	// Describes if the managed rule is in enabled or disabled state. Defaults to Disabled if not specified.
	EnabledState *ManagedRuleEnabledState `json:"enabledState,omitempty"`

	// Describes the exclusions that are applied to this specific rule.
	Exclusions []*ManagedRuleExclusion `json:"exclusions,omitempty"`
}

// ManagedRuleSet - Defines a managed rule set.
type ManagedRuleSet struct {
	// REQUIRED; Defines the rule set type to use.
	RuleSetType *string `json:"ruleSetType,omitempty"`

	// REQUIRED; Defines the version of the rule set to use.
	RuleSetVersion *string `json:"ruleSetVersion,omitempty"`

	// Describes the exclusions that are applied to all rules in the set.
	Exclusions []*ManagedRuleExclusion `json:"exclusions,omitempty"`

	// Defines the rule group overrides to apply to the rule set.
	RuleGroupOverrides []*ManagedRuleGroupOverride `json:"ruleGroupOverrides,omitempty"`

	// Defines the action to take when a managed rule set score threshold is met.
	RuleSetAction *ManagedRuleSetActionType `json:"ruleSetAction,omitempty"`
}

// ManagedRuleSetDefinition - Describes the a managed rule set definition.
type ManagedRuleSetDefinition struct {
	// Resource location.
	Location *string `json:"location,omitempty"`

	// Properties for a managed rule set definition.
	Properties *ManagedRuleSetDefinitionProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ManagedRuleSetDefinitionList - List of managed rule set definitions available for use in a policy.
type ManagedRuleSetDefinitionList struct {
	// URL to retrieve next set of managed rule set definitions.
	NextLink *string `json:"nextLink,omitempty"`

	// READ-ONLY; List of managed rule set definitions.
	Value []*ManagedRuleSetDefinition `json:"value,omitempty" azure:"ro"`
}

// ManagedRuleSetDefinitionProperties - Properties for a managed rule set definition.
type ManagedRuleSetDefinitionProperties struct {
	// READ-ONLY; Provisioning state of the managed rule set.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Rule groups of the managed rule set.
	RuleGroups []*ManagedRuleGroupDefinition `json:"ruleGroups,omitempty" azure:"ro"`

	// READ-ONLY; Id of the managed rule set.
	RuleSetID *string `json:"ruleSetId,omitempty" azure:"ro"`

	// READ-ONLY; Type of the managed rule set.
	RuleSetType *string `json:"ruleSetType,omitempty" azure:"ro"`

	// READ-ONLY; Version of the managed rule set type.
	RuleSetVersion *string `json:"ruleSetVersion,omitempty" azure:"ro"`
}

// ManagedRuleSetList - Defines the list of managed rule sets for the policy.
type ManagedRuleSetList struct {
	// List of rule sets.
	ManagedRuleSets []*ManagedRuleSet `json:"managedRuleSets,omitempty"`
}

// ManagedRuleSetsClientListOptions contains the optional parameters for the ManagedRuleSetsClient.List method.
type ManagedRuleSetsClientListOptions struct {
	// placeholder for future optional parameters
}

// MatchCondition - Define a match condition.
type MatchCondition struct {
	// REQUIRED; List of possible match values.
	MatchValue []*string `json:"matchValue,omitempty"`

	// REQUIRED; Request variable to compare with.
	MatchVariable *MatchVariable `json:"matchVariable,omitempty"`

	// REQUIRED; Comparison type to use for matching with the variable value.
	Operator *Operator `json:"operator,omitempty"`

	// Describes if the result of this condition should be negated.
	NegateCondition *bool `json:"negateCondition,omitempty"`

	// Match against a specific key from the QueryString, PostArgs, RequestHeader or Cookies variables. Default is null.
	Selector *string `json:"selector,omitempty"`

	// List of transforms.
	Transforms []*TransformType `json:"transforms,omitempty"`
}

// NameAvailabilityClientCheckOptions contains the optional parameters for the NameAvailabilityClient.Check method.
type NameAvailabilityClientCheckOptions struct {
	// placeholder for future optional parameters
}

// NameAvailabilityWithSubscriptionClientCheckOptions contains the optional parameters for the NameAvailabilityWithSubscriptionClient.Check
// method.
type NameAvailabilityWithSubscriptionClientCheckOptions struct {
	// placeholder for future optional parameters
}

// NetworkExperimentProfilesClientBeginCreateOrUpdateOptions contains the optional parameters for the NetworkExperimentProfilesClient.BeginCreateOrUpdate
// method.
type NetworkExperimentProfilesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// NetworkExperimentProfilesClientBeginDeleteOptions contains the optional parameters for the NetworkExperimentProfilesClient.BeginDelete
// method.
type NetworkExperimentProfilesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// NetworkExperimentProfilesClientBeginUpdateOptions contains the optional parameters for the NetworkExperimentProfilesClient.BeginUpdate
// method.
type NetworkExperimentProfilesClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// NetworkExperimentProfilesClientGetOptions contains the optional parameters for the NetworkExperimentProfilesClient.Get
// method.
type NetworkExperimentProfilesClientGetOptions struct {
	// placeholder for future optional parameters
}

// NetworkExperimentProfilesClientListByResourceGroupOptions contains the optional parameters for the NetworkExperimentProfilesClient.ListByResourceGroup
// method.
type NetworkExperimentProfilesClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// NetworkExperimentProfilesClientListOptions contains the optional parameters for the NetworkExperimentProfilesClient.List
// method.
type NetworkExperimentProfilesClientListOptions struct {
	// placeholder for future optional parameters
}

// PoliciesClientBeginCreateOrUpdateOptions contains the optional parameters for the PoliciesClient.BeginCreateOrUpdate method.
type PoliciesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PoliciesClientBeginDeleteOptions contains the optional parameters for the PoliciesClient.BeginDelete method.
type PoliciesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PoliciesClientGetOptions contains the optional parameters for the PoliciesClient.Get method.
type PoliciesClientGetOptions struct {
	// placeholder for future optional parameters
}

// PoliciesClientListOptions contains the optional parameters for the PoliciesClient.List method.
type PoliciesClientListOptions struct {
	// placeholder for future optional parameters
}

// PolicySettings - Defines top-level WebApplicationFirewallPolicy configuration settings.
type PolicySettings struct {
	// If the action type is block, customer can override the response body. The body must be specified in base64 encoding.
	CustomBlockResponseBody *string `json:"customBlockResponseBody,omitempty"`

	// If the action type is block, customer can override the response status code.
	CustomBlockResponseStatusCode *int32 `json:"customBlockResponseStatusCode,omitempty"`

	// Describes if the policy is in enabled or disabled state. Defaults to Enabled if not specified.
	EnabledState *PolicyEnabledState `json:"enabledState,omitempty"`

	// Describes if it is in detection mode or prevention mode at policy level.
	Mode *PolicyMode `json:"mode,omitempty"`

	// If action type is redirect, this field represents redirect URL for the client.
	RedirectURL *string `json:"redirectUrl,omitempty"`

	// Describes if policy managed rules will inspect the request body content.
	RequestBodyCheck *PolicyRequestBodyCheck `json:"requestBodyCheck,omitempty"`
}

// PreconfiguredEndpoint - Defines the properties of a preconfigured endpoint
type PreconfiguredEndpoint struct {
	// Resource location.
	Location *string `json:"location,omitempty"`

	// The properties of a preconfiguredEndpoint
	Properties *PreconfiguredEndpointProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PreconfiguredEndpointList - Defines a list of preconfigured endpoints.
type PreconfiguredEndpointList struct {
	// URL to get the next set of PreconfiguredEndpoints if there are any.
	NextLink *string `json:"nextLink,omitempty"`

	// READ-ONLY; List of PreconfiguredEndpoints supported by NetworkExperiment.
	Value []*PreconfiguredEndpoint `json:"value,omitempty" azure:"ro"`
}

// PreconfiguredEndpointProperties - Defines the properties of a preconfigured endpoint
type PreconfiguredEndpointProperties struct {
	// The preconfigured endpoint backend
	Backend *string `json:"backend,omitempty"`

	// The description of the endpoint
	Description *string `json:"description,omitempty"`

	// The endpoint that is preconfigured
	Endpoint *string `json:"endpoint,omitempty"`

	// The type of endpoint
	EndpointType *EndpointType `json:"endpointType,omitempty"`
}

// PreconfiguredEndpointsClientListOptions contains the optional parameters for the PreconfiguredEndpointsClient.List method.
type PreconfiguredEndpointsClientListOptions struct {
	// placeholder for future optional parameters
}

// Profile - Defines an Network Experiment Profile and lists of Experiments
type Profile struct {
	// Gets a unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// The properties of a Profile
	Properties *ProfileProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ProfileList - Defines a list of Profiles. It contains a list of Profile objects and a URL link to get the next set of results.
type ProfileList struct {
	// URL to get the next set of Profile objects if there are any.
	NextLink *string `json:"nextLink,omitempty"`

	// READ-ONLY; List of Profiles within a resource group.
	Value []*Profile `json:"value,omitempty" azure:"ro"`
}

// ProfileProperties - Defines the properties of an experiment
type ProfileProperties struct {
	// The state of the Experiment
	EnabledState *State `json:"enabledState,omitempty"`

	// READ-ONLY; Resource status.
	ResourceState *NetworkExperimentResourceState `json:"resourceState,omitempty" azure:"ro"`
}

// ProfileUpdateModel - Defines modifiable attributes of a Profile
type ProfileUpdateModel struct {
	// The properties of a Profile
	Properties *ProfileUpdateProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// ProfileUpdateProperties - Defines the properties of an experiment
type ProfileUpdateProperties struct {
	// The enabled state of the Profile
	EnabledState *State `json:"enabledState,omitempty"`
}

// Properties - The JSON object that contains the properties required to create an endpoint.
type Properties struct {
	// Backend pools available to routing rules.
	BackendPools []*BackendPool `json:"backendPools,omitempty"`

	// Settings for all backendPools
	BackendPoolsSettings *BackendPoolsSettings `json:"backendPoolsSettings,omitempty"`

	// Operational status of the Front Door load balancer. Permitted values are 'Enabled' or 'Disabled'
	EnabledState *FrontDoorEnabledState `json:"enabledState,omitempty"`

	// A friendly name for the frontDoor
	FriendlyName *string `json:"friendlyName,omitempty"`

	// Frontend endpoints available to routing rules.
	FrontendEndpoints []*FrontendEndpoint `json:"frontendEndpoints,omitempty"`

	// Health probe settings associated with this Front Door instance.
	HealthProbeSettings []*HealthProbeSettingsModel `json:"healthProbeSettings,omitempty"`

	// Load balancing settings associated with this Front Door instance.
	LoadBalancingSettings []*LoadBalancingSettingsModel `json:"loadBalancingSettings,omitempty"`

	// Routing rules associated with this Front Door.
	RoutingRules []*RoutingRule `json:"routingRules,omitempty"`

	// READ-ONLY; The host that each frontendEndpoint must CNAME to.
	Cname *string `json:"cname,omitempty" azure:"ro"`

	// READ-ONLY; The Id of the frontdoor.
	FrontdoorID *string `json:"frontdoorId,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the Front Door.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Resource status of the Front Door.
	ResourceState *FrontDoorResourceState `json:"resourceState,omitempty" azure:"ro"`

	// READ-ONLY; Rules Engine Configurations available to routing rules.
	RulesEngines []*RulesEngine `json:"rulesEngines,omitempty" azure:"ro"`
}

// PurgeParameters - Parameters required for content purge.
type PurgeParameters struct {
	// REQUIRED; The path to the content to be purged. Can describe a file path or a wild card directory.
	ContentPaths []*string `json:"contentPaths,omitempty"`
}

// RedirectConfiguration - Describes Redirect Route.
type RedirectConfiguration struct {
	// REQUIRED
	ODataType *string `json:"@odata.type,omitempty"`

	// Fragment to add to the redirect URL. Fragment is the part of the URL that comes after #. Do not include the #.
	CustomFragment *string `json:"customFragment,omitempty"`

	// Host to redirect. Leave empty to use the incoming host as the destination host.
	CustomHost *string `json:"customHost,omitempty"`

	// The full path to redirect. Path cannot be empty and must start with /. Leave empty to use the incoming path as destination
	// path.
	CustomPath *string `json:"customPath,omitempty"`

	// The set of query strings to be placed in the redirect URL. Setting this value would replace any existing query string;
	// leave empty to preserve the incoming query string. Query string must be in =
	// format. The first ? and & will be added automatically so do not include them in the front, but do separate multiple query
	// strings with &.
	CustomQueryString *string `json:"customQueryString,omitempty"`

	// The protocol of the destination to where the traffic is redirected
	RedirectProtocol *FrontDoorRedirectProtocol `json:"redirectProtocol,omitempty"`

	// The redirect type the rule will use when redirecting traffic.
	RedirectType *FrontDoorRedirectType `json:"redirectType,omitempty"`
}

// GetRouteConfiguration implements the RouteConfigurationClassification interface for type RedirectConfiguration.
func (r *RedirectConfiguration) GetRouteConfiguration() *RouteConfiguration {
	return &RouteConfiguration{
		ODataType: r.ODataType,
	}
}

// ReportsClientGetLatencyScorecardsOptions contains the optional parameters for the ReportsClient.GetLatencyScorecards method.
type ReportsClientGetLatencyScorecardsOptions struct {
	// The country associated with the Latency Scorecard. Values are country ISO codes as specified here- https://www.iso.org/iso-3166-country-codes.html
	Country *string
	// The end DateTime of the Latency Scorecard in UTC
	EndDateTimeUTC *string
}

// ReportsClientGetTimeseriesOptions contains the optional parameters for the ReportsClient.GetTimeseries method.
type ReportsClientGetTimeseriesOptions struct {
	// The country associated with the Timeseries. Values are country ISO codes as specified here- https://www.iso.org/iso-3166-country-codes.html
	Country *string
	// The specific endpoint
	Endpoint *string
}

// Resource - Common resource representation.
type Resource struct {
	// Resource location.
	Location *string `json:"location,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RouteConfigurationClassification provides polymorphic access to related types.
// Call the interface's GetRouteConfiguration() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *ForwardingConfiguration, *RedirectConfiguration, *RouteConfiguration
type RouteConfigurationClassification interface {
	// GetRouteConfiguration returns the RouteConfiguration content of the underlying type.
	GetRouteConfiguration() *RouteConfiguration
}

// RouteConfiguration - Base class for all types of Route.
type RouteConfiguration struct {
	// REQUIRED
	ODataType *string `json:"@odata.type,omitempty"`
}

// GetRouteConfiguration implements the RouteConfigurationClassification interface for type RouteConfiguration.
func (r *RouteConfiguration) GetRouteConfiguration() *RouteConfiguration { return r }

// RoutingRule - A routing rule represents a specification for traffic to treat and where to send it, along with health probe
// information.
type RoutingRule struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Resource name.
	Name *string `json:"name,omitempty"`

	// Properties of the Front Door Routing Rule
	Properties *RoutingRuleProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RoutingRuleLink - Defines the Resource ID for a Routing Rule.
type RoutingRuleLink struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`
}

// RoutingRuleListResult - Result of the request to list Routing Rules. It contains a list of Routing Rule objects and a URL
// link to get the next set of results.
type RoutingRuleListResult struct {
	// URL to get the next set of RoutingRule objects if there are any.
	NextLink *string `json:"nextLink,omitempty"`

	// READ-ONLY; List of Routing Rules within a Front Door.
	Value []*RoutingRule `json:"value,omitempty" azure:"ro"`
}

// RoutingRuleProperties - The JSON object that contains the properties required to create a routing rule.
type RoutingRuleProperties struct {
	// Protocol schemes to match for this rule
	AcceptedProtocols []*FrontDoorProtocol `json:"acceptedProtocols,omitempty"`

	// Whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'
	EnabledState *RoutingRuleEnabledState `json:"enabledState,omitempty"`

	// Frontend endpoints associated with this rule
	FrontendEndpoints []*SubResource `json:"frontendEndpoints,omitempty"`

	// The route patterns of the rule.
	PatternsToMatch []*string `json:"patternsToMatch,omitempty"`

	// A reference to the routing configuration.
	RouteConfiguration RouteConfigurationClassification `json:"routeConfiguration,omitempty"`

	// A reference to a specific Rules Engine Configuration to apply to this route.
	RulesEngine *SubResource `json:"rulesEngine,omitempty"`

	// Defines the Web Application Firewall policy for each routing rule (if applicable)
	WebApplicationFirewallPolicyLink *RoutingRuleUpdateParametersWebApplicationFirewallPolicyLink `json:"webApplicationFirewallPolicyLink,omitempty"`

	// READ-ONLY; Resource status.
	ResourceState *FrontDoorResourceState `json:"resourceState,omitempty" azure:"ro"`
}

// RoutingRuleUpdateParameters - Routing rules to apply to an endpoint
type RoutingRuleUpdateParameters struct {
	// Protocol schemes to match for this rule
	AcceptedProtocols []*FrontDoorProtocol `json:"acceptedProtocols,omitempty"`

	// Whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'
	EnabledState *RoutingRuleEnabledState `json:"enabledState,omitempty"`

	// Frontend endpoints associated with this rule
	FrontendEndpoints []*SubResource `json:"frontendEndpoints,omitempty"`

	// The route patterns of the rule.
	PatternsToMatch []*string `json:"patternsToMatch,omitempty"`

	// A reference to the routing configuration.
	RouteConfiguration RouteConfigurationClassification `json:"routeConfiguration,omitempty"`

	// A reference to a specific Rules Engine Configuration to apply to this route.
	RulesEngine *SubResource `json:"rulesEngine,omitempty"`

	// Defines the Web Application Firewall policy for each routing rule (if applicable)
	WebApplicationFirewallPolicyLink *RoutingRuleUpdateParametersWebApplicationFirewallPolicyLink `json:"webApplicationFirewallPolicyLink,omitempty"`
}

// RoutingRuleUpdateParametersWebApplicationFirewallPolicyLink - Defines the Web Application Firewall policy for each routing
// rule (if applicable)
type RoutingRuleUpdateParametersWebApplicationFirewallPolicyLink struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`
}

// RulesEngine - A rules engine configuration containing a list of rules that will run to modify the runtime behavior of the
// request and response.
type RulesEngine struct {
	// Properties of the Rules Engine Configuration.
	Properties *RulesEngineProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RulesEngineAction - One or more actions that will execute, modifying the request and/or response.
type RulesEngineAction struct {
	// A list of header actions to apply from the request from AFD to the origin.
	RequestHeaderActions []*HeaderAction `json:"requestHeaderActions,omitempty"`

	// A list of header actions to apply from the response from AFD to the client.
	ResponseHeaderActions []*HeaderAction `json:"responseHeaderActions,omitempty"`

	// Override the route configuration.
	RouteConfigurationOverride RouteConfigurationClassification `json:"routeConfigurationOverride,omitempty"`
}

// RulesEngineListResult - Result of the request to list Rules Engine Configurations. It contains a list of RulesEngine objects
// and a URL link to get the next set of results.
type RulesEngineListResult struct {
	// URL to get the next set of RulesEngine objects if there are any.
	NextLink *string `json:"nextLink,omitempty"`

	// READ-ONLY; List of rulesEngines within a Front Door.
	Value []*RulesEngine `json:"value,omitempty" azure:"ro"`
}

// RulesEngineMatchCondition - Define a match condition
type RulesEngineMatchCondition struct {
	// REQUIRED; Match values to match against. The operator will apply to each value in here with OR semantics. If any of them
	// match the variable with the given operator this match condition is considered a match.
	RulesEngineMatchValue []*string `json:"rulesEngineMatchValue,omitempty"`

	// REQUIRED; Match Variable
	RulesEngineMatchVariable *RulesEngineMatchVariable `json:"rulesEngineMatchVariable,omitempty"`

	// REQUIRED; Describes operator to apply to the match condition.
	RulesEngineOperator *RulesEngineOperator `json:"rulesEngineOperator,omitempty"`

	// Describes if this is negate condition or not
	NegateCondition *bool `json:"negateCondition,omitempty"`

	// Name of selector in RequestHeader or RequestBody to be matched
	Selector *string `json:"selector,omitempty"`

	// List of transforms
	Transforms []*Transform `json:"transforms,omitempty"`
}

// RulesEngineProperties - The JSON object that contains the properties required to create a Rules Engine Configuration.
type RulesEngineProperties struct {
	// A list of rules that define a particular Rules Engine Configuration.
	Rules []*RulesEngineRule `json:"rules,omitempty"`

	// READ-ONLY; Resource status.
	ResourceState *FrontDoorResourceState `json:"resourceState,omitempty" azure:"ro"`
}

// RulesEngineRule - Contains a list of match conditions, and an action on how to modify the request/response. If multiple
// rules match, the actions from one rule that conflict with a previous rule overwrite for a singular
// action, or append in the case of headers manipulation.
type RulesEngineRule struct {
	// REQUIRED; Actions to perform on the request and response if all of the match conditions are met.
	Action *RulesEngineAction `json:"action,omitempty"`

	// REQUIRED; A name to refer to this specific rule.
	Name *string `json:"name,omitempty"`

	// REQUIRED; A priority assigned to this rule.
	Priority *int32 `json:"priority,omitempty"`

	// A list of match conditions that must meet in order for the actions of this rule to run. Having no match conditions means
	// the actions will always run.
	MatchConditions []*RulesEngineMatchCondition `json:"matchConditions,omitempty"`

	// If this rule is a match should the rules engine continue running the remaining rules or stop. If not present, defaults
	// to Continue.
	MatchProcessingBehavior *MatchProcessingBehavior `json:"matchProcessingBehavior,omitempty"`
}

// RulesEngineUpdateParameters - Rules Engine Configuration to apply to a Routing Rule.
type RulesEngineUpdateParameters struct {
	// A list of rules that define a particular Rules Engine Configuration.
	Rules []*RulesEngineRule `json:"rules,omitempty"`
}

// RulesEnginesClientBeginCreateOrUpdateOptions contains the optional parameters for the RulesEnginesClient.BeginCreateOrUpdate
// method.
type RulesEnginesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// RulesEnginesClientBeginDeleteOptions contains the optional parameters for the RulesEnginesClient.BeginDelete method.
type RulesEnginesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// RulesEnginesClientGetOptions contains the optional parameters for the RulesEnginesClient.Get method.
type RulesEnginesClientGetOptions struct {
	// placeholder for future optional parameters
}

// RulesEnginesClientListByFrontDoorOptions contains the optional parameters for the RulesEnginesClient.ListByFrontDoor method.
type RulesEnginesClientListByFrontDoorOptions struct {
	// placeholder for future optional parameters
}

// SKU - The pricing tier of the web application firewall policy.
type SKU struct {
	// Name of the pricing tier.
	Name *SKUName `json:"name,omitempty"`
}

// SecurityPolicyLink - Defines the Resource ID for a Security Policy.
type SecurityPolicyLink struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`
}

// SubResource - Reference to another subresource.
type SubResource struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`
}

// TagsObject - Tags object for patch operations.
type TagsObject struct {
	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// Timeseries - Defines the Timeseries
type Timeseries struct {
	// Resource location.
	Location *string `json:"location,omitempty"`

	// The properties of a Timeseries
	Properties *TimeseriesProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// TimeseriesDataPoint - Defines a timeseries datapoint used in a timeseries
type TimeseriesDataPoint struct {
	// The DateTime of the Timeseries data point in UTC
	DateTimeUTC *string `json:"dateTimeUTC,omitempty"`

	// The Value of the Timeseries data point
	Value *float32 `json:"value,omitempty"`
}

// TimeseriesProperties - Defines the properties of a timeseries
type TimeseriesProperties struct {
	// The aggregation interval of the Timeseries
	AggregationInterval *AggregationInterval `json:"aggregationInterval,omitempty"`

	// The country associated with the Timeseries. Values are country ISO codes as specified here- https://www.iso.org/iso-3166-country-codes.html
	Country *string `json:"country,omitempty"`

	// The end DateTime of the Timeseries in UTC
	EndDateTimeUTC *string `json:"endDateTimeUTC,omitempty"`

	// The endpoint associated with the Timeseries data point
	Endpoint *string `json:"endpoint,omitempty"`

	// The start DateTime of the Timeseries in UTC
	StartDateTimeUTC *string `json:"startDateTimeUTC,omitempty"`

	// The set of data points for the timeseries
	TimeseriesData []*TimeseriesDataPoint `json:"timeseriesData,omitempty"`

	// The type of Timeseries
	TimeseriesType *TimeseriesType `json:"timeseriesType,omitempty"`
}

// UpdateParameters - The properties needed to update a Front Door
type UpdateParameters struct {
	// Backend pools available to routing rules.
	BackendPools []*BackendPool `json:"backendPools,omitempty"`

	// Settings for all backendPools
	BackendPoolsSettings *BackendPoolsSettings `json:"backendPoolsSettings,omitempty"`

	// Operational status of the Front Door load balancer. Permitted values are 'Enabled' or 'Disabled'
	EnabledState *FrontDoorEnabledState `json:"enabledState,omitempty"`

	// A friendly name for the frontDoor
	FriendlyName *string `json:"friendlyName,omitempty"`

	// Frontend endpoints available to routing rules.
	FrontendEndpoints []*FrontendEndpoint `json:"frontendEndpoints,omitempty"`

	// Health probe settings associated with this Front Door instance.
	HealthProbeSettings []*HealthProbeSettingsModel `json:"healthProbeSettings,omitempty"`

	// Load balancing settings associated with this Front Door instance.
	LoadBalancingSettings []*LoadBalancingSettingsModel `json:"loadBalancingSettings,omitempty"`

	// Routing rules associated with this Front Door.
	RoutingRules []*RoutingRule `json:"routingRules,omitempty"`
}

// ValidateCustomDomainInput - Input of the custom domain to be validated for DNS mapping.
type ValidateCustomDomainInput struct {
	// REQUIRED; The host name of the custom domain. Must be a domain name.
	HostName *string `json:"hostName,omitempty"`
}

// ValidateCustomDomainOutput - Output of custom domain validation.
type ValidateCustomDomainOutput struct {
	// READ-ONLY; Indicates whether the custom domain is valid or not.
	CustomDomainValidated *bool `json:"customDomainValidated,omitempty" azure:"ro"`

	// READ-ONLY; Error message describing why the custom domain is not valid.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The reason why the custom domain is not valid.
	Reason *string `json:"reason,omitempty" azure:"ro"`
}

// WebApplicationFirewallPolicy - Defines web application firewall policy.
type WebApplicationFirewallPolicy struct {
	// Gets a unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// Properties of the web application firewall policy.
	Properties *WebApplicationFirewallPolicyProperties `json:"properties,omitempty"`

	// The pricing tier of web application firewall policy. Defaults to Classic_AzureFrontDoor if not specified.
	SKU *SKU `json:"sku,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// WebApplicationFirewallPolicyList - Defines a list of WebApplicationFirewallPolicies. It contains a list of WebApplicationFirewallPolicy
// objects and a URL link to get the next set of results.
type WebApplicationFirewallPolicyList struct {
	// URL to get the next set of WebApplicationFirewallPolicy objects if there are any.
	NextLink *string `json:"nextLink,omitempty"`

	// READ-ONLY; List of WebApplicationFirewallPolicies within a resource group.
	Value []*WebApplicationFirewallPolicy `json:"value,omitempty" azure:"ro"`
}

// WebApplicationFirewallPolicyProperties - Defines web application firewall policy properties.
type WebApplicationFirewallPolicyProperties struct {
	// Describes custom rules inside the policy.
	CustomRules *CustomRuleList `json:"customRules,omitempty"`

	// Describes managed rules inside the policy.
	ManagedRules *ManagedRuleSetList `json:"managedRules,omitempty"`

	// Describes settings for the policy.
	PolicySettings *PolicySettings `json:"policySettings,omitempty"`

	// READ-ONLY; Describes Frontend Endpoints associated with this Web Application Firewall policy.
	FrontendEndpointLinks []*FrontendEndpointLink `json:"frontendEndpointLinks,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the policy.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Resource status of the policy.
	ResourceState *PolicyResourceState `json:"resourceState,omitempty" azure:"ro"`

	// READ-ONLY; Describes Routing Rules associated with this Web Application Firewall policy.
	RoutingRuleLinks []*RoutingRuleLink `json:"routingRuleLinks,omitempty" azure:"ro"`

	// READ-ONLY; Describes Security Policy associated with this Web Application Firewall policy.
	SecurityPolicyLinks []*SecurityPolicyLink `json:"securityPolicyLinks,omitempty" azure:"ro"`
}
