//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdevtestlabs

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
)

// ProviderOperationsClient contains the methods for the ProviderOperations group.
// Don't use this type directly, use NewProviderOperationsClient() instead.
type ProviderOperationsClient struct {
	host string
	pl   runtime.Pipeline
}

// NewProviderOperationsClient creates a new instance of ProviderOperationsClient with the specified values.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewProviderOperationsClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*ProviderOperationsClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &ProviderOperationsClient{
		host: ep,
		pl:   pl,
	}
	return client, nil
}

// NewListPager - Result of the request to list REST API operations
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2018-09-15
// options - ProviderOperationsClientListOptions contains the optional parameters for the ProviderOperationsClient.List method.
func (client *ProviderOperationsClient) NewListPager(options *ProviderOperationsClientListOptions) *runtime.Pager[ProviderOperationsClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[ProviderOperationsClientListResponse]{
		More: func(page ProviderOperationsClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ProviderOperationsClientListResponse) (ProviderOperationsClientListResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listCreateRequest(ctx, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return ProviderOperationsClientListResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return ProviderOperationsClientListResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return ProviderOperationsClientListResponse{}, runtime.NewResponseError(resp)
			}
			return client.listHandleResponse(resp)
		},
	})
}

// listCreateRequest creates the List request.
func (client *ProviderOperationsClient) listCreateRequest(ctx context.Context, options *ProviderOperationsClientListOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.DevTestLab/operations"
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2018-09-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *ProviderOperationsClient) listHandleResponse(resp *http.Response) (ProviderOperationsClientListResponse, error) {
	result := ProviderOperationsClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ProviderOperationResult); err != nil {
		return ProviderOperationsClientListResponse{}, err
	}
	return result, nil
}
