//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdatamigration

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type BackupSetInfo.
func (b BackupSetInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "backupFinishedDate", b.BackupFinishedDate)
	populate(objectMap, "backupSetId", b.BackupSetID)
	populateTimeRFC3339(objectMap, "backupStartDate", b.BackupStartDate)
	populate(objectMap, "backupType", b.BackupType)
	populate(objectMap, "databaseName", b.DatabaseName)
	populate(objectMap, "firstLsn", b.FirstLsn)
	populate(objectMap, "isBackupRestored", b.IsBackupRestored)
	populate(objectMap, "lastLsn", b.LastLsn)
	populateTimeRFC3339(objectMap, "lastModifiedTime", b.LastModifiedTime)
	populate(objectMap, "listOfBackupFiles", b.ListOfBackupFiles)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackupSetInfo.
func (b *BackupSetInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupFinishedDate":
			err = unpopulateTimeRFC3339(val, "BackupFinishedDate", &b.BackupFinishedDate)
			delete(rawMsg, key)
		case "backupSetId":
			err = unpopulate(val, "BackupSetID", &b.BackupSetID)
			delete(rawMsg, key)
		case "backupStartDate":
			err = unpopulateTimeRFC3339(val, "BackupStartDate", &b.BackupStartDate)
			delete(rawMsg, key)
		case "backupType":
			err = unpopulate(val, "BackupType", &b.BackupType)
			delete(rawMsg, key)
		case "databaseName":
			err = unpopulate(val, "DatabaseName", &b.DatabaseName)
			delete(rawMsg, key)
		case "firstLsn":
			err = unpopulate(val, "FirstLsn", &b.FirstLsn)
			delete(rawMsg, key)
		case "isBackupRestored":
			err = unpopulate(val, "IsBackupRestored", &b.IsBackupRestored)
			delete(rawMsg, key)
		case "lastLsn":
			err = unpopulate(val, "LastLsn", &b.LastLsn)
			delete(rawMsg, key)
		case "lastModifiedTime":
			err = unpopulateTimeRFC3339(val, "LastModifiedTime", &b.LastModifiedTime)
			delete(rawMsg, key)
		case "listOfBackupFiles":
			err = unpopulate(val, "ListOfBackupFiles", &b.ListOfBackupFiles)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CheckOCIDriverTaskOutput.
func (c CheckOCIDriverTaskOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "installedDriver", c.InstalledDriver)
	populate(objectMap, "validationErrors", c.ValidationErrors)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type CheckOCIDriverTaskProperties.
func (c CheckOCIDriverTaskProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "clientData", c.ClientData)
	populate(objectMap, "commands", c.Commands)
	populate(objectMap, "errors", c.Errors)
	populate(objectMap, "input", c.Input)
	populate(objectMap, "output", c.Output)
	populate(objectMap, "state", c.State)
	objectMap["taskType"] = "Service.Check.OCI"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CheckOCIDriverTaskProperties.
func (c *CheckOCIDriverTaskProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientData":
			err = unpopulate(val, "ClientData", &c.ClientData)
			delete(rawMsg, key)
		case "commands":
			c.Commands, err = unmarshalCommandPropertiesClassificationArray(val)
			delete(rawMsg, key)
		case "errors":
			err = unpopulate(val, "Errors", &c.Errors)
			delete(rawMsg, key)
		case "input":
			err = unpopulate(val, "Input", &c.Input)
			delete(rawMsg, key)
		case "output":
			err = unpopulate(val, "Output", &c.Output)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &c.State)
			delete(rawMsg, key)
		case "taskType":
			err = unpopulate(val, "TaskType", &c.TaskType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CommandProperties.
func (c CommandProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["commandType"] = c.CommandType
	populate(objectMap, "errors", c.Errors)
	populate(objectMap, "state", c.State)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ConnectToMongoDbTaskProperties.
func (c ConnectToMongoDbTaskProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "clientData", c.ClientData)
	populate(objectMap, "commands", c.Commands)
	populate(objectMap, "errors", c.Errors)
	populate(objectMap, "input", c.Input)
	populate(objectMap, "output", c.Output)
	populate(objectMap, "state", c.State)
	objectMap["taskType"] = "Connect.MongoDb"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectToMongoDbTaskProperties.
func (c *ConnectToMongoDbTaskProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientData":
			err = unpopulate(val, "ClientData", &c.ClientData)
			delete(rawMsg, key)
		case "commands":
			c.Commands, err = unmarshalCommandPropertiesClassificationArray(val)
			delete(rawMsg, key)
		case "errors":
			err = unpopulate(val, "Errors", &c.Errors)
			delete(rawMsg, key)
		case "input":
			err = unpopulate(val, "Input", &c.Input)
			delete(rawMsg, key)
		case "output":
			err = unpopulate(val, "Output", &c.Output)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &c.State)
			delete(rawMsg, key)
		case "taskType":
			err = unpopulate(val, "TaskType", &c.TaskType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectToSourceMySQLTaskProperties.
func (c ConnectToSourceMySQLTaskProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "clientData", c.ClientData)
	populate(objectMap, "commands", c.Commands)
	populate(objectMap, "errors", c.Errors)
	populate(objectMap, "input", c.Input)
	populate(objectMap, "output", c.Output)
	populate(objectMap, "state", c.State)
	objectMap["taskType"] = "ConnectToSource.MySql"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectToSourceMySQLTaskProperties.
func (c *ConnectToSourceMySQLTaskProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientData":
			err = unpopulate(val, "ClientData", &c.ClientData)
			delete(rawMsg, key)
		case "commands":
			c.Commands, err = unmarshalCommandPropertiesClassificationArray(val)
			delete(rawMsg, key)
		case "errors":
			err = unpopulate(val, "Errors", &c.Errors)
			delete(rawMsg, key)
		case "input":
			err = unpopulate(val, "Input", &c.Input)
			delete(rawMsg, key)
		case "output":
			err = unpopulate(val, "Output", &c.Output)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &c.State)
			delete(rawMsg, key)
		case "taskType":
			err = unpopulate(val, "TaskType", &c.TaskType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectToSourceNonSQLTaskOutput.
func (c ConnectToSourceNonSQLTaskOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "databases", c.Databases)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "serverProperties", c.ServerProperties)
	populate(objectMap, "sourceServerBrandVersion", c.SourceServerBrandVersion)
	populate(objectMap, "validationErrors", c.ValidationErrors)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ConnectToSourceOracleSyncTaskOutput.
func (c ConnectToSourceOracleSyncTaskOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "databases", c.Databases)
	populate(objectMap, "sourceServerBrandVersion", c.SourceServerBrandVersion)
	populate(objectMap, "sourceServerVersion", c.SourceServerVersion)
	populate(objectMap, "validationErrors", c.ValidationErrors)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ConnectToSourceOracleSyncTaskProperties.
func (c ConnectToSourceOracleSyncTaskProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "clientData", c.ClientData)
	populate(objectMap, "commands", c.Commands)
	populate(objectMap, "errors", c.Errors)
	populate(objectMap, "input", c.Input)
	populate(objectMap, "output", c.Output)
	populate(objectMap, "state", c.State)
	objectMap["taskType"] = "ConnectToSource.Oracle.Sync"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectToSourceOracleSyncTaskProperties.
func (c *ConnectToSourceOracleSyncTaskProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientData":
			err = unpopulate(val, "ClientData", &c.ClientData)
			delete(rawMsg, key)
		case "commands":
			c.Commands, err = unmarshalCommandPropertiesClassificationArray(val)
			delete(rawMsg, key)
		case "errors":
			err = unpopulate(val, "Errors", &c.Errors)
			delete(rawMsg, key)
		case "input":
			err = unpopulate(val, "Input", &c.Input)
			delete(rawMsg, key)
		case "output":
			err = unpopulate(val, "Output", &c.Output)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &c.State)
			delete(rawMsg, key)
		case "taskType":
			err = unpopulate(val, "TaskType", &c.TaskType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectToSourcePostgreSQLSyncTaskOutput.
func (c ConnectToSourcePostgreSQLSyncTaskOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "databases", c.Databases)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "sourceServerBrandVersion", c.SourceServerBrandVersion)
	populate(objectMap, "sourceServerVersion", c.SourceServerVersion)
	populate(objectMap, "validationErrors", c.ValidationErrors)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ConnectToSourcePostgreSQLSyncTaskProperties.
func (c ConnectToSourcePostgreSQLSyncTaskProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "clientData", c.ClientData)
	populate(objectMap, "commands", c.Commands)
	populate(objectMap, "errors", c.Errors)
	populate(objectMap, "input", c.Input)
	populate(objectMap, "output", c.Output)
	populate(objectMap, "state", c.State)
	objectMap["taskType"] = "ConnectToSource.PostgreSql.Sync"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectToSourcePostgreSQLSyncTaskProperties.
func (c *ConnectToSourcePostgreSQLSyncTaskProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientData":
			err = unpopulate(val, "ClientData", &c.ClientData)
			delete(rawMsg, key)
		case "commands":
			c.Commands, err = unmarshalCommandPropertiesClassificationArray(val)
			delete(rawMsg, key)
		case "errors":
			err = unpopulate(val, "Errors", &c.Errors)
			delete(rawMsg, key)
		case "input":
			err = unpopulate(val, "Input", &c.Input)
			delete(rawMsg, key)
		case "output":
			err = unpopulate(val, "Output", &c.Output)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &c.State)
			delete(rawMsg, key)
		case "taskType":
			err = unpopulate(val, "TaskType", &c.TaskType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectToSourceSQLServerSyncTaskProperties.
func (c ConnectToSourceSQLServerSyncTaskProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "clientData", c.ClientData)
	populate(objectMap, "commands", c.Commands)
	populate(objectMap, "errors", c.Errors)
	populate(objectMap, "input", c.Input)
	populate(objectMap, "output", c.Output)
	populate(objectMap, "state", c.State)
	objectMap["taskType"] = "ConnectToSource.SqlServer.Sync"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectToSourceSQLServerSyncTaskProperties.
func (c *ConnectToSourceSQLServerSyncTaskProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientData":
			err = unpopulate(val, "ClientData", &c.ClientData)
			delete(rawMsg, key)
		case "commands":
			c.Commands, err = unmarshalCommandPropertiesClassificationArray(val)
			delete(rawMsg, key)
		case "errors":
			err = unpopulate(val, "Errors", &c.Errors)
			delete(rawMsg, key)
		case "input":
			err = unpopulate(val, "Input", &c.Input)
			delete(rawMsg, key)
		case "output":
			c.Output, err = unmarshalConnectToSourceSQLServerTaskOutputClassificationArray(val)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &c.State)
			delete(rawMsg, key)
		case "taskType":
			err = unpopulate(val, "TaskType", &c.TaskType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectToSourceSQLServerTaskOutputAgentJobLevel.
func (c ConnectToSourceSQLServerTaskOutputAgentJobLevel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", c.ID)
	populate(objectMap, "isEnabled", c.IsEnabled)
	populate(objectMap, "jobCategory", c.JobCategory)
	populate(objectMap, "jobOwner", c.JobOwner)
	populateTimeRFC3339(objectMap, "lastExecutedOn", c.LastExecutedOn)
	populate(objectMap, "migrationEligibility", c.MigrationEligibility)
	populate(objectMap, "name", c.Name)
	objectMap["resultType"] = "AgentJobLevelOutput"
	populate(objectMap, "validationErrors", c.ValidationErrors)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectToSourceSQLServerTaskOutputAgentJobLevel.
func (c *ConnectToSourceSQLServerTaskOutputAgentJobLevel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "isEnabled":
			err = unpopulate(val, "IsEnabled", &c.IsEnabled)
			delete(rawMsg, key)
		case "jobCategory":
			err = unpopulate(val, "JobCategory", &c.JobCategory)
			delete(rawMsg, key)
		case "jobOwner":
			err = unpopulate(val, "JobOwner", &c.JobOwner)
			delete(rawMsg, key)
		case "lastExecutedOn":
			err = unpopulateTimeRFC3339(val, "LastExecutedOn", &c.LastExecutedOn)
			delete(rawMsg, key)
		case "migrationEligibility":
			err = unpopulate(val, "MigrationEligibility", &c.MigrationEligibility)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "resultType":
			err = unpopulate(val, "ResultType", &c.ResultType)
			delete(rawMsg, key)
		case "validationErrors":
			err = unpopulate(val, "ValidationErrors", &c.ValidationErrors)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectToSourceSQLServerTaskOutputDatabaseLevel.
func (c ConnectToSourceSQLServerTaskOutputDatabaseLevel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "compatibilityLevel", c.CompatibilityLevel)
	populate(objectMap, "databaseFiles", c.DatabaseFiles)
	populate(objectMap, "databaseState", c.DatabaseState)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "name", c.Name)
	objectMap["resultType"] = "DatabaseLevelOutput"
	populate(objectMap, "sizeMB", c.SizeMB)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectToSourceSQLServerTaskOutputDatabaseLevel.
func (c *ConnectToSourceSQLServerTaskOutputDatabaseLevel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "compatibilityLevel":
			err = unpopulate(val, "CompatibilityLevel", &c.CompatibilityLevel)
			delete(rawMsg, key)
		case "databaseFiles":
			err = unpopulate(val, "DatabaseFiles", &c.DatabaseFiles)
			delete(rawMsg, key)
		case "databaseState":
			err = unpopulate(val, "DatabaseState", &c.DatabaseState)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "resultType":
			err = unpopulate(val, "ResultType", &c.ResultType)
			delete(rawMsg, key)
		case "sizeMB":
			err = unpopulate(val, "SizeMB", &c.SizeMB)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectToSourceSQLServerTaskOutputLoginLevel.
func (c ConnectToSourceSQLServerTaskOutputLoginLevel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "defaultDatabase", c.DefaultDatabase)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "isEnabled", c.IsEnabled)
	populate(objectMap, "loginType", c.LoginType)
	populate(objectMap, "migrationEligibility", c.MigrationEligibility)
	populate(objectMap, "name", c.Name)
	objectMap["resultType"] = "LoginLevelOutput"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectToSourceSQLServerTaskOutputLoginLevel.
func (c *ConnectToSourceSQLServerTaskOutputLoginLevel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "defaultDatabase":
			err = unpopulate(val, "DefaultDatabase", &c.DefaultDatabase)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "isEnabled":
			err = unpopulate(val, "IsEnabled", &c.IsEnabled)
			delete(rawMsg, key)
		case "loginType":
			err = unpopulate(val, "LoginType", &c.LoginType)
			delete(rawMsg, key)
		case "migrationEligibility":
			err = unpopulate(val, "MigrationEligibility", &c.MigrationEligibility)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "resultType":
			err = unpopulate(val, "ResultType", &c.ResultType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectToSourceSQLServerTaskOutputTaskLevel.
func (c ConnectToSourceSQLServerTaskOutputTaskLevel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "agentJobs", c.AgentJobs)
	populate(objectMap, "databaseTdeCertificateMapping", c.DatabaseTdeCertificateMapping)
	populate(objectMap, "databases", c.Databases)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "logins", c.Logins)
	objectMap["resultType"] = "TaskLevelOutput"
	populate(objectMap, "sourceServerBrandVersion", c.SourceServerBrandVersion)
	populate(objectMap, "sourceServerVersion", c.SourceServerVersion)
	populate(objectMap, "validationErrors", c.ValidationErrors)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectToSourceSQLServerTaskOutputTaskLevel.
func (c *ConnectToSourceSQLServerTaskOutputTaskLevel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "agentJobs":
			err = unpopulate(val, "AgentJobs", &c.AgentJobs)
			delete(rawMsg, key)
		case "databaseTdeCertificateMapping":
			err = unpopulate(val, "DatabaseTdeCertificateMapping", &c.DatabaseTdeCertificateMapping)
			delete(rawMsg, key)
		case "databases":
			err = unpopulate(val, "Databases", &c.Databases)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "logins":
			err = unpopulate(val, "Logins", &c.Logins)
			delete(rawMsg, key)
		case "resultType":
			err = unpopulate(val, "ResultType", &c.ResultType)
			delete(rawMsg, key)
		case "sourceServerBrandVersion":
			err = unpopulate(val, "SourceServerBrandVersion", &c.SourceServerBrandVersion)
			delete(rawMsg, key)
		case "sourceServerVersion":
			err = unpopulate(val, "SourceServerVersion", &c.SourceServerVersion)
			delete(rawMsg, key)
		case "validationErrors":
			err = unpopulate(val, "ValidationErrors", &c.ValidationErrors)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectToSourceSQLServerTaskProperties.
func (c ConnectToSourceSQLServerTaskProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "clientData", c.ClientData)
	populate(objectMap, "commands", c.Commands)
	populate(objectMap, "errors", c.Errors)
	populate(objectMap, "input", c.Input)
	populate(objectMap, "output", c.Output)
	populate(objectMap, "state", c.State)
	objectMap["taskType"] = "ConnectToSource.SqlServer"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectToSourceSQLServerTaskProperties.
func (c *ConnectToSourceSQLServerTaskProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientData":
			err = unpopulate(val, "ClientData", &c.ClientData)
			delete(rawMsg, key)
		case "commands":
			c.Commands, err = unmarshalCommandPropertiesClassificationArray(val)
			delete(rawMsg, key)
		case "errors":
			err = unpopulate(val, "Errors", &c.Errors)
			delete(rawMsg, key)
		case "input":
			err = unpopulate(val, "Input", &c.Input)
			delete(rawMsg, key)
		case "output":
			c.Output, err = unmarshalConnectToSourceSQLServerTaskOutputClassificationArray(val)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &c.State)
			delete(rawMsg, key)
		case "taskType":
			err = unpopulate(val, "TaskType", &c.TaskType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectToTargetAzureDbForMySQLTaskOutput.
func (c ConnectToTargetAzureDbForMySQLTaskOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "databases", c.Databases)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "serverVersion", c.ServerVersion)
	populate(objectMap, "targetServerBrandVersion", c.TargetServerBrandVersion)
	populate(objectMap, "validationErrors", c.ValidationErrors)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ConnectToTargetAzureDbForMySQLTaskProperties.
func (c ConnectToTargetAzureDbForMySQLTaskProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "clientData", c.ClientData)
	populate(objectMap, "commands", c.Commands)
	populate(objectMap, "errors", c.Errors)
	populate(objectMap, "input", c.Input)
	populate(objectMap, "output", c.Output)
	populate(objectMap, "state", c.State)
	objectMap["taskType"] = "ConnectToTarget.AzureDbForMySql"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectToTargetAzureDbForMySQLTaskProperties.
func (c *ConnectToTargetAzureDbForMySQLTaskProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientData":
			err = unpopulate(val, "ClientData", &c.ClientData)
			delete(rawMsg, key)
		case "commands":
			c.Commands, err = unmarshalCommandPropertiesClassificationArray(val)
			delete(rawMsg, key)
		case "errors":
			err = unpopulate(val, "Errors", &c.Errors)
			delete(rawMsg, key)
		case "input":
			err = unpopulate(val, "Input", &c.Input)
			delete(rawMsg, key)
		case "output":
			err = unpopulate(val, "Output", &c.Output)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &c.State)
			delete(rawMsg, key)
		case "taskType":
			err = unpopulate(val, "TaskType", &c.TaskType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectToTargetAzureDbForPostgreSQLSyncTaskOutput.
func (c ConnectToTargetAzureDbForPostgreSQLSyncTaskOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "databases", c.Databases)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "targetServerBrandVersion", c.TargetServerBrandVersion)
	populate(objectMap, "targetServerVersion", c.TargetServerVersion)
	populate(objectMap, "validationErrors", c.ValidationErrors)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties.
func (c ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "clientData", c.ClientData)
	populate(objectMap, "commands", c.Commands)
	populate(objectMap, "errors", c.Errors)
	populate(objectMap, "input", c.Input)
	populate(objectMap, "output", c.Output)
	populate(objectMap, "state", c.State)
	objectMap["taskType"] = "ConnectToTarget.AzureDbForPostgreSql.Sync"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties.
func (c *ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientData":
			err = unpopulate(val, "ClientData", &c.ClientData)
			delete(rawMsg, key)
		case "commands":
			c.Commands, err = unmarshalCommandPropertiesClassificationArray(val)
			delete(rawMsg, key)
		case "errors":
			err = unpopulate(val, "Errors", &c.Errors)
			delete(rawMsg, key)
		case "input":
			err = unpopulate(val, "Input", &c.Input)
			delete(rawMsg, key)
		case "output":
			err = unpopulate(val, "Output", &c.Output)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &c.State)
			delete(rawMsg, key)
		case "taskType":
			err = unpopulate(val, "TaskType", &c.TaskType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskOutput.
func (c ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "databaseSchemaMap", c.DatabaseSchemaMap)
	populate(objectMap, "databases", c.Databases)
	populate(objectMap, "targetServerBrandVersion", c.TargetServerBrandVersion)
	populate(objectMap, "targetServerVersion", c.TargetServerVersion)
	populate(objectMap, "validationErrors", c.ValidationErrors)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskOutputDatabaseSchemaMapItem.
func (c ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskOutputDatabaseSchemaMapItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "database", c.Database)
	populate(objectMap, "schemas", c.Schemas)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties.
func (c ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "clientData", c.ClientData)
	populate(objectMap, "commands", c.Commands)
	populate(objectMap, "errors", c.Errors)
	populate(objectMap, "input", c.Input)
	populate(objectMap, "output", c.Output)
	populate(objectMap, "state", c.State)
	objectMap["taskType"] = "ConnectToTarget.Oracle.AzureDbForPostgreSql.Sync"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties.
func (c *ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientData":
			err = unpopulate(val, "ClientData", &c.ClientData)
			delete(rawMsg, key)
		case "commands":
			c.Commands, err = unmarshalCommandPropertiesClassificationArray(val)
			delete(rawMsg, key)
		case "errors":
			err = unpopulate(val, "Errors", &c.Errors)
			delete(rawMsg, key)
		case "input":
			err = unpopulate(val, "Input", &c.Input)
			delete(rawMsg, key)
		case "output":
			err = unpopulate(val, "Output", &c.Output)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &c.State)
			delete(rawMsg, key)
		case "taskType":
			err = unpopulate(val, "TaskType", &c.TaskType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectToTargetSQLDbSyncTaskProperties.
func (c ConnectToTargetSQLDbSyncTaskProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "clientData", c.ClientData)
	populate(objectMap, "commands", c.Commands)
	populate(objectMap, "errors", c.Errors)
	populate(objectMap, "input", c.Input)
	populate(objectMap, "output", c.Output)
	populate(objectMap, "state", c.State)
	objectMap["taskType"] = "ConnectToTarget.SqlDb.Sync"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectToTargetSQLDbSyncTaskProperties.
func (c *ConnectToTargetSQLDbSyncTaskProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientData":
			err = unpopulate(val, "ClientData", &c.ClientData)
			delete(rawMsg, key)
		case "commands":
			c.Commands, err = unmarshalCommandPropertiesClassificationArray(val)
			delete(rawMsg, key)
		case "errors":
			err = unpopulate(val, "Errors", &c.Errors)
			delete(rawMsg, key)
		case "input":
			err = unpopulate(val, "Input", &c.Input)
			delete(rawMsg, key)
		case "output":
			err = unpopulate(val, "Output", &c.Output)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &c.State)
			delete(rawMsg, key)
		case "taskType":
			err = unpopulate(val, "TaskType", &c.TaskType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectToTargetSQLDbTaskProperties.
func (c ConnectToTargetSQLDbTaskProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "clientData", c.ClientData)
	populate(objectMap, "commands", c.Commands)
	populate(objectMap, "errors", c.Errors)
	populate(objectMap, "input", c.Input)
	populate(objectMap, "output", c.Output)
	populate(objectMap, "state", c.State)
	objectMap["taskType"] = "ConnectToTarget.SqlDb"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectToTargetSQLDbTaskProperties.
func (c *ConnectToTargetSQLDbTaskProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientData":
			err = unpopulate(val, "ClientData", &c.ClientData)
			delete(rawMsg, key)
		case "commands":
			c.Commands, err = unmarshalCommandPropertiesClassificationArray(val)
			delete(rawMsg, key)
		case "errors":
			err = unpopulate(val, "Errors", &c.Errors)
			delete(rawMsg, key)
		case "input":
			err = unpopulate(val, "Input", &c.Input)
			delete(rawMsg, key)
		case "output":
			err = unpopulate(val, "Output", &c.Output)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &c.State)
			delete(rawMsg, key)
		case "taskType":
			err = unpopulate(val, "TaskType", &c.TaskType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectToTargetSQLMISyncTaskOutput.
func (c ConnectToTargetSQLMISyncTaskOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "targetServerBrandVersion", c.TargetServerBrandVersion)
	populate(objectMap, "targetServerVersion", c.TargetServerVersion)
	populate(objectMap, "validationErrors", c.ValidationErrors)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ConnectToTargetSQLMISyncTaskProperties.
func (c ConnectToTargetSQLMISyncTaskProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "clientData", c.ClientData)
	populate(objectMap, "commands", c.Commands)
	populate(objectMap, "errors", c.Errors)
	populate(objectMap, "input", c.Input)
	populate(objectMap, "output", c.Output)
	populate(objectMap, "state", c.State)
	objectMap["taskType"] = "ConnectToTarget.AzureSqlDbMI.Sync.LRS"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectToTargetSQLMISyncTaskProperties.
func (c *ConnectToTargetSQLMISyncTaskProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientData":
			err = unpopulate(val, "ClientData", &c.ClientData)
			delete(rawMsg, key)
		case "commands":
			c.Commands, err = unmarshalCommandPropertiesClassificationArray(val)
			delete(rawMsg, key)
		case "errors":
			err = unpopulate(val, "Errors", &c.Errors)
			delete(rawMsg, key)
		case "input":
			err = unpopulate(val, "Input", &c.Input)
			delete(rawMsg, key)
		case "output":
			err = unpopulate(val, "Output", &c.Output)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &c.State)
			delete(rawMsg, key)
		case "taskType":
			err = unpopulate(val, "TaskType", &c.TaskType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectToTargetSQLMITaskOutput.
func (c ConnectToTargetSQLMITaskOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "agentJobs", c.AgentJobs)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "logins", c.Logins)
	populate(objectMap, "targetServerBrandVersion", c.TargetServerBrandVersion)
	populate(objectMap, "targetServerVersion", c.TargetServerVersion)
	populate(objectMap, "validationErrors", c.ValidationErrors)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ConnectToTargetSQLMITaskProperties.
func (c ConnectToTargetSQLMITaskProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "clientData", c.ClientData)
	populate(objectMap, "commands", c.Commands)
	populate(objectMap, "errors", c.Errors)
	populate(objectMap, "input", c.Input)
	populate(objectMap, "output", c.Output)
	populate(objectMap, "state", c.State)
	objectMap["taskType"] = "ConnectToTarget.AzureSqlDbMI"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectToTargetSQLMITaskProperties.
func (c *ConnectToTargetSQLMITaskProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientData":
			err = unpopulate(val, "ClientData", &c.ClientData)
			delete(rawMsg, key)
		case "commands":
			c.Commands, err = unmarshalCommandPropertiesClassificationArray(val)
			delete(rawMsg, key)
		case "errors":
			err = unpopulate(val, "Errors", &c.Errors)
			delete(rawMsg, key)
		case "input":
			err = unpopulate(val, "Input", &c.Input)
			delete(rawMsg, key)
		case "output":
			err = unpopulate(val, "Output", &c.Output)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &c.State)
			delete(rawMsg, key)
		case "taskType":
			err = unpopulate(val, "TaskType", &c.TaskType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataIntegrityValidationResult.
func (d DataIntegrityValidationResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "failedObjects", d.FailedObjects)
	populate(objectMap, "validationErrors", d.ValidationErrors)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataItemMigrationSummaryResult.
func (d *DataItemMigrationSummaryResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endedOn":
			err = unpopulateTimeRFC3339(val, "EndedOn", &d.EndedOn)
			delete(rawMsg, key)
		case "errorPrefix":
			err = unpopulate(val, "ErrorPrefix", &d.ErrorPrefix)
			delete(rawMsg, key)
		case "itemsCompletedCount":
			err = unpopulate(val, "ItemsCompletedCount", &d.ItemsCompletedCount)
			delete(rawMsg, key)
		case "itemsCount":
			err = unpopulate(val, "ItemsCount", &d.ItemsCount)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "resultPrefix":
			err = unpopulate(val, "ResultPrefix", &d.ResultPrefix)
			delete(rawMsg, key)
		case "startedOn":
			err = unpopulateTimeRFC3339(val, "StartedOn", &d.StartedOn)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &d.State)
			delete(rawMsg, key)
		case "statusMessage":
			err = unpopulate(val, "StatusMessage", &d.StatusMessage)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DatabaseBackupInfo.
func (d DatabaseBackupInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "backupFiles", d.BackupFiles)
	populateTimeRFC3339(objectMap, "backupFinishDate", d.BackupFinishDate)
	populate(objectMap, "backupType", d.BackupType)
	populate(objectMap, "databaseName", d.DatabaseName)
	populate(objectMap, "familyCount", d.FamilyCount)
	populate(objectMap, "isCompressed", d.IsCompressed)
	populate(objectMap, "isDamaged", d.IsDamaged)
	populate(objectMap, "position", d.Position)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DatabaseBackupInfo.
func (d *DatabaseBackupInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupFiles":
			err = unpopulate(val, "BackupFiles", &d.BackupFiles)
			delete(rawMsg, key)
		case "backupFinishDate":
			err = unpopulateTimeRFC3339(val, "BackupFinishDate", &d.BackupFinishDate)
			delete(rawMsg, key)
		case "backupType":
			err = unpopulate(val, "BackupType", &d.BackupType)
			delete(rawMsg, key)
		case "databaseName":
			err = unpopulate(val, "DatabaseName", &d.DatabaseName)
			delete(rawMsg, key)
		case "familyCount":
			err = unpopulate(val, "FamilyCount", &d.FamilyCount)
			delete(rawMsg, key)
		case "isCompressed":
			err = unpopulate(val, "IsCompressed", &d.IsCompressed)
			delete(rawMsg, key)
		case "isDamaged":
			err = unpopulate(val, "IsDamaged", &d.IsDamaged)
			delete(rawMsg, key)
		case "position":
			err = unpopulate(val, "Position", &d.Position)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DatabaseSummaryResult.
func (d *DatabaseSummaryResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endedOn":
			err = unpopulateTimeRFC3339(val, "EndedOn", &d.EndedOn)
			delete(rawMsg, key)
		case "errorPrefix":
			err = unpopulate(val, "ErrorPrefix", &d.ErrorPrefix)
			delete(rawMsg, key)
		case "itemsCompletedCount":
			err = unpopulate(val, "ItemsCompletedCount", &d.ItemsCompletedCount)
			delete(rawMsg, key)
		case "itemsCount":
			err = unpopulate(val, "ItemsCount", &d.ItemsCount)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "resultPrefix":
			err = unpopulate(val, "ResultPrefix", &d.ResultPrefix)
			delete(rawMsg, key)
		case "sizeMB":
			err = unpopulate(val, "SizeMB", &d.SizeMB)
			delete(rawMsg, key)
		case "startedOn":
			err = unpopulateTimeRFC3339(val, "StartedOn", &d.StartedOn)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &d.State)
			delete(rawMsg, key)
		case "statusMessage":
			err = unpopulate(val, "StatusMessage", &d.StatusMessage)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExecutionStatistics.
func (e ExecutionStatistics) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "cpuTimeMs", e.CPUTimeMs)
	populate(objectMap, "elapsedTimeMs", e.ElapsedTimeMs)
	populate(objectMap, "executionCount", e.ExecutionCount)
	populate(objectMap, "hasErrors", e.HasErrors)
	populate(objectMap, "sqlErrors", e.SQLErrors)
	populate(objectMap, "waitStats", e.WaitStats)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type GetTdeCertificatesSQLTaskInput.
func (g GetTdeCertificatesSQLTaskInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "backupFileShare", g.BackupFileShare)
	populate(objectMap, "connectionInfo", g.ConnectionInfo)
	populate(objectMap, "selectedCertificates", g.SelectedCertificates)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type GetTdeCertificatesSQLTaskOutput.
func (g GetTdeCertificatesSQLTaskOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "base64EncodedCertificates", g.Base64EncodedCertificates)
	populate(objectMap, "validationErrors", g.ValidationErrors)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type GetTdeCertificatesSQLTaskProperties.
func (g GetTdeCertificatesSQLTaskProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "clientData", g.ClientData)
	populate(objectMap, "commands", g.Commands)
	populate(objectMap, "errors", g.Errors)
	populate(objectMap, "input", g.Input)
	populate(objectMap, "output", g.Output)
	populate(objectMap, "state", g.State)
	objectMap["taskType"] = "GetTDECertificates.Sql"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GetTdeCertificatesSQLTaskProperties.
func (g *GetTdeCertificatesSQLTaskProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientData":
			err = unpopulate(val, "ClientData", &g.ClientData)
			delete(rawMsg, key)
		case "commands":
			g.Commands, err = unmarshalCommandPropertiesClassificationArray(val)
			delete(rawMsg, key)
		case "errors":
			err = unpopulate(val, "Errors", &g.Errors)
			delete(rawMsg, key)
		case "input":
			err = unpopulate(val, "Input", &g.Input)
			delete(rawMsg, key)
		case "output":
			err = unpopulate(val, "Output", &g.Output)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &g.State)
			delete(rawMsg, key)
		case "taskType":
			err = unpopulate(val, "TaskType", &g.TaskType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GetUserTablesMySQLTaskInput.
func (g GetUserTablesMySQLTaskInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "connectionInfo", g.ConnectionInfo)
	populate(objectMap, "selectedDatabases", g.SelectedDatabases)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type GetUserTablesMySQLTaskOutput.
func (g GetUserTablesMySQLTaskOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "databasesToTables", g.DatabasesToTables)
	populate(objectMap, "id", g.ID)
	populate(objectMap, "validationErrors", g.ValidationErrors)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type GetUserTablesMySQLTaskProperties.
func (g GetUserTablesMySQLTaskProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "clientData", g.ClientData)
	populate(objectMap, "commands", g.Commands)
	populate(objectMap, "errors", g.Errors)
	populate(objectMap, "input", g.Input)
	populate(objectMap, "output", g.Output)
	populate(objectMap, "state", g.State)
	objectMap["taskType"] = "GetUserTablesMySql"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GetUserTablesMySQLTaskProperties.
func (g *GetUserTablesMySQLTaskProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientData":
			err = unpopulate(val, "ClientData", &g.ClientData)
			delete(rawMsg, key)
		case "commands":
			g.Commands, err = unmarshalCommandPropertiesClassificationArray(val)
			delete(rawMsg, key)
		case "errors":
			err = unpopulate(val, "Errors", &g.Errors)
			delete(rawMsg, key)
		case "input":
			err = unpopulate(val, "Input", &g.Input)
			delete(rawMsg, key)
		case "output":
			err = unpopulate(val, "Output", &g.Output)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &g.State)
			delete(rawMsg, key)
		case "taskType":
			err = unpopulate(val, "TaskType", &g.TaskType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GetUserTablesOracleTaskInput.
func (g GetUserTablesOracleTaskInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "connectionInfo", g.ConnectionInfo)
	populate(objectMap, "selectedSchemas", g.SelectedSchemas)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type GetUserTablesOracleTaskOutput.
func (g GetUserTablesOracleTaskOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "schemaName", g.SchemaName)
	populate(objectMap, "tables", g.Tables)
	populate(objectMap, "validationErrors", g.ValidationErrors)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type GetUserTablesOracleTaskProperties.
func (g GetUserTablesOracleTaskProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "clientData", g.ClientData)
	populate(objectMap, "commands", g.Commands)
	populate(objectMap, "errors", g.Errors)
	populate(objectMap, "input", g.Input)
	populate(objectMap, "output", g.Output)
	populate(objectMap, "state", g.State)
	objectMap["taskType"] = "GetUserTablesOracle"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GetUserTablesOracleTaskProperties.
func (g *GetUserTablesOracleTaskProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientData":
			err = unpopulate(val, "ClientData", &g.ClientData)
			delete(rawMsg, key)
		case "commands":
			g.Commands, err = unmarshalCommandPropertiesClassificationArray(val)
			delete(rawMsg, key)
		case "errors":
			err = unpopulate(val, "Errors", &g.Errors)
			delete(rawMsg, key)
		case "input":
			err = unpopulate(val, "Input", &g.Input)
			delete(rawMsg, key)
		case "output":
			err = unpopulate(val, "Output", &g.Output)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &g.State)
			delete(rawMsg, key)
		case "taskType":
			err = unpopulate(val, "TaskType", &g.TaskType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GetUserTablesPostgreSQLTaskInput.
func (g GetUserTablesPostgreSQLTaskInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "connectionInfo", g.ConnectionInfo)
	populate(objectMap, "selectedDatabases", g.SelectedDatabases)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type GetUserTablesPostgreSQLTaskOutput.
func (g GetUserTablesPostgreSQLTaskOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "databaseName", g.DatabaseName)
	populate(objectMap, "tables", g.Tables)
	populate(objectMap, "validationErrors", g.ValidationErrors)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type GetUserTablesPostgreSQLTaskProperties.
func (g GetUserTablesPostgreSQLTaskProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "clientData", g.ClientData)
	populate(objectMap, "commands", g.Commands)
	populate(objectMap, "errors", g.Errors)
	populate(objectMap, "input", g.Input)
	populate(objectMap, "output", g.Output)
	populate(objectMap, "state", g.State)
	objectMap["taskType"] = "GetUserTablesPostgreSql"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GetUserTablesPostgreSQLTaskProperties.
func (g *GetUserTablesPostgreSQLTaskProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientData":
			err = unpopulate(val, "ClientData", &g.ClientData)
			delete(rawMsg, key)
		case "commands":
			g.Commands, err = unmarshalCommandPropertiesClassificationArray(val)
			delete(rawMsg, key)
		case "errors":
			err = unpopulate(val, "Errors", &g.Errors)
			delete(rawMsg, key)
		case "input":
			err = unpopulate(val, "Input", &g.Input)
			delete(rawMsg, key)
		case "output":
			err = unpopulate(val, "Output", &g.Output)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &g.State)
			delete(rawMsg, key)
		case "taskType":
			err = unpopulate(val, "TaskType", &g.TaskType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GetUserTablesSQLSyncTaskInput.
func (g GetUserTablesSQLSyncTaskInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "selectedSourceDatabases", g.SelectedSourceDatabases)
	populate(objectMap, "selectedTargetDatabases", g.SelectedTargetDatabases)
	populate(objectMap, "sourceConnectionInfo", g.SourceConnectionInfo)
	populate(objectMap, "targetConnectionInfo", g.TargetConnectionInfo)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type GetUserTablesSQLSyncTaskOutput.
func (g GetUserTablesSQLSyncTaskOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "databasesToSourceTables", g.DatabasesToSourceTables)
	populate(objectMap, "databasesToTargetTables", g.DatabasesToTargetTables)
	populate(objectMap, "tableValidationErrors", g.TableValidationErrors)
	populate(objectMap, "validationErrors", g.ValidationErrors)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type GetUserTablesSQLSyncTaskProperties.
func (g GetUserTablesSQLSyncTaskProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "clientData", g.ClientData)
	populate(objectMap, "commands", g.Commands)
	populate(objectMap, "errors", g.Errors)
	populate(objectMap, "input", g.Input)
	populate(objectMap, "output", g.Output)
	populate(objectMap, "state", g.State)
	objectMap["taskType"] = "GetUserTables.AzureSqlDb.Sync"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GetUserTablesSQLSyncTaskProperties.
func (g *GetUserTablesSQLSyncTaskProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientData":
			err = unpopulate(val, "ClientData", &g.ClientData)
			delete(rawMsg, key)
		case "commands":
			g.Commands, err = unmarshalCommandPropertiesClassificationArray(val)
			delete(rawMsg, key)
		case "errors":
			err = unpopulate(val, "Errors", &g.Errors)
			delete(rawMsg, key)
		case "input":
			err = unpopulate(val, "Input", &g.Input)
			delete(rawMsg, key)
		case "output":
			err = unpopulate(val, "Output", &g.Output)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &g.State)
			delete(rawMsg, key)
		case "taskType":
			err = unpopulate(val, "TaskType", &g.TaskType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GetUserTablesSQLTaskInput.
func (g GetUserTablesSQLTaskInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "connectionInfo", g.ConnectionInfo)
	populate(objectMap, "selectedDatabases", g.SelectedDatabases)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type GetUserTablesSQLTaskOutput.
func (g GetUserTablesSQLTaskOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "databasesToTables", g.DatabasesToTables)
	populate(objectMap, "id", g.ID)
	populate(objectMap, "validationErrors", g.ValidationErrors)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type GetUserTablesSQLTaskProperties.
func (g GetUserTablesSQLTaskProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "clientData", g.ClientData)
	populate(objectMap, "commands", g.Commands)
	populate(objectMap, "errors", g.Errors)
	populate(objectMap, "input", g.Input)
	populate(objectMap, "output", g.Output)
	populate(objectMap, "state", g.State)
	objectMap["taskType"] = "GetUserTables.Sql"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GetUserTablesSQLTaskProperties.
func (g *GetUserTablesSQLTaskProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientData":
			err = unpopulate(val, "ClientData", &g.ClientData)
			delete(rawMsg, key)
		case "commands":
			g.Commands, err = unmarshalCommandPropertiesClassificationArray(val)
			delete(rawMsg, key)
		case "errors":
			err = unpopulate(val, "Errors", &g.Errors)
			delete(rawMsg, key)
		case "input":
			err = unpopulate(val, "Input", &g.Input)
			delete(rawMsg, key)
		case "output":
			err = unpopulate(val, "Output", &g.Output)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &g.State)
			delete(rawMsg, key)
		case "taskType":
			err = unpopulate(val, "TaskType", &g.TaskType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InstallOCIDriverTaskOutput.
func (i InstallOCIDriverTaskOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "validationErrors", i.ValidationErrors)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type InstallOCIDriverTaskProperties.
func (i InstallOCIDriverTaskProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "clientData", i.ClientData)
	populate(objectMap, "commands", i.Commands)
	populate(objectMap, "errors", i.Errors)
	populate(objectMap, "input", i.Input)
	populate(objectMap, "output", i.Output)
	populate(objectMap, "state", i.State)
	objectMap["taskType"] = "Service.Install.OCI"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InstallOCIDriverTaskProperties.
func (i *InstallOCIDriverTaskProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientData":
			err = unpopulate(val, "ClientData", &i.ClientData)
			delete(rawMsg, key)
		case "commands":
			i.Commands, err = unmarshalCommandPropertiesClassificationArray(val)
			delete(rawMsg, key)
		case "errors":
			err = unpopulate(val, "Errors", &i.Errors)
			delete(rawMsg, key)
		case "input":
			err = unpopulate(val, "Input", &i.Input)
			delete(rawMsg, key)
		case "output":
			err = unpopulate(val, "Output", &i.Output)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &i.State)
			delete(rawMsg, key)
		case "taskType":
			err = unpopulate(val, "TaskType", &i.TaskType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MiSQLConnectionInfo.
func (m MiSQLConnectionInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "managedInstanceResourceId", m.ManagedInstanceResourceID)
	populate(objectMap, "password", m.Password)
	objectMap["type"] = "MiSqlConnectionInfo"
	populate(objectMap, "userName", m.UserName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MiSQLConnectionInfo.
func (m *MiSQLConnectionInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "managedInstanceResourceId":
			err = unpopulate(val, "ManagedInstanceResourceID", &m.ManagedInstanceResourceID)
			delete(rawMsg, key)
		case "password":
			err = unpopulate(val, "Password", &m.Password)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		case "userName":
			err = unpopulate(val, "UserName", &m.UserName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrateMISyncCompleteCommandOutput.
func (m MigrateMISyncCompleteCommandOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "errors", m.Errors)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type MigrateMISyncCompleteCommandProperties.
func (m MigrateMISyncCompleteCommandProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["commandType"] = "Migrate.SqlServer.AzureDbSqlMi.Complete"
	populate(objectMap, "errors", m.Errors)
	populate(objectMap, "input", m.Input)
	populate(objectMap, "output", m.Output)
	populate(objectMap, "state", m.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrateMISyncCompleteCommandProperties.
func (m *MigrateMISyncCompleteCommandProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "commandType":
			err = unpopulate(val, "CommandType", &m.CommandType)
			delete(rawMsg, key)
		case "errors":
			err = unpopulate(val, "Errors", &m.Errors)
			delete(rawMsg, key)
		case "input":
			err = unpopulate(val, "Input", &m.Input)
			delete(rawMsg, key)
		case "output":
			err = unpopulate(val, "Output", &m.Output)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &m.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrateMongoDbTaskProperties.
func (m MigrateMongoDbTaskProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "clientData", m.ClientData)
	populate(objectMap, "commands", m.Commands)
	populate(objectMap, "errors", m.Errors)
	populate(objectMap, "input", m.Input)
	populate(objectMap, "output", m.Output)
	populate(objectMap, "state", m.State)
	objectMap["taskType"] = "Migrate.MongoDb"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrateMongoDbTaskProperties.
func (m *MigrateMongoDbTaskProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientData":
			err = unpopulate(val, "ClientData", &m.ClientData)
			delete(rawMsg, key)
		case "commands":
			m.Commands, err = unmarshalCommandPropertiesClassificationArray(val)
			delete(rawMsg, key)
		case "errors":
			err = unpopulate(val, "Errors", &m.Errors)
			delete(rawMsg, key)
		case "input":
			err = unpopulate(val, "Input", &m.Input)
			delete(rawMsg, key)
		case "output":
			m.Output, err = unmarshalMongoDbProgressClassificationArray(val)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &m.State)
			delete(rawMsg, key)
		case "taskType":
			err = unpopulate(val, "TaskType", &m.TaskType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrateMySQLAzureDbForMySQLOfflineDatabaseInput.
func (m MigrateMySQLAzureDbForMySQLOfflineDatabaseInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "name", m.Name)
	populate(objectMap, "tableMap", m.TableMap)
	populate(objectMap, "targetDatabaseName", m.TargetDatabaseName)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type MigrateMySQLAzureDbForMySQLOfflineTaskInput.
func (m MigrateMySQLAzureDbForMySQLOfflineTaskInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "makeSourceServerReadOnly", m.MakeSourceServerReadOnly)
	populate(objectMap, "optionalAgentSettings", m.OptionalAgentSettings)
	populate(objectMap, "selectedDatabases", m.SelectedDatabases)
	populate(objectMap, "sourceConnectionInfo", m.SourceConnectionInfo)
	populateTimeRFC3339(objectMap, "startedOn", m.StartedOn)
	populate(objectMap, "targetConnectionInfo", m.TargetConnectionInfo)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrateMySQLAzureDbForMySQLOfflineTaskInput.
func (m *MigrateMySQLAzureDbForMySQLOfflineTaskInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "makeSourceServerReadOnly":
			err = unpopulate(val, "MakeSourceServerReadOnly", &m.MakeSourceServerReadOnly)
			delete(rawMsg, key)
		case "optionalAgentSettings":
			err = unpopulate(val, "OptionalAgentSettings", &m.OptionalAgentSettings)
			delete(rawMsg, key)
		case "selectedDatabases":
			err = unpopulate(val, "SelectedDatabases", &m.SelectedDatabases)
			delete(rawMsg, key)
		case "sourceConnectionInfo":
			err = unpopulate(val, "SourceConnectionInfo", &m.SourceConnectionInfo)
			delete(rawMsg, key)
		case "startedOn":
			err = unpopulateTimeRFC3339(val, "StartedOn", &m.StartedOn)
			delete(rawMsg, key)
		case "targetConnectionInfo":
			err = unpopulate(val, "TargetConnectionInfo", &m.TargetConnectionInfo)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrateMySQLAzureDbForMySQLOfflineTaskOutputDatabaseLevel.
func (m MigrateMySQLAzureDbForMySQLOfflineTaskOutputDatabaseLevel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "databaseName", m.DatabaseName)
	populateTimeRFC3339(objectMap, "endedOn", m.EndedOn)
	populate(objectMap, "errorCount", m.ErrorCount)
	populate(objectMap, "errorPrefix", m.ErrorPrefix)
	populate(objectMap, "exceptionsAndWarnings", m.ExceptionsAndWarnings)
	populate(objectMap, "id", m.ID)
	populateTimeRFC3339(objectMap, "lastStorageUpdate", m.LastStorageUpdate)
	populate(objectMap, "message", m.Message)
	populate(objectMap, "numberOfObjects", m.NumberOfObjects)
	populate(objectMap, "numberOfObjectsCompleted", m.NumberOfObjectsCompleted)
	populate(objectMap, "objectSummary", m.ObjectSummary)
	populate(objectMap, "resultPrefix", m.ResultPrefix)
	objectMap["resultType"] = "DatabaseLevelOutput"
	populate(objectMap, "stage", m.Stage)
	populateTimeRFC3339(objectMap, "startedOn", m.StartedOn)
	populate(objectMap, "state", m.State)
	populate(objectMap, "statusMessage", m.StatusMessage)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrateMySQLAzureDbForMySQLOfflineTaskOutputDatabaseLevel.
func (m *MigrateMySQLAzureDbForMySQLOfflineTaskOutputDatabaseLevel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "databaseName":
			err = unpopulate(val, "DatabaseName", &m.DatabaseName)
			delete(rawMsg, key)
		case "endedOn":
			err = unpopulateTimeRFC3339(val, "EndedOn", &m.EndedOn)
			delete(rawMsg, key)
		case "errorCount":
			err = unpopulate(val, "ErrorCount", &m.ErrorCount)
			delete(rawMsg, key)
		case "errorPrefix":
			err = unpopulate(val, "ErrorPrefix", &m.ErrorPrefix)
			delete(rawMsg, key)
		case "exceptionsAndWarnings":
			err = unpopulate(val, "ExceptionsAndWarnings", &m.ExceptionsAndWarnings)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "lastStorageUpdate":
			err = unpopulateTimeRFC3339(val, "LastStorageUpdate", &m.LastStorageUpdate)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &m.Message)
			delete(rawMsg, key)
		case "numberOfObjects":
			err = unpopulate(val, "NumberOfObjects", &m.NumberOfObjects)
			delete(rawMsg, key)
		case "numberOfObjectsCompleted":
			err = unpopulate(val, "NumberOfObjectsCompleted", &m.NumberOfObjectsCompleted)
			delete(rawMsg, key)
		case "objectSummary":
			err = unpopulate(val, "ObjectSummary", &m.ObjectSummary)
			delete(rawMsg, key)
		case "resultPrefix":
			err = unpopulate(val, "ResultPrefix", &m.ResultPrefix)
			delete(rawMsg, key)
		case "resultType":
			err = unpopulate(val, "ResultType", &m.ResultType)
			delete(rawMsg, key)
		case "stage":
			err = unpopulate(val, "Stage", &m.Stage)
			delete(rawMsg, key)
		case "startedOn":
			err = unpopulateTimeRFC3339(val, "StartedOn", &m.StartedOn)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &m.State)
			delete(rawMsg, key)
		case "statusMessage":
			err = unpopulate(val, "StatusMessage", &m.StatusMessage)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrateMySQLAzureDbForMySQLOfflineTaskOutputError.
func (m MigrateMySQLAzureDbForMySQLOfflineTaskOutputError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "error", m.Error)
	populate(objectMap, "id", m.ID)
	objectMap["resultType"] = "ErrorOutput"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrateMySQLAzureDbForMySQLOfflineTaskOutputError.
func (m *MigrateMySQLAzureDbForMySQLOfflineTaskOutputError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &m.Error)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "resultType":
			err = unpopulate(val, "ResultType", &m.ResultType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrateMySQLAzureDbForMySQLOfflineTaskOutputMigrationLevel.
func (m MigrateMySQLAzureDbForMySQLOfflineTaskOutputMigrationLevel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "databaseSummary", m.DatabaseSummary)
	populate(objectMap, "databases", m.Databases)
	populate(objectMap, "durationInSeconds", m.DurationInSeconds)
	populateTimeRFC3339(objectMap, "endedOn", m.EndedOn)
	populate(objectMap, "exceptionsAndWarnings", m.ExceptionsAndWarnings)
	populate(objectMap, "id", m.ID)
	populateTimeRFC3339(objectMap, "lastStorageUpdate", m.LastStorageUpdate)
	populate(objectMap, "message", m.Message)
	populate(objectMap, "migrationReportResult", m.MigrationReportResult)
	objectMap["resultType"] = "MigrationLevelOutput"
	populate(objectMap, "sourceServerBrandVersion", m.SourceServerBrandVersion)
	populate(objectMap, "sourceServerVersion", m.SourceServerVersion)
	populateTimeRFC3339(objectMap, "startedOn", m.StartedOn)
	populate(objectMap, "status", m.Status)
	populate(objectMap, "statusMessage", m.StatusMessage)
	populate(objectMap, "targetServerBrandVersion", m.TargetServerBrandVersion)
	populate(objectMap, "targetServerVersion", m.TargetServerVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrateMySQLAzureDbForMySQLOfflineTaskOutputMigrationLevel.
func (m *MigrateMySQLAzureDbForMySQLOfflineTaskOutputMigrationLevel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "databaseSummary":
			err = unpopulate(val, "DatabaseSummary", &m.DatabaseSummary)
			delete(rawMsg, key)
		case "databases":
			err = unpopulate(val, "Databases", &m.Databases)
			delete(rawMsg, key)
		case "durationInSeconds":
			err = unpopulate(val, "DurationInSeconds", &m.DurationInSeconds)
			delete(rawMsg, key)
		case "endedOn":
			err = unpopulateTimeRFC3339(val, "EndedOn", &m.EndedOn)
			delete(rawMsg, key)
		case "exceptionsAndWarnings":
			err = unpopulate(val, "ExceptionsAndWarnings", &m.ExceptionsAndWarnings)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "lastStorageUpdate":
			err = unpopulateTimeRFC3339(val, "LastStorageUpdate", &m.LastStorageUpdate)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &m.Message)
			delete(rawMsg, key)
		case "migrationReportResult":
			err = unpopulate(val, "MigrationReportResult", &m.MigrationReportResult)
			delete(rawMsg, key)
		case "resultType":
			err = unpopulate(val, "ResultType", &m.ResultType)
			delete(rawMsg, key)
		case "sourceServerBrandVersion":
			err = unpopulate(val, "SourceServerBrandVersion", &m.SourceServerBrandVersion)
			delete(rawMsg, key)
		case "sourceServerVersion":
			err = unpopulate(val, "SourceServerVersion", &m.SourceServerVersion)
			delete(rawMsg, key)
		case "startedOn":
			err = unpopulateTimeRFC3339(val, "StartedOn", &m.StartedOn)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &m.Status)
			delete(rawMsg, key)
		case "statusMessage":
			err = unpopulate(val, "StatusMessage", &m.StatusMessage)
			delete(rawMsg, key)
		case "targetServerBrandVersion":
			err = unpopulate(val, "TargetServerBrandVersion", &m.TargetServerBrandVersion)
			delete(rawMsg, key)
		case "targetServerVersion":
			err = unpopulate(val, "TargetServerVersion", &m.TargetServerVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrateMySQLAzureDbForMySQLOfflineTaskOutputTableLevel.
func (m MigrateMySQLAzureDbForMySQLOfflineTaskOutputTableLevel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "endedOn", m.EndedOn)
	populate(objectMap, "errorPrefix", m.ErrorPrefix)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "itemsCompletedCount", m.ItemsCompletedCount)
	populate(objectMap, "itemsCount", m.ItemsCount)
	populateTimeRFC3339(objectMap, "lastStorageUpdate", m.LastStorageUpdate)
	populate(objectMap, "objectName", m.ObjectName)
	populate(objectMap, "resultPrefix", m.ResultPrefix)
	objectMap["resultType"] = "TableLevelOutput"
	populateTimeRFC3339(objectMap, "startedOn", m.StartedOn)
	populate(objectMap, "state", m.State)
	populate(objectMap, "statusMessage", m.StatusMessage)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrateMySQLAzureDbForMySQLOfflineTaskOutputTableLevel.
func (m *MigrateMySQLAzureDbForMySQLOfflineTaskOutputTableLevel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endedOn":
			err = unpopulateTimeRFC3339(val, "EndedOn", &m.EndedOn)
			delete(rawMsg, key)
		case "errorPrefix":
			err = unpopulate(val, "ErrorPrefix", &m.ErrorPrefix)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "itemsCompletedCount":
			err = unpopulate(val, "ItemsCompletedCount", &m.ItemsCompletedCount)
			delete(rawMsg, key)
		case "itemsCount":
			err = unpopulate(val, "ItemsCount", &m.ItemsCount)
			delete(rawMsg, key)
		case "lastStorageUpdate":
			err = unpopulateTimeRFC3339(val, "LastStorageUpdate", &m.LastStorageUpdate)
			delete(rawMsg, key)
		case "objectName":
			err = unpopulate(val, "ObjectName", &m.ObjectName)
			delete(rawMsg, key)
		case "resultPrefix":
			err = unpopulate(val, "ResultPrefix", &m.ResultPrefix)
			delete(rawMsg, key)
		case "resultType":
			err = unpopulate(val, "ResultType", &m.ResultType)
			delete(rawMsg, key)
		case "startedOn":
			err = unpopulateTimeRFC3339(val, "StartedOn", &m.StartedOn)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &m.State)
			delete(rawMsg, key)
		case "statusMessage":
			err = unpopulate(val, "StatusMessage", &m.StatusMessage)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrateMySQLAzureDbForMySQLOfflineTaskProperties.
func (m MigrateMySQLAzureDbForMySQLOfflineTaskProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "clientData", m.ClientData)
	populate(objectMap, "commands", m.Commands)
	populate(objectMap, "errors", m.Errors)
	populate(objectMap, "input", m.Input)
	populate(objectMap, "output", m.Output)
	populate(objectMap, "state", m.State)
	objectMap["taskType"] = "Migrate.MySql.AzureDbForMySql"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrateMySQLAzureDbForMySQLOfflineTaskProperties.
func (m *MigrateMySQLAzureDbForMySQLOfflineTaskProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientData":
			err = unpopulate(val, "ClientData", &m.ClientData)
			delete(rawMsg, key)
		case "commands":
			m.Commands, err = unmarshalCommandPropertiesClassificationArray(val)
			delete(rawMsg, key)
		case "errors":
			err = unpopulate(val, "Errors", &m.Errors)
			delete(rawMsg, key)
		case "input":
			err = unpopulate(val, "Input", &m.Input)
			delete(rawMsg, key)
		case "output":
			m.Output, err = unmarshalMigrateMySQLAzureDbForMySQLOfflineTaskOutputClassificationArray(val)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &m.State)
			delete(rawMsg, key)
		case "taskType":
			err = unpopulate(val, "TaskType", &m.TaskType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrateMySQLAzureDbForMySQLSyncDatabaseInput.
func (m MigrateMySQLAzureDbForMySQLSyncDatabaseInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "migrationSetting", m.MigrationSetting)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "sourceSetting", m.SourceSetting)
	populate(objectMap, "tableMap", m.TableMap)
	populate(objectMap, "targetDatabaseName", m.TargetDatabaseName)
	populate(objectMap, "targetSetting", m.TargetSetting)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type MigrateMySQLAzureDbForMySQLSyncTaskInput.
func (m MigrateMySQLAzureDbForMySQLSyncTaskInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "selectedDatabases", m.SelectedDatabases)
	populate(objectMap, "sourceConnectionInfo", m.SourceConnectionInfo)
	populate(objectMap, "targetConnectionInfo", m.TargetConnectionInfo)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError.
func (m MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "errorMessage", m.ErrorMessage)
	populate(objectMap, "events", m.Events)
	populate(objectMap, "id", m.ID)
	objectMap["resultType"] = "DatabaseLevelErrorOutput"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError.
func (m *MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "errorMessage":
			err = unpopulate(val, "ErrorMessage", &m.ErrorMessage)
			delete(rawMsg, key)
		case "events":
			err = unpopulate(val, "Events", &m.Events)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "resultType":
			err = unpopulate(val, "ResultType", &m.ResultType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel.
func (m MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "appliedChanges", m.AppliedChanges)
	populate(objectMap, "cdcDeleteCounter", m.CdcDeleteCounter)
	populate(objectMap, "cdcInsertCounter", m.CdcInsertCounter)
	populate(objectMap, "cdcUpdateCounter", m.CdcUpdateCounter)
	populate(objectMap, "databaseName", m.DatabaseName)
	populateTimeRFC3339(objectMap, "endedOn", m.EndedOn)
	populate(objectMap, "fullLoadCompletedTables", m.FullLoadCompletedTables)
	populate(objectMap, "fullLoadErroredTables", m.FullLoadErroredTables)
	populate(objectMap, "fullLoadLoadingTables", m.FullLoadLoadingTables)
	populate(objectMap, "fullLoadQueuedTables", m.FullLoadQueuedTables)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "incomingChanges", m.IncomingChanges)
	populate(objectMap, "initializationCompleted", m.InitializationCompleted)
	populate(objectMap, "latency", m.Latency)
	populate(objectMap, "migrationState", m.MigrationState)
	objectMap["resultType"] = "DatabaseLevelOutput"
	populateTimeRFC3339(objectMap, "startedOn", m.StartedOn)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel.
func (m *MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appliedChanges":
			err = unpopulate(val, "AppliedChanges", &m.AppliedChanges)
			delete(rawMsg, key)
		case "cdcDeleteCounter":
			err = unpopulate(val, "CdcDeleteCounter", &m.CdcDeleteCounter)
			delete(rawMsg, key)
		case "cdcInsertCounter":
			err = unpopulate(val, "CdcInsertCounter", &m.CdcInsertCounter)
			delete(rawMsg, key)
		case "cdcUpdateCounter":
			err = unpopulate(val, "CdcUpdateCounter", &m.CdcUpdateCounter)
			delete(rawMsg, key)
		case "databaseName":
			err = unpopulate(val, "DatabaseName", &m.DatabaseName)
			delete(rawMsg, key)
		case "endedOn":
			err = unpopulateTimeRFC3339(val, "EndedOn", &m.EndedOn)
			delete(rawMsg, key)
		case "fullLoadCompletedTables":
			err = unpopulate(val, "FullLoadCompletedTables", &m.FullLoadCompletedTables)
			delete(rawMsg, key)
		case "fullLoadErroredTables":
			err = unpopulate(val, "FullLoadErroredTables", &m.FullLoadErroredTables)
			delete(rawMsg, key)
		case "fullLoadLoadingTables":
			err = unpopulate(val, "FullLoadLoadingTables", &m.FullLoadLoadingTables)
			delete(rawMsg, key)
		case "fullLoadQueuedTables":
			err = unpopulate(val, "FullLoadQueuedTables", &m.FullLoadQueuedTables)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "incomingChanges":
			err = unpopulate(val, "IncomingChanges", &m.IncomingChanges)
			delete(rawMsg, key)
		case "initializationCompleted":
			err = unpopulate(val, "InitializationCompleted", &m.InitializationCompleted)
			delete(rawMsg, key)
		case "latency":
			err = unpopulate(val, "Latency", &m.Latency)
			delete(rawMsg, key)
		case "migrationState":
			err = unpopulate(val, "MigrationState", &m.MigrationState)
			delete(rawMsg, key)
		case "resultType":
			err = unpopulate(val, "ResultType", &m.ResultType)
			delete(rawMsg, key)
		case "startedOn":
			err = unpopulateTimeRFC3339(val, "StartedOn", &m.StartedOn)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrateMySQLAzureDbForMySQLSyncTaskOutputError.
func (m MigrateMySQLAzureDbForMySQLSyncTaskOutputError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "error", m.Error)
	populate(objectMap, "id", m.ID)
	objectMap["resultType"] = "ErrorOutput"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrateMySQLAzureDbForMySQLSyncTaskOutputError.
func (m *MigrateMySQLAzureDbForMySQLSyncTaskOutputError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &m.Error)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "resultType":
			err = unpopulate(val, "ResultType", &m.ResultType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel.
func (m MigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "endedOn", m.EndedOn)
	populate(objectMap, "id", m.ID)
	objectMap["resultType"] = "MigrationLevelOutput"
	populate(objectMap, "sourceServer", m.SourceServer)
	populate(objectMap, "sourceServerVersion", m.SourceServerVersion)
	populateTimeRFC3339(objectMap, "startedOn", m.StartedOn)
	populate(objectMap, "targetServer", m.TargetServer)
	populate(objectMap, "targetServerVersion", m.TargetServerVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel.
func (m *MigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endedOn":
			err = unpopulateTimeRFC3339(val, "EndedOn", &m.EndedOn)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "resultType":
			err = unpopulate(val, "ResultType", &m.ResultType)
			delete(rawMsg, key)
		case "sourceServer":
			err = unpopulate(val, "SourceServer", &m.SourceServer)
			delete(rawMsg, key)
		case "sourceServerVersion":
			err = unpopulate(val, "SourceServerVersion", &m.SourceServerVersion)
			delete(rawMsg, key)
		case "startedOn":
			err = unpopulateTimeRFC3339(val, "StartedOn", &m.StartedOn)
			delete(rawMsg, key)
		case "targetServer":
			err = unpopulate(val, "TargetServer", &m.TargetServer)
			delete(rawMsg, key)
		case "targetServerVersion":
			err = unpopulate(val, "TargetServerVersion", &m.TargetServerVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel.
func (m MigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "cdcDeleteCounter", m.CdcDeleteCounter)
	populate(objectMap, "cdcInsertCounter", m.CdcInsertCounter)
	populate(objectMap, "cdcUpdateCounter", m.CdcUpdateCounter)
	populate(objectMap, "dataErrorsCounter", m.DataErrorsCounter)
	populate(objectMap, "databaseName", m.DatabaseName)
	populateTimeRFC3339(objectMap, "fullLoadEndedOn", m.FullLoadEndedOn)
	populateTimeRFC3339(objectMap, "fullLoadEstFinishTime", m.FullLoadEstFinishTime)
	populateTimeRFC3339(objectMap, "fullLoadStartedOn", m.FullLoadStartedOn)
	populate(objectMap, "fullLoadTotalRows", m.FullLoadTotalRows)
	populate(objectMap, "id", m.ID)
	populateTimeRFC3339(objectMap, "lastModifiedTime", m.LastModifiedTime)
	objectMap["resultType"] = "TableLevelOutput"
	populate(objectMap, "state", m.State)
	populate(objectMap, "tableName", m.TableName)
	populate(objectMap, "totalChangesApplied", m.TotalChangesApplied)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel.
func (m *MigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cdcDeleteCounter":
			err = unpopulate(val, "CdcDeleteCounter", &m.CdcDeleteCounter)
			delete(rawMsg, key)
		case "cdcInsertCounter":
			err = unpopulate(val, "CdcInsertCounter", &m.CdcInsertCounter)
			delete(rawMsg, key)
		case "cdcUpdateCounter":
			err = unpopulate(val, "CdcUpdateCounter", &m.CdcUpdateCounter)
			delete(rawMsg, key)
		case "dataErrorsCounter":
			err = unpopulate(val, "DataErrorsCounter", &m.DataErrorsCounter)
			delete(rawMsg, key)
		case "databaseName":
			err = unpopulate(val, "DatabaseName", &m.DatabaseName)
			delete(rawMsg, key)
		case "fullLoadEndedOn":
			err = unpopulateTimeRFC3339(val, "FullLoadEndedOn", &m.FullLoadEndedOn)
			delete(rawMsg, key)
		case "fullLoadEstFinishTime":
			err = unpopulateTimeRFC3339(val, "FullLoadEstFinishTime", &m.FullLoadEstFinishTime)
			delete(rawMsg, key)
		case "fullLoadStartedOn":
			err = unpopulateTimeRFC3339(val, "FullLoadStartedOn", &m.FullLoadStartedOn)
			delete(rawMsg, key)
		case "fullLoadTotalRows":
			err = unpopulate(val, "FullLoadTotalRows", &m.FullLoadTotalRows)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "lastModifiedTime":
			err = unpopulateTimeRFC3339(val, "LastModifiedTime", &m.LastModifiedTime)
			delete(rawMsg, key)
		case "resultType":
			err = unpopulate(val, "ResultType", &m.ResultType)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &m.State)
			delete(rawMsg, key)
		case "tableName":
			err = unpopulate(val, "TableName", &m.TableName)
			delete(rawMsg, key)
		case "totalChangesApplied":
			err = unpopulate(val, "TotalChangesApplied", &m.TotalChangesApplied)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrateMySQLAzureDbForMySQLSyncTaskProperties.
func (m MigrateMySQLAzureDbForMySQLSyncTaskProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "clientData", m.ClientData)
	populate(objectMap, "commands", m.Commands)
	populate(objectMap, "errors", m.Errors)
	populate(objectMap, "input", m.Input)
	populate(objectMap, "output", m.Output)
	populate(objectMap, "state", m.State)
	objectMap["taskType"] = "Migrate.MySql.AzureDbForMySql.Sync"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrateMySQLAzureDbForMySQLSyncTaskProperties.
func (m *MigrateMySQLAzureDbForMySQLSyncTaskProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientData":
			err = unpopulate(val, "ClientData", &m.ClientData)
			delete(rawMsg, key)
		case "commands":
			m.Commands, err = unmarshalCommandPropertiesClassificationArray(val)
			delete(rawMsg, key)
		case "errors":
			err = unpopulate(val, "Errors", &m.Errors)
			delete(rawMsg, key)
		case "input":
			err = unpopulate(val, "Input", &m.Input)
			delete(rawMsg, key)
		case "output":
			m.Output, err = unmarshalMigrateMySQLAzureDbForMySQLSyncTaskOutputClassificationArray(val)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &m.State)
			delete(rawMsg, key)
		case "taskType":
			err = unpopulate(val, "TaskType", &m.TaskType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrateOracleAzureDbForPostgreSQLSyncTaskProperties.
func (m MigrateOracleAzureDbForPostgreSQLSyncTaskProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "clientData", m.ClientData)
	populate(objectMap, "commands", m.Commands)
	populate(objectMap, "errors", m.Errors)
	populate(objectMap, "input", m.Input)
	populate(objectMap, "output", m.Output)
	populate(objectMap, "state", m.State)
	objectMap["taskType"] = "Migrate.Oracle.AzureDbForPostgreSql.Sync"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrateOracleAzureDbForPostgreSQLSyncTaskProperties.
func (m *MigrateOracleAzureDbForPostgreSQLSyncTaskProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientData":
			err = unpopulate(val, "ClientData", &m.ClientData)
			delete(rawMsg, key)
		case "commands":
			m.Commands, err = unmarshalCommandPropertiesClassificationArray(val)
			delete(rawMsg, key)
		case "errors":
			err = unpopulate(val, "Errors", &m.Errors)
			delete(rawMsg, key)
		case "input":
			err = unpopulate(val, "Input", &m.Input)
			delete(rawMsg, key)
		case "output":
			m.Output, err = unmarshalMigrateOracleAzureDbPostgreSQLSyncTaskOutputClassificationArray(val)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &m.State)
			delete(rawMsg, key)
		case "taskType":
			err = unpopulate(val, "TaskType", &m.TaskType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrateOracleAzureDbPostgreSQLSyncDatabaseInput.
func (m MigrateOracleAzureDbPostgreSQLSyncDatabaseInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "caseManipulation", m.CaseManipulation)
	populate(objectMap, "migrationSetting", m.MigrationSetting)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "schemaName", m.SchemaName)
	populate(objectMap, "sourceSetting", m.SourceSetting)
	populate(objectMap, "tableMap", m.TableMap)
	populate(objectMap, "targetDatabaseName", m.TargetDatabaseName)
	populate(objectMap, "targetSetting", m.TargetSetting)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type MigrateOracleAzureDbPostgreSQLSyncTaskInput.
func (m MigrateOracleAzureDbPostgreSQLSyncTaskInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "selectedDatabases", m.SelectedDatabases)
	populate(objectMap, "sourceConnectionInfo", m.SourceConnectionInfo)
	populate(objectMap, "targetConnectionInfo", m.TargetConnectionInfo)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseError.
func (m MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "errorMessage", m.ErrorMessage)
	populate(objectMap, "events", m.Events)
	populate(objectMap, "id", m.ID)
	objectMap["resultType"] = "DatabaseLevelErrorOutput"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseError.
func (m *MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "errorMessage":
			err = unpopulate(val, "ErrorMessage", &m.ErrorMessage)
			delete(rawMsg, key)
		case "events":
			err = unpopulate(val, "Events", &m.Events)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "resultType":
			err = unpopulate(val, "ResultType", &m.ResultType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseLevel.
func (m MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseLevel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "appliedChanges", m.AppliedChanges)
	populate(objectMap, "cdcDeleteCounter", m.CdcDeleteCounter)
	populate(objectMap, "cdcInsertCounter", m.CdcInsertCounter)
	populate(objectMap, "cdcUpdateCounter", m.CdcUpdateCounter)
	populate(objectMap, "databaseName", m.DatabaseName)
	populateTimeRFC3339(objectMap, "endedOn", m.EndedOn)
	populate(objectMap, "fullLoadCompletedTables", m.FullLoadCompletedTables)
	populate(objectMap, "fullLoadErroredTables", m.FullLoadErroredTables)
	populate(objectMap, "fullLoadLoadingTables", m.FullLoadLoadingTables)
	populate(objectMap, "fullLoadQueuedTables", m.FullLoadQueuedTables)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "incomingChanges", m.IncomingChanges)
	populate(objectMap, "initializationCompleted", m.InitializationCompleted)
	populate(objectMap, "latency", m.Latency)
	populate(objectMap, "migrationState", m.MigrationState)
	objectMap["resultType"] = "DatabaseLevelOutput"
	populateTimeRFC3339(objectMap, "startedOn", m.StartedOn)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseLevel.
func (m *MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseLevel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appliedChanges":
			err = unpopulate(val, "AppliedChanges", &m.AppliedChanges)
			delete(rawMsg, key)
		case "cdcDeleteCounter":
			err = unpopulate(val, "CdcDeleteCounter", &m.CdcDeleteCounter)
			delete(rawMsg, key)
		case "cdcInsertCounter":
			err = unpopulate(val, "CdcInsertCounter", &m.CdcInsertCounter)
			delete(rawMsg, key)
		case "cdcUpdateCounter":
			err = unpopulate(val, "CdcUpdateCounter", &m.CdcUpdateCounter)
			delete(rawMsg, key)
		case "databaseName":
			err = unpopulate(val, "DatabaseName", &m.DatabaseName)
			delete(rawMsg, key)
		case "endedOn":
			err = unpopulateTimeRFC3339(val, "EndedOn", &m.EndedOn)
			delete(rawMsg, key)
		case "fullLoadCompletedTables":
			err = unpopulate(val, "FullLoadCompletedTables", &m.FullLoadCompletedTables)
			delete(rawMsg, key)
		case "fullLoadErroredTables":
			err = unpopulate(val, "FullLoadErroredTables", &m.FullLoadErroredTables)
			delete(rawMsg, key)
		case "fullLoadLoadingTables":
			err = unpopulate(val, "FullLoadLoadingTables", &m.FullLoadLoadingTables)
			delete(rawMsg, key)
		case "fullLoadQueuedTables":
			err = unpopulate(val, "FullLoadQueuedTables", &m.FullLoadQueuedTables)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "incomingChanges":
			err = unpopulate(val, "IncomingChanges", &m.IncomingChanges)
			delete(rawMsg, key)
		case "initializationCompleted":
			err = unpopulate(val, "InitializationCompleted", &m.InitializationCompleted)
			delete(rawMsg, key)
		case "latency":
			err = unpopulate(val, "Latency", &m.Latency)
			delete(rawMsg, key)
		case "migrationState":
			err = unpopulate(val, "MigrationState", &m.MigrationState)
			delete(rawMsg, key)
		case "resultType":
			err = unpopulate(val, "ResultType", &m.ResultType)
			delete(rawMsg, key)
		case "startedOn":
			err = unpopulateTimeRFC3339(val, "StartedOn", &m.StartedOn)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrateOracleAzureDbPostgreSQLSyncTaskOutputError.
func (m MigrateOracleAzureDbPostgreSQLSyncTaskOutputError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "error", m.Error)
	populate(objectMap, "id", m.ID)
	objectMap["resultType"] = "ErrorOutput"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrateOracleAzureDbPostgreSQLSyncTaskOutputError.
func (m *MigrateOracleAzureDbPostgreSQLSyncTaskOutputError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &m.Error)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "resultType":
			err = unpopulate(val, "ResultType", &m.ResultType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrateOracleAzureDbPostgreSQLSyncTaskOutputMigrationLevel.
func (m MigrateOracleAzureDbPostgreSQLSyncTaskOutputMigrationLevel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "endedOn", m.EndedOn)
	populate(objectMap, "id", m.ID)
	objectMap["resultType"] = "MigrationLevelOutput"
	populate(objectMap, "sourceServer", m.SourceServer)
	populate(objectMap, "sourceServerVersion", m.SourceServerVersion)
	populateTimeRFC3339(objectMap, "startedOn", m.StartedOn)
	populate(objectMap, "targetServer", m.TargetServer)
	populate(objectMap, "targetServerVersion", m.TargetServerVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrateOracleAzureDbPostgreSQLSyncTaskOutputMigrationLevel.
func (m *MigrateOracleAzureDbPostgreSQLSyncTaskOutputMigrationLevel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endedOn":
			err = unpopulateTimeRFC3339(val, "EndedOn", &m.EndedOn)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "resultType":
			err = unpopulate(val, "ResultType", &m.ResultType)
			delete(rawMsg, key)
		case "sourceServer":
			err = unpopulate(val, "SourceServer", &m.SourceServer)
			delete(rawMsg, key)
		case "sourceServerVersion":
			err = unpopulate(val, "SourceServerVersion", &m.SourceServerVersion)
			delete(rawMsg, key)
		case "startedOn":
			err = unpopulateTimeRFC3339(val, "StartedOn", &m.StartedOn)
			delete(rawMsg, key)
		case "targetServer":
			err = unpopulate(val, "TargetServer", &m.TargetServer)
			delete(rawMsg, key)
		case "targetServerVersion":
			err = unpopulate(val, "TargetServerVersion", &m.TargetServerVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrateOracleAzureDbPostgreSQLSyncTaskOutputTableLevel.
func (m MigrateOracleAzureDbPostgreSQLSyncTaskOutputTableLevel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "cdcDeleteCounter", m.CdcDeleteCounter)
	populate(objectMap, "cdcInsertCounter", m.CdcInsertCounter)
	populate(objectMap, "cdcUpdateCounter", m.CdcUpdateCounter)
	populate(objectMap, "dataErrorsCounter", m.DataErrorsCounter)
	populate(objectMap, "databaseName", m.DatabaseName)
	populateTimeRFC3339(objectMap, "fullLoadEndedOn", m.FullLoadEndedOn)
	populateTimeRFC3339(objectMap, "fullLoadEstFinishTime", m.FullLoadEstFinishTime)
	populateTimeRFC3339(objectMap, "fullLoadStartedOn", m.FullLoadStartedOn)
	populate(objectMap, "fullLoadTotalRows", m.FullLoadTotalRows)
	populate(objectMap, "id", m.ID)
	populateTimeRFC3339(objectMap, "lastModifiedTime", m.LastModifiedTime)
	objectMap["resultType"] = "TableLevelOutput"
	populate(objectMap, "state", m.State)
	populate(objectMap, "tableName", m.TableName)
	populate(objectMap, "totalChangesApplied", m.TotalChangesApplied)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrateOracleAzureDbPostgreSQLSyncTaskOutputTableLevel.
func (m *MigrateOracleAzureDbPostgreSQLSyncTaskOutputTableLevel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cdcDeleteCounter":
			err = unpopulate(val, "CdcDeleteCounter", &m.CdcDeleteCounter)
			delete(rawMsg, key)
		case "cdcInsertCounter":
			err = unpopulate(val, "CdcInsertCounter", &m.CdcInsertCounter)
			delete(rawMsg, key)
		case "cdcUpdateCounter":
			err = unpopulate(val, "CdcUpdateCounter", &m.CdcUpdateCounter)
			delete(rawMsg, key)
		case "dataErrorsCounter":
			err = unpopulate(val, "DataErrorsCounter", &m.DataErrorsCounter)
			delete(rawMsg, key)
		case "databaseName":
			err = unpopulate(val, "DatabaseName", &m.DatabaseName)
			delete(rawMsg, key)
		case "fullLoadEndedOn":
			err = unpopulateTimeRFC3339(val, "FullLoadEndedOn", &m.FullLoadEndedOn)
			delete(rawMsg, key)
		case "fullLoadEstFinishTime":
			err = unpopulateTimeRFC3339(val, "FullLoadEstFinishTime", &m.FullLoadEstFinishTime)
			delete(rawMsg, key)
		case "fullLoadStartedOn":
			err = unpopulateTimeRFC3339(val, "FullLoadStartedOn", &m.FullLoadStartedOn)
			delete(rawMsg, key)
		case "fullLoadTotalRows":
			err = unpopulate(val, "FullLoadTotalRows", &m.FullLoadTotalRows)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "lastModifiedTime":
			err = unpopulateTimeRFC3339(val, "LastModifiedTime", &m.LastModifiedTime)
			delete(rawMsg, key)
		case "resultType":
			err = unpopulate(val, "ResultType", &m.ResultType)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &m.State)
			delete(rawMsg, key)
		case "tableName":
			err = unpopulate(val, "TableName", &m.TableName)
			delete(rawMsg, key)
		case "totalChangesApplied":
			err = unpopulate(val, "TotalChangesApplied", &m.TotalChangesApplied)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigratePostgreSQLAzureDbForPostgreSQLSyncDatabaseInput.
func (m MigratePostgreSQLAzureDbForPostgreSQLSyncDatabaseInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "migrationSetting", m.MigrationSetting)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "selectedTables", m.SelectedTables)
	populate(objectMap, "sourceSetting", m.SourceSetting)
	populate(objectMap, "targetDatabaseName", m.TargetDatabaseName)
	populate(objectMap, "targetSetting", m.TargetSetting)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskInput.
func (m MigratePostgreSQLAzureDbForPostgreSQLSyncTaskInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "selectedDatabases", m.SelectedDatabases)
	populate(objectMap, "sourceConnectionInfo", m.SourceConnectionInfo)
	populate(objectMap, "targetConnectionInfo", m.TargetConnectionInfo)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError.
func (m MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "errorMessage", m.ErrorMessage)
	populate(objectMap, "events", m.Events)
	populate(objectMap, "id", m.ID)
	objectMap["resultType"] = "DatabaseLevelErrorOutput"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError.
func (m *MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "errorMessage":
			err = unpopulate(val, "ErrorMessage", &m.ErrorMessage)
			delete(rawMsg, key)
		case "events":
			err = unpopulate(val, "Events", &m.Events)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "resultType":
			err = unpopulate(val, "ResultType", &m.ResultType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel.
func (m MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "appliedChanges", m.AppliedChanges)
	populate(objectMap, "cdcDeleteCounter", m.CdcDeleteCounter)
	populate(objectMap, "cdcInsertCounter", m.CdcInsertCounter)
	populate(objectMap, "cdcUpdateCounter", m.CdcUpdateCounter)
	populate(objectMap, "databaseName", m.DatabaseName)
	populateTimeRFC3339(objectMap, "endedOn", m.EndedOn)
	populate(objectMap, "fullLoadCompletedTables", m.FullLoadCompletedTables)
	populate(objectMap, "fullLoadErroredTables", m.FullLoadErroredTables)
	populate(objectMap, "fullLoadLoadingTables", m.FullLoadLoadingTables)
	populate(objectMap, "fullLoadQueuedTables", m.FullLoadQueuedTables)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "incomingChanges", m.IncomingChanges)
	populate(objectMap, "initializationCompleted", m.InitializationCompleted)
	populate(objectMap, "latency", m.Latency)
	populate(objectMap, "migrationState", m.MigrationState)
	objectMap["resultType"] = "DatabaseLevelOutput"
	populateTimeRFC3339(objectMap, "startedOn", m.StartedOn)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel.
func (m *MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appliedChanges":
			err = unpopulate(val, "AppliedChanges", &m.AppliedChanges)
			delete(rawMsg, key)
		case "cdcDeleteCounter":
			err = unpopulate(val, "CdcDeleteCounter", &m.CdcDeleteCounter)
			delete(rawMsg, key)
		case "cdcInsertCounter":
			err = unpopulate(val, "CdcInsertCounter", &m.CdcInsertCounter)
			delete(rawMsg, key)
		case "cdcUpdateCounter":
			err = unpopulate(val, "CdcUpdateCounter", &m.CdcUpdateCounter)
			delete(rawMsg, key)
		case "databaseName":
			err = unpopulate(val, "DatabaseName", &m.DatabaseName)
			delete(rawMsg, key)
		case "endedOn":
			err = unpopulateTimeRFC3339(val, "EndedOn", &m.EndedOn)
			delete(rawMsg, key)
		case "fullLoadCompletedTables":
			err = unpopulate(val, "FullLoadCompletedTables", &m.FullLoadCompletedTables)
			delete(rawMsg, key)
		case "fullLoadErroredTables":
			err = unpopulate(val, "FullLoadErroredTables", &m.FullLoadErroredTables)
			delete(rawMsg, key)
		case "fullLoadLoadingTables":
			err = unpopulate(val, "FullLoadLoadingTables", &m.FullLoadLoadingTables)
			delete(rawMsg, key)
		case "fullLoadQueuedTables":
			err = unpopulate(val, "FullLoadQueuedTables", &m.FullLoadQueuedTables)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "incomingChanges":
			err = unpopulate(val, "IncomingChanges", &m.IncomingChanges)
			delete(rawMsg, key)
		case "initializationCompleted":
			err = unpopulate(val, "InitializationCompleted", &m.InitializationCompleted)
			delete(rawMsg, key)
		case "latency":
			err = unpopulate(val, "Latency", &m.Latency)
			delete(rawMsg, key)
		case "migrationState":
			err = unpopulate(val, "MigrationState", &m.MigrationState)
			delete(rawMsg, key)
		case "resultType":
			err = unpopulate(val, "ResultType", &m.ResultType)
			delete(rawMsg, key)
		case "startedOn":
			err = unpopulateTimeRFC3339(val, "StartedOn", &m.StartedOn)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError.
func (m MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "error", m.Error)
	populate(objectMap, "id", m.ID)
	objectMap["resultType"] = "ErrorOutput"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError.
func (m *MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &m.Error)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "resultType":
			err = unpopulate(val, "ResultType", &m.ResultType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel.
func (m MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "endedOn", m.EndedOn)
	populate(objectMap, "id", m.ID)
	objectMap["resultType"] = "MigrationLevelOutput"
	populate(objectMap, "sourceServer", m.SourceServer)
	populate(objectMap, "sourceServerType", m.SourceServerType)
	populate(objectMap, "sourceServerVersion", m.SourceServerVersion)
	populateTimeRFC3339(objectMap, "startedOn", m.StartedOn)
	populate(objectMap, "state", m.State)
	populate(objectMap, "targetServer", m.TargetServer)
	populate(objectMap, "targetServerType", m.TargetServerType)
	populate(objectMap, "targetServerVersion", m.TargetServerVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel.
func (m *MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endedOn":
			err = unpopulateTimeRFC3339(val, "EndedOn", &m.EndedOn)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "resultType":
			err = unpopulate(val, "ResultType", &m.ResultType)
			delete(rawMsg, key)
		case "sourceServer":
			err = unpopulate(val, "SourceServer", &m.SourceServer)
			delete(rawMsg, key)
		case "sourceServerType":
			err = unpopulate(val, "SourceServerType", &m.SourceServerType)
			delete(rawMsg, key)
		case "sourceServerVersion":
			err = unpopulate(val, "SourceServerVersion", &m.SourceServerVersion)
			delete(rawMsg, key)
		case "startedOn":
			err = unpopulateTimeRFC3339(val, "StartedOn", &m.StartedOn)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &m.State)
			delete(rawMsg, key)
		case "targetServer":
			err = unpopulate(val, "TargetServer", &m.TargetServer)
			delete(rawMsg, key)
		case "targetServerType":
			err = unpopulate(val, "TargetServerType", &m.TargetServerType)
			delete(rawMsg, key)
		case "targetServerVersion":
			err = unpopulate(val, "TargetServerVersion", &m.TargetServerVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel.
func (m MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "cdcDeleteCounter", m.CdcDeleteCounter)
	populate(objectMap, "cdcInsertCounter", m.CdcInsertCounter)
	populate(objectMap, "cdcUpdateCounter", m.CdcUpdateCounter)
	populate(objectMap, "dataErrorsCounter", m.DataErrorsCounter)
	populate(objectMap, "databaseName", m.DatabaseName)
	populateTimeRFC3339(objectMap, "fullLoadEndedOn", m.FullLoadEndedOn)
	populateTimeRFC3339(objectMap, "fullLoadEstFinishTime", m.FullLoadEstFinishTime)
	populateTimeRFC3339(objectMap, "fullLoadStartedOn", m.FullLoadStartedOn)
	populate(objectMap, "fullLoadTotalRows", m.FullLoadTotalRows)
	populate(objectMap, "id", m.ID)
	populateTimeRFC3339(objectMap, "lastModifiedTime", m.LastModifiedTime)
	objectMap["resultType"] = "TableLevelOutput"
	populate(objectMap, "state", m.State)
	populate(objectMap, "tableName", m.TableName)
	populate(objectMap, "totalChangesApplied", m.TotalChangesApplied)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel.
func (m *MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cdcDeleteCounter":
			err = unpopulate(val, "CdcDeleteCounter", &m.CdcDeleteCounter)
			delete(rawMsg, key)
		case "cdcInsertCounter":
			err = unpopulate(val, "CdcInsertCounter", &m.CdcInsertCounter)
			delete(rawMsg, key)
		case "cdcUpdateCounter":
			err = unpopulate(val, "CdcUpdateCounter", &m.CdcUpdateCounter)
			delete(rawMsg, key)
		case "dataErrorsCounter":
			err = unpopulate(val, "DataErrorsCounter", &m.DataErrorsCounter)
			delete(rawMsg, key)
		case "databaseName":
			err = unpopulate(val, "DatabaseName", &m.DatabaseName)
			delete(rawMsg, key)
		case "fullLoadEndedOn":
			err = unpopulateTimeRFC3339(val, "FullLoadEndedOn", &m.FullLoadEndedOn)
			delete(rawMsg, key)
		case "fullLoadEstFinishTime":
			err = unpopulateTimeRFC3339(val, "FullLoadEstFinishTime", &m.FullLoadEstFinishTime)
			delete(rawMsg, key)
		case "fullLoadStartedOn":
			err = unpopulateTimeRFC3339(val, "FullLoadStartedOn", &m.FullLoadStartedOn)
			delete(rawMsg, key)
		case "fullLoadTotalRows":
			err = unpopulate(val, "FullLoadTotalRows", &m.FullLoadTotalRows)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "lastModifiedTime":
			err = unpopulateTimeRFC3339(val, "LastModifiedTime", &m.LastModifiedTime)
			delete(rawMsg, key)
		case "resultType":
			err = unpopulate(val, "ResultType", &m.ResultType)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &m.State)
			delete(rawMsg, key)
		case "tableName":
			err = unpopulate(val, "TableName", &m.TableName)
			delete(rawMsg, key)
		case "totalChangesApplied":
			err = unpopulate(val, "TotalChangesApplied", &m.TotalChangesApplied)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties.
func (m MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "clientData", m.ClientData)
	populate(objectMap, "commands", m.Commands)
	populate(objectMap, "errors", m.Errors)
	populate(objectMap, "input", m.Input)
	populate(objectMap, "output", m.Output)
	populate(objectMap, "state", m.State)
	objectMap["taskType"] = "Migrate.PostgreSql.AzureDbForPostgreSql.SyncV2"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties.
func (m *MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientData":
			err = unpopulate(val, "ClientData", &m.ClientData)
			delete(rawMsg, key)
		case "commands":
			m.Commands, err = unmarshalCommandPropertiesClassificationArray(val)
			delete(rawMsg, key)
		case "errors":
			err = unpopulate(val, "Errors", &m.Errors)
			delete(rawMsg, key)
		case "input":
			err = unpopulate(val, "Input", &m.Input)
			delete(rawMsg, key)
		case "output":
			m.Output, err = unmarshalMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputClassificationArray(val)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &m.State)
			delete(rawMsg, key)
		case "taskType":
			err = unpopulate(val, "TaskType", &m.TaskType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrateSQLServerSQLDbDatabaseInput.
func (m MigrateSQLServerSQLDbDatabaseInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "makeSourceDbReadOnly", m.MakeSourceDbReadOnly)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "tableMap", m.TableMap)
	populate(objectMap, "targetDatabaseName", m.TargetDatabaseName)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type MigrateSQLServerSQLDbSyncDatabaseInput.
func (m MigrateSQLServerSQLDbSyncDatabaseInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", m.ID)
	populate(objectMap, "migrationSetting", m.MigrationSetting)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "schemaName", m.SchemaName)
	populate(objectMap, "sourceSetting", m.SourceSetting)
	populate(objectMap, "tableMap", m.TableMap)
	populate(objectMap, "targetDatabaseName", m.TargetDatabaseName)
	populate(objectMap, "targetSetting", m.TargetSetting)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type MigrateSQLServerSQLDbSyncTaskInput.
func (m MigrateSQLServerSQLDbSyncTaskInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "selectedDatabases", m.SelectedDatabases)
	populate(objectMap, "sourceConnectionInfo", m.SourceConnectionInfo)
	populate(objectMap, "targetConnectionInfo", m.TargetConnectionInfo)
	populate(objectMap, "validationOptions", m.ValidationOptions)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type MigrateSQLServerSQLDbSyncTaskOutputDatabaseError.
func (m MigrateSQLServerSQLDbSyncTaskOutputDatabaseError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "errorMessage", m.ErrorMessage)
	populate(objectMap, "events", m.Events)
	populate(objectMap, "id", m.ID)
	objectMap["resultType"] = "DatabaseLevelErrorOutput"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrateSQLServerSQLDbSyncTaskOutputDatabaseError.
func (m *MigrateSQLServerSQLDbSyncTaskOutputDatabaseError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "errorMessage":
			err = unpopulate(val, "ErrorMessage", &m.ErrorMessage)
			delete(rawMsg, key)
		case "events":
			err = unpopulate(val, "Events", &m.Events)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "resultType":
			err = unpopulate(val, "ResultType", &m.ResultType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel.
func (m MigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "appliedChanges", m.AppliedChanges)
	populate(objectMap, "cdcDeleteCounter", m.CdcDeleteCounter)
	populate(objectMap, "cdcInsertCounter", m.CdcInsertCounter)
	populate(objectMap, "cdcUpdateCounter", m.CdcUpdateCounter)
	populate(objectMap, "databaseName", m.DatabaseName)
	populateTimeRFC3339(objectMap, "endedOn", m.EndedOn)
	populate(objectMap, "fullLoadCompletedTables", m.FullLoadCompletedTables)
	populate(objectMap, "fullLoadErroredTables", m.FullLoadErroredTables)
	populate(objectMap, "fullLoadLoadingTables", m.FullLoadLoadingTables)
	populate(objectMap, "fullLoadQueuedTables", m.FullLoadQueuedTables)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "incomingChanges", m.IncomingChanges)
	populate(objectMap, "initializationCompleted", m.InitializationCompleted)
	populate(objectMap, "latency", m.Latency)
	populate(objectMap, "migrationState", m.MigrationState)
	objectMap["resultType"] = "DatabaseLevelOutput"
	populateTimeRFC3339(objectMap, "startedOn", m.StartedOn)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel.
func (m *MigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appliedChanges":
			err = unpopulate(val, "AppliedChanges", &m.AppliedChanges)
			delete(rawMsg, key)
		case "cdcDeleteCounter":
			err = unpopulate(val, "CdcDeleteCounter", &m.CdcDeleteCounter)
			delete(rawMsg, key)
		case "cdcInsertCounter":
			err = unpopulate(val, "CdcInsertCounter", &m.CdcInsertCounter)
			delete(rawMsg, key)
		case "cdcUpdateCounter":
			err = unpopulate(val, "CdcUpdateCounter", &m.CdcUpdateCounter)
			delete(rawMsg, key)
		case "databaseName":
			err = unpopulate(val, "DatabaseName", &m.DatabaseName)
			delete(rawMsg, key)
		case "endedOn":
			err = unpopulateTimeRFC3339(val, "EndedOn", &m.EndedOn)
			delete(rawMsg, key)
		case "fullLoadCompletedTables":
			err = unpopulate(val, "FullLoadCompletedTables", &m.FullLoadCompletedTables)
			delete(rawMsg, key)
		case "fullLoadErroredTables":
			err = unpopulate(val, "FullLoadErroredTables", &m.FullLoadErroredTables)
			delete(rawMsg, key)
		case "fullLoadLoadingTables":
			err = unpopulate(val, "FullLoadLoadingTables", &m.FullLoadLoadingTables)
			delete(rawMsg, key)
		case "fullLoadQueuedTables":
			err = unpopulate(val, "FullLoadQueuedTables", &m.FullLoadQueuedTables)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "incomingChanges":
			err = unpopulate(val, "IncomingChanges", &m.IncomingChanges)
			delete(rawMsg, key)
		case "initializationCompleted":
			err = unpopulate(val, "InitializationCompleted", &m.InitializationCompleted)
			delete(rawMsg, key)
		case "latency":
			err = unpopulate(val, "Latency", &m.Latency)
			delete(rawMsg, key)
		case "migrationState":
			err = unpopulate(val, "MigrationState", &m.MigrationState)
			delete(rawMsg, key)
		case "resultType":
			err = unpopulate(val, "ResultType", &m.ResultType)
			delete(rawMsg, key)
		case "startedOn":
			err = unpopulateTimeRFC3339(val, "StartedOn", &m.StartedOn)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrateSQLServerSQLDbSyncTaskOutputError.
func (m MigrateSQLServerSQLDbSyncTaskOutputError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "error", m.Error)
	populate(objectMap, "id", m.ID)
	objectMap["resultType"] = "ErrorOutput"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrateSQLServerSQLDbSyncTaskOutputError.
func (m *MigrateSQLServerSQLDbSyncTaskOutputError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &m.Error)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "resultType":
			err = unpopulate(val, "ResultType", &m.ResultType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrateSQLServerSQLDbSyncTaskOutputMigrationLevel.
func (m MigrateSQLServerSQLDbSyncTaskOutputMigrationLevel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "databaseCount", m.DatabaseCount)
	populateTimeRFC3339(objectMap, "endedOn", m.EndedOn)
	populate(objectMap, "id", m.ID)
	objectMap["resultType"] = "MigrationLevelOutput"
	populate(objectMap, "sourceServer", m.SourceServer)
	populate(objectMap, "sourceServerVersion", m.SourceServerVersion)
	populateTimeRFC3339(objectMap, "startedOn", m.StartedOn)
	populate(objectMap, "targetServer", m.TargetServer)
	populate(objectMap, "targetServerVersion", m.TargetServerVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrateSQLServerSQLDbSyncTaskOutputMigrationLevel.
func (m *MigrateSQLServerSQLDbSyncTaskOutputMigrationLevel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "databaseCount":
			err = unpopulate(val, "DatabaseCount", &m.DatabaseCount)
			delete(rawMsg, key)
		case "endedOn":
			err = unpopulateTimeRFC3339(val, "EndedOn", &m.EndedOn)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "resultType":
			err = unpopulate(val, "ResultType", &m.ResultType)
			delete(rawMsg, key)
		case "sourceServer":
			err = unpopulate(val, "SourceServer", &m.SourceServer)
			delete(rawMsg, key)
		case "sourceServerVersion":
			err = unpopulate(val, "SourceServerVersion", &m.SourceServerVersion)
			delete(rawMsg, key)
		case "startedOn":
			err = unpopulateTimeRFC3339(val, "StartedOn", &m.StartedOn)
			delete(rawMsg, key)
		case "targetServer":
			err = unpopulate(val, "TargetServer", &m.TargetServer)
			delete(rawMsg, key)
		case "targetServerVersion":
			err = unpopulate(val, "TargetServerVersion", &m.TargetServerVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrateSQLServerSQLDbSyncTaskOutputTableLevel.
func (m MigrateSQLServerSQLDbSyncTaskOutputTableLevel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "cdcDeleteCounter", m.CdcDeleteCounter)
	populate(objectMap, "cdcInsertCounter", m.CdcInsertCounter)
	populate(objectMap, "cdcUpdateCounter", m.CdcUpdateCounter)
	populate(objectMap, "dataErrorsCounter", m.DataErrorsCounter)
	populate(objectMap, "databaseName", m.DatabaseName)
	populateTimeRFC3339(objectMap, "fullLoadEndedOn", m.FullLoadEndedOn)
	populateTimeRFC3339(objectMap, "fullLoadEstFinishTime", m.FullLoadEstFinishTime)
	populateTimeRFC3339(objectMap, "fullLoadStartedOn", m.FullLoadStartedOn)
	populate(objectMap, "fullLoadTotalRows", m.FullLoadTotalRows)
	populate(objectMap, "id", m.ID)
	populateTimeRFC3339(objectMap, "lastModifiedTime", m.LastModifiedTime)
	objectMap["resultType"] = "TableLevelOutput"
	populate(objectMap, "state", m.State)
	populate(objectMap, "tableName", m.TableName)
	populate(objectMap, "totalChangesApplied", m.TotalChangesApplied)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrateSQLServerSQLDbSyncTaskOutputTableLevel.
func (m *MigrateSQLServerSQLDbSyncTaskOutputTableLevel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cdcDeleteCounter":
			err = unpopulate(val, "CdcDeleteCounter", &m.CdcDeleteCounter)
			delete(rawMsg, key)
		case "cdcInsertCounter":
			err = unpopulate(val, "CdcInsertCounter", &m.CdcInsertCounter)
			delete(rawMsg, key)
		case "cdcUpdateCounter":
			err = unpopulate(val, "CdcUpdateCounter", &m.CdcUpdateCounter)
			delete(rawMsg, key)
		case "dataErrorsCounter":
			err = unpopulate(val, "DataErrorsCounter", &m.DataErrorsCounter)
			delete(rawMsg, key)
		case "databaseName":
			err = unpopulate(val, "DatabaseName", &m.DatabaseName)
			delete(rawMsg, key)
		case "fullLoadEndedOn":
			err = unpopulateTimeRFC3339(val, "FullLoadEndedOn", &m.FullLoadEndedOn)
			delete(rawMsg, key)
		case "fullLoadEstFinishTime":
			err = unpopulateTimeRFC3339(val, "FullLoadEstFinishTime", &m.FullLoadEstFinishTime)
			delete(rawMsg, key)
		case "fullLoadStartedOn":
			err = unpopulateTimeRFC3339(val, "FullLoadStartedOn", &m.FullLoadStartedOn)
			delete(rawMsg, key)
		case "fullLoadTotalRows":
			err = unpopulate(val, "FullLoadTotalRows", &m.FullLoadTotalRows)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "lastModifiedTime":
			err = unpopulateTimeRFC3339(val, "LastModifiedTime", &m.LastModifiedTime)
			delete(rawMsg, key)
		case "resultType":
			err = unpopulate(val, "ResultType", &m.ResultType)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &m.State)
			delete(rawMsg, key)
		case "tableName":
			err = unpopulate(val, "TableName", &m.TableName)
			delete(rawMsg, key)
		case "totalChangesApplied":
			err = unpopulate(val, "TotalChangesApplied", &m.TotalChangesApplied)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrateSQLServerSQLDbSyncTaskProperties.
func (m MigrateSQLServerSQLDbSyncTaskProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "clientData", m.ClientData)
	populate(objectMap, "commands", m.Commands)
	populate(objectMap, "errors", m.Errors)
	populate(objectMap, "input", m.Input)
	populate(objectMap, "output", m.Output)
	populate(objectMap, "state", m.State)
	objectMap["taskType"] = "Migrate.SqlServer.AzureSqlDb.Sync"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrateSQLServerSQLDbSyncTaskProperties.
func (m *MigrateSQLServerSQLDbSyncTaskProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientData":
			err = unpopulate(val, "ClientData", &m.ClientData)
			delete(rawMsg, key)
		case "commands":
			m.Commands, err = unmarshalCommandPropertiesClassificationArray(val)
			delete(rawMsg, key)
		case "errors":
			err = unpopulate(val, "Errors", &m.Errors)
			delete(rawMsg, key)
		case "input":
			err = unpopulate(val, "Input", &m.Input)
			delete(rawMsg, key)
		case "output":
			m.Output, err = unmarshalMigrateSQLServerSQLDbSyncTaskOutputClassificationArray(val)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &m.State)
			delete(rawMsg, key)
		case "taskType":
			err = unpopulate(val, "TaskType", &m.TaskType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrateSQLServerSQLDbTaskInput.
func (m MigrateSQLServerSQLDbTaskInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "selectedDatabases", m.SelectedDatabases)
	populate(objectMap, "sourceConnectionInfo", m.SourceConnectionInfo)
	populate(objectMap, "targetConnectionInfo", m.TargetConnectionInfo)
	populate(objectMap, "validationOptions", m.ValidationOptions)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type MigrateSQLServerSQLDbTaskOutputDatabaseLevel.
func (m MigrateSQLServerSQLDbTaskOutputDatabaseLevel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "databaseName", m.DatabaseName)
	populateTimeRFC3339(objectMap, "endedOn", m.EndedOn)
	populate(objectMap, "errorCount", m.ErrorCount)
	populate(objectMap, "errorPrefix", m.ErrorPrefix)
	populate(objectMap, "exceptionsAndWarnings", m.ExceptionsAndWarnings)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "message", m.Message)
	populate(objectMap, "numberOfObjects", m.NumberOfObjects)
	populate(objectMap, "numberOfObjectsCompleted", m.NumberOfObjectsCompleted)
	populate(objectMap, "objectSummary", m.ObjectSummary)
	populate(objectMap, "resultPrefix", m.ResultPrefix)
	objectMap["resultType"] = "DatabaseLevelOutput"
	populate(objectMap, "stage", m.Stage)
	populateTimeRFC3339(objectMap, "startedOn", m.StartedOn)
	populate(objectMap, "state", m.State)
	populate(objectMap, "statusMessage", m.StatusMessage)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrateSQLServerSQLDbTaskOutputDatabaseLevel.
func (m *MigrateSQLServerSQLDbTaskOutputDatabaseLevel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "databaseName":
			err = unpopulate(val, "DatabaseName", &m.DatabaseName)
			delete(rawMsg, key)
		case "endedOn":
			err = unpopulateTimeRFC3339(val, "EndedOn", &m.EndedOn)
			delete(rawMsg, key)
		case "errorCount":
			err = unpopulate(val, "ErrorCount", &m.ErrorCount)
			delete(rawMsg, key)
		case "errorPrefix":
			err = unpopulate(val, "ErrorPrefix", &m.ErrorPrefix)
			delete(rawMsg, key)
		case "exceptionsAndWarnings":
			err = unpopulate(val, "ExceptionsAndWarnings", &m.ExceptionsAndWarnings)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &m.Message)
			delete(rawMsg, key)
		case "numberOfObjects":
			err = unpopulate(val, "NumberOfObjects", &m.NumberOfObjects)
			delete(rawMsg, key)
		case "numberOfObjectsCompleted":
			err = unpopulate(val, "NumberOfObjectsCompleted", &m.NumberOfObjectsCompleted)
			delete(rawMsg, key)
		case "objectSummary":
			err = unpopulate(val, "ObjectSummary", &m.ObjectSummary)
			delete(rawMsg, key)
		case "resultPrefix":
			err = unpopulate(val, "ResultPrefix", &m.ResultPrefix)
			delete(rawMsg, key)
		case "resultType":
			err = unpopulate(val, "ResultType", &m.ResultType)
			delete(rawMsg, key)
		case "stage":
			err = unpopulate(val, "Stage", &m.Stage)
			delete(rawMsg, key)
		case "startedOn":
			err = unpopulateTimeRFC3339(val, "StartedOn", &m.StartedOn)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &m.State)
			delete(rawMsg, key)
		case "statusMessage":
			err = unpopulate(val, "StatusMessage", &m.StatusMessage)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrateSQLServerSQLDbTaskOutputDatabaseLevelValidationResult.
func (m MigrateSQLServerSQLDbTaskOutputDatabaseLevelValidationResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "dataIntegrityValidationResult", m.DataIntegrityValidationResult)
	populateTimeRFC3339(objectMap, "endedOn", m.EndedOn)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "migrationId", m.MigrationID)
	populate(objectMap, "queryAnalysisValidationResult", m.QueryAnalysisValidationResult)
	objectMap["resultType"] = "MigrationDatabaseLevelValidationOutput"
	populate(objectMap, "schemaValidationResult", m.SchemaValidationResult)
	populate(objectMap, "sourceDatabaseName", m.SourceDatabaseName)
	populateTimeRFC3339(objectMap, "startedOn", m.StartedOn)
	populate(objectMap, "status", m.Status)
	populate(objectMap, "targetDatabaseName", m.TargetDatabaseName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrateSQLServerSQLDbTaskOutputDatabaseLevelValidationResult.
func (m *MigrateSQLServerSQLDbTaskOutputDatabaseLevelValidationResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataIntegrityValidationResult":
			err = unpopulate(val, "DataIntegrityValidationResult", &m.DataIntegrityValidationResult)
			delete(rawMsg, key)
		case "endedOn":
			err = unpopulateTimeRFC3339(val, "EndedOn", &m.EndedOn)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "migrationId":
			err = unpopulate(val, "MigrationID", &m.MigrationID)
			delete(rawMsg, key)
		case "queryAnalysisValidationResult":
			err = unpopulate(val, "QueryAnalysisValidationResult", &m.QueryAnalysisValidationResult)
			delete(rawMsg, key)
		case "resultType":
			err = unpopulate(val, "ResultType", &m.ResultType)
			delete(rawMsg, key)
		case "schemaValidationResult":
			err = unpopulate(val, "SchemaValidationResult", &m.SchemaValidationResult)
			delete(rawMsg, key)
		case "sourceDatabaseName":
			err = unpopulate(val, "SourceDatabaseName", &m.SourceDatabaseName)
			delete(rawMsg, key)
		case "startedOn":
			err = unpopulateTimeRFC3339(val, "StartedOn", &m.StartedOn)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &m.Status)
			delete(rawMsg, key)
		case "targetDatabaseName":
			err = unpopulate(val, "TargetDatabaseName", &m.TargetDatabaseName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrateSQLServerSQLDbTaskOutputError.
func (m MigrateSQLServerSQLDbTaskOutputError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "error", m.Error)
	populate(objectMap, "id", m.ID)
	objectMap["resultType"] = "ErrorOutput"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrateSQLServerSQLDbTaskOutputError.
func (m *MigrateSQLServerSQLDbTaskOutputError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &m.Error)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "resultType":
			err = unpopulate(val, "ResultType", &m.ResultType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrateSQLServerSQLDbTaskOutputMigrationLevel.
func (m MigrateSQLServerSQLDbTaskOutputMigrationLevel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "databaseSummary", m.DatabaseSummary)
	populate(objectMap, "databases", m.Databases)
	populate(objectMap, "durationInSeconds", m.DurationInSeconds)
	populateTimeRFC3339(objectMap, "endedOn", m.EndedOn)
	populate(objectMap, "exceptionsAndWarnings", m.ExceptionsAndWarnings)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "message", m.Message)
	populate(objectMap, "migrationReportResult", m.MigrationReportResult)
	populate(objectMap, "migrationValidationResult", m.MigrationValidationResult)
	objectMap["resultType"] = "MigrationLevelOutput"
	populate(objectMap, "sourceServerBrandVersion", m.SourceServerBrandVersion)
	populate(objectMap, "sourceServerVersion", m.SourceServerVersion)
	populateTimeRFC3339(objectMap, "startedOn", m.StartedOn)
	populate(objectMap, "status", m.Status)
	populate(objectMap, "statusMessage", m.StatusMessage)
	populate(objectMap, "targetServerBrandVersion", m.TargetServerBrandVersion)
	populate(objectMap, "targetServerVersion", m.TargetServerVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrateSQLServerSQLDbTaskOutputMigrationLevel.
func (m *MigrateSQLServerSQLDbTaskOutputMigrationLevel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "databaseSummary":
			err = unpopulate(val, "DatabaseSummary", &m.DatabaseSummary)
			delete(rawMsg, key)
		case "databases":
			err = unpopulate(val, "Databases", &m.Databases)
			delete(rawMsg, key)
		case "durationInSeconds":
			err = unpopulate(val, "DurationInSeconds", &m.DurationInSeconds)
			delete(rawMsg, key)
		case "endedOn":
			err = unpopulateTimeRFC3339(val, "EndedOn", &m.EndedOn)
			delete(rawMsg, key)
		case "exceptionsAndWarnings":
			err = unpopulate(val, "ExceptionsAndWarnings", &m.ExceptionsAndWarnings)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &m.Message)
			delete(rawMsg, key)
		case "migrationReportResult":
			err = unpopulate(val, "MigrationReportResult", &m.MigrationReportResult)
			delete(rawMsg, key)
		case "migrationValidationResult":
			err = unpopulate(val, "MigrationValidationResult", &m.MigrationValidationResult)
			delete(rawMsg, key)
		case "resultType":
			err = unpopulate(val, "ResultType", &m.ResultType)
			delete(rawMsg, key)
		case "sourceServerBrandVersion":
			err = unpopulate(val, "SourceServerBrandVersion", &m.SourceServerBrandVersion)
			delete(rawMsg, key)
		case "sourceServerVersion":
			err = unpopulate(val, "SourceServerVersion", &m.SourceServerVersion)
			delete(rawMsg, key)
		case "startedOn":
			err = unpopulateTimeRFC3339(val, "StartedOn", &m.StartedOn)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &m.Status)
			delete(rawMsg, key)
		case "statusMessage":
			err = unpopulate(val, "StatusMessage", &m.StatusMessage)
			delete(rawMsg, key)
		case "targetServerBrandVersion":
			err = unpopulate(val, "TargetServerBrandVersion", &m.TargetServerBrandVersion)
			delete(rawMsg, key)
		case "targetServerVersion":
			err = unpopulate(val, "TargetServerVersion", &m.TargetServerVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrateSQLServerSQLDbTaskOutputTableLevel.
func (m MigrateSQLServerSQLDbTaskOutputTableLevel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "endedOn", m.EndedOn)
	populate(objectMap, "errorPrefix", m.ErrorPrefix)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "itemsCompletedCount", m.ItemsCompletedCount)
	populate(objectMap, "itemsCount", m.ItemsCount)
	populate(objectMap, "objectName", m.ObjectName)
	populate(objectMap, "resultPrefix", m.ResultPrefix)
	objectMap["resultType"] = "TableLevelOutput"
	populateTimeRFC3339(objectMap, "startedOn", m.StartedOn)
	populate(objectMap, "state", m.State)
	populate(objectMap, "statusMessage", m.StatusMessage)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrateSQLServerSQLDbTaskOutputTableLevel.
func (m *MigrateSQLServerSQLDbTaskOutputTableLevel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endedOn":
			err = unpopulateTimeRFC3339(val, "EndedOn", &m.EndedOn)
			delete(rawMsg, key)
		case "errorPrefix":
			err = unpopulate(val, "ErrorPrefix", &m.ErrorPrefix)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "itemsCompletedCount":
			err = unpopulate(val, "ItemsCompletedCount", &m.ItemsCompletedCount)
			delete(rawMsg, key)
		case "itemsCount":
			err = unpopulate(val, "ItemsCount", &m.ItemsCount)
			delete(rawMsg, key)
		case "objectName":
			err = unpopulate(val, "ObjectName", &m.ObjectName)
			delete(rawMsg, key)
		case "resultPrefix":
			err = unpopulate(val, "ResultPrefix", &m.ResultPrefix)
			delete(rawMsg, key)
		case "resultType":
			err = unpopulate(val, "ResultType", &m.ResultType)
			delete(rawMsg, key)
		case "startedOn":
			err = unpopulateTimeRFC3339(val, "StartedOn", &m.StartedOn)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &m.State)
			delete(rawMsg, key)
		case "statusMessage":
			err = unpopulate(val, "StatusMessage", &m.StatusMessage)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrateSQLServerSQLDbTaskOutputValidationResult.
func (m MigrateSQLServerSQLDbTaskOutputValidationResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", m.ID)
	populate(objectMap, "migrationId", m.MigrationID)
	objectMap["resultType"] = "MigrationValidationOutput"
	populate(objectMap, "status", m.Status)
	populate(objectMap, "summaryResults", m.SummaryResults)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrateSQLServerSQLDbTaskOutputValidationResult.
func (m *MigrateSQLServerSQLDbTaskOutputValidationResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "migrationId":
			err = unpopulate(val, "MigrationID", &m.MigrationID)
			delete(rawMsg, key)
		case "resultType":
			err = unpopulate(val, "ResultType", &m.ResultType)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &m.Status)
			delete(rawMsg, key)
		case "summaryResults":
			err = unpopulate(val, "SummaryResults", &m.SummaryResults)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrateSQLServerSQLDbTaskProperties.
func (m MigrateSQLServerSQLDbTaskProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "clientData", m.ClientData)
	populate(objectMap, "commands", m.Commands)
	populate(objectMap, "errors", m.Errors)
	populate(objectMap, "input", m.Input)
	populate(objectMap, "output", m.Output)
	populate(objectMap, "state", m.State)
	objectMap["taskType"] = "Migrate.SqlServer.SqlDb"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrateSQLServerSQLDbTaskProperties.
func (m *MigrateSQLServerSQLDbTaskProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientData":
			err = unpopulate(val, "ClientData", &m.ClientData)
			delete(rawMsg, key)
		case "commands":
			m.Commands, err = unmarshalCommandPropertiesClassificationArray(val)
			delete(rawMsg, key)
		case "errors":
			err = unpopulate(val, "Errors", &m.Errors)
			delete(rawMsg, key)
		case "input":
			err = unpopulate(val, "Input", &m.Input)
			delete(rawMsg, key)
		case "output":
			m.Output, err = unmarshalMigrateSQLServerSQLDbTaskOutputClassificationArray(val)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &m.State)
			delete(rawMsg, key)
		case "taskType":
			err = unpopulate(val, "TaskType", &m.TaskType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrateSQLServerSQLMIDatabaseInput.
func (m MigrateSQLServerSQLMIDatabaseInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "backupFilePaths", m.BackupFilePaths)
	populate(objectMap, "backupFileShare", m.BackupFileShare)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "restoreDatabaseName", m.RestoreDatabaseName)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type MigrateSQLServerSQLMISyncTaskInput.
func (m MigrateSQLServerSQLMISyncTaskInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "azureApp", m.AzureApp)
	populate(objectMap, "backupFileShare", m.BackupFileShare)
	populate(objectMap, "selectedDatabases", m.SelectedDatabases)
	populate(objectMap, "sourceConnectionInfo", m.SourceConnectionInfo)
	populate(objectMap, "storageResourceId", m.StorageResourceID)
	populate(objectMap, "targetConnectionInfo", m.TargetConnectionInfo)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type MigrateSQLServerSQLMISyncTaskOutputDatabaseLevel.
func (m MigrateSQLServerSQLMISyncTaskOutputDatabaseLevel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "activeBackupSets", m.ActiveBackupSets)
	populate(objectMap, "containerName", m.ContainerName)
	populateTimeRFC3339(objectMap, "endedOn", m.EndedOn)
	populate(objectMap, "errorPrefix", m.ErrorPrefix)
	populate(objectMap, "exceptionsAndWarnings", m.ExceptionsAndWarnings)
	populate(objectMap, "fullBackupSetInfo", m.FullBackupSetInfo)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "isFullBackupRestored", m.IsFullBackupRestored)
	populate(objectMap, "lastRestoredBackupSetInfo", m.LastRestoredBackupSetInfo)
	populate(objectMap, "migrationState", m.MigrationState)
	objectMap["resultType"] = "DatabaseLevelOutput"
	populate(objectMap, "sourceDatabaseName", m.SourceDatabaseName)
	populateTimeRFC3339(objectMap, "startedOn", m.StartedOn)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrateSQLServerSQLMISyncTaskOutputDatabaseLevel.
func (m *MigrateSQLServerSQLMISyncTaskOutputDatabaseLevel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "activeBackupSets":
			err = unpopulate(val, "ActiveBackupSets", &m.ActiveBackupSets)
			delete(rawMsg, key)
		case "containerName":
			err = unpopulate(val, "ContainerName", &m.ContainerName)
			delete(rawMsg, key)
		case "endedOn":
			err = unpopulateTimeRFC3339(val, "EndedOn", &m.EndedOn)
			delete(rawMsg, key)
		case "errorPrefix":
			err = unpopulate(val, "ErrorPrefix", &m.ErrorPrefix)
			delete(rawMsg, key)
		case "exceptionsAndWarnings":
			err = unpopulate(val, "ExceptionsAndWarnings", &m.ExceptionsAndWarnings)
			delete(rawMsg, key)
		case "fullBackupSetInfo":
			err = unpopulate(val, "FullBackupSetInfo", &m.FullBackupSetInfo)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "isFullBackupRestored":
			err = unpopulate(val, "IsFullBackupRestored", &m.IsFullBackupRestored)
			delete(rawMsg, key)
		case "lastRestoredBackupSetInfo":
			err = unpopulate(val, "LastRestoredBackupSetInfo", &m.LastRestoredBackupSetInfo)
			delete(rawMsg, key)
		case "migrationState":
			err = unpopulate(val, "MigrationState", &m.MigrationState)
			delete(rawMsg, key)
		case "resultType":
			err = unpopulate(val, "ResultType", &m.ResultType)
			delete(rawMsg, key)
		case "sourceDatabaseName":
			err = unpopulate(val, "SourceDatabaseName", &m.SourceDatabaseName)
			delete(rawMsg, key)
		case "startedOn":
			err = unpopulateTimeRFC3339(val, "StartedOn", &m.StartedOn)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrateSQLServerSQLMISyncTaskOutputError.
func (m MigrateSQLServerSQLMISyncTaskOutputError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "error", m.Error)
	populate(objectMap, "id", m.ID)
	objectMap["resultType"] = "ErrorOutput"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrateSQLServerSQLMISyncTaskOutputError.
func (m *MigrateSQLServerSQLMISyncTaskOutputError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &m.Error)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "resultType":
			err = unpopulate(val, "ResultType", &m.ResultType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrateSQLServerSQLMISyncTaskOutputMigrationLevel.
func (m MigrateSQLServerSQLMISyncTaskOutputMigrationLevel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "databaseCount", m.DatabaseCount)
	populate(objectMap, "databaseErrorCount", m.DatabaseErrorCount)
	populateTimeRFC3339(objectMap, "endedOn", m.EndedOn)
	populate(objectMap, "id", m.ID)
	objectMap["resultType"] = "MigrationLevelOutput"
	populate(objectMap, "sourceServerBrandVersion", m.SourceServerBrandVersion)
	populate(objectMap, "sourceServerName", m.SourceServerName)
	populate(objectMap, "sourceServerVersion", m.SourceServerVersion)
	populateTimeRFC3339(objectMap, "startedOn", m.StartedOn)
	populate(objectMap, "state", m.State)
	populate(objectMap, "targetServerBrandVersion", m.TargetServerBrandVersion)
	populate(objectMap, "targetServerName", m.TargetServerName)
	populate(objectMap, "targetServerVersion", m.TargetServerVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrateSQLServerSQLMISyncTaskOutputMigrationLevel.
func (m *MigrateSQLServerSQLMISyncTaskOutputMigrationLevel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "databaseCount":
			err = unpopulate(val, "DatabaseCount", &m.DatabaseCount)
			delete(rawMsg, key)
		case "databaseErrorCount":
			err = unpopulate(val, "DatabaseErrorCount", &m.DatabaseErrorCount)
			delete(rawMsg, key)
		case "endedOn":
			err = unpopulateTimeRFC3339(val, "EndedOn", &m.EndedOn)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "resultType":
			err = unpopulate(val, "ResultType", &m.ResultType)
			delete(rawMsg, key)
		case "sourceServerBrandVersion":
			err = unpopulate(val, "SourceServerBrandVersion", &m.SourceServerBrandVersion)
			delete(rawMsg, key)
		case "sourceServerName":
			err = unpopulate(val, "SourceServerName", &m.SourceServerName)
			delete(rawMsg, key)
		case "sourceServerVersion":
			err = unpopulate(val, "SourceServerVersion", &m.SourceServerVersion)
			delete(rawMsg, key)
		case "startedOn":
			err = unpopulateTimeRFC3339(val, "StartedOn", &m.StartedOn)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &m.State)
			delete(rawMsg, key)
		case "targetServerBrandVersion":
			err = unpopulate(val, "TargetServerBrandVersion", &m.TargetServerBrandVersion)
			delete(rawMsg, key)
		case "targetServerName":
			err = unpopulate(val, "TargetServerName", &m.TargetServerName)
			delete(rawMsg, key)
		case "targetServerVersion":
			err = unpopulate(val, "TargetServerVersion", &m.TargetServerVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrateSQLServerSQLMISyncTaskProperties.
func (m MigrateSQLServerSQLMISyncTaskProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "clientData", m.ClientData)
	populate(objectMap, "commands", m.Commands)
	populate(objectMap, "errors", m.Errors)
	populate(objectMap, "input", m.Input)
	populate(objectMap, "output", m.Output)
	populate(objectMap, "state", m.State)
	objectMap["taskType"] = "Migrate.SqlServer.AzureSqlDbMI.Sync.LRS"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrateSQLServerSQLMISyncTaskProperties.
func (m *MigrateSQLServerSQLMISyncTaskProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientData":
			err = unpopulate(val, "ClientData", &m.ClientData)
			delete(rawMsg, key)
		case "commands":
			m.Commands, err = unmarshalCommandPropertiesClassificationArray(val)
			delete(rawMsg, key)
		case "errors":
			err = unpopulate(val, "Errors", &m.Errors)
			delete(rawMsg, key)
		case "input":
			err = unpopulate(val, "Input", &m.Input)
			delete(rawMsg, key)
		case "output":
			m.Output, err = unmarshalMigrateSQLServerSQLMISyncTaskOutputClassificationArray(val)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &m.State)
			delete(rawMsg, key)
		case "taskType":
			err = unpopulate(val, "TaskType", &m.TaskType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrateSQLServerSQLMITaskInput.
func (m MigrateSQLServerSQLMITaskInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "aadDomainName", m.AADDomainName)
	populate(objectMap, "backupBlobShare", m.BackupBlobShare)
	populate(objectMap, "backupFileShare", m.BackupFileShare)
	populate(objectMap, "backupMode", m.BackupMode)
	populate(objectMap, "selectedAgentJobs", m.SelectedAgentJobs)
	populate(objectMap, "selectedDatabases", m.SelectedDatabases)
	populate(objectMap, "selectedLogins", m.SelectedLogins)
	populate(objectMap, "sourceConnectionInfo", m.SourceConnectionInfo)
	populate(objectMap, "targetConnectionInfo", m.TargetConnectionInfo)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type MigrateSQLServerSQLMITaskOutputAgentJobLevel.
func (m MigrateSQLServerSQLMITaskOutputAgentJobLevel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "endedOn", m.EndedOn)
	populate(objectMap, "exceptionsAndWarnings", m.ExceptionsAndWarnings)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "isEnabled", m.IsEnabled)
	populate(objectMap, "message", m.Message)
	populate(objectMap, "name", m.Name)
	objectMap["resultType"] = "AgentJobLevelOutput"
	populateTimeRFC3339(objectMap, "startedOn", m.StartedOn)
	populate(objectMap, "state", m.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrateSQLServerSQLMITaskOutputAgentJobLevel.
func (m *MigrateSQLServerSQLMITaskOutputAgentJobLevel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endedOn":
			err = unpopulateTimeRFC3339(val, "EndedOn", &m.EndedOn)
			delete(rawMsg, key)
		case "exceptionsAndWarnings":
			err = unpopulate(val, "ExceptionsAndWarnings", &m.ExceptionsAndWarnings)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "isEnabled":
			err = unpopulate(val, "IsEnabled", &m.IsEnabled)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &m.Message)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "resultType":
			err = unpopulate(val, "ResultType", &m.ResultType)
			delete(rawMsg, key)
		case "startedOn":
			err = unpopulateTimeRFC3339(val, "StartedOn", &m.StartedOn)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &m.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrateSQLServerSQLMITaskOutputDatabaseLevel.
func (m MigrateSQLServerSQLMITaskOutputDatabaseLevel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "databaseName", m.DatabaseName)
	populateTimeRFC3339(objectMap, "endedOn", m.EndedOn)
	populate(objectMap, "exceptionsAndWarnings", m.ExceptionsAndWarnings)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "message", m.Message)
	objectMap["resultType"] = "DatabaseLevelOutput"
	populate(objectMap, "sizeMB", m.SizeMB)
	populate(objectMap, "stage", m.Stage)
	populateTimeRFC3339(objectMap, "startedOn", m.StartedOn)
	populate(objectMap, "state", m.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrateSQLServerSQLMITaskOutputDatabaseLevel.
func (m *MigrateSQLServerSQLMITaskOutputDatabaseLevel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "databaseName":
			err = unpopulate(val, "DatabaseName", &m.DatabaseName)
			delete(rawMsg, key)
		case "endedOn":
			err = unpopulateTimeRFC3339(val, "EndedOn", &m.EndedOn)
			delete(rawMsg, key)
		case "exceptionsAndWarnings":
			err = unpopulate(val, "ExceptionsAndWarnings", &m.ExceptionsAndWarnings)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &m.Message)
			delete(rawMsg, key)
		case "resultType":
			err = unpopulate(val, "ResultType", &m.ResultType)
			delete(rawMsg, key)
		case "sizeMB":
			err = unpopulate(val, "SizeMB", &m.SizeMB)
			delete(rawMsg, key)
		case "stage":
			err = unpopulate(val, "Stage", &m.Stage)
			delete(rawMsg, key)
		case "startedOn":
			err = unpopulateTimeRFC3339(val, "StartedOn", &m.StartedOn)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &m.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrateSQLServerSQLMITaskOutputError.
func (m MigrateSQLServerSQLMITaskOutputError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "error", m.Error)
	populate(objectMap, "id", m.ID)
	objectMap["resultType"] = "ErrorOutput"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrateSQLServerSQLMITaskOutputError.
func (m *MigrateSQLServerSQLMITaskOutputError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &m.Error)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "resultType":
			err = unpopulate(val, "ResultType", &m.ResultType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrateSQLServerSQLMITaskOutputLoginLevel.
func (m MigrateSQLServerSQLMITaskOutputLoginLevel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "endedOn", m.EndedOn)
	populate(objectMap, "exceptionsAndWarnings", m.ExceptionsAndWarnings)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "loginName", m.LoginName)
	populate(objectMap, "message", m.Message)
	objectMap["resultType"] = "LoginLevelOutput"
	populate(objectMap, "stage", m.Stage)
	populateTimeRFC3339(objectMap, "startedOn", m.StartedOn)
	populate(objectMap, "state", m.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrateSQLServerSQLMITaskOutputLoginLevel.
func (m *MigrateSQLServerSQLMITaskOutputLoginLevel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endedOn":
			err = unpopulateTimeRFC3339(val, "EndedOn", &m.EndedOn)
			delete(rawMsg, key)
		case "exceptionsAndWarnings":
			err = unpopulate(val, "ExceptionsAndWarnings", &m.ExceptionsAndWarnings)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "loginName":
			err = unpopulate(val, "LoginName", &m.LoginName)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &m.Message)
			delete(rawMsg, key)
		case "resultType":
			err = unpopulate(val, "ResultType", &m.ResultType)
			delete(rawMsg, key)
		case "stage":
			err = unpopulate(val, "Stage", &m.Stage)
			delete(rawMsg, key)
		case "startedOn":
			err = unpopulateTimeRFC3339(val, "StartedOn", &m.StartedOn)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &m.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrateSQLServerSQLMITaskOutputMigrationLevel.
func (m MigrateSQLServerSQLMITaskOutputMigrationLevel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "agentJobs", m.AgentJobs)
	populate(objectMap, "databases", m.Databases)
	populateTimeRFC3339(objectMap, "endedOn", m.EndedOn)
	populate(objectMap, "exceptionsAndWarnings", m.ExceptionsAndWarnings)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "logins", m.Logins)
	populate(objectMap, "message", m.Message)
	populate(objectMap, "orphanedUsersInfo", m.OrphanedUsersInfo)
	objectMap["resultType"] = "MigrationLevelOutput"
	populate(objectMap, "serverRoleResults", m.ServerRoleResults)
	populate(objectMap, "sourceServerBrandVersion", m.SourceServerBrandVersion)
	populate(objectMap, "sourceServerVersion", m.SourceServerVersion)
	populateTimeRFC3339(objectMap, "startedOn", m.StartedOn)
	populate(objectMap, "state", m.State)
	populate(objectMap, "status", m.Status)
	populate(objectMap, "targetServerBrandVersion", m.TargetServerBrandVersion)
	populate(objectMap, "targetServerVersion", m.TargetServerVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrateSQLServerSQLMITaskOutputMigrationLevel.
func (m *MigrateSQLServerSQLMITaskOutputMigrationLevel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "agentJobs":
			err = unpopulate(val, "AgentJobs", &m.AgentJobs)
			delete(rawMsg, key)
		case "databases":
			err = unpopulate(val, "Databases", &m.Databases)
			delete(rawMsg, key)
		case "endedOn":
			err = unpopulateTimeRFC3339(val, "EndedOn", &m.EndedOn)
			delete(rawMsg, key)
		case "exceptionsAndWarnings":
			err = unpopulate(val, "ExceptionsAndWarnings", &m.ExceptionsAndWarnings)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "logins":
			err = unpopulate(val, "Logins", &m.Logins)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &m.Message)
			delete(rawMsg, key)
		case "orphanedUsersInfo":
			err = unpopulate(val, "OrphanedUsersInfo", &m.OrphanedUsersInfo)
			delete(rawMsg, key)
		case "resultType":
			err = unpopulate(val, "ResultType", &m.ResultType)
			delete(rawMsg, key)
		case "serverRoleResults":
			err = unpopulate(val, "ServerRoleResults", &m.ServerRoleResults)
			delete(rawMsg, key)
		case "sourceServerBrandVersion":
			err = unpopulate(val, "SourceServerBrandVersion", &m.SourceServerBrandVersion)
			delete(rawMsg, key)
		case "sourceServerVersion":
			err = unpopulate(val, "SourceServerVersion", &m.SourceServerVersion)
			delete(rawMsg, key)
		case "startedOn":
			err = unpopulateTimeRFC3339(val, "StartedOn", &m.StartedOn)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &m.State)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &m.Status)
			delete(rawMsg, key)
		case "targetServerBrandVersion":
			err = unpopulate(val, "TargetServerBrandVersion", &m.TargetServerBrandVersion)
			delete(rawMsg, key)
		case "targetServerVersion":
			err = unpopulate(val, "TargetServerVersion", &m.TargetServerVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrateSQLServerSQLMITaskProperties.
func (m MigrateSQLServerSQLMITaskProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "clientData", m.ClientData)
	populate(objectMap, "commands", m.Commands)
	populate(objectMap, "errors", m.Errors)
	populate(objectMap, "input", m.Input)
	populate(objectMap, "output", m.Output)
	populate(objectMap, "state", m.State)
	objectMap["taskType"] = "Migrate.SqlServer.AzureSqlDbMI"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrateSQLServerSQLMITaskProperties.
func (m *MigrateSQLServerSQLMITaskProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientData":
			err = unpopulate(val, "ClientData", &m.ClientData)
			delete(rawMsg, key)
		case "commands":
			m.Commands, err = unmarshalCommandPropertiesClassificationArray(val)
			delete(rawMsg, key)
		case "errors":
			err = unpopulate(val, "Errors", &m.Errors)
			delete(rawMsg, key)
		case "input":
			err = unpopulate(val, "Input", &m.Input)
			delete(rawMsg, key)
		case "output":
			m.Output, err = unmarshalMigrateSQLServerSQLMITaskOutputClassificationArray(val)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &m.State)
			delete(rawMsg, key)
		case "taskType":
			err = unpopulate(val, "TaskType", &m.TaskType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrateSchemaSQLServerSQLDbTaskInput.
func (m MigrateSchemaSQLServerSQLDbTaskInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "selectedDatabases", m.SelectedDatabases)
	populate(objectMap, "sourceConnectionInfo", m.SourceConnectionInfo)
	populate(objectMap, "targetConnectionInfo", m.TargetConnectionInfo)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type MigrateSchemaSQLServerSQLDbTaskOutputDatabaseLevel.
func (m MigrateSchemaSQLServerSQLDbTaskOutputDatabaseLevel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "databaseErrorResultPrefix", m.DatabaseErrorResultPrefix)
	populate(objectMap, "databaseName", m.DatabaseName)
	populateTimeRFC3339(objectMap, "endedOn", m.EndedOn)
	populate(objectMap, "fileId", m.FileID)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "numberOfFailedOperations", m.NumberOfFailedOperations)
	populate(objectMap, "numberOfSuccessfulOperations", m.NumberOfSuccessfulOperations)
	objectMap["resultType"] = "DatabaseLevelOutput"
	populate(objectMap, "schemaErrorResultPrefix", m.SchemaErrorResultPrefix)
	populate(objectMap, "stage", m.Stage)
	populateTimeRFC3339(objectMap, "startedOn", m.StartedOn)
	populate(objectMap, "state", m.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrateSchemaSQLServerSQLDbTaskOutputDatabaseLevel.
func (m *MigrateSchemaSQLServerSQLDbTaskOutputDatabaseLevel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "databaseErrorResultPrefix":
			err = unpopulate(val, "DatabaseErrorResultPrefix", &m.DatabaseErrorResultPrefix)
			delete(rawMsg, key)
		case "databaseName":
			err = unpopulate(val, "DatabaseName", &m.DatabaseName)
			delete(rawMsg, key)
		case "endedOn":
			err = unpopulateTimeRFC3339(val, "EndedOn", &m.EndedOn)
			delete(rawMsg, key)
		case "fileId":
			err = unpopulate(val, "FileID", &m.FileID)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "numberOfFailedOperations":
			err = unpopulate(val, "NumberOfFailedOperations", &m.NumberOfFailedOperations)
			delete(rawMsg, key)
		case "numberOfSuccessfulOperations":
			err = unpopulate(val, "NumberOfSuccessfulOperations", &m.NumberOfSuccessfulOperations)
			delete(rawMsg, key)
		case "resultType":
			err = unpopulate(val, "ResultType", &m.ResultType)
			delete(rawMsg, key)
		case "schemaErrorResultPrefix":
			err = unpopulate(val, "SchemaErrorResultPrefix", &m.SchemaErrorResultPrefix)
			delete(rawMsg, key)
		case "stage":
			err = unpopulate(val, "Stage", &m.Stage)
			delete(rawMsg, key)
		case "startedOn":
			err = unpopulateTimeRFC3339(val, "StartedOn", &m.StartedOn)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &m.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrateSchemaSQLServerSQLDbTaskOutputError.
func (m MigrateSchemaSQLServerSQLDbTaskOutputError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "commandText", m.CommandText)
	populate(objectMap, "errorText", m.ErrorText)
	populate(objectMap, "id", m.ID)
	objectMap["resultType"] = "SchemaErrorOutput"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrateSchemaSQLServerSQLDbTaskOutputError.
func (m *MigrateSchemaSQLServerSQLDbTaskOutputError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "commandText":
			err = unpopulate(val, "CommandText", &m.CommandText)
			delete(rawMsg, key)
		case "errorText":
			err = unpopulate(val, "ErrorText", &m.ErrorText)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "resultType":
			err = unpopulate(val, "ResultType", &m.ResultType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrateSchemaSQLServerSQLDbTaskOutputMigrationLevel.
func (m MigrateSchemaSQLServerSQLDbTaskOutputMigrationLevel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "endedOn", m.EndedOn)
	populate(objectMap, "id", m.ID)
	objectMap["resultType"] = "MigrationLevelOutput"
	populate(objectMap, "sourceServerBrandVersion", m.SourceServerBrandVersion)
	populate(objectMap, "sourceServerVersion", m.SourceServerVersion)
	populateTimeRFC3339(objectMap, "startedOn", m.StartedOn)
	populate(objectMap, "state", m.State)
	populate(objectMap, "targetServerBrandVersion", m.TargetServerBrandVersion)
	populate(objectMap, "targetServerVersion", m.TargetServerVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrateSchemaSQLServerSQLDbTaskOutputMigrationLevel.
func (m *MigrateSchemaSQLServerSQLDbTaskOutputMigrationLevel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endedOn":
			err = unpopulateTimeRFC3339(val, "EndedOn", &m.EndedOn)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "resultType":
			err = unpopulate(val, "ResultType", &m.ResultType)
			delete(rawMsg, key)
		case "sourceServerBrandVersion":
			err = unpopulate(val, "SourceServerBrandVersion", &m.SourceServerBrandVersion)
			delete(rawMsg, key)
		case "sourceServerVersion":
			err = unpopulate(val, "SourceServerVersion", &m.SourceServerVersion)
			delete(rawMsg, key)
		case "startedOn":
			err = unpopulateTimeRFC3339(val, "StartedOn", &m.StartedOn)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &m.State)
			delete(rawMsg, key)
		case "targetServerBrandVersion":
			err = unpopulate(val, "TargetServerBrandVersion", &m.TargetServerBrandVersion)
			delete(rawMsg, key)
		case "targetServerVersion":
			err = unpopulate(val, "TargetServerVersion", &m.TargetServerVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrateSchemaSQLServerSQLDbTaskProperties.
func (m MigrateSchemaSQLServerSQLDbTaskProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "clientData", m.ClientData)
	populate(objectMap, "commands", m.Commands)
	populate(objectMap, "errors", m.Errors)
	populate(objectMap, "input", m.Input)
	populate(objectMap, "output", m.Output)
	populate(objectMap, "state", m.State)
	objectMap["taskType"] = "MigrateSchemaSqlServerSqlDb"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrateSchemaSQLServerSQLDbTaskProperties.
func (m *MigrateSchemaSQLServerSQLDbTaskProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientData":
			err = unpopulate(val, "ClientData", &m.ClientData)
			delete(rawMsg, key)
		case "commands":
			m.Commands, err = unmarshalCommandPropertiesClassificationArray(val)
			delete(rawMsg, key)
		case "errors":
			err = unpopulate(val, "Errors", &m.Errors)
			delete(rawMsg, key)
		case "input":
			err = unpopulate(val, "Input", &m.Input)
			delete(rawMsg, key)
		case "output":
			m.Output, err = unmarshalMigrateSchemaSQLServerSQLDbTaskOutputClassificationArray(val)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &m.State)
			delete(rawMsg, key)
		case "taskType":
			err = unpopulate(val, "TaskType", &m.TaskType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrateSchemaSQLTaskOutputError.
func (m MigrateSchemaSQLTaskOutputError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "error", m.Error)
	populate(objectMap, "id", m.ID)
	objectMap["resultType"] = "ErrorOutput"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrateSchemaSQLTaskOutputError.
func (m *MigrateSchemaSQLTaskOutputError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &m.Error)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "resultType":
			err = unpopulate(val, "ResultType", &m.ResultType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrateSsisTaskOutputMigrationLevel.
func (m MigrateSsisTaskOutputMigrationLevel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "endedOn", m.EndedOn)
	populate(objectMap, "exceptionsAndWarnings", m.ExceptionsAndWarnings)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "message", m.Message)
	objectMap["resultType"] = "MigrationLevelOutput"
	populate(objectMap, "sourceServerBrandVersion", m.SourceServerBrandVersion)
	populate(objectMap, "sourceServerVersion", m.SourceServerVersion)
	populate(objectMap, "stage", m.Stage)
	populateTimeRFC3339(objectMap, "startedOn", m.StartedOn)
	populate(objectMap, "status", m.Status)
	populate(objectMap, "targetServerBrandVersion", m.TargetServerBrandVersion)
	populate(objectMap, "targetServerVersion", m.TargetServerVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrateSsisTaskOutputMigrationLevel.
func (m *MigrateSsisTaskOutputMigrationLevel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endedOn":
			err = unpopulateTimeRFC3339(val, "EndedOn", &m.EndedOn)
			delete(rawMsg, key)
		case "exceptionsAndWarnings":
			err = unpopulate(val, "ExceptionsAndWarnings", &m.ExceptionsAndWarnings)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &m.Message)
			delete(rawMsg, key)
		case "resultType":
			err = unpopulate(val, "ResultType", &m.ResultType)
			delete(rawMsg, key)
		case "sourceServerBrandVersion":
			err = unpopulate(val, "SourceServerBrandVersion", &m.SourceServerBrandVersion)
			delete(rawMsg, key)
		case "sourceServerVersion":
			err = unpopulate(val, "SourceServerVersion", &m.SourceServerVersion)
			delete(rawMsg, key)
		case "stage":
			err = unpopulate(val, "Stage", &m.Stage)
			delete(rawMsg, key)
		case "startedOn":
			err = unpopulateTimeRFC3339(val, "StartedOn", &m.StartedOn)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &m.Status)
			delete(rawMsg, key)
		case "targetServerBrandVersion":
			err = unpopulate(val, "TargetServerBrandVersion", &m.TargetServerBrandVersion)
			delete(rawMsg, key)
		case "targetServerVersion":
			err = unpopulate(val, "TargetServerVersion", &m.TargetServerVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrateSsisTaskOutputProjectLevel.
func (m MigrateSsisTaskOutputProjectLevel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "endedOn", m.EndedOn)
	populate(objectMap, "exceptionsAndWarnings", m.ExceptionsAndWarnings)
	populate(objectMap, "folderName", m.FolderName)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "message", m.Message)
	populate(objectMap, "projectName", m.ProjectName)
	objectMap["resultType"] = "SsisProjectLevelOutput"
	populate(objectMap, "stage", m.Stage)
	populateTimeRFC3339(objectMap, "startedOn", m.StartedOn)
	populate(objectMap, "state", m.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrateSsisTaskOutputProjectLevel.
func (m *MigrateSsisTaskOutputProjectLevel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endedOn":
			err = unpopulateTimeRFC3339(val, "EndedOn", &m.EndedOn)
			delete(rawMsg, key)
		case "exceptionsAndWarnings":
			err = unpopulate(val, "ExceptionsAndWarnings", &m.ExceptionsAndWarnings)
			delete(rawMsg, key)
		case "folderName":
			err = unpopulate(val, "FolderName", &m.FolderName)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &m.Message)
			delete(rawMsg, key)
		case "projectName":
			err = unpopulate(val, "ProjectName", &m.ProjectName)
			delete(rawMsg, key)
		case "resultType":
			err = unpopulate(val, "ResultType", &m.ResultType)
			delete(rawMsg, key)
		case "stage":
			err = unpopulate(val, "Stage", &m.Stage)
			delete(rawMsg, key)
		case "startedOn":
			err = unpopulateTimeRFC3339(val, "StartedOn", &m.StartedOn)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &m.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrateSsisTaskProperties.
func (m MigrateSsisTaskProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "clientData", m.ClientData)
	populate(objectMap, "commands", m.Commands)
	populate(objectMap, "errors", m.Errors)
	populate(objectMap, "input", m.Input)
	populate(objectMap, "output", m.Output)
	populate(objectMap, "state", m.State)
	objectMap["taskType"] = "Migrate.Ssis"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrateSsisTaskProperties.
func (m *MigrateSsisTaskProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientData":
			err = unpopulate(val, "ClientData", &m.ClientData)
			delete(rawMsg, key)
		case "commands":
			m.Commands, err = unmarshalCommandPropertiesClassificationArray(val)
			delete(rawMsg, key)
		case "errors":
			err = unpopulate(val, "Errors", &m.Errors)
			delete(rawMsg, key)
		case "input":
			err = unpopulate(val, "Input", &m.Input)
			delete(rawMsg, key)
		case "output":
			m.Output, err = unmarshalMigrateSsisTaskOutputClassificationArray(val)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &m.State)
			delete(rawMsg, key)
		case "taskType":
			err = unpopulate(val, "TaskType", &m.TaskType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrateSyncCompleteCommandInput.
func (m MigrateSyncCompleteCommandInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "commitTimeStamp", m.CommitTimeStamp)
	populate(objectMap, "databaseName", m.DatabaseName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrateSyncCompleteCommandInput.
func (m *MigrateSyncCompleteCommandInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "commitTimeStamp":
			err = unpopulateTimeRFC3339(val, "CommitTimeStamp", &m.CommitTimeStamp)
			delete(rawMsg, key)
		case "databaseName":
			err = unpopulate(val, "DatabaseName", &m.DatabaseName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrateSyncCompleteCommandOutput.
func (m MigrateSyncCompleteCommandOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "errors", m.Errors)
	populate(objectMap, "id", m.ID)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type MigrateSyncCompleteCommandProperties.
func (m MigrateSyncCompleteCommandProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["commandType"] = "Migrate.Sync.Complete.Database"
	populate(objectMap, "errors", m.Errors)
	populate(objectMap, "input", m.Input)
	populate(objectMap, "output", m.Output)
	populate(objectMap, "state", m.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrateSyncCompleteCommandProperties.
func (m *MigrateSyncCompleteCommandProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "commandType":
			err = unpopulate(val, "CommandType", &m.CommandType)
			delete(rawMsg, key)
		case "errors":
			err = unpopulate(val, "Errors", &m.Errors)
			delete(rawMsg, key)
		case "input":
			err = unpopulate(val, "Input", &m.Input)
			delete(rawMsg, key)
		case "output":
			err = unpopulate(val, "Output", &m.Output)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &m.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrationEligibilityInfo.
func (m MigrationEligibilityInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "isEligibleForMigration", m.IsEligibleForMigration)
	populate(objectMap, "validationMessages", m.ValidationMessages)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type MigrationValidationDatabaseLevelResult.
func (m MigrationValidationDatabaseLevelResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "dataIntegrityValidationResult", m.DataIntegrityValidationResult)
	populateTimeRFC3339(objectMap, "endedOn", m.EndedOn)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "migrationId", m.MigrationID)
	populate(objectMap, "queryAnalysisValidationResult", m.QueryAnalysisValidationResult)
	populate(objectMap, "schemaValidationResult", m.SchemaValidationResult)
	populate(objectMap, "sourceDatabaseName", m.SourceDatabaseName)
	populateTimeRFC3339(objectMap, "startedOn", m.StartedOn)
	populate(objectMap, "status", m.Status)
	populate(objectMap, "targetDatabaseName", m.TargetDatabaseName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrationValidationDatabaseLevelResult.
func (m *MigrationValidationDatabaseLevelResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataIntegrityValidationResult":
			err = unpopulate(val, "DataIntegrityValidationResult", &m.DataIntegrityValidationResult)
			delete(rawMsg, key)
		case "endedOn":
			err = unpopulateTimeRFC3339(val, "EndedOn", &m.EndedOn)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "migrationId":
			err = unpopulate(val, "MigrationID", &m.MigrationID)
			delete(rawMsg, key)
		case "queryAnalysisValidationResult":
			err = unpopulate(val, "QueryAnalysisValidationResult", &m.QueryAnalysisValidationResult)
			delete(rawMsg, key)
		case "schemaValidationResult":
			err = unpopulate(val, "SchemaValidationResult", &m.SchemaValidationResult)
			delete(rawMsg, key)
		case "sourceDatabaseName":
			err = unpopulate(val, "SourceDatabaseName", &m.SourceDatabaseName)
			delete(rawMsg, key)
		case "startedOn":
			err = unpopulateTimeRFC3339(val, "StartedOn", &m.StartedOn)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &m.Status)
			delete(rawMsg, key)
		case "targetDatabaseName":
			err = unpopulate(val, "TargetDatabaseName", &m.TargetDatabaseName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrationValidationDatabaseSummaryResult.
func (m MigrationValidationDatabaseSummaryResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "endedOn", m.EndedOn)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "migrationId", m.MigrationID)
	populate(objectMap, "sourceDatabaseName", m.SourceDatabaseName)
	populateTimeRFC3339(objectMap, "startedOn", m.StartedOn)
	populate(objectMap, "status", m.Status)
	populate(objectMap, "targetDatabaseName", m.TargetDatabaseName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrationValidationDatabaseSummaryResult.
func (m *MigrationValidationDatabaseSummaryResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endedOn":
			err = unpopulateTimeRFC3339(val, "EndedOn", &m.EndedOn)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "migrationId":
			err = unpopulate(val, "MigrationID", &m.MigrationID)
			delete(rawMsg, key)
		case "sourceDatabaseName":
			err = unpopulate(val, "SourceDatabaseName", &m.SourceDatabaseName)
			delete(rawMsg, key)
		case "startedOn":
			err = unpopulateTimeRFC3339(val, "StartedOn", &m.StartedOn)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &m.Status)
			delete(rawMsg, key)
		case "targetDatabaseName":
			err = unpopulate(val, "TargetDatabaseName", &m.TargetDatabaseName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrationValidationResult.
func (m MigrationValidationResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", m.ID)
	populate(objectMap, "migrationId", m.MigrationID)
	populate(objectMap, "status", m.Status)
	populate(objectMap, "summaryResults", m.SummaryResults)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type MongoDbCancelCommand.
func (m MongoDbCancelCommand) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["commandType"] = "cancel"
	populate(objectMap, "errors", m.Errors)
	populate(objectMap, "input", m.Input)
	populate(objectMap, "state", m.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MongoDbCancelCommand.
func (m *MongoDbCancelCommand) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "commandType":
			err = unpopulate(val, "CommandType", &m.CommandType)
			delete(rawMsg, key)
		case "errors":
			err = unpopulate(val, "Errors", &m.Errors)
			delete(rawMsg, key)
		case "input":
			err = unpopulate(val, "Input", &m.Input)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &m.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MongoDbClusterInfo.
func (m MongoDbClusterInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "databases", m.Databases)
	populate(objectMap, "supportsSharding", m.SupportsSharding)
	populate(objectMap, "type", m.Type)
	populate(objectMap, "version", m.Version)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type MongoDbCollectionProgress.
func (m MongoDbCollectionProgress) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "bytesCopied", m.BytesCopied)
	populate(objectMap, "documentsCopied", m.DocumentsCopied)
	populate(objectMap, "elapsedTime", m.ElapsedTime)
	populate(objectMap, "errors", m.Errors)
	populate(objectMap, "eventsPending", m.EventsPending)
	populate(objectMap, "eventsReplayed", m.EventsReplayed)
	populateTimeRFC3339(objectMap, "lastEventTime", m.LastEventTime)
	populateTimeRFC3339(objectMap, "lastReplayTime", m.LastReplayTime)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "qualifiedName", m.QualifiedName)
	objectMap["resultType"] = MongoDbProgressResultTypeCollection
	populate(objectMap, "state", m.State)
	populate(objectMap, "totalBytes", m.TotalBytes)
	populate(objectMap, "totalDocuments", m.TotalDocuments)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MongoDbCollectionProgress.
func (m *MongoDbCollectionProgress) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bytesCopied":
			err = unpopulate(val, "BytesCopied", &m.BytesCopied)
			delete(rawMsg, key)
		case "documentsCopied":
			err = unpopulate(val, "DocumentsCopied", &m.DocumentsCopied)
			delete(rawMsg, key)
		case "elapsedTime":
			err = unpopulate(val, "ElapsedTime", &m.ElapsedTime)
			delete(rawMsg, key)
		case "errors":
			err = unpopulate(val, "Errors", &m.Errors)
			delete(rawMsg, key)
		case "eventsPending":
			err = unpopulate(val, "EventsPending", &m.EventsPending)
			delete(rawMsg, key)
		case "eventsReplayed":
			err = unpopulate(val, "EventsReplayed", &m.EventsReplayed)
			delete(rawMsg, key)
		case "lastEventTime":
			err = unpopulateTimeRFC3339(val, "LastEventTime", &m.LastEventTime)
			delete(rawMsg, key)
		case "lastReplayTime":
			err = unpopulateTimeRFC3339(val, "LastReplayTime", &m.LastReplayTime)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "qualifiedName":
			err = unpopulate(val, "QualifiedName", &m.QualifiedName)
			delete(rawMsg, key)
		case "resultType":
			err = unpopulate(val, "ResultType", &m.ResultType)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &m.State)
			delete(rawMsg, key)
		case "totalBytes":
			err = unpopulate(val, "TotalBytes", &m.TotalBytes)
			delete(rawMsg, key)
		case "totalDocuments":
			err = unpopulate(val, "TotalDocuments", &m.TotalDocuments)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MongoDbConnectionInfo.
func (m MongoDbConnectionInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "connectionString", m.ConnectionString)
	populate(objectMap, "password", m.Password)
	objectMap["type"] = "MongoDbConnectionInfo"
	populate(objectMap, "userName", m.UserName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MongoDbConnectionInfo.
func (m *MongoDbConnectionInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "connectionString":
			err = unpopulate(val, "ConnectionString", &m.ConnectionString)
			delete(rawMsg, key)
		case "password":
			err = unpopulate(val, "Password", &m.Password)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		case "userName":
			err = unpopulate(val, "UserName", &m.UserName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MongoDbDatabaseInfo.
func (m MongoDbDatabaseInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "averageDocumentSize", m.AverageDocumentSize)
	populate(objectMap, "collections", m.Collections)
	populate(objectMap, "dataSize", m.DataSize)
	populate(objectMap, "documentCount", m.DocumentCount)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "qualifiedName", m.QualifiedName)
	populate(objectMap, "supportsSharding", m.SupportsSharding)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type MongoDbDatabaseProgress.
func (m MongoDbDatabaseProgress) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "bytesCopied", m.BytesCopied)
	populate(objectMap, "collections", m.Collections)
	populate(objectMap, "documentsCopied", m.DocumentsCopied)
	populate(objectMap, "elapsedTime", m.ElapsedTime)
	populate(objectMap, "errors", m.Errors)
	populate(objectMap, "eventsPending", m.EventsPending)
	populate(objectMap, "eventsReplayed", m.EventsReplayed)
	populateTimeRFC3339(objectMap, "lastEventTime", m.LastEventTime)
	populateTimeRFC3339(objectMap, "lastReplayTime", m.LastReplayTime)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "qualifiedName", m.QualifiedName)
	objectMap["resultType"] = MongoDbProgressResultTypeDatabase
	populate(objectMap, "state", m.State)
	populate(objectMap, "totalBytes", m.TotalBytes)
	populate(objectMap, "totalDocuments", m.TotalDocuments)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MongoDbDatabaseProgress.
func (m *MongoDbDatabaseProgress) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bytesCopied":
			err = unpopulate(val, "BytesCopied", &m.BytesCopied)
			delete(rawMsg, key)
		case "collections":
			err = unpopulate(val, "Collections", &m.Collections)
			delete(rawMsg, key)
		case "documentsCopied":
			err = unpopulate(val, "DocumentsCopied", &m.DocumentsCopied)
			delete(rawMsg, key)
		case "elapsedTime":
			err = unpopulate(val, "ElapsedTime", &m.ElapsedTime)
			delete(rawMsg, key)
		case "errors":
			err = unpopulate(val, "Errors", &m.Errors)
			delete(rawMsg, key)
		case "eventsPending":
			err = unpopulate(val, "EventsPending", &m.EventsPending)
			delete(rawMsg, key)
		case "eventsReplayed":
			err = unpopulate(val, "EventsReplayed", &m.EventsReplayed)
			delete(rawMsg, key)
		case "lastEventTime":
			err = unpopulateTimeRFC3339(val, "LastEventTime", &m.LastEventTime)
			delete(rawMsg, key)
		case "lastReplayTime":
			err = unpopulateTimeRFC3339(val, "LastReplayTime", &m.LastReplayTime)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "qualifiedName":
			err = unpopulate(val, "QualifiedName", &m.QualifiedName)
			delete(rawMsg, key)
		case "resultType":
			err = unpopulate(val, "ResultType", &m.ResultType)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &m.State)
			delete(rawMsg, key)
		case "totalBytes":
			err = unpopulate(val, "TotalBytes", &m.TotalBytes)
			delete(rawMsg, key)
		case "totalDocuments":
			err = unpopulate(val, "TotalDocuments", &m.TotalDocuments)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MongoDbDatabaseSettings.
func (m MongoDbDatabaseSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "collections", m.Collections)
	populate(objectMap, "targetRUs", m.TargetRUs)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type MongoDbFinishCommand.
func (m MongoDbFinishCommand) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["commandType"] = "finish"
	populate(objectMap, "errors", m.Errors)
	populate(objectMap, "input", m.Input)
	populate(objectMap, "state", m.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MongoDbFinishCommand.
func (m *MongoDbFinishCommand) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "commandType":
			err = unpopulate(val, "CommandType", &m.CommandType)
			delete(rawMsg, key)
		case "errors":
			err = unpopulate(val, "Errors", &m.Errors)
			delete(rawMsg, key)
		case "input":
			err = unpopulate(val, "Input", &m.Input)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &m.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MongoDbMigrationProgress.
func (m MongoDbMigrationProgress) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "bytesCopied", m.BytesCopied)
	populate(objectMap, "databases", m.Databases)
	populate(objectMap, "documentsCopied", m.DocumentsCopied)
	populate(objectMap, "elapsedTime", m.ElapsedTime)
	populate(objectMap, "errors", m.Errors)
	populate(objectMap, "eventsPending", m.EventsPending)
	populate(objectMap, "eventsReplayed", m.EventsReplayed)
	populateTimeRFC3339(objectMap, "lastEventTime", m.LastEventTime)
	populateTimeRFC3339(objectMap, "lastReplayTime", m.LastReplayTime)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "qualifiedName", m.QualifiedName)
	objectMap["resultType"] = MongoDbProgressResultTypeMigration
	populate(objectMap, "state", m.State)
	populate(objectMap, "totalBytes", m.TotalBytes)
	populate(objectMap, "totalDocuments", m.TotalDocuments)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MongoDbMigrationProgress.
func (m *MongoDbMigrationProgress) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bytesCopied":
			err = unpopulate(val, "BytesCopied", &m.BytesCopied)
			delete(rawMsg, key)
		case "databases":
			err = unpopulate(val, "Databases", &m.Databases)
			delete(rawMsg, key)
		case "documentsCopied":
			err = unpopulate(val, "DocumentsCopied", &m.DocumentsCopied)
			delete(rawMsg, key)
		case "elapsedTime":
			err = unpopulate(val, "ElapsedTime", &m.ElapsedTime)
			delete(rawMsg, key)
		case "errors":
			err = unpopulate(val, "Errors", &m.Errors)
			delete(rawMsg, key)
		case "eventsPending":
			err = unpopulate(val, "EventsPending", &m.EventsPending)
			delete(rawMsg, key)
		case "eventsReplayed":
			err = unpopulate(val, "EventsReplayed", &m.EventsReplayed)
			delete(rawMsg, key)
		case "lastEventTime":
			err = unpopulateTimeRFC3339(val, "LastEventTime", &m.LastEventTime)
			delete(rawMsg, key)
		case "lastReplayTime":
			err = unpopulateTimeRFC3339(val, "LastReplayTime", &m.LastReplayTime)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "qualifiedName":
			err = unpopulate(val, "QualifiedName", &m.QualifiedName)
			delete(rawMsg, key)
		case "resultType":
			err = unpopulate(val, "ResultType", &m.ResultType)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &m.State)
			delete(rawMsg, key)
		case "totalBytes":
			err = unpopulate(val, "TotalBytes", &m.TotalBytes)
			delete(rawMsg, key)
		case "totalDocuments":
			err = unpopulate(val, "TotalDocuments", &m.TotalDocuments)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MongoDbMigrationSettings.
func (m MongoDbMigrationSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "boostRUs", m.BoostRUs)
	populate(objectMap, "databases", m.Databases)
	populate(objectMap, "replication", m.Replication)
	populate(objectMap, "source", m.Source)
	populate(objectMap, "target", m.Target)
	populate(objectMap, "throttling", m.Throttling)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type MongoDbProgress.
func (m MongoDbProgress) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "bytesCopied", m.BytesCopied)
	populate(objectMap, "documentsCopied", m.DocumentsCopied)
	populate(objectMap, "elapsedTime", m.ElapsedTime)
	populate(objectMap, "errors", m.Errors)
	populate(objectMap, "eventsPending", m.EventsPending)
	populate(objectMap, "eventsReplayed", m.EventsReplayed)
	populateTimeRFC3339(objectMap, "lastEventTime", m.LastEventTime)
	populateTimeRFC3339(objectMap, "lastReplayTime", m.LastReplayTime)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "qualifiedName", m.QualifiedName)
	objectMap["resultType"] = m.ResultType
	populate(objectMap, "state", m.State)
	populate(objectMap, "totalBytes", m.TotalBytes)
	populate(objectMap, "totalDocuments", m.TotalDocuments)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MongoDbProgress.
func (m *MongoDbProgress) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bytesCopied":
			err = unpopulate(val, "BytesCopied", &m.BytesCopied)
			delete(rawMsg, key)
		case "documentsCopied":
			err = unpopulate(val, "DocumentsCopied", &m.DocumentsCopied)
			delete(rawMsg, key)
		case "elapsedTime":
			err = unpopulate(val, "ElapsedTime", &m.ElapsedTime)
			delete(rawMsg, key)
		case "errors":
			err = unpopulate(val, "Errors", &m.Errors)
			delete(rawMsg, key)
		case "eventsPending":
			err = unpopulate(val, "EventsPending", &m.EventsPending)
			delete(rawMsg, key)
		case "eventsReplayed":
			err = unpopulate(val, "EventsReplayed", &m.EventsReplayed)
			delete(rawMsg, key)
		case "lastEventTime":
			err = unpopulateTimeRFC3339(val, "LastEventTime", &m.LastEventTime)
			delete(rawMsg, key)
		case "lastReplayTime":
			err = unpopulateTimeRFC3339(val, "LastReplayTime", &m.LastReplayTime)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "qualifiedName":
			err = unpopulate(val, "QualifiedName", &m.QualifiedName)
			delete(rawMsg, key)
		case "resultType":
			err = unpopulate(val, "ResultType", &m.ResultType)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &m.State)
			delete(rawMsg, key)
		case "totalBytes":
			err = unpopulate(val, "TotalBytes", &m.TotalBytes)
			delete(rawMsg, key)
		case "totalDocuments":
			err = unpopulate(val, "TotalDocuments", &m.TotalDocuments)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MongoDbRestartCommand.
func (m MongoDbRestartCommand) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["commandType"] = "restart"
	populate(objectMap, "errors", m.Errors)
	populate(objectMap, "input", m.Input)
	populate(objectMap, "state", m.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MongoDbRestartCommand.
func (m *MongoDbRestartCommand) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "commandType":
			err = unpopulate(val, "CommandType", &m.CommandType)
			delete(rawMsg, key)
		case "errors":
			err = unpopulate(val, "Errors", &m.Errors)
			delete(rawMsg, key)
		case "input":
			err = unpopulate(val, "Input", &m.Input)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &m.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MongoDbShardKeyInfo.
func (m MongoDbShardKeyInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "fields", m.Fields)
	populate(objectMap, "isUnique", m.IsUnique)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type MongoDbShardKeySetting.
func (m MongoDbShardKeySetting) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "fields", m.Fields)
	populate(objectMap, "isUnique", m.IsUnique)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type MySQLConnectionInfo.
func (m MySQLConnectionInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "encryptConnection", m.EncryptConnection)
	populate(objectMap, "password", m.Password)
	populate(objectMap, "port", m.Port)
	populate(objectMap, "serverName", m.ServerName)
	objectMap["type"] = "MySqlConnectionInfo"
	populate(objectMap, "userName", m.UserName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MySQLConnectionInfo.
func (m *MySQLConnectionInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "encryptConnection":
			err = unpopulate(val, "EncryptConnection", &m.EncryptConnection)
			delete(rawMsg, key)
		case "password":
			err = unpopulate(val, "Password", &m.Password)
			delete(rawMsg, key)
		case "port":
			err = unpopulate(val, "Port", &m.Port)
			delete(rawMsg, key)
		case "serverName":
			err = unpopulate(val, "ServerName", &m.ServerName)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		case "userName":
			err = unpopulate(val, "UserName", &m.UserName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NonSQLMigrationTaskOutput.
func (n *NonSQLMigrationTaskOutput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataMigrationTableResults":
			err = unpopulate(val, "DataMigrationTableResults", &n.DataMigrationTableResults)
			delete(rawMsg, key)
		case "endedOn":
			err = unpopulateTimeRFC3339(val, "EndedOn", &n.EndedOn)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &n.ID)
			delete(rawMsg, key)
		case "progressMessage":
			err = unpopulate(val, "ProgressMessage", &n.ProgressMessage)
			delete(rawMsg, key)
		case "sourceServerName":
			err = unpopulate(val, "SourceServerName", &n.SourceServerName)
			delete(rawMsg, key)
		case "startedOn":
			err = unpopulateTimeRFC3339(val, "StartedOn", &n.StartedOn)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &n.Status)
			delete(rawMsg, key)
		case "targetServerName":
			err = unpopulate(val, "TargetServerName", &n.TargetServerName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ODataError.
func (o ODataError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "code", o.Code)
	populate(objectMap, "details", o.Details)
	populate(objectMap, "message", o.Message)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type OracleConnectionInfo.
func (o OracleConnectionInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "dataSource", o.DataSource)
	populate(objectMap, "password", o.Password)
	objectMap["type"] = "OracleConnectionInfo"
	populate(objectMap, "userName", o.UserName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OracleConnectionInfo.
func (o *OracleConnectionInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataSource":
			err = unpopulate(val, "DataSource", &o.DataSource)
			delete(rawMsg, key)
		case "password":
			err = unpopulate(val, "Password", &o.Password)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &o.Type)
			delete(rawMsg, key)
		case "userName":
			err = unpopulate(val, "UserName", &o.UserName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OracleOCIDriverInfo.
func (o OracleOCIDriverInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "archiveChecksum", o.ArchiveChecksum)
	populate(objectMap, "assemblyVersion", o.AssemblyVersion)
	populate(objectMap, "driverName", o.DriverName)
	populate(objectMap, "driverSize", o.DriverSize)
	populate(objectMap, "oracleChecksum", o.OracleChecksum)
	populate(objectMap, "supportedOracleVersions", o.SupportedOracleVersions)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type PostgreSQLConnectionInfo.
func (p PostgreSQLConnectionInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "databaseName", p.DatabaseName)
	populate(objectMap, "encryptConnection", p.EncryptConnection)
	populate(objectMap, "password", p.Password)
	populate(objectMap, "port", p.Port)
	populate(objectMap, "serverName", p.ServerName)
	populate(objectMap, "trustServerCertificate", p.TrustServerCertificate)
	objectMap["type"] = "PostgreSqlConnectionInfo"
	populate(objectMap, "userName", p.UserName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PostgreSQLConnectionInfo.
func (p *PostgreSQLConnectionInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "databaseName":
			err = unpopulate(val, "DatabaseName", &p.DatabaseName)
			delete(rawMsg, key)
		case "encryptConnection":
			err = unpopulate(val, "EncryptConnection", &p.EncryptConnection)
			delete(rawMsg, key)
		case "password":
			err = unpopulate(val, "Password", &p.Password)
			delete(rawMsg, key)
		case "port":
			err = unpopulate(val, "Port", &p.Port)
			delete(rawMsg, key)
		case "serverName":
			err = unpopulate(val, "ServerName", &p.ServerName)
			delete(rawMsg, key)
		case "trustServerCertificate":
			err = unpopulate(val, "TrustServerCertificate", &p.TrustServerCertificate)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		case "userName":
			err = unpopulate(val, "UserName", &p.UserName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Project.
func (p Project) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", p.ID)
	populate(objectMap, "location", p.Location)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "systemData", p.SystemData)
	populate(objectMap, "tags", p.Tags)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ProjectFile.
func (p ProjectFile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "etag", p.Etag)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "systemData", p.SystemData)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ProjectFileProperties.
func (p ProjectFileProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "extension", p.Extension)
	populate(objectMap, "filePath", p.FilePath)
	populateTimeRFC3339(objectMap, "lastModified", p.LastModified)
	populate(objectMap, "mediaType", p.MediaType)
	populate(objectMap, "size", p.Size)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProjectFileProperties.
func (p *ProjectFileProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "extension":
			err = unpopulate(val, "Extension", &p.Extension)
			delete(rawMsg, key)
		case "filePath":
			err = unpopulate(val, "FilePath", &p.FilePath)
			delete(rawMsg, key)
		case "lastModified":
			err = unpopulateTimeRFC3339(val, "LastModified", &p.LastModified)
			delete(rawMsg, key)
		case "mediaType":
			err = unpopulate(val, "MediaType", &p.MediaType)
			delete(rawMsg, key)
		case "size":
			err = unpopulate(val, "Size", &p.Size)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProjectProperties.
func (p ProjectProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "creationTime", p.CreationTime)
	populate(objectMap, "databasesInfo", p.DatabasesInfo)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	populate(objectMap, "sourceConnectionInfo", p.SourceConnectionInfo)
	populate(objectMap, "sourcePlatform", p.SourcePlatform)
	populate(objectMap, "targetConnectionInfo", p.TargetConnectionInfo)
	populate(objectMap, "targetPlatform", p.TargetPlatform)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProjectProperties.
func (p *ProjectProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "creationTime":
			err = unpopulateTimeRFC3339(val, "CreationTime", &p.CreationTime)
			delete(rawMsg, key)
		case "databasesInfo":
			err = unpopulate(val, "DatabasesInfo", &p.DatabasesInfo)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &p.ProvisioningState)
			delete(rawMsg, key)
		case "sourceConnectionInfo":
			p.SourceConnectionInfo, err = unmarshalConnectionInfoClassification(val)
			delete(rawMsg, key)
		case "sourcePlatform":
			err = unpopulate(val, "SourcePlatform", &p.SourcePlatform)
			delete(rawMsg, key)
		case "targetConnectionInfo":
			p.TargetConnectionInfo, err = unmarshalConnectionInfoClassification(val)
			delete(rawMsg, key)
		case "targetPlatform":
			err = unpopulate(val, "TargetPlatform", &p.TargetPlatform)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProjectTask.
func (p ProjectTask) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "etag", p.Etag)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "systemData", p.SystemData)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProjectTask.
func (p *ProjectTask) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &p.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			p.Properties, err = unmarshalProjectTaskPropertiesClassification(val)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &p.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProjectTaskProperties.
func (p ProjectTaskProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "clientData", p.ClientData)
	populate(objectMap, "commands", p.Commands)
	populate(objectMap, "errors", p.Errors)
	populate(objectMap, "state", p.State)
	objectMap["taskType"] = p.TaskType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProjectTaskProperties.
func (p *ProjectTaskProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientData":
			err = unpopulate(val, "ClientData", &p.ClientData)
			delete(rawMsg, key)
		case "commands":
			p.Commands, err = unmarshalCommandPropertiesClassificationArray(val)
			delete(rawMsg, key)
		case "errors":
			err = unpopulate(val, "Errors", &p.Errors)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &p.State)
			delete(rawMsg, key)
		case "taskType":
			err = unpopulate(val, "TaskType", &p.TaskType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SQLConnectionInfo.
func (s SQLConnectionInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "additionalSettings", s.AdditionalSettings)
	populate(objectMap, "authentication", s.Authentication)
	populate(objectMap, "dataSource", s.DataSource)
	populate(objectMap, "encryptConnection", s.EncryptConnection)
	populate(objectMap, "password", s.Password)
	populate(objectMap, "platform", s.Platform)
	populate(objectMap, "trustServerCertificate", s.TrustServerCertificate)
	objectMap["type"] = "SqlConnectionInfo"
	populate(objectMap, "userName", s.UserName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SQLConnectionInfo.
func (s *SQLConnectionInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalSettings":
			err = unpopulate(val, "AdditionalSettings", &s.AdditionalSettings)
			delete(rawMsg, key)
		case "authentication":
			err = unpopulate(val, "Authentication", &s.Authentication)
			delete(rawMsg, key)
		case "dataSource":
			err = unpopulate(val, "DataSource", &s.DataSource)
			delete(rawMsg, key)
		case "encryptConnection":
			err = unpopulate(val, "EncryptConnection", &s.EncryptConnection)
			delete(rawMsg, key)
		case "password":
			err = unpopulate(val, "Password", &s.Password)
			delete(rawMsg, key)
		case "platform":
			err = unpopulate(val, "Platform", &s.Platform)
			delete(rawMsg, key)
		case "trustServerCertificate":
			err = unpopulate(val, "TrustServerCertificate", &s.TrustServerCertificate)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		case "userName":
			err = unpopulate(val, "UserName", &s.UserName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SQLServerSQLMISyncTaskInput.
func (s SQLServerSQLMISyncTaskInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "azureApp", s.AzureApp)
	populate(objectMap, "backupFileShare", s.BackupFileShare)
	populate(objectMap, "selectedDatabases", s.SelectedDatabases)
	populate(objectMap, "sourceConnectionInfo", s.SourceConnectionInfo)
	populate(objectMap, "storageResourceId", s.StorageResourceID)
	populate(objectMap, "targetConnectionInfo", s.TargetConnectionInfo)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type SchemaComparisonValidationResult.
func (s SchemaComparisonValidationResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "schemaDifferences", s.SchemaDifferences)
	populate(objectMap, "sourceDatabaseObjectCount", s.SourceDatabaseObjectCount)
	populate(objectMap, "targetDatabaseObjectCount", s.TargetDatabaseObjectCount)
	populate(objectMap, "validationErrors", s.ValidationErrors)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type Service.
func (s Service) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "etag", s.Etag)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "kind", s.Kind)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "sku", s.SKU)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type SystemData.
func (s SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "createdByType", s.CreatedByType)
	populateTimeRFC3339(objectMap, "lastModifiedAt", s.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", s.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemData.
func (s *SystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &s.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateTimeRFC3339(val, "LastModifiedAt", &s.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &s.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TrackedResource.
func (t TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", t.ID)
	populate(objectMap, "location", t.Location)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "systemData", t.SystemData)
	populate(objectMap, "tags", t.Tags)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type UploadOCIDriverTaskOutput.
func (u UploadOCIDriverTaskOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "driverPackageName", u.DriverPackageName)
	populate(objectMap, "validationErrors", u.ValidationErrors)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type UploadOCIDriverTaskProperties.
func (u UploadOCIDriverTaskProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "clientData", u.ClientData)
	populate(objectMap, "commands", u.Commands)
	populate(objectMap, "errors", u.Errors)
	populate(objectMap, "input", u.Input)
	populate(objectMap, "output", u.Output)
	populate(objectMap, "state", u.State)
	objectMap["taskType"] = "Service.Upload.OCI"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UploadOCIDriverTaskProperties.
func (u *UploadOCIDriverTaskProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientData":
			err = unpopulate(val, "ClientData", &u.ClientData)
			delete(rawMsg, key)
		case "commands":
			u.Commands, err = unmarshalCommandPropertiesClassificationArray(val)
			delete(rawMsg, key)
		case "errors":
			err = unpopulate(val, "Errors", &u.Errors)
			delete(rawMsg, key)
		case "input":
			err = unpopulate(val, "Input", &u.Input)
			delete(rawMsg, key)
		case "output":
			err = unpopulate(val, "Output", &u.Output)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &u.State)
			delete(rawMsg, key)
		case "taskType":
			err = unpopulate(val, "TaskType", &u.TaskType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ValidateMigrationInputSQLServerSQLDbSyncTaskProperties.
func (v ValidateMigrationInputSQLServerSQLDbSyncTaskProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "clientData", v.ClientData)
	populate(objectMap, "commands", v.Commands)
	populate(objectMap, "errors", v.Errors)
	populate(objectMap, "input", v.Input)
	populate(objectMap, "output", v.Output)
	populate(objectMap, "state", v.State)
	objectMap["taskType"] = "ValidateMigrationInput.SqlServer.SqlDb.Sync"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ValidateMigrationInputSQLServerSQLDbSyncTaskProperties.
func (v *ValidateMigrationInputSQLServerSQLDbSyncTaskProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientData":
			err = unpopulate(val, "ClientData", &v.ClientData)
			delete(rawMsg, key)
		case "commands":
			v.Commands, err = unmarshalCommandPropertiesClassificationArray(val)
			delete(rawMsg, key)
		case "errors":
			err = unpopulate(val, "Errors", &v.Errors)
			delete(rawMsg, key)
		case "input":
			err = unpopulate(val, "Input", &v.Input)
			delete(rawMsg, key)
		case "output":
			err = unpopulate(val, "Output", &v.Output)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &v.State)
			delete(rawMsg, key)
		case "taskType":
			err = unpopulate(val, "TaskType", &v.TaskType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ValidateMigrationInputSQLServerSQLMISyncTaskInput.
func (v ValidateMigrationInputSQLServerSQLMISyncTaskInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "azureApp", v.AzureApp)
	populate(objectMap, "backupFileShare", v.BackupFileShare)
	populate(objectMap, "selectedDatabases", v.SelectedDatabases)
	populate(objectMap, "sourceConnectionInfo", v.SourceConnectionInfo)
	populate(objectMap, "storageResourceId", v.StorageResourceID)
	populate(objectMap, "targetConnectionInfo", v.TargetConnectionInfo)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ValidateMigrationInputSQLServerSQLMISyncTaskOutput.
func (v ValidateMigrationInputSQLServerSQLMISyncTaskOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", v.ID)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "validationErrors", v.ValidationErrors)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ValidateMigrationInputSQLServerSQLMISyncTaskProperties.
func (v ValidateMigrationInputSQLServerSQLMISyncTaskProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "clientData", v.ClientData)
	populate(objectMap, "commands", v.Commands)
	populate(objectMap, "errors", v.Errors)
	populate(objectMap, "input", v.Input)
	populate(objectMap, "output", v.Output)
	populate(objectMap, "state", v.State)
	objectMap["taskType"] = "ValidateMigrationInput.SqlServer.AzureSqlDbMI.Sync.LRS"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ValidateMigrationInputSQLServerSQLMISyncTaskProperties.
func (v *ValidateMigrationInputSQLServerSQLMISyncTaskProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientData":
			err = unpopulate(val, "ClientData", &v.ClientData)
			delete(rawMsg, key)
		case "commands":
			v.Commands, err = unmarshalCommandPropertiesClassificationArray(val)
			delete(rawMsg, key)
		case "errors":
			err = unpopulate(val, "Errors", &v.Errors)
			delete(rawMsg, key)
		case "input":
			err = unpopulate(val, "Input", &v.Input)
			delete(rawMsg, key)
		case "output":
			err = unpopulate(val, "Output", &v.Output)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &v.State)
			delete(rawMsg, key)
		case "taskType":
			err = unpopulate(val, "TaskType", &v.TaskType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ValidateMigrationInputSQLServerSQLMITaskInput.
func (v ValidateMigrationInputSQLServerSQLMITaskInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "backupBlobShare", v.BackupBlobShare)
	populate(objectMap, "backupFileShare", v.BackupFileShare)
	populate(objectMap, "backupMode", v.BackupMode)
	populate(objectMap, "selectedDatabases", v.SelectedDatabases)
	populate(objectMap, "selectedLogins", v.SelectedLogins)
	populate(objectMap, "sourceConnectionInfo", v.SourceConnectionInfo)
	populate(objectMap, "targetConnectionInfo", v.TargetConnectionInfo)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ValidateMigrationInputSQLServerSQLMITaskOutput.
func (v ValidateMigrationInputSQLServerSQLMITaskOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "backupFolderErrors", v.BackupFolderErrors)
	populate(objectMap, "backupShareCredentialsErrors", v.BackupShareCredentialsErrors)
	populate(objectMap, "backupStorageAccountErrors", v.BackupStorageAccountErrors)
	populate(objectMap, "databaseBackupInfo", v.DatabaseBackupInfo)
	populate(objectMap, "existingBackupErrors", v.ExistingBackupErrors)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "restoreDatabaseNameErrors", v.RestoreDatabaseNameErrors)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ValidateMigrationInputSQLServerSQLMITaskProperties.
func (v ValidateMigrationInputSQLServerSQLMITaskProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "clientData", v.ClientData)
	populate(objectMap, "commands", v.Commands)
	populate(objectMap, "errors", v.Errors)
	populate(objectMap, "input", v.Input)
	populate(objectMap, "output", v.Output)
	populate(objectMap, "state", v.State)
	objectMap["taskType"] = "ValidateMigrationInput.SqlServer.AzureSqlDbMI"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ValidateMigrationInputSQLServerSQLMITaskProperties.
func (v *ValidateMigrationInputSQLServerSQLMITaskProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientData":
			err = unpopulate(val, "ClientData", &v.ClientData)
			delete(rawMsg, key)
		case "commands":
			v.Commands, err = unmarshalCommandPropertiesClassificationArray(val)
			delete(rawMsg, key)
		case "errors":
			err = unpopulate(val, "Errors", &v.Errors)
			delete(rawMsg, key)
		case "input":
			err = unpopulate(val, "Input", &v.Input)
			delete(rawMsg, key)
		case "output":
			err = unpopulate(val, "Output", &v.Output)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &v.State)
			delete(rawMsg, key)
		case "taskType":
			err = unpopulate(val, "TaskType", &v.TaskType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ValidateMongoDbTaskProperties.
func (v ValidateMongoDbTaskProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "clientData", v.ClientData)
	populate(objectMap, "commands", v.Commands)
	populate(objectMap, "errors", v.Errors)
	populate(objectMap, "input", v.Input)
	populate(objectMap, "output", v.Output)
	populate(objectMap, "state", v.State)
	objectMap["taskType"] = "Validate.MongoDb"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ValidateMongoDbTaskProperties.
func (v *ValidateMongoDbTaskProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientData":
			err = unpopulate(val, "ClientData", &v.ClientData)
			delete(rawMsg, key)
		case "commands":
			v.Commands, err = unmarshalCommandPropertiesClassificationArray(val)
			delete(rawMsg, key)
		case "errors":
			err = unpopulate(val, "Errors", &v.Errors)
			delete(rawMsg, key)
		case "input":
			err = unpopulate(val, "Input", &v.Input)
			delete(rawMsg, key)
		case "output":
			err = unpopulate(val, "Output", &v.Output)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &v.State)
			delete(rawMsg, key)
		case "taskType":
			err = unpopulate(val, "TaskType", &v.TaskType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ValidateOracleAzureDbForPostgreSQLSyncTaskProperties.
func (v ValidateOracleAzureDbForPostgreSQLSyncTaskProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "clientData", v.ClientData)
	populate(objectMap, "commands", v.Commands)
	populate(objectMap, "errors", v.Errors)
	populate(objectMap, "input", v.Input)
	populate(objectMap, "output", v.Output)
	populate(objectMap, "state", v.State)
	objectMap["taskType"] = "Validate.Oracle.AzureDbPostgreSql.Sync"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ValidateOracleAzureDbForPostgreSQLSyncTaskProperties.
func (v *ValidateOracleAzureDbForPostgreSQLSyncTaskProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientData":
			err = unpopulate(val, "ClientData", &v.ClientData)
			delete(rawMsg, key)
		case "commands":
			v.Commands, err = unmarshalCommandPropertiesClassificationArray(val)
			delete(rawMsg, key)
		case "errors":
			err = unpopulate(val, "Errors", &v.Errors)
			delete(rawMsg, key)
		case "input":
			err = unpopulate(val, "Input", &v.Input)
			delete(rawMsg, key)
		case "output":
			err = unpopulate(val, "Output", &v.Output)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &v.State)
			delete(rawMsg, key)
		case "taskType":
			err = unpopulate(val, "TaskType", &v.TaskType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ValidateOracleAzureDbPostgreSQLSyncTaskOutput.
func (v ValidateOracleAzureDbPostgreSQLSyncTaskOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "validationErrors", v.ValidationErrors)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ValidateSyncMigrationInputSQLServerTaskInput.
func (v ValidateSyncMigrationInputSQLServerTaskInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "selectedDatabases", v.SelectedDatabases)
	populate(objectMap, "sourceConnectionInfo", v.SourceConnectionInfo)
	populate(objectMap, "targetConnectionInfo", v.TargetConnectionInfo)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ValidateSyncMigrationInputSQLServerTaskOutput.
func (v ValidateSyncMigrationInputSQLServerTaskOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", v.ID)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "validationErrors", v.ValidationErrors)
	return json.Marshal(objectMap)
}

func populate(m map[string]interface{}, k string, v interface{}) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v interface{}) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
