//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armcontainerregistry_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/containerregistry/armcontainerregistry"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/tree/main/specification/containerregistry/resource-manager/Microsoft.ContainerRegistry/preview/2019-06-01-preview/examples/TasksList.json
func ExampleTasksClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client, err := armcontainerregistry.NewTasksClient("4385cf00-2d3a-425a-832f-f4285b1c9dce", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := client.NewListPager("myResourceGroup",
		"myRegistry",
		nil)
	for pager.More() {
		nextResult, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range nextResult.Value {
			// TODO: use page item
			_ = v
		}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/tree/main/specification/containerregistry/resource-manager/Microsoft.ContainerRegistry/preview/2019-06-01-preview/examples/TasksGet.json
func ExampleTasksClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client, err := armcontainerregistry.NewTasksClient("4385cf00-2d3a-425a-832f-f4285b1c9dce", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := client.Get(ctx,
		"myResourceGroup",
		"myRegistry",
		"myTask",
		nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// TODO: use response item
	_ = res
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/tree/main/specification/containerregistry/resource-manager/Microsoft.ContainerRegistry/preview/2019-06-01-preview/examples/TasksCreate.json
func ExampleTasksClient_BeginCreate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client, err := armcontainerregistry.NewTasksClient("4385cf00-2d3a-425a-832f-f4285b1c9dce", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := client.BeginCreate(ctx,
		"myResourceGroup",
		"myRegistry",
		"mytTask",
		armcontainerregistry.Task{
			Location: to.Ptr("eastus"),
			Tags: map[string]*string{
				"testkey": to.Ptr("value"),
			},
			Identity: &armcontainerregistry.IdentityProperties{
				Type: to.Ptr(armcontainerregistry.ResourceIdentityTypeSystemAssigned),
			},
			Properties: &armcontainerregistry.TaskProperties{
				AgentConfiguration: &armcontainerregistry.AgentProperties{
					CPU: to.Ptr[int32](2),
				},
				IsSystemTask: to.Ptr(false),
				LogTemplate:  to.Ptr("acr/tasks:{{.Run.OS}}"),
				Platform: &armcontainerregistry.PlatformProperties{
					Architecture: to.Ptr(armcontainerregistry.ArchitectureAmd64),
					OS:           to.Ptr(armcontainerregistry.OSLinux),
				},
				Status: to.Ptr(armcontainerregistry.TaskStatusEnabled),
				Step: &armcontainerregistry.DockerBuildStep{
					Type:        to.Ptr(armcontainerregistry.StepTypeDocker),
					ContextPath: to.Ptr("src"),
					Arguments: []*armcontainerregistry.Argument{
						{
							Name:     to.Ptr("mytestargument"),
							IsSecret: to.Ptr(false),
							Value:    to.Ptr("mytestvalue"),
						},
						{
							Name:     to.Ptr("mysecrettestargument"),
							IsSecret: to.Ptr(true),
							Value:    to.Ptr("mysecrettestvalue"),
						}},
					DockerFilePath: to.Ptr("src/DockerFile"),
					ImageNames: []*string{
						to.Ptr("azurerest:testtag")},
					IsPushEnabled: to.Ptr(true),
					NoCache:       to.Ptr(false),
				},
				Trigger: &armcontainerregistry.TriggerProperties{
					BaseImageTrigger: &armcontainerregistry.BaseImageTrigger{
						Name:                     to.Ptr("myBaseImageTrigger"),
						BaseImageTriggerType:     to.Ptr(armcontainerregistry.BaseImageTriggerTypeRuntime),
						UpdateTriggerEndpoint:    to.Ptr("https://user:pass@mycicd.webhook.com?token=foo"),
						UpdateTriggerPayloadType: to.Ptr(armcontainerregistry.UpdateTriggerPayloadTypeToken),
					},
					SourceTriggers: []*armcontainerregistry.SourceTrigger{
						{
							Name: to.Ptr("mySourceTrigger"),
							SourceRepository: &armcontainerregistry.SourceProperties{
								Branch:        to.Ptr("master"),
								RepositoryURL: to.Ptr("https://github.com/Azure/azure-rest-api-specs"),
								SourceControlAuthProperties: &armcontainerregistry.AuthInfo{
									Token:     to.Ptr("xxxxx"),
									TokenType: to.Ptr(armcontainerregistry.TokenTypePAT),
								},
								SourceControlType: to.Ptr(armcontainerregistry.SourceControlTypeGithub),
							},
							SourceTriggerEvents: []*armcontainerregistry.SourceTriggerEvent{
								to.Ptr(armcontainerregistry.SourceTriggerEventCommit)},
						}},
					TimerTriggers: []*armcontainerregistry.TimerTrigger{
						{
							Name:     to.Ptr("myTimerTrigger"),
							Schedule: to.Ptr("30 9 * * 1-5"),
						}},
				},
			},
		},
		nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// TODO: use response item
	_ = res
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/tree/main/specification/containerregistry/resource-manager/Microsoft.ContainerRegistry/preview/2019-06-01-preview/examples/TasksDelete.json
func ExampleTasksClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client, err := armcontainerregistry.NewTasksClient("4385cf00-2d3a-425a-832f-f4285b1c9dce", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := client.BeginDelete(ctx,
		"myResourceGroup",
		"myRegistry",
		"myTask",
		nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/tree/main/specification/containerregistry/resource-manager/Microsoft.ContainerRegistry/preview/2019-06-01-preview/examples/TasksUpdate.json
func ExampleTasksClient_BeginUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client, err := armcontainerregistry.NewTasksClient("4385cf00-2d3a-425a-832f-f4285b1c9dce", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := client.BeginUpdate(ctx,
		"myResourceGroup",
		"myRegistry",
		"myTask",
		armcontainerregistry.TaskUpdateParameters{
			Properties: &armcontainerregistry.TaskPropertiesUpdateParameters{
				AgentConfiguration: &armcontainerregistry.AgentProperties{
					CPU: to.Ptr[int32](3),
				},
				Credentials: &armcontainerregistry.Credentials{
					CustomRegistries: map[string]*armcontainerregistry.CustomRegistryCredentials{
						"myregistry.azurecr.io": {
							Identity: to.Ptr("[system]"),
							Password: &armcontainerregistry.SecretObject{
								Type:  to.Ptr(armcontainerregistry.SecretObjectTypeVaultsecret),
								Value: to.Ptr("https://myacbvault.vault.azure.net/secrets/password"),
							},
							UserName: &armcontainerregistry.SecretObject{
								Type:  to.Ptr(armcontainerregistry.SecretObjectTypeOpaque),
								Value: to.Ptr("username"),
							},
						},
					},
				},
				LogTemplate: to.Ptr("acr/tasks:{{.Run.OS}}"),
				Status:      to.Ptr(armcontainerregistry.TaskStatusEnabled),
				Step: &armcontainerregistry.DockerBuildStepUpdateParameters{
					Type:           to.Ptr(armcontainerregistry.StepTypeDocker),
					DockerFilePath: to.Ptr("src/DockerFile"),
					ImageNames: []*string{
						to.Ptr("azurerest:testtag1")},
				},
				Trigger: &armcontainerregistry.TriggerUpdateParameters{
					SourceTriggers: []*armcontainerregistry.SourceTriggerUpdateParameters{
						{
							Name: to.Ptr("mySourceTrigger"),
							SourceRepository: &armcontainerregistry.SourceUpdateParameters{
								SourceControlAuthProperties: &armcontainerregistry.AuthInfoUpdateParameters{
									Token:     to.Ptr("xxxxx"),
									TokenType: to.Ptr(armcontainerregistry.TokenTypePAT),
								},
							},
							SourceTriggerEvents: []*armcontainerregistry.SourceTriggerEvent{
								to.Ptr(armcontainerregistry.SourceTriggerEventCommit)},
						}},
				},
			},
			Tags: map[string]*string{
				"testkey": to.Ptr("value"),
			},
		},
		nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// TODO: use response item
	_ = res
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/tree/main/specification/containerregistry/resource-manager/Microsoft.ContainerRegistry/preview/2019-06-01-preview/examples/TasksGetDetails.json
func ExampleTasksClient_GetDetails() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client, err := armcontainerregistry.NewTasksClient("4385cf00-2d3a-425a-832f-f4285b1c9dce", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := client.GetDetails(ctx,
		"myResourceGroup",
		"myRegistry",
		"myTask",
		nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// TODO: use response item
	_ = res
}
