//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armappservice

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strconv"
	"strings"
)

// DomainsClient contains the methods for the Domains group.
// Don't use this type directly, use NewDomainsClient() instead.
type DomainsClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewDomainsClient creates a new instance of DomainsClient with the specified values.
// subscriptionID - Your Azure subscription ID. This is a GUID-formatted string (e.g. 00000000-0000-0000-0000-000000000000).
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewDomainsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*DomainsClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &DomainsClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// CheckAvailability - Description for Check if a domain is available for registration.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// identifier - Name of the domain.
// options - DomainsClientCheckAvailabilityOptions contains the optional parameters for the DomainsClient.CheckAvailability
// method.
func (client *DomainsClient) CheckAvailability(ctx context.Context, identifier NameIdentifier, options *DomainsClientCheckAvailabilityOptions) (DomainsClientCheckAvailabilityResponse, error) {
	req, err := client.checkAvailabilityCreateRequest(ctx, identifier, options)
	if err != nil {
		return DomainsClientCheckAvailabilityResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return DomainsClientCheckAvailabilityResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return DomainsClientCheckAvailabilityResponse{}, runtime.NewResponseError(resp)
	}
	return client.checkAvailabilityHandleResponse(resp)
}

// checkAvailabilityCreateRequest creates the CheckAvailability request.
func (client *DomainsClient) checkAvailabilityCreateRequest(ctx context.Context, identifier NameIdentifier, options *DomainsClientCheckAvailabilityOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.DomainRegistration/checkDomainAvailability"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, identifier)
}

// checkAvailabilityHandleResponse handles the CheckAvailability response.
func (client *DomainsClient) checkAvailabilityHandleResponse(resp *http.Response) (DomainsClientCheckAvailabilityResponse, error) {
	result := DomainsClientCheckAvailabilityResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DomainAvailabilityCheckResult); err != nil {
		return DomainsClientCheckAvailabilityResponse{}, err
	}
	return result, nil
}

// BeginCreateOrUpdate - Description for Creates or updates a domain.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// domainName - Name of the domain.
// domain - Domain registration information.
// options - DomainsClientBeginCreateOrUpdateOptions contains the optional parameters for the DomainsClient.BeginCreateOrUpdate
// method.
func (client *DomainsClient) BeginCreateOrUpdate(ctx context.Context, resourceGroupName string, domainName string, domain Domain, options *DomainsClientBeginCreateOrUpdateOptions) (*runtime.Poller[DomainsClientCreateOrUpdateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createOrUpdate(ctx, resourceGroupName, domainName, domain, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[DomainsClientCreateOrUpdateResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[DomainsClientCreateOrUpdateResponse](options.ResumeToken, client.pl, nil)
	}
}

// CreateOrUpdate - Description for Creates or updates a domain.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
func (client *DomainsClient) createOrUpdate(ctx context.Context, resourceGroupName string, domainName string, domain Domain, options *DomainsClientBeginCreateOrUpdateOptions) (*http.Response, error) {
	req, err := client.createOrUpdateCreateRequest(ctx, resourceGroupName, domainName, domain, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *DomainsClient) createOrUpdateCreateRequest(ctx context.Context, resourceGroupName string, domainName string, domain Domain, options *DomainsClientBeginCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if domainName == "" {
		return nil, errors.New("parameter domainName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{domainName}", url.PathEscape(domainName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, domain)
}

// CreateOrUpdateOwnershipIdentifier - Description for Creates an ownership identifier for a domain or updates identifier
// details for an existing identifier
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// domainName - Name of domain.
// name - Name of identifier.
// domainOwnershipIdentifier - A JSON representation of the domain ownership properties.
// options - DomainsClientCreateOrUpdateOwnershipIdentifierOptions contains the optional parameters for the DomainsClient.CreateOrUpdateOwnershipIdentifier
// method.
func (client *DomainsClient) CreateOrUpdateOwnershipIdentifier(ctx context.Context, resourceGroupName string, domainName string, name string, domainOwnershipIdentifier DomainOwnershipIdentifier, options *DomainsClientCreateOrUpdateOwnershipIdentifierOptions) (DomainsClientCreateOrUpdateOwnershipIdentifierResponse, error) {
	req, err := client.createOrUpdateOwnershipIdentifierCreateRequest(ctx, resourceGroupName, domainName, name, domainOwnershipIdentifier, options)
	if err != nil {
		return DomainsClientCreateOrUpdateOwnershipIdentifierResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return DomainsClientCreateOrUpdateOwnershipIdentifierResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return DomainsClientCreateOrUpdateOwnershipIdentifierResponse{}, runtime.NewResponseError(resp)
	}
	return client.createOrUpdateOwnershipIdentifierHandleResponse(resp)
}

// createOrUpdateOwnershipIdentifierCreateRequest creates the CreateOrUpdateOwnershipIdentifier request.
func (client *DomainsClient) createOrUpdateOwnershipIdentifierCreateRequest(ctx context.Context, resourceGroupName string, domainName string, name string, domainOwnershipIdentifier DomainOwnershipIdentifier, options *DomainsClientCreateOrUpdateOwnershipIdentifierOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}/domainOwnershipIdentifiers/{name}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if domainName == "" {
		return nil, errors.New("parameter domainName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{domainName}", url.PathEscape(domainName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, domainOwnershipIdentifier)
}

// createOrUpdateOwnershipIdentifierHandleResponse handles the CreateOrUpdateOwnershipIdentifier response.
func (client *DomainsClient) createOrUpdateOwnershipIdentifierHandleResponse(resp *http.Response) (DomainsClientCreateOrUpdateOwnershipIdentifierResponse, error) {
	result := DomainsClientCreateOrUpdateOwnershipIdentifierResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DomainOwnershipIdentifier); err != nil {
		return DomainsClientCreateOrUpdateOwnershipIdentifierResponse{}, err
	}
	return result, nil
}

// Delete - Description for Delete a domain.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// domainName - Name of the domain.
// options - DomainsClientDeleteOptions contains the optional parameters for the DomainsClient.Delete method.
func (client *DomainsClient) Delete(ctx context.Context, resourceGroupName string, domainName string, options *DomainsClientDeleteOptions) (DomainsClientDeleteResponse, error) {
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, domainName, options)
	if err != nil {
		return DomainsClientDeleteResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return DomainsClientDeleteResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusNoContent) {
		return DomainsClientDeleteResponse{}, runtime.NewResponseError(resp)
	}
	return DomainsClientDeleteResponse{}, nil
}

// deleteCreateRequest creates the Delete request.
func (client *DomainsClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, domainName string, options *DomainsClientDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if domainName == "" {
		return nil, errors.New("parameter domainName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{domainName}", url.PathEscape(domainName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.ForceHardDeleteDomain != nil {
		reqQP.Set("forceHardDeleteDomain", strconv.FormatBool(*options.ForceHardDeleteDomain))
	}
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// DeleteOwnershipIdentifier - Description for Delete ownership identifier for domain
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// domainName - Name of domain.
// name - Name of identifier.
// options - DomainsClientDeleteOwnershipIdentifierOptions contains the optional parameters for the DomainsClient.DeleteOwnershipIdentifier
// method.
func (client *DomainsClient) DeleteOwnershipIdentifier(ctx context.Context, resourceGroupName string, domainName string, name string, options *DomainsClientDeleteOwnershipIdentifierOptions) (DomainsClientDeleteOwnershipIdentifierResponse, error) {
	req, err := client.deleteOwnershipIdentifierCreateRequest(ctx, resourceGroupName, domainName, name, options)
	if err != nil {
		return DomainsClientDeleteOwnershipIdentifierResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return DomainsClientDeleteOwnershipIdentifierResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusNoContent) {
		return DomainsClientDeleteOwnershipIdentifierResponse{}, runtime.NewResponseError(resp)
	}
	return DomainsClientDeleteOwnershipIdentifierResponse{}, nil
}

// deleteOwnershipIdentifierCreateRequest creates the DeleteOwnershipIdentifier request.
func (client *DomainsClient) deleteOwnershipIdentifierCreateRequest(ctx context.Context, resourceGroupName string, domainName string, name string, options *DomainsClientDeleteOwnershipIdentifierOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}/domainOwnershipIdentifiers/{name}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if domainName == "" {
		return nil, errors.New("parameter domainName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{domainName}", url.PathEscape(domainName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Get - Description for Get a domain.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// domainName - Name of the domain.
// options - DomainsClientGetOptions contains the optional parameters for the DomainsClient.Get method.
func (client *DomainsClient) Get(ctx context.Context, resourceGroupName string, domainName string, options *DomainsClientGetOptions) (DomainsClientGetResponse, error) {
	req, err := client.getCreateRequest(ctx, resourceGroupName, domainName, options)
	if err != nil {
		return DomainsClientGetResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return DomainsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return DomainsClientGetResponse{}, runtime.NewResponseError(resp)
	}
	return client.getHandleResponse(resp)
}

// getCreateRequest creates the Get request.
func (client *DomainsClient) getCreateRequest(ctx context.Context, resourceGroupName string, domainName string, options *DomainsClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if domainName == "" {
		return nil, errors.New("parameter domainName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{domainName}", url.PathEscape(domainName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *DomainsClient) getHandleResponse(resp *http.Response) (DomainsClientGetResponse, error) {
	result := DomainsClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Domain); err != nil {
		return DomainsClientGetResponse{}, err
	}
	return result, nil
}

// GetControlCenterSsoRequest - Description for Generate a single sign-on request for the domain management portal.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// options - DomainsClientGetControlCenterSsoRequestOptions contains the optional parameters for the DomainsClient.GetControlCenterSsoRequest
// method.
func (client *DomainsClient) GetControlCenterSsoRequest(ctx context.Context, options *DomainsClientGetControlCenterSsoRequestOptions) (DomainsClientGetControlCenterSsoRequestResponse, error) {
	req, err := client.getControlCenterSsoRequestCreateRequest(ctx, options)
	if err != nil {
		return DomainsClientGetControlCenterSsoRequestResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return DomainsClientGetControlCenterSsoRequestResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return DomainsClientGetControlCenterSsoRequestResponse{}, runtime.NewResponseError(resp)
	}
	return client.getControlCenterSsoRequestHandleResponse(resp)
}

// getControlCenterSsoRequestCreateRequest creates the GetControlCenterSsoRequest request.
func (client *DomainsClient) getControlCenterSsoRequestCreateRequest(ctx context.Context, options *DomainsClientGetControlCenterSsoRequestOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.DomainRegistration/generateSsoRequest"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getControlCenterSsoRequestHandleResponse handles the GetControlCenterSsoRequest response.
func (client *DomainsClient) getControlCenterSsoRequestHandleResponse(resp *http.Response) (DomainsClientGetControlCenterSsoRequestResponse, error) {
	result := DomainsClientGetControlCenterSsoRequestResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DomainControlCenterSsoRequest); err != nil {
		return DomainsClientGetControlCenterSsoRequestResponse{}, err
	}
	return result, nil
}

// GetOwnershipIdentifier - Description for Get ownership identifier for domain
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// domainName - Name of domain.
// name - Name of identifier.
// options - DomainsClientGetOwnershipIdentifierOptions contains the optional parameters for the DomainsClient.GetOwnershipIdentifier
// method.
func (client *DomainsClient) GetOwnershipIdentifier(ctx context.Context, resourceGroupName string, domainName string, name string, options *DomainsClientGetOwnershipIdentifierOptions) (DomainsClientGetOwnershipIdentifierResponse, error) {
	req, err := client.getOwnershipIdentifierCreateRequest(ctx, resourceGroupName, domainName, name, options)
	if err != nil {
		return DomainsClientGetOwnershipIdentifierResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return DomainsClientGetOwnershipIdentifierResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return DomainsClientGetOwnershipIdentifierResponse{}, runtime.NewResponseError(resp)
	}
	return client.getOwnershipIdentifierHandleResponse(resp)
}

// getOwnershipIdentifierCreateRequest creates the GetOwnershipIdentifier request.
func (client *DomainsClient) getOwnershipIdentifierCreateRequest(ctx context.Context, resourceGroupName string, domainName string, name string, options *DomainsClientGetOwnershipIdentifierOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}/domainOwnershipIdentifiers/{name}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if domainName == "" {
		return nil, errors.New("parameter domainName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{domainName}", url.PathEscape(domainName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getOwnershipIdentifierHandleResponse handles the GetOwnershipIdentifier response.
func (client *DomainsClient) getOwnershipIdentifierHandleResponse(resp *http.Response) (DomainsClientGetOwnershipIdentifierResponse, error) {
	result := DomainsClientGetOwnershipIdentifierResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DomainOwnershipIdentifier); err != nil {
		return DomainsClientGetOwnershipIdentifierResponse{}, err
	}
	return result, nil
}

// NewListPager - Description for Get all domains in a subscription.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// options - DomainsClientListOptions contains the optional parameters for the DomainsClient.List method.
func (client *DomainsClient) NewListPager(options *DomainsClientListOptions) *runtime.Pager[DomainsClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[DomainsClientListResponse]{
		More: func(page DomainsClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *DomainsClientListResponse) (DomainsClientListResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listCreateRequest(ctx, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return DomainsClientListResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return DomainsClientListResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return DomainsClientListResponse{}, runtime.NewResponseError(resp)
			}
			return client.listHandleResponse(resp)
		},
	})
}

// listCreateRequest creates the List request.
func (client *DomainsClient) listCreateRequest(ctx context.Context, options *DomainsClientListOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.DomainRegistration/domains"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *DomainsClient) listHandleResponse(resp *http.Response) (DomainsClientListResponse, error) {
	result := DomainsClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DomainCollection); err != nil {
		return DomainsClientListResponse{}, err
	}
	return result, nil
}

// NewListByResourceGroupPager - Description for Get all domains in a resource group.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// options - DomainsClientListByResourceGroupOptions contains the optional parameters for the DomainsClient.ListByResourceGroup
// method.
func (client *DomainsClient) NewListByResourceGroupPager(resourceGroupName string, options *DomainsClientListByResourceGroupOptions) *runtime.Pager[DomainsClientListByResourceGroupResponse] {
	return runtime.NewPager(runtime.PagingHandler[DomainsClientListByResourceGroupResponse]{
		More: func(page DomainsClientListByResourceGroupResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *DomainsClientListByResourceGroupResponse) (DomainsClientListByResourceGroupResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listByResourceGroupCreateRequest(ctx, resourceGroupName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return DomainsClientListByResourceGroupResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return DomainsClientListByResourceGroupResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return DomainsClientListByResourceGroupResponse{}, runtime.NewResponseError(resp)
			}
			return client.listByResourceGroupHandleResponse(resp)
		},
	})
}

// listByResourceGroupCreateRequest creates the ListByResourceGroup request.
func (client *DomainsClient) listByResourceGroupCreateRequest(ctx context.Context, resourceGroupName string, options *DomainsClientListByResourceGroupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByResourceGroupHandleResponse handles the ListByResourceGroup response.
func (client *DomainsClient) listByResourceGroupHandleResponse(resp *http.Response) (DomainsClientListByResourceGroupResponse, error) {
	result := DomainsClientListByResourceGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DomainCollection); err != nil {
		return DomainsClientListByResourceGroupResponse{}, err
	}
	return result, nil
}

// NewListOwnershipIdentifiersPager - Description for Lists domain ownership identifiers.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// domainName - Name of domain.
// options - DomainsClientListOwnershipIdentifiersOptions contains the optional parameters for the DomainsClient.ListOwnershipIdentifiers
// method.
func (client *DomainsClient) NewListOwnershipIdentifiersPager(resourceGroupName string, domainName string, options *DomainsClientListOwnershipIdentifiersOptions) *runtime.Pager[DomainsClientListOwnershipIdentifiersResponse] {
	return runtime.NewPager(runtime.PagingHandler[DomainsClientListOwnershipIdentifiersResponse]{
		More: func(page DomainsClientListOwnershipIdentifiersResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *DomainsClientListOwnershipIdentifiersResponse) (DomainsClientListOwnershipIdentifiersResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listOwnershipIdentifiersCreateRequest(ctx, resourceGroupName, domainName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return DomainsClientListOwnershipIdentifiersResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return DomainsClientListOwnershipIdentifiersResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return DomainsClientListOwnershipIdentifiersResponse{}, runtime.NewResponseError(resp)
			}
			return client.listOwnershipIdentifiersHandleResponse(resp)
		},
	})
}

// listOwnershipIdentifiersCreateRequest creates the ListOwnershipIdentifiers request.
func (client *DomainsClient) listOwnershipIdentifiersCreateRequest(ctx context.Context, resourceGroupName string, domainName string, options *DomainsClientListOwnershipIdentifiersOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}/domainOwnershipIdentifiers"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if domainName == "" {
		return nil, errors.New("parameter domainName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{domainName}", url.PathEscape(domainName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listOwnershipIdentifiersHandleResponse handles the ListOwnershipIdentifiers response.
func (client *DomainsClient) listOwnershipIdentifiersHandleResponse(resp *http.Response) (DomainsClientListOwnershipIdentifiersResponse, error) {
	result := DomainsClientListOwnershipIdentifiersResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DomainOwnershipIdentifierCollection); err != nil {
		return DomainsClientListOwnershipIdentifiersResponse{}, err
	}
	return result, nil
}

// NewListRecommendationsPager - Description for Get domain name recommendations based on keywords.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// parameters - Search parameters for domain name recommendations.
// options - DomainsClientListRecommendationsOptions contains the optional parameters for the DomainsClient.ListRecommendations
// method.
func (client *DomainsClient) NewListRecommendationsPager(parameters DomainRecommendationSearchParameters, options *DomainsClientListRecommendationsOptions) *runtime.Pager[DomainsClientListRecommendationsResponse] {
	return runtime.NewPager(runtime.PagingHandler[DomainsClientListRecommendationsResponse]{
		More: func(page DomainsClientListRecommendationsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *DomainsClientListRecommendationsResponse) (DomainsClientListRecommendationsResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listRecommendationsCreateRequest(ctx, parameters, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return DomainsClientListRecommendationsResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return DomainsClientListRecommendationsResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return DomainsClientListRecommendationsResponse{}, runtime.NewResponseError(resp)
			}
			return client.listRecommendationsHandleResponse(resp)
		},
	})
}

// listRecommendationsCreateRequest creates the ListRecommendations request.
func (client *DomainsClient) listRecommendationsCreateRequest(ctx context.Context, parameters DomainRecommendationSearchParameters, options *DomainsClientListRecommendationsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.DomainRegistration/listDomainRecommendations"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, parameters)
}

// listRecommendationsHandleResponse handles the ListRecommendations response.
func (client *DomainsClient) listRecommendationsHandleResponse(resp *http.Response) (DomainsClientListRecommendationsResponse, error) {
	result := DomainsClientListRecommendationsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.NameIdentifierCollection); err != nil {
		return DomainsClientListRecommendationsResponse{}, err
	}
	return result, nil
}

// Renew - Description for Renew a domain.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// domainName - Name of the domain.
// options - DomainsClientRenewOptions contains the optional parameters for the DomainsClient.Renew method.
func (client *DomainsClient) Renew(ctx context.Context, resourceGroupName string, domainName string, options *DomainsClientRenewOptions) (DomainsClientRenewResponse, error) {
	req, err := client.renewCreateRequest(ctx, resourceGroupName, domainName, options)
	if err != nil {
		return DomainsClientRenewResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return DomainsClientRenewResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted, http.StatusNoContent) {
		return DomainsClientRenewResponse{}, runtime.NewResponseError(resp)
	}
	return DomainsClientRenewResponse{}, nil
}

// renewCreateRequest creates the Renew request.
func (client *DomainsClient) renewCreateRequest(ctx context.Context, resourceGroupName string, domainName string, options *DomainsClientRenewOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}/renew"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if domainName == "" {
		return nil, errors.New("parameter domainName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{domainName}", url.PathEscape(domainName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// TransferOut - Transfer out domain to another registrar
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// domainName - Name of domain.
// options - DomainsClientTransferOutOptions contains the optional parameters for the DomainsClient.TransferOut method.
func (client *DomainsClient) TransferOut(ctx context.Context, resourceGroupName string, domainName string, options *DomainsClientTransferOutOptions) (DomainsClientTransferOutResponse, error) {
	req, err := client.transferOutCreateRequest(ctx, resourceGroupName, domainName, options)
	if err != nil {
		return DomainsClientTransferOutResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return DomainsClientTransferOutResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return DomainsClientTransferOutResponse{}, runtime.NewResponseError(resp)
	}
	return client.transferOutHandleResponse(resp)
}

// transferOutCreateRequest creates the TransferOut request.
func (client *DomainsClient) transferOutCreateRequest(ctx context.Context, resourceGroupName string, domainName string, options *DomainsClientTransferOutOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}/transferOut"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if domainName == "" {
		return nil, errors.New("parameter domainName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{domainName}", url.PathEscape(domainName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// transferOutHandleResponse handles the TransferOut response.
func (client *DomainsClient) transferOutHandleResponse(resp *http.Response) (DomainsClientTransferOutResponse, error) {
	result := DomainsClientTransferOutResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Domain); err != nil {
		return DomainsClientTransferOutResponse{}, err
	}
	return result, nil
}

// Update - Description for Creates or updates a domain.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// domainName - Name of the domain.
// domain - Domain registration information.
// options - DomainsClientUpdateOptions contains the optional parameters for the DomainsClient.Update method.
func (client *DomainsClient) Update(ctx context.Context, resourceGroupName string, domainName string, domain DomainPatchResource, options *DomainsClientUpdateOptions) (DomainsClientUpdateResponse, error) {
	req, err := client.updateCreateRequest(ctx, resourceGroupName, domainName, domain, options)
	if err != nil {
		return DomainsClientUpdateResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return DomainsClientUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted) {
		return DomainsClientUpdateResponse{}, runtime.NewResponseError(resp)
	}
	return client.updateHandleResponse(resp)
}

// updateCreateRequest creates the Update request.
func (client *DomainsClient) updateCreateRequest(ctx context.Context, resourceGroupName string, domainName string, domain DomainPatchResource, options *DomainsClientUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if domainName == "" {
		return nil, errors.New("parameter domainName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{domainName}", url.PathEscape(domainName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, domain)
}

// updateHandleResponse handles the Update response.
func (client *DomainsClient) updateHandleResponse(resp *http.Response) (DomainsClientUpdateResponse, error) {
	result := DomainsClientUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Domain); err != nil {
		return DomainsClientUpdateResponse{}, err
	}
	return result, nil
}

// UpdateOwnershipIdentifier - Description for Creates an ownership identifier for a domain or updates identifier details
// for an existing identifier
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// domainName - Name of domain.
// name - Name of identifier.
// domainOwnershipIdentifier - A JSON representation of the domain ownership properties.
// options - DomainsClientUpdateOwnershipIdentifierOptions contains the optional parameters for the DomainsClient.UpdateOwnershipIdentifier
// method.
func (client *DomainsClient) UpdateOwnershipIdentifier(ctx context.Context, resourceGroupName string, domainName string, name string, domainOwnershipIdentifier DomainOwnershipIdentifier, options *DomainsClientUpdateOwnershipIdentifierOptions) (DomainsClientUpdateOwnershipIdentifierResponse, error) {
	req, err := client.updateOwnershipIdentifierCreateRequest(ctx, resourceGroupName, domainName, name, domainOwnershipIdentifier, options)
	if err != nil {
		return DomainsClientUpdateOwnershipIdentifierResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return DomainsClientUpdateOwnershipIdentifierResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return DomainsClientUpdateOwnershipIdentifierResponse{}, runtime.NewResponseError(resp)
	}
	return client.updateOwnershipIdentifierHandleResponse(resp)
}

// updateOwnershipIdentifierCreateRequest creates the UpdateOwnershipIdentifier request.
func (client *DomainsClient) updateOwnershipIdentifierCreateRequest(ctx context.Context, resourceGroupName string, domainName string, name string, domainOwnershipIdentifier DomainOwnershipIdentifier, options *DomainsClientUpdateOwnershipIdentifierOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}/domainOwnershipIdentifiers/{name}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if domainName == "" {
		return nil, errors.New("parameter domainName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{domainName}", url.PathEscape(domainName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, domainOwnershipIdentifier)
}

// updateOwnershipIdentifierHandleResponse handles the UpdateOwnershipIdentifier response.
func (client *DomainsClient) updateOwnershipIdentifierHandleResponse(resp *http.Response) (DomainsClientUpdateOwnershipIdentifierResponse, error) {
	result := DomainsClientUpdateOwnershipIdentifierResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DomainOwnershipIdentifier); err != nil {
		return DomainsClientUpdateOwnershipIdentifierResponse{}, err
	}
	return result, nil
}
