# dependencies:
# GObject-2.0
# GLib-2.0
# immediate dependencies:
# GObject-2.0
# libraries:
# libgio-2.0.so.0
{.warning[UnusedImport]: off.}
import gobject, glib
const Lib = "libgio-2.0.so.0"
{.pragma: libprag, cdecl, dynlib: Lib.}

proc finalizeGObject*[T](o: ref T) =
  if not o.ignoreFinalizer:
    gobject.g_object_remove_toggle_ref(o.impl, gobject.toggleNotify, addr(o[]))

type
  Action00* = object of gobject.Object00
  Action* = ref object of gobject.Object

proc g_action_name_is_valid(actionName: cstring): gboolean {.
    importc, libprag.}

proc nameIsValid*(actionName: cstring): bool =
  toBool(g_action_name_is_valid(actionName))

proc g_action_parse_detailed_name(detailedName: cstring; actionName: var cstring;
    targetValue: var ptr glib.Variant00; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc parseDetailedName*(detailedName: cstring; actionName: var string;
    targetValue: var glib.Variant): bool =
  fnew(targetValue, finalizerunref)
  var gerror: ptr glib.Error
  var actionName_00: cstring
  let resul0 = g_action_parse_detailed_name(detailedName, actionName_00, cast[var ptr glib.Variant00](addr targetValue.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)
  if actionName.addr != nil:
    actionName = $(actionName_00)

proc g_action_print_detailed_name(actionName: cstring; targetValue: ptr glib.Variant00): cstring {.
    importc, libprag.}

proc printDetailedName*(actionName: cstring; targetValue: glib.Variant = nil): string =
  let resul0 = g_action_print_detailed_name(actionName, if targetValue.isNil: nil else: cast[ptr glib.Variant00](targetValue.impl))
  result = $resul0
  cogfree(resul0)

type
  PropertyAction* = ref object of gobject.Object
  PropertyAction00* = object of gobject.Object00

proc g_property_action_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(PropertyAction()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc g_property_action_new(name: cstring; `object`: ptr gobject.Object00;
    propertyName: cstring): ptr PropertyAction00 {.
    importc, libprag.}

proc newPropertyAction*(name: cstring; `object`: gobject.Object; propertyName: cstring): PropertyAction =
  let gobj = g_property_action_new(name, cast[ptr gobject.Object00](`object`.impl), propertyName)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newPropertyAction*(tdesc: typedesc; name: cstring; `object`: gobject.Object; propertyName: cstring): tdesc =
  assert(result is PropertyAction)
  let gobj = g_property_action_new(name, cast[ptr gobject.Object00](`object`.impl), propertyName)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initPropertyAction*[T](result: var T; name: cstring; `object`: gobject.Object; propertyName: cstring) {.deprecated.} =
  assert(result is PropertyAction)
  let gobj = g_property_action_new(name, cast[ptr gobject.Object00](`object`.impl), propertyName)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

type
  SimpleAction* = ref object of gobject.Object
  SimpleAction00* = object of gobject.Object00

proc g_simple_action_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(SimpleAction()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc scActivate*(self: SimpleAction;  p: proc (self: ptr SimpleAction00; parameter: ptr glib.Variant00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "activate", cast[GCallback](p), xdata, nil, cf)

proc scChangeState*(self: SimpleAction;  p: proc (self: ptr SimpleAction00; value: ptr glib.Variant00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "change-state", cast[GCallback](p), xdata, nil, cf)

proc g_simple_action_new(name: cstring; parameterType: ptr glib.VariantType00): ptr SimpleAction00 {.
    importc, libprag.}

proc newSimpleAction*(name: cstring; parameterType: glib.VariantType = nil): SimpleAction =
  let gobj = g_simple_action_new(name, if parameterType.isNil: nil else: cast[ptr glib.VariantType00](parameterType.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newSimpleAction*(tdesc: typedesc; name: cstring; parameterType: glib.VariantType = nil): tdesc =
  assert(result is SimpleAction)
  let gobj = g_simple_action_new(name, if parameterType.isNil: nil else: cast[ptr glib.VariantType00](parameterType.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initSimpleAction*[T](result: var T; name: cstring; parameterType: glib.VariantType = nil) {.deprecated.} =
  assert(result is SimpleAction)
  let gobj = g_simple_action_new(name, if parameterType.isNil: nil else: cast[ptr glib.VariantType00](parameterType.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_simple_action_new_stateful(name: cstring; parameterType: ptr glib.VariantType00;
    state: ptr glib.Variant00): ptr SimpleAction00 {.
    importc, libprag.}

proc newSimpleActionStateful*(name: cstring; parameterType: glib.VariantType = nil;
    state: glib.Variant): SimpleAction =
  let gobj = g_simple_action_new_stateful(name, if parameterType.isNil: nil else: cast[ptr glib.VariantType00](parameterType.impl), cast[ptr glib.Variant00](state.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newSimpleActionStateful*(tdesc: typedesc; name: cstring; parameterType: glib.VariantType = nil;
    state: glib.Variant): tdesc =
  assert(result is SimpleAction)
  let gobj = g_simple_action_new_stateful(name, if parameterType.isNil: nil else: cast[ptr glib.VariantType00](parameterType.impl), cast[ptr glib.Variant00](state.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initSimpleActionStateful*[T](result: var T; name: cstring; parameterType: glib.VariantType = nil;
    state: glib.Variant) {.deprecated.} =
  assert(result is SimpleAction)
  let gobj = g_simple_action_new_stateful(name, if parameterType.isNil: nil else: cast[ptr glib.VariantType00](parameterType.impl), cast[ptr glib.Variant00](state.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_simple_action_set_enabled(self: ptr SimpleAction00; enabled: gboolean) {.
    importc, libprag.}

proc setEnabled*(self: SimpleAction; enabled: bool = true) =
  g_simple_action_set_enabled(cast[ptr SimpleAction00](self.impl), gboolean(enabled))

proc `enabled=`*(self: SimpleAction; enabled: bool) =
  g_simple_action_set_enabled(cast[ptr SimpleAction00](self.impl), gboolean(enabled))

proc g_simple_action_set_state(self: ptr SimpleAction00; value: ptr glib.Variant00) {.
    importc, libprag.}

proc setState*(self: SimpleAction; value: glib.Variant) =
  g_simple_action_set_state(cast[ptr SimpleAction00](self.impl), cast[ptr glib.Variant00](value.impl))

proc `state=`*(self: SimpleAction; value: glib.Variant) =
  g_simple_action_set_state(cast[ptr SimpleAction00](self.impl), cast[ptr glib.Variant00](value.impl))

proc g_simple_action_set_state_hint(self: ptr SimpleAction00; stateHint: ptr glib.Variant00) {.
    importc, libprag.}

proc setStateHint*(self: SimpleAction; stateHint: glib.Variant = nil) =
  g_simple_action_set_state_hint(cast[ptr SimpleAction00](self.impl), if stateHint.isNil: nil else: cast[ptr glib.Variant00](stateHint.impl))

proc `stateHint=`*(self: SimpleAction; stateHint: glib.Variant = nil) =
  g_simple_action_set_state_hint(cast[ptr SimpleAction00](self.impl), if stateHint.isNil: nil else: cast[ptr glib.Variant00](stateHint.impl))

proc g_action_activate(self: ptr Action00; parameter: ptr glib.Variant00) {.
    importc, libprag.}

proc activate*(self: Action | PropertyAction | SimpleAction; parameter: glib.Variant = nil) =
  g_action_activate(cast[ptr Action00](self.impl), if parameter.isNil: nil else: cast[ptr glib.Variant00](parameter.impl))

proc g_action_change_state(self: ptr Action00; value: ptr glib.Variant00) {.
    importc, libprag.}

proc changeState*(self: Action | PropertyAction | SimpleAction;
    value: glib.Variant) =
  g_action_change_state(cast[ptr Action00](self.impl), cast[ptr glib.Variant00](value.impl))

proc g_action_get_enabled(self: ptr Action00): gboolean {.
    importc, libprag.}

proc getEnabled*(self: Action | PropertyAction | SimpleAction): bool =
  toBool(g_action_get_enabled(cast[ptr Action00](self.impl)))

proc enabled*(self: Action | PropertyAction | SimpleAction): bool =
  toBool(g_action_get_enabled(cast[ptr Action00](self.impl)))

proc g_action_get_name(self: ptr Action00): cstring {.
    importc, libprag.}

proc getName*(self: Action | PropertyAction | SimpleAction): string =
  result = $g_action_get_name(cast[ptr Action00](self.impl))

proc name*(self: Action | PropertyAction | SimpleAction): string =
  result = $g_action_get_name(cast[ptr Action00](self.impl))

proc g_action_get_parameter_type(self: ptr Action00): ptr glib.VariantType00 {.
    importc, libprag.}

proc getParameterType*(self: Action | PropertyAction | SimpleAction): glib.VariantType =
  let impl0 = g_action_get_parameter_type(cast[ptr Action00](self.impl))
  if impl0.isNil:
    return nil
  fnew(result, finalizerfree)
  result.impl = cast[typeof(result.impl)](g_boxed_copy(g_variant_type_get_gtype(), impl0))

proc parameterType*(self: Action | PropertyAction | SimpleAction): glib.VariantType =
  let impl0 = g_action_get_parameter_type(cast[ptr Action00](self.impl))
  if impl0.isNil:
    return nil
  fnew(result, finalizerfree)
  result.impl = cast[typeof(result.impl)](g_boxed_copy(g_variant_type_get_gtype(), impl0))

proc g_action_get_state(self: ptr Action00): ptr glib.Variant00 {.
    importc, libprag.}

proc getState*(self: Action | PropertyAction | SimpleAction): glib.Variant =
  fnew(result, finalizerunref)
  result.impl = g_action_get_state(cast[ptr Action00](self.impl))

proc state*(self: Action | PropertyAction | SimpleAction): glib.Variant =
  fnew(result, finalizerunref)
  result.impl = g_action_get_state(cast[ptr Action00](self.impl))

proc g_action_get_state_hint(self: ptr Action00): ptr glib.Variant00 {.
    importc, libprag.}

proc getStateHint*(self: Action | PropertyAction | SimpleAction): glib.Variant =
  let impl0 = g_action_get_state_hint(cast[ptr Action00](self.impl))
  if impl0.isNil:
    return nil
  fnew(result, finalizerunref)
  result.impl = impl0

proc stateHint*(self: Action | PropertyAction | SimpleAction): glib.Variant =
  let impl0 = g_action_get_state_hint(cast[ptr Action00](self.impl))
  if impl0.isNil:
    return nil
  fnew(result, finalizerunref)
  result.impl = impl0

proc g_action_get_state_type(self: ptr Action00): ptr glib.VariantType00 {.
    importc, libprag.}

proc getStateType*(self: Action | PropertyAction | SimpleAction): glib.VariantType =
  let impl0 = g_action_get_state_type(cast[ptr Action00](self.impl))
  if impl0.isNil:
    return nil
  fnew(result, finalizerfree)
  result.impl = cast[typeof(result.impl)](g_boxed_copy(g_variant_type_get_gtype(), impl0))

proc stateType*(self: Action | PropertyAction | SimpleAction): glib.VariantType =
  let impl0 = g_action_get_state_type(cast[ptr Action00](self.impl))
  if impl0.isNil:
    return nil
  fnew(result, finalizerfree)
  result.impl = cast[typeof(result.impl)](g_boxed_copy(g_variant_type_get_gtype(), impl0))

type
  ActionEntry00* {.pure.} = object
  ActionEntry* = ref object
    impl*: ptr ActionEntry00
    ignoreFinalizer*: bool

type
  ApplicationCommandLine* = ref object of gobject.Object
  ApplicationCommandLine00* = object of gobject.Object00

proc g_application_command_line_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(ApplicationCommandLine()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc g_application_command_line_get_arguments(self: ptr ApplicationCommandLine00;
    argc: var int32): ptr cstring {.
    importc, libprag.}

proc getArguments*(self: ApplicationCommandLine;
    argc: var int = cast[var int](nil)): seq[string] =
  var argc_00: int32
  let resul0 = g_application_command_line_get_arguments(cast[ptr ApplicationCommandLine00](self.impl), argc_00)
  result = cstringArrayToSeq(resul0)
  if argc.addr != nil:
    argc = int(argc_00)

proc g_application_command_line_get_cwd(self: ptr ApplicationCommandLine00): cstring {.
    importc, libprag.}

proc getCwd*(self: ApplicationCommandLine): string =
  let resul0 = g_application_command_line_get_cwd(cast[ptr ApplicationCommandLine00](self.impl))
  if resul0.isNil:
    return
  result = $resul0

proc cwd*(self: ApplicationCommandLine): string =
  let resul0 = g_application_command_line_get_cwd(cast[ptr ApplicationCommandLine00](self.impl))
  if resul0.isNil:
    return
  result = $resul0

proc g_application_command_line_get_environ(self: ptr ApplicationCommandLine00): ptr cstring {.
    importc, libprag.}

proc getEnviron*(self: ApplicationCommandLine): seq[string] =
  cstringArrayToSeq(g_application_command_line_get_environ(cast[ptr ApplicationCommandLine00](self.impl)))

proc environ*(self: ApplicationCommandLine): seq[string] =
  cstringArrayToSeq(g_application_command_line_get_environ(cast[ptr ApplicationCommandLine00](self.impl)))

proc g_application_command_line_get_exit_status(self: ptr ApplicationCommandLine00): int32 {.
    importc, libprag.}

proc getExitStatus*(self: ApplicationCommandLine): int =
  int(g_application_command_line_get_exit_status(cast[ptr ApplicationCommandLine00](self.impl)))

proc exitStatus*(self: ApplicationCommandLine): int =
  int(g_application_command_line_get_exit_status(cast[ptr ApplicationCommandLine00](self.impl)))

proc g_application_command_line_get_is_remote(self: ptr ApplicationCommandLine00): gboolean {.
    importc, libprag.}

proc getIsRemote*(self: ApplicationCommandLine): bool =
  toBool(g_application_command_line_get_is_remote(cast[ptr ApplicationCommandLine00](self.impl)))

proc isRemote*(self: ApplicationCommandLine): bool =
  toBool(g_application_command_line_get_is_remote(cast[ptr ApplicationCommandLine00](self.impl)))

proc g_application_command_line_get_options_dict(self: ptr ApplicationCommandLine00): ptr glib.VariantDict00 {.
    importc, libprag.}

proc getOptionsDict*(self: ApplicationCommandLine): glib.VariantDict =
  fnew(result, gBoxedFreeGVariantDict)
  result.impl = g_application_command_line_get_options_dict(cast[ptr ApplicationCommandLine00](self.impl))
  result.impl = cast[typeof(result.impl)](g_boxed_copy(g_variant_dict_get_type(), result.impl))

proc optionsDict*(self: ApplicationCommandLine): glib.VariantDict =
  fnew(result, gBoxedFreeGVariantDict)
  result.impl = g_application_command_line_get_options_dict(cast[ptr ApplicationCommandLine00](self.impl))
  result.impl = cast[typeof(result.impl)](g_boxed_copy(g_variant_dict_get_type(), result.impl))

proc g_application_command_line_get_platform_data(self: ptr ApplicationCommandLine00): ptr glib.Variant00 {.
    importc, libprag.}

proc getPlatformData*(self: ApplicationCommandLine): glib.Variant =
  let impl0 = g_application_command_line_get_platform_data(cast[ptr ApplicationCommandLine00](self.impl))
  if impl0.isNil:
    return nil
  fnew(result, finalizerunref)
  result.impl = impl0

proc platformData*(self: ApplicationCommandLine): glib.Variant =
  let impl0 = g_application_command_line_get_platform_data(cast[ptr ApplicationCommandLine00](self.impl))
  if impl0.isNil:
    return nil
  fnew(result, finalizerunref)
  result.impl = impl0

proc g_application_command_line_getenv(self: ptr ApplicationCommandLine00;
    name: cstring): cstring {.
    importc, libprag.}

proc getenv*(self: ApplicationCommandLine; name: cstring): string =
  result = $g_application_command_line_getenv(cast[ptr ApplicationCommandLine00](self.impl), name)

proc g_application_command_line_set_exit_status(self: ptr ApplicationCommandLine00;
    exitStatus: int32) {.
    importc, libprag.}

proc setExitStatus*(self: ApplicationCommandLine;
    exitStatus: int) =
  g_application_command_line_set_exit_status(cast[ptr ApplicationCommandLine00](self.impl), int32(exitStatus))

proc `exitStatus=`*(self: ApplicationCommandLine;
    exitStatus: int) =
  g_application_command_line_set_exit_status(cast[ptr ApplicationCommandLine00](self.impl), int32(exitStatus))

type
  GFile00* = object of gobject.Object00
  GFile* = ref object of gobject.Object

proc g_file_new_for_commandline_arg(arg: cstring): ptr GFile00 {.
    importc, libprag.}

proc newGFileForCommandlineArg*(arg: cstring): GFile =
  let gobj = g_file_new_for_commandline_arg(arg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_file_new_for_commandline_arg_and_cwd(arg: cstring; cwd: cstring): ptr GFile00 {.
    importc, libprag.}

proc newGFileForCommandlineArgAndCwd*(arg: cstring; cwd: cstring): GFile =
  let gobj = g_file_new_for_commandline_arg_and_cwd(arg, cwd)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_file_new_for_path(path: cstring): ptr GFile00 {.
    importc, libprag.}

proc newGFileForPath*(path: cstring): GFile =
  let gobj = g_file_new_for_path(path)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_file_new_for_uri(uri: cstring): ptr GFile00 {.
    importc, libprag.}

proc newGFileForUri*(uri: cstring): GFile =
  let gobj = g_file_new_for_uri(uri)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_file_parse_name(parseName: cstring): ptr GFile00 {.
    importc, libprag.}

proc parseName*(parseName: cstring): GFile =
  let gobj = g_file_parse_name(parseName)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_file_dup(self: ptr GFile00): ptr GFile00 {.
    importc, libprag.}

proc dup*(self: GFile): GFile =
  let gobj = g_file_dup(cast[ptr GFile00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_file_equal(self: ptr GFile00; file2: ptr GFile00): gboolean {.
    importc, libprag.}

proc equal*(self: GFile; file2: GFile): bool =
  toBool(g_file_equal(cast[ptr GFile00](self.impl), cast[ptr GFile00](file2.impl)))

proc g_file_get_basename(self: ptr GFile00): cstring {.
    importc, libprag.}

proc getBasename*(self: GFile): string =
  let resul0 = g_file_get_basename(cast[ptr GFile00](self.impl))
  if resul0.isNil:
    return
  result = $resul0
  cogfree(resul0)

proc basename*(self: GFile): string =
  let resul0 = g_file_get_basename(cast[ptr GFile00](self.impl))
  if resul0.isNil:
    return
  result = $resul0
  cogfree(resul0)

proc g_file_get_child(self: ptr GFile00; name: cstring): ptr GFile00 {.
    importc, libprag.}

proc getChild*(self: GFile; name: cstring): GFile =
  let gobj = g_file_get_child(cast[ptr GFile00](self.impl), name)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_file_get_child_for_display_name(self: ptr GFile00; displayName: cstring;
    error: ptr ptr glib.Error = nil): ptr GFile00 {.
    importc, libprag.}

proc getChildForDisplayName*(self: GFile; displayName: cstring): GFile =
  var gerror: ptr glib.Error
  let gobj = g_file_get_child_for_display_name(cast[ptr GFile00](self.impl), displayName, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_file_get_parent(self: ptr GFile00): ptr GFile00 {.
    importc, libprag.}

proc getParent*(self: GFile): GFile =
  let gobj = g_file_get_parent(cast[ptr GFile00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc parent*(self: GFile): GFile =
  let gobj = g_file_get_parent(cast[ptr GFile00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_file_get_parse_name(self: ptr GFile00): cstring {.
    importc, libprag.}

proc getParseName*(self: GFile): string =
  let resul0 = g_file_get_parse_name(cast[ptr GFile00](self.impl))
  result = $resul0
  cogfree(resul0)

proc parseName*(self: GFile): string =
  let resul0 = g_file_get_parse_name(cast[ptr GFile00](self.impl))
  result = $resul0
  cogfree(resul0)

proc g_file_get_path(self: ptr GFile00): cstring {.
    importc, libprag.}

proc getPath*(self: GFile): string =
  let resul0 = g_file_get_path(cast[ptr GFile00](self.impl))
  if resul0.isNil:
    return
  result = $resul0
  cogfree(resul0)

proc path*(self: GFile): string =
  let resul0 = g_file_get_path(cast[ptr GFile00](self.impl))
  if resul0.isNil:
    return
  result = $resul0
  cogfree(resul0)

proc g_file_get_relative_path(self: ptr GFile00; descendant: ptr GFile00): cstring {.
    importc, libprag.}

proc getRelativePath*(self: GFile; descendant: GFile): string =
  let resul0 = g_file_get_relative_path(cast[ptr GFile00](self.impl), cast[ptr GFile00](descendant.impl))
  if resul0.isNil:
    return
  result = $resul0
  cogfree(resul0)

proc g_file_get_uri(self: ptr GFile00): cstring {.
    importc, libprag.}

proc getUri*(self: GFile): string =
  let resul0 = g_file_get_uri(cast[ptr GFile00](self.impl))
  result = $resul0
  cogfree(resul0)

proc uri*(self: GFile): string =
  let resul0 = g_file_get_uri(cast[ptr GFile00](self.impl))
  result = $resul0
  cogfree(resul0)

proc g_file_get_uri_scheme(self: ptr GFile00): cstring {.
    importc, libprag.}

proc getUriScheme*(self: GFile): string =
  let resul0 = g_file_get_uri_scheme(cast[ptr GFile00](self.impl))
  result = $resul0
  cogfree(resul0)

proc uriScheme*(self: GFile): string =
  let resul0 = g_file_get_uri_scheme(cast[ptr GFile00](self.impl))
  result = $resul0
  cogfree(resul0)

proc g_file_has_parent(self: ptr GFile00; parent: ptr GFile00): gboolean {.
    importc, libprag.}

proc hasParent*(self: GFile; parent: GFile = nil): bool =
  toBool(g_file_has_parent(cast[ptr GFile00](self.impl), if parent.isNil: nil else: cast[ptr GFile00](parent.impl)))

proc g_file_has_prefix(self: ptr GFile00; prefix: ptr GFile00): gboolean {.
    importc, libprag.}

proc hasPrefix*(self: GFile; prefix: GFile): bool =
  toBool(g_file_has_prefix(cast[ptr GFile00](self.impl), cast[ptr GFile00](prefix.impl)))

proc g_file_has_uri_scheme(self: ptr GFile00; uriScheme: cstring): gboolean {.
    importc, libprag.}

proc hasUriScheme*(self: GFile; uriScheme: cstring): bool =
  toBool(g_file_has_uri_scheme(cast[ptr GFile00](self.impl), uriScheme))

proc g_file_hash(self: ptr GFile00): uint32 {.
    importc, libprag.}

proc hash*(self: GFile): int =
  int(g_file_hash(cast[ptr GFile00](self.impl)))

proc g_file_is_native(self: ptr GFile00): gboolean {.
    importc, libprag.}

proc isNative*(self: GFile): bool =
  toBool(g_file_is_native(cast[ptr GFile00](self.impl)))

proc g_file_peek_path(self: ptr GFile00): cstring {.
    importc, libprag.}

proc peekPath*(self: GFile): string =
  let resul0 = g_file_peek_path(cast[ptr GFile00](self.impl))
  if resul0.isNil:
    return
  result = $resul0

proc g_file_resolve_relative_path(self: ptr GFile00; relativePath: cstring): ptr GFile00 {.
    importc, libprag.}

proc resolveRelativePath*(self: GFile; relativePath: cstring): GFile =
  let gobj = g_file_resolve_relative_path(cast[ptr GFile00](self.impl), relativePath)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_file_supports_thread_contexts(self: ptr GFile00): gboolean {.
    importc, libprag.}

proc supportsThreadContexts*(self: GFile): bool =
  toBool(g_file_supports_thread_contexts(cast[ptr GFile00](self.impl)))

type
  GApplication* = ref object of gobject.Object
  GApplication00* = object of gobject.Object00

proc g_application_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(GApplication()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc scActivate*(self: GApplication;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "activate", cast[GCallback](p), xdata, nil, cf)

proc scCommandLine*(self: GApplication;  p: proc (self: ptr GApplication00; commandLine: ptr ApplicationCommandLine00; xdata: pointer): int32 {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "command-line", cast[GCallback](p), xdata, nil, cf)

proc scHandleLocalOptions*(self: GApplication;  p: proc (self: ptr GApplication00; options: ptr glib.VariantDict00; xdata: pointer): int32 {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "handle-local-options", cast[GCallback](p), xdata, nil, cf)

proc scNameLost*(self: GApplication;  p: proc (self: ptr GApplication00; xdata: pointer): gboolean {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "name-lost", cast[GCallback](p), xdata, nil, cf)

proc scOpen*(self: GApplication;  p: proc (self: ptr GApplication00; files: ptr GFile00; nFiles: int32; hint: cstring; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "open", cast[GCallback](p), xdata, nil, cf)

proc scShutdown*(self: GApplication;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "shutdown", cast[GCallback](p), xdata, nil, cf)

proc scStartup*(self: GApplication;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "startup", cast[GCallback](p), xdata, nil, cf)

proc g_application_get_default(): ptr GApplication00 {.
    importc, libprag.}

proc getDefaultGApplication*(): GApplication =
  let gobj = g_application_get_default()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_application_id_is_valid(applicationId: cstring): gboolean {.
    importc, libprag.}

proc idIsValid*(applicationId: cstring): bool =
  toBool(g_application_id_is_valid(applicationId))

proc g_application_activate(self: ptr GApplication00) {.
    importc, libprag.}

proc activate*(self: GApplication) =
  g_application_activate(cast[ptr GApplication00](self.impl))

proc g_application_add_main_option(self: ptr GApplication00; longName: cstring;
    shortName: int8; flags: glib.OptionFlags; arg: glib.OptionArg; description: cstring;
    argDescription: cstring) {.
    importc, libprag.}

proc addMainOption*(self: GApplication; longName: cstring;
    shortName: int8; flags: glib.OptionFlags; arg: glib.OptionArg; description: cstring;
    argDescription: cstring = nil) =
  g_application_add_main_option(cast[ptr GApplication00](self.impl), longName, shortName, flags, arg, description, argDescription)

proc g_application_add_main_option_entries(self: ptr GApplication00; entries: ptr glib.OptionEntry) {.
    importc, libprag.}

proc addMainOptionEntries*(self: GApplication; entries: ptr glib.OptionEntry) =
  g_application_add_main_option_entries(cast[ptr GApplication00](self.impl), entries)

proc g_application_add_option_group(self: ptr GApplication00; group: ptr glib.OptionGroup00) {.
    importc, libprag.}

proc addOptionGroup*(self: GApplication; group: glib.OptionGroup) =
  g_application_add_option_group(cast[ptr GApplication00](self.impl), cast[ptr glib.OptionGroup00](g_boxed_copy(g_option_group_get_type(), group.impl)))

proc g_application_bind_busy_property(self: ptr GApplication00; `object`: ptr gobject.Object00;
    property: cstring) {.
    importc, libprag.}

proc bindBusyProperty*(self: GApplication; `object`: gobject.Object;
    property: cstring) =
  g_application_bind_busy_property(cast[ptr GApplication00](self.impl), cast[ptr gobject.Object00](`object`.impl), property)

proc g_application_get_application_id(self: ptr GApplication00): cstring {.
    importc, libprag.}

proc getApplicationId*(self: GApplication): string =
  result = $g_application_get_application_id(cast[ptr GApplication00](self.impl))

proc applicationId*(self: GApplication): string =
  result = $g_application_get_application_id(cast[ptr GApplication00](self.impl))

proc g_application_get_dbus_object_path(self: ptr GApplication00): cstring {.
    importc, libprag.}

proc getDbusObjectPath*(self: GApplication): string =
  result = $g_application_get_dbus_object_path(cast[ptr GApplication00](self.impl))

proc dbusObjectPath*(self: GApplication): string =
  result = $g_application_get_dbus_object_path(cast[ptr GApplication00](self.impl))

proc g_application_get_inactivity_timeout(self: ptr GApplication00): uint32 {.
    importc, libprag.}

proc getInactivityTimeout*(self: GApplication): int =
  int(g_application_get_inactivity_timeout(cast[ptr GApplication00](self.impl)))

proc inactivityTimeout*(self: GApplication): int =
  int(g_application_get_inactivity_timeout(cast[ptr GApplication00](self.impl)))

proc g_application_get_is_busy(self: ptr GApplication00): gboolean {.
    importc, libprag.}

proc getIsBusy*(self: GApplication): bool =
  toBool(g_application_get_is_busy(cast[ptr GApplication00](self.impl)))

proc isBusy*(self: GApplication): bool =
  toBool(g_application_get_is_busy(cast[ptr GApplication00](self.impl)))

proc g_application_get_is_registered(self: ptr GApplication00): gboolean {.
    importc, libprag.}

proc getIsRegistered*(self: GApplication): bool =
  toBool(g_application_get_is_registered(cast[ptr GApplication00](self.impl)))

proc isRegistered*(self: GApplication): bool =
  toBool(g_application_get_is_registered(cast[ptr GApplication00](self.impl)))

proc g_application_get_is_remote(self: ptr GApplication00): gboolean {.
    importc, libprag.}

proc getIsRemote*(self: GApplication): bool =
  toBool(g_application_get_is_remote(cast[ptr GApplication00](self.impl)))

proc isRemote*(self: GApplication): bool =
  toBool(g_application_get_is_remote(cast[ptr GApplication00](self.impl)))

proc g_application_get_resource_base_path(self: ptr GApplication00): cstring {.
    importc, libprag.}

proc getResourceBasePath*(self: GApplication): string =
  let resul0 = g_application_get_resource_base_path(cast[ptr GApplication00](self.impl))
  if resul0.isNil:
    return
  result = $resul0

proc resourceBasePath*(self: GApplication): string =
  let resul0 = g_application_get_resource_base_path(cast[ptr GApplication00](self.impl))
  if resul0.isNil:
    return
  result = $resul0

proc g_application_hold(self: ptr GApplication00) {.
    importc, libprag.}

proc hold*(self: GApplication) =
  g_application_hold(cast[ptr GApplication00](self.impl))

proc g_application_mark_busy(self: ptr GApplication00) {.
    importc, libprag.}

proc markBusy*(self: GApplication) =
  g_application_mark_busy(cast[ptr GApplication00](self.impl))

proc g_application_open(self: ptr GApplication00; files: ptr ptr GFile00;
    nFiles: int32; hint: cstring) {.
    importc, libprag.}

proc open*(self: GApplication; files: ptr ptr GFile00; nFiles: int;
    hint: cstring) =
  g_application_open(cast[ptr GApplication00](self.impl), files, int32(nFiles), hint)

proc g_application_quit(self: ptr GApplication00) {.
    importc, libprag.}

proc quit*(self: GApplication) =
  g_application_quit(cast[ptr GApplication00](self.impl))

proc g_application_release(self: ptr GApplication00) {.
    importc, libprag.}

proc release*(self: GApplication) =
  g_application_release(cast[ptr GApplication00](self.impl))

proc g_application_run(self: ptr GApplication00; argc: int32; argv: ptr cstring): int32 {.
    importc, libprag.}

proc run*(self: GApplication; argc: int; argv: varargs[string, `$`]): int =
  var fs469n23x: array[256, pointer]
  var fs469n23: cstringArray = cast[cstringArray](addr fs469n23x)
  int(g_application_run(cast[ptr GApplication00](self.impl), int32(argc), seq2CstringArray(argv, fs469n23)))

proc g_application_set_application_id(self: ptr GApplication00; applicationId: cstring) {.
    importc, libprag.}

proc setApplicationId*(self: GApplication; applicationId: cstring = nil) =
  g_application_set_application_id(cast[ptr GApplication00](self.impl), applicationId)

proc `applicationId=`*(self: GApplication; applicationId: cstring = nil) =
  g_application_set_application_id(cast[ptr GApplication00](self.impl), applicationId)

proc g_application_set_default(self: ptr GApplication00) {.
    importc, libprag.}

proc setDefault*(self: GApplication) =
  g_application_set_default(cast[ptr GApplication00](self.impl))

proc g_application_set_inactivity_timeout(self: ptr GApplication00; inactivityTimeout: uint32) {.
    importc, libprag.}

proc setInactivityTimeout*(self: GApplication; inactivityTimeout: int) =
  g_application_set_inactivity_timeout(cast[ptr GApplication00](self.impl), uint32(inactivityTimeout))

proc `inactivityTimeout=`*(self: GApplication; inactivityTimeout: int) =
  g_application_set_inactivity_timeout(cast[ptr GApplication00](self.impl), uint32(inactivityTimeout))

proc g_application_set_option_context_description(self: ptr GApplication00;
    description: cstring) {.
    importc, libprag.}

proc setOptionContextDescription*(self: GApplication; description: cstring = nil) =
  g_application_set_option_context_description(cast[ptr GApplication00](self.impl), description)

proc `optionContextDescription=`*(self: GApplication; description: cstring = nil) =
  g_application_set_option_context_description(cast[ptr GApplication00](self.impl), description)

proc g_application_set_option_context_parameter_string(self: ptr GApplication00;
    parameterString: cstring) {.
    importc, libprag.}

proc setOptionContextParameterString*(self: GApplication;
    parameterString: cstring = nil) =
  g_application_set_option_context_parameter_string(cast[ptr GApplication00](self.impl), parameterString)

proc `optionContextParameterString=`*(self: GApplication;
    parameterString: cstring = nil) =
  g_application_set_option_context_parameter_string(cast[ptr GApplication00](self.impl), parameterString)

proc g_application_set_option_context_summary(self: ptr GApplication00; summary: cstring) {.
    importc, libprag.}

proc setOptionContextSummary*(self: GApplication; summary: cstring = nil) =
  g_application_set_option_context_summary(cast[ptr GApplication00](self.impl), summary)

proc `optionContextSummary=`*(self: GApplication; summary: cstring = nil) =
  g_application_set_option_context_summary(cast[ptr GApplication00](self.impl), summary)

proc g_application_set_resource_base_path(self: ptr GApplication00; resourcePath: cstring) {.
    importc, libprag.}

proc setResourceBasePath*(self: GApplication; resourcePath: cstring = nil) =
  g_application_set_resource_base_path(cast[ptr GApplication00](self.impl), resourcePath)

proc `resourceBasePath=`*(self: GApplication; resourcePath: cstring = nil) =
  g_application_set_resource_base_path(cast[ptr GApplication00](self.impl), resourcePath)

proc g_application_unbind_busy_property(self: ptr GApplication00; `object`: ptr gobject.Object00;
    property: cstring) {.
    importc, libprag.}

proc unbindBusyProperty*(self: GApplication; `object`: gobject.Object;
    property: cstring) =
  g_application_unbind_busy_property(cast[ptr GApplication00](self.impl), cast[ptr gobject.Object00](`object`.impl), property)

proc g_application_unmark_busy(self: ptr GApplication00) {.
    importc, libprag.}

proc unmarkBusy*(self: GApplication) =
  g_application_unmark_busy(cast[ptr GApplication00](self.impl))

proc g_application_withdraw_notification(self: ptr GApplication00; id: cstring) {.
    importc, libprag.}

proc withdrawNotification*(self: GApplication; id: cstring) =
  g_application_withdraw_notification(cast[ptr GApplication00](self.impl), id)

proc g_application_command_line_create_file_for_arg(self: ptr ApplicationCommandLine00;
    arg: cstring): ptr GFile00 {.
    importc, libprag.}

proc createFileForArg*(self: ApplicationCommandLine;
    arg: cstring): GFile =
  let gobj = g_application_command_line_create_file_for_arg(cast[ptr ApplicationCommandLine00](self.impl), arg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

type
  DBusActionGroup* = ref object of gobject.Object
  DBusActionGroup00* = object of gobject.Object00

proc g_dbus_action_group_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(DBusActionGroup()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

type
  SimpleActionGroup* = ref object of gobject.Object
  SimpleActionGroup00* = object of gobject.Object00

proc g_simple_action_group_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(SimpleActionGroup()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc g_simple_action_group_new(): ptr SimpleActionGroup00 {.
    importc, libprag.}

proc newSimpleActionGroup*(): SimpleActionGroup =
  let gobj = g_simple_action_group_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newSimpleActionGroup*(tdesc: typedesc): tdesc =
  assert(result is SimpleActionGroup)
  let gobj = g_simple_action_group_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initSimpleActionGroup*[T](result: var T) {.deprecated.} =
  assert(result is SimpleActionGroup)
  let gobj = g_simple_action_group_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_simple_action_group_add_entries(self: ptr SimpleActionGroup00; entries: ptr ActionEntry00;
    nEntries: int32; userData: pointer) {.
    importc, libprag.}

proc addEntries*(self: SimpleActionGroup; entries: ptr ActionEntry00;
    nEntries: int; userData: pointer) =
  g_simple_action_group_add_entries(cast[ptr SimpleActionGroup00](self.impl), entries, int32(nEntries), userData)

proc g_simple_action_group_insert(self: ptr SimpleActionGroup00; action: ptr Action00) {.
    importc, libprag.}

proc insert*(self: SimpleActionGroup; action: Action | PropertyAction | SimpleAction) =
  g_simple_action_group_insert(cast[ptr SimpleActionGroup00](self.impl), cast[ptr Action00](action.impl))

proc g_simple_action_group_lookup(self: ptr SimpleActionGroup00; actionName: cstring): ptr Action00 {.
    importc, libprag.}

proc lookup*(self: SimpleActionGroup; actionName: cstring): Action =
  let gobj = g_simple_action_group_lookup(cast[ptr SimpleActionGroup00](self.impl), actionName)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_simple_action_group_remove(self: ptr SimpleActionGroup00; actionName: cstring) {.
    importc, libprag.}

proc remove*(self: SimpleActionGroup; actionName: cstring) =
  g_simple_action_group_remove(cast[ptr SimpleActionGroup00](self.impl), actionName)

type
  ActionGroup00* = object of gobject.Object00
  ActionGroup* = ref object of gobject.Object

proc scActionAdded*(self: ActionGroup | GApplication | DBusActionGroup | SimpleActionGroup;  p: proc (self: ptr ActionGroup00; actionName: cstring; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "action-added", cast[GCallback](p), xdata, nil, cf)

proc scActionEnabledChanged*(self: ActionGroup | GApplication | DBusActionGroup | SimpleActionGroup;  p: proc (self: ptr ActionGroup00; actionName: cstring; enabled: gboolean; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "action-enabled-changed", cast[GCallback](p), xdata, nil, cf)

proc scActionRemoved*(self: ActionGroup | GApplication | DBusActionGroup | SimpleActionGroup;  p: proc (self: ptr ActionGroup00; actionName: cstring; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "action-removed", cast[GCallback](p), xdata, nil, cf)

proc scActionStateChanged*(self: ActionGroup | GApplication | DBusActionGroup | SimpleActionGroup;  p: proc (self: ptr ActionGroup00; actionName: cstring; value: ptr glib.Variant00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "action-state-changed", cast[GCallback](p), xdata, nil, cf)

proc g_action_group_action_added(self: ptr ActionGroup00; actionName: cstring) {.
    importc, libprag.}

proc actionAdded*(self: ActionGroup | GApplication | DBusActionGroup | SimpleActionGroup;
    actionName: cstring) =
  g_action_group_action_added(cast[ptr ActionGroup00](self.impl), actionName)

proc g_action_group_action_enabled_changed(self: ptr ActionGroup00; actionName: cstring;
    enabled: gboolean) {.
    importc, libprag.}

proc actionEnabledChanged*(self: ActionGroup | GApplication | DBusActionGroup | SimpleActionGroup;
    actionName: cstring; enabled: bool) =
  g_action_group_action_enabled_changed(cast[ptr ActionGroup00](self.impl), actionName, gboolean(enabled))

proc g_action_group_action_removed(self: ptr ActionGroup00; actionName: cstring) {.
    importc, libprag.}

proc actionRemoved*(self: ActionGroup | GApplication | DBusActionGroup | SimpleActionGroup;
    actionName: cstring) =
  g_action_group_action_removed(cast[ptr ActionGroup00](self.impl), actionName)

proc g_action_group_action_state_changed(self: ptr ActionGroup00; actionName: cstring;
    state: ptr glib.Variant00) {.
    importc, libprag.}

proc actionStateChanged*(self: ActionGroup | GApplication | DBusActionGroup | SimpleActionGroup;
    actionName: cstring; state: glib.Variant) =
  g_action_group_action_state_changed(cast[ptr ActionGroup00](self.impl), actionName, cast[ptr glib.Variant00](state.impl))

proc g_action_group_activate_action(self: ptr ActionGroup00; actionName: cstring;
    parameter: ptr glib.Variant00) {.
    importc, libprag.}

proc activateAction*(self: ActionGroup | GApplication | DBusActionGroup | SimpleActionGroup;
    actionName: cstring; parameter: glib.Variant = nil) =
  g_action_group_activate_action(cast[ptr ActionGroup00](self.impl), actionName, if parameter.isNil: nil else: cast[ptr glib.Variant00](parameter.impl))

proc g_action_group_change_action_state(self: ptr ActionGroup00; actionName: cstring;
    value: ptr glib.Variant00) {.
    importc, libprag.}

proc changeActionState*(self: ActionGroup | GApplication | DBusActionGroup | SimpleActionGroup;
    actionName: cstring; value: glib.Variant) =
  g_action_group_change_action_state(cast[ptr ActionGroup00](self.impl), actionName, cast[ptr glib.Variant00](value.impl))

proc g_action_group_get_action_enabled(self: ptr ActionGroup00; actionName: cstring): gboolean {.
    importc, libprag.}

proc getActionEnabled*(self: ActionGroup | GApplication | DBusActionGroup | SimpleActionGroup;
    actionName: cstring): bool =
  toBool(g_action_group_get_action_enabled(cast[ptr ActionGroup00](self.impl), actionName))

proc g_action_group_get_action_parameter_type(self: ptr ActionGroup00; actionName: cstring): ptr glib.VariantType00 {.
    importc, libprag.}

proc getActionParameterType*(self: ActionGroup | GApplication | DBusActionGroup | SimpleActionGroup;
    actionName: cstring): glib.VariantType =
  let impl0 = g_action_group_get_action_parameter_type(cast[ptr ActionGroup00](self.impl), actionName)
  if impl0.isNil:
    return nil
  fnew(result, finalizerfree)
  result.impl = cast[typeof(result.impl)](g_boxed_copy(g_variant_type_get_gtype(), impl0))

proc g_action_group_get_action_state(self: ptr ActionGroup00; actionName: cstring): ptr glib.Variant00 {.
    importc, libprag.}

proc getActionState*(self: ActionGroup | GApplication | DBusActionGroup | SimpleActionGroup;
    actionName: cstring): glib.Variant =
  let impl0 = g_action_group_get_action_state(cast[ptr ActionGroup00](self.impl), actionName)
  if impl0.isNil:
    return nil
  fnew(result, finalizerunref)
  result.impl = impl0

proc g_action_group_get_action_state_hint(self: ptr ActionGroup00; actionName: cstring): ptr glib.Variant00 {.
    importc, libprag.}

proc getActionStateHint*(self: ActionGroup | GApplication | DBusActionGroup | SimpleActionGroup;
    actionName: cstring): glib.Variant =
  let impl0 = g_action_group_get_action_state_hint(cast[ptr ActionGroup00](self.impl), actionName)
  if impl0.isNil:
    return nil
  fnew(result, finalizerunref)
  result.impl = impl0

proc g_action_group_get_action_state_type(self: ptr ActionGroup00; actionName: cstring): ptr glib.VariantType00 {.
    importc, libprag.}

proc getActionStateType*(self: ActionGroup | GApplication | DBusActionGroup | SimpleActionGroup;
    actionName: cstring): glib.VariantType =
  let impl0 = g_action_group_get_action_state_type(cast[ptr ActionGroup00](self.impl), actionName)
  if impl0.isNil:
    return nil
  fnew(result, finalizerfree)
  result.impl = cast[typeof(result.impl)](g_boxed_copy(g_variant_type_get_gtype(), impl0))

proc g_action_group_has_action(self: ptr ActionGroup00; actionName: cstring): gboolean {.
    importc, libprag.}

proc hasAction*(self: ActionGroup | GApplication | DBusActionGroup | SimpleActionGroup;
    actionName: cstring): bool =
  toBool(g_action_group_has_action(cast[ptr ActionGroup00](self.impl), actionName))

proc g_action_group_list_actions(self: ptr ActionGroup00): ptr cstring {.
    importc, libprag.}

proc listActions*(self: ActionGroup | GApplication | DBusActionGroup | SimpleActionGroup): seq[string] =
  let resul0 = g_action_group_list_actions(cast[ptr ActionGroup00](self.impl))
  if resul0.isNil:
    return
  result = cstringArrayToSeq(resul0)
  g_strfreev(resul0)

proc g_action_group_query_action(self: ptr ActionGroup00; actionName: cstring;
    enabled: var gboolean; parameterType: var ptr glib.VariantType00; stateType: var ptr glib.VariantType00;
    stateHint: var ptr glib.Variant00; state: var ptr glib.Variant00): gboolean {.
    importc, libprag.}

proc queryAction*(self: ActionGroup | GApplication | DBusActionGroup | SimpleActionGroup;
    actionName: cstring; enabled: var bool; parameterType: var glib.VariantType = cast[var glib.VariantType](nil);
    stateType: var glib.VariantType = cast[var glib.VariantType](nil); stateHint: var glib.Variant = cast[var glib.Variant](nil);
    state: var glib.Variant = cast[var glib.Variant](nil)): bool =
  if addr(parameterType) != nil:
    fnew(parameterType, finalizerfree)
  if addr(stateType) != nil:
    fnew(stateType, finalizerfree)
  if addr(stateHint) != nil:
    fnew(stateHint, finalizerunref)
  if addr(state) != nil:
    fnew(state, finalizerunref)
  var enabled_00: gboolean
  result = toBool(g_action_group_query_action(cast[ptr ActionGroup00](self.impl), actionName, enabled_00, cast[var ptr glib.VariantType00](if addr(parameterType) == nil: nil else: addr parameterType.impl), cast[var ptr glib.VariantType00](if addr(stateType) == nil: nil else: addr stateType.impl), cast[var ptr glib.Variant00](if addr(stateHint) == nil: nil else: addr stateHint.impl), cast[var ptr glib.Variant00](if addr(state) == nil: nil else: addr state.impl)))
  if enabled.addr != nil:
    enabled = toBool(enabled_00)

proc g_application_set_action_group(self: ptr GApplication00; actionGroup: ptr ActionGroup00) {.
    importc, libprag.}

proc setActionGroup*(self: GApplication; actionGroup: ActionGroup | GApplication | DBusActionGroup | SimpleActionGroup = nil) =
  g_application_set_action_group(cast[ptr GApplication00](self.impl), if actionGroup.isNil: nil else: cast[ptr ActionGroup00](actionGroup.impl))

proc `actionGroup=`*(self: GApplication; actionGroup: ActionGroup | GApplication | DBusActionGroup | SimpleActionGroup = nil) =
  g_application_set_action_group(cast[ptr GApplication00](self.impl), if actionGroup.isNil: nil else: cast[ptr ActionGroup00](actionGroup.impl))

type
  IOStream* = ref object of gobject.Object
  IOStream00* = object of gobject.Object00

proc g_io_stream_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(IOStream()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc g_io_stream_clear_pending(self: ptr IOStream00) {.
    importc, libprag.}

proc clearPending*(self: IOStream) =
  g_io_stream_clear_pending(cast[ptr IOStream00](self.impl))

proc g_io_stream_has_pending(self: ptr IOStream00): gboolean {.
    importc, libprag.}

proc hasPending*(self: IOStream): bool =
  toBool(g_io_stream_has_pending(cast[ptr IOStream00](self.impl)))

proc g_io_stream_is_closed(self: ptr IOStream00): gboolean {.
    importc, libprag.}

proc isClosed*(self: IOStream): bool =
  toBool(g_io_stream_is_closed(cast[ptr IOStream00](self.impl)))

proc g_io_stream_set_pending(self: ptr IOStream00; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc setPending*(self: IOStream): bool =
  var gerror: ptr glib.Error
  let resul0 = g_io_stream_set_pending(cast[ptr IOStream00](self.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

type
  FileIOStream* = ref object of IOStream
  FileIOStream00* = object of IOStream00

proc g_file_io_stream_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(FileIOStream()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc g_file_io_stream_get_etag(self: ptr FileIOStream00): cstring {.
    importc, libprag.}

proc getEtag*(self: FileIOStream): string =
  let resul0 = g_file_io_stream_get_etag(cast[ptr FileIOStream00](self.impl))
  result = $resul0
  cogfree(resul0)

proc etag*(self: FileIOStream): string =
  let resul0 = g_file_io_stream_get_etag(cast[ptr FileIOStream00](self.impl))
  result = $resul0
  cogfree(resul0)

proc g_file_new_tmp(tmpl: cstring; iostream: var ptr FileIOStream00; error: ptr ptr glib.Error = nil): ptr GFile00 {.
    importc, libprag.}

proc newGFileTmp*(tmpl: cstring = nil; iostream: var FileIOStream): GFile =
  var tmpoutgobjectarg: ptr FileIOStream00
  var gerror: ptr glib.Error
  let gobj = g_file_new_tmp(tmpl, tmpoutgobjectarg, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))
#  dothemagic(iostream
  let argqdata = g_object_get_qdata(tmpoutgobjectarg, Quark)
  if argqdata != nil:
    iostream = cast[type(iostream)](argqdata)
    assert(iostream.impl == tmpoutgobjectarg)
  else:
    fnew(iostream, gio.finalizeGObject)
    iostream.impl = tmpoutgobjectarg
    GC_ref(iostream)
    if g_object_is_floating(iostream.impl).int != 0:
      discard g_object_ref_sink(iostream.impl)
    g_object_add_toggle_ref(iostream.impl, toggleNotify, addr(iostream[]))
    g_object_unref(iostream.impl)
    assert(g_object_get_qdata(iostream.impl, Quark) == nil)
    g_object_set_qdata(iostream.impl, Quark, addr(iostream[]))


type
  OutputStream* = ref object of gobject.Object
  OutputStream00* = object of gobject.Object00

proc g_output_stream_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(OutputStream()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc g_output_stream_clear_pending(self: ptr OutputStream00) {.
    importc, libprag.}

proc clearPending*(self: OutputStream) =
  g_output_stream_clear_pending(cast[ptr OutputStream00](self.impl))

proc g_output_stream_has_pending(self: ptr OutputStream00): gboolean {.
    importc, libprag.}

proc hasPending*(self: OutputStream): bool =
  toBool(g_output_stream_has_pending(cast[ptr OutputStream00](self.impl)))

proc g_output_stream_is_closed(self: ptr OutputStream00): gboolean {.
    importc, libprag.}

proc isClosed*(self: OutputStream): bool =
  toBool(g_output_stream_is_closed(cast[ptr OutputStream00](self.impl)))

proc g_output_stream_is_closing(self: ptr OutputStream00): gboolean {.
    importc, libprag.}

proc isClosing*(self: OutputStream): bool =
  toBool(g_output_stream_is_closing(cast[ptr OutputStream00](self.impl)))

proc g_output_stream_set_pending(self: ptr OutputStream00; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc setPending*(self: OutputStream): bool =
  var gerror: ptr glib.Error
  let resul0 = g_output_stream_set_pending(cast[ptr OutputStream00](self.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_io_stream_get_output_stream(self: ptr IOStream00): ptr OutputStream00 {.
    importc, libprag.}

proc getOutputStream*(self: IOStream): OutputStream =
  let gobj = g_io_stream_get_output_stream(cast[ptr IOStream00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc outputStream*(self: IOStream): OutputStream =
  let gobj = g_io_stream_get_output_stream(cast[ptr IOStream00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

type
  OutputVector* {.pure, byRef.} = object
    buffer*: pointer
    size*: uint64

type
  IOStreamSpliceFlag* {.size: sizeof(cint), pure.} = enum
    closeStream1 = 0
    closeStream2 = 1
    waitForBoth = 2

  IOStreamSpliceFlags* {.size: sizeof(cint).} = set[IOStreamSpliceFlag]

const
  IOStreamSpliceFlagsNone* = IOStreamSpliceFlags({})
proc none*(t: typedesc[IOStreamSpliceFlags]): IOStreamSpliceFlags = IOStreamSpliceFlags({})

type
  FileMonitorFlag* {.size: sizeof(cint), pure.} = enum
    watchMounts = 0
    sendMoved = 1
    watchHardLinks = 2
    watchMoves = 3

  FileMonitorFlags* {.size: sizeof(cint).} = set[FileMonitorFlag]

const
  FileMonitorFlagsNone* = FileMonitorFlags({})
proc none*(t: typedesc[FileMonitorFlags]): FileMonitorFlags = FileMonitorFlags({})

type
  MountMountFlags* {.size: sizeof(cint), pure.} = enum
    none = 0

type
  AskPasswordFlag* {.size: sizeof(cint), pure.} = enum
    needPassword = 0
    needUsername = 1
    needDomain = 2
    savingSupported = 3
    anonymousSupported = 4
    tcrypt = 5

  AskPasswordFlags* {.size: sizeof(cint).} = set[AskPasswordFlag]

type
  MountOperationResult* {.size: sizeof(cint), pure.} = enum
    handled = 0
    aborted = 1
    unhandled = 2

type
  MountOperation* = ref object of gobject.Object
  MountOperation00* = object of gobject.Object00

proc g_mount_operation_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(MountOperation()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc scAborted*(self: MountOperation;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "aborted", cast[GCallback](p), xdata, nil, cf)

proc scAskPassword*(self: MountOperation;  p: proc (self: ptr MountOperation00; message: cstring; defaultUser: cstring; defaultDomain: cstring; flags: AskPasswordFlags; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "ask-password", cast[GCallback](p), xdata, nil, cf)

proc scAskQuestion*(self: MountOperation;  p: proc (self: ptr MountOperation00; message: cstring; choices: ptr cstring; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "ask-question", cast[GCallback](p), xdata, nil, cf)

proc scReply*(self: MountOperation;  p: proc (self: ptr MountOperation00; resu: MountOperationResult; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "reply", cast[GCallback](p), xdata, nil, cf)

proc scShowProcesses*(self: MountOperation;  p: proc (self: ptr MountOperation00; message: cstring; processes: ptr GArray00; choices: ptr cstring; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "show-processes", cast[GCallback](p), xdata, nil, cf)

proc scShowUnmountProgress*(self: MountOperation;  p: proc (self: ptr MountOperation00; message: cstring; timeLeft: int64; bytesLeft: int64; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "show-unmount-progress", cast[GCallback](p), xdata, nil, cf)

proc g_mount_operation_new(): ptr MountOperation00 {.
    importc, libprag.}

proc newMountOperation*(): MountOperation =
  let gobj = g_mount_operation_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newMountOperation*(tdesc: typedesc): tdesc =
  assert(result is MountOperation)
  let gobj = g_mount_operation_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initMountOperation*[T](result: var T) {.deprecated.} =
  assert(result is MountOperation)
  let gobj = g_mount_operation_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_mount_operation_get_anonymous(self: ptr MountOperation00): gboolean {.
    importc, libprag.}

proc getAnonymous*(self: MountOperation): bool =
  toBool(g_mount_operation_get_anonymous(cast[ptr MountOperation00](self.impl)))

proc anonymous*(self: MountOperation): bool =
  toBool(g_mount_operation_get_anonymous(cast[ptr MountOperation00](self.impl)))

proc g_mount_operation_get_choice(self: ptr MountOperation00): int32 {.
    importc, libprag.}

proc getChoice*(self: MountOperation): int =
  int(g_mount_operation_get_choice(cast[ptr MountOperation00](self.impl)))

proc choice*(self: MountOperation): int =
  int(g_mount_operation_get_choice(cast[ptr MountOperation00](self.impl)))

proc g_mount_operation_get_domain(self: ptr MountOperation00): cstring {.
    importc, libprag.}

proc getDomain*(self: MountOperation): string =
  result = $g_mount_operation_get_domain(cast[ptr MountOperation00](self.impl))

proc domain*(self: MountOperation): string =
  result = $g_mount_operation_get_domain(cast[ptr MountOperation00](self.impl))

proc g_mount_operation_get_is_tcrypt_hidden_volume(self: ptr MountOperation00): gboolean {.
    importc, libprag.}

proc getIsTcryptHiddenVolume*(self: MountOperation): bool =
  toBool(g_mount_operation_get_is_tcrypt_hidden_volume(cast[ptr MountOperation00](self.impl)))

proc isTcryptHiddenVolume*(self: MountOperation): bool =
  toBool(g_mount_operation_get_is_tcrypt_hidden_volume(cast[ptr MountOperation00](self.impl)))

proc g_mount_operation_get_is_tcrypt_system_volume(self: ptr MountOperation00): gboolean {.
    importc, libprag.}

proc getIsTcryptSystemVolume*(self: MountOperation): bool =
  toBool(g_mount_operation_get_is_tcrypt_system_volume(cast[ptr MountOperation00](self.impl)))

proc isTcryptSystemVolume*(self: MountOperation): bool =
  toBool(g_mount_operation_get_is_tcrypt_system_volume(cast[ptr MountOperation00](self.impl)))

proc g_mount_operation_get_password(self: ptr MountOperation00): cstring {.
    importc, libprag.}

proc getPassword*(self: MountOperation): string =
  result = $g_mount_operation_get_password(cast[ptr MountOperation00](self.impl))

proc password*(self: MountOperation): string =
  result = $g_mount_operation_get_password(cast[ptr MountOperation00](self.impl))

proc g_mount_operation_get_pim(self: ptr MountOperation00): uint32 {.
    importc, libprag.}

proc getPim*(self: MountOperation): int =
  int(g_mount_operation_get_pim(cast[ptr MountOperation00](self.impl)))

proc pim*(self: MountOperation): int =
  int(g_mount_operation_get_pim(cast[ptr MountOperation00](self.impl)))

proc g_mount_operation_get_username(self: ptr MountOperation00): cstring {.
    importc, libprag.}

proc getUsername*(self: MountOperation): string =
  result = $g_mount_operation_get_username(cast[ptr MountOperation00](self.impl))

proc username*(self: MountOperation): string =
  result = $g_mount_operation_get_username(cast[ptr MountOperation00](self.impl))

proc g_mount_operation_reply(self: ptr MountOperation00; resu: MountOperationResult) {.
    importc, libprag.}

proc reply*(self: MountOperation; resu: MountOperationResult) =
  g_mount_operation_reply(cast[ptr MountOperation00](self.impl), resu)

proc g_mount_operation_set_anonymous(self: ptr MountOperation00; anonymous: gboolean) {.
    importc, libprag.}

proc setAnonymous*(self: MountOperation; anonymous: bool = true) =
  g_mount_operation_set_anonymous(cast[ptr MountOperation00](self.impl), gboolean(anonymous))

proc `anonymous=`*(self: MountOperation; anonymous: bool) =
  g_mount_operation_set_anonymous(cast[ptr MountOperation00](self.impl), gboolean(anonymous))

proc g_mount_operation_set_choice(self: ptr MountOperation00; choice: int32) {.
    importc, libprag.}

proc setChoice*(self: MountOperation; choice: int) =
  g_mount_operation_set_choice(cast[ptr MountOperation00](self.impl), int32(choice))

proc `choice=`*(self: MountOperation; choice: int) =
  g_mount_operation_set_choice(cast[ptr MountOperation00](self.impl), int32(choice))

proc g_mount_operation_set_domain(self: ptr MountOperation00; domain: cstring) {.
    importc, libprag.}

proc setDomain*(self: MountOperation; domain: cstring) =
  g_mount_operation_set_domain(cast[ptr MountOperation00](self.impl), domain)

proc `domain=`*(self: MountOperation; domain: cstring) =
  g_mount_operation_set_domain(cast[ptr MountOperation00](self.impl), domain)

proc g_mount_operation_set_is_tcrypt_hidden_volume(self: ptr MountOperation00;
    hiddenVolume: gboolean) {.
    importc, libprag.}

proc setIsTcryptHiddenVolume*(self: MountOperation;
    hiddenVolume: bool = true) =
  g_mount_operation_set_is_tcrypt_hidden_volume(cast[ptr MountOperation00](self.impl), gboolean(hiddenVolume))

proc `isTcryptHiddenVolume=`*(self: MountOperation;
    hiddenVolume: bool) =
  g_mount_operation_set_is_tcrypt_hidden_volume(cast[ptr MountOperation00](self.impl), gboolean(hiddenVolume))

proc g_mount_operation_set_is_tcrypt_system_volume(self: ptr MountOperation00;
    systemVolume: gboolean) {.
    importc, libprag.}

proc setIsTcryptSystemVolume*(self: MountOperation;
    systemVolume: bool = true) =
  g_mount_operation_set_is_tcrypt_system_volume(cast[ptr MountOperation00](self.impl), gboolean(systemVolume))

proc `isTcryptSystemVolume=`*(self: MountOperation;
    systemVolume: bool) =
  g_mount_operation_set_is_tcrypt_system_volume(cast[ptr MountOperation00](self.impl), gboolean(systemVolume))

proc g_mount_operation_set_password(self: ptr MountOperation00; password: cstring) {.
    importc, libprag.}

proc setPassword*(self: MountOperation; password: cstring) =
  g_mount_operation_set_password(cast[ptr MountOperation00](self.impl), password)

proc `password=`*(self: MountOperation; password: cstring) =
  g_mount_operation_set_password(cast[ptr MountOperation00](self.impl), password)

proc g_mount_operation_set_pim(self: ptr MountOperation00; pim: uint32) {.
    importc, libprag.}

proc setPim*(self: MountOperation; pim: int) =
  g_mount_operation_set_pim(cast[ptr MountOperation00](self.impl), uint32(pim))

proc `pim=`*(self: MountOperation; pim: int) =
  g_mount_operation_set_pim(cast[ptr MountOperation00](self.impl), uint32(pim))

proc g_mount_operation_set_username(self: ptr MountOperation00; username: cstring) {.
    importc, libprag.}

proc setUsername*(self: MountOperation; username: cstring) =
  g_mount_operation_set_username(cast[ptr MountOperation00](self.impl), username)

proc `username=`*(self: MountOperation; username: cstring) =
  g_mount_operation_set_username(cast[ptr MountOperation00](self.impl), username)

type
  PasswordSave* {.size: sizeof(cint), pure.} = enum
    never = 0
    forSession = 1
    permanently = 2

proc g_mount_operation_get_password_save(self: ptr MountOperation00): PasswordSave {.
    importc, libprag.}

proc getPasswordSave*(self: MountOperation): PasswordSave =
  g_mount_operation_get_password_save(cast[ptr MountOperation00](self.impl))

proc passwordSave*(self: MountOperation): PasswordSave =
  g_mount_operation_get_password_save(cast[ptr MountOperation00](self.impl))

proc g_mount_operation_set_password_save(self: ptr MountOperation00; save: PasswordSave) {.
    importc, libprag.}

proc setPasswordSave*(self: MountOperation; save: PasswordSave) =
  g_mount_operation_set_password_save(cast[ptr MountOperation00](self.impl), save)

proc `passwordSave=`*(self: MountOperation; save: PasswordSave) =
  g_mount_operation_set_password_save(cast[ptr MountOperation00](self.impl), save)

type
  FileCopyFlag* {.size: sizeof(cint), pure.} = enum
    overwrite = 0
    backup = 1
    nofollowSymlinks = 2
    allMetadata = 3
    noFallbackForMove = 4
    targetDefaultPerms = 5

  FileCopyFlags* {.size: sizeof(cint).} = set[FileCopyFlag]

const
  FileCopyFlagsNone* = FileCopyFlags({})
proc none*(t: typedesc[FileCopyFlags]): FileCopyFlags = FileCopyFlags({})

type
  FileCreateFlag* {.size: sizeof(cint), pure.} = enum
    private = 0
    replaceDestination = 1

  FileCreateFlags* {.size: sizeof(cint).} = set[FileCreateFlag]

const
  FileCreateFlagsNone* = FileCreateFlags({})
proc none*(t: typedesc[FileCreateFlags]): FileCreateFlags = FileCreateFlags({})

type
  FileAttributeType* {.size: sizeof(cint), pure.} = enum
    invalid = 0
    string = 1
    byteString = 2
    boolean = 3
    uint32 = 4
    int32 = 5
    uint64 = 6
    int64 = 7
    `object` = 8
    stringv = 9

type
  FileQueryInfoFlag* {.size: sizeof(cint), pure.} = enum
    nofollowSymlinks = 0

  FileQueryInfoFlags* {.size: sizeof(cint).} = set[FileQueryInfoFlag]

const
  FileQueryInfoFlagsNone* = FileQueryInfoFlags({})
proc none*(t: typedesc[FileQueryInfoFlags]): FileQueryInfoFlags = FileQueryInfoFlags({})

type
  FileInfo* = ref object of gobject.Object
  FileInfo00* = object of gobject.Object00

proc g_file_info_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(FileInfo()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc g_file_info_new(): ptr FileInfo00 {.
    importc, libprag.}

proc newFileInfo*(): FileInfo =
  let gobj = g_file_info_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newFileInfo*(tdesc: typedesc): tdesc =
  assert(result is FileInfo)
  let gobj = g_file_info_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initFileInfo*[T](result: var T) {.deprecated.} =
  assert(result is FileInfo)
  let gobj = g_file_info_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_file_info_clear_status(self: ptr FileInfo00) {.
    importc, libprag.}

proc clearStatus*(self: FileInfo) =
  g_file_info_clear_status(cast[ptr FileInfo00](self.impl))

proc g_file_info_copy_into(self: ptr FileInfo00; destInfo: ptr FileInfo00) {.
    importc, libprag.}

proc copyInto*(self: FileInfo; destInfo: FileInfo) =
  g_file_info_copy_into(cast[ptr FileInfo00](self.impl), cast[ptr FileInfo00](destInfo.impl))

proc g_file_info_dup(self: ptr FileInfo00): ptr FileInfo00 {.
    importc, libprag.}

proc dup*(self: FileInfo): FileInfo =
  let gobj = g_file_info_dup(cast[ptr FileInfo00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_file_info_get_attribute_as_string(self: ptr FileInfo00; attribute: cstring): cstring {.
    importc, libprag.}

proc getAttributeAsString*(self: FileInfo; attribute: cstring): string =
  let resul0 = g_file_info_get_attribute_as_string(cast[ptr FileInfo00](self.impl), attribute)
  if resul0.isNil:
    return
  result = $resul0
  cogfree(resul0)

proc g_file_info_get_attribute_boolean(self: ptr FileInfo00; attribute: cstring): gboolean {.
    importc, libprag.}

proc getAttributeBoolean*(self: FileInfo; attribute: cstring): bool =
  toBool(g_file_info_get_attribute_boolean(cast[ptr FileInfo00](self.impl), attribute))

proc g_file_info_get_attribute_byte_string(self: ptr FileInfo00; attribute: cstring): cstring {.
    importc, libprag.}

proc getAttributeByteString*(self: FileInfo; attribute: cstring): string =
  let resul0 = g_file_info_get_attribute_byte_string(cast[ptr FileInfo00](self.impl), attribute)
  if resul0.isNil:
    return
  result = $resul0

proc g_file_info_get_attribute_int32(self: ptr FileInfo00; attribute: cstring): int32 {.
    importc, libprag.}

proc getAttributeInt32*(self: FileInfo; attribute: cstring): int =
  int(g_file_info_get_attribute_int32(cast[ptr FileInfo00](self.impl), attribute))

proc g_file_info_get_attribute_int64(self: ptr FileInfo00; attribute: cstring): int64 {.
    importc, libprag.}

proc getAttributeInt64*(self: FileInfo; attribute: cstring): int64 =
  g_file_info_get_attribute_int64(cast[ptr FileInfo00](self.impl), attribute)

proc g_file_info_get_attribute_object(self: ptr FileInfo00; attribute: cstring): ptr gobject.Object00 {.
    importc, libprag.}

proc getAttributeObject*(self: FileInfo; attribute: cstring): gobject.Object =
  let gobj = g_file_info_get_attribute_object(cast[ptr FileInfo00](self.impl), attribute)
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gobject.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_file_info_get_attribute_string(self: ptr FileInfo00; attribute: cstring): cstring {.
    importc, libprag.}

proc getAttributeString*(self: FileInfo; attribute: cstring): string =
  let resul0 = g_file_info_get_attribute_string(cast[ptr FileInfo00](self.impl), attribute)
  if resul0.isNil:
    return
  result = $resul0

proc g_file_info_get_attribute_stringv(self: ptr FileInfo00; attribute: cstring): ptr cstring {.
    importc, libprag.}

proc getAttributeStringv*(self: FileInfo; attribute: cstring): seq[string] =
  let resul0 = g_file_info_get_attribute_stringv(cast[ptr FileInfo00](self.impl), attribute)
  if resul0.isNil:
    return
  cstringArrayToSeq(resul0)

proc g_file_info_get_attribute_type(self: ptr FileInfo00; attribute: cstring): FileAttributeType {.
    importc, libprag.}

proc getAttributeType*(self: FileInfo; attribute: cstring): FileAttributeType =
  g_file_info_get_attribute_type(cast[ptr FileInfo00](self.impl), attribute)

proc g_file_info_get_attribute_uint32(self: ptr FileInfo00; attribute: cstring): uint32 {.
    importc, libprag.}

proc getAttributeUint32*(self: FileInfo; attribute: cstring): int =
  int(g_file_info_get_attribute_uint32(cast[ptr FileInfo00](self.impl), attribute))

proc g_file_info_get_attribute_uint64(self: ptr FileInfo00; attribute: cstring): uint64 {.
    importc, libprag.}

proc getAttributeUint64*(self: FileInfo; attribute: cstring): uint64 =
  g_file_info_get_attribute_uint64(cast[ptr FileInfo00](self.impl), attribute)

proc g_file_info_get_content_type(self: ptr FileInfo00): cstring {.
    importc, libprag.}

proc getContentType*(self: FileInfo): string =
  let resul0 = g_file_info_get_content_type(cast[ptr FileInfo00](self.impl))
  if resul0.isNil:
    return
  result = $resul0

proc contentType*(self: FileInfo): string =
  let resul0 = g_file_info_get_content_type(cast[ptr FileInfo00](self.impl))
  if resul0.isNil:
    return
  result = $resul0

proc g_file_info_get_deletion_date(self: ptr FileInfo00): ptr glib.DateTime00 {.
    importc, libprag.}

proc getDeletionDate*(self: FileInfo): glib.DateTime =
  let impl0 = g_file_info_get_deletion_date(cast[ptr FileInfo00](self.impl))
  if impl0.isNil:
    return nil
  fnew(result, gBoxedFreeGDateTime)
  result.impl = impl0

proc deletionDate*(self: FileInfo): glib.DateTime =
  let impl0 = g_file_info_get_deletion_date(cast[ptr FileInfo00](self.impl))
  if impl0.isNil:
    return nil
  fnew(result, gBoxedFreeGDateTime)
  result.impl = impl0

proc g_file_info_get_display_name(self: ptr FileInfo00): cstring {.
    importc, libprag.}

proc getDisplayName*(self: FileInfo): string =
  result = $g_file_info_get_display_name(cast[ptr FileInfo00](self.impl))

proc displayName*(self: FileInfo): string =
  result = $g_file_info_get_display_name(cast[ptr FileInfo00](self.impl))

proc g_file_info_get_edit_name(self: ptr FileInfo00): cstring {.
    importc, libprag.}

proc getEditName*(self: FileInfo): string =
  result = $g_file_info_get_edit_name(cast[ptr FileInfo00](self.impl))

proc editName*(self: FileInfo): string =
  result = $g_file_info_get_edit_name(cast[ptr FileInfo00](self.impl))

proc g_file_info_get_etag(self: ptr FileInfo00): cstring {.
    importc, libprag.}

proc getEtag*(self: FileInfo): string =
  result = $g_file_info_get_etag(cast[ptr FileInfo00](self.impl))

proc etag*(self: FileInfo): string =
  result = $g_file_info_get_etag(cast[ptr FileInfo00](self.impl))

proc g_file_info_get_is_backup(self: ptr FileInfo00): gboolean {.
    importc, libprag.}

proc getIsBackup*(self: FileInfo): bool =
  toBool(g_file_info_get_is_backup(cast[ptr FileInfo00](self.impl)))

proc isBackup*(self: FileInfo): bool =
  toBool(g_file_info_get_is_backup(cast[ptr FileInfo00](self.impl)))

proc g_file_info_get_is_hidden(self: ptr FileInfo00): gboolean {.
    importc, libprag.}

proc getIsHidden*(self: FileInfo): bool =
  toBool(g_file_info_get_is_hidden(cast[ptr FileInfo00](self.impl)))

proc isHidden*(self: FileInfo): bool =
  toBool(g_file_info_get_is_hidden(cast[ptr FileInfo00](self.impl)))

proc g_file_info_get_is_symlink(self: ptr FileInfo00): gboolean {.
    importc, libprag.}

proc getIsSymlink*(self: FileInfo): bool =
  toBool(g_file_info_get_is_symlink(cast[ptr FileInfo00](self.impl)))

proc isSymlink*(self: FileInfo): bool =
  toBool(g_file_info_get_is_symlink(cast[ptr FileInfo00](self.impl)))

proc g_file_info_get_modification_date_time(self: ptr FileInfo00): ptr glib.DateTime00 {.
    importc, libprag.}

proc getModificationDateTime*(self: FileInfo): glib.DateTime =
  let impl0 = g_file_info_get_modification_date_time(cast[ptr FileInfo00](self.impl))
  if impl0.isNil:
    return nil
  fnew(result, gBoxedFreeGDateTime)
  result.impl = impl0

proc modificationDateTime*(self: FileInfo): glib.DateTime =
  let impl0 = g_file_info_get_modification_date_time(cast[ptr FileInfo00](self.impl))
  if impl0.isNil:
    return nil
  fnew(result, gBoxedFreeGDateTime)
  result.impl = impl0

proc g_file_info_get_modification_time(self: ptr FileInfo00; resu: var glib.TimeVal) {.
    importc, libprag.}

proc getModificationTime*(self: FileInfo; resu: var glib.TimeVal) =
  g_file_info_get_modification_time(cast[ptr FileInfo00](self.impl), resu)

proc getModificationTime*(self: FileInfo): glib.TimeVal =
  g_file_info_get_modification_time(cast[ptr FileInfo00](self.impl), result)

proc g_file_info_get_name(self: ptr FileInfo00): cstring {.
    importc, libprag.}

proc getName*(self: FileInfo): string =
  result = $g_file_info_get_name(cast[ptr FileInfo00](self.impl))

proc name*(self: FileInfo): string =
  result = $g_file_info_get_name(cast[ptr FileInfo00](self.impl))

proc g_file_info_get_size(self: ptr FileInfo00): int64 {.
    importc, libprag.}

proc getSize*(self: FileInfo): int64 =
  g_file_info_get_size(cast[ptr FileInfo00](self.impl))

proc size*(self: FileInfo): int64 =
  g_file_info_get_size(cast[ptr FileInfo00](self.impl))

proc g_file_info_get_sort_order(self: ptr FileInfo00): int32 {.
    importc, libprag.}

proc getSortOrder*(self: FileInfo): int =
  int(g_file_info_get_sort_order(cast[ptr FileInfo00](self.impl)))

proc sortOrder*(self: FileInfo): int =
  int(g_file_info_get_sort_order(cast[ptr FileInfo00](self.impl)))

proc g_file_info_get_symlink_target(self: ptr FileInfo00): cstring {.
    importc, libprag.}

proc getSymlinkTarget*(self: FileInfo): string =
  result = $g_file_info_get_symlink_target(cast[ptr FileInfo00](self.impl))

proc symlinkTarget*(self: FileInfo): string =
  result = $g_file_info_get_symlink_target(cast[ptr FileInfo00](self.impl))

proc g_file_info_has_attribute(self: ptr FileInfo00; attribute: cstring): gboolean {.
    importc, libprag.}

proc hasAttribute*(self: FileInfo; attribute: cstring): bool =
  toBool(g_file_info_has_attribute(cast[ptr FileInfo00](self.impl), attribute))

proc g_file_info_has_namespace(self: ptr FileInfo00; nameSpace: cstring): gboolean {.
    importc, libprag.}

proc hasNamespace*(self: FileInfo; nameSpace: cstring): bool =
  toBool(g_file_info_has_namespace(cast[ptr FileInfo00](self.impl), nameSpace))

proc g_file_info_list_attributes(self: ptr FileInfo00; nameSpace: cstring): ptr cstring {.
    importc, libprag.}

proc listAttributes*(self: FileInfo; nameSpace: cstring = nil): seq[string] =
  let resul0 = g_file_info_list_attributes(cast[ptr FileInfo00](self.impl), nameSpace)
  if resul0.isNil:
    return
  result = cstringArrayToSeq(resul0)
  g_strfreev(resul0)

proc g_file_info_remove_attribute(self: ptr FileInfo00; attribute: cstring) {.
    importc, libprag.}

proc removeAttribute*(self: FileInfo; attribute: cstring) =
  g_file_info_remove_attribute(cast[ptr FileInfo00](self.impl), attribute)

proc g_file_info_set_attribute(self: ptr FileInfo00; attribute: cstring;
    `type`: FileAttributeType; valueP: pointer) {.
    importc, libprag.}

proc setAttribute*(self: FileInfo; attribute: cstring; `type`: FileAttributeType;
    valueP: pointer) =
  g_file_info_set_attribute(cast[ptr FileInfo00](self.impl), attribute, `type`, valueP)

proc g_file_info_set_attribute_boolean(self: ptr FileInfo00; attribute: cstring;
    attrValue: gboolean) {.
    importc, libprag.}

proc setAttributeBoolean*(self: FileInfo; attribute: cstring;
    attrValue: bool) =
  g_file_info_set_attribute_boolean(cast[ptr FileInfo00](self.impl), attribute, gboolean(attrValue))

proc g_file_info_set_attribute_byte_string(self: ptr FileInfo00; attribute: cstring;
    attrValue: cstring) {.
    importc, libprag.}

proc setAttributeByteString*(self: FileInfo; attribute: cstring;
    attrValue: cstring) =
  g_file_info_set_attribute_byte_string(cast[ptr FileInfo00](self.impl), attribute, attrValue)

proc g_file_info_set_attribute_int32(self: ptr FileInfo00; attribute: cstring;
    attrValue: int32) {.
    importc, libprag.}

proc setAttributeInt32*(self: FileInfo; attribute: cstring;
    attrValue: int) =
  g_file_info_set_attribute_int32(cast[ptr FileInfo00](self.impl), attribute, int32(attrValue))

proc g_file_info_set_attribute_int64(self: ptr FileInfo00; attribute: cstring;
    attrValue: int64) {.
    importc, libprag.}

proc setAttributeInt64*(self: FileInfo; attribute: cstring;
    attrValue: int64) =
  g_file_info_set_attribute_int64(cast[ptr FileInfo00](self.impl), attribute, attrValue)

proc g_file_info_set_attribute_object(self: ptr FileInfo00; attribute: cstring;
    attrValue: ptr gobject.Object00) {.
    importc, libprag.}

proc setAttributeObject*(self: FileInfo; attribute: cstring;
    attrValue: gobject.Object) =
  g_file_info_set_attribute_object(cast[ptr FileInfo00](self.impl), attribute, cast[ptr gobject.Object00](attrValue.impl))

proc g_file_info_set_attribute_string(self: ptr FileInfo00; attribute: cstring;
    attrValue: cstring) {.
    importc, libprag.}

proc setAttributeString*(self: FileInfo; attribute: cstring;
    attrValue: cstring) =
  g_file_info_set_attribute_string(cast[ptr FileInfo00](self.impl), attribute, attrValue)

proc g_file_info_set_attribute_stringv(self: ptr FileInfo00; attribute: cstring;
    attrValue: ptr cstring) {.
    importc, libprag.}

proc setAttributeStringv*(self: FileInfo; attribute: cstring;
    attrValue: varargs[string, `$`]) =
  var fs469n23x: array[256, pointer]
  var fs469n23: cstringArray = cast[cstringArray](addr fs469n23x)
  g_file_info_set_attribute_stringv(cast[ptr FileInfo00](self.impl), attribute, seq2CstringArray(attrValue, fs469n23))

proc g_file_info_set_attribute_uint32(self: ptr FileInfo00; attribute: cstring;
    attrValue: uint32) {.
    importc, libprag.}

proc setAttributeUint32*(self: FileInfo; attribute: cstring;
    attrValue: int) =
  g_file_info_set_attribute_uint32(cast[ptr FileInfo00](self.impl), attribute, uint32(attrValue))

proc g_file_info_set_attribute_uint64(self: ptr FileInfo00; attribute: cstring;
    attrValue: uint64) {.
    importc, libprag.}

proc setAttributeUint64*(self: FileInfo; attribute: cstring;
    attrValue: uint64) =
  g_file_info_set_attribute_uint64(cast[ptr FileInfo00](self.impl), attribute, attrValue)

proc g_file_info_set_content_type(self: ptr FileInfo00; contentType: cstring) {.
    importc, libprag.}

proc setContentType*(self: FileInfo; contentType: cstring) =
  g_file_info_set_content_type(cast[ptr FileInfo00](self.impl), contentType)

proc `contentType=`*(self: FileInfo; contentType: cstring) =
  g_file_info_set_content_type(cast[ptr FileInfo00](self.impl), contentType)

proc g_file_info_set_display_name(self: ptr FileInfo00; displayName: cstring) {.
    importc, libprag.}

proc setDisplayName*(self: FileInfo; displayName: cstring) =
  g_file_info_set_display_name(cast[ptr FileInfo00](self.impl), displayName)

proc `displayName=`*(self: FileInfo; displayName: cstring) =
  g_file_info_set_display_name(cast[ptr FileInfo00](self.impl), displayName)

proc g_file_info_set_edit_name(self: ptr FileInfo00; editName: cstring) {.
    importc, libprag.}

proc setEditName*(self: FileInfo; editName: cstring) =
  g_file_info_set_edit_name(cast[ptr FileInfo00](self.impl), editName)

proc `editName=`*(self: FileInfo; editName: cstring) =
  g_file_info_set_edit_name(cast[ptr FileInfo00](self.impl), editName)

proc g_file_info_set_is_hidden(self: ptr FileInfo00; isHidden: gboolean) {.
    importc, libprag.}

proc setIsHidden*(self: FileInfo; isHidden: bool = true) =
  g_file_info_set_is_hidden(cast[ptr FileInfo00](self.impl), gboolean(isHidden))

proc `isHidden=`*(self: FileInfo; isHidden: bool) =
  g_file_info_set_is_hidden(cast[ptr FileInfo00](self.impl), gboolean(isHidden))

proc g_file_info_set_is_symlink(self: ptr FileInfo00; isSymlink: gboolean) {.
    importc, libprag.}

proc setIsSymlink*(self: FileInfo; isSymlink: bool = true) =
  g_file_info_set_is_symlink(cast[ptr FileInfo00](self.impl), gboolean(isSymlink))

proc `isSymlink=`*(self: FileInfo; isSymlink: bool) =
  g_file_info_set_is_symlink(cast[ptr FileInfo00](self.impl), gboolean(isSymlink))

proc g_file_info_set_modification_date_time(self: ptr FileInfo00; mtime: ptr glib.DateTime00) {.
    importc, libprag.}

proc setModificationDateTime*(self: FileInfo; mtime: glib.DateTime) =
  g_file_info_set_modification_date_time(cast[ptr FileInfo00](self.impl), cast[ptr glib.DateTime00](mtime.impl))

proc `modificationDateTime=`*(self: FileInfo; mtime: glib.DateTime) =
  g_file_info_set_modification_date_time(cast[ptr FileInfo00](self.impl), cast[ptr glib.DateTime00](mtime.impl))

proc g_file_info_set_modification_time(self: ptr FileInfo00; mtime: glib.TimeVal) {.
    importc, libprag.}

proc setModificationTime*(self: FileInfo; mtime: glib.TimeVal) =
  g_file_info_set_modification_time(cast[ptr FileInfo00](self.impl), mtime)

proc `modificationTime=`*(self: FileInfo; mtime: glib.TimeVal) =
  g_file_info_set_modification_time(cast[ptr FileInfo00](self.impl), mtime)

proc g_file_info_set_name(self: ptr FileInfo00; name: cstring) {.
    importc, libprag.}

proc setName*(self: FileInfo; name: cstring) =
  g_file_info_set_name(cast[ptr FileInfo00](self.impl), name)

proc `name=`*(self: FileInfo; name: cstring) =
  g_file_info_set_name(cast[ptr FileInfo00](self.impl), name)

proc g_file_info_set_size(self: ptr FileInfo00; size: int64) {.
    importc, libprag.}

proc setSize*(self: FileInfo; size: int64) =
  g_file_info_set_size(cast[ptr FileInfo00](self.impl), size)

proc `size=`*(self: FileInfo; size: int64) =
  g_file_info_set_size(cast[ptr FileInfo00](self.impl), size)

proc g_file_info_set_sort_order(self: ptr FileInfo00; sortOrder: int32) {.
    importc, libprag.}

proc setSortOrder*(self: FileInfo; sortOrder: int) =
  g_file_info_set_sort_order(cast[ptr FileInfo00](self.impl), int32(sortOrder))

proc `sortOrder=`*(self: FileInfo; sortOrder: int) =
  g_file_info_set_sort_order(cast[ptr FileInfo00](self.impl), int32(sortOrder))

proc g_file_info_set_symlink_target(self: ptr FileInfo00; symlinkTarget: cstring) {.
    importc, libprag.}

proc setSymlinkTarget*(self: FileInfo; symlinkTarget: cstring) =
  g_file_info_set_symlink_target(cast[ptr FileInfo00](self.impl), symlinkTarget)

proc `symlinkTarget=`*(self: FileInfo; symlinkTarget: cstring) =
  g_file_info_set_symlink_target(cast[ptr FileInfo00](self.impl), symlinkTarget)

proc g_file_info_unset_attribute_mask(self: ptr FileInfo00) {.
    importc, libprag.}

proc unsetAttributeMask*(self: FileInfo) =
  g_file_info_unset_attribute_mask(cast[ptr FileInfo00](self.impl))

type
  FileAttributeMatcher00* {.pure.} = object
  FileAttributeMatcher* = ref object
    impl*: ptr FileAttributeMatcher00
    ignoreFinalizer*: bool

proc g_file_attribute_matcher_get_type*(): GType {.importc, libprag.}

proc gBoxedFreeGFileAttributeMatcher*(self: FileAttributeMatcher) =
  if not self.ignoreFinalizer:
    boxedFree(g_file_attribute_matcher_get_type(), cast[ptr FileAttributeMatcher00](self.impl))

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(FileAttributeMatcher()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    if not self.ignoreFinalizer and self.impl != nil:
      boxedFree(g_file_attribute_matcher_get_type(), cast[ptr FileAttributeMatcher00](self.impl))
      self.impl = nil

proc newWithFinalizer*(x: var FileAttributeMatcher) =
  when defined(gcDestructors):
    new(x)
  else:
    new(x, gBoxedFreeGFileAttributeMatcher)

proc g_file_attribute_matcher_unref(self: ptr FileAttributeMatcher00) {.
    importc, libprag.}

proc unref*(self: FileAttributeMatcher) =
  g_file_attribute_matcher_unref(cast[ptr FileAttributeMatcher00](self.impl))

proc finalizerunref*(self: FileAttributeMatcher) =
  if not self.ignoreFinalizer:
    g_file_attribute_matcher_unref(cast[ptr FileAttributeMatcher00](self.impl))

proc g_file_attribute_matcher_enumerate_namespace(self: ptr FileAttributeMatcher00;
    ns: cstring): gboolean {.
    importc, libprag.}

proc enumerateNamespace*(self: FileAttributeMatcher;
    ns: cstring): bool =
  toBool(g_file_attribute_matcher_enumerate_namespace(cast[ptr FileAttributeMatcher00](self.impl), ns))

proc g_file_attribute_matcher_enumerate_next(self: ptr FileAttributeMatcher00): cstring {.
    importc, libprag.}

proc enumerateNext*(self: FileAttributeMatcher): string =
  let resul0 = g_file_attribute_matcher_enumerate_next(cast[ptr FileAttributeMatcher00](self.impl))
  if resul0.isNil:
    return
  result = $resul0

proc g_file_attribute_matcher_matches(self: ptr FileAttributeMatcher00; attribute: cstring): gboolean {.
    importc, libprag.}

proc matches*(self: FileAttributeMatcher; attribute: cstring): bool =
  toBool(g_file_attribute_matcher_matches(cast[ptr FileAttributeMatcher00](self.impl), attribute))

proc g_file_attribute_matcher_matches_only(self: ptr FileAttributeMatcher00;
    attribute: cstring): gboolean {.
    importc, libprag.}

proc matchesOnly*(self: FileAttributeMatcher; attribute: cstring): bool =
  toBool(g_file_attribute_matcher_matches_only(cast[ptr FileAttributeMatcher00](self.impl), attribute))

proc g_file_attribute_matcher_ref(self: ptr FileAttributeMatcher00): ptr FileAttributeMatcher00 {.
    importc, libprag.}

proc `ref`*(self: FileAttributeMatcher): FileAttributeMatcher =
  fnew(result, gBoxedFreeGFileAttributeMatcher)
  result.impl = g_file_attribute_matcher_ref(cast[ptr FileAttributeMatcher00](self.impl))

proc g_file_attribute_matcher_subtract(self: ptr FileAttributeMatcher00;
    subtract: ptr FileAttributeMatcher00): ptr FileAttributeMatcher00 {.
    importc, libprag.}

proc subtract*(self: FileAttributeMatcher; subtract: FileAttributeMatcher): FileAttributeMatcher =
  fnew(result, gBoxedFreeGFileAttributeMatcher)
  result.impl = g_file_attribute_matcher_subtract(cast[ptr FileAttributeMatcher00](self.impl), cast[ptr FileAttributeMatcher00](subtract.impl))

proc g_file_attribute_matcher_to_string(self: ptr FileAttributeMatcher00): cstring {.
    importc, libprag.}

proc toString*(self: FileAttributeMatcher): string =
  let resul0 = g_file_attribute_matcher_to_string(cast[ptr FileAttributeMatcher00](self.impl))
  result = $resul0
  cogfree(resul0)

proc g_file_attribute_matcher_new(attributes: cstring): ptr FileAttributeMatcher00 {.
    importc, libprag.}

proc newFileAttributeMatcher*(attributes: cstring): FileAttributeMatcher =
  fnew(result, gBoxedFreeGFileAttributeMatcher)
  result.impl = g_file_attribute_matcher_new(attributes)

proc newFileAttributeMatcher*(tdesc: typedesc; attributes: cstring): tdesc =
  assert(result is FileAttributeMatcher)
  fnew(result, gBoxedFreeGFileAttributeMatcher)
  result.impl = g_file_attribute_matcher_new(attributes)

proc initFileAttributeMatcher*[T](result: var T; attributes: cstring) {.deprecated.} =
  assert(result is FileAttributeMatcher)
  fnew(result, gBoxedFreeGFileAttributeMatcher)
  result.impl = g_file_attribute_matcher_new(attributes)

proc g_file_info_set_attribute_mask(self: ptr FileInfo00; mask: ptr FileAttributeMatcher00) {.
    importc, libprag.}

proc setAttributeMask*(self: FileInfo; mask: FileAttributeMatcher) =
  g_file_info_set_attribute_mask(cast[ptr FileInfo00](self.impl), cast[ptr FileAttributeMatcher00](mask.impl))

proc `attributeMask=`*(self: FileInfo; mask: FileAttributeMatcher) =
  g_file_info_set_attribute_mask(cast[ptr FileInfo00](self.impl), cast[ptr FileAttributeMatcher00](mask.impl))

type
  FileAttributeStatus* {.size: sizeof(cint), pure.} = enum
    unset = 0
    set = 1
    errorSetting = 2

proc g_file_info_get_attribute_data(self: ptr FileInfo00; attribute: cstring;
    `type`: var FileAttributeType; valuePp: var pointer; status: var FileAttributeStatus): gboolean {.
    importc, libprag.}

proc getAttributeData*(self: FileInfo; attribute: cstring; `type`: var FileAttributeType = cast[var FileAttributeType](nil);
    valuePp: var pointer = cast[var pointer](nil); status: var FileAttributeStatus = cast[var FileAttributeStatus](nil)): bool =
  toBool(g_file_info_get_attribute_data(cast[ptr FileInfo00](self.impl), attribute, `type`, valuePp, status))

proc g_file_info_get_attribute_status(self: ptr FileInfo00; attribute: cstring): FileAttributeStatus {.
    importc, libprag.}

proc getAttributeStatus*(self: FileInfo; attribute: cstring): FileAttributeStatus =
  g_file_info_get_attribute_status(cast[ptr FileInfo00](self.impl), attribute)

proc g_file_info_set_attribute_status(self: ptr FileInfo00; attribute: cstring;
    status: FileAttributeStatus): gboolean {.
    importc, libprag.}

proc setAttributeStatus*(self: FileInfo; attribute: cstring;
    status: FileAttributeStatus): bool =
  toBool(g_file_info_set_attribute_status(cast[ptr FileInfo00](self.impl), attribute, status))

type
  FileType* {.size: sizeof(cint), pure.} = enum
    unknown = 0
    regular = 1
    directory = 2
    symbolicLink = 3
    special = 4
    shortcut = 5
    mountable = 6

proc g_file_info_get_file_type(self: ptr FileInfo00): FileType {.
    importc, libprag.}

proc getFileType*(self: FileInfo): FileType =
  g_file_info_get_file_type(cast[ptr FileInfo00](self.impl))

proc fileType*(self: FileInfo): FileType =
  g_file_info_get_file_type(cast[ptr FileInfo00](self.impl))

proc g_file_info_set_file_type(self: ptr FileInfo00; `type`: FileType) {.
    importc, libprag.}

proc setFileType*(self: FileInfo; `type`: FileType) =
  g_file_info_set_file_type(cast[ptr FileInfo00](self.impl), `type`)

proc `fileType=`*(self: FileInfo; `type`: FileType) =
  g_file_info_set_file_type(cast[ptr FileInfo00](self.impl), `type`)

type
  Icon00* = object of gobject.Object00
  Icon* = ref object of gobject.Object

proc g_icon_deserialize(value: ptr glib.Variant00): ptr Icon00 {.
    importc, libprag.}

proc deserialize*(value: glib.Variant): Icon =
  let gobj = g_icon_deserialize(cast[ptr glib.Variant00](value.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_icon_hash(icon: pointer): uint32 {.
    importc, libprag.}

proc hash*(icon: pointer): int =
  int(g_icon_hash(icon))

proc g_icon_new_for_string(str: cstring; error: ptr ptr glib.Error = nil): ptr Icon00 {.
    importc, libprag.}

proc newIconForString*(str: cstring): Icon =
  var gerror: ptr glib.Error
  let gobj = g_icon_new_for_string(str, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_file_info_get_icon(self: ptr FileInfo00): ptr Icon00 {.
    importc, libprag.}

proc getIcon*(self: FileInfo): Icon =
  let gobj = g_file_info_get_icon(cast[ptr FileInfo00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc icon*(self: FileInfo): Icon =
  let gobj = g_file_info_get_icon(cast[ptr FileInfo00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_file_info_get_symbolic_icon(self: ptr FileInfo00): ptr Icon00 {.
    importc, libprag.}

proc getSymbolicIcon*(self: FileInfo): Icon =
  let gobj = g_file_info_get_symbolic_icon(cast[ptr FileInfo00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc symbolicIcon*(self: FileInfo): Icon =
  let gobj = g_file_info_get_symbolic_icon(cast[ptr FileInfo00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

type
  Emblem* = ref object of gobject.Object
  Emblem00* = object of gobject.Object00

proc g_emblem_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(Emblem()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc g_emblem_get_icon(self: ptr Emblem00): ptr Icon00 {.
    importc, libprag.}

proc getIcon*(self: Emblem): Icon =
  let gobj = g_emblem_get_icon(cast[ptr Emblem00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc icon*(self: Emblem): Icon =
  let gobj = g_emblem_get_icon(cast[ptr Emblem00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

type
  BytesIcon* = ref object of gobject.Object
  BytesIcon00* = object of gobject.Object00

proc g_bytes_icon_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(BytesIcon()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc g_bytes_icon_new(bytes: ptr glib.Bytes00): ptr BytesIcon00 {.
    importc, libprag.}

proc newBytesIcon*(bytes: glib.Bytes): BytesIcon =
  let gobj = g_bytes_icon_new(cast[ptr glib.Bytes00](bytes.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newBytesIcon*(tdesc: typedesc; bytes: glib.Bytes): tdesc =
  assert(result is BytesIcon)
  let gobj = g_bytes_icon_new(cast[ptr glib.Bytes00](bytes.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initBytesIcon*[T](result: var T; bytes: glib.Bytes) {.deprecated.} =
  assert(result is BytesIcon)
  let gobj = g_bytes_icon_new(cast[ptr glib.Bytes00](bytes.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_bytes_icon_get_bytes(self: ptr BytesIcon00): ptr glib.Bytes00 {.
    importc, libprag.}

proc getBytes*(self: BytesIcon): glib.Bytes =
  fnew(result, gBoxedFreeGBytes)
  result.impl = g_bytes_icon_get_bytes(cast[ptr BytesIcon00](self.impl))
  result.impl = cast[typeof(result.impl)](g_boxed_copy(g_bytes_get_type(), result.impl))

proc bytes*(self: BytesIcon): glib.Bytes =
  fnew(result, gBoxedFreeGBytes)
  result.impl = g_bytes_icon_get_bytes(cast[ptr BytesIcon00](self.impl))
  result.impl = cast[typeof(result.impl)](g_boxed_copy(g_bytes_get_type(), result.impl))

type
  FileIcon* = ref object of gobject.Object
  FileIcon00* = object of gobject.Object00

proc g_file_icon_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(FileIcon()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc g_file_icon_new(file: ptr GFile00): ptr FileIcon00 {.
    importc, libprag.}

proc newFileIcon*(file: GFile): FileIcon =
  let gobj = g_file_icon_new(cast[ptr GFile00](file.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newFileIcon*(tdesc: typedesc; file: GFile): tdesc =
  assert(result is FileIcon)
  let gobj = g_file_icon_new(cast[ptr GFile00](file.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initFileIcon*[T](result: var T; file: GFile) {.deprecated.} =
  assert(result is FileIcon)
  let gobj = g_file_icon_new(cast[ptr GFile00](file.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_file_icon_get_file(self: ptr FileIcon00): ptr GFile00 {.
    importc, libprag.}

proc getFile*(self: FileIcon): GFile =
  let gobj = g_file_icon_get_file(cast[ptr FileIcon00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc file*(self: FileIcon): GFile =
  let gobj = g_file_icon_get_file(cast[ptr FileIcon00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

type
  EmblemedIcon* = ref object of gobject.Object
  EmblemedIcon00* = object of gobject.Object00

proc g_emblemed_icon_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(EmblemedIcon()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc g_emblemed_icon_add_emblem(self: ptr EmblemedIcon00; emblem: ptr Emblem00) {.
    importc, libprag.}

proc addEmblem*(self: EmblemedIcon; emblem: Emblem) =
  g_emblemed_icon_add_emblem(cast[ptr EmblemedIcon00](self.impl), cast[ptr Emblem00](emblem.impl))

proc g_emblemed_icon_clear_emblems(self: ptr EmblemedIcon00) {.
    importc, libprag.}

proc clearEmblems*(self: EmblemedIcon) =
  g_emblemed_icon_clear_emblems(cast[ptr EmblemedIcon00](self.impl))

proc g_emblemed_icon_get_emblems(self: ptr EmblemedIcon00): ptr glib.List {.
    importc, libprag.}

proc getEmblems*(self: EmblemedIcon): seq[Emblem] =
  result = glistObjects2seq(Emblem, g_emblemed_icon_get_emblems(cast[ptr EmblemedIcon00](self.impl)), false)

proc emblems*(self: EmblemedIcon): seq[Emblem] =
  result = glistObjects2seq(Emblem, g_emblemed_icon_get_emblems(cast[ptr EmblemedIcon00](self.impl)), false)

proc g_emblemed_icon_get_icon(self: ptr EmblemedIcon00): ptr Icon00 {.
    importc, libprag.}

proc getIcon*(self: EmblemedIcon): Icon =
  let gobj = g_emblemed_icon_get_icon(cast[ptr EmblemedIcon00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc icon*(self: EmblemedIcon): Icon =
  let gobj = g_emblemed_icon_get_icon(cast[ptr EmblemedIcon00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

type
  ThemedIcon* = ref object of gobject.Object
  ThemedIcon00* = object of gobject.Object00

proc g_themed_icon_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(ThemedIcon()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc g_themed_icon_new(iconname: cstring): ptr ThemedIcon00 {.
    importc, libprag.}

proc newThemedIcon*(iconname: cstring): ThemedIcon =
  let gobj = g_themed_icon_new(iconname)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newThemedIcon*(tdesc: typedesc; iconname: cstring): tdesc =
  assert(result is ThemedIcon)
  let gobj = g_themed_icon_new(iconname)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initThemedIcon*[T](result: var T; iconname: cstring) {.deprecated.} =
  assert(result is ThemedIcon)
  let gobj = g_themed_icon_new(iconname)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_themed_icon_new_from_names(iconnames: ptr cstring; len: int32): ptr ThemedIcon00 {.
    importc, libprag.}

proc newThemedIconFromNames*(iconnames: openArray[string]; len: int): ThemedIcon =
  var fs469n23x: array[256, pointer]
  var fs469n23: cstringArray = cast[cstringArray](addr fs469n23x)
  let gobj = g_themed_icon_new_from_names(seq2CstringArray(iconnames, fs469n23), int32(len))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newThemedIconFromNames*(tdesc: typedesc; iconnames: openArray[string]; len: int): tdesc =
  var fs469n23x: array[256, pointer]
  var fs469n23: cstringArray = cast[cstringArray](addr fs469n23x)
  assert(result is ThemedIcon)
  let gobj = g_themed_icon_new_from_names(seq2CstringArray(iconnames, fs469n23), int32(len))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initThemedIconFromNames*[T](result: var T; iconnames: openArray[string]; len: int) {.deprecated.} =
  var fs469n23x: array[256, pointer]
  var fs469n23: cstringArray = cast[cstringArray](addr fs469n23x)
  assert(result is ThemedIcon)
  let gobj = g_themed_icon_new_from_names(seq2CstringArray(iconnames, fs469n23), int32(len))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_themed_icon_new_with_default_fallbacks(iconname: cstring): ptr ThemedIcon00 {.
    importc, libprag.}

proc newThemedIconWithDefaultFallbacks*(iconname: cstring): ThemedIcon =
  let gobj = g_themed_icon_new_with_default_fallbacks(iconname)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newThemedIconWithDefaultFallbacks*(tdesc: typedesc; iconname: cstring): tdesc =
  assert(result is ThemedIcon)
  let gobj = g_themed_icon_new_with_default_fallbacks(iconname)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initThemedIconWithDefaultFallbacks*[T](result: var T; iconname: cstring) {.deprecated.} =
  assert(result is ThemedIcon)
  let gobj = g_themed_icon_new_with_default_fallbacks(iconname)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_themed_icon_append_name(self: ptr ThemedIcon00; iconname: cstring) {.
    importc, libprag.}

proc appendName*(self: ThemedIcon; iconname: cstring) =
  g_themed_icon_append_name(cast[ptr ThemedIcon00](self.impl), iconname)

proc g_themed_icon_get_names(self: ptr ThemedIcon00): ptr cstring {.
    importc, libprag.}

proc getNames*(self: ThemedIcon): seq[string] =
  cstringArrayToSeq(g_themed_icon_get_names(cast[ptr ThemedIcon00](self.impl)))

proc names*(self: ThemedIcon): seq[string] =
  cstringArrayToSeq(g_themed_icon_get_names(cast[ptr ThemedIcon00](self.impl)))

proc g_themed_icon_prepend_name(self: ptr ThemedIcon00; iconname: cstring) {.
    importc, libprag.}

proc prependName*(self: ThemedIcon; iconname: cstring) =
  g_themed_icon_prepend_name(cast[ptr ThemedIcon00](self.impl), iconname)

proc g_file_info_set_icon(self: ptr FileInfo00; icon: ptr Icon00) {.
    importc, libprag.}

proc setIcon*(self: FileInfo; icon: Icon | Emblem | BytesIcon | FileIcon | EmblemedIcon | ThemedIcon) =
  g_file_info_set_icon(cast[ptr FileInfo00](self.impl), cast[ptr Icon00](icon.impl))

proc `icon=`*(self: FileInfo; icon: Icon | Emblem | BytesIcon | FileIcon | EmblemedIcon | ThemedIcon) =
  g_file_info_set_icon(cast[ptr FileInfo00](self.impl), cast[ptr Icon00](icon.impl))

proc g_file_info_set_symbolic_icon(self: ptr FileInfo00; icon: ptr Icon00) {.
    importc, libprag.}

proc setSymbolicIcon*(self: FileInfo; icon: Icon | Emblem | BytesIcon | FileIcon | EmblemedIcon | ThemedIcon) =
  g_file_info_set_symbolic_icon(cast[ptr FileInfo00](self.impl), cast[ptr Icon00](icon.impl))

proc `symbolicIcon=`*(self: FileInfo; icon: Icon | Emblem | BytesIcon | FileIcon | EmblemedIcon | ThemedIcon) =
  g_file_info_set_symbolic_icon(cast[ptr FileInfo00](self.impl), cast[ptr Icon00](icon.impl))

proc g_icon_equal(self: ptr Icon00; icon2: ptr Icon00): gboolean {.
    importc, libprag.}

proc equal*(self: Icon | Emblem | BytesIcon | FileIcon | EmblemedIcon | ThemedIcon;
    icon2: Icon | Emblem | BytesIcon | FileIcon | EmblemedIcon | ThemedIcon = nil): bool =
  toBool(g_icon_equal(cast[ptr Icon00](self.impl), if icon2.isNil: nil else: cast[ptr Icon00](icon2.impl)))

proc g_icon_serialize(self: ptr Icon00): ptr glib.Variant00 {.
    importc, libprag.}

proc serialize*(self: Icon | Emblem | BytesIcon | FileIcon | EmblemedIcon | ThemedIcon): glib.Variant =
  fnew(result, finalizerunref)
  result.impl = g_icon_serialize(cast[ptr Icon00](self.impl))

proc g_icon_to_string(self: ptr Icon00): cstring {.
    importc, libprag.}

proc toString*(self: Icon | Emblem | BytesIcon | FileIcon | EmblemedIcon | ThemedIcon): string =
  let resul0 = g_icon_to_string(cast[ptr Icon00](self.impl))
  if resul0.isNil:
    return
  result = $resul0
  cogfree(resul0)

proc g_emblem_new(icon: ptr Icon00): ptr Emblem00 {.
    importc, libprag.}

proc newEmblem*(icon: Icon | Emblem | BytesIcon | FileIcon | EmblemedIcon | ThemedIcon): Emblem =
  let gobj = g_emblem_new(cast[ptr Icon00](icon.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newEmblem*(tdesc: typedesc; icon: Icon | Emblem | BytesIcon | FileIcon | EmblemedIcon | ThemedIcon): tdesc =
  assert(result is Emblem)
  let gobj = g_emblem_new(cast[ptr Icon00](icon.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initEmblem*[T](result: var T; icon: Icon | Emblem | BytesIcon | FileIcon | EmblemedIcon | ThemedIcon) {.deprecated.} =
  assert(result is Emblem)
  let gobj = g_emblem_new(cast[ptr Icon00](icon.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_emblemed_icon_new(icon: ptr Icon00; emblem: ptr Emblem00): ptr EmblemedIcon00 {.
    importc, libprag.}

proc newEmblemedIcon*(icon: Icon | Emblem | BytesIcon | FileIcon | EmblemedIcon | ThemedIcon;
    emblem: Emblem = nil): EmblemedIcon =
  let gobj = g_emblemed_icon_new(cast[ptr Icon00](icon.impl), if emblem.isNil: nil else: cast[ptr Emblem00](emblem.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newEmblemedIcon*(tdesc: typedesc; icon: Icon | Emblem | BytesIcon | FileIcon | EmblemedIcon | ThemedIcon;
    emblem: Emblem = nil): tdesc =
  assert(result is EmblemedIcon)
  let gobj = g_emblemed_icon_new(cast[ptr Icon00](icon.impl), if emblem.isNil: nil else: cast[ptr Emblem00](emblem.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initEmblemedIcon*[T](result: var T; icon: Icon | Emblem | BytesIcon | FileIcon | EmblemedIcon | ThemedIcon;
    emblem: Emblem = nil) {.deprecated.} =
  assert(result is EmblemedIcon)
  let gobj = g_emblemed_icon_new(cast[ptr Icon00](icon.impl), if emblem.isNil: nil else: cast[ptr Emblem00](emblem.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

type
  EmblemOrigin* {.size: sizeof(cint), pure.} = enum
    unknown = 0
    device = 1
    livemetadata = 2
    tag = 3

proc g_emblem_new_with_origin(icon: ptr Icon00; origin: EmblemOrigin): ptr Emblem00 {.
    importc, libprag.}

proc newEmblemWithOrigin*(icon: Icon | Emblem | BytesIcon | FileIcon | EmblemedIcon | ThemedIcon;
    origin: EmblemOrigin): Emblem =
  let gobj = g_emblem_new_with_origin(cast[ptr Icon00](icon.impl), origin)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newEmblemWithOrigin*(tdesc: typedesc; icon: Icon | Emblem | BytesIcon | FileIcon | EmblemedIcon | ThemedIcon;
    origin: EmblemOrigin): tdesc =
  assert(result is Emblem)
  let gobj = g_emblem_new_with_origin(cast[ptr Icon00](icon.impl), origin)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initEmblemWithOrigin*[T](result: var T; icon: Icon | Emblem | BytesIcon | FileIcon | EmblemedIcon | ThemedIcon;
    origin: EmblemOrigin) {.deprecated.} =
  assert(result is Emblem)
  let gobj = g_emblem_new_with_origin(cast[ptr Icon00](icon.impl), origin)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_emblem_get_origin(self: ptr Emblem00): EmblemOrigin {.
    importc, libprag.}

proc getOrigin*(self: Emblem): EmblemOrigin =
  g_emblem_get_origin(cast[ptr Emblem00](self.impl))

proc origin*(self: Emblem): EmblemOrigin =
  g_emblem_get_origin(cast[ptr Emblem00](self.impl))

type
  DriveStartFlags* {.size: sizeof(cint), pure.} = enum
    none = 0

type
  MountUnmountFlag* {.size: sizeof(cint), pure.} = enum
    force = 0

  MountUnmountFlags* {.size: sizeof(cint).} = set[MountUnmountFlag]

const
  MountUnmountFlagsNone* = MountUnmountFlags({})
proc none*(t: typedesc[MountUnmountFlags]): MountUnmountFlags = MountUnmountFlags({})

type
  AsyncResult00* = object of gobject.Object00
  AsyncResult* = ref object of gobject.Object

type
  FileEnumerator* = ref object of gobject.Object
  FileEnumerator00* = object of gobject.Object00

proc g_file_enumerator_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(FileEnumerator()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc g_file_enumerator_get_child(self: ptr FileEnumerator00; info: ptr FileInfo00): ptr GFile00 {.
    importc, libprag.}

proc getChild*(self: FileEnumerator; info: FileInfo): GFile =
  let gobj = g_file_enumerator_get_child(cast[ptr FileEnumerator00](self.impl), cast[ptr FileInfo00](info.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_file_enumerator_get_container(self: ptr FileEnumerator00): ptr GFile00 {.
    importc, libprag.}

proc getContainer*(self: FileEnumerator): GFile =
  let gobj = g_file_enumerator_get_container(cast[ptr FileEnumerator00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc container*(self: FileEnumerator): GFile =
  let gobj = g_file_enumerator_get_container(cast[ptr FileEnumerator00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_file_enumerator_has_pending(self: ptr FileEnumerator00): gboolean {.
    importc, libprag.}

proc hasPending*(self: FileEnumerator): bool =
  toBool(g_file_enumerator_has_pending(cast[ptr FileEnumerator00](self.impl)))

proc g_file_enumerator_is_closed(self: ptr FileEnumerator00): gboolean {.
    importc, libprag.}

proc isClosed*(self: FileEnumerator): bool =
  toBool(g_file_enumerator_is_closed(cast[ptr FileEnumerator00](self.impl)))

proc g_file_enumerator_set_pending(self: ptr FileEnumerator00; pending: gboolean) {.
    importc, libprag.}

proc setPending*(self: FileEnumerator; pending: bool = true) =
  g_file_enumerator_set_pending(cast[ptr FileEnumerator00](self.impl), gboolean(pending))

proc `pending=`*(self: FileEnumerator; pending: bool) =
  g_file_enumerator_set_pending(cast[ptr FileEnumerator00](self.impl), gboolean(pending))

type
  Mount00* = object of gobject.Object00
  Mount* = ref object of gobject.Object

proc scChanged*(self: Mount;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "changed", cast[GCallback](p), xdata, nil, cf)

proc scPreUnmount*(self: Mount;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "pre-unmount", cast[GCallback](p), xdata, nil, cf)

proc scUnmounted*(self: Mount;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "unmounted", cast[GCallback](p), xdata, nil, cf)

proc g_mount_can_eject(self: ptr Mount00): gboolean {.
    importc, libprag.}

proc canEject*(self: Mount): bool =
  toBool(g_mount_can_eject(cast[ptr Mount00](self.impl)))

proc g_mount_can_unmount(self: ptr Mount00): gboolean {.
    importc, libprag.}

proc canUnmount*(self: Mount): bool =
  toBool(g_mount_can_unmount(cast[ptr Mount00](self.impl)))

proc g_mount_get_default_location(self: ptr Mount00): ptr GFile00 {.
    importc, libprag.}

proc getDefaultLocation*(self: Mount): GFile =
  let gobj = g_mount_get_default_location(cast[ptr Mount00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc defaultLocation*(self: Mount): GFile =
  let gobj = g_mount_get_default_location(cast[ptr Mount00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_mount_get_icon(self: ptr Mount00): ptr Icon00 {.
    importc, libprag.}

proc getIcon*(self: Mount): Icon =
  let gobj = g_mount_get_icon(cast[ptr Mount00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc icon*(self: Mount): Icon =
  let gobj = g_mount_get_icon(cast[ptr Mount00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_mount_get_name(self: ptr Mount00): cstring {.
    importc, libprag.}

proc getName*(self: Mount): string =
  let resul0 = g_mount_get_name(cast[ptr Mount00](self.impl))
  result = $resul0
  cogfree(resul0)

proc name*(self: Mount): string =
  let resul0 = g_mount_get_name(cast[ptr Mount00](self.impl))
  result = $resul0
  cogfree(resul0)

proc g_mount_get_root(self: ptr Mount00): ptr GFile00 {.
    importc, libprag.}

proc getRoot*(self: Mount): GFile =
  let gobj = g_mount_get_root(cast[ptr Mount00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc root*(self: Mount): GFile =
  let gobj = g_mount_get_root(cast[ptr Mount00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_mount_get_sort_key(self: ptr Mount00): cstring {.
    importc, libprag.}

proc getSortKey*(self: Mount): string =
  let resul0 = g_mount_get_sort_key(cast[ptr Mount00](self.impl))
  if resul0.isNil:
    return
  result = $resul0

proc sortKey*(self: Mount): string =
  let resul0 = g_mount_get_sort_key(cast[ptr Mount00](self.impl))
  if resul0.isNil:
    return
  result = $resul0

proc g_mount_get_symbolic_icon(self: ptr Mount00): ptr Icon00 {.
    importc, libprag.}

proc getSymbolicIcon*(self: Mount): Icon =
  let gobj = g_mount_get_symbolic_icon(cast[ptr Mount00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc symbolicIcon*(self: Mount): Icon =
  let gobj = g_mount_get_symbolic_icon(cast[ptr Mount00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_mount_get_uuid(self: ptr Mount00): cstring {.
    importc, libprag.}

proc getUuid*(self: Mount): string =
  let resul0 = g_mount_get_uuid(cast[ptr Mount00](self.impl))
  if resul0.isNil:
    return
  result = $resul0
  cogfree(resul0)

proc uuid*(self: Mount): string =
  let resul0 = g_mount_get_uuid(cast[ptr Mount00](self.impl))
  if resul0.isNil:
    return
  result = $resul0
  cogfree(resul0)

proc g_mount_is_shadowed(self: ptr Mount00): gboolean {.
    importc, libprag.}

proc isShadowed*(self: Mount): bool =
  toBool(g_mount_is_shadowed(cast[ptr Mount00](self.impl)))

proc g_mount_shadow(self: ptr Mount00) {.
    importc, libprag.}

proc shadow*(self: Mount) =
  g_mount_shadow(cast[ptr Mount00](self.impl))

proc g_mount_unshadow(self: ptr Mount00) {.
    importc, libprag.}

proc unshadow*(self: Mount) =
  g_mount_unshadow(cast[ptr Mount00](self.impl))

type
  Drive00* = object of gobject.Object00
  Drive* = ref object of gobject.Object

proc scChanged*(self: Drive;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "changed", cast[GCallback](p), xdata, nil, cf)

proc scDisconnected*(self: Drive;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "disconnected", cast[GCallback](p), xdata, nil, cf)

proc scEjectButton*(self: Drive;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "eject-button", cast[GCallback](p), xdata, nil, cf)

proc scStopButton*(self: Drive;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "stop-button", cast[GCallback](p), xdata, nil, cf)

proc g_drive_can_eject(self: ptr Drive00): gboolean {.
    importc, libprag.}

proc canEject*(self: Drive): bool =
  toBool(g_drive_can_eject(cast[ptr Drive00](self.impl)))

proc g_drive_can_poll_for_media(self: ptr Drive00): gboolean {.
    importc, libprag.}

proc canPollForMedia*(self: Drive): bool =
  toBool(g_drive_can_poll_for_media(cast[ptr Drive00](self.impl)))

proc g_drive_can_start(self: ptr Drive00): gboolean {.
    importc, libprag.}

proc canStart*(self: Drive): bool =
  toBool(g_drive_can_start(cast[ptr Drive00](self.impl)))

proc g_drive_can_start_degraded(self: ptr Drive00): gboolean {.
    importc, libprag.}

proc canStartDegraded*(self: Drive): bool =
  toBool(g_drive_can_start_degraded(cast[ptr Drive00](self.impl)))

proc g_drive_can_stop(self: ptr Drive00): gboolean {.
    importc, libprag.}

proc canStop*(self: Drive): bool =
  toBool(g_drive_can_stop(cast[ptr Drive00](self.impl)))

proc g_drive_enumerate_identifiers(self: ptr Drive00): ptr cstring {.
    importc, libprag.}

proc enumerateIdentifiers*(self: Drive): seq[string] =
  let resul0 = g_drive_enumerate_identifiers(cast[ptr Drive00](self.impl))
  if resul0.isNil:
    return
  result = cstringArrayToSeq(resul0)
  g_strfreev(resul0)

proc g_drive_get_icon(self: ptr Drive00): ptr Icon00 {.
    importc, libprag.}

proc getIcon*(self: Drive): Icon =
  let gobj = g_drive_get_icon(cast[ptr Drive00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc icon*(self: Drive): Icon =
  let gobj = g_drive_get_icon(cast[ptr Drive00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_drive_get_identifier(self: ptr Drive00; kind: cstring): cstring {.
    importc, libprag.}

proc getIdentifier*(self: Drive; kind: cstring): string =
  let resul0 = g_drive_get_identifier(cast[ptr Drive00](self.impl), kind)
  if resul0.isNil:
    return
  result = $resul0
  cogfree(resul0)

proc g_drive_get_name(self: ptr Drive00): cstring {.
    importc, libprag.}

proc getName*(self: Drive): string =
  let resul0 = g_drive_get_name(cast[ptr Drive00](self.impl))
  result = $resul0
  cogfree(resul0)

proc name*(self: Drive): string =
  let resul0 = g_drive_get_name(cast[ptr Drive00](self.impl))
  result = $resul0
  cogfree(resul0)

proc g_drive_get_sort_key(self: ptr Drive00): cstring {.
    importc, libprag.}

proc getSortKey*(self: Drive): string =
  let resul0 = g_drive_get_sort_key(cast[ptr Drive00](self.impl))
  if resul0.isNil:
    return
  result = $resul0

proc sortKey*(self: Drive): string =
  let resul0 = g_drive_get_sort_key(cast[ptr Drive00](self.impl))
  if resul0.isNil:
    return
  result = $resul0

proc g_drive_get_symbolic_icon(self: ptr Drive00): ptr Icon00 {.
    importc, libprag.}

proc getSymbolicIcon*(self: Drive): Icon =
  let gobj = g_drive_get_symbolic_icon(cast[ptr Drive00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc symbolicIcon*(self: Drive): Icon =
  let gobj = g_drive_get_symbolic_icon(cast[ptr Drive00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_drive_has_media(self: ptr Drive00): gboolean {.
    importc, libprag.}

proc hasMedia*(self: Drive): bool =
  toBool(g_drive_has_media(cast[ptr Drive00](self.impl)))

proc g_drive_has_volumes(self: ptr Drive00): gboolean {.
    importc, libprag.}

proc hasVolumes*(self: Drive): bool =
  toBool(g_drive_has_volumes(cast[ptr Drive00](self.impl)))

proc g_drive_is_media_check_automatic(self: ptr Drive00): gboolean {.
    importc, libprag.}

proc isMediaCheckAutomatic*(self: Drive): bool =
  toBool(g_drive_is_media_check_automatic(cast[ptr Drive00](self.impl)))

proc g_drive_is_media_removable(self: ptr Drive00): gboolean {.
    importc, libprag.}

proc isMediaRemovable*(self: Drive): bool =
  toBool(g_drive_is_media_removable(cast[ptr Drive00](self.impl)))

proc g_drive_is_removable(self: ptr Drive00): gboolean {.
    importc, libprag.}

proc isRemovable*(self: Drive): bool =
  toBool(g_drive_is_removable(cast[ptr Drive00](self.impl)))

proc g_mount_get_drive(self: ptr Mount00): ptr Drive00 {.
    importc, libprag.}

proc getDrive*(self: Mount): Drive =
  let gobj = g_mount_get_drive(cast[ptr Mount00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc drive*(self: Mount): Drive =
  let gobj = g_mount_get_drive(cast[ptr Mount00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

type
  DriveStartStopType* {.size: sizeof(cint), pure.} = enum
    unknown = 0
    shutdown = 1
    network = 2
    multidisk = 3
    password = 4

proc g_drive_get_start_stop_type(self: ptr Drive00): DriveStartStopType {.
    importc, libprag.}

proc getStartStopType*(self: Drive): DriveStartStopType =
  g_drive_get_start_stop_type(cast[ptr Drive00](self.impl))

proc startStopType*(self: Drive): DriveStartStopType =
  g_drive_get_start_stop_type(cast[ptr Drive00](self.impl))

type
  Volume00* = object of gobject.Object00
  Volume* = ref object of gobject.Object

proc scChanged*(self: Volume;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "changed", cast[GCallback](p), xdata, nil, cf)

proc scRemoved*(self: Volume;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "removed", cast[GCallback](p), xdata, nil, cf)

proc g_volume_can_eject(self: ptr Volume00): gboolean {.
    importc, libprag.}

proc canEject*(self: Volume): bool =
  toBool(g_volume_can_eject(cast[ptr Volume00](self.impl)))

proc g_volume_can_mount(self: ptr Volume00): gboolean {.
    importc, libprag.}

proc canMount*(self: Volume): bool =
  toBool(g_volume_can_mount(cast[ptr Volume00](self.impl)))

proc g_volume_enumerate_identifiers(self: ptr Volume00): ptr cstring {.
    importc, libprag.}

proc enumerateIdentifiers*(self: Volume): seq[string] =
  let resul0 = g_volume_enumerate_identifiers(cast[ptr Volume00](self.impl))
  if resul0.isNil:
    return
  result = cstringArrayToSeq(resul0)
  g_strfreev(resul0)

proc g_volume_get_activation_root(self: ptr Volume00): ptr GFile00 {.
    importc, libprag.}

proc getActivationRoot*(self: Volume): GFile =
  let gobj = g_volume_get_activation_root(cast[ptr Volume00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc activationRoot*(self: Volume): GFile =
  let gobj = g_volume_get_activation_root(cast[ptr Volume00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_volume_get_drive(self: ptr Volume00): ptr Drive00 {.
    importc, libprag.}

proc getDrive*(self: Volume): Drive =
  let gobj = g_volume_get_drive(cast[ptr Volume00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc drive*(self: Volume): Drive =
  let gobj = g_volume_get_drive(cast[ptr Volume00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_volume_get_icon(self: ptr Volume00): ptr Icon00 {.
    importc, libprag.}

proc getIcon*(self: Volume): Icon =
  let gobj = g_volume_get_icon(cast[ptr Volume00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc icon*(self: Volume): Icon =
  let gobj = g_volume_get_icon(cast[ptr Volume00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_volume_get_identifier(self: ptr Volume00; kind: cstring): cstring {.
    importc, libprag.}

proc getIdentifier*(self: Volume; kind: cstring): string =
  let resul0 = g_volume_get_identifier(cast[ptr Volume00](self.impl), kind)
  if resul0.isNil:
    return
  result = $resul0
  cogfree(resul0)

proc g_volume_get_mount(self: ptr Volume00): ptr Mount00 {.
    importc, libprag.}

proc getMount*(self: Volume): Mount =
  let gobj = g_volume_get_mount(cast[ptr Volume00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc mount*(self: Volume): Mount =
  let gobj = g_volume_get_mount(cast[ptr Volume00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_volume_get_name(self: ptr Volume00): cstring {.
    importc, libprag.}

proc getName*(self: Volume): string =
  let resul0 = g_volume_get_name(cast[ptr Volume00](self.impl))
  result = $resul0
  cogfree(resul0)

proc name*(self: Volume): string =
  let resul0 = g_volume_get_name(cast[ptr Volume00](self.impl))
  result = $resul0
  cogfree(resul0)

proc g_volume_get_sort_key(self: ptr Volume00): cstring {.
    importc, libprag.}

proc getSortKey*(self: Volume): string =
  let resul0 = g_volume_get_sort_key(cast[ptr Volume00](self.impl))
  if resul0.isNil:
    return
  result = $resul0

proc sortKey*(self: Volume): string =
  let resul0 = g_volume_get_sort_key(cast[ptr Volume00](self.impl))
  if resul0.isNil:
    return
  result = $resul0

proc g_volume_get_symbolic_icon(self: ptr Volume00): ptr Icon00 {.
    importc, libprag.}

proc getSymbolicIcon*(self: Volume): Icon =
  let gobj = g_volume_get_symbolic_icon(cast[ptr Volume00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc symbolicIcon*(self: Volume): Icon =
  let gobj = g_volume_get_symbolic_icon(cast[ptr Volume00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_volume_get_uuid(self: ptr Volume00): cstring {.
    importc, libprag.}

proc getUuid*(self: Volume): string =
  let resul0 = g_volume_get_uuid(cast[ptr Volume00](self.impl))
  if resul0.isNil:
    return
  result = $resul0
  cogfree(resul0)

proc uuid*(self: Volume): string =
  let resul0 = g_volume_get_uuid(cast[ptr Volume00](self.impl))
  if resul0.isNil:
    return
  result = $resul0
  cogfree(resul0)

proc g_volume_should_automount(self: ptr Volume00): gboolean {.
    importc, libprag.}

proc shouldAutomount*(self: Volume): bool =
  toBool(g_volume_should_automount(cast[ptr Volume00](self.impl)))

proc g_mount_get_volume(self: ptr Mount00): ptr Volume00 {.
    importc, libprag.}

proc getVolume*(self: Mount): Volume =
  let gobj = g_mount_get_volume(cast[ptr Mount00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc volume*(self: Mount): Volume =
  let gobj = g_mount_get_volume(cast[ptr Mount00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_drive_get_volumes(self: ptr Drive00): ptr glib.List {.
    importc, libprag.}

proc getVolumes*(self: Drive): seq[Volume] =
  let resul0 = g_drive_get_volumes(cast[ptr Drive00](self.impl))
  result = glistObjects2seq(Volume, resul0, true)
  g_list_free(resul0)

proc volumes*(self: Drive): seq[Volume] =
  let resul0 = g_drive_get_volumes(cast[ptr Drive00](self.impl))
  result = glistObjects2seq(Volume, resul0, true)
  g_list_free(resul0)

type
  AppInfo00* = object of gobject.Object00
  AppInfo* = ref object of gobject.Object

proc g_app_info_get_all(): ptr glib.List {.
    importc, libprag.}

proc getAll*(): seq[AppInfo] =
  let resul0 = g_app_info_get_all()
  result = glistObjects2seq(AppInfo, resul0, true)
  g_list_free(resul0)

proc g_app_info_get_all_for_type(contentType: cstring): ptr glib.List {.
    importc, libprag.}

proc getAllForType*(contentType: cstring): seq[AppInfo] =
  let resul0 = g_app_info_get_all_for_type(contentType)
  result = glistObjects2seq(AppInfo, resul0, true)
  g_list_free(resul0)

proc allForType*(contentType: cstring): seq[AppInfo] =
  let resul0 = g_app_info_get_all_for_type(contentType)
  result = glistObjects2seq(AppInfo, resul0, true)
  g_list_free(resul0)

proc g_app_info_get_default_for_type(contentType: cstring; mustSupportUris: gboolean): ptr AppInfo00 {.
    importc, libprag.}

proc getDefaultForType*(contentType: cstring; mustSupportUris: bool): AppInfo =
  let gobj = g_app_info_get_default_for_type(contentType, gboolean(mustSupportUris))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_app_info_get_default_for_uri_scheme(uriScheme: cstring): ptr AppInfo00 {.
    importc, libprag.}

proc getDefaultForUriScheme*(uriScheme: cstring): AppInfo =
  let gobj = g_app_info_get_default_for_uri_scheme(uriScheme)
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc defaultForUriScheme*(uriScheme: cstring): AppInfo =
  let gobj = g_app_info_get_default_for_uri_scheme(uriScheme)
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_app_info_get_fallback_for_type(contentType: cstring): ptr glib.List {.
    importc, libprag.}

proc getFallbackForType*(contentType: cstring): seq[AppInfo] =
  let resul0 = g_app_info_get_fallback_for_type(contentType)
  result = glistObjects2seq(AppInfo, resul0, true)
  g_list_free(resul0)

proc fallbackForType*(contentType: cstring): seq[AppInfo] =
  let resul0 = g_app_info_get_fallback_for_type(contentType)
  result = glistObjects2seq(AppInfo, resul0, true)
  g_list_free(resul0)

proc g_app_info_get_recommended_for_type(contentType: cstring): ptr glib.List {.
    importc, libprag.}

proc getRecommendedForType*(contentType: cstring): seq[AppInfo] =
  let resul0 = g_app_info_get_recommended_for_type(contentType)
  result = glistObjects2seq(AppInfo, resul0, true)
  g_list_free(resul0)

proc recommendedForType*(contentType: cstring): seq[AppInfo] =
  let resul0 = g_app_info_get_recommended_for_type(contentType)
  result = glistObjects2seq(AppInfo, resul0, true)
  g_list_free(resul0)

proc resetTypeAssociations*(contentType: cstring) {.
    importc: "g_app_info_reset_type_associations", libprag.}

type
  AppInfoCreateFlag* {.size: sizeof(cint), pure.} = enum
    needsTerminal = 0
    supportsUris = 1
    supportsStartupNotification = 2

  AppInfoCreateFlags* {.size: sizeof(cint).} = set[AppInfoCreateFlag]

const
  AppInfoCreateFlagsNone* = AppInfoCreateFlags({})
proc none*(t: typedesc[AppInfoCreateFlags]): AppInfoCreateFlags = AppInfoCreateFlags({})

proc g_app_info_create_from_commandline(commandline: cstring; applicationName: cstring;
    flags: AppInfoCreateFlags; error: ptr ptr glib.Error = nil): ptr AppInfo00 {.
    importc, libprag.}

proc createFromCommandline*(commandline: cstring; applicationName: cstring = nil;
    flags: AppInfoCreateFlags): AppInfo =
  var gerror: ptr glib.Error
  let gobj = g_app_info_create_from_commandline(commandline, applicationName, flags, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

type
  AppLaunchContext* = ref object of gobject.Object
  AppLaunchContext00* = object of gobject.Object00

proc g_app_launch_context_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(AppLaunchContext()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc scLaunchFailed*(self: AppLaunchContext;  p: proc (self: ptr AppLaunchContext00; startupNotifyId: cstring; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "launch-failed", cast[GCallback](p), xdata, nil, cf)

proc scLaunched*(self: AppLaunchContext;  p: proc (self: ptr AppLaunchContext00; info: ptr AppInfo00; platformData: ptr glib.Variant00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "launched", cast[GCallback](p), xdata, nil, cf)

proc g_app_launch_context_new(): ptr AppLaunchContext00 {.
    importc, libprag.}

proc newAppLaunchContext*(): AppLaunchContext =
  let gobj = g_app_launch_context_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newAppLaunchContext*(tdesc: typedesc): tdesc =
  assert(result is AppLaunchContext)
  let gobj = g_app_launch_context_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initAppLaunchContext*[T](result: var T) {.deprecated.} =
  assert(result is AppLaunchContext)
  let gobj = g_app_launch_context_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_app_launch_context_get_environment(self: ptr AppLaunchContext00): ptr cstring {.
    importc, libprag.}

proc getEnvironment*(self: AppLaunchContext): seq[string] =
  let resul0 = g_app_launch_context_get_environment(cast[ptr AppLaunchContext00](self.impl))
  if resul0.isNil:
    return
  result = cstringArrayToSeq(resul0)
  g_strfreev(resul0)

proc environment*(self: AppLaunchContext): seq[string] =
  let resul0 = g_app_launch_context_get_environment(cast[ptr AppLaunchContext00](self.impl))
  if resul0.isNil:
    return
  result = cstringArrayToSeq(resul0)
  g_strfreev(resul0)

proc g_app_launch_context_launch_failed(self: ptr AppLaunchContext00; startupNotifyId: cstring) {.
    importc, libprag.}

proc launchFailed*(self: AppLaunchContext; startupNotifyId: cstring) =
  g_app_launch_context_launch_failed(cast[ptr AppLaunchContext00](self.impl), startupNotifyId)

proc g_app_launch_context_setenv(self: ptr AppLaunchContext00; variable: cstring;
    value: cstring) {.
    importc, libprag.}

proc setenv*(self: AppLaunchContext; variable: cstring;
    value: cstring) =
  g_app_launch_context_setenv(cast[ptr AppLaunchContext00](self.impl), variable, value)

proc g_app_launch_context_unsetenv(self: ptr AppLaunchContext00; variable: cstring) {.
    importc, libprag.}

proc unsetenv*(self: AppLaunchContext; variable: cstring) =
  g_app_launch_context_unsetenv(cast[ptr AppLaunchContext00](self.impl), variable)

proc g_app_info_launch_default_for_uri(uri: cstring; context: ptr AppLaunchContext00;
    error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc launchDefaultForUri*(uri: cstring; context: AppLaunchContext = nil): bool =
  var gerror: ptr glib.Error
  let resul0 = g_app_info_launch_default_for_uri(uri, if context.isNil: nil else: cast[ptr AppLaunchContext00](context.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

type
  DesktopAppInfo* = ref object of gobject.Object
  DesktopAppInfo00* = object of gobject.Object00

proc g_desktop_app_info_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(DesktopAppInfo()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc g_desktop_app_info_new(desktopId: cstring): ptr DesktopAppInfo00 {.
    importc, libprag.}

proc newDesktopAppInfo*(desktopId: cstring): DesktopAppInfo =
  let gobj = g_desktop_app_info_new(desktopId)
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newDesktopAppInfo*(tdesc: typedesc; desktopId: cstring): tdesc =
  assert(result is DesktopAppInfo)
  let gobj = g_desktop_app_info_new(desktopId)
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initDesktopAppInfo*[T](result: var T; desktopId: cstring) {.deprecated.} =
  assert(result is DesktopAppInfo)
  let gobj = g_desktop_app_info_new(desktopId)
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_desktop_app_info_new_from_filename(filename: cstring): ptr DesktopAppInfo00 {.
    importc, libprag.}

proc newDesktopAppInfoFromFilename*(filename: cstring): DesktopAppInfo =
  let gobj = g_desktop_app_info_new_from_filename(filename)
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newDesktopAppInfoFromFilename*(tdesc: typedesc; filename: cstring): tdesc =
  assert(result is DesktopAppInfo)
  let gobj = g_desktop_app_info_new_from_filename(filename)
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initDesktopAppInfoFromFilename*[T](result: var T; filename: cstring) {.deprecated.} =
  assert(result is DesktopAppInfo)
  let gobj = g_desktop_app_info_new_from_filename(filename)
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_desktop_app_info_new_from_keyfile(keyFile: ptr glib.KeyFile00): ptr DesktopAppInfo00 {.
    importc, libprag.}

proc newDesktopAppInfoFromKeyfile*(keyFile: glib.KeyFile): DesktopAppInfo =
  let gobj = g_desktop_app_info_new_from_keyfile(cast[ptr glib.KeyFile00](keyFile.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newDesktopAppInfoFromKeyfile*(tdesc: typedesc; keyFile: glib.KeyFile): tdesc =
  assert(result is DesktopAppInfo)
  let gobj = g_desktop_app_info_new_from_keyfile(cast[ptr glib.KeyFile00](keyFile.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initDesktopAppInfoFromKeyfile*[T](result: var T; keyFile: glib.KeyFile) {.deprecated.} =
  assert(result is DesktopAppInfo)
  let gobj = g_desktop_app_info_new_from_keyfile(cast[ptr glib.KeyFile00](keyFile.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_desktop_app_info_get_implementations(`interface`: cstring): ptr glib.List {.
    importc, libprag.}

proc getImplementations*(`interface`: cstring): seq[DesktopAppInfo] =
  let resul0 = g_desktop_app_info_get_implementations(`interface`)
  result = glistObjects2seq(DesktopAppInfo, resul0, true)
  g_list_free(resul0)

proc implementations*(`interface`: cstring): seq[DesktopAppInfo] =
  let resul0 = g_desktop_app_info_get_implementations(`interface`)
  result = glistObjects2seq(DesktopAppInfo, resul0, true)
  g_list_free(resul0)

proc search*(searchString: cstring): ptr ptr cstring {.
    importc: "g_desktop_app_info_search", libprag.}

proc setDesktopEnv*(desktopEnv: cstring) {.
    importc: "g_desktop_app_info_set_desktop_env", libprag.}

proc g_desktop_app_info_get_action_name(self: ptr DesktopAppInfo00; actionName: cstring): cstring {.
    importc, libprag.}

proc getActionName*(self: DesktopAppInfo; actionName: cstring): string =
  let resul0 = g_desktop_app_info_get_action_name(cast[ptr DesktopAppInfo00](self.impl), actionName)
  result = $resul0
  cogfree(resul0)

proc g_desktop_app_info_get_boolean(self: ptr DesktopAppInfo00; key: cstring): gboolean {.
    importc, libprag.}

proc getBoolean*(self: DesktopAppInfo; key: cstring): bool =
  toBool(g_desktop_app_info_get_boolean(cast[ptr DesktopAppInfo00](self.impl), key))

proc g_desktop_app_info_get_categories(self: ptr DesktopAppInfo00): cstring {.
    importc, libprag.}

proc getCategories*(self: DesktopAppInfo): string =
  result = $g_desktop_app_info_get_categories(cast[ptr DesktopAppInfo00](self.impl))

proc categories*(self: DesktopAppInfo): string =
  result = $g_desktop_app_info_get_categories(cast[ptr DesktopAppInfo00](self.impl))

proc g_desktop_app_info_get_filename(self: ptr DesktopAppInfo00): cstring {.
    importc, libprag.}

proc getFilename*(self: DesktopAppInfo): string =
  result = $g_desktop_app_info_get_filename(cast[ptr DesktopAppInfo00](self.impl))

proc filename*(self: DesktopAppInfo): string =
  result = $g_desktop_app_info_get_filename(cast[ptr DesktopAppInfo00](self.impl))

proc g_desktop_app_info_get_generic_name(self: ptr DesktopAppInfo00): cstring {.
    importc, libprag.}

proc getGenericName*(self: DesktopAppInfo): string =
  result = $g_desktop_app_info_get_generic_name(cast[ptr DesktopAppInfo00](self.impl))

proc genericName*(self: DesktopAppInfo): string =
  result = $g_desktop_app_info_get_generic_name(cast[ptr DesktopAppInfo00](self.impl))

proc g_desktop_app_info_get_is_hidden(self: ptr DesktopAppInfo00): gboolean {.
    importc, libprag.}

proc getIsHidden*(self: DesktopAppInfo): bool =
  toBool(g_desktop_app_info_get_is_hidden(cast[ptr DesktopAppInfo00](self.impl)))

proc isHidden*(self: DesktopAppInfo): bool =
  toBool(g_desktop_app_info_get_is_hidden(cast[ptr DesktopAppInfo00](self.impl)))

proc g_desktop_app_info_get_keywords(self: ptr DesktopAppInfo00): ptr cstring {.
    importc, libprag.}

proc getKeywords*(self: DesktopAppInfo): seq[string] =
  cstringArrayToSeq(g_desktop_app_info_get_keywords(cast[ptr DesktopAppInfo00](self.impl)))

proc keywords*(self: DesktopAppInfo): seq[string] =
  cstringArrayToSeq(g_desktop_app_info_get_keywords(cast[ptr DesktopAppInfo00](self.impl)))

proc g_desktop_app_info_get_locale_string(self: ptr DesktopAppInfo00; key: cstring): cstring {.
    importc, libprag.}

proc getLocaleString*(self: DesktopAppInfo; key: cstring): string =
  let resul0 = g_desktop_app_info_get_locale_string(cast[ptr DesktopAppInfo00](self.impl), key)
  if resul0.isNil:
    return
  result = $resul0
  cogfree(resul0)

proc g_desktop_app_info_get_nodisplay(self: ptr DesktopAppInfo00): gboolean {.
    importc, libprag.}

proc getNodisplay*(self: DesktopAppInfo): bool =
  toBool(g_desktop_app_info_get_nodisplay(cast[ptr DesktopAppInfo00](self.impl)))

proc nodisplay*(self: DesktopAppInfo): bool =
  toBool(g_desktop_app_info_get_nodisplay(cast[ptr DesktopAppInfo00](self.impl)))

proc g_desktop_app_info_get_show_in(self: ptr DesktopAppInfo00; desktopEnv: cstring): gboolean {.
    importc, libprag.}

proc getShowIn*(self: DesktopAppInfo; desktopEnv: cstring = nil): bool =
  toBool(g_desktop_app_info_get_show_in(cast[ptr DesktopAppInfo00](self.impl), desktopEnv))

proc g_desktop_app_info_get_startup_wm_class(self: ptr DesktopAppInfo00): cstring {.
    importc, libprag.}

proc getStartupWmClass*(self: DesktopAppInfo): string =
  result = $g_desktop_app_info_get_startup_wm_class(cast[ptr DesktopAppInfo00](self.impl))

proc startupWmClass*(self: DesktopAppInfo): string =
  result = $g_desktop_app_info_get_startup_wm_class(cast[ptr DesktopAppInfo00](self.impl))

proc g_desktop_app_info_get_string(self: ptr DesktopAppInfo00; key: cstring): cstring {.
    importc, libprag.}

proc getString*(self: DesktopAppInfo; key: cstring): string =
  let resul0 = g_desktop_app_info_get_string(cast[ptr DesktopAppInfo00](self.impl), key)
  result = $resul0
  cogfree(resul0)

proc g_desktop_app_info_get_string_list(self: ptr DesktopAppInfo00; key: cstring;
    length: var uint64): ptr cstring {.
    importc, libprag.}

proc getStringList*(self: DesktopAppInfo; key: cstring;
    length: var uint64 = cast[var uint64](nil)): seq[string] =
  let resul0 = g_desktop_app_info_get_string_list(cast[ptr DesktopAppInfo00](self.impl), key, length)
  if resul0.isNil:
    return
  result = cstringArrayToSeq(resul0)
  g_strfreev(resul0)

proc g_desktop_app_info_has_key(self: ptr DesktopAppInfo00; key: cstring): gboolean {.
    importc, libprag.}

proc hasKey*(self: DesktopAppInfo; key: cstring): bool =
  toBool(g_desktop_app_info_has_key(cast[ptr DesktopAppInfo00](self.impl), key))

proc g_desktop_app_info_launch_action(self: ptr DesktopAppInfo00; actionName: cstring;
    launchContext: ptr AppLaunchContext00) {.
    importc, libprag.}

proc launchAction*(self: DesktopAppInfo; actionName: cstring;
    launchContext: AppLaunchContext = nil) =
  g_desktop_app_info_launch_action(cast[ptr DesktopAppInfo00](self.impl), actionName, if launchContext.isNil: nil else: cast[ptr AppLaunchContext00](launchContext.impl))

proc g_desktop_app_info_list_actions(self: ptr DesktopAppInfo00): ptr cstring {.
    importc, libprag.}

proc listActions*(self: DesktopAppInfo): seq[string] =
  cstringArrayToSeq(g_desktop_app_info_list_actions(cast[ptr DesktopAppInfo00](self.impl)))

proc g_app_info_add_supports_type(self: ptr AppInfo00; contentType: cstring;
    error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc addSupportsType*(self: AppInfo | DesktopAppInfo; contentType: cstring): bool =
  var gerror: ptr glib.Error
  let resul0 = g_app_info_add_supports_type(cast[ptr AppInfo00](self.impl), contentType, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_app_info_can_delete(self: ptr AppInfo00): gboolean {.
    importc, libprag.}

proc canDelete*(self: AppInfo | DesktopAppInfo): bool =
  toBool(g_app_info_can_delete(cast[ptr AppInfo00](self.impl)))

proc g_app_info_can_remove_supports_type(self: ptr AppInfo00): gboolean {.
    importc, libprag.}

proc canRemoveSupportsType*(self: AppInfo | DesktopAppInfo): bool =
  toBool(g_app_info_can_remove_supports_type(cast[ptr AppInfo00](self.impl)))

proc g_app_info_delete(self: ptr AppInfo00): gboolean {.
    importc, libprag.}

proc delete*(self: AppInfo | DesktopAppInfo): bool =
  toBool(g_app_info_delete(cast[ptr AppInfo00](self.impl)))

proc g_app_info_dup(self: ptr AppInfo00): ptr AppInfo00 {.
    importc, libprag.}

proc dup*(self: AppInfo | DesktopAppInfo): AppInfo =
  let gobj = g_app_info_dup(cast[ptr AppInfo00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_app_info_equal(self: ptr AppInfo00; appinfo2: ptr AppInfo00): gboolean {.
    importc, libprag.}

proc equal*(self: AppInfo | DesktopAppInfo; appinfo2: AppInfo | DesktopAppInfo): bool =
  toBool(g_app_info_equal(cast[ptr AppInfo00](self.impl), cast[ptr AppInfo00](appinfo2.impl)))

proc g_app_info_get_commandline(self: ptr AppInfo00): cstring {.
    importc, libprag.}

proc getCommandline*(self: AppInfo | DesktopAppInfo): string =
  result = $g_app_info_get_commandline(cast[ptr AppInfo00](self.impl))

proc commandline*(self: AppInfo | DesktopAppInfo): string =
  result = $g_app_info_get_commandline(cast[ptr AppInfo00](self.impl))

proc g_app_info_get_description(self: ptr AppInfo00): cstring {.
    importc, libprag.}

proc getDescription*(self: AppInfo | DesktopAppInfo): string =
  result = $g_app_info_get_description(cast[ptr AppInfo00](self.impl))

proc description*(self: AppInfo | DesktopAppInfo): string =
  result = $g_app_info_get_description(cast[ptr AppInfo00](self.impl))

proc g_app_info_get_display_name(self: ptr AppInfo00): cstring {.
    importc, libprag.}

proc getDisplayName*(self: AppInfo | DesktopAppInfo): string =
  result = $g_app_info_get_display_name(cast[ptr AppInfo00](self.impl))

proc displayName*(self: AppInfo | DesktopAppInfo): string =
  result = $g_app_info_get_display_name(cast[ptr AppInfo00](self.impl))

proc g_app_info_get_executable(self: ptr AppInfo00): cstring {.
    importc, libprag.}

proc getExecutable*(self: AppInfo | DesktopAppInfo): string =
  result = $g_app_info_get_executable(cast[ptr AppInfo00](self.impl))

proc executable*(self: AppInfo | DesktopAppInfo): string =
  result = $g_app_info_get_executable(cast[ptr AppInfo00](self.impl))

proc g_app_info_get_icon(self: ptr AppInfo00): ptr Icon00 {.
    importc, libprag.}

proc getIcon*(self: AppInfo | DesktopAppInfo): Icon =
  let gobj = g_app_info_get_icon(cast[ptr AppInfo00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc icon*(self: AppInfo | DesktopAppInfo): Icon =
  let gobj = g_app_info_get_icon(cast[ptr AppInfo00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_app_info_get_id(self: ptr AppInfo00): cstring {.
    importc, libprag.}

proc getId*(self: AppInfo | DesktopAppInfo): string =
  result = $g_app_info_get_id(cast[ptr AppInfo00](self.impl))

proc id*(self: AppInfo | DesktopAppInfo): string =
  result = $g_app_info_get_id(cast[ptr AppInfo00](self.impl))

proc g_app_info_get_name(self: ptr AppInfo00): cstring {.
    importc, libprag.}

proc getName*(self: AppInfo | DesktopAppInfo): string =
  result = $g_app_info_get_name(cast[ptr AppInfo00](self.impl))

proc name*(self: AppInfo | DesktopAppInfo): string =
  result = $g_app_info_get_name(cast[ptr AppInfo00](self.impl))

proc g_app_info_get_supported_types(self: ptr AppInfo00): ptr cstring {.
    importc, libprag.}

proc getSupportedTypes*(self: AppInfo | DesktopAppInfo): seq[string] =
  cstringArrayToSeq(g_app_info_get_supported_types(cast[ptr AppInfo00](self.impl)))

proc supportedTypes*(self: AppInfo | DesktopAppInfo): seq[string] =
  cstringArrayToSeq(g_app_info_get_supported_types(cast[ptr AppInfo00](self.impl)))

proc g_app_info_launch(self: ptr AppInfo00; files: ptr glib.List; context: ptr AppLaunchContext00;
    error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc launch*(self: AppInfo | DesktopAppInfo; files: seq[GFile];
    context: AppLaunchContext = nil): bool =
  var tempResGL = seq2GList(files)
  var gerror: ptr glib.Error
  let resul0 = g_app_info_launch(cast[ptr AppInfo00](self.impl), tempResGL, if context.isNil: nil else: cast[ptr AppLaunchContext00](context.impl), addr gerror)
  g_list_free(tempResGL)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_app_info_launch_uris(self: ptr AppInfo00; uris: ptr glib.List; context: ptr AppLaunchContext00;
    error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc launchUris*(self: AppInfo | DesktopAppInfo; uris: seq[cstring];
    context: AppLaunchContext = nil): bool =
  var tempResGL = seq2GList(uris)
  var gerror: ptr glib.Error
  let resul0 = g_app_info_launch_uris(cast[ptr AppInfo00](self.impl), tempResGL, if context.isNil: nil else: cast[ptr AppLaunchContext00](context.impl), addr gerror)
  g_list_free(tempResGL)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_app_info_remove_supports_type(self: ptr AppInfo00; contentType: cstring;
    error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc removeSupportsType*(self: AppInfo | DesktopAppInfo; contentType: cstring): bool =
  var gerror: ptr glib.Error
  let resul0 = g_app_info_remove_supports_type(cast[ptr AppInfo00](self.impl), contentType, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_app_info_set_as_default_for_extension(self: ptr AppInfo00; extension: cstring;
    error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc setAsDefaultForExtension*(self: AppInfo | DesktopAppInfo;
    extension: cstring): bool =
  var gerror: ptr glib.Error
  let resul0 = g_app_info_set_as_default_for_extension(cast[ptr AppInfo00](self.impl), extension, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_app_info_set_as_default_for_type(self: ptr AppInfo00; contentType: cstring;
    error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc setAsDefaultForType*(self: AppInfo | DesktopAppInfo; contentType: cstring): bool =
  var gerror: ptr glib.Error
  let resul0 = g_app_info_set_as_default_for_type(cast[ptr AppInfo00](self.impl), contentType, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_app_info_set_as_last_used_for_type(self: ptr AppInfo00; contentType: cstring;
    error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc setAsLastUsedForType*(self: AppInfo | DesktopAppInfo;
    contentType: cstring): bool =
  var gerror: ptr glib.Error
  let resul0 = g_app_info_set_as_last_used_for_type(cast[ptr AppInfo00](self.impl), contentType, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_app_info_should_show(self: ptr AppInfo00): gboolean {.
    importc, libprag.}

proc shouldShow*(self: AppInfo | DesktopAppInfo): bool =
  toBool(g_app_info_should_show(cast[ptr AppInfo00](self.impl)))

proc g_app_info_supports_files(self: ptr AppInfo00): gboolean {.
    importc, libprag.}

proc supportsFiles*(self: AppInfo | DesktopAppInfo): bool =
  toBool(g_app_info_supports_files(cast[ptr AppInfo00](self.impl)))

proc g_app_info_supports_uris(self: ptr AppInfo00): gboolean {.
    importc, libprag.}

proc supportsUris*(self: AppInfo | DesktopAppInfo): bool =
  toBool(g_app_info_supports_uris(cast[ptr AppInfo00](self.impl)))

proc g_app_launch_context_get_display(self: ptr AppLaunchContext00; info: ptr AppInfo00;
    files: ptr glib.List): cstring {.
    importc, libprag.}

proc getDisplay*(self: AppLaunchContext; info: AppInfo | DesktopAppInfo;
    files: seq[GFile]): string =
  var tempResGL = seq2GList(files)
  let resul0 = g_app_launch_context_get_display(cast[ptr AppLaunchContext00](self.impl), cast[ptr AppInfo00](info.impl), tempResGL)
  g_list_free(tempResGL)
  result = $resul0
  cogfree(resul0)

proc g_app_launch_context_get_startup_notify_id(self: ptr AppLaunchContext00;
    info: ptr AppInfo00; files: ptr glib.List): cstring {.
    importc, libprag.}

proc getStartupNotifyId*(self: AppLaunchContext; info: AppInfo | DesktopAppInfo;
    files: seq[GFile]): string =
  var tempResGL = seq2GList(files)
  let resul0 = g_app_launch_context_get_startup_notify_id(cast[ptr AppLaunchContext00](self.impl), cast[ptr AppInfo00](info.impl), tempResGL)
  g_list_free(tempResGL)
  result = $resul0
  cogfree(resul0)

type
  FileOutputStream* = ref object of OutputStream
  FileOutputStream00* = object of OutputStream00

proc g_file_output_stream_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(FileOutputStream()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc g_file_output_stream_get_etag(self: ptr FileOutputStream00): cstring {.
    importc, libprag.}

proc getEtag*(self: FileOutputStream): string =
  let resul0 = g_file_output_stream_get_etag(cast[ptr FileOutputStream00](self.impl))
  result = $resul0
  cogfree(resul0)

proc etag*(self: FileOutputStream): string =
  let resul0 = g_file_output_stream_get_etag(cast[ptr FileOutputStream00](self.impl))
  result = $resul0
  cogfree(resul0)

type
  SimpleAsyncResult* = ref object of gobject.Object
  SimpleAsyncResult00* = object of gobject.Object00

proc g_simple_async_result_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(SimpleAsyncResult()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc g_simple_async_result_complete(self: ptr SimpleAsyncResult00) {.
    importc, libprag.}

proc complete*(self: SimpleAsyncResult) =
  g_simple_async_result_complete(cast[ptr SimpleAsyncResult00](self.impl))

proc g_simple_async_result_complete_in_idle(self: ptr SimpleAsyncResult00) {.
    importc, libprag.}

proc completeInIdle*(self: SimpleAsyncResult) =
  g_simple_async_result_complete_in_idle(cast[ptr SimpleAsyncResult00](self.impl))

proc g_simple_async_result_get_op_res_gboolean(self: ptr SimpleAsyncResult00): gboolean {.
    importc, libprag.}

proc getOpResGboolean*(self: SimpleAsyncResult): bool =
  toBool(g_simple_async_result_get_op_res_gboolean(cast[ptr SimpleAsyncResult00](self.impl)))

proc opResGboolean*(self: SimpleAsyncResult): bool =
  toBool(g_simple_async_result_get_op_res_gboolean(cast[ptr SimpleAsyncResult00](self.impl)))

proc g_simple_async_result_get_op_res_gssize(self: ptr SimpleAsyncResult00): int64 {.
    importc, libprag.}

proc getOpResGssize*(self: SimpleAsyncResult): int64 =
  g_simple_async_result_get_op_res_gssize(cast[ptr SimpleAsyncResult00](self.impl))

proc opResGssize*(self: SimpleAsyncResult): int64 =
  g_simple_async_result_get_op_res_gssize(cast[ptr SimpleAsyncResult00](self.impl))

proc g_simple_async_result_propagate_error(self: ptr SimpleAsyncResult00;
    error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc propagateError*(self: SimpleAsyncResult): bool =
  var gerror: ptr glib.Error
  let resul0 = g_simple_async_result_propagate_error(cast[ptr SimpleAsyncResult00](self.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_simple_async_result_set_from_error(self: ptr SimpleAsyncResult00;
    error: ptr glib.Error) {.
    importc, libprag.}

proc setFromError*(self: SimpleAsyncResult; error: ptr glib.Error) =
  g_simple_async_result_set_from_error(cast[ptr SimpleAsyncResult00](self.impl), error)

proc `fromError=`*(self: SimpleAsyncResult; error: ptr glib.Error) =
  g_simple_async_result_set_from_error(cast[ptr SimpleAsyncResult00](self.impl), error)

proc g_simple_async_result_set_handle_cancellation(self: ptr SimpleAsyncResult00;
    handleCancellation: gboolean) {.
    importc, libprag.}

proc setHandleCancellation*(self: SimpleAsyncResult;
    handleCancellation: bool = true) =
  g_simple_async_result_set_handle_cancellation(cast[ptr SimpleAsyncResult00](self.impl), gboolean(handleCancellation))

proc `handleCancellation=`*(self: SimpleAsyncResult;
    handleCancellation: bool) =
  g_simple_async_result_set_handle_cancellation(cast[ptr SimpleAsyncResult00](self.impl), gboolean(handleCancellation))

proc g_simple_async_result_set_op_res_gboolean(self: ptr SimpleAsyncResult00;
    opRes: gboolean) {.
    importc, libprag.}

proc setOpResGboolean*(self: SimpleAsyncResult; opRes: bool = true) =
  g_simple_async_result_set_op_res_gboolean(cast[ptr SimpleAsyncResult00](self.impl), gboolean(opRes))

proc `opResGboolean=`*(self: SimpleAsyncResult; opRes: bool) =
  g_simple_async_result_set_op_res_gboolean(cast[ptr SimpleAsyncResult00](self.impl), gboolean(opRes))

proc g_simple_async_result_set_op_res_gssize(self: ptr SimpleAsyncResult00;
    opRes: int64) {.
    importc, libprag.}

proc setOpResGssize*(self: SimpleAsyncResult; opRes: int64) =
  g_simple_async_result_set_op_res_gssize(cast[ptr SimpleAsyncResult00](self.impl), opRes)

proc `opResGssize=`*(self: SimpleAsyncResult; opRes: int64) =
  g_simple_async_result_set_op_res_gssize(cast[ptr SimpleAsyncResult00](self.impl), opRes)

type
  Task* = ref object of gobject.Object
  Task00* = object of gobject.Object00

proc g_task_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(Task()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc g_task_is_valid(resu: ptr AsyncResult00; sourceObject: ptr gobject.Object00): gboolean {.
    importc, libprag.}

proc isValid*(resu: AsyncResult | SimpleAsyncResult | Task; sourceObject: gobject.Object = nil): bool =
  toBool(g_task_is_valid(cast[ptr AsyncResult00](resu.impl), if sourceObject.isNil: nil else: cast[ptr gobject.Object00](sourceObject.impl)))

proc g_task_get_check_cancellable(self: ptr Task00): gboolean {.
    importc, libprag.}

proc getCheckCancellable*(self: Task): bool =
  toBool(g_task_get_check_cancellable(cast[ptr Task00](self.impl)))

proc checkCancellable*(self: Task): bool =
  toBool(g_task_get_check_cancellable(cast[ptr Task00](self.impl)))

proc g_task_get_completed(self: ptr Task00): gboolean {.
    importc, libprag.}

proc getCompleted*(self: Task): bool =
  toBool(g_task_get_completed(cast[ptr Task00](self.impl)))

proc completed*(self: Task): bool =
  toBool(g_task_get_completed(cast[ptr Task00](self.impl)))

proc g_task_get_context(self: ptr Task00): ptr glib.MainContext00 {.
    importc, libprag.}

proc getContext*(self: Task): glib.MainContext =
  fnew(result, gBoxedFreeGMainContext)
  result.impl = g_task_get_context(cast[ptr Task00](self.impl))
  result.impl = cast[typeof(result.impl)](g_boxed_copy(g_main_context_get_type(), result.impl))

proc context*(self: Task): glib.MainContext =
  fnew(result, gBoxedFreeGMainContext)
  result.impl = g_task_get_context(cast[ptr Task00](self.impl))
  result.impl = cast[typeof(result.impl)](g_boxed_copy(g_main_context_get_type(), result.impl))

proc g_task_get_name(self: ptr Task00): cstring {.
    importc, libprag.}

proc getName*(self: Task): string =
  let resul0 = g_task_get_name(cast[ptr Task00](self.impl))
  if resul0.isNil:
    return
  result = $resul0

proc name*(self: Task): string =
  let resul0 = g_task_get_name(cast[ptr Task00](self.impl))
  if resul0.isNil:
    return
  result = $resul0

proc g_task_get_priority(self: ptr Task00): int32 {.
    importc, libprag.}

proc getPriority*(self: Task): int =
  int(g_task_get_priority(cast[ptr Task00](self.impl)))

proc priority*(self: Task): int =
  int(g_task_get_priority(cast[ptr Task00](self.impl)))

proc g_task_get_return_on_cancel(self: ptr Task00): gboolean {.
    importc, libprag.}

proc getReturnOnCancel*(self: Task): bool =
  toBool(g_task_get_return_on_cancel(cast[ptr Task00](self.impl)))

proc returnOnCancel*(self: Task): bool =
  toBool(g_task_get_return_on_cancel(cast[ptr Task00](self.impl)))

proc g_task_get_source_object(self: ptr Task00): ptr gobject.Object00 {.
    importc, libprag.}

proc getSourceObject*(self: Task): gobject.Object =
  let gobj = g_task_get_source_object(cast[ptr Task00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gobject.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc sourceObject*(self: Task): gobject.Object =
  let gobj = g_task_get_source_object(cast[ptr Task00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gobject.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_task_get_source_tag(self: ptr Task00): pointer {.
    importc, libprag.}

proc getSourceTag*(self: Task): pointer =
  g_task_get_source_tag(cast[ptr Task00](self.impl))

proc g_task_get_task_data(self: ptr Task00): pointer {.
    importc, libprag.}

proc getTaskData*(self: Task): pointer =
  g_task_get_task_data(cast[ptr Task00](self.impl))

proc g_task_had_error(self: ptr Task00): gboolean {.
    importc, libprag.}

proc hadError*(self: Task): bool =
  toBool(g_task_had_error(cast[ptr Task00](self.impl)))

proc g_task_propagate_boolean(self: ptr Task00; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc propagateBoolean*(self: Task): bool =
  var gerror: ptr glib.Error
  let resul0 = g_task_propagate_boolean(cast[ptr Task00](self.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_task_propagate_int(self: ptr Task00; error: ptr ptr glib.Error = nil): int64 {.
    importc, libprag.}

proc propagateInt*(self: Task): int64 =
  var gerror: ptr glib.Error
  let resul0 = g_task_propagate_int(cast[ptr Task00](self.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = resul0

proc g_task_propagate_pointer(self: ptr Task00; error: ptr ptr glib.Error = nil): pointer {.
    importc, libprag.}

proc propagatePointer*(self: Task): pointer =
  var gerror: ptr glib.Error
  let resul0 = g_task_propagate_pointer(cast[ptr Task00](self.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  if resul0.isNil:
    return
  result = resul0

proc g_task_propagate_value(self: ptr Task00; value: var gobject.Value; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc propagateValue*(self: Task; value: var gobject.Value): bool =
  var gerror: ptr glib.Error
  let resul0 = g_task_propagate_value(cast[ptr Task00](self.impl), value, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_task_return_boolean(self: ptr Task00; resu: gboolean) {.
    importc, libprag.}

proc returnBoolean*(self: Task; resu: bool) =
  g_task_return_boolean(cast[ptr Task00](self.impl), gboolean(resu))

proc g_task_return_error(self: ptr Task00; error: ptr glib.Error) {.
    importc, libprag.}

proc returnError*(self: Task; error: ptr glib.Error) =
  g_task_return_error(cast[ptr Task00](self.impl), error)

proc g_task_return_error_if_cancelled(self: ptr Task00): gboolean {.
    importc, libprag.}

proc returnErrorIfCancelled*(self: Task): bool =
  toBool(g_task_return_error_if_cancelled(cast[ptr Task00](self.impl)))

proc g_task_return_int(self: ptr Task00; resu: int64) {.
    importc, libprag.}

proc returnInt*(self: Task; resu: int64) =
  g_task_return_int(cast[ptr Task00](self.impl), resu)

proc g_task_return_pointer(self: ptr Task00; resu: pointer; resultDestroy: DestroyNotify) {.
    importc, libprag.}

proc returnPointer*(self: Task; resu: pointer; resultDestroy: DestroyNotify) =
  g_task_return_pointer(cast[ptr Task00](self.impl), resu, resultDestroy)

proc g_task_return_value(self: ptr Task00; resu: gobject.Value) {.
    importc, libprag.}

proc returnValue*(self: Task; resu: gobject.Value = cast[var gobject.Value](nil)) =
  g_task_return_value(cast[ptr Task00](self.impl), resu)

proc g_task_set_check_cancellable(self: ptr Task00; checkCancellable: gboolean) {.
    importc, libprag.}

proc setCheckCancellable*(self: Task; checkCancellable: bool = true) =
  g_task_set_check_cancellable(cast[ptr Task00](self.impl), gboolean(checkCancellable))

proc `checkCancellable=`*(self: Task; checkCancellable: bool) =
  g_task_set_check_cancellable(cast[ptr Task00](self.impl), gboolean(checkCancellable))

proc g_task_set_name(self: ptr Task00; name: cstring) {.
    importc, libprag.}

proc setName*(self: Task; name: cstring = nil) =
  g_task_set_name(cast[ptr Task00](self.impl), name)

proc `name=`*(self: Task; name: cstring = nil) =
  g_task_set_name(cast[ptr Task00](self.impl), name)

proc g_task_set_priority(self: ptr Task00; priority: int32) {.
    importc, libprag.}

proc setPriority*(self: Task; priority: int) =
  g_task_set_priority(cast[ptr Task00](self.impl), int32(priority))

proc `priority=`*(self: Task; priority: int) =
  g_task_set_priority(cast[ptr Task00](self.impl), int32(priority))

proc g_task_set_return_on_cancel(self: ptr Task00; returnOnCancel: gboolean): gboolean {.
    importc, libprag.}

proc setReturnOnCancel*(self: Task; returnOnCancel: bool = true): bool =
  toBool(g_task_set_return_on_cancel(cast[ptr Task00](self.impl), gboolean(returnOnCancel)))

proc g_task_set_source_tag(self: ptr Task00; sourceTag: pointer) {.
    importc, libprag.}

proc setSourceTag*(self: Task; sourceTag: pointer) =
  g_task_set_source_tag(cast[ptr Task00](self.impl), sourceTag)

proc `sourceTag=`*(self: Task; sourceTag: pointer) =
  g_task_set_source_tag(cast[ptr Task00](self.impl), sourceTag)

proc g_task_set_task_data(self: ptr Task00; taskData: pointer; taskDataDestroy: DestroyNotify) {.
    importc, libprag.}

proc setTaskData*(self: Task; taskData: pointer; taskDataDestroy: DestroyNotify) =
  g_task_set_task_data(cast[ptr Task00](self.impl), taskData, taskDataDestroy)

proc g_file_append_to_finish(self: ptr GFile00; res: ptr AsyncResult00; error: ptr ptr glib.Error = nil): ptr FileOutputStream00 {.
    importc, libprag.}

proc appendToFinish*(self: GFile; res: AsyncResult | SimpleAsyncResult | Task): FileOutputStream =
  var gerror: ptr glib.Error
  let gobj = g_file_append_to_finish(cast[ptr GFile00](self.impl), cast[ptr AsyncResult00](res.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_file_copy_finish(self: ptr GFile00; res: ptr AsyncResult00; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc copyFinish*(self: GFile; res: AsyncResult | SimpleAsyncResult | Task): bool =
  var gerror: ptr glib.Error
  let resul0 = g_file_copy_finish(cast[ptr GFile00](self.impl), cast[ptr AsyncResult00](res.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_file_create_finish(self: ptr GFile00; res: ptr AsyncResult00; error: ptr ptr glib.Error = nil): ptr FileOutputStream00 {.
    importc, libprag.}

proc createFinish*(self: GFile; res: AsyncResult | SimpleAsyncResult | Task): FileOutputStream =
  var gerror: ptr glib.Error
  let gobj = g_file_create_finish(cast[ptr GFile00](self.impl), cast[ptr AsyncResult00](res.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_file_create_readwrite_finish(self: ptr GFile00; res: ptr AsyncResult00;
    error: ptr ptr glib.Error = nil): ptr FileIOStream00 {.
    importc, libprag.}

proc createReadwriteFinish*(self: GFile; res: AsyncResult | SimpleAsyncResult | Task): FileIOStream =
  var gerror: ptr glib.Error
  let gobj = g_file_create_readwrite_finish(cast[ptr GFile00](self.impl), cast[ptr AsyncResult00](res.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_file_delete_finish(self: ptr GFile00; resu: ptr AsyncResult00; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc deleteFinish*(self: GFile; resu: AsyncResult | SimpleAsyncResult | Task): bool =
  var gerror: ptr glib.Error
  let resul0 = g_file_delete_finish(cast[ptr GFile00](self.impl), cast[ptr AsyncResult00](resu.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_file_eject_mountable_finish(self: ptr GFile00; resu: ptr AsyncResult00;
    error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc ejectMountableFinish*(self: GFile; resu: AsyncResult | SimpleAsyncResult | Task): bool =
  var gerror: ptr glib.Error
  let resul0 = g_file_eject_mountable_finish(cast[ptr GFile00](self.impl), cast[ptr AsyncResult00](resu.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_file_eject_mountable_with_operation_finish(self: ptr GFile00; resu: ptr AsyncResult00;
    error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc ejectMountableWithOperationFinish*(self: GFile; resu: AsyncResult | SimpleAsyncResult | Task): bool =
  var gerror: ptr glib.Error
  let resul0 = g_file_eject_mountable_with_operation_finish(cast[ptr GFile00](self.impl), cast[ptr AsyncResult00](resu.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_file_enumerate_children_finish(self: ptr GFile00; res: ptr AsyncResult00;
    error: ptr ptr glib.Error = nil): ptr FileEnumerator00 {.
    importc, libprag.}

proc enumerateChildrenFinish*(self: GFile; res: AsyncResult | SimpleAsyncResult | Task): FileEnumerator =
  var gerror: ptr glib.Error
  let gobj = g_file_enumerate_children_finish(cast[ptr GFile00](self.impl), cast[ptr AsyncResult00](res.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_file_find_enclosing_mount_finish(self: ptr GFile00; res: ptr AsyncResult00;
    error: ptr ptr glib.Error = nil): ptr Mount00 {.
    importc, libprag.}

proc findEnclosingMountFinish*(self: GFile; res: AsyncResult | SimpleAsyncResult | Task): Mount =
  var gerror: ptr glib.Error
  let gobj = g_file_find_enclosing_mount_finish(cast[ptr GFile00](self.impl), cast[ptr AsyncResult00](res.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_file_load_bytes_finish(self: ptr GFile00; resu: ptr AsyncResult00;
    etagOut: var cstring; error: ptr ptr glib.Error = nil): ptr glib.Bytes00 {.
    importc, libprag.}

proc loadBytesFinish*(self: GFile; resu: AsyncResult | SimpleAsyncResult | Task;
    etagOut: var string = cast[var string](nil)): glib.Bytes =
  var gerror: ptr glib.Error
  var etagOut_00: cstring
  let impl0 = g_file_load_bytes_finish(cast[ptr GFile00](self.impl), cast[ptr AsyncResult00](resu.impl), etagOut_00, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  fnew(result, gBoxedFreeGBytes)
  result.impl = impl0
  if etagOut.addr != nil:
    etagOut = $(etagOut_00)

proc g_file_load_contents_finish(self: ptr GFile00; res: ptr AsyncResult00;
    contents: var ptr uint8; length: var uint64; etagOut: var cstring; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc loadContentsFinish*(self: GFile; res: AsyncResult | SimpleAsyncResult | Task;
    contents: var (seq[uint8] | string); length: var uint64 = cast[var uint64](nil);
    etagOut: var string = cast[var string](nil)): bool =
  var gerror: ptr glib.Error
  var etagOut_00: cstring
  var contents_00: ptr uint8
  let resul0 = g_file_load_contents_finish(cast[ptr GFile00](self.impl), cast[ptr AsyncResult00](res.impl), contents_00, length, etagOut_00, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)
  if etagOut.addr != nil:
    etagOut = $(etagOut_00)
  contents.setLen(length)
  copyMem(unsafeaddr contents[0], contents_00, length.int * sizeof(contents[0]))
  cogfree(contents_00)

proc g_file_make_directory_finish(self: ptr GFile00; resu: ptr AsyncResult00;
    error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc makeDirectoryFinish*(self: GFile; resu: AsyncResult | SimpleAsyncResult | Task): bool =
  var gerror: ptr glib.Error
  let resul0 = g_file_make_directory_finish(cast[ptr GFile00](self.impl), cast[ptr AsyncResult00](resu.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_file_measure_disk_usage_finish(self: ptr GFile00; resu: ptr AsyncResult00;
    diskUsage: var uint64; numDirs: var uint64; numFiles: var uint64; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc measureDiskUsageFinish*(self: GFile; resu: AsyncResult | SimpleAsyncResult | Task;
    diskUsage: var uint64 = cast[var uint64](nil); numDirs: var uint64 = cast[var uint64](nil);
    numFiles: var uint64 = cast[var uint64](nil)): bool =
  var gerror: ptr glib.Error
  let resul0 = g_file_measure_disk_usage_finish(cast[ptr GFile00](self.impl), cast[ptr AsyncResult00](resu.impl), diskUsage, numDirs, numFiles, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_file_mount_enclosing_volume_finish(self: ptr GFile00; resu: ptr AsyncResult00;
    error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc mountEnclosingVolumeFinish*(self: GFile; resu: AsyncResult | SimpleAsyncResult | Task): bool =
  var gerror: ptr glib.Error
  let resul0 = g_file_mount_enclosing_volume_finish(cast[ptr GFile00](self.impl), cast[ptr AsyncResult00](resu.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_file_mount_mountable_finish(self: ptr GFile00; resu: ptr AsyncResult00;
    error: ptr ptr glib.Error = nil): ptr GFile00 {.
    importc, libprag.}

proc mountMountableFinish*(self: GFile; resu: AsyncResult | SimpleAsyncResult | Task): GFile =
  var gerror: ptr glib.Error
  let gobj = g_file_mount_mountable_finish(cast[ptr GFile00](self.impl), cast[ptr AsyncResult00](resu.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_file_open_readwrite_finish(self: ptr GFile00; res: ptr AsyncResult00;
    error: ptr ptr glib.Error = nil): ptr FileIOStream00 {.
    importc, libprag.}

proc openReadwriteFinish*(self: GFile; res: AsyncResult | SimpleAsyncResult | Task): FileIOStream =
  var gerror: ptr glib.Error
  let gobj = g_file_open_readwrite_finish(cast[ptr GFile00](self.impl), cast[ptr AsyncResult00](res.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_file_poll_mountable_finish(self: ptr GFile00; resu: ptr AsyncResult00;
    error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc pollMountableFinish*(self: GFile; resu: AsyncResult | SimpleAsyncResult | Task): bool =
  var gerror: ptr glib.Error
  let resul0 = g_file_poll_mountable_finish(cast[ptr GFile00](self.impl), cast[ptr AsyncResult00](resu.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_file_query_default_handler_finish(self: ptr GFile00; resu: ptr AsyncResult00;
    error: ptr ptr glib.Error = nil): ptr AppInfo00 {.
    importc, libprag.}

proc queryDefaultHandlerFinish*(self: GFile; resu: AsyncResult | SimpleAsyncResult | Task): AppInfo =
  var gerror: ptr glib.Error
  let gobj = g_file_query_default_handler_finish(cast[ptr GFile00](self.impl), cast[ptr AsyncResult00](resu.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_file_query_filesystem_info_finish(self: ptr GFile00; res: ptr AsyncResult00;
    error: ptr ptr glib.Error = nil): ptr FileInfo00 {.
    importc, libprag.}

proc queryFilesystemInfoFinish*(self: GFile; res: AsyncResult | SimpleAsyncResult | Task): FileInfo =
  var gerror: ptr glib.Error
  let gobj = g_file_query_filesystem_info_finish(cast[ptr GFile00](self.impl), cast[ptr AsyncResult00](res.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_file_query_info_finish(self: ptr GFile00; res: ptr AsyncResult00;
    error: ptr ptr glib.Error = nil): ptr FileInfo00 {.
    importc, libprag.}

proc queryInfoFinish*(self: GFile; res: AsyncResult | SimpleAsyncResult | Task): FileInfo =
  var gerror: ptr glib.Error
  let gobj = g_file_query_info_finish(cast[ptr GFile00](self.impl), cast[ptr AsyncResult00](res.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_file_replace_contents_finish(self: ptr GFile00; res: ptr AsyncResult00;
    newEtag: var cstring; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc replaceContentsFinish*(self: GFile; res: AsyncResult | SimpleAsyncResult | Task;
    newEtag: var string = cast[var string](nil)): bool =
  var gerror: ptr glib.Error
  var newEtag_00: cstring
  let resul0 = g_file_replace_contents_finish(cast[ptr GFile00](self.impl), cast[ptr AsyncResult00](res.impl), newEtag_00, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)
  if newEtag.addr != nil:
    newEtag = $(newEtag_00)

proc g_file_replace_finish(self: ptr GFile00; res: ptr AsyncResult00; error: ptr ptr glib.Error = nil): ptr FileOutputStream00 {.
    importc, libprag.}

proc replaceFinish*(self: GFile; res: AsyncResult | SimpleAsyncResult | Task): FileOutputStream =
  var gerror: ptr glib.Error
  let gobj = g_file_replace_finish(cast[ptr GFile00](self.impl), cast[ptr AsyncResult00](res.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_file_replace_readwrite_finish(self: ptr GFile00; res: ptr AsyncResult00;
    error: ptr ptr glib.Error = nil): ptr FileIOStream00 {.
    importc, libprag.}

proc replaceReadwriteFinish*(self: GFile; res: AsyncResult | SimpleAsyncResult | Task): FileIOStream =
  var gerror: ptr glib.Error
  let gobj = g_file_replace_readwrite_finish(cast[ptr GFile00](self.impl), cast[ptr AsyncResult00](res.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_file_set_attributes_finish(self: ptr GFile00; resu: ptr AsyncResult00;
    info: var ptr FileInfo00; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc setAttributesFinish*(self: GFile; resu: AsyncResult | SimpleAsyncResult | Task;
    info: var FileInfo): bool =
  var tmpoutgobjectarg: ptr FileInfo00
  var gerror: ptr glib.Error
  let resul0 = g_file_set_attributes_finish(cast[ptr GFile00](self.impl), cast[ptr AsyncResult00](resu.impl), tmpoutgobjectarg, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)
#  dothemagic(info
  let argqdata = g_object_get_qdata(tmpoutgobjectarg, Quark)
  if argqdata != nil:
    info = cast[type(info)](argqdata)
    assert(info.impl == tmpoutgobjectarg)
  else:
    fnew(info, gio.finalizeGObject)
    info.impl = tmpoutgobjectarg
    GC_ref(info)
    if g_object_is_floating(info.impl).int != 0:
      discard g_object_ref_sink(info.impl)
    g_object_add_toggle_ref(info.impl, toggleNotify, addr(info[]))
    g_object_unref(info.impl)
    assert(g_object_get_qdata(info.impl, Quark) == nil)
    g_object_set_qdata(info.impl, Quark, addr(info[]))


proc g_file_set_display_name_finish(self: ptr GFile00; res: ptr AsyncResult00;
    error: ptr ptr glib.Error = nil): ptr GFile00 {.
    importc, libprag.}

proc setDisplayNameFinish*(self: GFile; res: AsyncResult | SimpleAsyncResult | Task): GFile =
  var gerror: ptr glib.Error
  let gobj = g_file_set_display_name_finish(cast[ptr GFile00](self.impl), cast[ptr AsyncResult00](res.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_file_start_mountable_finish(self: ptr GFile00; resu: ptr AsyncResult00;
    error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc startMountableFinish*(self: GFile; resu: AsyncResult | SimpleAsyncResult | Task): bool =
  var gerror: ptr glib.Error
  let resul0 = g_file_start_mountable_finish(cast[ptr GFile00](self.impl), cast[ptr AsyncResult00](resu.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_file_stop_mountable_finish(self: ptr GFile00; resu: ptr AsyncResult00;
    error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc stopMountableFinish*(self: GFile; resu: AsyncResult | SimpleAsyncResult | Task): bool =
  var gerror: ptr glib.Error
  let resul0 = g_file_stop_mountable_finish(cast[ptr GFile00](self.impl), cast[ptr AsyncResult00](resu.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_file_trash_finish(self: ptr GFile00; resu: ptr AsyncResult00; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc trashFinish*(self: GFile; resu: AsyncResult | SimpleAsyncResult | Task): bool =
  var gerror: ptr glib.Error
  let resul0 = g_file_trash_finish(cast[ptr GFile00](self.impl), cast[ptr AsyncResult00](resu.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_file_unmount_mountable_finish(self: ptr GFile00; resu: ptr AsyncResult00;
    error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc unmountMountableFinish*(self: GFile; resu: AsyncResult | SimpleAsyncResult | Task): bool =
  var gerror: ptr glib.Error
  let resul0 = g_file_unmount_mountable_finish(cast[ptr GFile00](self.impl), cast[ptr AsyncResult00](resu.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_file_unmount_mountable_with_operation_finish(self: ptr GFile00; resu: ptr AsyncResult00;
    error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc unmountMountableWithOperationFinish*(self: GFile; resu: AsyncResult | SimpleAsyncResult | Task): bool =
  var gerror: ptr glib.Error
  let resul0 = g_file_unmount_mountable_with_operation_finish(cast[ptr GFile00](self.impl), cast[ptr AsyncResult00](resu.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_io_stream_splice_finish(resu: ptr AsyncResult00; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc spliceFinish*(resu: AsyncResult | SimpleAsyncResult | Task): bool =
  var gerror: ptr glib.Error
  let resul0 = g_io_stream_splice_finish(cast[ptr AsyncResult00](resu.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_io_stream_close_finish(self: ptr IOStream00; resu: ptr AsyncResult00;
    error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc closeFinish*(self: IOStream; resu: AsyncResult | SimpleAsyncResult | Task): bool =
  var gerror: ptr glib.Error
  let resul0 = g_io_stream_close_finish(cast[ptr IOStream00](self.impl), cast[ptr AsyncResult00](resu.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_file_io_stream_query_info_finish(self: ptr FileIOStream00; resu: ptr AsyncResult00;
    error: ptr ptr glib.Error = nil): ptr FileInfo00 {.
    importc, libprag.}

proc queryInfoFinish*(self: FileIOStream; resu: AsyncResult | SimpleAsyncResult | Task): FileInfo =
  var gerror: ptr glib.Error
  let gobj = g_file_io_stream_query_info_finish(cast[ptr FileIOStream00](self.impl), cast[ptr AsyncResult00](resu.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_output_stream_close_finish(self: ptr OutputStream00; resu: ptr AsyncResult00;
    error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc closeFinish*(self: OutputStream; resu: AsyncResult | SimpleAsyncResult | Task): bool =
  var gerror: ptr glib.Error
  let resul0 = g_output_stream_close_finish(cast[ptr OutputStream00](self.impl), cast[ptr AsyncResult00](resu.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_output_stream_flush_finish(self: ptr OutputStream00; resu: ptr AsyncResult00;
    error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc flushFinish*(self: OutputStream; resu: AsyncResult | SimpleAsyncResult | Task): bool =
  var gerror: ptr glib.Error
  let resul0 = g_output_stream_flush_finish(cast[ptr OutputStream00](self.impl), cast[ptr AsyncResult00](resu.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_output_stream_splice_finish(self: ptr OutputStream00; resu: ptr AsyncResult00;
    error: ptr ptr glib.Error = nil): int64 {.
    importc, libprag.}

proc spliceFinish*(self: OutputStream; resu: AsyncResult | SimpleAsyncResult | Task): int64 =
  var gerror: ptr glib.Error
  let resul0 = g_output_stream_splice_finish(cast[ptr OutputStream00](self.impl), cast[ptr AsyncResult00](resu.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = resul0

proc g_output_stream_write_all_finish(self: ptr OutputStream00; resu: ptr AsyncResult00;
    bytesWritten: var uint64; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc writeAllFinish*(self: OutputStream; resu: AsyncResult | SimpleAsyncResult | Task;
    bytesWritten: var uint64 = cast[var uint64](nil)): bool =
  var gerror: ptr glib.Error
  let resul0 = g_output_stream_write_all_finish(cast[ptr OutputStream00](self.impl), cast[ptr AsyncResult00](resu.impl), bytesWritten, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_output_stream_write_bytes_finish(self: ptr OutputStream00; resu: ptr AsyncResult00;
    error: ptr ptr glib.Error = nil): int64 {.
    importc, libprag.}

proc writeBytesFinish*(self: OutputStream; resu: AsyncResult | SimpleAsyncResult | Task): int64 =
  var gerror: ptr glib.Error
  let resul0 = g_output_stream_write_bytes_finish(cast[ptr OutputStream00](self.impl), cast[ptr AsyncResult00](resu.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = resul0

proc g_output_stream_write_finish(self: ptr OutputStream00; resu: ptr AsyncResult00;
    error: ptr ptr glib.Error = nil): int64 {.
    importc, libprag.}

proc writeFinish*(self: OutputStream; resu: AsyncResult | SimpleAsyncResult | Task): int64 =
  var gerror: ptr glib.Error
  let resul0 = g_output_stream_write_finish(cast[ptr OutputStream00](self.impl), cast[ptr AsyncResult00](resu.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = resul0

proc g_output_stream_writev_all_finish(self: ptr OutputStream00; resu: ptr AsyncResult00;
    bytesWritten: var uint64; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc writevAllFinish*(self: OutputStream; resu: AsyncResult | SimpleAsyncResult | Task;
    bytesWritten: var uint64 = cast[var uint64](nil)): bool =
  var gerror: ptr glib.Error
  let resul0 = g_output_stream_writev_all_finish(cast[ptr OutputStream00](self.impl), cast[ptr AsyncResult00](resu.impl), bytesWritten, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_output_stream_writev_finish(self: ptr OutputStream00; resu: ptr AsyncResult00;
    bytesWritten: var uint64; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc writevFinish*(self: OutputStream; resu: AsyncResult | SimpleAsyncResult | Task;
    bytesWritten: var uint64 = cast[var uint64](nil)): bool =
  var gerror: ptr glib.Error
  let resul0 = g_output_stream_writev_finish(cast[ptr OutputStream00](self.impl), cast[ptr AsyncResult00](resu.impl), bytesWritten, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_async_result_get_source_object(self: ptr AsyncResult00): ptr gobject.Object00 {.
    importc, libprag.}

proc getSourceObject*(self: AsyncResult | SimpleAsyncResult | Task): gobject.Object =
  let gobj = g_async_result_get_source_object(cast[ptr AsyncResult00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gobject.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc sourceObject*(self: AsyncResult | SimpleAsyncResult | Task): gobject.Object =
  let gobj = g_async_result_get_source_object(cast[ptr AsyncResult00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gobject.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_async_result_get_user_data(self: ptr AsyncResult00): pointer {.
    importc, libprag.}

proc getUserData*(self: AsyncResult | SimpleAsyncResult | Task): pointer =
  g_async_result_get_user_data(cast[ptr AsyncResult00](self.impl))

proc g_async_result_is_tagged(self: ptr AsyncResult00; sourceTag: pointer): gboolean {.
    importc, libprag.}

proc isTagged*(self: AsyncResult | SimpleAsyncResult | Task;
    sourceTag: pointer): bool =
  toBool(g_async_result_is_tagged(cast[ptr AsyncResult00](self.impl), sourceTag))

proc g_async_result_legacy_propagate_error(self: ptr AsyncResult00; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc legacyPropagateError*(self: AsyncResult | SimpleAsyncResult | Task): bool =
  var gerror: ptr glib.Error
  let resul0 = g_async_result_legacy_propagate_error(cast[ptr AsyncResult00](self.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_file_enumerator_close_finish(self: ptr FileEnumerator00; resu: ptr AsyncResult00;
    error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc closeFinish*(self: FileEnumerator; resu: AsyncResult | SimpleAsyncResult | Task): bool =
  var gerror: ptr glib.Error
  let resul0 = g_file_enumerator_close_finish(cast[ptr FileEnumerator00](self.impl), cast[ptr AsyncResult00](resu.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_file_enumerator_next_files_finish(self: ptr FileEnumerator00; resu: ptr AsyncResult00;
    error: ptr ptr glib.Error = nil): ptr glib.List {.
    importc, libprag.}

proc nextFilesFinish*(self: FileEnumerator; resu: AsyncResult | SimpleAsyncResult | Task): seq[FileInfo] =
  var gerror: ptr glib.Error
  let resul0 = g_file_enumerator_next_files_finish(cast[ptr FileEnumerator00](self.impl), cast[ptr AsyncResult00](resu.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = glistObjects2seq(FileInfo, resul0, true)
  g_list_free(resul0)

proc g_mount_eject_finish(self: ptr Mount00; resu: ptr AsyncResult00; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc ejectFinish*(self: Mount; resu: AsyncResult | SimpleAsyncResult | Task): bool =
  var gerror: ptr glib.Error
  let resul0 = g_mount_eject_finish(cast[ptr Mount00](self.impl), cast[ptr AsyncResult00](resu.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_mount_eject_with_operation_finish(self: ptr Mount00; resu: ptr AsyncResult00;
    error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc ejectWithOperationFinish*(self: Mount; resu: AsyncResult | SimpleAsyncResult | Task): bool =
  var gerror: ptr glib.Error
  let resul0 = g_mount_eject_with_operation_finish(cast[ptr Mount00](self.impl), cast[ptr AsyncResult00](resu.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_mount_guess_content_type_finish(self: ptr Mount00; resu: ptr AsyncResult00;
    error: ptr ptr glib.Error = nil): ptr cstring {.
    importc, libprag.}

proc guessContentTypeFinish*(self: Mount; resu: AsyncResult | SimpleAsyncResult | Task): seq[string] =
  var gerror: ptr glib.Error
  let resul0 = g_mount_guess_content_type_finish(cast[ptr Mount00](self.impl), cast[ptr AsyncResult00](resu.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = cstringArrayToSeq(resul0)

proc g_mount_remount_finish(self: ptr Mount00; resu: ptr AsyncResult00; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc remountFinish*(self: Mount; resu: AsyncResult | SimpleAsyncResult | Task): bool =
  var gerror: ptr glib.Error
  let resul0 = g_mount_remount_finish(cast[ptr Mount00](self.impl), cast[ptr AsyncResult00](resu.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_mount_unmount_finish(self: ptr Mount00; resu: ptr AsyncResult00; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc unmountFinish*(self: Mount; resu: AsyncResult | SimpleAsyncResult | Task): bool =
  var gerror: ptr glib.Error
  let resul0 = g_mount_unmount_finish(cast[ptr Mount00](self.impl), cast[ptr AsyncResult00](resu.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_mount_unmount_with_operation_finish(self: ptr Mount00; resu: ptr AsyncResult00;
    error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc unmountWithOperationFinish*(self: Mount; resu: AsyncResult | SimpleAsyncResult | Task): bool =
  var gerror: ptr glib.Error
  let resul0 = g_mount_unmount_with_operation_finish(cast[ptr Mount00](self.impl), cast[ptr AsyncResult00](resu.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_drive_eject_finish(self: ptr Drive00; resu: ptr AsyncResult00; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc ejectFinish*(self: Drive; resu: AsyncResult | SimpleAsyncResult | Task): bool =
  var gerror: ptr glib.Error
  let resul0 = g_drive_eject_finish(cast[ptr Drive00](self.impl), cast[ptr AsyncResult00](resu.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_drive_eject_with_operation_finish(self: ptr Drive00; resu: ptr AsyncResult00;
    error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc ejectWithOperationFinish*(self: Drive; resu: AsyncResult | SimpleAsyncResult | Task): bool =
  var gerror: ptr glib.Error
  let resul0 = g_drive_eject_with_operation_finish(cast[ptr Drive00](self.impl), cast[ptr AsyncResult00](resu.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_drive_poll_for_media_finish(self: ptr Drive00; resu: ptr AsyncResult00;
    error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc pollForMediaFinish*(self: Drive; resu: AsyncResult | SimpleAsyncResult | Task): bool =
  var gerror: ptr glib.Error
  let resul0 = g_drive_poll_for_media_finish(cast[ptr Drive00](self.impl), cast[ptr AsyncResult00](resu.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_drive_start_finish(self: ptr Drive00; resu: ptr AsyncResult00; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc startFinish*(self: Drive; resu: AsyncResult | SimpleAsyncResult | Task): bool =
  var gerror: ptr glib.Error
  let resul0 = g_drive_start_finish(cast[ptr Drive00](self.impl), cast[ptr AsyncResult00](resu.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_drive_stop_finish(self: ptr Drive00; resu: ptr AsyncResult00; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc stopFinish*(self: Drive; resu: AsyncResult | SimpleAsyncResult | Task): bool =
  var gerror: ptr glib.Error
  let resul0 = g_drive_stop_finish(cast[ptr Drive00](self.impl), cast[ptr AsyncResult00](resu.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_volume_eject_finish(self: ptr Volume00; resu: ptr AsyncResult00; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc ejectFinish*(self: Volume; resu: AsyncResult | SimpleAsyncResult | Task): bool =
  var gerror: ptr glib.Error
  let resul0 = g_volume_eject_finish(cast[ptr Volume00](self.impl), cast[ptr AsyncResult00](resu.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_volume_eject_with_operation_finish(self: ptr Volume00; resu: ptr AsyncResult00;
    error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc ejectWithOperationFinish*(self: Volume; resu: AsyncResult | SimpleAsyncResult | Task): bool =
  var gerror: ptr glib.Error
  let resul0 = g_volume_eject_with_operation_finish(cast[ptr Volume00](self.impl), cast[ptr AsyncResult00](resu.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_volume_mount_finish(self: ptr Volume00; resu: ptr AsyncResult00; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc mountFinish*(self: Volume; resu: AsyncResult | SimpleAsyncResult | Task): bool =
  var gerror: ptr glib.Error
  let resul0 = g_volume_mount_finish(cast[ptr Volume00](self.impl), cast[ptr AsyncResult00](resu.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_app_info_launch_default_for_uri_finish(resu: ptr AsyncResult00; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc launchDefaultForUriFinish*(resu: AsyncResult | SimpleAsyncResult | Task): bool =
  var gerror: ptr glib.Error
  let resul0 = g_app_info_launch_default_for_uri_finish(cast[ptr AsyncResult00](resu.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_app_info_launch_uris_finish(self: ptr AppInfo00; resu: ptr AsyncResult00;
    error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc launchUrisFinish*(self: AppInfo | DesktopAppInfo; resu: AsyncResult | SimpleAsyncResult | Task): bool =
  var gerror: ptr glib.Error
  let resul0 = g_app_info_launch_uris_finish(cast[ptr AppInfo00](self.impl), cast[ptr AsyncResult00](resu.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_file_output_stream_query_info_finish(self: ptr FileOutputStream00;
    resu: ptr AsyncResult00; error: ptr ptr glib.Error = nil): ptr FileInfo00 {.
    importc, libprag.}

proc queryInfoFinish*(self: FileOutputStream; resu: AsyncResult | SimpleAsyncResult | Task): FileInfo =
  var gerror: ptr glib.Error
  let gobj = g_file_output_stream_query_info_finish(cast[ptr FileOutputStream00](self.impl), cast[ptr AsyncResult00](resu.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_simple_async_result_is_valid(resu: ptr AsyncResult00; source: ptr gobject.Object00;
    sourceTag: pointer): gboolean {.
    importc, libprag.}

proc isValid*(resu: AsyncResult | SimpleAsyncResult | Task;
    source: gobject.Object = nil; sourceTag: pointer): bool =
  toBool(g_simple_async_result_is_valid(cast[ptr AsyncResult00](resu.impl), if source.isNil: nil else: cast[ptr gobject.Object00](source.impl), sourceTag))

type
  DBusConnection* = ref object of gobject.Object
  DBusConnection00* = object of gobject.Object00

proc g_dbus_connection_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(DBusConnection()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc scClosed*(self: DBusConnection;  p: proc (self: ptr DBusConnection00; remotePeerVanished: gboolean; error: ptr glib.Error; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "closed", cast[GCallback](p), xdata, nil, cf)

proc g_dbus_connection_new_finish(res: ptr AsyncResult00; error: ptr ptr glib.Error = nil): ptr DBusConnection00 {.
    importc, libprag.}

proc newDBusConnectionFinish*(res: AsyncResult | SimpleAsyncResult | Task): DBusConnection =
  var gerror: ptr glib.Error
  let gobj = g_dbus_connection_new_finish(cast[ptr AsyncResult00](res.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newDBusConnectionFinish*(tdesc: typedesc; res: AsyncResult | SimpleAsyncResult | Task): tdesc =
  var gerror: ptr glib.Error
  assert(result is DBusConnection)
  let gobj = g_dbus_connection_new_finish(cast[ptr AsyncResult00](res.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initDBusConnectionFinish*[T](result: var T; res: AsyncResult | SimpleAsyncResult | Task) {.deprecated.} =
  var gerror: ptr glib.Error
  assert(result is DBusConnection)
  let gobj = g_dbus_connection_new_finish(cast[ptr AsyncResult00](res.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_dbus_connection_new_for_address_finish(res: ptr AsyncResult00; error: ptr ptr glib.Error = nil): ptr DBusConnection00 {.
    importc, libprag.}

proc newDBusConnectionForAddressFinish*(res: AsyncResult | SimpleAsyncResult | Task): DBusConnection =
  var gerror: ptr glib.Error
  let gobj = g_dbus_connection_new_for_address_finish(cast[ptr AsyncResult00](res.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newDBusConnectionForAddressFinish*(tdesc: typedesc; res: AsyncResult | SimpleAsyncResult | Task): tdesc =
  var gerror: ptr glib.Error
  assert(result is DBusConnection)
  let gobj = g_dbus_connection_new_for_address_finish(cast[ptr AsyncResult00](res.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initDBusConnectionForAddressFinish*[T](result: var T; res: AsyncResult | SimpleAsyncResult | Task) {.deprecated.} =
  var gerror: ptr glib.Error
  assert(result is DBusConnection)
  let gobj = g_dbus_connection_new_for_address_finish(cast[ptr AsyncResult00](res.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_dbus_connection_call_finish(self: ptr DBusConnection00; res: ptr AsyncResult00;
    error: ptr ptr glib.Error = nil): ptr glib.Variant00 {.
    importc, libprag.}

proc callFinish*(self: DBusConnection; res: AsyncResult | SimpleAsyncResult | Task): glib.Variant =
  var gerror: ptr glib.Error
  let impl0 = g_dbus_connection_call_finish(cast[ptr DBusConnection00](self.impl), cast[ptr AsyncResult00](res.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  fnew(result, finalizerunref)
  result.impl = impl0

proc g_dbus_connection_close_finish(self: ptr DBusConnection00; res: ptr AsyncResult00;
    error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc closeFinish*(self: DBusConnection; res: AsyncResult | SimpleAsyncResult | Task): bool =
  var gerror: ptr glib.Error
  let resul0 = g_dbus_connection_close_finish(cast[ptr DBusConnection00](self.impl), cast[ptr AsyncResult00](res.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_dbus_connection_emit_signal(self: ptr DBusConnection00; destinationBusName: cstring;
    objectPath: cstring; interfaceName: cstring; signalName: cstring; parameters: ptr glib.Variant00;
    error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc emitSignal*(self: DBusConnection; destinationBusName: cstring = nil;
    objectPath: cstring; interfaceName: cstring; signalName: cstring; parameters: glib.Variant = nil): bool =
  var gerror: ptr glib.Error
  let resul0 = g_dbus_connection_emit_signal(cast[ptr DBusConnection00](self.impl), destinationBusName, objectPath, interfaceName, signalName, if parameters.isNil: nil else: cast[ptr glib.Variant00](parameters.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_dbus_connection_export_action_group(self: ptr DBusConnection00; objectPath: cstring;
    actionGroup: ptr ActionGroup00; error: ptr ptr glib.Error = nil): uint32 {.
    importc, libprag.}

proc exportActionGroup*(self: DBusConnection; objectPath: cstring;
    actionGroup: ActionGroup | GApplication | DBusActionGroup | SimpleActionGroup): int =
  var gerror: ptr glib.Error
  let resul0 = g_dbus_connection_export_action_group(cast[ptr DBusConnection00](self.impl), objectPath, cast[ptr ActionGroup00](actionGroup.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = int(resul0)

proc g_dbus_connection_flush_finish(self: ptr DBusConnection00; res: ptr AsyncResult00;
    error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc flushFinish*(self: DBusConnection; res: AsyncResult | SimpleAsyncResult | Task): bool =
  var gerror: ptr glib.Error
  let resul0 = g_dbus_connection_flush_finish(cast[ptr DBusConnection00](self.impl), cast[ptr AsyncResult00](res.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_dbus_connection_get_exit_on_close(self: ptr DBusConnection00): gboolean {.
    importc, libprag.}

proc getExitOnClose*(self: DBusConnection): bool =
  toBool(g_dbus_connection_get_exit_on_close(cast[ptr DBusConnection00](self.impl)))

proc exitOnClose*(self: DBusConnection): bool =
  toBool(g_dbus_connection_get_exit_on_close(cast[ptr DBusConnection00](self.impl)))

proc g_dbus_connection_get_guid(self: ptr DBusConnection00): cstring {.
    importc, libprag.}

proc getGuid*(self: DBusConnection): string =
  result = $g_dbus_connection_get_guid(cast[ptr DBusConnection00](self.impl))

proc guid*(self: DBusConnection): string =
  result = $g_dbus_connection_get_guid(cast[ptr DBusConnection00](self.impl))

proc g_dbus_connection_get_last_serial(self: ptr DBusConnection00): uint32 {.
    importc, libprag.}

proc getLastSerial*(self: DBusConnection): int =
  int(g_dbus_connection_get_last_serial(cast[ptr DBusConnection00](self.impl)))

proc lastSerial*(self: DBusConnection): int =
  int(g_dbus_connection_get_last_serial(cast[ptr DBusConnection00](self.impl)))

proc g_dbus_connection_get_stream(self: ptr DBusConnection00): ptr IOStream00 {.
    importc, libprag.}

proc getStream*(self: DBusConnection): IOStream =
  let gobj = g_dbus_connection_get_stream(cast[ptr DBusConnection00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc stream*(self: DBusConnection): IOStream =
  let gobj = g_dbus_connection_get_stream(cast[ptr DBusConnection00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_dbus_connection_get_unique_name(self: ptr DBusConnection00): cstring {.
    importc, libprag.}

proc getUniqueName*(self: DBusConnection): string =
  let resul0 = g_dbus_connection_get_unique_name(cast[ptr DBusConnection00](self.impl))
  if resul0.isNil:
    return
  result = $resul0

proc uniqueName*(self: DBusConnection): string =
  let resul0 = g_dbus_connection_get_unique_name(cast[ptr DBusConnection00](self.impl))
  if resul0.isNil:
    return
  result = $resul0

proc g_dbus_connection_is_closed(self: ptr DBusConnection00): gboolean {.
    importc, libprag.}

proc isClosed*(self: DBusConnection): bool =
  toBool(g_dbus_connection_is_closed(cast[ptr DBusConnection00](self.impl)))

proc g_dbus_connection_remove_filter(self: ptr DBusConnection00; filterId: uint32) {.
    importc, libprag.}

proc removeFilter*(self: DBusConnection; filterId: int) =
  g_dbus_connection_remove_filter(cast[ptr DBusConnection00](self.impl), uint32(filterId))

proc g_dbus_connection_set_exit_on_close(self: ptr DBusConnection00; exitOnClose: gboolean) {.
    importc, libprag.}

proc setExitOnClose*(self: DBusConnection; exitOnClose: bool = true) =
  g_dbus_connection_set_exit_on_close(cast[ptr DBusConnection00](self.impl), gboolean(exitOnClose))

proc `exitOnClose=`*(self: DBusConnection; exitOnClose: bool) =
  g_dbus_connection_set_exit_on_close(cast[ptr DBusConnection00](self.impl), gboolean(exitOnClose))

proc g_dbus_connection_signal_unsubscribe(self: ptr DBusConnection00; subscriptionId: uint32) {.
    importc, libprag.}

proc signalUnsubscribe*(self: DBusConnection; subscriptionId: int) =
  g_dbus_connection_signal_unsubscribe(cast[ptr DBusConnection00](self.impl), uint32(subscriptionId))

proc g_dbus_connection_start_message_processing(self: ptr DBusConnection00) {.
    importc, libprag.}

proc startMessageProcessing*(self: DBusConnection) =
  g_dbus_connection_start_message_processing(cast[ptr DBusConnection00](self.impl))

proc g_dbus_connection_unexport_action_group(self: ptr DBusConnection00;
    exportId: uint32) {.
    importc, libprag.}

proc unexportActionGroup*(self: DBusConnection; exportId: int) =
  g_dbus_connection_unexport_action_group(cast[ptr DBusConnection00](self.impl), uint32(exportId))

proc g_dbus_connection_unexport_menu_model(self: ptr DBusConnection00; exportId: uint32) {.
    importc, libprag.}

proc unexportMenuModel*(self: DBusConnection; exportId: int) =
  g_dbus_connection_unexport_menu_model(cast[ptr DBusConnection00](self.impl), uint32(exportId))

proc g_dbus_connection_unregister_object(self: ptr DBusConnection00; registrationId: uint32): gboolean {.
    importc, libprag.}

proc unregisterObject*(self: DBusConnection; registrationId: int): bool =
  toBool(g_dbus_connection_unregister_object(cast[ptr DBusConnection00](self.impl), uint32(registrationId)))

proc g_dbus_connection_unregister_subtree(self: ptr DBusConnection00; registrationId: uint32): gboolean {.
    importc, libprag.}

proc unregisterSubtree*(self: DBusConnection; registrationId: int): bool =
  toBool(g_dbus_connection_unregister_subtree(cast[ptr DBusConnection00](self.impl), uint32(registrationId)))

proc g_application_get_dbus_connection(self: ptr GApplication00): ptr DBusConnection00 {.
    importc, libprag.}

proc getDbusConnection*(self: GApplication): DBusConnection =
  let gobj = g_application_get_dbus_connection(cast[ptr GApplication00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc dbusConnection*(self: GApplication): DBusConnection =
  let gobj = g_application_get_dbus_connection(cast[ptr GApplication00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_dbus_action_group_get(connection: ptr DBusConnection00; busName: cstring;
    objectPath: cstring): ptr DBusActionGroup00 {.
    importc, libprag.}

proc getDBusActionGroup*(connection: DBusConnection; busName: cstring = nil;
    objectPath: cstring): DBusActionGroup =
  let gobj = g_dbus_action_group_get(cast[ptr DBusConnection00](connection.impl), busName, objectPath)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

type
  UnixFDList* = ref object of gobject.Object
  UnixFDList00* = object of gobject.Object00

proc g_unix_fd_list_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(UnixFDList()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc g_unix_fd_list_new(): ptr UnixFDList00 {.
    importc, libprag.}

proc newUnixFDList*(): UnixFDList =
  let gobj = g_unix_fd_list_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newUnixFDList*(tdesc: typedesc): tdesc =
  assert(result is UnixFDList)
  let gobj = g_unix_fd_list_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initUnixFDList*[T](result: var T) {.deprecated.} =
  assert(result is UnixFDList)
  let gobj = g_unix_fd_list_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_unix_fd_list_new_from_array(fds: ptr int32; nFds: int32): ptr UnixFDList00 {.
    importc, libprag.}

proc newUnixFDListFromArray*(fds: seq[int32]): UnixFDList =
  let nFds = int(fds.len)
  let gobj = g_unix_fd_list_new_from_array(cast[ptr int32](unsafeaddr(fds[0])), int32(nFds))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newUnixFDListFromArray*(tdesc: typedesc; fds: seq[int32]): tdesc =
  let nFds = int(fds.len)
  assert(result is UnixFDList)
  let gobj = g_unix_fd_list_new_from_array(cast[ptr int32](unsafeaddr(fds[0])), int32(nFds))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initUnixFDListFromArray*[T](result: var T; fds: seq[int32]) {.deprecated.} =
  let nFds = int(fds.len)
  assert(result is UnixFDList)
  let gobj = g_unix_fd_list_new_from_array(cast[ptr int32](unsafeaddr(fds[0])), int32(nFds))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_unix_fd_list_append(self: ptr UnixFDList00; fd: int32; error: ptr ptr glib.Error = nil): int32 {.
    importc, libprag.}

proc append*(self: UnixFDList; fd: int): int =
  var gerror: ptr glib.Error
  let resul0 = g_unix_fd_list_append(cast[ptr UnixFDList00](self.impl), int32(fd), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = int(resul0)

proc g_unix_fd_list_get(self: ptr UnixFDList00; index: int32; error: ptr ptr glib.Error = nil): int32 {.
    importc, libprag.}

proc getUnixFDList*(self: UnixFDList; index: int): int =
  var gerror: ptr glib.Error
  let resul0 = g_unix_fd_list_get(cast[ptr UnixFDList00](self.impl), int32(index), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = int(resul0)

proc g_unix_fd_list_get_length(self: ptr UnixFDList00): int32 {.
    importc, libprag.}

proc getLength*(self: UnixFDList): int =
  int(g_unix_fd_list_get_length(cast[ptr UnixFDList00](self.impl)))

proc length*(self: UnixFDList): int =
  int(g_unix_fd_list_get_length(cast[ptr UnixFDList00](self.impl)))

proc g_unix_fd_list_peek_fds(self: ptr UnixFDList00; length: var int32): ptr int32 {.
    importc, libprag.}

proc peekFds*(self: UnixFDList; length: var int = cast[var int](nil)): seq[int32] =
  var length_00: int32
  result = int32ArrayToSeq(g_unix_fd_list_peek_fds(cast[ptr UnixFDList00](self.impl), length_00), length.int)
  if length.addr != nil:
    length = int(length_00)

proc g_unix_fd_list_steal_fds(self: ptr UnixFDList00; length: var int32): ptr int32 {.
    importc, libprag.}

proc stealFds*(self: UnixFDList; length: var int = cast[var int](nil)): seq[int32] =
  var length_00: int32
  let resul0 = g_unix_fd_list_steal_fds(cast[ptr UnixFDList00](self.impl), length_00)
  result = int32ArrayToSeq(resul0, length.int)
  cogfree(resul0)
  if length.addr != nil:
    length = int(length_00)

proc g_dbus_connection_call_with_unix_fd_list_finish(self: ptr DBusConnection00;
    outFdList: var ptr UnixFDList00; res: ptr AsyncResult00; error: ptr ptr glib.Error = nil): ptr glib.Variant00 {.
    importc, libprag.}

proc callWithUnixFdListFinish*(self: DBusConnection;
    outFdList: var UnixFDList = cast[var UnixFDList](nil); res: AsyncResult | SimpleAsyncResult | Task): glib.Variant =
  var tmpoutgobjectarg: ptr UnixFDList00
  var gerror: ptr glib.Error
  let impl0 = g_dbus_connection_call_with_unix_fd_list_finish(cast[ptr DBusConnection00](self.impl), cast[var ptr UnixFDList00](if addr(outFdList) == nil: nil else: addr tmpoutgobjectarg), cast[ptr AsyncResult00](res.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  fnew(result, finalizerunref)
  result.impl = impl0
#  dothemagic(outFdList
  if addr(outFdList) != nil:
    outFdList = nil

  if tmpoutgobjectarg != nil:
    let argqdata = g_object_get_qdata(tmpoutgobjectarg, Quark)
    if argqdata != nil:
      outFdList = cast[type(outFdList)](argqdata)
      assert(outFdList.impl == tmpoutgobjectarg)
    else:
      fnew(outFdList, gio.finalizeGObject)
      outFdList.impl = tmpoutgobjectarg
      GC_ref(outFdList)
      if g_object_is_floating(outFdList.impl).int != 0:
        discard g_object_ref_sink(outFdList.impl)
      g_object_add_toggle_ref(outFdList.impl, toggleNotify, addr(outFdList[]))
      g_object_unref(outFdList.impl)
      assert(g_object_get_qdata(outFdList.impl, Quark) == nil)
      g_object_set_qdata(outFdList.impl, Quark, addr(outFdList[]))


type
  DBusCallFlag* {.size: sizeof(cint), pure.} = enum
    noAutoStart = 0
    allowInteractiveAuthorization = 1

  DBusCallFlags* {.size: sizeof(cint).} = set[DBusCallFlag]

const
  DBusCallFlagsNone* = DBusCallFlags({})
proc none*(t: typedesc[DBusCallFlags]): DBusCallFlags = DBusCallFlags({})

type
  MenuModel* = ref object of gobject.Object
  MenuModel00* = object of gobject.Object00

proc g_menu_model_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(MenuModel()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc scItemsChanged*(self: MenuModel;  p: proc (self: ptr MenuModel00; position: int32; removed: int32; added: int32; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "items-changed", cast[GCallback](p), xdata, nil, cf)

proc g_menu_model_get_item_attribute_value(self: ptr MenuModel00; itemIndex: int32;
    attribute: cstring; expectedType: ptr glib.VariantType00): ptr glib.Variant00 {.
    importc, libprag.}

proc getItemAttributeValue*(self: MenuModel; itemIndex: int;
    attribute: cstring; expectedType: glib.VariantType = nil): glib.Variant =
  fnew(result, finalizerunref)
  result.impl = g_menu_model_get_item_attribute_value(cast[ptr MenuModel00](self.impl), int32(itemIndex), attribute, if expectedType.isNil: nil else: cast[ptr glib.VariantType00](expectedType.impl))

proc g_menu_model_get_item_link(self: ptr MenuModel00; itemIndex: int32;
    link: cstring): ptr MenuModel00 {.
    importc, libprag.}

proc getItemLink*(self: MenuModel; itemIndex: int; link: cstring): MenuModel =
  let gobj = g_menu_model_get_item_link(cast[ptr MenuModel00](self.impl), int32(itemIndex), link)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_menu_model_get_n_items(self: ptr MenuModel00): int32 {.
    importc, libprag.}

proc getNItems*(self: MenuModel): int =
  int(g_menu_model_get_n_items(cast[ptr MenuModel00](self.impl)))

proc nItems*(self: MenuModel): int =
  int(g_menu_model_get_n_items(cast[ptr MenuModel00](self.impl)))

proc g_menu_model_is_mutable(self: ptr MenuModel00): gboolean {.
    importc, libprag.}

proc isMutable*(self: MenuModel): bool =
  toBool(g_menu_model_is_mutable(cast[ptr MenuModel00](self.impl)))

proc g_menu_model_items_changed(self: ptr MenuModel00; position: int32; removed: int32;
    added: int32) {.
    importc, libprag.}

proc itemsChanged*(self: MenuModel; position: int; removed: int;
    added: int) =
  g_menu_model_items_changed(cast[ptr MenuModel00](self.impl), int32(position), int32(removed), int32(added))

proc g_dbus_connection_export_menu_model(self: ptr DBusConnection00; objectPath: cstring;
    menu: ptr MenuModel00; error: ptr ptr glib.Error = nil): uint32 {.
    importc, libprag.}

proc exportMenuModel*(self: DBusConnection; objectPath: cstring;
    menu: MenuModel): int =
  var gerror: ptr glib.Error
  let resul0 = g_dbus_connection_export_menu_model(cast[ptr DBusConnection00](self.impl), objectPath, cast[ptr MenuModel00](menu.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = int(resul0)

type
  MenuAttributeIter* = ref object of gobject.Object
  MenuAttributeIter00* = object of gobject.Object00

proc g_menu_attribute_iter_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(MenuAttributeIter()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc g_menu_attribute_iter_get_name(self: ptr MenuAttributeIter00): cstring {.
    importc, libprag.}

proc getName*(self: MenuAttributeIter): string =
  result = $g_menu_attribute_iter_get_name(cast[ptr MenuAttributeIter00](self.impl))

proc name*(self: MenuAttributeIter): string =
  result = $g_menu_attribute_iter_get_name(cast[ptr MenuAttributeIter00](self.impl))

proc g_menu_attribute_iter_get_next(self: ptr MenuAttributeIter00; outName: var cstring;
    value: var ptr glib.Variant00): gboolean {.
    importc, libprag.}

proc getNext*(self: MenuAttributeIter; outName: var string = cast[var string](nil);
    value: var glib.Variant = cast[var glib.Variant](nil)): bool =
  if addr(value) != nil:
    fnew(value, finalizerunref)
  var outName_00: cstring
  result = toBool(g_menu_attribute_iter_get_next(cast[ptr MenuAttributeIter00](self.impl), outName_00, cast[var ptr glib.Variant00](if addr(value) == nil: nil else: addr value.impl)))
  if outName.addr != nil:
    outName = $(outName_00)

proc g_menu_attribute_iter_get_value(self: ptr MenuAttributeIter00): ptr glib.Variant00 {.
    importc, libprag.}

proc getValue*(self: MenuAttributeIter): glib.Variant =
  fnew(result, finalizerunref)
  result.impl = g_menu_attribute_iter_get_value(cast[ptr MenuAttributeIter00](self.impl))

proc value*(self: MenuAttributeIter): glib.Variant =
  fnew(result, finalizerunref)
  result.impl = g_menu_attribute_iter_get_value(cast[ptr MenuAttributeIter00](self.impl))

proc g_menu_attribute_iter_next(self: ptr MenuAttributeIter00): gboolean {.
    importc, libprag.}

proc next*(self: MenuAttributeIter): bool =
  toBool(g_menu_attribute_iter_next(cast[ptr MenuAttributeIter00](self.impl)))

proc g_menu_model_iterate_item_attributes(self: ptr MenuModel00; itemIndex: int32): ptr MenuAttributeIter00 {.
    importc, libprag.}

proc iterateItemAttributes*(self: MenuModel; itemIndex: int): MenuAttributeIter =
  let gobj = g_menu_model_iterate_item_attributes(cast[ptr MenuModel00](self.impl), int32(itemIndex))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

type
  MenuLinkIter* = ref object of gobject.Object
  MenuLinkIter00* = object of gobject.Object00

proc g_menu_link_iter_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(MenuLinkIter()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc g_menu_link_iter_get_name(self: ptr MenuLinkIter00): cstring {.
    importc, libprag.}

proc getName*(self: MenuLinkIter): string =
  result = $g_menu_link_iter_get_name(cast[ptr MenuLinkIter00](self.impl))

proc name*(self: MenuLinkIter): string =
  result = $g_menu_link_iter_get_name(cast[ptr MenuLinkIter00](self.impl))

proc g_menu_link_iter_get_next(self: ptr MenuLinkIter00; outLink: var cstring;
    value: var ptr MenuModel00): gboolean {.
    importc, libprag.}

proc getNext*(self: MenuLinkIter; outLink: var string = cast[var string](nil);
    value: var MenuModel = cast[var MenuModel](nil)): bool =
  var tmpoutgobjectarg: ptr MenuModel00
  var outLink_00: cstring
  result = toBool(g_menu_link_iter_get_next(cast[ptr MenuLinkIter00](self.impl), outLink_00, cast[var ptr MenuModel00](if addr(value) == nil: nil else: addr tmpoutgobjectarg)))
  if outLink.addr != nil:
    outLink = $(outLink_00)
#  dothemagic(value
  if addr(value) != nil:
    value = nil

  if tmpoutgobjectarg != nil:
    let argqdata = g_object_get_qdata(tmpoutgobjectarg, Quark)
    if argqdata != nil:
      value = cast[type(value)](argqdata)
      assert(value.impl == tmpoutgobjectarg)
    else:
      fnew(value, gio.finalizeGObject)
      value.impl = tmpoutgobjectarg
      GC_ref(value)
      if g_object_is_floating(value.impl).int != 0:
        discard g_object_ref_sink(value.impl)
      g_object_add_toggle_ref(value.impl, toggleNotify, addr(value[]))
      g_object_unref(value.impl)
      assert(g_object_get_qdata(value.impl, Quark) == nil)
      g_object_set_qdata(value.impl, Quark, addr(value[]))


proc g_menu_link_iter_get_value(self: ptr MenuLinkIter00): ptr MenuModel00 {.
    importc, libprag.}

proc getValue*(self: MenuLinkIter): MenuModel =
  let gobj = g_menu_link_iter_get_value(cast[ptr MenuLinkIter00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc value*(self: MenuLinkIter): MenuModel =
  let gobj = g_menu_link_iter_get_value(cast[ptr MenuLinkIter00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_menu_link_iter_next(self: ptr MenuLinkIter00): gboolean {.
    importc, libprag.}

proc next*(self: MenuLinkIter): bool =
  toBool(g_menu_link_iter_next(cast[ptr MenuLinkIter00](self.impl)))

proc g_menu_model_iterate_item_links(self: ptr MenuModel00; itemIndex: int32): ptr MenuLinkIter00 {.
    importc, libprag.}

proc iterateItemLinks*(self: MenuModel; itemIndex: int): MenuLinkIter =
  let gobj = g_menu_model_iterate_item_links(cast[ptr MenuModel00](self.impl), int32(itemIndex))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

type
  DBusCapabilityFlag* {.size: sizeof(cint), pure.} = enum
    unixFdPassing = 0

  DBusCapabilityFlags* {.size: sizeof(cint).} = set[DBusCapabilityFlag]

const
  DBusCapabilityFlagsNone* = DBusCapabilityFlags({})
proc none*(t: typedesc[DBusCapabilityFlags]): DBusCapabilityFlags = DBusCapabilityFlags({})

proc g_dbus_connection_get_capabilities(self: ptr DBusConnection00): DBusCapabilityFlags {.
    importc, libprag.}

proc getCapabilities*(self: DBusConnection): DBusCapabilityFlags =
  g_dbus_connection_get_capabilities(cast[ptr DBusConnection00](self.impl))

proc capabilities*(self: DBusConnection): DBusCapabilityFlags =
  g_dbus_connection_get_capabilities(cast[ptr DBusConnection00](self.impl))

type
  DBusConnectionFlag* {.size: sizeof(cint), pure.} = enum
    authenticationClient = 0
    authenticationServer = 1
    authenticationAllowAnonymous = 2
    messageBusConnection = 3
    delayMessageProcessing = 4

  DBusConnectionFlags* {.size: sizeof(cint).} = set[DBusConnectionFlag]

const
  DBusConnectionFlagsNone* = DBusConnectionFlags({})
proc none*(t: typedesc[DBusConnectionFlags]): DBusConnectionFlags = DBusConnectionFlags({})

proc g_dbus_connection_get_flags(self: ptr DBusConnection00): DBusConnectionFlags {.
    importc, libprag.}

proc getFlags*(self: DBusConnection): DBusConnectionFlags =
  g_dbus_connection_get_flags(cast[ptr DBusConnection00](self.impl))

proc flags*(self: DBusConnection): DBusConnectionFlags =
  g_dbus_connection_get_flags(cast[ptr DBusConnection00](self.impl))

type
  Credentials* = ref object of gobject.Object
  Credentials00* = object of gobject.Object00

proc g_credentials_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(Credentials()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc g_credentials_new(): ptr Credentials00 {.
    importc, libprag.}

proc newCredentials*(): Credentials =
  let gobj = g_credentials_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newCredentials*(tdesc: typedesc): tdesc =
  assert(result is Credentials)
  let gobj = g_credentials_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initCredentials*[T](result: var T) {.deprecated.} =
  assert(result is Credentials)
  let gobj = g_credentials_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_credentials_get_unix_pid(self: ptr Credentials00; error: ptr ptr glib.Error = nil): int32 {.
    importc, libprag.}

proc getUnixPid*(self: Credentials): int =
  var gerror: ptr glib.Error
  let resul0 = g_credentials_get_unix_pid(cast[ptr Credentials00](self.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = int(resul0)

proc unixPid*(self: Credentials): int =
  var gerror: ptr glib.Error
  let resul0 = g_credentials_get_unix_pid(cast[ptr Credentials00](self.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = int(resul0)

proc g_credentials_get_unix_user(self: ptr Credentials00; error: ptr ptr glib.Error = nil): uint32 {.
    importc, libprag.}

proc getUnixUser*(self: Credentials): int =
  var gerror: ptr glib.Error
  let resul0 = g_credentials_get_unix_user(cast[ptr Credentials00](self.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = int(resul0)

proc unixUser*(self: Credentials): int =
  var gerror: ptr glib.Error
  let resul0 = g_credentials_get_unix_user(cast[ptr Credentials00](self.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = int(resul0)

proc g_credentials_is_same_user(self: ptr Credentials00; otherCredentials: ptr Credentials00;
    error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc isSameUser*(self: Credentials; otherCredentials: Credentials): bool =
  var gerror: ptr glib.Error
  let resul0 = g_credentials_is_same_user(cast[ptr Credentials00](self.impl), cast[ptr Credentials00](otherCredentials.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_credentials_set_unix_user(self: ptr Credentials00; uid: uint32; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc setUnixUser*(self: Credentials; uid: int): bool =
  var gerror: ptr glib.Error
  let resul0 = g_credentials_set_unix_user(cast[ptr Credentials00](self.impl), uint32(uid), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_credentials_to_string(self: ptr Credentials00): cstring {.
    importc, libprag.}

proc toString*(self: Credentials): string =
  let resul0 = g_credentials_to_string(cast[ptr Credentials00](self.impl))
  result = $resul0
  cogfree(resul0)

type
  DBusAuthObserver* = ref object of gobject.Object
  DBusAuthObserver00* = object of gobject.Object00

proc g_dbus_auth_observer_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(DBusAuthObserver()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc scAllowMechanism*(self: DBusAuthObserver;  p: proc (self: ptr DBusAuthObserver00; mechanism: cstring; xdata: pointer): gboolean {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "allow-mechanism", cast[GCallback](p), xdata, nil, cf)

proc scAuthorizeAuthenticatedPeer*(self: DBusAuthObserver;  p: proc (self: ptr DBusAuthObserver00; stream: ptr IOStream00; credentials: ptr Credentials00; xdata: pointer): gboolean {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "authorize-authenticated-peer", cast[GCallback](p), xdata, nil, cf)

proc g_dbus_auth_observer_new(): ptr DBusAuthObserver00 {.
    importc, libprag.}

proc newDBusAuthObserver*(): DBusAuthObserver =
  let gobj = g_dbus_auth_observer_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newDBusAuthObserver*(tdesc: typedesc): tdesc =
  assert(result is DBusAuthObserver)
  let gobj = g_dbus_auth_observer_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initDBusAuthObserver*[T](result: var T) {.deprecated.} =
  assert(result is DBusAuthObserver)
  let gobj = g_dbus_auth_observer_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_dbus_auth_observer_allow_mechanism(self: ptr DBusAuthObserver00; mechanism: cstring): gboolean {.
    importc, libprag.}

proc allowMechanism*(self: DBusAuthObserver; mechanism: cstring): bool =
  toBool(g_dbus_auth_observer_allow_mechanism(cast[ptr DBusAuthObserver00](self.impl), mechanism))

proc g_dbus_auth_observer_authorize_authenticated_peer(self: ptr DBusAuthObserver00;
    stream: ptr IOStream00; credentials: ptr Credentials00): gboolean {.
    importc, libprag.}

proc authorizeAuthenticatedPeer*(self: DBusAuthObserver;
    stream: IOStream; credentials: Credentials = nil): bool =
  toBool(g_dbus_auth_observer_authorize_authenticated_peer(cast[ptr DBusAuthObserver00](self.impl), cast[ptr IOStream00](stream.impl), if credentials.isNil: nil else: cast[ptr Credentials00](credentials.impl)))

proc g_dbus_connection_get_peer_credentials(self: ptr DBusConnection00): ptr Credentials00 {.
    importc, libprag.}

proc getPeerCredentials*(self: DBusConnection): Credentials =
  let gobj = g_dbus_connection_get_peer_credentials(cast[ptr DBusConnection00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc peerCredentials*(self: DBusConnection): Credentials =
  let gobj = g_dbus_connection_get_peer_credentials(cast[ptr DBusConnection00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

type
  CredentialsType* {.size: sizeof(cint), pure.} = enum
    invalid = 0
    linuxUcred = 1
    freebsdCmsgcred = 2
    openbsdSockpeercred = 3
    solarisUcred = 4
    netbsdUnpcbid = 5
    appleXucred = 6

proc g_credentials_set_native(self: ptr Credentials00; nativeType: CredentialsType;
    native: pointer) {.
    importc, libprag.}

proc setNative*(self: Credentials; nativeType: CredentialsType;
    native: pointer) =
  g_credentials_set_native(cast[ptr Credentials00](self.impl), nativeType, native)

type
  DBusInterfaceInfo00* {.pure.} = object
  DBusInterfaceInfo* = ref object
    impl*: ptr DBusInterfaceInfo00
    ignoreFinalizer*: bool

proc g_dbus_interface_info_get_type*(): GType {.importc, libprag.}

proc gBoxedFreeGDBusInterfaceInfo*(self: DBusInterfaceInfo) =
  if not self.ignoreFinalizer:
    boxedFree(g_dbus_interface_info_get_type(), cast[ptr DBusInterfaceInfo00](self.impl))

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(DBusInterfaceInfo()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    if not self.ignoreFinalizer and self.impl != nil:
      boxedFree(g_dbus_interface_info_get_type(), cast[ptr DBusInterfaceInfo00](self.impl))
      self.impl = nil

proc newWithFinalizer*(x: var DBusInterfaceInfo) =
  when defined(gcDestructors):
    new(x)
  else:
    new(x, gBoxedFreeGDBusInterfaceInfo)

proc g_dbus_interface_info_unref(self: ptr DBusInterfaceInfo00) {.
    importc, libprag.}

proc unref*(self: DBusInterfaceInfo) =
  g_dbus_interface_info_unref(cast[ptr DBusInterfaceInfo00](self.impl))

proc finalizerunref*(self: DBusInterfaceInfo) =
  if not self.ignoreFinalizer:
    g_dbus_interface_info_unref(cast[ptr DBusInterfaceInfo00](self.impl))

proc g_dbus_interface_info_cache_release(self: ptr DBusInterfaceInfo00) {.
    importc, libprag.}

proc cacheRelease*(self: DBusInterfaceInfo) =
  g_dbus_interface_info_cache_release(cast[ptr DBusInterfaceInfo00](self.impl))

proc g_dbus_interface_info_generate_xml(self: ptr DBusInterfaceInfo00; indent: uint32;
    stringBuilder: glib.String) {.
    importc, libprag.}

proc generateXml*(self: DBusInterfaceInfo; indent: int;
    stringBuilder: glib.String) =
  g_dbus_interface_info_generate_xml(cast[ptr DBusInterfaceInfo00](self.impl), uint32(indent), stringBuilder)

proc g_dbus_interface_info_ref(self: ptr DBusInterfaceInfo00): ptr DBusInterfaceInfo00 {.
    importc, libprag.}

proc `ref`*(self: DBusInterfaceInfo): DBusInterfaceInfo =
  fnew(result, gBoxedFreeGDBusInterfaceInfo)
  result.impl = g_dbus_interface_info_ref(cast[ptr DBusInterfaceInfo00](self.impl))

proc g_dbus_interface_info_cache_build(self: ptr DBusInterfaceInfo00) {.
    importc, libprag.}

proc cacheBuild*(self: DBusInterfaceInfo) =
  g_dbus_interface_info_cache_build(cast[ptr DBusInterfaceInfo00](self.impl))

proc g_dbus_connection_register_object_with_closures(self: ptr DBusConnection00;
    objectPath: cstring; interfaceInfo: ptr DBusInterfaceInfo00; methodCallClosure: ptr gobject.Closure00;
    getPropertyClosure: ptr gobject.Closure00; setPropertyClosure: ptr gobject.Closure00;
    error: ptr ptr glib.Error = nil): uint32 {.
    importc, libprag.}

proc registerObject*(self: DBusConnection;
    objectPath: cstring; interfaceInfo: DBusInterfaceInfo; methodCallClosure: gobject.Closure = nil;
    getPropertyClosure: gobject.Closure = nil; setPropertyClosure: gobject.Closure = nil): int =
  var gerror: ptr glib.Error
  let resul0 = g_dbus_connection_register_object_with_closures(cast[ptr DBusConnection00](self.impl), objectPath, cast[ptr DBusInterfaceInfo00](interfaceInfo.impl), if methodCallClosure.isNil: nil else: cast[ptr gobject.Closure00](methodCallClosure.impl), if getPropertyClosure.isNil: nil else: cast[ptr gobject.Closure00](getPropertyClosure.impl), if setPropertyClosure.isNil: nil else: cast[ptr gobject.Closure00](setPropertyClosure.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = int(resul0)

type
  DBusMethodInfo00* {.pure.} = object
  DBusMethodInfo* = ref object
    impl*: ptr DBusMethodInfo00
    ignoreFinalizer*: bool

proc g_dbus_method_info_get_type*(): GType {.importc, libprag.}

proc gBoxedFreeGDBusMethodInfo*(self: DBusMethodInfo) =
  if not self.ignoreFinalizer:
    boxedFree(g_dbus_method_info_get_type(), cast[ptr DBusMethodInfo00](self.impl))

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(DBusMethodInfo()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    if not self.ignoreFinalizer and self.impl != nil:
      boxedFree(g_dbus_method_info_get_type(), cast[ptr DBusMethodInfo00](self.impl))
      self.impl = nil

proc newWithFinalizer*(x: var DBusMethodInfo) =
  when defined(gcDestructors):
    new(x)
  else:
    new(x, gBoxedFreeGDBusMethodInfo)

proc g_dbus_method_info_unref(self: ptr DBusMethodInfo00) {.
    importc, libprag.}

proc unref*(self: DBusMethodInfo) =
  g_dbus_method_info_unref(cast[ptr DBusMethodInfo00](self.impl))

proc finalizerunref*(self: DBusMethodInfo) =
  if not self.ignoreFinalizer:
    g_dbus_method_info_unref(cast[ptr DBusMethodInfo00](self.impl))

proc g_dbus_method_info_ref(self: ptr DBusMethodInfo00): ptr DBusMethodInfo00 {.
    importc, libprag.}

proc `ref`*(self: DBusMethodInfo): DBusMethodInfo =
  fnew(result, gBoxedFreeGDBusMethodInfo)
  result.impl = g_dbus_method_info_ref(cast[ptr DBusMethodInfo00](self.impl))

proc g_dbus_interface_info_lookup_method(self: ptr DBusInterfaceInfo00; name: cstring): ptr DBusMethodInfo00 {.
    importc, libprag.}

proc lookupMethod*(self: DBusInterfaceInfo; name: cstring): DBusMethodInfo =
  fnew(result, gBoxedFreeGDBusMethodInfo)
  result.impl = g_dbus_interface_info_lookup_method(cast[ptr DBusInterfaceInfo00](self.impl), name)
  result.impl = cast[typeof(result.impl)](g_boxed_copy(g_dbus_method_info_get_type(), result.impl))

type
  DBusPropertyInfo00* {.pure.} = object
  DBusPropertyInfo* = ref object
    impl*: ptr DBusPropertyInfo00
    ignoreFinalizer*: bool

proc g_dbus_property_info_get_type*(): GType {.importc, libprag.}

proc gBoxedFreeGDBusPropertyInfo*(self: DBusPropertyInfo) =
  if not self.ignoreFinalizer:
    boxedFree(g_dbus_property_info_get_type(), cast[ptr DBusPropertyInfo00](self.impl))

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(DBusPropertyInfo()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    if not self.ignoreFinalizer and self.impl != nil:
      boxedFree(g_dbus_property_info_get_type(), cast[ptr DBusPropertyInfo00](self.impl))
      self.impl = nil

proc newWithFinalizer*(x: var DBusPropertyInfo) =
  when defined(gcDestructors):
    new(x)
  else:
    new(x, gBoxedFreeGDBusPropertyInfo)

proc g_dbus_property_info_unref(self: ptr DBusPropertyInfo00) {.
    importc, libprag.}

proc unref*(self: DBusPropertyInfo) =
  g_dbus_property_info_unref(cast[ptr DBusPropertyInfo00](self.impl))

proc finalizerunref*(self: DBusPropertyInfo) =
  if not self.ignoreFinalizer:
    g_dbus_property_info_unref(cast[ptr DBusPropertyInfo00](self.impl))

proc g_dbus_property_info_ref(self: ptr DBusPropertyInfo00): ptr DBusPropertyInfo00 {.
    importc, libprag.}

proc `ref`*(self: DBusPropertyInfo): DBusPropertyInfo =
  fnew(result, gBoxedFreeGDBusPropertyInfo)
  result.impl = g_dbus_property_info_ref(cast[ptr DBusPropertyInfo00](self.impl))

proc g_dbus_interface_info_lookup_property(self: ptr DBusInterfaceInfo00;
    name: cstring): ptr DBusPropertyInfo00 {.
    importc, libprag.}

proc lookupProperty*(self: DBusInterfaceInfo; name: cstring): DBusPropertyInfo =
  fnew(result, gBoxedFreeGDBusPropertyInfo)
  result.impl = g_dbus_interface_info_lookup_property(cast[ptr DBusInterfaceInfo00](self.impl), name)
  result.impl = cast[typeof(result.impl)](g_boxed_copy(g_dbus_property_info_get_type(), result.impl))

type
  DBusSignalInfo00* {.pure.} = object
  DBusSignalInfo* = ref object
    impl*: ptr DBusSignalInfo00
    ignoreFinalizer*: bool

proc g_dbus_signal_info_get_type*(): GType {.importc, libprag.}

proc gBoxedFreeGDBusSignalInfo*(self: DBusSignalInfo) =
  if not self.ignoreFinalizer:
    boxedFree(g_dbus_signal_info_get_type(), cast[ptr DBusSignalInfo00](self.impl))

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(DBusSignalInfo()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    if not self.ignoreFinalizer and self.impl != nil:
      boxedFree(g_dbus_signal_info_get_type(), cast[ptr DBusSignalInfo00](self.impl))
      self.impl = nil

proc newWithFinalizer*(x: var DBusSignalInfo) =
  when defined(gcDestructors):
    new(x)
  else:
    new(x, gBoxedFreeGDBusSignalInfo)

proc g_dbus_signal_info_unref(self: ptr DBusSignalInfo00) {.
    importc, libprag.}

proc unref*(self: DBusSignalInfo) =
  g_dbus_signal_info_unref(cast[ptr DBusSignalInfo00](self.impl))

proc finalizerunref*(self: DBusSignalInfo) =
  if not self.ignoreFinalizer:
    g_dbus_signal_info_unref(cast[ptr DBusSignalInfo00](self.impl))

proc g_dbus_signal_info_ref(self: ptr DBusSignalInfo00): ptr DBusSignalInfo00 {.
    importc, libprag.}

proc `ref`*(self: DBusSignalInfo): DBusSignalInfo =
  fnew(result, gBoxedFreeGDBusSignalInfo)
  result.impl = g_dbus_signal_info_ref(cast[ptr DBusSignalInfo00](self.impl))

proc g_dbus_interface_info_lookup_signal(self: ptr DBusInterfaceInfo00; name: cstring): ptr DBusSignalInfo00 {.
    importc, libprag.}

proc lookupSignal*(self: DBusInterfaceInfo; name: cstring): DBusSignalInfo =
  fnew(result, gBoxedFreeGDBusSignalInfo)
  result.impl = g_dbus_interface_info_lookup_signal(cast[ptr DBusInterfaceInfo00](self.impl), name)
  result.impl = cast[typeof(result.impl)](g_boxed_copy(g_dbus_signal_info_get_type(), result.impl))

type
  DBusSubtreeVTable00* {.pure.} = object
  DBusSubtreeVTable* = ref object
    impl*: ptr DBusSubtreeVTable00
    ignoreFinalizer*: bool

type
  DBusSubtreeFlag* {.size: sizeof(cint), pure.} = enum
    dispatchToUnenumeratedNodes = 0

  DBusSubtreeFlags* {.size: sizeof(cint).} = set[DBusSubtreeFlag]

const
  DBusSubtreeFlagsNone* = DBusSubtreeFlags({})
proc none*(t: typedesc[DBusSubtreeFlags]): DBusSubtreeFlags = DBusSubtreeFlags({})

proc g_dbus_connection_register_subtree(self: ptr DBusConnection00; objectPath: cstring;
    vtable: ptr DBusSubtreeVTable00; flags: DBusSubtreeFlags; userData: pointer;
    userDataFreeFunc: DestroyNotify; error: ptr ptr glib.Error = nil): uint32 {.
    importc, libprag.}

proc registerSubtree*(self: DBusConnection; objectPath: cstring;
    vtable: DBusSubtreeVTable; flags: DBusSubtreeFlags; userData: pointer;
    userDataFreeFunc: DestroyNotify): int =
  var gerror: ptr glib.Error
  let resul0 = g_dbus_connection_register_subtree(cast[ptr DBusConnection00](self.impl), objectPath, cast[ptr DBusSubtreeVTable00](vtable.impl), flags, userData, userDataFreeFunc, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = int(resul0)

type
  DBusMessage* = ref object of gobject.Object
  DBusMessage00* = object of gobject.Object00

proc g_dbus_message_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(DBusMessage()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc g_dbus_message_new(): ptr DBusMessage00 {.
    importc, libprag.}

proc newDBusMessage*(): DBusMessage =
  let gobj = g_dbus_message_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newDBusMessage*(tdesc: typedesc): tdesc =
  assert(result is DBusMessage)
  let gobj = g_dbus_message_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initDBusMessage*[T](result: var T) {.deprecated.} =
  assert(result is DBusMessage)
  let gobj = g_dbus_message_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_dbus_message_new_from_blob(blob: ptr uint8; blobLen: uint64; capabilities: DBusCapabilityFlags;
    error: ptr ptr glib.Error = nil): ptr DBusMessage00 {.
    importc, libprag.}

proc newDBusMessageFromBlob*(blob: seq[uint8] | string; capabilities: DBusCapabilityFlags): DBusMessage =
  let blobLen = uint64(blob.len)
  var gerror: ptr glib.Error
  let gobj = g_dbus_message_new_from_blob(cast[ptr uint8](unsafeaddr(blob[0])), blobLen, capabilities, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newDBusMessageFromBlob*(tdesc: typedesc; blob: seq[uint8] | string; capabilities: DBusCapabilityFlags): tdesc =
  let blobLen = uint64(blob.len)
  var gerror: ptr glib.Error
  assert(result is DBusMessage)
  let gobj = g_dbus_message_new_from_blob(cast[ptr uint8](unsafeaddr(blob[0])), blobLen, capabilities, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initDBusMessageFromBlob*[T](result: var T; blob: seq[uint8] | string; capabilities: DBusCapabilityFlags) {.deprecated.} =
  let blobLen = uint64(blob.len)
  var gerror: ptr glib.Error
  assert(result is DBusMessage)
  let gobj = g_dbus_message_new_from_blob(cast[ptr uint8](unsafeaddr(blob[0])), blobLen, capabilities, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_dbus_message_new_method_call(name: cstring; path: cstring; `interface`: cstring;
    `method`: cstring): ptr DBusMessage00 {.
    importc, libprag.}

proc newDBusMessageMethodCall*(name: cstring = nil; path: cstring; `interface`: cstring = nil;
    `method`: cstring): DBusMessage =
  let gobj = g_dbus_message_new_method_call(name, path, `interface`, `method`)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newDBusMessageMethodCall*(tdesc: typedesc; name: cstring = nil; path: cstring; `interface`: cstring = nil;
    `method`: cstring): tdesc =
  assert(result is DBusMessage)
  let gobj = g_dbus_message_new_method_call(name, path, `interface`, `method`)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initDBusMessageMethodCall*[T](result: var T; name: cstring = nil; path: cstring; `interface`: cstring = nil;
    `method`: cstring) {.deprecated.} =
  assert(result is DBusMessage)
  let gobj = g_dbus_message_new_method_call(name, path, `interface`, `method`)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_dbus_message_new_signal(path: cstring; `interface`: cstring; signal: cstring): ptr DBusMessage00 {.
    importc, libprag.}

proc newDBusMessageSignal*(path: cstring; `interface`: cstring; signal: cstring): DBusMessage =
  let gobj = g_dbus_message_new_signal(path, `interface`, signal)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newDBusMessageSignal*(tdesc: typedesc; path: cstring; `interface`: cstring; signal: cstring): tdesc =
  assert(result is DBusMessage)
  let gobj = g_dbus_message_new_signal(path, `interface`, signal)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initDBusMessageSignal*[T](result: var T; path: cstring; `interface`: cstring; signal: cstring) {.deprecated.} =
  assert(result is DBusMessage)
  let gobj = g_dbus_message_new_signal(path, `interface`, signal)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_dbus_message_bytes_needed(blob: ptr uint8; blobLen: uint64; error: ptr ptr glib.Error = nil): int64 {.
    importc, libprag.}

proc bytesNeeded*(blob: seq[uint8] | string): int64 =
  let blobLen = uint64(blob.len)
  var gerror: ptr glib.Error
  let resul0 = g_dbus_message_bytes_needed(cast[ptr uint8](unsafeaddr(blob[0])), blobLen, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = resul0

proc g_dbus_message_copy(self: ptr DBusMessage00; error: ptr ptr glib.Error = nil): ptr DBusMessage00 {.
    importc, libprag.}

proc copy*(self: DBusMessage): DBusMessage =
  var gerror: ptr glib.Error
  let gobj = g_dbus_message_copy(cast[ptr DBusMessage00](self.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_dbus_message_get_arg0(self: ptr DBusMessage00): cstring {.
    importc, libprag.}

proc getArg0*(self: DBusMessage): string =
  result = $g_dbus_message_get_arg0(cast[ptr DBusMessage00](self.impl))

proc arg0*(self: DBusMessage): string =
  result = $g_dbus_message_get_arg0(cast[ptr DBusMessage00](self.impl))

proc g_dbus_message_get_body(self: ptr DBusMessage00): ptr glib.Variant00 {.
    importc, libprag.}

proc getBody*(self: DBusMessage): glib.Variant =
  fnew(result, finalizerunref)
  result.impl = g_dbus_message_get_body(cast[ptr DBusMessage00](self.impl))
  result.ignoreFinalizer = true # GVariant

proc body*(self: DBusMessage): glib.Variant =
  fnew(result, finalizerunref)
  result.impl = g_dbus_message_get_body(cast[ptr DBusMessage00](self.impl))
  result.ignoreFinalizer = true # GVariant

proc g_dbus_message_get_destination(self: ptr DBusMessage00): cstring {.
    importc, libprag.}

proc getDestination*(self: DBusMessage): string =
  result = $g_dbus_message_get_destination(cast[ptr DBusMessage00](self.impl))

proc destination*(self: DBusMessage): string =
  result = $g_dbus_message_get_destination(cast[ptr DBusMessage00](self.impl))

proc g_dbus_message_get_error_name(self: ptr DBusMessage00): cstring {.
    importc, libprag.}

proc getErrorName*(self: DBusMessage): string =
  result = $g_dbus_message_get_error_name(cast[ptr DBusMessage00](self.impl))

proc errorName*(self: DBusMessage): string =
  result = $g_dbus_message_get_error_name(cast[ptr DBusMessage00](self.impl))

proc g_dbus_message_get_header_fields(self: ptr DBusMessage00): ptr uint8 {.
    importc, libprag.}

proc getHeaderFields*(self: DBusMessage): seq[uint8] =
  result = uint8ArrayZT2seq(g_dbus_message_get_header_fields(cast[ptr DBusMessage00](self.impl)))

proc headerFields*(self: DBusMessage): seq[uint8] =
  result = uint8ArrayZT2seq(g_dbus_message_get_header_fields(cast[ptr DBusMessage00](self.impl)))

proc g_dbus_message_get_interface(self: ptr DBusMessage00): cstring {.
    importc, libprag.}

proc getInterface*(self: DBusMessage): string =
  result = $g_dbus_message_get_interface(cast[ptr DBusMessage00](self.impl))

proc g_dbus_message_get_locked(self: ptr DBusMessage00): gboolean {.
    importc, libprag.}

proc getLocked*(self: DBusMessage): bool =
  toBool(g_dbus_message_get_locked(cast[ptr DBusMessage00](self.impl)))

proc locked*(self: DBusMessage): bool =
  toBool(g_dbus_message_get_locked(cast[ptr DBusMessage00](self.impl)))

proc g_dbus_message_get_member(self: ptr DBusMessage00): cstring {.
    importc, libprag.}

proc getMember*(self: DBusMessage): string =
  result = $g_dbus_message_get_member(cast[ptr DBusMessage00](self.impl))

proc member*(self: DBusMessage): string =
  result = $g_dbus_message_get_member(cast[ptr DBusMessage00](self.impl))

proc g_dbus_message_get_num_unix_fds(self: ptr DBusMessage00): uint32 {.
    importc, libprag.}

proc getNumUnixFds*(self: DBusMessage): int =
  int(g_dbus_message_get_num_unix_fds(cast[ptr DBusMessage00](self.impl)))

proc numUnixFds*(self: DBusMessage): int =
  int(g_dbus_message_get_num_unix_fds(cast[ptr DBusMessage00](self.impl)))

proc g_dbus_message_get_path(self: ptr DBusMessage00): cstring {.
    importc, libprag.}

proc getPath*(self: DBusMessage): string =
  result = $g_dbus_message_get_path(cast[ptr DBusMessage00](self.impl))

proc path*(self: DBusMessage): string =
  result = $g_dbus_message_get_path(cast[ptr DBusMessage00](self.impl))

proc g_dbus_message_get_reply_serial(self: ptr DBusMessage00): uint32 {.
    importc, libprag.}

proc getReplySerial*(self: DBusMessage): int =
  int(g_dbus_message_get_reply_serial(cast[ptr DBusMessage00](self.impl)))

proc replySerial*(self: DBusMessage): int =
  int(g_dbus_message_get_reply_serial(cast[ptr DBusMessage00](self.impl)))

proc g_dbus_message_get_sender(self: ptr DBusMessage00): cstring {.
    importc, libprag.}

proc getSender*(self: DBusMessage): string =
  result = $g_dbus_message_get_sender(cast[ptr DBusMessage00](self.impl))

proc sender*(self: DBusMessage): string =
  result = $g_dbus_message_get_sender(cast[ptr DBusMessage00](self.impl))

proc g_dbus_message_get_serial(self: ptr DBusMessage00): uint32 {.
    importc, libprag.}

proc getSerial*(self: DBusMessage): int =
  int(g_dbus_message_get_serial(cast[ptr DBusMessage00](self.impl)))

proc serial*(self: DBusMessage): int =
  int(g_dbus_message_get_serial(cast[ptr DBusMessage00](self.impl)))

proc g_dbus_message_get_signature(self: ptr DBusMessage00): cstring {.
    importc, libprag.}

proc getSignature*(self: DBusMessage): string =
  result = $g_dbus_message_get_signature(cast[ptr DBusMessage00](self.impl))

proc signature*(self: DBusMessage): string =
  result = $g_dbus_message_get_signature(cast[ptr DBusMessage00](self.impl))

proc g_dbus_message_get_unix_fd_list(self: ptr DBusMessage00): ptr UnixFDList00 {.
    importc, libprag.}

proc getUnixFdList*(self: DBusMessage): UnixFDList =
  let gobj = g_dbus_message_get_unix_fd_list(cast[ptr DBusMessage00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc unixFdList*(self: DBusMessage): UnixFDList =
  let gobj = g_dbus_message_get_unix_fd_list(cast[ptr DBusMessage00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_dbus_message_lock(self: ptr DBusMessage00) {.
    importc, libprag.}

proc lock*(self: DBusMessage) =
  g_dbus_message_lock(cast[ptr DBusMessage00](self.impl))

proc g_dbus_message_new_method_error_literal(self: ptr DBusMessage00; errorName: cstring;
    errorMessage: cstring): ptr DBusMessage00 {.
    importc, libprag.}

proc newDBusMessageMethodErrorLiteral*(self: DBusMessage; errorName: cstring;
    errorMessage: cstring): DBusMessage =
  let gobj = g_dbus_message_new_method_error_literal(cast[ptr DBusMessage00](self.impl), errorName, errorMessage)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_dbus_message_new_method_reply(self: ptr DBusMessage00): ptr DBusMessage00 {.
    importc, libprag.}

proc newDBusMessageMethodReply*(self: DBusMessage): DBusMessage =
  let gobj = g_dbus_message_new_method_reply(cast[ptr DBusMessage00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_dbus_message_print(self: ptr DBusMessage00; indent: uint32): cstring {.
    importc, libprag.}

proc print*(self: DBusMessage; indent: int): string =
  let resul0 = g_dbus_message_print(cast[ptr DBusMessage00](self.impl), uint32(indent))
  result = $resul0
  cogfree(resul0)

proc g_dbus_message_set_body(self: ptr DBusMessage00; body: ptr glib.Variant00) {.
    importc, libprag.}

proc setBody*(self: DBusMessage; body: glib.Variant) =
  g_dbus_message_set_body(cast[ptr DBusMessage00](self.impl), cast[ptr glib.Variant00](body.impl))

proc `body=`*(self: DBusMessage; body: glib.Variant) =
  g_dbus_message_set_body(cast[ptr DBusMessage00](self.impl), cast[ptr glib.Variant00](body.impl))

proc g_dbus_message_set_destination(self: ptr DBusMessage00; value: cstring) {.
    importc, libprag.}

proc setDestination*(self: DBusMessage; value: cstring) =
  g_dbus_message_set_destination(cast[ptr DBusMessage00](self.impl), value)

proc `destination=`*(self: DBusMessage; value: cstring) =
  g_dbus_message_set_destination(cast[ptr DBusMessage00](self.impl), value)

proc g_dbus_message_set_error_name(self: ptr DBusMessage00; value: cstring) {.
    importc, libprag.}

proc setErrorName*(self: DBusMessage; value: cstring) =
  g_dbus_message_set_error_name(cast[ptr DBusMessage00](self.impl), value)

proc `errorName=`*(self: DBusMessage; value: cstring) =
  g_dbus_message_set_error_name(cast[ptr DBusMessage00](self.impl), value)

proc g_dbus_message_set_interface(self: ptr DBusMessage00; value: cstring) {.
    importc, libprag.}

proc setInterface*(self: DBusMessage; value: cstring) =
  g_dbus_message_set_interface(cast[ptr DBusMessage00](self.impl), value)

proc `interface=`*(self: DBusMessage; value: cstring) =
  g_dbus_message_set_interface(cast[ptr DBusMessage00](self.impl), value)

proc g_dbus_message_set_member(self: ptr DBusMessage00; value: cstring) {.
    importc, libprag.}

proc setMember*(self: DBusMessage; value: cstring) =
  g_dbus_message_set_member(cast[ptr DBusMessage00](self.impl), value)

proc `member=`*(self: DBusMessage; value: cstring) =
  g_dbus_message_set_member(cast[ptr DBusMessage00](self.impl), value)

proc g_dbus_message_set_num_unix_fds(self: ptr DBusMessage00; value: uint32) {.
    importc, libprag.}

proc setNumUnixFds*(self: DBusMessage; value: int) =
  g_dbus_message_set_num_unix_fds(cast[ptr DBusMessage00](self.impl), uint32(value))

proc `numUnixFds=`*(self: DBusMessage; value: int) =
  g_dbus_message_set_num_unix_fds(cast[ptr DBusMessage00](self.impl), uint32(value))

proc g_dbus_message_set_path(self: ptr DBusMessage00; value: cstring) {.
    importc, libprag.}

proc setPath*(self: DBusMessage; value: cstring) =
  g_dbus_message_set_path(cast[ptr DBusMessage00](self.impl), value)

proc `path=`*(self: DBusMessage; value: cstring) =
  g_dbus_message_set_path(cast[ptr DBusMessage00](self.impl), value)

proc g_dbus_message_set_reply_serial(self: ptr DBusMessage00; value: uint32) {.
    importc, libprag.}

proc setReplySerial*(self: DBusMessage; value: int) =
  g_dbus_message_set_reply_serial(cast[ptr DBusMessage00](self.impl), uint32(value))

proc `replySerial=`*(self: DBusMessage; value: int) =
  g_dbus_message_set_reply_serial(cast[ptr DBusMessage00](self.impl), uint32(value))

proc g_dbus_message_set_sender(self: ptr DBusMessage00; value: cstring) {.
    importc, libprag.}

proc setSender*(self: DBusMessage; value: cstring) =
  g_dbus_message_set_sender(cast[ptr DBusMessage00](self.impl), value)

proc `sender=`*(self: DBusMessage; value: cstring) =
  g_dbus_message_set_sender(cast[ptr DBusMessage00](self.impl), value)

proc g_dbus_message_set_serial(self: ptr DBusMessage00; serial: uint32) {.
    importc, libprag.}

proc setSerial*(self: DBusMessage; serial: int) =
  g_dbus_message_set_serial(cast[ptr DBusMessage00](self.impl), uint32(serial))

proc `serial=`*(self: DBusMessage; serial: int) =
  g_dbus_message_set_serial(cast[ptr DBusMessage00](self.impl), uint32(serial))

proc g_dbus_message_set_signature(self: ptr DBusMessage00; value: cstring) {.
    importc, libprag.}

proc setSignature*(self: DBusMessage; value: cstring) =
  g_dbus_message_set_signature(cast[ptr DBusMessage00](self.impl), value)

proc `signature=`*(self: DBusMessage; value: cstring) =
  g_dbus_message_set_signature(cast[ptr DBusMessage00](self.impl), value)

proc g_dbus_message_set_unix_fd_list(self: ptr DBusMessage00; fdList: ptr UnixFDList00) {.
    importc, libprag.}

proc setUnixFdList*(self: DBusMessage; fdList: UnixFDList = nil) =
  g_dbus_message_set_unix_fd_list(cast[ptr DBusMessage00](self.impl), if fdList.isNil: nil else: cast[ptr UnixFDList00](fdList.impl))

proc `unixFdList=`*(self: DBusMessage; fdList: UnixFDList = nil) =
  g_dbus_message_set_unix_fd_list(cast[ptr DBusMessage00](self.impl), if fdList.isNil: nil else: cast[ptr UnixFDList00](fdList.impl))

proc g_dbus_message_to_blob(self: ptr DBusMessage00; outSize: var uint64;
    capabilities: DBusCapabilityFlags; error: ptr ptr glib.Error = nil): ptr uint8 {.
    importc, libprag.}

proc toBlob*(self: DBusMessage; outSize: var uint64; capabilities: DBusCapabilityFlags): seq[uint8] =
  var gerror: ptr glib.Error
  let resul0 = g_dbus_message_to_blob(cast[ptr DBusMessage00](self.impl), outSize, capabilities, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = uint8ArrayToSeq(resul0, outSize.int)
  cogfree(resul0)

proc g_dbus_message_to_gerror(self: ptr DBusMessage00; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc toGerror*(self: DBusMessage): bool =
  var gerror: ptr glib.Error
  let resul0 = g_dbus_message_to_gerror(cast[ptr DBusMessage00](self.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_dbus_connection_send_message_with_reply_finish(self: ptr DBusConnection00;
    res: ptr AsyncResult00; error: ptr ptr glib.Error = nil): ptr DBusMessage00 {.
    importc, libprag.}

proc sendMessageWithReplyFinish*(self: DBusConnection;
    res: AsyncResult | SimpleAsyncResult | Task): DBusMessage =
  var gerror: ptr glib.Error
  let gobj = g_dbus_connection_send_message_with_reply_finish(cast[ptr DBusConnection00](self.impl), cast[ptr AsyncResult00](res.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

type
  DBusSendMessageFlag* {.size: sizeof(cint), pure.} = enum
    preserveSerial = 0

  DBusSendMessageFlags* {.size: sizeof(cint).} = set[DBusSendMessageFlag]

const
  DBusSendMessageFlagsNone* = DBusSendMessageFlags({})
proc none*(t: typedesc[DBusSendMessageFlags]): DBusSendMessageFlags = DBusSendMessageFlags({})

proc g_dbus_connection_send_message(self: ptr DBusConnection00; message: ptr DBusMessage00;
    flags: DBusSendMessageFlags; outSerial: var uint32; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc sendMessage*(self: DBusConnection; message: DBusMessage;
    flags: DBusSendMessageFlags; outSerial: var int = cast[var int](nil)): bool =
  var gerror: ptr glib.Error
  var outSerial_00: uint32
  let resul0 = g_dbus_connection_send_message(cast[ptr DBusConnection00](self.impl), cast[ptr DBusMessage00](message.impl), flags, outSerial_00, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)
  if outSerial.addr != nil:
    outSerial = int(outSerial_00)

type
  DBusMessageByteOrder* {.size: sizeof(cint), pure.} = enum
    bigEndian = 66
    littleEndian = 108

proc g_dbus_message_get_byte_order(self: ptr DBusMessage00): DBusMessageByteOrder {.
    importc, libprag.}

proc getByteOrder*(self: DBusMessage): DBusMessageByteOrder =
  g_dbus_message_get_byte_order(cast[ptr DBusMessage00](self.impl))

proc byteOrder*(self: DBusMessage): DBusMessageByteOrder =
  g_dbus_message_get_byte_order(cast[ptr DBusMessage00](self.impl))

proc g_dbus_message_set_byte_order(self: ptr DBusMessage00; byteOrder: DBusMessageByteOrder) {.
    importc, libprag.}

proc setByteOrder*(self: DBusMessage; byteOrder: DBusMessageByteOrder) =
  g_dbus_message_set_byte_order(cast[ptr DBusMessage00](self.impl), byteOrder)

proc `byteOrder=`*(self: DBusMessage; byteOrder: DBusMessageByteOrder) =
  g_dbus_message_set_byte_order(cast[ptr DBusMessage00](self.impl), byteOrder)

type
  DBusMessageFlag* {.size: sizeof(cint), pure.} = enum
    noReplyExpected = 0
    noAutoStart = 1
    allowInteractiveAuthorization = 2

  DBusMessageFlags* {.size: sizeof(cint).} = set[DBusMessageFlag]

const
  DBusMessageFlagsNone* = DBusMessageFlags({})
proc none*(t: typedesc[DBusMessageFlags]): DBusMessageFlags = DBusMessageFlags({})

proc g_dbus_message_get_flags(self: ptr DBusMessage00): DBusMessageFlags {.
    importc, libprag.}

proc getFlags*(self: DBusMessage): DBusMessageFlags =
  g_dbus_message_get_flags(cast[ptr DBusMessage00](self.impl))

proc flags*(self: DBusMessage): DBusMessageFlags =
  g_dbus_message_get_flags(cast[ptr DBusMessage00](self.impl))

proc g_dbus_message_set_flags(self: ptr DBusMessage00; flags: DBusMessageFlags) {.
    importc, libprag.}

proc setFlags*(self: DBusMessage; flags: DBusMessageFlags) =
  g_dbus_message_set_flags(cast[ptr DBusMessage00](self.impl), flags)

proc `flags=`*(self: DBusMessage; flags: DBusMessageFlags) =
  g_dbus_message_set_flags(cast[ptr DBusMessage00](self.impl), flags)

type
  DBusMessageHeaderField* {.size: sizeof(cint), pure.} = enum
    invalid = 0
    path = 1
    `interface` = 2
    member = 3
    errorName = 4
    replySerial = 5
    destination = 6
    sender = 7
    signature = 8
    numUnixFds = 9

proc g_dbus_message_get_header(self: ptr DBusMessage00; headerField: DBusMessageHeaderField): ptr glib.Variant00 {.
    importc, libprag.}

proc getHeader*(self: DBusMessage; headerField: DBusMessageHeaderField): glib.Variant =
  let impl0 = g_dbus_message_get_header(cast[ptr DBusMessage00](self.impl), headerField)
  if impl0.isNil:
    return nil
  fnew(result, finalizerunref)
  result.impl = impl0
  result.ignoreFinalizer = true # GVariant

proc g_dbus_message_set_header(self: ptr DBusMessage00; headerField: DBusMessageHeaderField;
    value: ptr glib.Variant00) {.
    importc, libprag.}

proc setHeader*(self: DBusMessage; headerField: DBusMessageHeaderField;
    value: glib.Variant = nil) =
  g_dbus_message_set_header(cast[ptr DBusMessage00](self.impl), headerField, if value.isNil: nil else: cast[ptr glib.Variant00](value.impl))

type
  DBusMessageType* {.size: sizeof(cint), pure.} = enum
    invalid = 0
    methodCall = 1
    methodReturn = 2
    error = 3
    signal = 4

proc g_dbus_message_get_message_type(self: ptr DBusMessage00): DBusMessageType {.
    importc, libprag.}

proc getMessageType*(self: DBusMessage): DBusMessageType =
  g_dbus_message_get_message_type(cast[ptr DBusMessage00](self.impl))

proc messageType*(self: DBusMessage): DBusMessageType =
  g_dbus_message_get_message_type(cast[ptr DBusMessage00](self.impl))

proc g_dbus_message_set_message_type(self: ptr DBusMessage00; `type`: DBusMessageType) {.
    importc, libprag.}

proc setMessageType*(self: DBusMessage; `type`: DBusMessageType) =
  g_dbus_message_set_message_type(cast[ptr DBusMessage00](self.impl), `type`)

proc `messageType=`*(self: DBusMessage; `type`: DBusMessageType) =
  g_dbus_message_set_message_type(cast[ptr DBusMessage00](self.impl), `type`)

type
  DBusSignalFlag* {.size: sizeof(cint), pure.} = enum
    noMatchRule = 0
    matchArg0Namespace = 1
    matchArg0Path = 2

  DBusSignalFlags* {.size: sizeof(cint).} = set[DBusSignalFlag]

const
  DBusSignalFlagsNone* = DBusSignalFlags({})
proc none*(t: typedesc[DBusSignalFlags]): DBusSignalFlags = DBusSignalFlags({})

type
  Cancellable* = ref object of gobject.Object
  Cancellable00* = object of gobject.Object00

proc g_cancellable_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(Cancellable()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc scCancelled*(self: Cancellable;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "cancelled", cast[GCallback](p), xdata, nil, cf)

proc g_cancellable_new(): ptr Cancellable00 {.
    importc, libprag.}

proc newCancellable*(): Cancellable =
  let gobj = g_cancellable_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newCancellable*(tdesc: typedesc): tdesc =
  assert(result is Cancellable)
  let gobj = g_cancellable_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initCancellable*[T](result: var T) {.deprecated.} =
  assert(result is Cancellable)
  let gobj = g_cancellable_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_cancellable_get_current(): ptr Cancellable00 {.
    importc, libprag.}

proc getCurrent*(): Cancellable =
  let gobj = g_cancellable_get_current()
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_cancellable_cancel(self: ptr Cancellable00) {.
    importc, libprag.}

proc cancel*(self: Cancellable) =
  g_cancellable_cancel(cast[ptr Cancellable00](self.impl))

proc g_cancellable_connect(self: ptr Cancellable00; callback: Callback; data: pointer;
    dataDestroyFunc: DestroyNotify): uint64 {.
    importc, libprag.}

proc connect*(self: Cancellable; callback: Callback; data: pointer;
    dataDestroyFunc: DestroyNotify): uint64 =
  g_cancellable_connect(cast[ptr Cancellable00](self.impl), callback, data, dataDestroyFunc)

proc g_cancellable_disconnect(self: ptr Cancellable00; handlerId: uint64) {.
    importc, libprag.}

proc disconnect*(self: Cancellable; handlerId: uint64) =
  g_cancellable_disconnect(cast[ptr Cancellable00](self.impl), handlerId)

proc g_cancellable_get_fd(self: ptr Cancellable00): int32 {.
    importc, libprag.}

proc getFd*(self: Cancellable): int =
  int(g_cancellable_get_fd(cast[ptr Cancellable00](self.impl)))

proc fd*(self: Cancellable): int =
  int(g_cancellable_get_fd(cast[ptr Cancellable00](self.impl)))

proc g_cancellable_is_cancelled(self: ptr Cancellable00): gboolean {.
    importc, libprag.}

proc isCancelled*(self: Cancellable): bool =
  toBool(g_cancellable_is_cancelled(cast[ptr Cancellable00](self.impl)))

proc g_cancellable_make_pollfd(self: ptr Cancellable00; pollfd: glib.PollFD): gboolean {.
    importc, libprag.}

proc makePollfd*(self: Cancellable; pollfd: glib.PollFD): bool =
  toBool(g_cancellable_make_pollfd(cast[ptr Cancellable00](self.impl), pollfd))

proc g_cancellable_pop_current(self: ptr Cancellable00) {.
    importc, libprag.}

proc popCurrent*(self: Cancellable) =
  g_cancellable_pop_current(cast[ptr Cancellable00](self.impl))

proc g_cancellable_push_current(self: ptr Cancellable00) {.
    importc, libprag.}

proc pushCurrent*(self: Cancellable) =
  g_cancellable_push_current(cast[ptr Cancellable00](self.impl))

proc g_cancellable_release_fd(self: ptr Cancellable00) {.
    importc, libprag.}

proc releaseFd*(self: Cancellable) =
  g_cancellable_release_fd(cast[ptr Cancellable00](self.impl))

proc g_cancellable_reset(self: ptr Cancellable00) {.
    importc, libprag.}

proc reset*(self: Cancellable) =
  g_cancellable_reset(cast[ptr Cancellable00](self.impl))

proc g_cancellable_set_error_if_cancelled(self: ptr Cancellable00; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc setErrorIfCancelled*(self: Cancellable): bool =
  var gerror: ptr glib.Error
  let resul0 = g_cancellable_set_error_if_cancelled(cast[ptr Cancellable00](self.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_cancellable_source_new(self: ptr Cancellable00): ptr glib.Source00 {.
    importc, libprag.}

proc sourceNew*(self: Cancellable): glib.Source =
  fnew(result, gBoxedFreeGSource)
  result.impl = g_cancellable_source_new(cast[ptr Cancellable00](self.impl))

proc g_file_append_to(self: ptr GFile00; flags: FileCreateFlags; cancellable: ptr Cancellable00;
    error: ptr ptr glib.Error = nil): ptr FileOutputStream00 {.
    importc, libprag.}

proc appendTo*(self: GFile; flags: FileCreateFlags; cancellable: Cancellable = nil): FileOutputStream =
  var gerror: ptr glib.Error
  let gobj = g_file_append_to(cast[ptr GFile00](self.impl), flags, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_file_copy_attributes(self: ptr GFile00; destination: ptr GFile00;
    flags: FileCopyFlags; cancellable: ptr Cancellable00; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc copyAttributes*(self: GFile; destination: GFile; flags: FileCopyFlags;
    cancellable: Cancellable = nil): bool =
  var gerror: ptr glib.Error
  let resul0 = g_file_copy_attributes(cast[ptr GFile00](self.impl), cast[ptr GFile00](destination.impl), flags, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_file_create(self: ptr GFile00; flags: FileCreateFlags; cancellable: ptr Cancellable00;
    error: ptr ptr glib.Error = nil): ptr FileOutputStream00 {.
    importc, libprag.}

proc create*(self: GFile; flags: FileCreateFlags; cancellable: Cancellable = nil): FileOutputStream =
  var gerror: ptr glib.Error
  let gobj = g_file_create(cast[ptr GFile00](self.impl), flags, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_file_create_readwrite(self: ptr GFile00; flags: FileCreateFlags; cancellable: ptr Cancellable00;
    error: ptr ptr glib.Error = nil): ptr FileIOStream00 {.
    importc, libprag.}

proc createReadwrite*(self: GFile; flags: FileCreateFlags; cancellable: Cancellable = nil): FileIOStream =
  var gerror: ptr glib.Error
  let gobj = g_file_create_readwrite(cast[ptr GFile00](self.impl), flags, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_file_delete(self: ptr GFile00; cancellable: ptr Cancellable00; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc delete*(self: GFile; cancellable: Cancellable = nil): bool =
  var gerror: ptr glib.Error
  let resul0 = g_file_delete(cast[ptr GFile00](self.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_file_enumerate_children(self: ptr GFile00; attributes: cstring; flags: FileQueryInfoFlags;
    cancellable: ptr Cancellable00; error: ptr ptr glib.Error = nil): ptr FileEnumerator00 {.
    importc, libprag.}

proc enumerateChildren*(self: GFile; attributes: cstring; flags: FileQueryInfoFlags;
    cancellable: Cancellable = nil): FileEnumerator =
  var gerror: ptr glib.Error
  let gobj = g_file_enumerate_children(cast[ptr GFile00](self.impl), attributes, flags, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_file_find_enclosing_mount(self: ptr GFile00; cancellable: ptr Cancellable00;
    error: ptr ptr glib.Error = nil): ptr Mount00 {.
    importc, libprag.}

proc findEnclosingMount*(self: GFile; cancellable: Cancellable = nil): Mount =
  var gerror: ptr glib.Error
  let gobj = g_file_find_enclosing_mount(cast[ptr GFile00](self.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_file_load_bytes(self: ptr GFile00; cancellable: ptr Cancellable00;
    etagOut: var cstring; error: ptr ptr glib.Error = nil): ptr glib.Bytes00 {.
    importc, libprag.}

proc loadBytes*(self: GFile; cancellable: Cancellable = nil; etagOut: var string = cast[var string](nil)): glib.Bytes =
  var gerror: ptr glib.Error
  var etagOut_00: cstring
  let impl0 = g_file_load_bytes(cast[ptr GFile00](self.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), etagOut_00, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  fnew(result, gBoxedFreeGBytes)
  result.impl = impl0
  if etagOut.addr != nil:
    etagOut = $(etagOut_00)

proc g_file_load_contents(self: ptr GFile00; cancellable: ptr Cancellable00;
    contents: var ptr uint8; length: var uint64; etagOut: var cstring; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc loadContents*(self: GFile; cancellable: Cancellable = nil; contents: var (seq[uint8] | string);
    length: var uint64 = cast[var uint64](nil); etagOut: var string = cast[var string](nil)): bool =
  var gerror: ptr glib.Error
  var etagOut_00: cstring
  var contents_00: ptr uint8
  let resul0 = g_file_load_contents(cast[ptr GFile00](self.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), contents_00, length, etagOut_00, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)
  if etagOut.addr != nil:
    etagOut = $(etagOut_00)
  contents.setLen(length)
  copyMem(unsafeaddr contents[0], contents_00, length.int * sizeof(contents[0]))
  cogfree(contents_00)

proc g_file_make_directory(self: ptr GFile00; cancellable: ptr Cancellable00;
    error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc makeDirectory*(self: GFile; cancellable: Cancellable = nil): bool =
  var gerror: ptr glib.Error
  let resul0 = g_file_make_directory(cast[ptr GFile00](self.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_file_make_directory_with_parents(self: ptr GFile00; cancellable: ptr Cancellable00;
    error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc makeDirectoryWithParents*(self: GFile; cancellable: Cancellable = nil): bool =
  var gerror: ptr glib.Error
  let resul0 = g_file_make_directory_with_parents(cast[ptr GFile00](self.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_file_make_symbolic_link(self: ptr GFile00; symlinkValue: cstring;
    cancellable: ptr Cancellable00; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc makeSymbolicLink*(self: GFile; symlinkValue: cstring; cancellable: Cancellable = nil): bool =
  var gerror: ptr glib.Error
  let resul0 = g_file_make_symbolic_link(cast[ptr GFile00](self.impl), symlinkValue, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_file_open_readwrite(self: ptr GFile00; cancellable: ptr Cancellable00;
    error: ptr ptr glib.Error = nil): ptr FileIOStream00 {.
    importc, libprag.}

proc openReadwrite*(self: GFile; cancellable: Cancellable = nil): FileIOStream =
  var gerror: ptr glib.Error
  let gobj = g_file_open_readwrite(cast[ptr GFile00](self.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_file_query_default_handler(self: ptr GFile00; cancellable: ptr Cancellable00;
    error: ptr ptr glib.Error = nil): ptr AppInfo00 {.
    importc, libprag.}

proc queryDefaultHandler*(self: GFile; cancellable: Cancellable = nil): AppInfo =
  var gerror: ptr glib.Error
  let gobj = g_file_query_default_handler(cast[ptr GFile00](self.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_file_query_exists(self: ptr GFile00; cancellable: ptr Cancellable00): gboolean {.
    importc, libprag.}

proc queryExists*(self: GFile; cancellable: Cancellable = nil): bool =
  toBool(g_file_query_exists(cast[ptr GFile00](self.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl)))

proc g_file_query_file_type(self: ptr GFile00; flags: FileQueryInfoFlags;
    cancellable: ptr Cancellable00): FileType {.
    importc, libprag.}

proc queryFileType*(self: GFile; flags: FileQueryInfoFlags; cancellable: Cancellable = nil): FileType =
  g_file_query_file_type(cast[ptr GFile00](self.impl), flags, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl))

proc g_file_query_filesystem_info(self: ptr GFile00; attributes: cstring;
    cancellable: ptr Cancellable00; error: ptr ptr glib.Error = nil): ptr FileInfo00 {.
    importc, libprag.}

proc queryFilesystemInfo*(self: GFile; attributes: cstring; cancellable: Cancellable = nil): FileInfo =
  var gerror: ptr glib.Error
  let gobj = g_file_query_filesystem_info(cast[ptr GFile00](self.impl), attributes, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_file_query_info(self: ptr GFile00; attributes: cstring; flags: FileQueryInfoFlags;
    cancellable: ptr Cancellable00; error: ptr ptr glib.Error = nil): ptr FileInfo00 {.
    importc, libprag.}

proc queryInfo*(self: GFile; attributes: cstring; flags: FileQueryInfoFlags;
    cancellable: Cancellable = nil): FileInfo =
  var gerror: ptr glib.Error
  let gobj = g_file_query_info(cast[ptr GFile00](self.impl), attributes, flags, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_file_replace(self: ptr GFile00; etag: cstring; makeBackup: gboolean;
    flags: FileCreateFlags; cancellable: ptr Cancellable00; error: ptr ptr glib.Error = nil): ptr FileOutputStream00 {.
    importc, libprag.}

proc replace*(self: GFile; etag: cstring = nil; makeBackup: bool; flags: FileCreateFlags;
    cancellable: Cancellable = nil): FileOutputStream =
  var gerror: ptr glib.Error
  let gobj = g_file_replace(cast[ptr GFile00](self.impl), etag, gboolean(makeBackup), flags, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_file_replace_contents(self: ptr GFile00; contents: ptr uint8; length: uint64;
    etag: cstring; makeBackup: gboolean; flags: FileCreateFlags; newEtag: var cstring;
    cancellable: ptr Cancellable00; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc replaceContents*(self: GFile; contents: seq[uint8] | string;
    etag: cstring = nil; makeBackup: bool; flags: FileCreateFlags; newEtag: var string = cast[var string](nil);
    cancellable: Cancellable = nil): bool =
  let length = uint64(contents.len)
  var gerror: ptr glib.Error
  var newEtag_00: cstring
  let resul0 = g_file_replace_contents(cast[ptr GFile00](self.impl), cast[ptr uint8](unsafeaddr(contents[0])), length, etag, gboolean(makeBackup), flags, newEtag_00, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)
  if newEtag.addr != nil:
    newEtag = $(newEtag_00)

proc g_file_replace_readwrite(self: ptr GFile00; etag: cstring; makeBackup: gboolean;
    flags: FileCreateFlags; cancellable: ptr Cancellable00; error: ptr ptr glib.Error = nil): ptr FileIOStream00 {.
    importc, libprag.}

proc replaceReadwrite*(self: GFile; etag: cstring = nil; makeBackup: bool;
    flags: FileCreateFlags; cancellable: Cancellable = nil): FileIOStream =
  var gerror: ptr glib.Error
  let gobj = g_file_replace_readwrite(cast[ptr GFile00](self.impl), etag, gboolean(makeBackup), flags, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_file_set_attribute(self: ptr GFile00; attribute: cstring; `type`: FileAttributeType;
    valueP: pointer; flags: FileQueryInfoFlags; cancellable: ptr Cancellable00;
    error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc setAttribute*(self: GFile; attribute: cstring; `type`: FileAttributeType;
    valueP: pointer; flags: FileQueryInfoFlags; cancellable: Cancellable = nil): bool =
  var gerror: ptr glib.Error
  let resul0 = g_file_set_attribute(cast[ptr GFile00](self.impl), attribute, `type`, valueP, flags, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_file_set_attribute_byte_string(self: ptr GFile00; attribute: cstring;
    value: cstring; flags: FileQueryInfoFlags; cancellable: ptr Cancellable00;
    error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc setAttributeByteString*(self: GFile; attribute: cstring; value: cstring;
    flags: FileQueryInfoFlags; cancellable: Cancellable = nil): bool =
  var gerror: ptr glib.Error
  let resul0 = g_file_set_attribute_byte_string(cast[ptr GFile00](self.impl), attribute, value, flags, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_file_set_attribute_int32(self: ptr GFile00; attribute: cstring; value: int32;
    flags: FileQueryInfoFlags; cancellable: ptr Cancellable00; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc setAttributeInt32*(self: GFile; attribute: cstring; value: int;
    flags: FileQueryInfoFlags; cancellable: Cancellable = nil): bool =
  var gerror: ptr glib.Error
  let resul0 = g_file_set_attribute_int32(cast[ptr GFile00](self.impl), attribute, int32(value), flags, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_file_set_attribute_int64(self: ptr GFile00; attribute: cstring; value: int64;
    flags: FileQueryInfoFlags; cancellable: ptr Cancellable00; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc setAttributeInt64*(self: GFile; attribute: cstring; value: int64;
    flags: FileQueryInfoFlags; cancellable: Cancellable = nil): bool =
  var gerror: ptr glib.Error
  let resul0 = g_file_set_attribute_int64(cast[ptr GFile00](self.impl), attribute, value, flags, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_file_set_attribute_string(self: ptr GFile00; attribute: cstring; value: cstring;
    flags: FileQueryInfoFlags; cancellable: ptr Cancellable00; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc setAttributeString*(self: GFile; attribute: cstring; value: cstring;
    flags: FileQueryInfoFlags; cancellable: Cancellable = nil): bool =
  var gerror: ptr glib.Error
  let resul0 = g_file_set_attribute_string(cast[ptr GFile00](self.impl), attribute, value, flags, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_file_set_attribute_uint32(self: ptr GFile00; attribute: cstring; value: uint32;
    flags: FileQueryInfoFlags; cancellable: ptr Cancellable00; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc setAttributeUint32*(self: GFile; attribute: cstring; value: int;
    flags: FileQueryInfoFlags; cancellable: Cancellable = nil): bool =
  var gerror: ptr glib.Error
  let resul0 = g_file_set_attribute_uint32(cast[ptr GFile00](self.impl), attribute, uint32(value), flags, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_file_set_attribute_uint64(self: ptr GFile00; attribute: cstring; value: uint64;
    flags: FileQueryInfoFlags; cancellable: ptr Cancellable00; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc setAttributeUint64*(self: GFile; attribute: cstring; value: uint64;
    flags: FileQueryInfoFlags; cancellable: Cancellable = nil): bool =
  var gerror: ptr glib.Error
  let resul0 = g_file_set_attribute_uint64(cast[ptr GFile00](self.impl), attribute, value, flags, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_file_set_attributes_from_info(self: ptr GFile00; info: ptr FileInfo00;
    flags: FileQueryInfoFlags; cancellable: ptr Cancellable00; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc setAttributesFromInfo*(self: GFile; info: FileInfo; flags: FileQueryInfoFlags;
    cancellable: Cancellable = nil): bool =
  var gerror: ptr glib.Error
  let resul0 = g_file_set_attributes_from_info(cast[ptr GFile00](self.impl), cast[ptr FileInfo00](info.impl), flags, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_file_set_display_name(self: ptr GFile00; displayName: cstring; cancellable: ptr Cancellable00;
    error: ptr ptr glib.Error = nil): ptr GFile00 {.
    importc, libprag.}

proc setDisplayName*(self: GFile; displayName: cstring; cancellable: Cancellable = nil): GFile =
  var gerror: ptr glib.Error
  let gobj = g_file_set_display_name(cast[ptr GFile00](self.impl), displayName, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_file_trash(self: ptr GFile00; cancellable: ptr Cancellable00; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc trash*(self: GFile; cancellable: Cancellable = nil): bool =
  var gerror: ptr glib.Error
  let resul0 = g_file_trash(cast[ptr GFile00](self.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_application_register(self: ptr GApplication00; cancellable: ptr Cancellable00;
    error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc registerGApplication*(self: GApplication; cancellable: Cancellable = nil): bool =
  var gerror: ptr glib.Error
  let resul0 = g_application_register(cast[ptr GApplication00](self.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_io_stream_close(self: ptr IOStream00; cancellable: ptr Cancellable00;
    error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc close*(self: IOStream; cancellable: Cancellable = nil): bool =
  var gerror: ptr glib.Error
  let resul0 = g_io_stream_close(cast[ptr IOStream00](self.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_file_io_stream_query_info(self: ptr FileIOStream00; attributes: cstring;
    cancellable: ptr Cancellable00; error: ptr ptr glib.Error = nil): ptr FileInfo00 {.
    importc, libprag.}

proc queryInfo*(self: FileIOStream; attributes: cstring;
    cancellable: Cancellable = nil): FileInfo =
  var gerror: ptr glib.Error
  let gobj = g_file_io_stream_query_info(cast[ptr FileIOStream00](self.impl), attributes, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_output_stream_close(self: ptr OutputStream00; cancellable: ptr Cancellable00;
    error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc close*(self: OutputStream; cancellable: Cancellable = nil): bool =
  var gerror: ptr glib.Error
  let resul0 = g_output_stream_close(cast[ptr OutputStream00](self.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_output_stream_flush(self: ptr OutputStream00; cancellable: ptr Cancellable00;
    error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc flush*(self: OutputStream; cancellable: Cancellable = nil): bool =
  var gerror: ptr glib.Error
  let resul0 = g_output_stream_flush(cast[ptr OutputStream00](self.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_output_stream_write(self: ptr OutputStream00; buffer: ptr uint8; count: uint64;
    cancellable: ptr Cancellable00; error: ptr ptr glib.Error = nil): int64 {.
    importc, libprag.}

proc write*(self: OutputStream; buffer: seq[uint8] | string;
    cancellable: Cancellable = nil): int64 =
  let count = uint64(buffer.len)
  var gerror: ptr glib.Error
  let resul0 = g_output_stream_write(cast[ptr OutputStream00](self.impl), cast[ptr uint8](unsafeaddr(buffer[0])), count, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = resul0

proc g_output_stream_write_all(self: ptr OutputStream00; buffer: ptr uint8;
    count: uint64; bytesWritten: var uint64; cancellable: ptr Cancellable00;
    error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc writeAll*(self: OutputStream; buffer: seq[uint8] | string;
    bytesWritten: var uint64 = cast[var uint64](nil); cancellable: Cancellable = nil): bool =
  let count = uint64(buffer.len)
  var gerror: ptr glib.Error
  let resul0 = g_output_stream_write_all(cast[ptr OutputStream00](self.impl), cast[ptr uint8](unsafeaddr(buffer[0])), count, bytesWritten, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_output_stream_write_bytes(self: ptr OutputStream00; bytes: ptr glib.Bytes00;
    cancellable: ptr Cancellable00; error: ptr ptr glib.Error = nil): int64 {.
    importc, libprag.}

proc writeBytes*(self: OutputStream; bytes: glib.Bytes; cancellable: Cancellable = nil): int64 =
  var gerror: ptr glib.Error
  let resul0 = g_output_stream_write_bytes(cast[ptr OutputStream00](self.impl), cast[ptr glib.Bytes00](bytes.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = resul0

proc g_output_stream_writev(self: ptr OutputStream00; vectors: ptr OutputVector;
    nVectors: uint64; bytesWritten: var uint64; cancellable: ptr Cancellable00;
    error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc writev*(self: OutputStream; vectors: ptr OutputVector;
    nVectors: uint64; bytesWritten: var uint64 = cast[var uint64](nil); cancellable: Cancellable = nil): bool =
  var gerror: ptr glib.Error
  let resul0 = g_output_stream_writev(cast[ptr OutputStream00](self.impl), vectors, nVectors, bytesWritten, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_output_stream_writev_all(self: ptr OutputStream00; vectors: ptr OutputVector;
    nVectors: uint64; bytesWritten: var uint64; cancellable: ptr Cancellable00;
    error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc writevAll*(self: OutputStream; vectors: ptr OutputVector;
    nVectors: uint64; bytesWritten: var uint64 = cast[var uint64](nil); cancellable: Cancellable = nil): bool =
  var gerror: ptr glib.Error
  let resul0 = g_output_stream_writev_all(cast[ptr OutputStream00](self.impl), vectors, nVectors, bytesWritten, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_file_enumerator_close(self: ptr FileEnumerator00; cancellable: ptr Cancellable00;
    error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc close*(self: FileEnumerator; cancellable: Cancellable = nil): bool =
  var gerror: ptr glib.Error
  let resul0 = g_file_enumerator_close(cast[ptr FileEnumerator00](self.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_file_enumerator_next_file(self: ptr FileEnumerator00; cancellable: ptr Cancellable00;
    error: ptr ptr glib.Error = nil): ptr FileInfo00 {.
    importc, libprag.}

proc nextFile*(self: FileEnumerator; cancellable: Cancellable = nil): FileInfo =
  var gerror: ptr glib.Error
  let gobj = g_file_enumerator_next_file(cast[ptr FileEnumerator00](self.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_mount_guess_content_type_sync(self: ptr Mount00; forceRescan: gboolean;
    cancellable: ptr Cancellable00; error: ptr ptr glib.Error = nil): ptr cstring {.
    importc, libprag.}

proc guessContentTypeSync*(self: Mount; forceRescan: bool; cancellable: Cancellable = nil): seq[string] =
  var gerror: ptr glib.Error
  let resul0 = g_mount_guess_content_type_sync(cast[ptr Mount00](self.impl), gboolean(forceRescan), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = cstringArrayToSeq(resul0)

proc g_file_output_stream_query_info(self: ptr FileOutputStream00; attributes: cstring;
    cancellable: ptr Cancellable00; error: ptr ptr glib.Error = nil): ptr FileInfo00 {.
    importc, libprag.}

proc queryInfo*(self: FileOutputStream; attributes: cstring;
    cancellable: Cancellable = nil): FileInfo =
  var gerror: ptr glib.Error
  let gobj = g_file_output_stream_query_info(cast[ptr FileOutputStream00](self.impl), attributes, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_simple_async_result_set_check_cancellable(self: ptr SimpleAsyncResult00;
    checkCancellable: ptr Cancellable00) {.
    importc, libprag.}

proc setCheckCancellable*(self: SimpleAsyncResult;
    checkCancellable: Cancellable = nil) =
  g_simple_async_result_set_check_cancellable(cast[ptr SimpleAsyncResult00](self.impl), if checkCancellable.isNil: nil else: cast[ptr Cancellable00](checkCancellable.impl))

proc `checkCancellable=`*(self: SimpleAsyncResult;
    checkCancellable: Cancellable = nil) =
  g_simple_async_result_set_check_cancellable(cast[ptr SimpleAsyncResult00](self.impl), if checkCancellable.isNil: nil else: cast[ptr Cancellable00](checkCancellable.impl))

proc g_task_get_cancellable(self: ptr Task00): ptr Cancellable00 {.
    importc, libprag.}

proc getCancellable*(self: Task): Cancellable =
  let gobj = g_task_get_cancellable(cast[ptr Task00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc cancellable*(self: Task): Cancellable =
  let gobj = g_task_get_cancellable(cast[ptr Task00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_dbus_connection_new_for_address_sync(address: cstring; flags: DBusConnectionFlags;
    observer: ptr DBusAuthObserver00; cancellable: ptr Cancellable00; error: ptr ptr glib.Error = nil): ptr DBusConnection00 {.
    importc, libprag.}

proc newDBusConnectionForAddressSync*(address: cstring; flags: DBusConnectionFlags;
    observer: DBusAuthObserver = nil; cancellable: Cancellable = nil): DBusConnection =
  var gerror: ptr glib.Error
  let gobj = g_dbus_connection_new_for_address_sync(address, flags, if observer.isNil: nil else: cast[ptr DBusAuthObserver00](observer.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newDBusConnectionForAddressSync*(tdesc: typedesc; address: cstring; flags: DBusConnectionFlags;
    observer: DBusAuthObserver = nil; cancellable: Cancellable = nil): tdesc =
  var gerror: ptr glib.Error
  assert(result is DBusConnection)
  let gobj = g_dbus_connection_new_for_address_sync(address, flags, if observer.isNil: nil else: cast[ptr DBusAuthObserver00](observer.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initDBusConnectionForAddressSync*[T](result: var T; address: cstring; flags: DBusConnectionFlags;
    observer: DBusAuthObserver = nil; cancellable: Cancellable = nil) {.deprecated.} =
  var gerror: ptr glib.Error
  assert(result is DBusConnection)
  let gobj = g_dbus_connection_new_for_address_sync(address, flags, if observer.isNil: nil else: cast[ptr DBusAuthObserver00](observer.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_dbus_connection_new_sync(stream: ptr IOStream00; guid: cstring; flags: DBusConnectionFlags;
    observer: ptr DBusAuthObserver00; cancellable: ptr Cancellable00; error: ptr ptr glib.Error = nil): ptr DBusConnection00 {.
    importc, libprag.}

proc newDBusConnectionSync*(stream: IOStream; guid: cstring = nil; flags: DBusConnectionFlags;
    observer: DBusAuthObserver = nil; cancellable: Cancellable = nil): DBusConnection =
  var gerror: ptr glib.Error
  let gobj = g_dbus_connection_new_sync(cast[ptr IOStream00](stream.impl), guid, flags, if observer.isNil: nil else: cast[ptr DBusAuthObserver00](observer.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newDBusConnectionSync*(tdesc: typedesc; stream: IOStream; guid: cstring = nil; flags: DBusConnectionFlags;
    observer: DBusAuthObserver = nil; cancellable: Cancellable = nil): tdesc =
  var gerror: ptr glib.Error
  assert(result is DBusConnection)
  let gobj = g_dbus_connection_new_sync(cast[ptr IOStream00](stream.impl), guid, flags, if observer.isNil: nil else: cast[ptr DBusAuthObserver00](observer.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initDBusConnectionSync*[T](result: var T; stream: IOStream; guid: cstring = nil; flags: DBusConnectionFlags;
    observer: DBusAuthObserver = nil; cancellable: Cancellable = nil) {.deprecated.} =
  var gerror: ptr glib.Error
  assert(result is DBusConnection)
  let gobj = g_dbus_connection_new_sync(cast[ptr IOStream00](stream.impl), guid, flags, if observer.isNil: nil else: cast[ptr DBusAuthObserver00](observer.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_dbus_connection_call_sync(self: ptr DBusConnection00; busName: cstring;
    objectPath: cstring; interfaceName: cstring; methodName: cstring; parameters: ptr glib.Variant00;
    replyType: ptr glib.VariantType00; flags: DBusCallFlags; timeoutMsec: int32;
    cancellable: ptr Cancellable00; error: ptr ptr glib.Error = nil): ptr glib.Variant00 {.
    importc, libprag.}

proc callSync*(self: DBusConnection; busName: cstring = nil;
    objectPath: cstring; interfaceName: cstring; methodName: cstring; parameters: glib.Variant = nil;
    replyType: glib.VariantType = nil; flags: DBusCallFlags; timeoutMsec: int;
    cancellable: Cancellable = nil): glib.Variant =
  var gerror: ptr glib.Error
  let impl0 = g_dbus_connection_call_sync(cast[ptr DBusConnection00](self.impl), busName, objectPath, interfaceName, methodName, if parameters.isNil: nil else: cast[ptr glib.Variant00](parameters.impl), if replyType.isNil: nil else: cast[ptr glib.VariantType00](replyType.impl), flags, int32(timeoutMsec), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  fnew(result, finalizerunref)
  result.impl = impl0

proc g_dbus_connection_call_with_unix_fd_list_sync(self: ptr DBusConnection00;
    busName: cstring; objectPath: cstring; interfaceName: cstring; methodName: cstring;
    parameters: ptr glib.Variant00; replyType: ptr glib.VariantType00; flags: DBusCallFlags;
    timeoutMsec: int32; fdList: ptr UnixFDList00; outFdList: var ptr UnixFDList00;
    cancellable: ptr Cancellable00; error: ptr ptr glib.Error = nil): ptr glib.Variant00 {.
    importc, libprag.}

proc callWithUnixFdListSync*(self: DBusConnection;
    busName: cstring = nil; objectPath: cstring; interfaceName: cstring; methodName: cstring;
    parameters: glib.Variant = nil; replyType: glib.VariantType = nil; flags: DBusCallFlags;
    timeoutMsec: int; fdList: UnixFDList = nil; outFdList: var UnixFDList = cast[var UnixFDList](nil);
    cancellable: Cancellable = nil): glib.Variant =
  var tmpoutgobjectarg: ptr UnixFDList00
  var gerror: ptr glib.Error
  let impl0 = g_dbus_connection_call_with_unix_fd_list_sync(cast[ptr DBusConnection00](self.impl), busName, objectPath, interfaceName, methodName, if parameters.isNil: nil else: cast[ptr glib.Variant00](parameters.impl), if replyType.isNil: nil else: cast[ptr glib.VariantType00](replyType.impl), flags, int32(timeoutMsec), if fdList.isNil: nil else: cast[ptr UnixFDList00](fdList.impl), cast[var ptr UnixFDList00](if addr(outFdList) == nil: nil else: addr tmpoutgobjectarg), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  fnew(result, finalizerunref)
  result.impl = impl0
#  dothemagic(outFdList
  if addr(outFdList) != nil:
    outFdList = nil

  if tmpoutgobjectarg != nil:
    let argqdata = g_object_get_qdata(tmpoutgobjectarg, Quark)
    if argqdata != nil:
      outFdList = cast[type(outFdList)](argqdata)
      assert(outFdList.impl == tmpoutgobjectarg)
    else:
      fnew(outFdList, gio.finalizeGObject)
      outFdList.impl = tmpoutgobjectarg
      GC_ref(outFdList)
      if g_object_is_floating(outFdList.impl).int != 0:
        discard g_object_ref_sink(outFdList.impl)
      g_object_add_toggle_ref(outFdList.impl, toggleNotify, addr(outFdList[]))
      g_object_unref(outFdList.impl)
      assert(g_object_get_qdata(outFdList.impl, Quark) == nil)
      g_object_set_qdata(outFdList.impl, Quark, addr(outFdList[]))


proc g_dbus_connection_close_sync(self: ptr DBusConnection00; cancellable: ptr Cancellable00;
    error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc closeSync*(self: DBusConnection; cancellable: Cancellable = nil): bool =
  var gerror: ptr glib.Error
  let resul0 = g_dbus_connection_close_sync(cast[ptr DBusConnection00](self.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_dbus_connection_flush_sync(self: ptr DBusConnection00; cancellable: ptr Cancellable00;
    error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc flushSync*(self: DBusConnection; cancellable: Cancellable = nil): bool =
  var gerror: ptr glib.Error
  let resul0 = g_dbus_connection_flush_sync(cast[ptr DBusConnection00](self.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_dbus_connection_send_message_with_reply_sync(self: ptr DBusConnection00;
    message: ptr DBusMessage00; flags: DBusSendMessageFlags; timeoutMsec: int32;
    outSerial: var uint32; cancellable: ptr Cancellable00; error: ptr ptr glib.Error = nil): ptr DBusMessage00 {.
    importc, libprag.}

proc sendMessageWithReplySync*(self: DBusConnection;
    message: DBusMessage; flags: DBusSendMessageFlags; timeoutMsec: int; outSerial: var int = cast[var int](nil);
    cancellable: Cancellable = nil): DBusMessage =
  var gerror: ptr glib.Error
  var outSerial_00: uint32
  let gobj = g_dbus_connection_send_message_with_reply_sync(cast[ptr DBusConnection00](self.impl), cast[ptr DBusMessage00](message.impl), flags, int32(timeoutMsec), outSerial_00, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))
  if outSerial.addr != nil:
    outSerial = int(outSerial_00)

type
  FileMonitorEvent* {.size: sizeof(cint), pure.} = enum
    changed = 0
    changesDoneHint = 1
    deleted = 2
    created = 3
    attributeChanged = 4
    preUnmount = 5
    unmounted = 6
    moved = 7
    renamed = 8
    movedIn = 9
    movedOut = 10

type
  FileMonitor* = ref object of gobject.Object
  FileMonitor00* = object of gobject.Object00

proc g_file_monitor_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(FileMonitor()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc scChanged*(self: FileMonitor;  p: proc (self: ptr FileMonitor00; file: ptr GFile00; otherFile: ptr GFile00; eventType: FileMonitorEvent; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "changed", cast[GCallback](p), xdata, nil, cf)

proc g_file_monitor_cancel(self: ptr FileMonitor00): gboolean {.
    importc, libprag.}

proc cancel*(self: FileMonitor): bool =
  toBool(g_file_monitor_cancel(cast[ptr FileMonitor00](self.impl)))

proc g_file_monitor_emit_event(self: ptr FileMonitor00; child: ptr GFile00;
    otherFile: ptr GFile00; eventType: FileMonitorEvent) {.
    importc, libprag.}

proc emitEvent*(self: FileMonitor; child: GFile; otherFile: GFile;
    eventType: FileMonitorEvent) =
  g_file_monitor_emit_event(cast[ptr FileMonitor00](self.impl), cast[ptr GFile00](child.impl), cast[ptr GFile00](otherFile.impl), eventType)

proc g_file_monitor_is_cancelled(self: ptr FileMonitor00): gboolean {.
    importc, libprag.}

proc isCancelled*(self: FileMonitor): bool =
  toBool(g_file_monitor_is_cancelled(cast[ptr FileMonitor00](self.impl)))

proc g_file_monitor_set_rate_limit(self: ptr FileMonitor00; limitMsecs: int32) {.
    importc, libprag.}

proc setRateLimit*(self: FileMonitor; limitMsecs: int) =
  g_file_monitor_set_rate_limit(cast[ptr FileMonitor00](self.impl), int32(limitMsecs))

proc `rateLimit=`*(self: FileMonitor; limitMsecs: int) =
  g_file_monitor_set_rate_limit(cast[ptr FileMonitor00](self.impl), int32(limitMsecs))

proc g_file_monitor(self: ptr GFile00; flags: FileMonitorFlags; cancellable: ptr Cancellable00;
    error: ptr ptr glib.Error = nil): ptr FileMonitor00 {.
    importc, libprag.}

proc monitor*(self: GFile; flags: FileMonitorFlags; cancellable: Cancellable = nil): FileMonitor =
  var gerror: ptr glib.Error
  let gobj = g_file_monitor(cast[ptr GFile00](self.impl), flags, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_file_monitor_directory(self: ptr GFile00; flags: FileMonitorFlags;
    cancellable: ptr Cancellable00; error: ptr ptr glib.Error = nil): ptr FileMonitor00 {.
    importc, libprag.}

proc monitorDirectory*(self: GFile; flags: FileMonitorFlags; cancellable: Cancellable = nil): FileMonitor =
  var gerror: ptr glib.Error
  let gobj = g_file_monitor_directory(cast[ptr GFile00](self.impl), flags, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_file_monitor_file(self: ptr GFile00; flags: FileMonitorFlags; cancellable: ptr Cancellable00;
    error: ptr ptr glib.Error = nil): ptr FileMonitor00 {.
    importc, libprag.}

proc monitorFile*(self: GFile; flags: FileMonitorFlags; cancellable: Cancellable = nil): FileMonitor =
  var gerror: ptr glib.Error
  let gobj = g_file_monitor_file(cast[ptr GFile00](self.impl), flags, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

type
  FileAttributeInfoList00* {.pure.} = object
  FileAttributeInfoList* = ref object
    impl*: ptr FileAttributeInfoList00
    ignoreFinalizer*: bool

proc g_file_attribute_info_list_get_type*(): GType {.importc, libprag.}

proc gBoxedFreeGFileAttributeInfoList*(self: FileAttributeInfoList) =
  if not self.ignoreFinalizer:
    boxedFree(g_file_attribute_info_list_get_type(), cast[ptr FileAttributeInfoList00](self.impl))

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(FileAttributeInfoList()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    if not self.ignoreFinalizer and self.impl != nil:
      boxedFree(g_file_attribute_info_list_get_type(), cast[ptr FileAttributeInfoList00](self.impl))
      self.impl = nil

proc newWithFinalizer*(x: var FileAttributeInfoList) =
  when defined(gcDestructors):
    new(x)
  else:
    new(x, gBoxedFreeGFileAttributeInfoList)

proc g_file_attribute_info_list_unref(self: ptr FileAttributeInfoList00) {.
    importc, libprag.}

proc unref*(self: FileAttributeInfoList) =
  g_file_attribute_info_list_unref(cast[ptr FileAttributeInfoList00](self.impl))

proc finalizerunref*(self: FileAttributeInfoList) =
  if not self.ignoreFinalizer:
    g_file_attribute_info_list_unref(cast[ptr FileAttributeInfoList00](self.impl))

proc g_file_attribute_info_list_dup(self: ptr FileAttributeInfoList00): ptr FileAttributeInfoList00 {.
    importc, libprag.}

proc dup*(self: FileAttributeInfoList): FileAttributeInfoList =
  fnew(result, gBoxedFreeGFileAttributeInfoList)
  result.impl = g_file_attribute_info_list_dup(cast[ptr FileAttributeInfoList00](self.impl))

proc g_file_attribute_info_list_ref(self: ptr FileAttributeInfoList00): ptr FileAttributeInfoList00 {.
    importc, libprag.}

proc `ref`*(self: FileAttributeInfoList): FileAttributeInfoList =
  fnew(result, gBoxedFreeGFileAttributeInfoList)
  result.impl = g_file_attribute_info_list_ref(cast[ptr FileAttributeInfoList00](self.impl))

proc g_file_attribute_info_list_new(): ptr FileAttributeInfoList00 {.
    importc, libprag.}

proc newFileAttributeInfoList*(): FileAttributeInfoList =
  fnew(result, gBoxedFreeGFileAttributeInfoList)
  result.impl = g_file_attribute_info_list_new()

proc newFileAttributeInfoList*(tdesc: typedesc): tdesc =
  assert(result is FileAttributeInfoList)
  fnew(result, gBoxedFreeGFileAttributeInfoList)
  result.impl = g_file_attribute_info_list_new()

proc initFileAttributeInfoList*[T](result: var T) {.deprecated.} =
  assert(result is FileAttributeInfoList)
  fnew(result, gBoxedFreeGFileAttributeInfoList)
  result.impl = g_file_attribute_info_list_new()

proc g_file_query_settable_attributes(self: ptr GFile00; cancellable: ptr Cancellable00;
    error: ptr ptr glib.Error = nil): ptr FileAttributeInfoList00 {.
    importc, libprag.}

proc querySettableAttributes*(self: GFile; cancellable: Cancellable = nil): FileAttributeInfoList =
  var gerror: ptr glib.Error
  let impl0 = g_file_query_settable_attributes(cast[ptr GFile00](self.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  fnew(result, gBoxedFreeGFileAttributeInfoList)
  result.impl = impl0

proc g_file_query_writable_namespaces(self: ptr GFile00; cancellable: ptr Cancellable00;
    error: ptr ptr glib.Error = nil): ptr FileAttributeInfoList00 {.
    importc, libprag.}

proc queryWritableNamespaces*(self: GFile; cancellable: Cancellable = nil): FileAttributeInfoList =
  var gerror: ptr glib.Error
  let impl0 = g_file_query_writable_namespaces(cast[ptr GFile00](self.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  fnew(result, gBoxedFreeGFileAttributeInfoList)
  result.impl = impl0

type
  FileAttributeInfoFlag* {.size: sizeof(cint), pure.} = enum
    copyWithFile = 0
    copyWhenMoved = 1

  FileAttributeInfoFlags* {.size: sizeof(cint).} = set[FileAttributeInfoFlag]

const
  FileAttributeInfoFlagsNone* = FileAttributeInfoFlags({})
proc none*(t: typedesc[FileAttributeInfoFlags]): FileAttributeInfoFlags = FileAttributeInfoFlags({})

proc g_file_attribute_info_list_add(self: ptr FileAttributeInfoList00; name: cstring;
    `type`: FileAttributeType; flags: FileAttributeInfoFlags) {.
    importc, libprag.}

proc add*(self: FileAttributeInfoList; name: cstring;
    `type`: FileAttributeType; flags: FileAttributeInfoFlags) =
  g_file_attribute_info_list_add(cast[ptr FileAttributeInfoList00](self.impl), name, `type`, flags)

type
  FileAttributeInfo* {.pure, byRef.} = object
    name*: cstring
    `type`*: FileAttributeType
    flags*: FileAttributeInfoFlags

proc g_file_attribute_info_list_lookup(self: ptr FileAttributeInfoList00;
    name: cstring): ptr FileAttributeInfo {.
    importc, libprag.}

proc lookup*(self: FileAttributeInfoList; name: cstring): ptr FileAttributeInfo =
  g_file_attribute_info_list_lookup(cast[ptr FileAttributeInfoList00](self.impl), name)

type
  Notification* = ref object of gobject.Object
  Notification00* = object of gobject.Object00

proc g_notification_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(Notification()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc g_notification_new(title: cstring): ptr Notification00 {.
    importc, libprag.}

proc newNotification*(title: cstring): Notification =
  let gobj = g_notification_new(title)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newNotification*(tdesc: typedesc; title: cstring): tdesc =
  assert(result is Notification)
  let gobj = g_notification_new(title)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initNotification*[T](result: var T; title: cstring) {.deprecated.} =
  assert(result is Notification)
  let gobj = g_notification_new(title)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_notification_add_button(self: ptr Notification00; label: cstring;
    detailedAction: cstring) {.
    importc, libprag.}

proc addButton*(self: Notification; label: cstring; detailedAction: cstring) =
  g_notification_add_button(cast[ptr Notification00](self.impl), label, detailedAction)

proc g_notification_add_button_with_target_value(self: ptr Notification00;
    label: cstring; action: cstring; target: ptr glib.Variant00) {.
    importc, libprag.}

proc addButtonWithTarget*(self: Notification; label: cstring;
    action: cstring; target: glib.Variant = nil) =
  g_notification_add_button_with_target_value(cast[ptr Notification00](self.impl), label, action, if target.isNil: nil else: cast[ptr glib.Variant00](target.impl))

proc g_notification_set_body(self: ptr Notification00; body: cstring) {.
    importc, libprag.}

proc setBody*(self: Notification; body: cstring = nil) =
  g_notification_set_body(cast[ptr Notification00](self.impl), body)

proc `body=`*(self: Notification; body: cstring = nil) =
  g_notification_set_body(cast[ptr Notification00](self.impl), body)

proc g_notification_set_default_action(self: ptr Notification00; detailedAction: cstring) {.
    importc, libprag.}

proc setDefaultAction*(self: Notification; detailedAction: cstring) =
  g_notification_set_default_action(cast[ptr Notification00](self.impl), detailedAction)

proc `defaultAction=`*(self: Notification; detailedAction: cstring) =
  g_notification_set_default_action(cast[ptr Notification00](self.impl), detailedAction)

proc g_notification_set_default_action_and_target_value(self: ptr Notification00;
    action: cstring; target: ptr glib.Variant00) {.
    importc, libprag.}

proc setDefaultActionAndTarget*(self: Notification;
    action: cstring; target: glib.Variant = nil) =
  g_notification_set_default_action_and_target_value(cast[ptr Notification00](self.impl), action, if target.isNil: nil else: cast[ptr glib.Variant00](target.impl))

proc g_notification_set_icon(self: ptr Notification00; icon: ptr Icon00) {.
    importc, libprag.}

proc setIcon*(self: Notification; icon: Icon | Emblem | BytesIcon | FileIcon | EmblemedIcon | ThemedIcon) =
  g_notification_set_icon(cast[ptr Notification00](self.impl), cast[ptr Icon00](icon.impl))

proc `icon=`*(self: Notification; icon: Icon | Emblem | BytesIcon | FileIcon | EmblemedIcon | ThemedIcon) =
  g_notification_set_icon(cast[ptr Notification00](self.impl), cast[ptr Icon00](icon.impl))

proc g_notification_set_title(self: ptr Notification00; title: cstring) {.
    importc, libprag.}

proc setTitle*(self: Notification; title: cstring) =
  g_notification_set_title(cast[ptr Notification00](self.impl), title)

proc `title=`*(self: Notification; title: cstring) =
  g_notification_set_title(cast[ptr Notification00](self.impl), title)

proc g_notification_set_urgent(self: ptr Notification00; urgent: gboolean) {.
    importc, libprag.}

proc setUrgent*(self: Notification; urgent: bool = true) =
  g_notification_set_urgent(cast[ptr Notification00](self.impl), gboolean(urgent))

proc `urgent=`*(self: Notification; urgent: bool) =
  g_notification_set_urgent(cast[ptr Notification00](self.impl), gboolean(urgent))

proc g_application_send_notification(self: ptr GApplication00; id: cstring;
    notification: ptr Notification00) {.
    importc, libprag.}

proc sendNotification*(self: GApplication; id: cstring = nil;
    notification: Notification) =
  g_application_send_notification(cast[ptr GApplication00](self.impl), id, cast[ptr Notification00](notification.impl))

type
  NotificationPriority* {.size: sizeof(cint), pure.} = enum
    normal = 0
    low = 1
    high = 2
    urgent = 3

proc g_notification_set_priority(self: ptr Notification00; priority: NotificationPriority) {.
    importc, libprag.}

proc setPriority*(self: Notification; priority: NotificationPriority) =
  g_notification_set_priority(cast[ptr Notification00](self.impl), priority)

proc `priority=`*(self: Notification; priority: NotificationPriority) =
  g_notification_set_priority(cast[ptr Notification00](self.impl), priority)

type
  ApplicationFlag* {.size: sizeof(cint), pure.} = enum
    isService = 0
    isLauncher = 1
    handlesOpen = 2
    handlesCommandLine = 3
    sendEnvironment = 4
    nonUnique = 5
    canOverrideAppId = 6
    allowReplacement = 7
    replace = 8

  ApplicationFlags* {.size: sizeof(cint).} = set[ApplicationFlag]

const
  ApplicationFlagsFlagsNone* = ApplicationFlags({})
proc flagsNone*(t: typedesc[ApplicationFlags]): ApplicationFlags = ApplicationFlags({})

proc g_application_new(applicationId: cstring; flags: ApplicationFlags): ptr GApplication00 {.
    importc, libprag.}

proc newGApplication*(applicationId: cstring = nil; flags: ApplicationFlags): GApplication =
  let gobj = g_application_new(applicationId, flags)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newGApplication*(tdesc: typedesc; applicationId: cstring = nil; flags: ApplicationFlags): tdesc =
  assert(result is GApplication)
  let gobj = g_application_new(applicationId, flags)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initGApplication*[T](result: var T; applicationId: cstring = nil; flags: ApplicationFlags) {.deprecated.} =
  assert(result is GApplication)
  let gobj = g_application_new(applicationId, flags)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_application_get_flags(self: ptr GApplication00): ApplicationFlags {.
    importc, libprag.}

proc getFlags*(self: GApplication): ApplicationFlags =
  g_application_get_flags(cast[ptr GApplication00](self.impl))

proc flags*(self: GApplication): ApplicationFlags =
  g_application_get_flags(cast[ptr GApplication00](self.impl))

proc g_application_set_flags(self: ptr GApplication00; flags: ApplicationFlags) {.
    importc, libprag.}

proc setFlags*(self: GApplication; flags: ApplicationFlags) =
  g_application_set_flags(cast[ptr GApplication00](self.impl), flags)

proc `flags=`*(self: GApplication; flags: ApplicationFlags) =
  g_application_set_flags(cast[ptr GApplication00](self.impl), flags)

type
  InputStream* = ref object of gobject.Object
  InputStream00* = object of gobject.Object00

proc g_input_stream_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(InputStream()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc g_input_stream_clear_pending(self: ptr InputStream00) {.
    importc, libprag.}

proc clearPending*(self: InputStream) =
  g_input_stream_clear_pending(cast[ptr InputStream00](self.impl))

proc g_input_stream_close(self: ptr InputStream00; cancellable: ptr Cancellable00;
    error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc close*(self: InputStream; cancellable: Cancellable = nil): bool =
  var gerror: ptr glib.Error
  let resul0 = g_input_stream_close(cast[ptr InputStream00](self.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_input_stream_close_finish(self: ptr InputStream00; resu: ptr AsyncResult00;
    error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc closeFinish*(self: InputStream; resu: AsyncResult | SimpleAsyncResult | Task): bool =
  var gerror: ptr glib.Error
  let resul0 = g_input_stream_close_finish(cast[ptr InputStream00](self.impl), cast[ptr AsyncResult00](resu.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_input_stream_has_pending(self: ptr InputStream00): gboolean {.
    importc, libprag.}

proc hasPending*(self: InputStream): bool =
  toBool(g_input_stream_has_pending(cast[ptr InputStream00](self.impl)))

proc g_input_stream_is_closed(self: ptr InputStream00): gboolean {.
    importc, libprag.}

proc isClosed*(self: InputStream): bool =
  toBool(g_input_stream_is_closed(cast[ptr InputStream00](self.impl)))

proc g_input_stream_read(self: ptr InputStream00; buffer: ptr uint8; count: var uint64;
    cancellable: ptr Cancellable00; error: ptr ptr glib.Error = nil): int64 {.
    importc, libprag.}

proc read*(self: InputStream; buffer: var (seq[uint8] | string);
    count: var uint64; cancellable: Cancellable = nil): int64 =
  var gerror: ptr glib.Error
  let resul0 = g_input_stream_read(cast[ptr InputStream00](self.impl), cast[ptr uint8](unsafeaddr(buffer[0])), count, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = resul0

proc g_input_stream_read_all(self: ptr InputStream00; buffer: ptr uint8;
    count: var uint64; bytesRead: var uint64; cancellable: ptr Cancellable00;
    error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc readAll*(self: InputStream; buffer: var (seq[uint8] | string);
    count: var uint64; bytesRead: var uint64; cancellable: Cancellable = nil): bool =
  var gerror: ptr glib.Error
  let resul0 = g_input_stream_read_all(cast[ptr InputStream00](self.impl), cast[ptr uint8](unsafeaddr(buffer[0])), count, bytesRead, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_input_stream_read_all_finish(self: ptr InputStream00; resu: ptr AsyncResult00;
    bytesRead: var uint64; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc readAllFinish*(self: InputStream; resu: AsyncResult | SimpleAsyncResult | Task;
    bytesRead: var uint64): bool =
  var gerror: ptr glib.Error
  let resul0 = g_input_stream_read_all_finish(cast[ptr InputStream00](self.impl), cast[ptr AsyncResult00](resu.impl), bytesRead, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_input_stream_read_bytes(self: ptr InputStream00; count: uint64; cancellable: ptr Cancellable00;
    error: ptr ptr glib.Error = nil): ptr glib.Bytes00 {.
    importc, libprag.}

proc readBytes*(self: InputStream; count: uint64; cancellable: Cancellable = nil): glib.Bytes =
  var gerror: ptr glib.Error
  let impl0 = g_input_stream_read_bytes(cast[ptr InputStream00](self.impl), count, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  fnew(result, gBoxedFreeGBytes)
  result.impl = impl0

proc g_input_stream_read_bytes_finish(self: ptr InputStream00; resu: ptr AsyncResult00;
    error: ptr ptr glib.Error = nil): ptr glib.Bytes00 {.
    importc, libprag.}

proc readBytesFinish*(self: InputStream; resu: AsyncResult | SimpleAsyncResult | Task): glib.Bytes =
  var gerror: ptr glib.Error
  let impl0 = g_input_stream_read_bytes_finish(cast[ptr InputStream00](self.impl), cast[ptr AsyncResult00](resu.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  fnew(result, gBoxedFreeGBytes)
  result.impl = impl0

proc g_input_stream_read_finish(self: ptr InputStream00; resu: ptr AsyncResult00;
    error: ptr ptr glib.Error = nil): int64 {.
    importc, libprag.}

proc readFinish*(self: InputStream; resu: AsyncResult | SimpleAsyncResult | Task): int64 =
  var gerror: ptr glib.Error
  let resul0 = g_input_stream_read_finish(cast[ptr InputStream00](self.impl), cast[ptr AsyncResult00](resu.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = resul0

proc g_input_stream_set_pending(self: ptr InputStream00; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc setPending*(self: InputStream): bool =
  var gerror: ptr glib.Error
  let resul0 = g_input_stream_set_pending(cast[ptr InputStream00](self.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_input_stream_skip(self: ptr InputStream00; count: uint64; cancellable: ptr Cancellable00;
    error: ptr ptr glib.Error = nil): int64 {.
    importc, libprag.}

proc skip*(self: InputStream; count: uint64; cancellable: Cancellable = nil): int64 =
  var gerror: ptr glib.Error
  let resul0 = g_input_stream_skip(cast[ptr InputStream00](self.impl), count, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = resul0

proc g_input_stream_skip_finish(self: ptr InputStream00; resu: ptr AsyncResult00;
    error: ptr ptr glib.Error = nil): int64 {.
    importc, libprag.}

proc skipFinish*(self: InputStream; resu: AsyncResult | SimpleAsyncResult | Task): int64 =
  var gerror: ptr glib.Error
  let resul0 = g_input_stream_skip_finish(cast[ptr InputStream00](self.impl), cast[ptr AsyncResult00](resu.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = resul0

type
  FileInputStream* = ref object of InputStream
  FileInputStream00* = object of InputStream00

proc g_file_input_stream_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(FileInputStream()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc g_file_input_stream_query_info(self: ptr FileInputStream00; attributes: cstring;
    cancellable: ptr Cancellable00; error: ptr ptr glib.Error = nil): ptr FileInfo00 {.
    importc, libprag.}

proc queryInfo*(self: FileInputStream; attributes: cstring;
    cancellable: Cancellable = nil): FileInfo =
  var gerror: ptr glib.Error
  let gobj = g_file_input_stream_query_info(cast[ptr FileInputStream00](self.impl), attributes, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_file_input_stream_query_info_finish(self: ptr FileInputStream00; resu: ptr AsyncResult00;
    error: ptr ptr glib.Error = nil): ptr FileInfo00 {.
    importc, libprag.}

proc queryInfoFinish*(self: FileInputStream; resu: AsyncResult | SimpleAsyncResult | Task): FileInfo =
  var gerror: ptr glib.Error
  let gobj = g_file_input_stream_query_info_finish(cast[ptr FileInputStream00](self.impl), cast[ptr AsyncResult00](resu.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_application_command_line_get_stdin(self: ptr ApplicationCommandLine00): ptr InputStream00 {.
    importc, libprag.}

proc getStdin*(self: ApplicationCommandLine): InputStream =
  let gobj = g_application_command_line_get_stdin(cast[ptr ApplicationCommandLine00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc stdin*(self: ApplicationCommandLine): InputStream =
  let gobj = g_application_command_line_get_stdin(cast[ptr ApplicationCommandLine00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_file_read(self: ptr GFile00; cancellable: ptr Cancellable00; error: ptr ptr glib.Error = nil): ptr FileInputStream00 {.
    importc, libprag.}

proc read*(self: GFile; cancellable: Cancellable = nil): FileInputStream =
  var gerror: ptr glib.Error
  let gobj = g_file_read(cast[ptr GFile00](self.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_file_read_finish(self: ptr GFile00; res: ptr AsyncResult00; error: ptr ptr glib.Error = nil): ptr FileInputStream00 {.
    importc, libprag.}

proc readFinish*(self: GFile; res: AsyncResult | SimpleAsyncResult | Task): FileInputStream =
  var gerror: ptr glib.Error
  let gobj = g_file_read_finish(cast[ptr GFile00](self.impl), cast[ptr AsyncResult00](res.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_io_stream_get_input_stream(self: ptr IOStream00): ptr InputStream00 {.
    importc, libprag.}

proc getInputStream*(self: IOStream): InputStream =
  let gobj = g_io_stream_get_input_stream(cast[ptr IOStream00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc inputStream*(self: IOStream): InputStream =
  let gobj = g_io_stream_get_input_stream(cast[ptr IOStream00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

type
  OutputStreamSpliceFlag* {.size: sizeof(cint), pure.} = enum
    closeSource = 0
    closeTarget = 1

  OutputStreamSpliceFlags* {.size: sizeof(cint).} = set[OutputStreamSpliceFlag]

const
  OutputStreamSpliceFlagsNone* = OutputStreamSpliceFlags({})
proc none*(t: typedesc[OutputStreamSpliceFlags]): OutputStreamSpliceFlags = OutputStreamSpliceFlags({})

proc g_output_stream_splice(self: ptr OutputStream00; source: ptr InputStream00;
    flags: OutputStreamSpliceFlags; cancellable: ptr Cancellable00; error: ptr ptr glib.Error = nil): int64 {.
    importc, libprag.}

proc splice*(self: OutputStream; source: InputStream; flags: OutputStreamSpliceFlags;
    cancellable: Cancellable = nil): int64 =
  var gerror: ptr glib.Error
  let resul0 = g_output_stream_splice(cast[ptr OutputStream00](self.impl), cast[ptr InputStream00](source.impl), flags, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = resul0

type
  ActionMap00* = object of gobject.Object00
  ActionMap* = ref object of gobject.Object

proc g_action_map_add_action*(self: ptr ActionMap00; action: ptr Action00) {.
    importc, libprag.}

proc addAction*(self: ActionMap | GApplication | SimpleActionGroup;
    action: Action | PropertyAction | SimpleAction) =
  g_action_map_add_action(cast[ptr ActionMap00](self.impl), cast[ptr Action00](action.impl))

proc g_action_map_add_action_entries(self: ptr ActionMap00; entries: ptr ActionEntry00;
    nEntries: int32; userData: pointer) {.
    importc, libprag.}

proc addActionEntries*(self: ActionMap | GApplication | SimpleActionGroup;
    entries: ptr ActionEntry00; nEntries: int; userData: pointer) =
  g_action_map_add_action_entries(cast[ptr ActionMap00](self.impl), entries, int32(nEntries), userData)

proc g_action_map_lookup_action(self: ptr ActionMap00; actionName: cstring): ptr Action00 {.
    importc, libprag.}

proc lookupAction*(self: ActionMap | GApplication | SimpleActionGroup;
    actionName: cstring): Action =
  let gobj = g_action_map_lookup_action(cast[ptr ActionMap00](self.impl), actionName)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_action_map_remove_action(self: ptr ActionMap00; actionName: cstring) {.
    importc, libprag.}

proc removeAction*(self: ActionMap | GApplication | SimpleActionGroup;
    actionName: cstring) =
  g_action_map_remove_action(cast[ptr ActionMap00](self.impl), actionName)

type
  AppInfoMonitor* = ref object of gobject.Object
  AppInfoMonitor00* = object of gobject.Object00

proc g_app_info_monitor_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(AppInfoMonitor()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc scChanged*(self: AppInfoMonitor;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "changed", cast[GCallback](p), xdata, nil, cf)

proc g_app_info_monitor_get(): ptr AppInfoMonitor00 {.
    importc, libprag.}

proc getAppInfoMonitor*(): AppInfoMonitor =
  let gobj = g_app_info_monitor_get()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

type
  AsyncInitable00* = object of gobject.Object00
  AsyncInitable* = ref object of gobject.Object

type
  DBusProxy* = ref object of gobject.Object
  DBusProxy00* = object of gobject.Object00

proc g_dbus_proxy_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(DBusProxy()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc scGPropertiesChanged*(self: DBusProxy;  p: proc (self: ptr DBusProxy00; changedProperties: ptr glib.Variant00; invalidatedProperties: ptr cstring; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "g-properties-changed", cast[GCallback](p), xdata, nil, cf)

proc scGSignal*(self: DBusProxy;  p: proc (self: ptr DBusProxy00; senderName: cstring; signalName: cstring; parameters: ptr glib.Variant00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "g-signal", cast[GCallback](p), xdata, nil, cf)

proc g_dbus_proxy_new_finish(res: ptr AsyncResult00; error: ptr ptr glib.Error = nil): ptr DBusProxy00 {.
    importc, libprag.}

proc newDBusProxyFinish*(res: AsyncResult | SimpleAsyncResult | Task): DBusProxy =
  var gerror: ptr glib.Error
  let gobj = g_dbus_proxy_new_finish(cast[ptr AsyncResult00](res.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newDBusProxyFinish*(tdesc: typedesc; res: AsyncResult | SimpleAsyncResult | Task): tdesc =
  var gerror: ptr glib.Error
  assert(result is DBusProxy)
  let gobj = g_dbus_proxy_new_finish(cast[ptr AsyncResult00](res.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initDBusProxyFinish*[T](result: var T; res: AsyncResult | SimpleAsyncResult | Task) {.deprecated.} =
  var gerror: ptr glib.Error
  assert(result is DBusProxy)
  let gobj = g_dbus_proxy_new_finish(cast[ptr AsyncResult00](res.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_dbus_proxy_new_for_bus_finish(res: ptr AsyncResult00; error: ptr ptr glib.Error = nil): ptr DBusProxy00 {.
    importc, libprag.}

proc newDBusProxyForBusFinish*(res: AsyncResult | SimpleAsyncResult | Task): DBusProxy =
  var gerror: ptr glib.Error
  let gobj = g_dbus_proxy_new_for_bus_finish(cast[ptr AsyncResult00](res.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newDBusProxyForBusFinish*(tdesc: typedesc; res: AsyncResult | SimpleAsyncResult | Task): tdesc =
  var gerror: ptr glib.Error
  assert(result is DBusProxy)
  let gobj = g_dbus_proxy_new_for_bus_finish(cast[ptr AsyncResult00](res.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initDBusProxyForBusFinish*[T](result: var T; res: AsyncResult | SimpleAsyncResult | Task) {.deprecated.} =
  var gerror: ptr glib.Error
  assert(result is DBusProxy)
  let gobj = g_dbus_proxy_new_for_bus_finish(cast[ptr AsyncResult00](res.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_dbus_proxy_call_finish(self: ptr DBusProxy00; res: ptr AsyncResult00;
    error: ptr ptr glib.Error = nil): ptr glib.Variant00 {.
    importc, libprag.}

proc callFinish*(self: DBusProxy; res: AsyncResult | SimpleAsyncResult | Task): glib.Variant =
  var gerror: ptr glib.Error
  let impl0 = g_dbus_proxy_call_finish(cast[ptr DBusProxy00](self.impl), cast[ptr AsyncResult00](res.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  fnew(result, finalizerunref)
  result.impl = impl0

proc g_dbus_proxy_call_sync(self: ptr DBusProxy00; methodName: cstring; parameters: ptr glib.Variant00;
    flags: DBusCallFlags; timeoutMsec: int32; cancellable: ptr Cancellable00;
    error: ptr ptr glib.Error = nil): ptr glib.Variant00 {.
    importc, libprag.}

proc callSync*(self: DBusProxy; methodName: cstring; parameters: glib.Variant = nil;
    flags: DBusCallFlags; timeoutMsec: int; cancellable: Cancellable = nil): glib.Variant =
  var gerror: ptr glib.Error
  let impl0 = g_dbus_proxy_call_sync(cast[ptr DBusProxy00](self.impl), methodName, if parameters.isNil: nil else: cast[ptr glib.Variant00](parameters.impl), flags, int32(timeoutMsec), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  fnew(result, finalizerunref)
  result.impl = impl0

proc g_dbus_proxy_call_with_unix_fd_list_finish(self: ptr DBusProxy00; outFdList: var ptr UnixFDList00;
    res: ptr AsyncResult00; error: ptr ptr glib.Error = nil): ptr glib.Variant00 {.
    importc, libprag.}

proc callWithUnixFdListFinish*(self: DBusProxy; outFdList: var UnixFDList = cast[var UnixFDList](nil);
    res: AsyncResult | SimpleAsyncResult | Task): glib.Variant =
  var tmpoutgobjectarg: ptr UnixFDList00
  var gerror: ptr glib.Error
  let impl0 = g_dbus_proxy_call_with_unix_fd_list_finish(cast[ptr DBusProxy00](self.impl), cast[var ptr UnixFDList00](if addr(outFdList) == nil: nil else: addr tmpoutgobjectarg), cast[ptr AsyncResult00](res.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  fnew(result, finalizerunref)
  result.impl = impl0
#  dothemagic(outFdList
  if addr(outFdList) != nil:
    outFdList = nil

  if tmpoutgobjectarg != nil:
    let argqdata = g_object_get_qdata(tmpoutgobjectarg, Quark)
    if argqdata != nil:
      outFdList = cast[type(outFdList)](argqdata)
      assert(outFdList.impl == tmpoutgobjectarg)
    else:
      fnew(outFdList, gio.finalizeGObject)
      outFdList.impl = tmpoutgobjectarg
      GC_ref(outFdList)
      if g_object_is_floating(outFdList.impl).int != 0:
        discard g_object_ref_sink(outFdList.impl)
      g_object_add_toggle_ref(outFdList.impl, toggleNotify, addr(outFdList[]))
      g_object_unref(outFdList.impl)
      assert(g_object_get_qdata(outFdList.impl, Quark) == nil)
      g_object_set_qdata(outFdList.impl, Quark, addr(outFdList[]))


proc g_dbus_proxy_call_with_unix_fd_list_sync(self: ptr DBusProxy00; methodName: cstring;
    parameters: ptr glib.Variant00; flags: DBusCallFlags; timeoutMsec: int32;
    fdList: ptr UnixFDList00; outFdList: var ptr UnixFDList00; cancellable: ptr Cancellable00;
    error: ptr ptr glib.Error = nil): ptr glib.Variant00 {.
    importc, libprag.}

proc callWithUnixFdListSync*(self: DBusProxy; methodName: cstring;
    parameters: glib.Variant = nil; flags: DBusCallFlags; timeoutMsec: int;
    fdList: UnixFDList = nil; outFdList: var UnixFDList = cast[var UnixFDList](nil);
    cancellable: Cancellable = nil): glib.Variant =
  var tmpoutgobjectarg: ptr UnixFDList00
  var gerror: ptr glib.Error
  let impl0 = g_dbus_proxy_call_with_unix_fd_list_sync(cast[ptr DBusProxy00](self.impl), methodName, if parameters.isNil: nil else: cast[ptr glib.Variant00](parameters.impl), flags, int32(timeoutMsec), if fdList.isNil: nil else: cast[ptr UnixFDList00](fdList.impl), cast[var ptr UnixFDList00](if addr(outFdList) == nil: nil else: addr tmpoutgobjectarg), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  fnew(result, finalizerunref)
  result.impl = impl0
#  dothemagic(outFdList
  if addr(outFdList) != nil:
    outFdList = nil

  if tmpoutgobjectarg != nil:
    let argqdata = g_object_get_qdata(tmpoutgobjectarg, Quark)
    if argqdata != nil:
      outFdList = cast[type(outFdList)](argqdata)
      assert(outFdList.impl == tmpoutgobjectarg)
    else:
      fnew(outFdList, gio.finalizeGObject)
      outFdList.impl = tmpoutgobjectarg
      GC_ref(outFdList)
      if g_object_is_floating(outFdList.impl).int != 0:
        discard g_object_ref_sink(outFdList.impl)
      g_object_add_toggle_ref(outFdList.impl, toggleNotify, addr(outFdList[]))
      g_object_unref(outFdList.impl)
      assert(g_object_get_qdata(outFdList.impl, Quark) == nil)
      g_object_set_qdata(outFdList.impl, Quark, addr(outFdList[]))


proc g_dbus_proxy_get_cached_property(self: ptr DBusProxy00; propertyName: cstring): ptr glib.Variant00 {.
    importc, libprag.}

proc getCachedProperty*(self: DBusProxy; propertyName: cstring): glib.Variant =
  let impl0 = g_dbus_proxy_get_cached_property(cast[ptr DBusProxy00](self.impl), propertyName)
  if impl0.isNil:
    return nil
  fnew(result, finalizerunref)
  result.impl = impl0

proc g_dbus_proxy_get_cached_property_names(self: ptr DBusProxy00): ptr cstring {.
    importc, libprag.}

proc getCachedPropertyNames*(self: DBusProxy): seq[string] =
  let resul0 = g_dbus_proxy_get_cached_property_names(cast[ptr DBusProxy00](self.impl))
  if resul0.isNil:
    return
  result = cstringArrayToSeq(resul0)
  g_strfreev(resul0)

proc cachedPropertyNames*(self: DBusProxy): seq[string] =
  let resul0 = g_dbus_proxy_get_cached_property_names(cast[ptr DBusProxy00](self.impl))
  if resul0.isNil:
    return
  result = cstringArrayToSeq(resul0)
  g_strfreev(resul0)

proc g_dbus_proxy_get_connection(self: ptr DBusProxy00): ptr DBusConnection00 {.
    importc, libprag.}

proc getConnection*(self: DBusProxy): DBusConnection =
  let gobj = g_dbus_proxy_get_connection(cast[ptr DBusProxy00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc connection*(self: DBusProxy): DBusConnection =
  let gobj = g_dbus_proxy_get_connection(cast[ptr DBusProxy00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_dbus_proxy_get_default_timeout(self: ptr DBusProxy00): int32 {.
    importc, libprag.}

proc getDefaultTimeout*(self: DBusProxy): int =
  int(g_dbus_proxy_get_default_timeout(cast[ptr DBusProxy00](self.impl)))

proc defaultTimeout*(self: DBusProxy): int =
  int(g_dbus_proxy_get_default_timeout(cast[ptr DBusProxy00](self.impl)))

proc g_dbus_proxy_get_interface_info(self: ptr DBusProxy00): ptr DBusInterfaceInfo00 {.
    importc, libprag.}

proc getInterfaceInfo*(self: DBusProxy): DBusInterfaceInfo =
  let impl0 = g_dbus_proxy_get_interface_info(cast[ptr DBusProxy00](self.impl))
  if impl0.isNil:
    return nil
  fnew(result, gBoxedFreeGDBusInterfaceInfo)
  result.impl = cast[typeof(result.impl)](g_boxed_copy(g_dbus_interface_info_get_type(), impl0))

proc interfaceInfo*(self: DBusProxy): DBusInterfaceInfo =
  let impl0 = g_dbus_proxy_get_interface_info(cast[ptr DBusProxy00](self.impl))
  if impl0.isNil:
    return nil
  fnew(result, gBoxedFreeGDBusInterfaceInfo)
  result.impl = cast[typeof(result.impl)](g_boxed_copy(g_dbus_interface_info_get_type(), impl0))

proc g_dbus_proxy_get_interface_name(self: ptr DBusProxy00): cstring {.
    importc, libprag.}

proc getInterfaceName*(self: DBusProxy): string =
  result = $g_dbus_proxy_get_interface_name(cast[ptr DBusProxy00](self.impl))

proc interfaceName*(self: DBusProxy): string =
  result = $g_dbus_proxy_get_interface_name(cast[ptr DBusProxy00](self.impl))

proc g_dbus_proxy_get_name(self: ptr DBusProxy00): cstring {.
    importc, libprag.}

proc getName*(self: DBusProxy): string =
  result = $g_dbus_proxy_get_name(cast[ptr DBusProxy00](self.impl))

proc name*(self: DBusProxy): string =
  result = $g_dbus_proxy_get_name(cast[ptr DBusProxy00](self.impl))

proc g_dbus_proxy_get_name_owner(self: ptr DBusProxy00): cstring {.
    importc, libprag.}

proc getNameOwner*(self: DBusProxy): string =
  let resul0 = g_dbus_proxy_get_name_owner(cast[ptr DBusProxy00](self.impl))
  if resul0.isNil:
    return
  result = $resul0
  cogfree(resul0)

proc nameOwner*(self: DBusProxy): string =
  let resul0 = g_dbus_proxy_get_name_owner(cast[ptr DBusProxy00](self.impl))
  if resul0.isNil:
    return
  result = $resul0
  cogfree(resul0)

proc g_dbus_proxy_get_object_path(self: ptr DBusProxy00): cstring {.
    importc, libprag.}

proc getObjectPath*(self: DBusProxy): string =
  result = $g_dbus_proxy_get_object_path(cast[ptr DBusProxy00](self.impl))

proc objectPath*(self: DBusProxy): string =
  result = $g_dbus_proxy_get_object_path(cast[ptr DBusProxy00](self.impl))

proc g_dbus_proxy_set_cached_property(self: ptr DBusProxy00; propertyName: cstring;
    value: ptr glib.Variant00) {.
    importc, libprag.}

proc setCachedProperty*(self: DBusProxy; propertyName: cstring;
    value: glib.Variant = nil) =
  g_dbus_proxy_set_cached_property(cast[ptr DBusProxy00](self.impl), propertyName, if value.isNil: nil else: cast[ptr glib.Variant00](value.impl))

proc g_dbus_proxy_set_default_timeout(self: ptr DBusProxy00; timeoutMsec: int32) {.
    importc, libprag.}

proc setDefaultTimeout*(self: DBusProxy; timeoutMsec: int) =
  g_dbus_proxy_set_default_timeout(cast[ptr DBusProxy00](self.impl), int32(timeoutMsec))

proc `defaultTimeout=`*(self: DBusProxy; timeoutMsec: int) =
  g_dbus_proxy_set_default_timeout(cast[ptr DBusProxy00](self.impl), int32(timeoutMsec))

proc g_dbus_proxy_set_interface_info(self: ptr DBusProxy00; info: ptr DBusInterfaceInfo00) {.
    importc, libprag.}

proc setInterfaceInfo*(self: DBusProxy; info: DBusInterfaceInfo = nil) =
  g_dbus_proxy_set_interface_info(cast[ptr DBusProxy00](self.impl), if info.isNil: nil else: cast[ptr DBusInterfaceInfo00](info.impl))

proc `interfaceInfo=`*(self: DBusProxy; info: DBusInterfaceInfo = nil) =
  g_dbus_proxy_set_interface_info(cast[ptr DBusProxy00](self.impl), if info.isNil: nil else: cast[ptr DBusInterfaceInfo00](info.impl))

type
  DBusObjectProxy* = ref object of gobject.Object
  DBusObjectProxy00* = object of gobject.Object00

proc g_dbus_object_proxy_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(DBusObjectProxy()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc g_dbus_object_proxy_new(connection: ptr DBusConnection00; objectPath: cstring): ptr DBusObjectProxy00 {.
    importc, libprag.}

proc newDBusObjectProxy*(connection: DBusConnection; objectPath: cstring): DBusObjectProxy =
  let gobj = g_dbus_object_proxy_new(cast[ptr DBusConnection00](connection.impl), objectPath)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newDBusObjectProxy*(tdesc: typedesc; connection: DBusConnection; objectPath: cstring): tdesc =
  assert(result is DBusObjectProxy)
  let gobj = g_dbus_object_proxy_new(cast[ptr DBusConnection00](connection.impl), objectPath)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initDBusObjectProxy*[T](result: var T; connection: DBusConnection; objectPath: cstring) {.deprecated.} =
  assert(result is DBusObjectProxy)
  let gobj = g_dbus_object_proxy_new(cast[ptr DBusConnection00](connection.impl), objectPath)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_dbus_object_proxy_get_connection(self: ptr DBusObjectProxy00): ptr DBusConnection00 {.
    importc, libprag.}

proc getConnection*(self: DBusObjectProxy): DBusConnection =
  let gobj = g_dbus_object_proxy_get_connection(cast[ptr DBusObjectProxy00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc connection*(self: DBusObjectProxy): DBusConnection =
  let gobj = g_dbus_object_proxy_get_connection(cast[ptr DBusObjectProxy00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

type
  DBusObjectManagerClient* = ref object of gobject.Object
  DBusObjectManagerClient00* = object of gobject.Object00

proc g_dbus_object_manager_client_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(DBusObjectManagerClient()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc scInterfaceProxyPropertiesChanged*(self: DBusObjectManagerClient;  p: proc (self: ptr DBusObjectManagerClient00; objectProxy: ptr DBusObjectProxy00; interfaceProxy: ptr DBusProxy00;
    changedProperties: ptr glib.Variant00; invalidatedProperties: ptr cstring; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "interface-proxy-properties-changed", cast[GCallback](p), xdata, nil, cf)

proc scInterfaceProxySignal*(self: DBusObjectManagerClient;  p: proc (self: ptr DBusObjectManagerClient00; objectProxy: ptr DBusObjectProxy00; interfaceProxy: ptr DBusProxy00;
    senderName: cstring; signalName: cstring; parameters: ptr glib.Variant00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "interface-proxy-signal", cast[GCallback](p), xdata, nil, cf)

proc g_dbus_object_manager_client_new_finish(res: ptr AsyncResult00; error: ptr ptr glib.Error = nil): ptr DBusObjectManagerClient00 {.
    importc, libprag.}

proc newDBusObjectManagerClientFinish*(res: AsyncResult | SimpleAsyncResult | Task): DBusObjectManagerClient =
  var gerror: ptr glib.Error
  let gobj = g_dbus_object_manager_client_new_finish(cast[ptr AsyncResult00](res.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newDBusObjectManagerClientFinish*(tdesc: typedesc; res: AsyncResult | SimpleAsyncResult | Task): tdesc =
  var gerror: ptr glib.Error
  assert(result is DBusObjectManagerClient)
  let gobj = g_dbus_object_manager_client_new_finish(cast[ptr AsyncResult00](res.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initDBusObjectManagerClientFinish*[T](result: var T; res: AsyncResult | SimpleAsyncResult | Task) {.deprecated.} =
  var gerror: ptr glib.Error
  assert(result is DBusObjectManagerClient)
  let gobj = g_dbus_object_manager_client_new_finish(cast[ptr AsyncResult00](res.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_dbus_object_manager_client_new_for_bus_finish(res: ptr AsyncResult00;
    error: ptr ptr glib.Error = nil): ptr DBusObjectManagerClient00 {.
    importc, libprag.}

proc newDBusObjectManagerClientForBusFinish*(res: AsyncResult | SimpleAsyncResult | Task): DBusObjectManagerClient =
  var gerror: ptr glib.Error
  let gobj = g_dbus_object_manager_client_new_for_bus_finish(cast[ptr AsyncResult00](res.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newDBusObjectManagerClientForBusFinish*(tdesc: typedesc; res: AsyncResult | SimpleAsyncResult | Task): tdesc =
  var gerror: ptr glib.Error
  assert(result is DBusObjectManagerClient)
  let gobj = g_dbus_object_manager_client_new_for_bus_finish(cast[ptr AsyncResult00](res.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initDBusObjectManagerClientForBusFinish*[T](result: var T; res: AsyncResult | SimpleAsyncResult | Task) {.deprecated.} =
  var gerror: ptr glib.Error
  assert(result is DBusObjectManagerClient)
  let gobj = g_dbus_object_manager_client_new_for_bus_finish(cast[ptr AsyncResult00](res.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_dbus_object_manager_client_get_connection(self: ptr DBusObjectManagerClient00): ptr DBusConnection00 {.
    importc, libprag.}

proc getConnection*(self: DBusObjectManagerClient): DBusConnection =
  let gobj = g_dbus_object_manager_client_get_connection(cast[ptr DBusObjectManagerClient00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc connection*(self: DBusObjectManagerClient): DBusConnection =
  let gobj = g_dbus_object_manager_client_get_connection(cast[ptr DBusObjectManagerClient00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_dbus_object_manager_client_get_name(self: ptr DBusObjectManagerClient00): cstring {.
    importc, libprag.}

proc getName*(self: DBusObjectManagerClient): string =
  result = $g_dbus_object_manager_client_get_name(cast[ptr DBusObjectManagerClient00](self.impl))

proc name*(self: DBusObjectManagerClient): string =
  result = $g_dbus_object_manager_client_get_name(cast[ptr DBusObjectManagerClient00](self.impl))

proc g_dbus_object_manager_client_get_name_owner(self: ptr DBusObjectManagerClient00): cstring {.
    importc, libprag.}

proc getNameOwner*(self: DBusObjectManagerClient): string =
  let resul0 = g_dbus_object_manager_client_get_name_owner(cast[ptr DBusObjectManagerClient00](self.impl))
  if resul0.isNil:
    return
  result = $resul0
  cogfree(resul0)

proc nameOwner*(self: DBusObjectManagerClient): string =
  let resul0 = g_dbus_object_manager_client_get_name_owner(cast[ptr DBusObjectManagerClient00](self.impl))
  if resul0.isNil:
    return
  result = $resul0
  cogfree(resul0)

proc g_async_initable_init_finish(self: ptr AsyncInitable00; res: ptr AsyncResult00;
    error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc initFinish*(self: AsyncInitable | DBusProxy | DBusObjectManagerClient | DBusConnection;
    res: AsyncResult | SimpleAsyncResult | Task): bool =
  var gerror: ptr glib.Error
  let resul0 = g_async_initable_init_finish(cast[ptr AsyncInitable00](self.impl), cast[ptr AsyncResult00](res.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_async_initable_new_finish(self: ptr AsyncInitable00; res: ptr AsyncResult00;
    error: ptr ptr glib.Error = nil): ptr gobject.Object00 {.
    importc, libprag.}

proc newAsyncInitableFinish*(self: AsyncInitable | DBusProxy | DBusObjectManagerClient | DBusConnection;
    res: AsyncResult | SimpleAsyncResult | Task): gobject.Object =
  var gerror: ptr glib.Error
  let gobj = g_async_initable_new_finish(cast[ptr AsyncInitable00](self.impl), cast[ptr AsyncResult00](res.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gobject.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

type
  DBusObjectManagerClientFlag* {.size: sizeof(cint), pure.} = enum
    doNotAutoStart = 0

  DBusObjectManagerClientFlags* {.size: sizeof(cint).} = set[DBusObjectManagerClientFlag]

const
  DBusObjectManagerClientFlagsNone* = DBusObjectManagerClientFlags({})
proc none*(t: typedesc[DBusObjectManagerClientFlags]): DBusObjectManagerClientFlags = DBusObjectManagerClientFlags({})

proc g_dbus_object_manager_client_get_flags(self: ptr DBusObjectManagerClient00): DBusObjectManagerClientFlags {.
    importc, libprag.}

proc getFlags*(self: DBusObjectManagerClient): DBusObjectManagerClientFlags =
  g_dbus_object_manager_client_get_flags(cast[ptr DBusObjectManagerClient00](self.impl))

proc flags*(self: DBusObjectManagerClient): DBusObjectManagerClientFlags =
  g_dbus_object_manager_client_get_flags(cast[ptr DBusObjectManagerClient00](self.impl))

type
  BusType* {.size: sizeof(cint), pure.} = enum
    starter = -1
    none = 0
    system = 1
    session = 2

type
  DBusProxyFlag* {.size: sizeof(cint), pure.} = enum
    doNotLoadProperties = 0
    doNotConnectSignals = 1
    doNotAutoStart = 2
    getInvalidatedProperties = 3
    doNotAutoStartAtConstruction = 4

  DBusProxyFlags* {.size: sizeof(cint).} = set[DBusProxyFlag]

const
  DBusProxyFlagsNone* = DBusProxyFlags({})
proc none*(t: typedesc[DBusProxyFlags]): DBusProxyFlags = DBusProxyFlags({})

proc g_dbus_proxy_new_for_bus_sync(busType: BusType; flags: DBusProxyFlags;
    info: ptr DBusInterfaceInfo00; name: cstring; objectPath: cstring; interfaceName: cstring;
    cancellable: ptr Cancellable00; error: ptr ptr glib.Error = nil): ptr DBusProxy00 {.
    importc, libprag.}

proc newDBusProxyForBusSync*(busType: BusType; flags: DBusProxyFlags;
    info: DBusInterfaceInfo = nil; name: cstring; objectPath: cstring; interfaceName: cstring;
    cancellable: Cancellable = nil): DBusProxy =
  var gerror: ptr glib.Error
  let gobj = g_dbus_proxy_new_for_bus_sync(busType, flags, if info.isNil: nil else: cast[ptr DBusInterfaceInfo00](info.impl), name, objectPath, interfaceName, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newDBusProxyForBusSync*(tdesc: typedesc; busType: BusType; flags: DBusProxyFlags;
    info: DBusInterfaceInfo = nil; name: cstring; objectPath: cstring; interfaceName: cstring;
    cancellable: Cancellable = nil): tdesc =
  var gerror: ptr glib.Error
  assert(result is DBusProxy)
  let gobj = g_dbus_proxy_new_for_bus_sync(busType, flags, if info.isNil: nil else: cast[ptr DBusInterfaceInfo00](info.impl), name, objectPath, interfaceName, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initDBusProxyForBusSync*[T](result: var T; busType: BusType; flags: DBusProxyFlags;
    info: DBusInterfaceInfo = nil; name: cstring; objectPath: cstring; interfaceName: cstring;
    cancellable: Cancellable = nil) {.deprecated.} =
  var gerror: ptr glib.Error
  assert(result is DBusProxy)
  let gobj = g_dbus_proxy_new_for_bus_sync(busType, flags, if info.isNil: nil else: cast[ptr DBusInterfaceInfo00](info.impl), name, objectPath, interfaceName, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_dbus_proxy_new_sync(connection: ptr DBusConnection00; flags: DBusProxyFlags;
    info: ptr DBusInterfaceInfo00; name: cstring; objectPath: cstring; interfaceName: cstring;
    cancellable: ptr Cancellable00; error: ptr ptr glib.Error = nil): ptr DBusProxy00 {.
    importc, libprag.}

proc newDBusProxySync*(connection: DBusConnection; flags: DBusProxyFlags;
    info: DBusInterfaceInfo = nil; name: cstring = nil; objectPath: cstring;
    interfaceName: cstring; cancellable: Cancellable = nil): DBusProxy =
  var gerror: ptr glib.Error
  let gobj = g_dbus_proxy_new_sync(cast[ptr DBusConnection00](connection.impl), flags, if info.isNil: nil else: cast[ptr DBusInterfaceInfo00](info.impl), name, objectPath, interfaceName, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newDBusProxySync*(tdesc: typedesc; connection: DBusConnection; flags: DBusProxyFlags;
    info: DBusInterfaceInfo = nil; name: cstring = nil; objectPath: cstring;
    interfaceName: cstring; cancellable: Cancellable = nil): tdesc =
  var gerror: ptr glib.Error
  assert(result is DBusProxy)
  let gobj = g_dbus_proxy_new_sync(cast[ptr DBusConnection00](connection.impl), flags, if info.isNil: nil else: cast[ptr DBusInterfaceInfo00](info.impl), name, objectPath, interfaceName, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initDBusProxySync*[T](result: var T; connection: DBusConnection; flags: DBusProxyFlags;
    info: DBusInterfaceInfo = nil; name: cstring = nil; objectPath: cstring;
    interfaceName: cstring; cancellable: Cancellable = nil) {.deprecated.} =
  var gerror: ptr glib.Error
  assert(result is DBusProxy)
  let gobj = g_dbus_proxy_new_sync(cast[ptr DBusConnection00](connection.impl), flags, if info.isNil: nil else: cast[ptr DBusInterfaceInfo00](info.impl), name, objectPath, interfaceName, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_dbus_proxy_get_flags(self: ptr DBusProxy00): DBusProxyFlags {.
    importc, libprag.}

proc getFlags*(self: DBusProxy): DBusProxyFlags =
  g_dbus_proxy_get_flags(cast[ptr DBusProxy00](self.impl))

proc flags*(self: DBusProxy): DBusProxyFlags =
  g_dbus_proxy_get_flags(cast[ptr DBusProxy00](self.impl))

type
  AsyncReadyCallback* = proc (sourceObject: ptr gobject.Object00; res: ptr AsyncResult00; userData: pointer) {.cdecl.}

proc g_file_append_to_async(self: ptr GFile00; flags: FileCreateFlags; ioPriority: int32;
    cancellable: ptr Cancellable00; callback: AsyncReadyCallback; userData: pointer) {.
    importc, libprag.}

proc appendToAsync*(self: GFile; flags: FileCreateFlags; ioPriority: int;
    cancellable: Cancellable = nil; callback: AsyncReadyCallback; userData: pointer) =
  g_file_append_to_async(cast[ptr GFile00](self.impl), flags, int32(ioPriority), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_file_create_async(self: ptr GFile00; flags: FileCreateFlags; ioPriority: int32;
    cancellable: ptr Cancellable00; callback: AsyncReadyCallback; userData: pointer) {.
    importc, libprag.}

proc createAsync*(self: GFile; flags: FileCreateFlags; ioPriority: int;
    cancellable: Cancellable = nil; callback: AsyncReadyCallback; userData: pointer) =
  g_file_create_async(cast[ptr GFile00](self.impl), flags, int32(ioPriority), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_file_create_readwrite_async(self: ptr GFile00; flags: FileCreateFlags;
    ioPriority: int32; cancellable: ptr Cancellable00; callback: AsyncReadyCallback;
    userData: pointer) {.
    importc, libprag.}

proc createReadwriteAsync*(self: GFile; flags: FileCreateFlags; ioPriority: int;
    cancellable: Cancellable = nil; callback: AsyncReadyCallback; userData: pointer) =
  g_file_create_readwrite_async(cast[ptr GFile00](self.impl), flags, int32(ioPriority), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_file_delete_async(self: ptr GFile00; ioPriority: int32; cancellable: ptr Cancellable00;
    callback: AsyncReadyCallback; userData: pointer) {.
    importc, libprag.}

proc deleteAsync*(self: GFile; ioPriority: int; cancellable: Cancellable = nil;
    callback: AsyncReadyCallback; userData: pointer) =
  g_file_delete_async(cast[ptr GFile00](self.impl), int32(ioPriority), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_file_eject_mountable(self: ptr GFile00; flags: MountUnmountFlags;
    cancellable: ptr Cancellable00; callback: AsyncReadyCallback; userData: pointer) {.
    importc, libprag.}

proc ejectMountable*(self: GFile; flags: MountUnmountFlags; cancellable: Cancellable = nil;
    callback: AsyncReadyCallback; userData: pointer) =
  g_file_eject_mountable(cast[ptr GFile00](self.impl), flags, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_file_eject_mountable_with_operation(self: ptr GFile00; flags: MountUnmountFlags;
    mountOperation: ptr MountOperation00; cancellable: ptr Cancellable00; callback: AsyncReadyCallback;
    userData: pointer) {.
    importc, libprag.}

proc ejectMountableWithOperation*(self: GFile; flags: MountUnmountFlags;
    mountOperation: MountOperation = nil; cancellable: Cancellable = nil; callback: AsyncReadyCallback;
    userData: pointer) =
  g_file_eject_mountable_with_operation(cast[ptr GFile00](self.impl), flags, if mountOperation.isNil: nil else: cast[ptr MountOperation00](mountOperation.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_file_enumerate_children_async(self: ptr GFile00; attributes: cstring;
    flags: FileQueryInfoFlags; ioPriority: int32; cancellable: ptr Cancellable00;
    callback: AsyncReadyCallback; userData: pointer) {.
    importc, libprag.}

proc enumerateChildrenAsync*(self: GFile; attributes: cstring; flags: FileQueryInfoFlags;
    ioPriority: int; cancellable: Cancellable = nil; callback: AsyncReadyCallback;
    userData: pointer) =
  g_file_enumerate_children_async(cast[ptr GFile00](self.impl), attributes, flags, int32(ioPriority), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_file_find_enclosing_mount_async(self: ptr GFile00; ioPriority: int32;
    cancellable: ptr Cancellable00; callback: AsyncReadyCallback; userData: pointer) {.
    importc, libprag.}

proc findEnclosingMountAsync*(self: GFile; ioPriority: int; cancellable: Cancellable = nil;
    callback: AsyncReadyCallback; userData: pointer) =
  g_file_find_enclosing_mount_async(cast[ptr GFile00](self.impl), int32(ioPriority), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_file_load_bytes_async(self: ptr GFile00; cancellable: ptr Cancellable00;
    callback: AsyncReadyCallback; userData: pointer) {.
    importc, libprag.}

proc loadBytesAsync*(self: GFile; cancellable: Cancellable = nil;
    callback: AsyncReadyCallback; userData: pointer) =
  g_file_load_bytes_async(cast[ptr GFile00](self.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_file_load_contents_async(self: ptr GFile00; cancellable: ptr Cancellable00;
    callback: AsyncReadyCallback; userData: pointer) {.
    importc, libprag.}

proc loadContentsAsync*(self: GFile; cancellable: Cancellable = nil;
    callback: AsyncReadyCallback; userData: pointer) =
  g_file_load_contents_async(cast[ptr GFile00](self.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_file_make_directory_async(self: ptr GFile00; ioPriority: int32; cancellable: ptr Cancellable00;
    callback: AsyncReadyCallback; userData: pointer) {.
    importc, libprag.}

proc makeDirectoryAsync*(self: GFile; ioPriority: int; cancellable: Cancellable = nil;
    callback: AsyncReadyCallback; userData: pointer) =
  g_file_make_directory_async(cast[ptr GFile00](self.impl), int32(ioPriority), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_file_mount_enclosing_volume(self: ptr GFile00; flags: MountMountFlags;
    mountOperation: ptr MountOperation00; cancellable: ptr Cancellable00; callback: AsyncReadyCallback;
    userData: pointer) {.
    importc, libprag.}

proc mountEnclosingVolume*(self: GFile; flags: MountMountFlags; mountOperation: MountOperation = nil;
    cancellable: Cancellable = nil; callback: AsyncReadyCallback; userData: pointer) =
  g_file_mount_enclosing_volume(cast[ptr GFile00](self.impl), flags, if mountOperation.isNil: nil else: cast[ptr MountOperation00](mountOperation.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_file_mount_mountable(self: ptr GFile00; flags: MountMountFlags; mountOperation: ptr MountOperation00;
    cancellable: ptr Cancellable00; callback: AsyncReadyCallback; userData: pointer) {.
    importc, libprag.}

proc mountMountable*(self: GFile; flags: MountMountFlags; mountOperation: MountOperation = nil;
    cancellable: Cancellable = nil; callback: AsyncReadyCallback; userData: pointer) =
  g_file_mount_mountable(cast[ptr GFile00](self.impl), flags, if mountOperation.isNil: nil else: cast[ptr MountOperation00](mountOperation.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_file_open_readwrite_async(self: ptr GFile00; ioPriority: int32; cancellable: ptr Cancellable00;
    callback: AsyncReadyCallback; userData: pointer) {.
    importc, libprag.}

proc openReadwriteAsync*(self: GFile; ioPriority: int; cancellable: Cancellable = nil;
    callback: AsyncReadyCallback; userData: pointer) =
  g_file_open_readwrite_async(cast[ptr GFile00](self.impl), int32(ioPriority), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_file_poll_mountable(self: ptr GFile00; cancellable: ptr Cancellable00;
    callback: AsyncReadyCallback; userData: pointer) {.
    importc, libprag.}

proc pollMountable*(self: GFile; cancellable: Cancellable = nil; callback: AsyncReadyCallback;
    userData: pointer) =
  g_file_poll_mountable(cast[ptr GFile00](self.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_file_query_default_handler_async(self: ptr GFile00; ioPriority: int32;
    cancellable: ptr Cancellable00; callback: AsyncReadyCallback; userData: pointer) {.
    importc, libprag.}

proc queryDefaultHandlerAsync*(self: GFile; ioPriority: int; cancellable: Cancellable = nil;
    callback: AsyncReadyCallback; userData: pointer) =
  g_file_query_default_handler_async(cast[ptr GFile00](self.impl), int32(ioPriority), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_file_query_filesystem_info_async(self: ptr GFile00; attributes: cstring;
    ioPriority: int32; cancellable: ptr Cancellable00; callback: AsyncReadyCallback;
    userData: pointer) {.
    importc, libprag.}

proc queryFilesystemInfoAsync*(self: GFile; attributes: cstring;
    ioPriority: int; cancellable: Cancellable = nil; callback: AsyncReadyCallback;
    userData: pointer) =
  g_file_query_filesystem_info_async(cast[ptr GFile00](self.impl), attributes, int32(ioPriority), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_file_query_info_async(self: ptr GFile00; attributes: cstring; flags: FileQueryInfoFlags;
    ioPriority: int32; cancellable: ptr Cancellable00; callback: AsyncReadyCallback;
    userData: pointer) {.
    importc, libprag.}

proc queryInfoAsync*(self: GFile; attributes: cstring; flags: FileQueryInfoFlags;
    ioPriority: int; cancellable: Cancellable = nil; callback: AsyncReadyCallback;
    userData: pointer) =
  g_file_query_info_async(cast[ptr GFile00](self.impl), attributes, flags, int32(ioPriority), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_file_read_async(self: ptr GFile00; ioPriority: int32; cancellable: ptr Cancellable00;
    callback: AsyncReadyCallback; userData: pointer) {.
    importc, libprag.}

proc readAsync*(self: GFile; ioPriority: int; cancellable: Cancellable = nil;
    callback: AsyncReadyCallback; userData: pointer) =
  g_file_read_async(cast[ptr GFile00](self.impl), int32(ioPriority), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_file_replace_async(self: ptr GFile00; etag: cstring; makeBackup: gboolean;
    flags: FileCreateFlags; ioPriority: int32; cancellable: ptr Cancellable00;
    callback: AsyncReadyCallback; userData: pointer) {.
    importc, libprag.}

proc replaceAsync*(self: GFile; etag: cstring = nil; makeBackup: bool;
    flags: FileCreateFlags; ioPriority: int; cancellable: Cancellable = nil;
    callback: AsyncReadyCallback; userData: pointer) =
  g_file_replace_async(cast[ptr GFile00](self.impl), etag, gboolean(makeBackup), flags, int32(ioPriority), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_file_replace_contents_async(self: ptr GFile00; contents: ptr uint8;
    length: uint64; etag: cstring; makeBackup: gboolean; flags: FileCreateFlags;
    cancellable: ptr Cancellable00; callback: AsyncReadyCallback; userData: pointer) {.
    importc, libprag.}

proc replaceContentsAsync*(self: GFile; contents: seq[uint8] | string;
    etag: cstring = nil; makeBackup: bool; flags: FileCreateFlags; cancellable: Cancellable = nil;
    callback: AsyncReadyCallback; userData: pointer) =
  let length = uint64(contents.len)
  g_file_replace_contents_async(cast[ptr GFile00](self.impl), cast[ptr uint8](unsafeaddr(contents[0])), length, etag, gboolean(makeBackup), flags, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_file_replace_contents_bytes_async(self: ptr GFile00; contents: ptr glib.Bytes00;
    etag: cstring; makeBackup: gboolean; flags: FileCreateFlags; cancellable: ptr Cancellable00;
    callback: AsyncReadyCallback; userData: pointer) {.
    importc, libprag.}

proc replaceContentsBytesAsync*(self: GFile; contents: glib.Bytes;
    etag: cstring = nil; makeBackup: bool; flags: FileCreateFlags; cancellable: Cancellable = nil;
    callback: AsyncReadyCallback; userData: pointer) =
  g_file_replace_contents_bytes_async(cast[ptr GFile00](self.impl), cast[ptr glib.Bytes00](contents.impl), etag, gboolean(makeBackup), flags, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_file_replace_readwrite_async(self: ptr GFile00; etag: cstring; makeBackup: gboolean;
    flags: FileCreateFlags; ioPriority: int32; cancellable: ptr Cancellable00;
    callback: AsyncReadyCallback; userData: pointer) {.
    importc, libprag.}

proc replaceReadwriteAsync*(self: GFile; etag: cstring = nil; makeBackup: bool;
    flags: FileCreateFlags; ioPriority: int; cancellable: Cancellable = nil;
    callback: AsyncReadyCallback; userData: pointer) =
  g_file_replace_readwrite_async(cast[ptr GFile00](self.impl), etag, gboolean(makeBackup), flags, int32(ioPriority), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_file_set_attributes_async(self: ptr GFile00; info: ptr FileInfo00;
    flags: FileQueryInfoFlags; ioPriority: int32; cancellable: ptr Cancellable00;
    callback: AsyncReadyCallback; userData: pointer) {.
    importc, libprag.}

proc setAttributesAsync*(self: GFile; info: FileInfo; flags: FileQueryInfoFlags;
    ioPriority: int; cancellable: Cancellable = nil; callback: AsyncReadyCallback;
    userData: pointer) =
  g_file_set_attributes_async(cast[ptr GFile00](self.impl), cast[ptr FileInfo00](info.impl), flags, int32(ioPriority), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_file_set_display_name_async(self: ptr GFile00; displayName: cstring;
    ioPriority: int32; cancellable: ptr Cancellable00; callback: AsyncReadyCallback;
    userData: pointer) {.
    importc, libprag.}

proc setDisplayNameAsync*(self: GFile; displayName: cstring; ioPriority: int;
    cancellable: Cancellable = nil; callback: AsyncReadyCallback; userData: pointer) =
  g_file_set_display_name_async(cast[ptr GFile00](self.impl), displayName, int32(ioPriority), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_file_start_mountable(self: ptr GFile00; flags: DriveStartFlags; startOperation: ptr MountOperation00;
    cancellable: ptr Cancellable00; callback: AsyncReadyCallback; userData: pointer) {.
    importc, libprag.}

proc startMountable*(self: GFile; flags: DriveStartFlags; startOperation: MountOperation = nil;
    cancellable: Cancellable = nil; callback: AsyncReadyCallback; userData: pointer) =
  g_file_start_mountable(cast[ptr GFile00](self.impl), flags, if startOperation.isNil: nil else: cast[ptr MountOperation00](startOperation.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_file_stop_mountable(self: ptr GFile00; flags: MountUnmountFlags; mountOperation: ptr MountOperation00;
    cancellable: ptr Cancellable00; callback: AsyncReadyCallback; userData: pointer) {.
    importc, libprag.}

proc stopMountable*(self: GFile; flags: MountUnmountFlags; mountOperation: MountOperation = nil;
    cancellable: Cancellable = nil; callback: AsyncReadyCallback; userData: pointer) =
  g_file_stop_mountable(cast[ptr GFile00](self.impl), flags, if mountOperation.isNil: nil else: cast[ptr MountOperation00](mountOperation.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_file_trash_async(self: ptr GFile00; ioPriority: int32; cancellable: ptr Cancellable00;
    callback: AsyncReadyCallback; userData: pointer) {.
    importc, libprag.}

proc trashAsync*(self: GFile; ioPriority: int; cancellable: Cancellable = nil;
    callback: AsyncReadyCallback; userData: pointer) =
  g_file_trash_async(cast[ptr GFile00](self.impl), int32(ioPriority), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_file_unmount_mountable(self: ptr GFile00; flags: MountUnmountFlags;
    cancellable: ptr Cancellable00; callback: AsyncReadyCallback; userData: pointer) {.
    importc, libprag.}

proc unmountMountable*(self: GFile; flags: MountUnmountFlags; cancellable: Cancellable = nil;
    callback: AsyncReadyCallback; userData: pointer) =
  g_file_unmount_mountable(cast[ptr GFile00](self.impl), flags, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_file_unmount_mountable_with_operation(self: ptr GFile00; flags: MountUnmountFlags;
    mountOperation: ptr MountOperation00; cancellable: ptr Cancellable00; callback: AsyncReadyCallback;
    userData: pointer) {.
    importc, libprag.}

proc unmountMountableWithOperation*(self: GFile; flags: MountUnmountFlags;
    mountOperation: MountOperation = nil; cancellable: Cancellable = nil; callback: AsyncReadyCallback;
    userData: pointer) =
  g_file_unmount_mountable_with_operation(cast[ptr GFile00](self.impl), flags, if mountOperation.isNil: nil else: cast[ptr MountOperation00](mountOperation.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_io_stream_close_async(self: ptr IOStream00; ioPriority: int32; cancellable: ptr Cancellable00;
    callback: AsyncReadyCallback; userData: pointer) {.
    importc, libprag.}

proc closeAsync*(self: IOStream; ioPriority: int; cancellable: Cancellable = nil;
    callback: AsyncReadyCallback; userData: pointer) =
  g_io_stream_close_async(cast[ptr IOStream00](self.impl), int32(ioPriority), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_io_stream_splice_async(self: ptr IOStream00; stream2: ptr IOStream00;
    flags: IOStreamSpliceFlags; ioPriority: int32; cancellable: ptr Cancellable00;
    callback: AsyncReadyCallback; userData: pointer) {.
    importc, libprag.}

proc spliceAsync*(self: IOStream; stream2: IOStream; flags: IOStreamSpliceFlags;
    ioPriority: int; cancellable: Cancellable = nil; callback: AsyncReadyCallback;
    userData: pointer) =
  g_io_stream_splice_async(cast[ptr IOStream00](self.impl), cast[ptr IOStream00](stream2.impl), flags, int32(ioPriority), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_file_io_stream_query_info_async(self: ptr FileIOStream00; attributes: cstring;
    ioPriority: int32; cancellable: ptr Cancellable00; callback: AsyncReadyCallback;
    userData: pointer) {.
    importc, libprag.}

proc queryInfoAsync*(self: FileIOStream; attributes: cstring;
    ioPriority: int; cancellable: Cancellable = nil; callback: AsyncReadyCallback;
    userData: pointer) =
  g_file_io_stream_query_info_async(cast[ptr FileIOStream00](self.impl), attributes, int32(ioPriority), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_output_stream_close_async(self: ptr OutputStream00; ioPriority: int32;
    cancellable: ptr Cancellable00; callback: AsyncReadyCallback; userData: pointer) {.
    importc, libprag.}

proc closeAsync*(self: OutputStream; ioPriority: int; cancellable: Cancellable = nil;
    callback: AsyncReadyCallback; userData: pointer) =
  g_output_stream_close_async(cast[ptr OutputStream00](self.impl), int32(ioPriority), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_output_stream_flush_async(self: ptr OutputStream00; ioPriority: int32;
    cancellable: ptr Cancellable00; callback: AsyncReadyCallback; userData: pointer) {.
    importc, libprag.}

proc flushAsync*(self: OutputStream; ioPriority: int; cancellable: Cancellable = nil;
    callback: AsyncReadyCallback; userData: pointer) =
  g_output_stream_flush_async(cast[ptr OutputStream00](self.impl), int32(ioPriority), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_output_stream_splice_async(self: ptr OutputStream00; source: ptr InputStream00;
    flags: OutputStreamSpliceFlags; ioPriority: int32; cancellable: ptr Cancellable00;
    callback: AsyncReadyCallback; userData: pointer) {.
    importc, libprag.}

proc spliceAsync*(self: OutputStream; source: InputStream;
    flags: OutputStreamSpliceFlags; ioPriority: int; cancellable: Cancellable = nil;
    callback: AsyncReadyCallback; userData: pointer) =
  g_output_stream_splice_async(cast[ptr OutputStream00](self.impl), cast[ptr InputStream00](source.impl), flags, int32(ioPriority), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_output_stream_write_all_async(self: ptr OutputStream00; buffer: ptr uint8;
    count: uint64; ioPriority: int32; cancellable: ptr Cancellable00; callback: AsyncReadyCallback;
    userData: pointer) {.
    importc, libprag.}

proc writeAllAsync*(self: OutputStream; buffer: seq[uint8] | string;
    ioPriority: int; cancellable: Cancellable = nil; callback: AsyncReadyCallback;
    userData: pointer) =
  let count = uint64(buffer.len)
  g_output_stream_write_all_async(cast[ptr OutputStream00](self.impl), cast[ptr uint8](unsafeaddr(buffer[0])), count, int32(ioPriority), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_output_stream_write_async(self: ptr OutputStream00; buffer: ptr uint8;
    count: uint64; ioPriority: int32; cancellable: ptr Cancellable00; callback: AsyncReadyCallback;
    userData: pointer) {.
    importc, libprag.}

proc writeAsync*(self: OutputStream; buffer: seq[uint8] | string;
    ioPriority: int; cancellable: Cancellable = nil; callback: AsyncReadyCallback;
    userData: pointer) =
  let count = uint64(buffer.len)
  g_output_stream_write_async(cast[ptr OutputStream00](self.impl), cast[ptr uint8](unsafeaddr(buffer[0])), count, int32(ioPriority), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_output_stream_write_bytes_async(self: ptr OutputStream00; bytes: ptr glib.Bytes00;
    ioPriority: int32; cancellable: ptr Cancellable00; callback: AsyncReadyCallback;
    userData: pointer) {.
    importc, libprag.}

proc writeBytesAsync*(self: OutputStream; bytes: glib.Bytes;
    ioPriority: int; cancellable: Cancellable = nil; callback: AsyncReadyCallback;
    userData: pointer) =
  g_output_stream_write_bytes_async(cast[ptr OutputStream00](self.impl), cast[ptr glib.Bytes00](bytes.impl), int32(ioPriority), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_output_stream_writev_all_async(self: ptr OutputStream00; vectors: ptr OutputVector;
    nVectors: uint64; ioPriority: int32; cancellable: ptr Cancellable00; callback: AsyncReadyCallback;
    userData: pointer) {.
    importc, libprag.}

proc writevAllAsync*(self: OutputStream; vectors: ptr OutputVector;
    nVectors: uint64; ioPriority: int; cancellable: Cancellable = nil; callback: AsyncReadyCallback;
    userData: pointer) =
  g_output_stream_writev_all_async(cast[ptr OutputStream00](self.impl), vectors, nVectors, int32(ioPriority), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_output_stream_writev_async(self: ptr OutputStream00; vectors: ptr OutputVector;
    nVectors: uint64; ioPriority: int32; cancellable: ptr Cancellable00; callback: AsyncReadyCallback;
    userData: pointer) {.
    importc, libprag.}

proc writevAsync*(self: OutputStream; vectors: ptr OutputVector;
    nVectors: uint64; ioPriority: int; cancellable: Cancellable = nil; callback: AsyncReadyCallback;
    userData: pointer) =
  g_output_stream_writev_async(cast[ptr OutputStream00](self.impl), vectors, nVectors, int32(ioPriority), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_file_enumerator_close_async(self: ptr FileEnumerator00; ioPriority: int32;
    cancellable: ptr Cancellable00; callback: AsyncReadyCallback; userData: pointer) {.
    importc, libprag.}

proc closeAsync*(self: FileEnumerator; ioPriority: int;
    cancellable: Cancellable = nil; callback: AsyncReadyCallback; userData: pointer) =
  g_file_enumerator_close_async(cast[ptr FileEnumerator00](self.impl), int32(ioPriority), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_file_enumerator_next_files_async(self: ptr FileEnumerator00; numFiles: int32;
    ioPriority: int32; cancellable: ptr Cancellable00; callback: AsyncReadyCallback;
    userData: pointer) {.
    importc, libprag.}

proc nextFilesAsync*(self: FileEnumerator; numFiles: int;
    ioPriority: int; cancellable: Cancellable = nil; callback: AsyncReadyCallback;
    userData: pointer) =
  g_file_enumerator_next_files_async(cast[ptr FileEnumerator00](self.impl), int32(numFiles), int32(ioPriority), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_mount_eject(self: ptr Mount00; flags: MountUnmountFlags; cancellable: ptr Cancellable00;
    callback: AsyncReadyCallback; userData: pointer) {.
    importc, libprag.}

proc eject*(self: Mount; flags: MountUnmountFlags; cancellable: Cancellable = nil;
    callback: AsyncReadyCallback; userData: pointer) =
  g_mount_eject(cast[ptr Mount00](self.impl), flags, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_mount_eject_with_operation(self: ptr Mount00; flags: MountUnmountFlags;
    mountOperation: ptr MountOperation00; cancellable: ptr Cancellable00; callback: AsyncReadyCallback;
    userData: pointer) {.
    importc, libprag.}

proc ejectWithOperation*(self: Mount; flags: MountUnmountFlags;
    mountOperation: MountOperation = nil; cancellable: Cancellable = nil; callback: AsyncReadyCallback;
    userData: pointer) =
  g_mount_eject_with_operation(cast[ptr Mount00](self.impl), flags, if mountOperation.isNil: nil else: cast[ptr MountOperation00](mountOperation.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_mount_guess_content_type(self: ptr Mount00; forceRescan: gboolean;
    cancellable: ptr Cancellable00; callback: AsyncReadyCallback; userData: pointer) {.
    importc, libprag.}

proc guessContentType*(self: Mount; forceRescan: bool; cancellable: Cancellable = nil;
    callback: AsyncReadyCallback; userData: pointer) =
  g_mount_guess_content_type(cast[ptr Mount00](self.impl), gboolean(forceRescan), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_mount_remount(self: ptr Mount00; flags: MountMountFlags; mountOperation: ptr MountOperation00;
    cancellable: ptr Cancellable00; callback: AsyncReadyCallback; userData: pointer) {.
    importc, libprag.}

proc remount*(self: Mount; flags: MountMountFlags; mountOperation: MountOperation = nil;
    cancellable: Cancellable = nil; callback: AsyncReadyCallback; userData: pointer) =
  g_mount_remount(cast[ptr Mount00](self.impl), flags, if mountOperation.isNil: nil else: cast[ptr MountOperation00](mountOperation.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_mount_unmount(self: ptr Mount00; flags: MountUnmountFlags; cancellable: ptr Cancellable00;
    callback: AsyncReadyCallback; userData: pointer) {.
    importc, libprag.}

proc unmount*(self: Mount; flags: MountUnmountFlags; cancellable: Cancellable = nil;
    callback: AsyncReadyCallback; userData: pointer) =
  g_mount_unmount(cast[ptr Mount00](self.impl), flags, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_mount_unmount_with_operation(self: ptr Mount00; flags: MountUnmountFlags;
    mountOperation: ptr MountOperation00; cancellable: ptr Cancellable00; callback: AsyncReadyCallback;
    userData: pointer) {.
    importc, libprag.}

proc unmountWithOperation*(self: Mount; flags: MountUnmountFlags;
    mountOperation: MountOperation = nil; cancellable: Cancellable = nil; callback: AsyncReadyCallback;
    userData: pointer) =
  g_mount_unmount_with_operation(cast[ptr Mount00](self.impl), flags, if mountOperation.isNil: nil else: cast[ptr MountOperation00](mountOperation.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_drive_eject(self: ptr Drive00; flags: MountUnmountFlags; cancellable: ptr Cancellable00;
    callback: AsyncReadyCallback; userData: pointer) {.
    importc, libprag.}

proc eject*(self: Drive; flags: MountUnmountFlags; cancellable: Cancellable = nil;
    callback: AsyncReadyCallback; userData: pointer) =
  g_drive_eject(cast[ptr Drive00](self.impl), flags, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_drive_eject_with_operation(self: ptr Drive00; flags: MountUnmountFlags;
    mountOperation: ptr MountOperation00; cancellable: ptr Cancellable00; callback: AsyncReadyCallback;
    userData: pointer) {.
    importc, libprag.}

proc ejectWithOperation*(self: Drive; flags: MountUnmountFlags;
    mountOperation: MountOperation = nil; cancellable: Cancellable = nil; callback: AsyncReadyCallback;
    userData: pointer) =
  g_drive_eject_with_operation(cast[ptr Drive00](self.impl), flags, if mountOperation.isNil: nil else: cast[ptr MountOperation00](mountOperation.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_drive_poll_for_media(self: ptr Drive00; cancellable: ptr Cancellable00;
    callback: AsyncReadyCallback; userData: pointer) {.
    importc, libprag.}

proc pollForMedia*(self: Drive; cancellable: Cancellable = nil;
    callback: AsyncReadyCallback; userData: pointer) =
  g_drive_poll_for_media(cast[ptr Drive00](self.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_drive_start(self: ptr Drive00; flags: DriveStartFlags; mountOperation: ptr MountOperation00;
    cancellable: ptr Cancellable00; callback: AsyncReadyCallback; userData: pointer) {.
    importc, libprag.}

proc start*(self: Drive; flags: DriveStartFlags; mountOperation: MountOperation = nil;
    cancellable: Cancellable = nil; callback: AsyncReadyCallback; userData: pointer) =
  g_drive_start(cast[ptr Drive00](self.impl), flags, if mountOperation.isNil: nil else: cast[ptr MountOperation00](mountOperation.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_drive_stop(self: ptr Drive00; flags: MountUnmountFlags; mountOperation: ptr MountOperation00;
    cancellable: ptr Cancellable00; callback: AsyncReadyCallback; userData: pointer) {.
    importc, libprag.}

proc stop*(self: Drive; flags: MountUnmountFlags; mountOperation: MountOperation = nil;
    cancellable: Cancellable = nil; callback: AsyncReadyCallback; userData: pointer) =
  g_drive_stop(cast[ptr Drive00](self.impl), flags, if mountOperation.isNil: nil else: cast[ptr MountOperation00](mountOperation.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_volume_eject(self: ptr Volume00; flags: MountUnmountFlags; cancellable: ptr Cancellable00;
    callback: AsyncReadyCallback; userData: pointer) {.
    importc, libprag.}

proc eject*(self: Volume; flags: MountUnmountFlags; cancellable: Cancellable = nil;
    callback: AsyncReadyCallback; userData: pointer) =
  g_volume_eject(cast[ptr Volume00](self.impl), flags, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_volume_eject_with_operation(self: ptr Volume00; flags: MountUnmountFlags;
    mountOperation: ptr MountOperation00; cancellable: ptr Cancellable00; callback: AsyncReadyCallback;
    userData: pointer) {.
    importc, libprag.}

proc ejectWithOperation*(self: Volume; flags: MountUnmountFlags;
    mountOperation: MountOperation = nil; cancellable: Cancellable = nil; callback: AsyncReadyCallback;
    userData: pointer) =
  g_volume_eject_with_operation(cast[ptr Volume00](self.impl), flags, if mountOperation.isNil: nil else: cast[ptr MountOperation00](mountOperation.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_volume_mount(self: ptr Volume00; flags: MountMountFlags; mountOperation: ptr MountOperation00;
    cancellable: ptr Cancellable00; callback: AsyncReadyCallback; userData: pointer) {.
    importc, libprag.}

proc mount*(self: Volume; flags: MountMountFlags; mountOperation: MountOperation = nil;
    cancellable: Cancellable = nil; callback: AsyncReadyCallback; userData: pointer) =
  g_volume_mount(cast[ptr Volume00](self.impl), flags, if mountOperation.isNil: nil else: cast[ptr MountOperation00](mountOperation.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_app_info_launch_default_for_uri_async(uri: cstring; context: ptr AppLaunchContext00;
    cancellable: ptr Cancellable00; callback: AsyncReadyCallback; userData: pointer) {.
    importc, libprag.}

proc launchDefaultForUriAsync*(uri: cstring; context: AppLaunchContext = nil;
    cancellable: Cancellable = nil; callback: AsyncReadyCallback; userData: pointer) =
  g_app_info_launch_default_for_uri_async(uri, if context.isNil: nil else: cast[ptr AppLaunchContext00](context.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_app_info_launch_uris_async(self: ptr AppInfo00; uris: ptr glib.List;
    context: ptr AppLaunchContext00; cancellable: ptr Cancellable00; callback: AsyncReadyCallback;
    userData: pointer) {.
    importc, libprag.}

proc launchUrisAsync*(self: AppInfo | DesktopAppInfo; uris: seq[cstring];
    context: AppLaunchContext = nil; cancellable: Cancellable = nil; callback: AsyncReadyCallback;
    userData: pointer) =
  var tempResGL = seq2GList(uris)
  g_app_info_launch_uris_async(cast[ptr AppInfo00](self.impl), tempResGL, if context.isNil: nil else: cast[ptr AppLaunchContext00](context.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)
  g_list_free(tempResGL)

proc g_file_output_stream_query_info_async(self: ptr FileOutputStream00;
    attributes: cstring; ioPriority: int32; cancellable: ptr Cancellable00;
    callback: AsyncReadyCallback; userData: pointer) {.
    importc, libprag.}

proc queryInfoAsync*(self: FileOutputStream; attributes: cstring;
    ioPriority: int; cancellable: Cancellable = nil; callback: AsyncReadyCallback;
    userData: pointer) =
  g_file_output_stream_query_info_async(cast[ptr FileOutputStream00](self.impl), attributes, int32(ioPriority), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_simple_async_result_new(sourceObject: ptr gobject.Object00; callback: AsyncReadyCallback;
    userData: pointer; sourceTag: pointer): ptr SimpleAsyncResult00 {.
    importc, libprag.}

proc newSimpleAsyncResult*(sourceObject: gobject.Object = nil; callback: AsyncReadyCallback;
    userData: pointer; sourceTag: pointer): SimpleAsyncResult {.deprecated.}  =
  let gobj = g_simple_async_result_new(if sourceObject.isNil: nil else: cast[ptr gobject.Object00](sourceObject.impl), callback, userData, sourceTag)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newSimpleAsyncResult*(tdesc: typedesc; sourceObject: gobject.Object = nil; callback: AsyncReadyCallback;
    userData: pointer; sourceTag: pointer): tdesc {.deprecated.}  =
  assert(result is SimpleAsyncResult)
  let gobj = g_simple_async_result_new(if sourceObject.isNil: nil else: cast[ptr gobject.Object00](sourceObject.impl), callback, userData, sourceTag)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initSimpleAsyncResult*[T](result: var T; sourceObject: gobject.Object = nil; callback: AsyncReadyCallback;
    userData: pointer; sourceTag: pointer) {.deprecated.} =
  assert(result is SimpleAsyncResult)
  let gobj = g_simple_async_result_new(if sourceObject.isNil: nil else: cast[ptr gobject.Object00](sourceObject.impl), callback, userData, sourceTag)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_simple_async_result_new_from_error(sourceObject: ptr gobject.Object00;
    callback: AsyncReadyCallback; userData: pointer; error: ptr glib.Error): ptr SimpleAsyncResult00 {.
    importc, libprag.}

proc newSimpleAsyncResultFromError*(sourceObject: gobject.Object = nil;
    callback: AsyncReadyCallback; userData: pointer; error: ptr glib.Error): SimpleAsyncResult {.deprecated.}  =
  let gobj = g_simple_async_result_new_from_error(if sourceObject.isNil: nil else: cast[ptr gobject.Object00](sourceObject.impl), callback, userData, error)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newSimpleAsyncResultFromError*(tdesc: typedesc; sourceObject: gobject.Object = nil;
    callback: AsyncReadyCallback; userData: pointer; error: ptr glib.Error): tdesc {.deprecated.}  =
  assert(result is SimpleAsyncResult)
  let gobj = g_simple_async_result_new_from_error(if sourceObject.isNil: nil else: cast[ptr gobject.Object00](sourceObject.impl), callback, userData, error)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initSimpleAsyncResultFromError*[T](result: var T; sourceObject: gobject.Object = nil;
    callback: AsyncReadyCallback; userData: pointer; error: ptr glib.Error) {.deprecated.} =
  assert(result is SimpleAsyncResult)
  let gobj = g_simple_async_result_new_from_error(if sourceObject.isNil: nil else: cast[ptr gobject.Object00](sourceObject.impl), callback, userData, error)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_task_new(sourceObject: ptr gobject.Object00; cancellable: ptr Cancellable00;
    callback: AsyncReadyCallback; callbackData: pointer): ptr Task00 {.
    importc, libprag.}

proc newTask*(sourceObject: gobject.Object = nil; cancellable: Cancellable = nil;
    callback: AsyncReadyCallback; callbackData: pointer): Task =
  let gobj = g_task_new(if sourceObject.isNil: nil else: cast[ptr gobject.Object00](sourceObject.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, callbackData)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newTask*(tdesc: typedesc; sourceObject: gobject.Object = nil; cancellable: Cancellable = nil;
    callback: AsyncReadyCallback; callbackData: pointer): tdesc =
  assert(result is Task)
  let gobj = g_task_new(if sourceObject.isNil: nil else: cast[ptr gobject.Object00](sourceObject.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, callbackData)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initTask*[T](result: var T; sourceObject: gobject.Object = nil; cancellable: Cancellable = nil;
    callback: AsyncReadyCallback; callbackData: pointer) {.deprecated.} =
  assert(result is Task)
  let gobj = g_task_new(if sourceObject.isNil: nil else: cast[ptr gobject.Object00](sourceObject.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, callbackData)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_task_report_error(sourceObject: ptr gobject.Object00; callback: AsyncReadyCallback;
    callbackData: pointer; sourceTag: pointer; error: ptr glib.Error) {.
    importc, libprag.}

proc reportError*(sourceObject: gobject.Object = nil; callback: AsyncReadyCallback;
    callbackData: pointer; sourceTag: pointer; error: ptr glib.Error) =
  g_task_report_error(if sourceObject.isNil: nil else: cast[ptr gobject.Object00](sourceObject.impl), callback, callbackData, sourceTag, error)

proc g_dbus_connection_new(stream: ptr IOStream00; guid: cstring; flags: DBusConnectionFlags;
    observer: ptr DBusAuthObserver00; cancellable: ptr Cancellable00; callback: AsyncReadyCallback;
    userData: pointer) {.
    importc, libprag.}

proc new*(stream: IOStream; guid: cstring = nil; flags: DBusConnectionFlags;
    observer: DBusAuthObserver = nil; cancellable: Cancellable = nil; callback: AsyncReadyCallback;
    userData: pointer) =
  g_dbus_connection_new(cast[ptr IOStream00](stream.impl), guid, flags, if observer.isNil: nil else: cast[ptr DBusAuthObserver00](observer.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_dbus_connection_new_for_address(address: cstring; flags: DBusConnectionFlags;
    observer: ptr DBusAuthObserver00; cancellable: ptr Cancellable00; callback: AsyncReadyCallback;
    userData: pointer) {.
    importc, libprag.}

proc newForAddress*(address: cstring; flags: DBusConnectionFlags;
    observer: DBusAuthObserver = nil; cancellable: Cancellable = nil; callback: AsyncReadyCallback;
    userData: pointer) =
  g_dbus_connection_new_for_address(address, flags, if observer.isNil: nil else: cast[ptr DBusAuthObserver00](observer.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_dbus_connection_call(self: ptr DBusConnection00; busName: cstring;
    objectPath: cstring; interfaceName: cstring; methodName: cstring; parameters: ptr glib.Variant00;
    replyType: ptr glib.VariantType00; flags: DBusCallFlags; timeoutMsec: int32;
    cancellable: ptr Cancellable00; callback: AsyncReadyCallback; userData: pointer) {.
    importc, libprag.}

proc call*(self: DBusConnection; busName: cstring = nil;
    objectPath: cstring; interfaceName: cstring; methodName: cstring; parameters: glib.Variant = nil;
    replyType: glib.VariantType = nil; flags: DBusCallFlags; timeoutMsec: int;
    cancellable: Cancellable = nil; callback: AsyncReadyCallback; userData: pointer) =
  g_dbus_connection_call(cast[ptr DBusConnection00](self.impl), busName, objectPath, interfaceName, methodName, if parameters.isNil: nil else: cast[ptr glib.Variant00](parameters.impl), if replyType.isNil: nil else: cast[ptr glib.VariantType00](replyType.impl), flags, int32(timeoutMsec), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_dbus_connection_call_with_unix_fd_list(self: ptr DBusConnection00;
    busName: cstring; objectPath: cstring; interfaceName: cstring; methodName: cstring;
    parameters: ptr glib.Variant00; replyType: ptr glib.VariantType00; flags: DBusCallFlags;
    timeoutMsec: int32; fdList: ptr UnixFDList00; cancellable: ptr Cancellable00;
    callback: AsyncReadyCallback; userData: pointer) {.
    importc, libprag.}

proc callWithUnixFdList*(self: DBusConnection; busName: cstring = nil;
    objectPath: cstring; interfaceName: cstring; methodName: cstring; parameters: glib.Variant = nil;
    replyType: glib.VariantType = nil; flags: DBusCallFlags; timeoutMsec: int;
    fdList: UnixFDList = nil; cancellable: Cancellable = nil; callback: AsyncReadyCallback;
    userData: pointer) =
  g_dbus_connection_call_with_unix_fd_list(cast[ptr DBusConnection00](self.impl), busName, objectPath, interfaceName, methodName, if parameters.isNil: nil else: cast[ptr glib.Variant00](parameters.impl), if replyType.isNil: nil else: cast[ptr glib.VariantType00](replyType.impl), flags, int32(timeoutMsec), if fdList.isNil: nil else: cast[ptr UnixFDList00](fdList.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_dbus_connection_close(self: ptr DBusConnection00; cancellable: ptr Cancellable00;
    callback: AsyncReadyCallback; userData: pointer) {.
    importc, libprag.}

proc close*(self: DBusConnection; cancellable: Cancellable = nil;
    callback: AsyncReadyCallback; userData: pointer) =
  g_dbus_connection_close(cast[ptr DBusConnection00](self.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_dbus_connection_flush(self: ptr DBusConnection00; cancellable: ptr Cancellable00;
    callback: AsyncReadyCallback; userData: pointer) {.
    importc, libprag.}

proc flush*(self: DBusConnection; cancellable: Cancellable = nil;
    callback: AsyncReadyCallback; userData: pointer) =
  g_dbus_connection_flush(cast[ptr DBusConnection00](self.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_dbus_connection_send_message_with_reply(self: ptr DBusConnection00;
    message: ptr DBusMessage00; flags: DBusSendMessageFlags; timeoutMsec: int32;
    outSerial: var uint32; cancellable: ptr Cancellable00; callback: AsyncReadyCallback;
    userData: pointer) {.
    importc, libprag.}

proc sendMessageWithReply*(self: DBusConnection; message: DBusMessage;
    flags: DBusSendMessageFlags; timeoutMsec: int; outSerial: var int = cast[var int](nil);
    cancellable: Cancellable = nil; callback: AsyncReadyCallback; userData: pointer) =
  var outSerial_00: uint32
  g_dbus_connection_send_message_with_reply(cast[ptr DBusConnection00](self.impl), cast[ptr DBusMessage00](message.impl), flags, int32(timeoutMsec), outSerial_00, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)
  if outSerial.addr != nil:
    outSerial = int(outSerial_00)

proc g_input_stream_close_async(self: ptr InputStream00; ioPriority: int32;
    cancellable: ptr Cancellable00; callback: AsyncReadyCallback; userData: pointer) {.
    importc, libprag.}

proc closeAsync*(self: InputStream; ioPriority: int; cancellable: Cancellable = nil;
    callback: AsyncReadyCallback; userData: pointer) =
  g_input_stream_close_async(cast[ptr InputStream00](self.impl), int32(ioPriority), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_input_stream_read_all_async(self: ptr InputStream00; buffer: ptr uint8;
    count: var uint64; ioPriority: int32; cancellable: ptr Cancellable00; callback: AsyncReadyCallback;
    userData: pointer) {.
    importc, libprag.}

proc readAllAsync*(self: InputStream; buffer: var (seq[uint8] | string);
    count: var uint64; ioPriority: int; cancellable: Cancellable = nil; callback: AsyncReadyCallback;
    userData: pointer) =
  g_input_stream_read_all_async(cast[ptr InputStream00](self.impl), cast[ptr uint8](unsafeaddr(buffer[0])), count, int32(ioPriority), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_input_stream_read_async(self: ptr InputStream00; buffer: ptr uint8;
    count: var uint64; ioPriority: int32; cancellable: ptr Cancellable00; callback: AsyncReadyCallback;
    userData: pointer) {.
    importc, libprag.}

proc readAsync*(self: InputStream; buffer: var (seq[uint8] | string);
    count: var uint64; ioPriority: int; cancellable: Cancellable = nil; callback: AsyncReadyCallback;
    userData: pointer) =
  g_input_stream_read_async(cast[ptr InputStream00](self.impl), cast[ptr uint8](unsafeaddr(buffer[0])), count, int32(ioPriority), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_input_stream_read_bytes_async(self: ptr InputStream00; count: uint64;
    ioPriority: int32; cancellable: ptr Cancellable00; callback: AsyncReadyCallback;
    userData: pointer) {.
    importc, libprag.}

proc readBytesAsync*(self: InputStream; count: uint64; ioPriority: int;
    cancellable: Cancellable = nil; callback: AsyncReadyCallback; userData: pointer) =
  g_input_stream_read_bytes_async(cast[ptr InputStream00](self.impl), count, int32(ioPriority), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_input_stream_skip_async(self: ptr InputStream00; count: uint64; ioPriority: int32;
    cancellable: ptr Cancellable00; callback: AsyncReadyCallback; userData: pointer) {.
    importc, libprag.}

proc skipAsync*(self: InputStream; count: uint64; ioPriority: int;
    cancellable: Cancellable = nil; callback: AsyncReadyCallback; userData: pointer) =
  g_input_stream_skip_async(cast[ptr InputStream00](self.impl), count, int32(ioPriority), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_file_input_stream_query_info_async(self: ptr FileInputStream00; attributes: cstring;
    ioPriority: int32; cancellable: ptr Cancellable00; callback: AsyncReadyCallback;
    userData: pointer) {.
    importc, libprag.}

proc queryInfoAsync*(self: FileInputStream; attributes: cstring;
    ioPriority: int; cancellable: Cancellable = nil; callback: AsyncReadyCallback;
    userData: pointer) =
  g_file_input_stream_query_info_async(cast[ptr FileInputStream00](self.impl), attributes, int32(ioPriority), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_async_initable_newv_async(objectType: GType; nParameters: uint32;
    parameters: ptr gobject.Parameter00; ioPriority: int32; cancellable: ptr Cancellable00;
    callback: AsyncReadyCallback; userData: pointer) {.
    importc, libprag.}

proc newvAsync*(objectType: GType; nParameters: int; parameters: gobject.Parameter;
    ioPriority: int; cancellable: Cancellable = nil; callback: AsyncReadyCallback;
    userData: pointer) =
  g_async_initable_newv_async(objectType, uint32(nParameters), cast[ptr gobject.Parameter00](parameters.impl), int32(ioPriority), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_async_initable_init_async(self: ptr AsyncInitable00; ioPriority: int32;
    cancellable: ptr Cancellable00; callback: AsyncReadyCallback; userData: pointer) {.
    importc, libprag.}

proc initAsync*(self: AsyncInitable | DBusProxy | DBusObjectManagerClient | DBusConnection;
    ioPriority: int; cancellable: Cancellable = nil; callback: AsyncReadyCallback;
    userData: pointer) =
  g_async_initable_init_async(cast[ptr AsyncInitable00](self.impl), int32(ioPriority), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_dbus_proxy_new(connection: ptr DBusConnection00; flags: DBusProxyFlags;
    info: ptr DBusInterfaceInfo00; name: cstring; objectPath: cstring; interfaceName: cstring;
    cancellable: ptr Cancellable00; callback: AsyncReadyCallback; userData: pointer) {.
    importc, libprag.}

proc new*(connection: DBusConnection; flags: DBusProxyFlags;
    info: DBusInterfaceInfo = nil; name: cstring = nil; objectPath: cstring;
    interfaceName: cstring; cancellable: Cancellable = nil; callback: AsyncReadyCallback;
    userData: pointer) =
  g_dbus_proxy_new(cast[ptr DBusConnection00](connection.impl), flags, if info.isNil: nil else: cast[ptr DBusInterfaceInfo00](info.impl), name, objectPath, interfaceName, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_dbus_proxy_new_for_bus(busType: BusType; flags: DBusProxyFlags; info: ptr DBusInterfaceInfo00;
    name: cstring; objectPath: cstring; interfaceName: cstring; cancellable: ptr Cancellable00;
    callback: AsyncReadyCallback; userData: pointer) {.
    importc, libprag.}

proc newForBus*(busType: BusType; flags: DBusProxyFlags; info: DBusInterfaceInfo = nil;
    name: cstring; objectPath: cstring; interfaceName: cstring; cancellable: Cancellable = nil;
    callback: AsyncReadyCallback; userData: pointer) =
  g_dbus_proxy_new_for_bus(busType, flags, if info.isNil: nil else: cast[ptr DBusInterfaceInfo00](info.impl), name, objectPath, interfaceName, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_dbus_proxy_call(self: ptr DBusProxy00; methodName: cstring; parameters: ptr glib.Variant00;
    flags: DBusCallFlags; timeoutMsec: int32; cancellable: ptr Cancellable00;
    callback: AsyncReadyCallback; userData: pointer) {.
    importc, libprag.}

proc call*(self: DBusProxy; methodName: cstring; parameters: glib.Variant = nil;
    flags: DBusCallFlags; timeoutMsec: int; cancellable: Cancellable = nil;
    callback: AsyncReadyCallback; userData: pointer) =
  g_dbus_proxy_call(cast[ptr DBusProxy00](self.impl), methodName, if parameters.isNil: nil else: cast[ptr glib.Variant00](parameters.impl), flags, int32(timeoutMsec), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_dbus_proxy_call_with_unix_fd_list(self: ptr DBusProxy00; methodName: cstring;
    parameters: ptr glib.Variant00; flags: DBusCallFlags; timeoutMsec: int32;
    fdList: ptr UnixFDList00; cancellable: ptr Cancellable00; callback: AsyncReadyCallback;
    userData: pointer) {.
    importc, libprag.}

proc callWithUnixFdList*(self: DBusProxy; methodName: cstring;
    parameters: glib.Variant = nil; flags: DBusCallFlags; timeoutMsec: int;
    fdList: UnixFDList = nil; cancellable: Cancellable = nil; callback: AsyncReadyCallback;
    userData: pointer) =
  g_dbus_proxy_call_with_unix_fd_list(cast[ptr DBusProxy00](self.impl), methodName, if parameters.isNil: nil else: cast[ptr glib.Variant00](parameters.impl), flags, int32(timeoutMsec), if fdList.isNil: nil else: cast[ptr UnixFDList00](fdList.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

type
  FilterInputStream* = ref object of InputStream
  FilterInputStream00* = object of InputStream00

proc g_filter_input_stream_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(FilterInputStream()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc g_filter_input_stream_get_base_stream(self: ptr FilterInputStream00): ptr InputStream00 {.
    importc, libprag.}

proc getBaseStream*(self: FilterInputStream): InputStream =
  let gobj = g_filter_input_stream_get_base_stream(cast[ptr FilterInputStream00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc baseStream*(self: FilterInputStream): InputStream =
  let gobj = g_filter_input_stream_get_base_stream(cast[ptr FilterInputStream00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_filter_input_stream_get_close_base_stream(self: ptr FilterInputStream00): gboolean {.
    importc, libprag.}

proc getCloseBaseStream*(self: FilterInputStream): bool =
  toBool(g_filter_input_stream_get_close_base_stream(cast[ptr FilterInputStream00](self.impl)))

proc closeBaseStream*(self: FilterInputStream): bool =
  toBool(g_filter_input_stream_get_close_base_stream(cast[ptr FilterInputStream00](self.impl)))

proc g_filter_input_stream_set_close_base_stream(self: ptr FilterInputStream00;
    closeBase: gboolean) {.
    importc, libprag.}

proc setCloseBaseStream*(self: FilterInputStream;
    closeBase: bool = true) =
  g_filter_input_stream_set_close_base_stream(cast[ptr FilterInputStream00](self.impl), gboolean(closeBase))

proc `closeBaseStream=`*(self: FilterInputStream;
    closeBase: bool) =
  g_filter_input_stream_set_close_base_stream(cast[ptr FilterInputStream00](self.impl), gboolean(closeBase))

type
  BufferedInputStream* = ref object of FilterInputStream
  BufferedInputStream00* = object of FilterInputStream00

proc g_buffered_input_stream_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(BufferedInputStream()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc g_buffered_input_stream_new(baseStream: ptr InputStream00): ptr BufferedInputStream00 {.
    importc, libprag.}

proc newBufferedInputStream*(baseStream: InputStream): BufferedInputStream =
  let gobj = g_buffered_input_stream_new(cast[ptr InputStream00](baseStream.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newBufferedInputStream*(tdesc: typedesc; baseStream: InputStream): tdesc =
  assert(result is BufferedInputStream)
  let gobj = g_buffered_input_stream_new(cast[ptr InputStream00](baseStream.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initBufferedInputStream*[T](result: var T; baseStream: InputStream) {.deprecated.} =
  assert(result is BufferedInputStream)
  let gobj = g_buffered_input_stream_new(cast[ptr InputStream00](baseStream.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_buffered_input_stream_new_sized(baseStream: ptr InputStream00; size: uint64): ptr BufferedInputStream00 {.
    importc, libprag.}

proc newBufferedInputStreamSized*(baseStream: InputStream; size: uint64): BufferedInputStream =
  let gobj = g_buffered_input_stream_new_sized(cast[ptr InputStream00](baseStream.impl), size)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newBufferedInputStreamSized*(tdesc: typedesc; baseStream: InputStream; size: uint64): tdesc =
  assert(result is BufferedInputStream)
  let gobj = g_buffered_input_stream_new_sized(cast[ptr InputStream00](baseStream.impl), size)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initBufferedInputStreamSized*[T](result: var T; baseStream: InputStream; size: uint64) {.deprecated.} =
  assert(result is BufferedInputStream)
  let gobj = g_buffered_input_stream_new_sized(cast[ptr InputStream00](baseStream.impl), size)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_buffered_input_stream_fill(self: ptr BufferedInputStream00; count: int64;
    cancellable: ptr Cancellable00; error: ptr ptr glib.Error = nil): int64 {.
    importc, libprag.}

proc fill*(self: BufferedInputStream; count: int64;
    cancellable: Cancellable = nil): int64 =
  var gerror: ptr glib.Error
  let resul0 = g_buffered_input_stream_fill(cast[ptr BufferedInputStream00](self.impl), count, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = resul0

proc g_buffered_input_stream_fill_async(self: ptr BufferedInputStream00;
    count: int64; ioPriority: int32; cancellable: ptr Cancellable00; callback: AsyncReadyCallback;
    userData: pointer) {.
    importc, libprag.}

proc fillAsync*(self: BufferedInputStream; count: int64;
    ioPriority: int; cancellable: Cancellable = nil; callback: AsyncReadyCallback;
    userData: pointer) =
  g_buffered_input_stream_fill_async(cast[ptr BufferedInputStream00](self.impl), count, int32(ioPriority), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_buffered_input_stream_fill_finish(self: ptr BufferedInputStream00;
    resu: ptr AsyncResult00; error: ptr ptr glib.Error = nil): int64 {.
    importc, libprag.}

proc fillFinish*(self: BufferedInputStream; resu: AsyncResult | SimpleAsyncResult | Task): int64 =
  var gerror: ptr glib.Error
  let resul0 = g_buffered_input_stream_fill_finish(cast[ptr BufferedInputStream00](self.impl), cast[ptr AsyncResult00](resu.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = resul0

proc g_buffered_input_stream_get_available(self: ptr BufferedInputStream00): uint64 {.
    importc, libprag.}

proc getAvailable*(self: BufferedInputStream): uint64 =
  g_buffered_input_stream_get_available(cast[ptr BufferedInputStream00](self.impl))

proc available*(self: BufferedInputStream): uint64 =
  g_buffered_input_stream_get_available(cast[ptr BufferedInputStream00](self.impl))

proc g_buffered_input_stream_get_buffer_size(self: ptr BufferedInputStream00): uint64 {.
    importc, libprag.}

proc getBufferSize*(self: BufferedInputStream): uint64 =
  g_buffered_input_stream_get_buffer_size(cast[ptr BufferedInputStream00](self.impl))

proc bufferSize*(self: BufferedInputStream): uint64 =
  g_buffered_input_stream_get_buffer_size(cast[ptr BufferedInputStream00](self.impl))

proc g_buffered_input_stream_peek(self: ptr BufferedInputStream00; buffer: ptr uint8;
    offset: uint64; count: uint64): uint64 {.
    importc, libprag.}

proc peek*(self: BufferedInputStream; buffer: seq[uint8] | string;
    offset: uint64): uint64 =
  let count = uint64(buffer.len)
  g_buffered_input_stream_peek(cast[ptr BufferedInputStream00](self.impl), cast[ptr uint8](unsafeaddr(buffer[0])), offset, count)

proc g_buffered_input_stream_peek_buffer(self: ptr BufferedInputStream00;
    count: var uint64): ptr uint8 {.
    importc, libprag.}

proc peekBuffer*(self: BufferedInputStream; count: var uint64): seq[uint8] =
  result = uint8ArrayToSeq(g_buffered_input_stream_peek_buffer(cast[ptr BufferedInputStream00](self.impl), count), count.int)

proc g_buffered_input_stream_read_byte(self: ptr BufferedInputStream00; cancellable: ptr Cancellable00;
    error: ptr ptr glib.Error = nil): int32 {.
    importc, libprag.}

proc readByte*(self: BufferedInputStream; cancellable: Cancellable = nil): int =
  var gerror: ptr glib.Error
  let resul0 = g_buffered_input_stream_read_byte(cast[ptr BufferedInputStream00](self.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = int(resul0)

proc g_buffered_input_stream_set_buffer_size(self: ptr BufferedInputStream00;
    size: uint64) {.
    importc, libprag.}

proc setBufferSize*(self: BufferedInputStream; size: uint64) =
  g_buffered_input_stream_set_buffer_size(cast[ptr BufferedInputStream00](self.impl), size)

proc `bufferSize=`*(self: BufferedInputStream; size: uint64) =
  g_buffered_input_stream_set_buffer_size(cast[ptr BufferedInputStream00](self.impl), size)

type
  FilterOutputStream* = ref object of OutputStream
  FilterOutputStream00* = object of OutputStream00

proc g_filter_output_stream_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(FilterOutputStream()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc g_filter_output_stream_get_base_stream(self: ptr FilterOutputStream00): ptr OutputStream00 {.
    importc, libprag.}

proc getBaseStream*(self: FilterOutputStream): OutputStream =
  let gobj = g_filter_output_stream_get_base_stream(cast[ptr FilterOutputStream00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc baseStream*(self: FilterOutputStream): OutputStream =
  let gobj = g_filter_output_stream_get_base_stream(cast[ptr FilterOutputStream00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_filter_output_stream_get_close_base_stream(self: ptr FilterOutputStream00): gboolean {.
    importc, libprag.}

proc getCloseBaseStream*(self: FilterOutputStream): bool =
  toBool(g_filter_output_stream_get_close_base_stream(cast[ptr FilterOutputStream00](self.impl)))

proc closeBaseStream*(self: FilterOutputStream): bool =
  toBool(g_filter_output_stream_get_close_base_stream(cast[ptr FilterOutputStream00](self.impl)))

proc g_filter_output_stream_set_close_base_stream(self: ptr FilterOutputStream00;
    closeBase: gboolean) {.
    importc, libprag.}

proc setCloseBaseStream*(self: FilterOutputStream;
    closeBase: bool = true) =
  g_filter_output_stream_set_close_base_stream(cast[ptr FilterOutputStream00](self.impl), gboolean(closeBase))

proc `closeBaseStream=`*(self: FilterOutputStream;
    closeBase: bool) =
  g_filter_output_stream_set_close_base_stream(cast[ptr FilterOutputStream00](self.impl), gboolean(closeBase))

type
  BufferedOutputStream* = ref object of FilterOutputStream
  BufferedOutputStream00* = object of FilterOutputStream00

proc g_buffered_output_stream_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(BufferedOutputStream()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc g_buffered_output_stream_new(baseStream: ptr OutputStream00): ptr BufferedOutputStream00 {.
    importc, libprag.}

proc newBufferedOutputStream*(baseStream: OutputStream): BufferedOutputStream =
  let gobj = g_buffered_output_stream_new(cast[ptr OutputStream00](baseStream.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newBufferedOutputStream*(tdesc: typedesc; baseStream: OutputStream): tdesc =
  assert(result is BufferedOutputStream)
  let gobj = g_buffered_output_stream_new(cast[ptr OutputStream00](baseStream.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initBufferedOutputStream*[T](result: var T; baseStream: OutputStream) {.deprecated.} =
  assert(result is BufferedOutputStream)
  let gobj = g_buffered_output_stream_new(cast[ptr OutputStream00](baseStream.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_buffered_output_stream_new_sized(baseStream: ptr OutputStream00; size: uint64): ptr BufferedOutputStream00 {.
    importc, libprag.}

proc newBufferedOutputStreamSized*(baseStream: OutputStream; size: uint64): BufferedOutputStream =
  let gobj = g_buffered_output_stream_new_sized(cast[ptr OutputStream00](baseStream.impl), size)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newBufferedOutputStreamSized*(tdesc: typedesc; baseStream: OutputStream; size: uint64): tdesc =
  assert(result is BufferedOutputStream)
  let gobj = g_buffered_output_stream_new_sized(cast[ptr OutputStream00](baseStream.impl), size)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initBufferedOutputStreamSized*[T](result: var T; baseStream: OutputStream; size: uint64) {.deprecated.} =
  assert(result is BufferedOutputStream)
  let gobj = g_buffered_output_stream_new_sized(cast[ptr OutputStream00](baseStream.impl), size)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_buffered_output_stream_get_auto_grow(self: ptr BufferedOutputStream00): gboolean {.
    importc, libprag.}

proc getAutoGrow*(self: BufferedOutputStream): bool =
  toBool(g_buffered_output_stream_get_auto_grow(cast[ptr BufferedOutputStream00](self.impl)))

proc autoGrow*(self: BufferedOutputStream): bool =
  toBool(g_buffered_output_stream_get_auto_grow(cast[ptr BufferedOutputStream00](self.impl)))

proc g_buffered_output_stream_get_buffer_size(self: ptr BufferedOutputStream00): uint64 {.
    importc, libprag.}

proc getBufferSize*(self: BufferedOutputStream): uint64 =
  g_buffered_output_stream_get_buffer_size(cast[ptr BufferedOutputStream00](self.impl))

proc bufferSize*(self: BufferedOutputStream): uint64 =
  g_buffered_output_stream_get_buffer_size(cast[ptr BufferedOutputStream00](self.impl))

proc g_buffered_output_stream_set_auto_grow(self: ptr BufferedOutputStream00;
    autoGrow: gboolean) {.
    importc, libprag.}

proc setAutoGrow*(self: BufferedOutputStream; autoGrow: bool = true) =
  g_buffered_output_stream_set_auto_grow(cast[ptr BufferedOutputStream00](self.impl), gboolean(autoGrow))

proc `autoGrow=`*(self: BufferedOutputStream; autoGrow: bool) =
  g_buffered_output_stream_set_auto_grow(cast[ptr BufferedOutputStream00](self.impl), gboolean(autoGrow))

proc g_buffered_output_stream_set_buffer_size(self: ptr BufferedOutputStream00;
    size: uint64) {.
    importc, libprag.}

proc setBufferSize*(self: BufferedOutputStream;
    size: uint64) =
  g_buffered_output_stream_set_buffer_size(cast[ptr BufferedOutputStream00](self.impl), size)

proc `bufferSize=`*(self: BufferedOutputStream;
    size: uint64) =
  g_buffered_output_stream_set_buffer_size(cast[ptr BufferedOutputStream00](self.impl), size)

type
  BusAcquiredCallback* = proc (connection: ptr DBusConnection00; name: cstring; userData: pointer) {.cdecl.}

type
  BusNameAcquiredCallback* = proc (connection: ptr DBusConnection00; name: cstring; userData: pointer) {.cdecl.}

type
  BusNameAppearedCallback* = proc (connection: ptr DBusConnection00; name: cstring; nameOwner: cstring;
    userData: pointer) {.cdecl.}

type
  BusNameLostCallback* = proc (connection: ptr DBusConnection00; name: cstring; userData: pointer) {.cdecl.}

type
  BusNameOwnerFlag* {.size: sizeof(cint), pure.} = enum
    allowReplacement = 0
    replace = 1
    doNotQueue = 2

  BusNameOwnerFlags* {.size: sizeof(cint).} = set[BusNameOwnerFlag]

const
  BusNameOwnerFlagsNone* = BusNameOwnerFlags({})
proc none*(t: typedesc[BusNameOwnerFlags]): BusNameOwnerFlags = BusNameOwnerFlags({})

type
  BusNameVanishedCallback* = proc (connection: ptr DBusConnection00; name: cstring; userData: pointer) {.cdecl.}

type
  BusNameWatcherFlag* {.size: sizeof(cint), pure.} = enum
    autoStart = 0

  BusNameWatcherFlags* {.size: sizeof(cint).} = set[BusNameWatcherFlag]

const
  BusNameWatcherFlagsNone* = BusNameWatcherFlags({})
proc none*(t: typedesc[BusNameWatcherFlags]): BusNameWatcherFlags = BusNameWatcherFlags({})

type
  CancellableSourceFunc* = proc (cancellable: ptr Cancellable00; userData: pointer): gboolean {.cdecl.}

type
  CharsetConverter* = ref object of gobject.Object
  CharsetConverter00* = object of gobject.Object00

proc g_charset_converter_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(CharsetConverter()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc g_charset_converter_new(toCharset: cstring; fromCharset: cstring; error: ptr ptr glib.Error = nil): ptr CharsetConverter00 {.
    importc, libprag.}

proc newCharsetConverter*(toCharset: cstring; fromCharset: cstring): CharsetConverter =
  var gerror: ptr glib.Error
  let gobj = g_charset_converter_new(toCharset, fromCharset, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newCharsetConverter*(tdesc: typedesc; toCharset: cstring; fromCharset: cstring): tdesc =
  var gerror: ptr glib.Error
  assert(result is CharsetConverter)
  let gobj = g_charset_converter_new(toCharset, fromCharset, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initCharsetConverter*[T](result: var T; toCharset: cstring; fromCharset: cstring) {.deprecated.} =
  var gerror: ptr glib.Error
  assert(result is CharsetConverter)
  let gobj = g_charset_converter_new(toCharset, fromCharset, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_charset_converter_get_num_fallbacks(self: ptr CharsetConverter00): uint32 {.
    importc, libprag.}

proc getNumFallbacks*(self: CharsetConverter): int =
  int(g_charset_converter_get_num_fallbacks(cast[ptr CharsetConverter00](self.impl)))

proc numFallbacks*(self: CharsetConverter): int =
  int(g_charset_converter_get_num_fallbacks(cast[ptr CharsetConverter00](self.impl)))

proc g_charset_converter_get_use_fallback(self: ptr CharsetConverter00): gboolean {.
    importc, libprag.}

proc getUseFallback*(self: CharsetConverter): bool =
  toBool(g_charset_converter_get_use_fallback(cast[ptr CharsetConverter00](self.impl)))

proc useFallback*(self: CharsetConverter): bool =
  toBool(g_charset_converter_get_use_fallback(cast[ptr CharsetConverter00](self.impl)))

proc g_charset_converter_set_use_fallback(self: ptr CharsetConverter00; useFallback: gboolean) {.
    importc, libprag.}

proc setUseFallback*(self: CharsetConverter; useFallback: bool = true) =
  g_charset_converter_set_use_fallback(cast[ptr CharsetConverter00](self.impl), gboolean(useFallback))

proc `useFallback=`*(self: CharsetConverter; useFallback: bool) =
  g_charset_converter_set_use_fallback(cast[ptr CharsetConverter00](self.impl), gboolean(useFallback))

type
  Converter00* = object of gobject.Object00
  Converter* = ref object of gobject.Object

type
  ZlibCompressor* = ref object of gobject.Object
  ZlibCompressor00* = object of gobject.Object00

proc g_zlib_compressor_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(ZlibCompressor()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc g_zlib_compressor_get_file_info(self: ptr ZlibCompressor00): ptr FileInfo00 {.
    importc, libprag.}

proc getFileInfo*(self: ZlibCompressor): FileInfo =
  let gobj = g_zlib_compressor_get_file_info(cast[ptr ZlibCompressor00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc fileInfo*(self: ZlibCompressor): FileInfo =
  let gobj = g_zlib_compressor_get_file_info(cast[ptr ZlibCompressor00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_zlib_compressor_set_file_info(self: ptr ZlibCompressor00; fileInfo: ptr FileInfo00) {.
    importc, libprag.}

proc setFileInfo*(self: ZlibCompressor; fileInfo: FileInfo = nil) =
  g_zlib_compressor_set_file_info(cast[ptr ZlibCompressor00](self.impl), if fileInfo.isNil: nil else: cast[ptr FileInfo00](fileInfo.impl))

proc `fileInfo=`*(self: ZlibCompressor; fileInfo: FileInfo = nil) =
  g_zlib_compressor_set_file_info(cast[ptr ZlibCompressor00](self.impl), if fileInfo.isNil: nil else: cast[ptr FileInfo00](fileInfo.impl))

type
  ZlibDecompressor* = ref object of gobject.Object
  ZlibDecompressor00* = object of gobject.Object00

proc g_zlib_decompressor_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(ZlibDecompressor()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc g_zlib_decompressor_get_file_info(self: ptr ZlibDecompressor00): ptr FileInfo00 {.
    importc, libprag.}

proc getFileInfo*(self: ZlibDecompressor): FileInfo =
  let gobj = g_zlib_decompressor_get_file_info(cast[ptr ZlibDecompressor00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc fileInfo*(self: ZlibDecompressor): FileInfo =
  let gobj = g_zlib_decompressor_get_file_info(cast[ptr ZlibDecompressor00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_converter_reset(self: ptr Converter00) {.
    importc, libprag.}

proc reset*(self: Converter | ZlibCompressor | ZlibDecompressor | CharsetConverter) =
  g_converter_reset(cast[ptr Converter00](self.impl))

type
  ZlibCompressorFormat* {.size: sizeof(cint), pure.} = enum
    zlib = 0
    gzip = 1
    raw = 2

proc g_zlib_compressor_new(format: ZlibCompressorFormat; level: int32): ptr ZlibCompressor00 {.
    importc, libprag.}

proc newZlibCompressor*(format: ZlibCompressorFormat; level: int): ZlibCompressor =
  let gobj = g_zlib_compressor_new(format, int32(level))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newZlibCompressor*(tdesc: typedesc; format: ZlibCompressorFormat; level: int): tdesc =
  assert(result is ZlibCompressor)
  let gobj = g_zlib_compressor_new(format, int32(level))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initZlibCompressor*[T](result: var T; format: ZlibCompressorFormat; level: int) {.deprecated.} =
  assert(result is ZlibCompressor)
  let gobj = g_zlib_compressor_new(format, int32(level))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_zlib_decompressor_new(format: ZlibCompressorFormat): ptr ZlibDecompressor00 {.
    importc, libprag.}

proc newZlibDecompressor*(format: ZlibCompressorFormat): ZlibDecompressor =
  let gobj = g_zlib_decompressor_new(format)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newZlibDecompressor*(tdesc: typedesc; format: ZlibCompressorFormat): tdesc =
  assert(result is ZlibDecompressor)
  let gobj = g_zlib_decompressor_new(format)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initZlibDecompressor*[T](result: var T; format: ZlibCompressorFormat) {.deprecated.} =
  assert(result is ZlibDecompressor)
  let gobj = g_zlib_decompressor_new(format)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

type
  ConverterFlag* {.size: sizeof(cint), pure.} = enum
    inputAtEnd = 0
    flush = 1

  ConverterFlags* {.size: sizeof(cint).} = set[ConverterFlag]

const
  ConverterFlagsNone* = ConverterFlags({})
proc none*(t: typedesc[ConverterFlags]): ConverterFlags = ConverterFlags({})

type
  ConverterInputStream* = ref object of FilterInputStream
  ConverterInputStream00* = object of FilterInputStream00

proc g_converter_input_stream_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(ConverterInputStream()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc g_converter_input_stream_new(baseStream: ptr InputStream00; `converter`: ptr Converter00): ptr ConverterInputStream00 {.
    importc, libprag.}

proc newConverterInputStream*(baseStream: InputStream; `converter`: Converter | ZlibCompressor | ZlibDecompressor | CharsetConverter): ConverterInputStream =
  let gobj = g_converter_input_stream_new(cast[ptr InputStream00](baseStream.impl), cast[ptr Converter00](`converter`.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newConverterInputStream*(tdesc: typedesc; baseStream: InputStream; `converter`: Converter | ZlibCompressor | ZlibDecompressor | CharsetConverter): tdesc =
  assert(result is ConverterInputStream)
  let gobj = g_converter_input_stream_new(cast[ptr InputStream00](baseStream.impl), cast[ptr Converter00](`converter`.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initConverterInputStream*[T](result: var T; baseStream: InputStream; `converter`: Converter | ZlibCompressor | ZlibDecompressor | CharsetConverter) {.deprecated.} =
  assert(result is ConverterInputStream)
  let gobj = g_converter_input_stream_new(cast[ptr InputStream00](baseStream.impl), cast[ptr Converter00](`converter`.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_converter_input_stream_get_converter(self: ptr ConverterInputStream00): ptr Converter00 {.
    importc, libprag.}

proc getConverter*(self: ConverterInputStream): Converter =
  let gobj = g_converter_input_stream_get_converter(cast[ptr ConverterInputStream00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

type
  ConverterOutputStream* = ref object of FilterOutputStream
  ConverterOutputStream00* = object of FilterOutputStream00

proc g_converter_output_stream_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(ConverterOutputStream()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc g_converter_output_stream_new(baseStream: ptr OutputStream00; `converter`: ptr Converter00): ptr ConverterOutputStream00 {.
    importc, libprag.}

proc newConverterOutputStream*(baseStream: OutputStream; `converter`: Converter | ZlibCompressor | ZlibDecompressor | CharsetConverter): ConverterOutputStream =
  let gobj = g_converter_output_stream_new(cast[ptr OutputStream00](baseStream.impl), cast[ptr Converter00](`converter`.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newConverterOutputStream*(tdesc: typedesc; baseStream: OutputStream; `converter`: Converter | ZlibCompressor | ZlibDecompressor | CharsetConverter): tdesc =
  assert(result is ConverterOutputStream)
  let gobj = g_converter_output_stream_new(cast[ptr OutputStream00](baseStream.impl), cast[ptr Converter00](`converter`.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initConverterOutputStream*[T](result: var T; baseStream: OutputStream; `converter`: Converter | ZlibCompressor | ZlibDecompressor | CharsetConverter) {.deprecated.} =
  assert(result is ConverterOutputStream)
  let gobj = g_converter_output_stream_new(cast[ptr OutputStream00](baseStream.impl), cast[ptr Converter00](`converter`.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_converter_output_stream_get_converter(self: ptr ConverterOutputStream00): ptr Converter00 {.
    importc, libprag.}

proc getConverter*(self: ConverterOutputStream): Converter =
  let gobj = g_converter_output_stream_get_converter(cast[ptr ConverterOutputStream00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

type
  ConverterResult* {.size: sizeof(cint), pure.} = enum
    error = 0
    converted = 1
    finished = 2
    flushed = 3

type
  DBusAnnotationInfo00* {.pure.} = object
  DBusAnnotationInfo* = ref object
    impl*: ptr DBusAnnotationInfo00
    ignoreFinalizer*: bool

proc g_dbus_annotation_info_get_type*(): GType {.importc, libprag.}

proc gBoxedFreeGDBusAnnotationInfo*(self: DBusAnnotationInfo) =
  if not self.ignoreFinalizer:
    boxedFree(g_dbus_annotation_info_get_type(), cast[ptr DBusAnnotationInfo00](self.impl))

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(DBusAnnotationInfo()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    if not self.ignoreFinalizer and self.impl != nil:
      boxedFree(g_dbus_annotation_info_get_type(), cast[ptr DBusAnnotationInfo00](self.impl))
      self.impl = nil

proc newWithFinalizer*(x: var DBusAnnotationInfo) =
  when defined(gcDestructors):
    new(x)
  else:
    new(x, gBoxedFreeGDBusAnnotationInfo)

proc g_dbus_annotation_info_unref(self: ptr DBusAnnotationInfo00) {.
    importc, libprag.}

proc unref*(self: DBusAnnotationInfo) =
  g_dbus_annotation_info_unref(cast[ptr DBusAnnotationInfo00](self.impl))

proc finalizerunref*(self: DBusAnnotationInfo) =
  if not self.ignoreFinalizer:
    g_dbus_annotation_info_unref(cast[ptr DBusAnnotationInfo00](self.impl))

proc g_dbus_annotation_info_ref(self: ptr DBusAnnotationInfo00): ptr DBusAnnotationInfo00 {.
    importc, libprag.}

proc `ref`*(self: DBusAnnotationInfo): DBusAnnotationInfo =
  fnew(result, gBoxedFreeGDBusAnnotationInfo)
  result.impl = g_dbus_annotation_info_ref(cast[ptr DBusAnnotationInfo00](self.impl))

proc g_dbus_annotation_info_lookup(annotations: ptr ptr DBusAnnotationInfo00;
    name: cstring): cstring {.
    importc, libprag.}

proc lookup*(annotations: ptr ptr DBusAnnotationInfo00;
    name: cstring): string =
  result = $g_dbus_annotation_info_lookup(annotations, name)

type
  DBusArgInfo00* {.pure.} = object
  DBusArgInfo* = ref object
    impl*: ptr DBusArgInfo00
    ignoreFinalizer*: bool

proc g_dbus_arg_info_get_type*(): GType {.importc, libprag.}

proc gBoxedFreeGDBusArgInfo*(self: DBusArgInfo) =
  if not self.ignoreFinalizer:
    boxedFree(g_dbus_arg_info_get_type(), cast[ptr DBusArgInfo00](self.impl))

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(DBusArgInfo()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    if not self.ignoreFinalizer and self.impl != nil:
      boxedFree(g_dbus_arg_info_get_type(), cast[ptr DBusArgInfo00](self.impl))
      self.impl = nil

proc newWithFinalizer*(x: var DBusArgInfo) =
  when defined(gcDestructors):
    new(x)
  else:
    new(x, gBoxedFreeGDBusArgInfo)

proc g_dbus_arg_info_unref(self: ptr DBusArgInfo00) {.
    importc, libprag.}

proc unref*(self: DBusArgInfo) =
  g_dbus_arg_info_unref(cast[ptr DBusArgInfo00](self.impl))

proc finalizerunref*(self: DBusArgInfo) =
  if not self.ignoreFinalizer:
    g_dbus_arg_info_unref(cast[ptr DBusArgInfo00](self.impl))

proc g_dbus_arg_info_ref(self: ptr DBusArgInfo00): ptr DBusArgInfo00 {.
    importc, libprag.}

proc `ref`*(self: DBusArgInfo): DBusArgInfo =
  fnew(result, gBoxedFreeGDBusArgInfo)
  result.impl = g_dbus_arg_info_ref(cast[ptr DBusArgInfo00](self.impl))

type
  DBusError* {.size: sizeof(cint), pure.} = enum
    failed = 0
    noMemory = 1
    serviceUnknown = 2
    nameHasNoOwner = 3
    noReply = 4
    ioError = 5
    badAddress = 6
    notSupported = 7
    limitsExceeded = 8
    accessDenied = 9
    authFailed = 10
    noServer = 11
    timeout = 12
    noNetwork = 13
    addressInUse = 14
    disconnected = 15
    invalidArgs = 16
    fileNotFound = 17
    fileExists = 18
    unknownMethod = 19
    timedOut = 20
    matchRuleNotFound = 21
    matchRuleInvalid = 22
    spawnExecFailed = 23
    spawnForkFailed = 24
    spawnChildExited = 25
    spawnChildSignaled = 26
    spawnFailed = 27
    spawnSetupFailed = 28
    spawnConfigInvalid = 29
    spawnServiceInvalid = 30
    spawnServiceNotFound = 31
    spawnPermissionsInvalid = 32
    spawnFileInvalid = 33
    spawnNoMemory = 34
    unixProcessIdUnknown = 35
    invalidSignature = 36
    invalidFileContent = 37
    selinuxSecurityContextUnknown = 38
    adtAuditDataUnknown = 39
    objectPathInUse = 40
    unknownObject = 41
    unknownInterface = 42
    unknownProperty = 43
    propertyReadOnly = 44

proc g_dbus_error_encode_gerror(error: ptr glib.Error): cstring {.
    importc, libprag.}

proc encodeGerror*(error: ptr glib.Error): string =
  let resul0 = g_dbus_error_encode_gerror(error)
  result = $resul0
  cogfree(resul0)

proc g_dbus_error_get_remote_error(error: ptr glib.Error): cstring {.
    importc, libprag.}

proc getRemoteError*(error: ptr glib.Error): string =
  let resul0 = g_dbus_error_get_remote_error(error)
  result = $resul0
  cogfree(resul0)

proc remoteError*(error: ptr glib.Error): string =
  let resul0 = g_dbus_error_get_remote_error(error)
  result = $resul0
  cogfree(resul0)

proc g_dbus_error_is_remote_error(error: ptr glib.Error): gboolean {.
    importc, libprag.}

proc isRemoteError*(error: ptr glib.Error): bool =
  toBool(g_dbus_error_is_remote_error(error))

proc newForDbusError*(dbusErrorName: cstring; dbusErrorMessage: cstring): ptr glib.Error {.
    importc: "g_dbus_error_new_for_dbus_error", libprag.}

proc g_dbus_error_register_error(errorDomain: uint32; errorCode: int32; dbusErrorName: cstring): gboolean {.
    importc, libprag.}

proc registerError*(errorDomain: int; errorCode: int; dbusErrorName: cstring): bool =
  toBool(g_dbus_error_register_error(uint32(errorDomain), int32(errorCode), dbusErrorName))

proc g_dbus_error_strip_remote_error(error: ptr glib.Error): gboolean {.
    importc, libprag.}

proc stripRemoteError*(error: ptr glib.Error): bool =
  toBool(g_dbus_error_strip_remote_error(error))

proc g_dbus_error_unregister_error(errorDomain: uint32; errorCode: int32;
    dbusErrorName: cstring): gboolean {.
    importc, libprag.}

proc unregisterError*(errorDomain: int; errorCode: int; dbusErrorName: cstring): bool =
  toBool(g_dbus_error_unregister_error(uint32(errorDomain), int32(errorCode), dbusErrorName))

type
  DBusErrorEntry* {.pure, byRef.} = object
    errorCode*: int32
    dbusErrorName*: cstring

proc g_dbus_error_register_error_domain(errorDomainQuarkName: cstring; quarkVolatile: ptr uint64;
    entries: ptr DBusErrorEntry; numEntries: uint32) {.
    importc, libprag.}

proc registerErrorDomain*(errorDomainQuarkName: cstring; quarkVolatile: ptr uint64;
    entries: ptr DBusErrorEntry; numEntries: int) =
  g_dbus_error_register_error_domain(errorDomainQuarkName, quarkVolatile, entries, uint32(numEntries))

type
  DBusInterface00* = object of gobject.Object00
  DBusInterface* = ref object of gobject.Object

type
  DBusMethodInvocation* = ref object of gobject.Object
  DBusMethodInvocation00* = object of gobject.Object00

proc g_dbus_method_invocation_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(DBusMethodInvocation()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc g_dbus_method_invocation_get_connection(self: ptr DBusMethodInvocation00): ptr DBusConnection00 {.
    importc, libprag.}

proc getConnection*(self: DBusMethodInvocation): DBusConnection =
  let gobj = g_dbus_method_invocation_get_connection(cast[ptr DBusMethodInvocation00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc connection*(self: DBusMethodInvocation): DBusConnection =
  let gobj = g_dbus_method_invocation_get_connection(cast[ptr DBusMethodInvocation00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_dbus_method_invocation_get_interface_name(self: ptr DBusMethodInvocation00): cstring {.
    importc, libprag.}

proc getInterfaceName*(self: DBusMethodInvocation): string =
  result = $g_dbus_method_invocation_get_interface_name(cast[ptr DBusMethodInvocation00](self.impl))

proc interfaceName*(self: DBusMethodInvocation): string =
  result = $g_dbus_method_invocation_get_interface_name(cast[ptr DBusMethodInvocation00](self.impl))

proc g_dbus_method_invocation_get_message(self: ptr DBusMethodInvocation00): ptr DBusMessage00 {.
    importc, libprag.}

proc getMessage*(self: DBusMethodInvocation): DBusMessage =
  let gobj = g_dbus_method_invocation_get_message(cast[ptr DBusMethodInvocation00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc message*(self: DBusMethodInvocation): DBusMessage =
  let gobj = g_dbus_method_invocation_get_message(cast[ptr DBusMethodInvocation00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_dbus_method_invocation_get_method_info(self: ptr DBusMethodInvocation00): ptr DBusMethodInfo00 {.
    importc, libprag.}

proc getMethodInfo*(self: DBusMethodInvocation): DBusMethodInfo =
  fnew(result, gBoxedFreeGDBusMethodInfo)
  result.impl = g_dbus_method_invocation_get_method_info(cast[ptr DBusMethodInvocation00](self.impl))
  result.impl = cast[typeof(result.impl)](g_boxed_copy(g_dbus_method_info_get_type(), result.impl))

proc methodInfo*(self: DBusMethodInvocation): DBusMethodInfo =
  fnew(result, gBoxedFreeGDBusMethodInfo)
  result.impl = g_dbus_method_invocation_get_method_info(cast[ptr DBusMethodInvocation00](self.impl))
  result.impl = cast[typeof(result.impl)](g_boxed_copy(g_dbus_method_info_get_type(), result.impl))

proc g_dbus_method_invocation_get_method_name(self: ptr DBusMethodInvocation00): cstring {.
    importc, libprag.}

proc getMethodName*(self: DBusMethodInvocation): string =
  result = $g_dbus_method_invocation_get_method_name(cast[ptr DBusMethodInvocation00](self.impl))

proc methodName*(self: DBusMethodInvocation): string =
  result = $g_dbus_method_invocation_get_method_name(cast[ptr DBusMethodInvocation00](self.impl))

proc g_dbus_method_invocation_get_object_path(self: ptr DBusMethodInvocation00): cstring {.
    importc, libprag.}

proc getObjectPath*(self: DBusMethodInvocation): string =
  result = $g_dbus_method_invocation_get_object_path(cast[ptr DBusMethodInvocation00](self.impl))

proc objectPath*(self: DBusMethodInvocation): string =
  result = $g_dbus_method_invocation_get_object_path(cast[ptr DBusMethodInvocation00](self.impl))

proc g_dbus_method_invocation_get_parameters(self: ptr DBusMethodInvocation00): ptr glib.Variant00 {.
    importc, libprag.}

proc getParameters*(self: DBusMethodInvocation): glib.Variant =
  fnew(result, finalizerunref)
  result.impl = g_dbus_method_invocation_get_parameters(cast[ptr DBusMethodInvocation00](self.impl))
  result.ignoreFinalizer = true # GVariant

proc parameters*(self: DBusMethodInvocation): glib.Variant =
  fnew(result, finalizerunref)
  result.impl = g_dbus_method_invocation_get_parameters(cast[ptr DBusMethodInvocation00](self.impl))
  result.ignoreFinalizer = true # GVariant

proc g_dbus_method_invocation_get_property_info(self: ptr DBusMethodInvocation00): ptr DBusPropertyInfo00 {.
    importc, libprag.}

proc getPropertyInfo*(self: DBusMethodInvocation): DBusPropertyInfo =
  fnew(result, gBoxedFreeGDBusPropertyInfo)
  result.impl = g_dbus_method_invocation_get_property_info(cast[ptr DBusMethodInvocation00](self.impl))
  result.impl = cast[typeof(result.impl)](g_boxed_copy(g_dbus_property_info_get_type(), result.impl))

proc propertyInfo*(self: DBusMethodInvocation): DBusPropertyInfo =
  fnew(result, gBoxedFreeGDBusPropertyInfo)
  result.impl = g_dbus_method_invocation_get_property_info(cast[ptr DBusMethodInvocation00](self.impl))
  result.impl = cast[typeof(result.impl)](g_boxed_copy(g_dbus_property_info_get_type(), result.impl))

proc g_dbus_method_invocation_get_sender(self: ptr DBusMethodInvocation00): cstring {.
    importc, libprag.}

proc getSender*(self: DBusMethodInvocation): string =
  result = $g_dbus_method_invocation_get_sender(cast[ptr DBusMethodInvocation00](self.impl))

proc sender*(self: DBusMethodInvocation): string =
  result = $g_dbus_method_invocation_get_sender(cast[ptr DBusMethodInvocation00](self.impl))

proc g_dbus_method_invocation_return_dbus_error(self: ptr DBusMethodInvocation00;
    errorName: cstring; errorMessage: cstring) {.
    importc, libprag.}

proc returnDbusError*(self: DBusMethodInvocation;
    errorName: cstring; errorMessage: cstring) =
  g_dbus_method_invocation_return_dbus_error(cast[ptr DBusMethodInvocation00](g_object_ref(self.impl)), errorName, errorMessage)

proc g_dbus_method_invocation_return_error_literal(self: ptr DBusMethodInvocation00;
    domain: uint32; code: int32; message: cstring) {.
    importc, libprag.}

proc returnErrorLiteral*(self: DBusMethodInvocation;
    domain: int; code: int; message: cstring) =
  g_dbus_method_invocation_return_error_literal(cast[ptr DBusMethodInvocation00](g_object_ref(self.impl)), uint32(domain), int32(code), message)

proc g_dbus_method_invocation_return_gerror(self: ptr DBusMethodInvocation00;
    error: ptr glib.Error) {.
    importc, libprag.}

proc returnGerror*(self: DBusMethodInvocation; error: ptr glib.Error) =
  g_dbus_method_invocation_return_gerror(cast[ptr DBusMethodInvocation00](g_object_ref(self.impl)), error)

proc g_dbus_method_invocation_return_value(self: ptr DBusMethodInvocation00;
    parameters: ptr glib.Variant00) {.
    importc, libprag.}

proc returnValue*(self: DBusMethodInvocation; parameters: glib.Variant = nil) =
  g_dbus_method_invocation_return_value(cast[ptr DBusMethodInvocation00](g_object_ref(self.impl)), if parameters.isNil: nil else: cast[ptr glib.Variant00](parameters.impl))

proc g_dbus_method_invocation_return_value_with_unix_fd_list(self: ptr DBusMethodInvocation00;
    parameters: ptr glib.Variant00; fdList: ptr UnixFDList00) {.
    importc, libprag.}

proc returnValueWithUnixFdList*(self: DBusMethodInvocation;
    parameters: glib.Variant = nil; fdList: UnixFDList = nil) =
  g_dbus_method_invocation_return_value_with_unix_fd_list(cast[ptr DBusMethodInvocation00](g_object_ref(self.impl)), if parameters.isNil: nil else: cast[ptr glib.Variant00](parameters.impl), if fdList.isNil: nil else: cast[ptr UnixFDList00](fdList.impl))

type
  DBusInterfaceSkeleton* = ref object of gobject.Object
  DBusInterfaceSkeleton00* = object of gobject.Object00

proc g_dbus_interface_skeleton_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(DBusInterfaceSkeleton()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc scGAuthorizeMethod*(self: DBusInterfaceSkeleton;  p: proc (self: ptr DBusInterfaceSkeleton00; invocation: ptr DBusMethodInvocation00; xdata: pointer): gboolean {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "g-authorize-method", cast[GCallback](p), xdata, nil, cf)

proc g_dbus_interface_skeleton_export(self: ptr DBusInterfaceSkeleton00;
    connection: ptr DBusConnection00; objectPath: cstring; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc `export`*(self: DBusInterfaceSkeleton; connection: DBusConnection;
    objectPath: cstring): bool =
  var gerror: ptr glib.Error
  let resul0 = g_dbus_interface_skeleton_export(cast[ptr DBusInterfaceSkeleton00](self.impl), cast[ptr DBusConnection00](connection.impl), objectPath, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_dbus_interface_skeleton_flush(self: ptr DBusInterfaceSkeleton00) {.
    importc, libprag.}

proc flush*(self: DBusInterfaceSkeleton) =
  g_dbus_interface_skeleton_flush(cast[ptr DBusInterfaceSkeleton00](self.impl))

proc g_dbus_interface_skeleton_get_connection(self: ptr DBusInterfaceSkeleton00): ptr DBusConnection00 {.
    importc, libprag.}

proc getConnection*(self: DBusInterfaceSkeleton): DBusConnection =
  let gobj = g_dbus_interface_skeleton_get_connection(cast[ptr DBusInterfaceSkeleton00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc connection*(self: DBusInterfaceSkeleton): DBusConnection =
  let gobj = g_dbus_interface_skeleton_get_connection(cast[ptr DBusInterfaceSkeleton00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_dbus_interface_skeleton_get_connections(self: ptr DBusInterfaceSkeleton00): ptr glib.List {.
    importc, libprag.}

proc getConnections*(self: DBusInterfaceSkeleton): seq[DBusConnection] =
  let resul0 = g_dbus_interface_skeleton_get_connections(cast[ptr DBusInterfaceSkeleton00](self.impl))
  result = glistObjects2seq(DBusConnection, resul0, true)
  g_list_free(resul0)

proc connections*(self: DBusInterfaceSkeleton): seq[DBusConnection] =
  let resul0 = g_dbus_interface_skeleton_get_connections(cast[ptr DBusInterfaceSkeleton00](self.impl))
  result = glistObjects2seq(DBusConnection, resul0, true)
  g_list_free(resul0)

proc g_dbus_interface_skeleton_get_info(self: ptr DBusInterfaceSkeleton00): ptr DBusInterfaceInfo00 {.
    importc, libprag.}

proc getInfoDBusInterfaceSkeleton*(self: DBusInterfaceSkeleton): DBusInterfaceInfo =
  fnew(result, gBoxedFreeGDBusInterfaceInfo)
  result.impl = g_dbus_interface_skeleton_get_info(cast[ptr DBusInterfaceSkeleton00](self.impl))
  result.impl = cast[typeof(result.impl)](g_boxed_copy(g_dbus_interface_info_get_type(), result.impl))

proc infoDBusInterfaceSkeleton*(self: DBusInterfaceSkeleton): DBusInterfaceInfo =
  fnew(result, gBoxedFreeGDBusInterfaceInfo)
  result.impl = g_dbus_interface_skeleton_get_info(cast[ptr DBusInterfaceSkeleton00](self.impl))
  result.impl = cast[typeof(result.impl)](g_boxed_copy(g_dbus_interface_info_get_type(), result.impl))

proc g_dbus_interface_skeleton_get_object_path(self: ptr DBusInterfaceSkeleton00): cstring {.
    importc, libprag.}

proc getObjectPath*(self: DBusInterfaceSkeleton): string =
  result = $g_dbus_interface_skeleton_get_object_path(cast[ptr DBusInterfaceSkeleton00](self.impl))

proc objectPath*(self: DBusInterfaceSkeleton): string =
  result = $g_dbus_interface_skeleton_get_object_path(cast[ptr DBusInterfaceSkeleton00](self.impl))

proc g_dbus_interface_skeleton_get_properties(self: ptr DBusInterfaceSkeleton00): ptr glib.Variant00 {.
    importc, libprag.}

proc getProperties*(self: DBusInterfaceSkeleton): glib.Variant =
  fnew(result, finalizerunref)
  result.impl = g_dbus_interface_skeleton_get_properties(cast[ptr DBusInterfaceSkeleton00](self.impl))

proc properties*(self: DBusInterfaceSkeleton): glib.Variant =
  fnew(result, finalizerunref)
  result.impl = g_dbus_interface_skeleton_get_properties(cast[ptr DBusInterfaceSkeleton00](self.impl))

proc g_dbus_interface_skeleton_has_connection(self: ptr DBusInterfaceSkeleton00;
    connection: ptr DBusConnection00): gboolean {.
    importc, libprag.}

proc hasConnection*(self: DBusInterfaceSkeleton;
    connection: DBusConnection): bool =
  toBool(g_dbus_interface_skeleton_has_connection(cast[ptr DBusInterfaceSkeleton00](self.impl), cast[ptr DBusConnection00](connection.impl)))

proc g_dbus_interface_skeleton_unexport(self: ptr DBusInterfaceSkeleton00) {.
    importc, libprag.}

proc unexport*(self: DBusInterfaceSkeleton) =
  g_dbus_interface_skeleton_unexport(cast[ptr DBusInterfaceSkeleton00](self.impl))

proc g_dbus_interface_skeleton_unexport_from_connection(self: ptr DBusInterfaceSkeleton00;
    connection: ptr DBusConnection00) {.
    importc, libprag.}

proc unexportFromConnection*(self: DBusInterfaceSkeleton;
    connection: DBusConnection) =
  g_dbus_interface_skeleton_unexport_from_connection(cast[ptr DBusInterfaceSkeleton00](self.impl), cast[ptr DBusConnection00](connection.impl))

proc g_dbus_interface_get_info(self: ptr DBusInterface00): ptr DBusInterfaceInfo00 {.
    importc, libprag.}

proc getInfoDBusInterface*(self: DBusInterface | DBusInterfaceSkeleton | DBusProxy): DBusInterfaceInfo =
  fnew(result, gBoxedFreeGDBusInterfaceInfo)
  result.impl = g_dbus_interface_get_info(cast[ptr DBusInterface00](self.impl))
  result.impl = cast[typeof(result.impl)](g_boxed_copy(g_dbus_interface_info_get_type(), result.impl))

proc infoDBusInterface*(self: DBusInterface | DBusInterfaceSkeleton | DBusProxy): DBusInterfaceInfo =
  fnew(result, gBoxedFreeGDBusInterfaceInfo)
  result.impl = g_dbus_interface_get_info(cast[ptr DBusInterface00](self.impl))
  result.impl = cast[typeof(result.impl)](g_boxed_copy(g_dbus_interface_info_get_type(), result.impl))

type
  DBusInterfaceSkeletonFlag* {.size: sizeof(cint), pure.} = enum
    handleMethodInvocationsInThread = 0

  DBusInterfaceSkeletonFlags* {.size: sizeof(cint).} = set[DBusInterfaceSkeletonFlag]

const
  DBusInterfaceSkeletonFlagsNone* = DBusInterfaceSkeletonFlags({})
proc none*(t: typedesc[DBusInterfaceSkeletonFlags]): DBusInterfaceSkeletonFlags = DBusInterfaceSkeletonFlags({})

proc g_dbus_interface_skeleton_get_flags(self: ptr DBusInterfaceSkeleton00): DBusInterfaceSkeletonFlags {.
    importc, libprag.}

proc getFlags*(self: DBusInterfaceSkeleton): DBusInterfaceSkeletonFlags =
  g_dbus_interface_skeleton_get_flags(cast[ptr DBusInterfaceSkeleton00](self.impl))

proc flags*(self: DBusInterfaceSkeleton): DBusInterfaceSkeletonFlags =
  g_dbus_interface_skeleton_get_flags(cast[ptr DBusInterfaceSkeleton00](self.impl))

proc g_dbus_interface_skeleton_set_flags(self: ptr DBusInterfaceSkeleton00;
    flags: DBusInterfaceSkeletonFlags) {.
    importc, libprag.}

proc setFlags*(self: DBusInterfaceSkeleton; flags: DBusInterfaceSkeletonFlags) =
  g_dbus_interface_skeleton_set_flags(cast[ptr DBusInterfaceSkeleton00](self.impl), flags)

proc `flags=`*(self: DBusInterfaceSkeleton; flags: DBusInterfaceSkeletonFlags) =
  g_dbus_interface_skeleton_set_flags(cast[ptr DBusInterfaceSkeleton00](self.impl), flags)

type
  DBusObjectSkeleton* = ref object of gobject.Object
  DBusObjectSkeleton00* = object of gobject.Object00

proc g_dbus_object_skeleton_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(DBusObjectSkeleton()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc scAuthorizeMethod*(self: DBusObjectSkeleton;  p: proc (self: ptr DBusObjectSkeleton00; `interface`: ptr DBusInterfaceSkeleton00; invocation: ptr DBusMethodInvocation00; xdata: pointer): gboolean {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "authorize-method", cast[GCallback](p), xdata, nil, cf)

proc g_dbus_object_skeleton_new(objectPath: cstring): ptr DBusObjectSkeleton00 {.
    importc, libprag.}

proc newDBusObjectSkeleton*(objectPath: cstring): DBusObjectSkeleton =
  let gobj = g_dbus_object_skeleton_new(objectPath)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newDBusObjectSkeleton*(tdesc: typedesc; objectPath: cstring): tdesc =
  assert(result is DBusObjectSkeleton)
  let gobj = g_dbus_object_skeleton_new(objectPath)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initDBusObjectSkeleton*[T](result: var T; objectPath: cstring) {.deprecated.} =
  assert(result is DBusObjectSkeleton)
  let gobj = g_dbus_object_skeleton_new(objectPath)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_dbus_object_skeleton_add_interface(self: ptr DBusObjectSkeleton00;
    `interface`: ptr DBusInterfaceSkeleton00) {.
    importc, libprag.}

proc addInterface*(self: DBusObjectSkeleton; `interface`: DBusInterfaceSkeleton) =
  g_dbus_object_skeleton_add_interface(cast[ptr DBusObjectSkeleton00](self.impl), cast[ptr DBusInterfaceSkeleton00](`interface`.impl))

proc g_dbus_object_skeleton_flush(self: ptr DBusObjectSkeleton00) {.
    importc, libprag.}

proc flush*(self: DBusObjectSkeleton) =
  g_dbus_object_skeleton_flush(cast[ptr DBusObjectSkeleton00](self.impl))

proc g_dbus_object_skeleton_remove_interface(self: ptr DBusObjectSkeleton00;
    `interface`: ptr DBusInterfaceSkeleton00) {.
    importc, libprag.}

proc removeInterface*(self: DBusObjectSkeleton; `interface`: DBusInterfaceSkeleton) =
  g_dbus_object_skeleton_remove_interface(cast[ptr DBusObjectSkeleton00](self.impl), cast[ptr DBusInterfaceSkeleton00](`interface`.impl))

proc g_dbus_object_skeleton_remove_interface_by_name(self: ptr DBusObjectSkeleton00;
    interfaceName: cstring) {.
    importc, libprag.}

proc removeInterfaceByName*(self: DBusObjectSkeleton;
    interfaceName: cstring) =
  g_dbus_object_skeleton_remove_interface_by_name(cast[ptr DBusObjectSkeleton00](self.impl), interfaceName)

proc g_dbus_object_skeleton_set_object_path(self: ptr DBusObjectSkeleton00;
    objectPath: cstring) {.
    importc, libprag.}

proc setObjectPath*(self: DBusObjectSkeleton; objectPath: cstring) =
  g_dbus_object_skeleton_set_object_path(cast[ptr DBusObjectSkeleton00](self.impl), objectPath)

proc `objectPath=`*(self: DBusObjectSkeleton; objectPath: cstring) =
  g_dbus_object_skeleton_set_object_path(cast[ptr DBusObjectSkeleton00](self.impl), objectPath)

type
  DBusObject00* = object of gobject.Object00
  DBusObject* = ref object of gobject.Object

proc scInterfaceAdded*(self: DBusObject | DBusObjectSkeleton | DBusObjectProxy;  p: proc (self: ptr DBusObject00; `interface`: ptr DBusInterface00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "interface-added", cast[GCallback](p), xdata, nil, cf)

proc scInterfaceRemoved*(self: DBusObject | DBusObjectSkeleton | DBusObjectProxy;  p: proc (self: ptr DBusObject00; `interface`: ptr DBusInterface00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "interface-removed", cast[GCallback](p), xdata, nil, cf)

proc g_dbus_object_get_interface(self: ptr DBusObject00; interfaceName: cstring): ptr DBusInterface00 {.
    importc, libprag.}

proc getInterface*(self: DBusObject | DBusObjectSkeleton | DBusObjectProxy;
    interfaceName: cstring): DBusInterface =
  let gobj = g_dbus_object_get_interface(cast[ptr DBusObject00](self.impl), interfaceName)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_dbus_object_get_interfaces(self: ptr DBusObject00): ptr glib.List {.
    importc, libprag.}

proc getInterfaces*(self: DBusObject | DBusObjectSkeleton | DBusObjectProxy): seq[DBusInterface] =
  let resul0 = g_dbus_object_get_interfaces(cast[ptr DBusObject00](self.impl))
  result = glistObjects2seq(DBusInterface, resul0, true)
  g_list_free(resul0)

proc interfaces*(self: DBusObject | DBusObjectSkeleton | DBusObjectProxy): seq[DBusInterface] =
  let resul0 = g_dbus_object_get_interfaces(cast[ptr DBusObject00](self.impl))
  result = glistObjects2seq(DBusInterface, resul0, true)
  g_list_free(resul0)

proc g_dbus_object_get_object_path(self: ptr DBusObject00): cstring {.
    importc, libprag.}

proc getObjectPath*(self: DBusObject | DBusObjectSkeleton | DBusObjectProxy): string =
  result = $g_dbus_object_get_object_path(cast[ptr DBusObject00](self.impl))

proc objectPath*(self: DBusObject | DBusObjectSkeleton | DBusObjectProxy): string =
  result = $g_dbus_object_get_object_path(cast[ptr DBusObject00](self.impl))

proc g_dbus_interface_dup_object(self: ptr DBusInterface00): ptr DBusObject00 {.
    importc, libprag.}

proc getObject*(self: DBusInterface | DBusInterfaceSkeleton | DBusProxy): DBusObject =
  let gobj = g_dbus_interface_dup_object(cast[ptr DBusInterface00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_dbus_interface_set_object(self: ptr DBusInterface00; `object`: ptr DBusObject00) {.
    importc, libprag.}

proc setObject*(self: DBusInterface | DBusInterfaceSkeleton | DBusProxy;
    `object`: DBusObject | DBusObjectSkeleton | DBusObjectProxy = nil) =
  g_dbus_interface_set_object(cast[ptr DBusInterface00](self.impl), if `object`.isNil: nil else: cast[ptr DBusObject00](`object`.impl))

proc `object=`*(self: DBusInterface | DBusInterfaceSkeleton | DBusProxy;
    `object`: DBusObject | DBusObjectSkeleton | DBusObjectProxy = nil) =
  g_dbus_interface_set_object(cast[ptr DBusInterface00](self.impl), if `object`.isNil: nil else: cast[ptr DBusObject00](`object`.impl))

type
  DBusInterfaceGetPropertyFunc* = proc (connection: ptr DBusConnection00; sender: cstring; objectPath: cstring;
    interfaceName: cstring; propertyName: cstring; error: ptr glib.Error; userData: pointer): ptr glib.Variant00 {.cdecl.}

type
  DBusInterfaceMethodCallFunc* = proc (connection: ptr DBusConnection00; sender: cstring; objectPath: cstring;
    interfaceName: cstring; methodName: cstring; parameters: ptr glib.Variant00;
    invocation: ptr DBusMethodInvocation00; userData: pointer) {.cdecl.}

type
  DBusInterfaceSetPropertyFunc* = proc (connection: ptr DBusConnection00; sender: cstring; objectPath: cstring;
    interfaceName: cstring; propertyName: cstring; value: ptr glib.Variant00;
    error: ptr glib.Error; userData: pointer): gboolean {.cdecl.}

type
  DBusInterfaceVTable00* {.pure.} = object
  DBusInterfaceVTable* = ref object
    impl*: ptr DBusInterfaceVTable00
    ignoreFinalizer*: bool

type
  DBusMenuModel* = ref object of MenuModel
  DBusMenuModel00* = object of MenuModel00

proc g_dbus_menu_model_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(DBusMenuModel()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc g_dbus_menu_model_get(connection: ptr DBusConnection00; busName: cstring;
    objectPath: cstring): ptr DBusMenuModel00 {.
    importc, libprag.}

proc getDBusMenuModel*(connection: DBusConnection; busName: cstring = nil;
    objectPath: cstring): DBusMenuModel =
  let gobj = g_dbus_menu_model_get(cast[ptr DBusConnection00](connection.impl), busName, objectPath)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

type
  DBusMessageFilterFunction* = proc (connection: ptr DBusConnection00; message: ptr DBusMessage00; incoming: gboolean;
    userData: pointer): ptr DBusMessage00 {.cdecl.}

proc g_dbus_connection_add_filter(self: ptr DBusConnection00; filterFunction: DBusMessageFilterFunction;
    userData: pointer; userDataFreeFunc: DestroyNotify): uint32 {.
    importc, libprag.}

proc addFilter*(self: DBusConnection; filterFunction: DBusMessageFilterFunction;
    userData: pointer; userDataFreeFunc: DestroyNotify): int =
  int(g_dbus_connection_add_filter(cast[ptr DBusConnection00](self.impl), filterFunction, userData, userDataFreeFunc))

type
  DBusNodeInfo00* {.pure.} = object
  DBusNodeInfo* = ref object
    impl*: ptr DBusNodeInfo00
    ignoreFinalizer*: bool

proc g_dbus_node_info_get_type*(): GType {.importc, libprag.}

proc gBoxedFreeGDBusNodeInfo*(self: DBusNodeInfo) =
  if not self.ignoreFinalizer:
    boxedFree(g_dbus_node_info_get_type(), cast[ptr DBusNodeInfo00](self.impl))

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(DBusNodeInfo()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    if not self.ignoreFinalizer and self.impl != nil:
      boxedFree(g_dbus_node_info_get_type(), cast[ptr DBusNodeInfo00](self.impl))
      self.impl = nil

proc newWithFinalizer*(x: var DBusNodeInfo) =
  when defined(gcDestructors):
    new(x)
  else:
    new(x, gBoxedFreeGDBusNodeInfo)

proc g_dbus_node_info_unref(self: ptr DBusNodeInfo00) {.
    importc, libprag.}

proc unref*(self: DBusNodeInfo) =
  g_dbus_node_info_unref(cast[ptr DBusNodeInfo00](self.impl))

proc finalizerunref*(self: DBusNodeInfo) =
  if not self.ignoreFinalizer:
    g_dbus_node_info_unref(cast[ptr DBusNodeInfo00](self.impl))

proc g_dbus_node_info_generate_xml(self: ptr DBusNodeInfo00; indent: uint32;
    stringBuilder: glib.String) {.
    importc, libprag.}

proc generateXml*(self: DBusNodeInfo; indent: int; stringBuilder: glib.String) =
  g_dbus_node_info_generate_xml(cast[ptr DBusNodeInfo00](self.impl), uint32(indent), stringBuilder)

proc g_dbus_node_info_lookup_interface(self: ptr DBusNodeInfo00; name: cstring): ptr DBusInterfaceInfo00 {.
    importc, libprag.}

proc lookupInterface*(self: DBusNodeInfo; name: cstring): DBusInterfaceInfo =
  fnew(result, gBoxedFreeGDBusInterfaceInfo)
  result.impl = g_dbus_node_info_lookup_interface(cast[ptr DBusNodeInfo00](self.impl), name)
  result.impl = cast[typeof(result.impl)](g_boxed_copy(g_dbus_interface_info_get_type(), result.impl))

proc g_dbus_node_info_ref(self: ptr DBusNodeInfo00): ptr DBusNodeInfo00 {.
    importc, libprag.}

proc `ref`*(self: DBusNodeInfo): DBusNodeInfo =
  fnew(result, gBoxedFreeGDBusNodeInfo)
  result.impl = g_dbus_node_info_ref(cast[ptr DBusNodeInfo00](self.impl))

proc g_dbus_node_info_new_for_xml(xmlData: cstring; error: ptr ptr glib.Error = nil): ptr DBusNodeInfo00 {.
    importc, libprag.}

proc newDBusNodeInfoForXml*(xmlData: cstring): DBusNodeInfo =
  var gerror: ptr glib.Error
  let impl0 = g_dbus_node_info_new_for_xml(xmlData, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  fnew(result, gBoxedFreeGDBusNodeInfo)
  result.impl = impl0

proc newDBusNodeInfoForXml*(tdesc: typedesc; xmlData: cstring): tdesc =
  var gerror: ptr glib.Error
  assert(result is DBusNodeInfo)
  let impl0 = g_dbus_node_info_new_for_xml(xmlData, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  fnew(result, gBoxedFreeGDBusNodeInfo)
  result.impl = impl0

proc initDBusNodeInfoForXml*[T](result: var T; xmlData: cstring) {.deprecated.} =
  var gerror: ptr glib.Error
  assert(result is DBusNodeInfo)
  let impl0 = g_dbus_node_info_new_for_xml(xmlData, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  fnew(result, gBoxedFreeGDBusNodeInfo)
  result.impl = impl0

type
  DBusObjectManagerServer* = ref object of gobject.Object
  DBusObjectManagerServer00* = object of gobject.Object00

proc g_dbus_object_manager_server_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(DBusObjectManagerServer()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc g_dbus_object_manager_server_new(objectPath: cstring): ptr DBusObjectManagerServer00 {.
    importc, libprag.}

proc newDBusObjectManagerServer*(objectPath: cstring): DBusObjectManagerServer =
  let gobj = g_dbus_object_manager_server_new(objectPath)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newDBusObjectManagerServer*(tdesc: typedesc; objectPath: cstring): tdesc =
  assert(result is DBusObjectManagerServer)
  let gobj = g_dbus_object_manager_server_new(objectPath)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initDBusObjectManagerServer*[T](result: var T; objectPath: cstring) {.deprecated.} =
  assert(result is DBusObjectManagerServer)
  let gobj = g_dbus_object_manager_server_new(objectPath)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_dbus_object_manager_server_export(self: ptr DBusObjectManagerServer00;
    `object`: ptr DBusObjectSkeleton00) {.
    importc, libprag.}

proc `export`*(self: DBusObjectManagerServer; `object`: DBusObjectSkeleton) =
  g_dbus_object_manager_server_export(cast[ptr DBusObjectManagerServer00](self.impl), cast[ptr DBusObjectSkeleton00](`object`.impl))

proc g_dbus_object_manager_server_export_uniquely(self: ptr DBusObjectManagerServer00;
    `object`: ptr DBusObjectSkeleton00) {.
    importc, libprag.}

proc exportUniquely*(self: DBusObjectManagerServer;
    `object`: DBusObjectSkeleton) =
  g_dbus_object_manager_server_export_uniquely(cast[ptr DBusObjectManagerServer00](self.impl), cast[ptr DBusObjectSkeleton00](`object`.impl))

proc g_dbus_object_manager_server_get_connection(self: ptr DBusObjectManagerServer00): ptr DBusConnection00 {.
    importc, libprag.}

proc getConnection*(self: DBusObjectManagerServer): DBusConnection =
  let gobj = g_dbus_object_manager_server_get_connection(cast[ptr DBusObjectManagerServer00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc connection*(self: DBusObjectManagerServer): DBusConnection =
  let gobj = g_dbus_object_manager_server_get_connection(cast[ptr DBusObjectManagerServer00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_dbus_object_manager_server_is_exported(self: ptr DBusObjectManagerServer00;
    `object`: ptr DBusObjectSkeleton00): gboolean {.
    importc, libprag.}

proc isExported*(self: DBusObjectManagerServer;
    `object`: DBusObjectSkeleton): bool =
  toBool(g_dbus_object_manager_server_is_exported(cast[ptr DBusObjectManagerServer00](self.impl), cast[ptr DBusObjectSkeleton00](`object`.impl)))

proc g_dbus_object_manager_server_set_connection(self: ptr DBusObjectManagerServer00;
    connection: ptr DBusConnection00) {.
    importc, libprag.}

proc setConnection*(self: DBusObjectManagerServer;
    connection: DBusConnection = nil) =
  g_dbus_object_manager_server_set_connection(cast[ptr DBusObjectManagerServer00](self.impl), if connection.isNil: nil else: cast[ptr DBusConnection00](connection.impl))

proc `connection=`*(self: DBusObjectManagerServer;
    connection: DBusConnection = nil) =
  g_dbus_object_manager_server_set_connection(cast[ptr DBusObjectManagerServer00](self.impl), if connection.isNil: nil else: cast[ptr DBusConnection00](connection.impl))

proc g_dbus_object_manager_server_unexport(self: ptr DBusObjectManagerServer00;
    objectPath: cstring): gboolean {.
    importc, libprag.}

proc unexport*(self: DBusObjectManagerServer;
    objectPath: cstring): bool =
  toBool(g_dbus_object_manager_server_unexport(cast[ptr DBusObjectManagerServer00](self.impl), objectPath))

type
  DBusObjectManager00* = object of gobject.Object00
  DBusObjectManager* = ref object of gobject.Object

proc scInterfaceAdded*(self: DBusObjectManager | DBusObjectManagerClient | DBusObjectManagerServer;  p: proc (self: ptr DBusObjectManager00; `object`: ptr DBusObject00; `interface`: ptr DBusInterface00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "interface-added", cast[GCallback](p), xdata, nil, cf)

proc scInterfaceRemoved*(self: DBusObjectManager | DBusObjectManagerClient | DBusObjectManagerServer;  p: proc (self: ptr DBusObjectManager00; `object`: ptr DBusObject00; `interface`: ptr DBusInterface00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "interface-removed", cast[GCallback](p), xdata, nil, cf)

proc scObjectAdded*(self: DBusObjectManager | DBusObjectManagerClient | DBusObjectManagerServer;  p: proc (self: ptr DBusObjectManager00; `object`: ptr DBusObject00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "object-added", cast[GCallback](p), xdata, nil, cf)

proc scObjectRemoved*(self: DBusObjectManager | DBusObjectManagerClient | DBusObjectManagerServer;  p: proc (self: ptr DBusObjectManager00; `object`: ptr DBusObject00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "object-removed", cast[GCallback](p), xdata, nil, cf)

proc g_dbus_object_manager_get_interface(self: ptr DBusObjectManager00; objectPath: cstring;
    interfaceName: cstring): ptr DBusInterface00 {.
    importc, libprag.}

proc getInterface*(self: DBusObjectManager | DBusObjectManagerClient | DBusObjectManagerServer;
    objectPath: cstring; interfaceName: cstring): DBusInterface =
  let gobj = g_dbus_object_manager_get_interface(cast[ptr DBusObjectManager00](self.impl), objectPath, interfaceName)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_dbus_object_manager_get_object(self: ptr DBusObjectManager00; objectPath: cstring): ptr DBusObject00 {.
    importc, libprag.}

proc getObject*(self: DBusObjectManager | DBusObjectManagerClient | DBusObjectManagerServer;
    objectPath: cstring): DBusObject =
  let gobj = g_dbus_object_manager_get_object(cast[ptr DBusObjectManager00](self.impl), objectPath)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_dbus_object_manager_get_object_path(self: ptr DBusObjectManager00): cstring {.
    importc, libprag.}

proc getObjectPath*(self: DBusObjectManager | DBusObjectManagerClient | DBusObjectManagerServer): string =
  result = $g_dbus_object_manager_get_object_path(cast[ptr DBusObjectManager00](self.impl))

proc objectPath*(self: DBusObjectManager | DBusObjectManagerClient | DBusObjectManagerServer): string =
  result = $g_dbus_object_manager_get_object_path(cast[ptr DBusObjectManager00](self.impl))

proc g_dbus_object_manager_get_objects(self: ptr DBusObjectManager00): ptr glib.List {.
    importc, libprag.}

proc getObjects*(self: DBusObjectManager | DBusObjectManagerClient | DBusObjectManagerServer): seq[DBusObject] =
  let resul0 = g_dbus_object_manager_get_objects(cast[ptr DBusObjectManager00](self.impl))
  result = glistObjects2seq(DBusObject, resul0, true)
  g_list_free(resul0)

proc objects*(self: DBusObjectManager | DBusObjectManagerClient | DBusObjectManagerServer): seq[DBusObject] =
  let resul0 = g_dbus_object_manager_get_objects(cast[ptr DBusObjectManager00](self.impl))
  result = glistObjects2seq(DBusObject, resul0, true)
  g_list_free(resul0)

type
  DBusPropertyInfoFlag* {.size: sizeof(cint), pure.} = enum
    readable = 0
    writable = 1

  DBusPropertyInfoFlags* {.size: sizeof(cint).} = set[DBusPropertyInfoFlag]

const
  DBusPropertyInfoFlagsNone* = DBusPropertyInfoFlags({})
proc none*(t: typedesc[DBusPropertyInfoFlags]): DBusPropertyInfoFlags = DBusPropertyInfoFlags({})

type
  DBusProxyTypeFunc* = proc (manager: ptr DBusObjectManagerClient00; objectPath: cstring; interfaceName: cstring;
    userData: pointer): GType {.cdecl.}

proc g_dbus_object_manager_client_new_for_bus_sync(busType: BusType; flags: DBusObjectManagerClientFlags;
    name: cstring; objectPath: cstring; getProxyTypeFunc: DBusProxyTypeFunc;
    getProxyTypeUserData: pointer; getProxyTypeDestroyNotify: DestroyNotify;
    cancellable: ptr Cancellable00; error: ptr ptr glib.Error = nil): ptr DBusObjectManagerClient00 {.
    importc, libprag.}

proc newDBusObjectManagerClientForBusSync*(busType: BusType; flags: DBusObjectManagerClientFlags;
    name: cstring; objectPath: cstring; getProxyTypeFunc: DBusProxyTypeFunc;
    getProxyTypeUserData: pointer; getProxyTypeDestroyNotify: DestroyNotify;
    cancellable: Cancellable = nil): DBusObjectManagerClient =
  var gerror: ptr glib.Error
  let gobj = g_dbus_object_manager_client_new_for_bus_sync(busType, flags, name, objectPath, getProxyTypeFunc, getProxyTypeUserData, getProxyTypeDestroyNotify, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newDBusObjectManagerClientForBusSync*(tdesc: typedesc; busType: BusType; flags: DBusObjectManagerClientFlags;
    name: cstring; objectPath: cstring; getProxyTypeFunc: DBusProxyTypeFunc;
    getProxyTypeUserData: pointer; getProxyTypeDestroyNotify: DestroyNotify;
    cancellable: Cancellable = nil): tdesc =
  var gerror: ptr glib.Error
  assert(result is DBusObjectManagerClient)
  let gobj = g_dbus_object_manager_client_new_for_bus_sync(busType, flags, name, objectPath, getProxyTypeFunc, getProxyTypeUserData, getProxyTypeDestroyNotify, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initDBusObjectManagerClientForBusSync*[T](result: var T; busType: BusType; flags: DBusObjectManagerClientFlags;
    name: cstring; objectPath: cstring; getProxyTypeFunc: DBusProxyTypeFunc;
    getProxyTypeUserData: pointer; getProxyTypeDestroyNotify: DestroyNotify;
    cancellable: Cancellable = nil) {.deprecated.} =
  var gerror: ptr glib.Error
  assert(result is DBusObjectManagerClient)
  let gobj = g_dbus_object_manager_client_new_for_bus_sync(busType, flags, name, objectPath, getProxyTypeFunc, getProxyTypeUserData, getProxyTypeDestroyNotify, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_dbus_object_manager_client_new_sync(connection: ptr DBusConnection00;
    flags: DBusObjectManagerClientFlags; name: cstring; objectPath: cstring;
    getProxyTypeFunc: DBusProxyTypeFunc; getProxyTypeUserData: pointer; getProxyTypeDestroyNotify: DestroyNotify;
    cancellable: ptr Cancellable00; error: ptr ptr glib.Error = nil): ptr DBusObjectManagerClient00 {.
    importc, libprag.}

proc newDBusObjectManagerClientSync*(connection: DBusConnection; flags: DBusObjectManagerClientFlags;
    name: cstring = nil; objectPath: cstring; getProxyTypeFunc: DBusProxyTypeFunc;
    getProxyTypeUserData: pointer; getProxyTypeDestroyNotify: DestroyNotify;
    cancellable: Cancellable = nil): DBusObjectManagerClient =
  var gerror: ptr glib.Error
  let gobj = g_dbus_object_manager_client_new_sync(cast[ptr DBusConnection00](connection.impl), flags, name, objectPath, getProxyTypeFunc, getProxyTypeUserData, getProxyTypeDestroyNotify, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newDBusObjectManagerClientSync*(tdesc: typedesc; connection: DBusConnection; flags: DBusObjectManagerClientFlags;
    name: cstring = nil; objectPath: cstring; getProxyTypeFunc: DBusProxyTypeFunc;
    getProxyTypeUserData: pointer; getProxyTypeDestroyNotify: DestroyNotify;
    cancellable: Cancellable = nil): tdesc =
  var gerror: ptr glib.Error
  assert(result is DBusObjectManagerClient)
  let gobj = g_dbus_object_manager_client_new_sync(cast[ptr DBusConnection00](connection.impl), flags, name, objectPath, getProxyTypeFunc, getProxyTypeUserData, getProxyTypeDestroyNotify, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initDBusObjectManagerClientSync*[T](result: var T; connection: DBusConnection; flags: DBusObjectManagerClientFlags;
    name: cstring = nil; objectPath: cstring; getProxyTypeFunc: DBusProxyTypeFunc;
    getProxyTypeUserData: pointer; getProxyTypeDestroyNotify: DestroyNotify;
    cancellable: Cancellable = nil) {.deprecated.} =
  var gerror: ptr glib.Error
  assert(result is DBusObjectManagerClient)
  let gobj = g_dbus_object_manager_client_new_sync(cast[ptr DBusConnection00](connection.impl), flags, name, objectPath, getProxyTypeFunc, getProxyTypeUserData, getProxyTypeDestroyNotify, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_dbus_object_manager_client_new(connection: ptr DBusConnection00; flags: DBusObjectManagerClientFlags;
    name: cstring; objectPath: cstring; getProxyTypeFunc: DBusProxyTypeFunc;
    getProxyTypeUserData: pointer; getProxyTypeDestroyNotify: DestroyNotify;
    cancellable: ptr Cancellable00; callback: AsyncReadyCallback; userData: pointer) {.
    importc, libprag.}

proc new*(connection: DBusConnection; flags: DBusObjectManagerClientFlags;
    name: cstring; objectPath: cstring; getProxyTypeFunc: DBusProxyTypeFunc;
    getProxyTypeUserData: pointer; getProxyTypeDestroyNotify: DestroyNotify;
    cancellable: Cancellable = nil; callback: AsyncReadyCallback; userData: pointer) =
  g_dbus_object_manager_client_new(cast[ptr DBusConnection00](connection.impl), flags, name, objectPath, getProxyTypeFunc, getProxyTypeUserData, getProxyTypeDestroyNotify, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_dbus_object_manager_client_new_for_bus(busType: BusType; flags: DBusObjectManagerClientFlags;
    name: cstring; objectPath: cstring; getProxyTypeFunc: DBusProxyTypeFunc;
    getProxyTypeUserData: pointer; getProxyTypeDestroyNotify: DestroyNotify;
    cancellable: ptr Cancellable00; callback: AsyncReadyCallback; userData: pointer) {.
    importc, libprag.}

proc newForBus*(busType: BusType; flags: DBusObjectManagerClientFlags;
    name: cstring; objectPath: cstring; getProxyTypeFunc: DBusProxyTypeFunc;
    getProxyTypeUserData: pointer; getProxyTypeDestroyNotify: DestroyNotify;
    cancellable: Cancellable = nil; callback: AsyncReadyCallback; userData: pointer) =
  g_dbus_object_manager_client_new_for_bus(busType, flags, name, objectPath, getProxyTypeFunc, getProxyTypeUserData, getProxyTypeDestroyNotify, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

type
  DBusServer* = ref object of gobject.Object
  DBusServer00* = object of gobject.Object00

proc g_dbus_server_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(DBusServer()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc scNewConnection*(self: DBusServer;  p: proc (self: ptr DBusServer00; connection: ptr DBusConnection00; xdata: pointer): gboolean {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "new-connection", cast[GCallback](p), xdata, nil, cf)

proc g_dbus_server_get_client_address(self: ptr DBusServer00): cstring {.
    importc, libprag.}

proc getClientAddress*(self: DBusServer): string =
  result = $g_dbus_server_get_client_address(cast[ptr DBusServer00](self.impl))

proc clientAddress*(self: DBusServer): string =
  result = $g_dbus_server_get_client_address(cast[ptr DBusServer00](self.impl))

proc g_dbus_server_get_guid(self: ptr DBusServer00): cstring {.
    importc, libprag.}

proc getGuid*(self: DBusServer): string =
  result = $g_dbus_server_get_guid(cast[ptr DBusServer00](self.impl))

proc guid*(self: DBusServer): string =
  result = $g_dbus_server_get_guid(cast[ptr DBusServer00](self.impl))

proc g_dbus_server_is_active(self: ptr DBusServer00): gboolean {.
    importc, libprag.}

proc isActive*(self: DBusServer): bool =
  toBool(g_dbus_server_is_active(cast[ptr DBusServer00](self.impl)))

proc g_dbus_server_start(self: ptr DBusServer00) {.
    importc, libprag.}

proc start*(self: DBusServer) =
  g_dbus_server_start(cast[ptr DBusServer00](self.impl))

proc g_dbus_server_stop(self: ptr DBusServer00) {.
    importc, libprag.}

proc stop*(self: DBusServer) =
  g_dbus_server_stop(cast[ptr DBusServer00](self.impl))

type
  DBusServerFlag* {.size: sizeof(cint), pure.} = enum
    runInThread = 0
    authenticationAllowAnonymous = 1

  DBusServerFlags* {.size: sizeof(cint).} = set[DBusServerFlag]

const
  DBusServerFlagsNone* = DBusServerFlags({})
proc none*(t: typedesc[DBusServerFlags]): DBusServerFlags = DBusServerFlags({})

proc g_dbus_server_new_sync(address: cstring; flags: DBusServerFlags; guid: cstring;
    observer: ptr DBusAuthObserver00; cancellable: ptr Cancellable00; error: ptr ptr glib.Error = nil): ptr DBusServer00 {.
    importc, libprag.}

proc newDBusServerSync*(address: cstring; flags: DBusServerFlags; guid: cstring;
    observer: DBusAuthObserver = nil; cancellable: Cancellable = nil): DBusServer =
  var gerror: ptr glib.Error
  let gobj = g_dbus_server_new_sync(address, flags, guid, if observer.isNil: nil else: cast[ptr DBusAuthObserver00](observer.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newDBusServerSync*(tdesc: typedesc; address: cstring; flags: DBusServerFlags; guid: cstring;
    observer: DBusAuthObserver = nil; cancellable: Cancellable = nil): tdesc =
  var gerror: ptr glib.Error
  assert(result is DBusServer)
  let gobj = g_dbus_server_new_sync(address, flags, guid, if observer.isNil: nil else: cast[ptr DBusAuthObserver00](observer.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initDBusServerSync*[T](result: var T; address: cstring; flags: DBusServerFlags; guid: cstring;
    observer: DBusAuthObserver = nil; cancellable: Cancellable = nil) {.deprecated.} =
  var gerror: ptr glib.Error
  assert(result is DBusServer)
  let gobj = g_dbus_server_new_sync(address, flags, guid, if observer.isNil: nil else: cast[ptr DBusAuthObserver00](observer.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_dbus_server_get_flags(self: ptr DBusServer00): DBusServerFlags {.
    importc, libprag.}

proc getFlags*(self: DBusServer): DBusServerFlags =
  g_dbus_server_get_flags(cast[ptr DBusServer00](self.impl))

proc flags*(self: DBusServer): DBusServerFlags =
  g_dbus_server_get_flags(cast[ptr DBusServer00](self.impl))

type
  DBusSignalCallback* = proc (connection: ptr DBusConnection00; senderName: cstring; objectPath: cstring;
    interfaceName: cstring; signalName: cstring; parameters: ptr glib.Variant00;
    userData: pointer) {.cdecl.}

proc g_dbus_connection_signal_subscribe(self: ptr DBusConnection00; sender: cstring;
    interfaceName: cstring; member: cstring; objectPath: cstring; arg0: cstring;
    flags: DBusSignalFlags; callback: DBusSignalCallback; userData: pointer;
    userDataFreeFunc: DestroyNotify): uint32 {.
    importc, libprag.}

proc signalSubscribe*(self: DBusConnection; sender: cstring = nil;
    interfaceName: cstring = nil; member: cstring = nil; objectPath: cstring = nil;
    arg0: cstring = nil; flags: DBusSignalFlags; callback: DBusSignalCallback;
    userData: pointer; userDataFreeFunc: DestroyNotify): int =
  int(g_dbus_connection_signal_subscribe(cast[ptr DBusConnection00](self.impl), sender, interfaceName, member, objectPath, arg0, flags, callback, userData, userDataFreeFunc))

type
  DBusSubtreeDispatchFunc* = proc (connection: ptr DBusConnection00; sender: cstring; objectPath: cstring;
    interfaceName: cstring; node: cstring; outUserData: pointer; userData: pointer): ptr DBusInterfaceVTable00 {.cdecl.}

type
  DBusSubtreeIntrospectFunc* = proc (connection: ptr DBusConnection00; sender: cstring; objectPath: cstring;
    node: cstring; userData: pointer): ptr DBusInterfaceInfo00 {.cdecl.}

const DESKTOP_APP_INFO_LOOKUP_EXTENSION_POINT_NAME* = "gio-desktop-app-info-lookup"

const DRIVE_IDENTIFIER_KIND_UNIX_DEVICE* = "unix-device"

type
  DataInputStream* = ref object of BufferedInputStream
  DataInputStream00* = object of BufferedInputStream00

proc g_data_input_stream_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(DataInputStream()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc g_data_input_stream_new(baseStream: ptr InputStream00): ptr DataInputStream00 {.
    importc, libprag.}

proc newDataInputStream*(baseStream: InputStream): DataInputStream =
  let gobj = g_data_input_stream_new(cast[ptr InputStream00](baseStream.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newDataInputStream*(tdesc: typedesc; baseStream: InputStream): tdesc =
  assert(result is DataInputStream)
  let gobj = g_data_input_stream_new(cast[ptr InputStream00](baseStream.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initDataInputStream*[T](result: var T; baseStream: InputStream) {.deprecated.} =
  assert(result is DataInputStream)
  let gobj = g_data_input_stream_new(cast[ptr InputStream00](baseStream.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_data_input_stream_read_byte(self: ptr DataInputStream00; cancellable: ptr Cancellable00;
    error: ptr ptr glib.Error = nil): uint8 {.
    importc, libprag.}

proc readByte*(self: DataInputStream; cancellable: Cancellable = nil): uint8 =
  var gerror: ptr glib.Error
  let resul0 = g_data_input_stream_read_byte(cast[ptr DataInputStream00](self.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = resul0

proc g_data_input_stream_read_int16(self: ptr DataInputStream00; cancellable: ptr Cancellable00;
    error: ptr ptr glib.Error = nil): int16 {.
    importc, libprag.}

proc readInt16*(self: DataInputStream; cancellable: Cancellable = nil): int16 =
  var gerror: ptr glib.Error
  let resul0 = g_data_input_stream_read_int16(cast[ptr DataInputStream00](self.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = resul0

proc g_data_input_stream_read_int32(self: ptr DataInputStream00; cancellable: ptr Cancellable00;
    error: ptr ptr glib.Error = nil): int32 {.
    importc, libprag.}

proc readInt32*(self: DataInputStream; cancellable: Cancellable = nil): int =
  var gerror: ptr glib.Error
  let resul0 = g_data_input_stream_read_int32(cast[ptr DataInputStream00](self.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = int(resul0)

proc g_data_input_stream_read_int64(self: ptr DataInputStream00; cancellable: ptr Cancellable00;
    error: ptr ptr glib.Error = nil): int64 {.
    importc, libprag.}

proc readInt64*(self: DataInputStream; cancellable: Cancellable = nil): int64 =
  var gerror: ptr glib.Error
  let resul0 = g_data_input_stream_read_int64(cast[ptr DataInputStream00](self.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = resul0

proc g_data_input_stream_read_line(self: ptr DataInputStream00; length: var uint64;
    cancellable: ptr Cancellable00; error: ptr ptr glib.Error = nil): ptr uint8 {.
    importc, libprag.}

proc readLine*(self: DataInputStream; length: var uint64 = cast[var uint64](nil);
    cancellable: Cancellable = nil): seq[uint8] =
  var gerror: ptr glib.Error
  let resul0 = g_data_input_stream_read_line(cast[ptr DataInputStream00](self.impl), length, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  if resul0.isNil:
    return
  result = uint8ArrayZT2seq(resul0)
  cogfree(resul0)

proc g_data_input_stream_read_line_async(self: ptr DataInputStream00; ioPriority: int32;
    cancellable: ptr Cancellable00; callback: AsyncReadyCallback; userData: pointer) {.
    importc, libprag.}

proc readLineAsync*(self: DataInputStream; ioPriority: int;
    cancellable: Cancellable = nil; callback: AsyncReadyCallback; userData: pointer) =
  g_data_input_stream_read_line_async(cast[ptr DataInputStream00](self.impl), int32(ioPriority), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_data_input_stream_read_line_finish(self: ptr DataInputStream00; resu: ptr AsyncResult00;
    length: var uint64; error: ptr ptr glib.Error = nil): ptr uint8 {.
    importc, libprag.}

proc readLineFinish*(self: DataInputStream; resu: AsyncResult | SimpleAsyncResult | Task;
    length: var uint64 = cast[var uint64](nil)): seq[uint8] =
  var gerror: ptr glib.Error
  let resul0 = g_data_input_stream_read_line_finish(cast[ptr DataInputStream00](self.impl), cast[ptr AsyncResult00](resu.impl), length, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  if resul0.isNil:
    return
  result = uint8ArrayZT2seq(resul0)
  cogfree(resul0)

proc g_data_input_stream_read_line_finish_utf8(self: ptr DataInputStream00;
    resu: ptr AsyncResult00; length: var uint64; error: ptr ptr glib.Error = nil): cstring {.
    importc, libprag.}

proc readLineFinishUtf8*(self: DataInputStream; resu: AsyncResult | SimpleAsyncResult | Task;
    length: var uint64 = cast[var uint64](nil)): string =
  var gerror: ptr glib.Error
  let resul0 = g_data_input_stream_read_line_finish_utf8(cast[ptr DataInputStream00](self.impl), cast[ptr AsyncResult00](resu.impl), length, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  if resul0.isNil:
    return
  result = $resul0
  cogfree(resul0)

proc g_data_input_stream_read_line_utf8(self: ptr DataInputStream00; length: var uint64;
    cancellable: ptr Cancellable00; error: ptr ptr glib.Error = nil): cstring {.
    importc, libprag.}

proc readLineUtf8*(self: DataInputStream; length: var uint64 = cast[var uint64](nil);
    cancellable: Cancellable = nil): string =
  var gerror: ptr glib.Error
  let resul0 = g_data_input_stream_read_line_utf8(cast[ptr DataInputStream00](self.impl), length, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  if resul0.isNil:
    return
  result = $resul0
  cogfree(resul0)

proc g_data_input_stream_read_uint16(self: ptr DataInputStream00; cancellable: ptr Cancellable00;
    error: ptr ptr glib.Error = nil): uint16 {.
    importc, libprag.}

proc readUint16*(self: DataInputStream; cancellable: Cancellable = nil): uint16 =
  var gerror: ptr glib.Error
  let resul0 = g_data_input_stream_read_uint16(cast[ptr DataInputStream00](self.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = resul0

proc g_data_input_stream_read_uint32(self: ptr DataInputStream00; cancellable: ptr Cancellable00;
    error: ptr ptr glib.Error = nil): uint32 {.
    importc, libprag.}

proc readUint32*(self: DataInputStream; cancellable: Cancellable = nil): int =
  var gerror: ptr glib.Error
  let resul0 = g_data_input_stream_read_uint32(cast[ptr DataInputStream00](self.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = int(resul0)

proc g_data_input_stream_read_uint64(self: ptr DataInputStream00; cancellable: ptr Cancellable00;
    error: ptr ptr glib.Error = nil): uint64 {.
    importc, libprag.}

proc readUint64*(self: DataInputStream; cancellable: Cancellable = nil): uint64 =
  var gerror: ptr glib.Error
  let resul0 = g_data_input_stream_read_uint64(cast[ptr DataInputStream00](self.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = resul0

proc g_data_input_stream_read_until(self: ptr DataInputStream00; stopChars: cstring;
    length: var uint64; cancellable: ptr Cancellable00; error: ptr ptr glib.Error = nil): cstring {.
    importc, libprag.}

proc readUntil*(self: DataInputStream; stopChars: cstring;
    length: var uint64 = cast[var uint64](nil); cancellable: Cancellable = nil): string =
  var gerror: ptr glib.Error
  let resul0 = g_data_input_stream_read_until(cast[ptr DataInputStream00](self.impl), stopChars, length, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = $resul0
  cogfree(resul0)

proc g_data_input_stream_read_until_async(self: ptr DataInputStream00; stopChars: cstring;
    ioPriority: int32; cancellable: ptr Cancellable00; callback: AsyncReadyCallback;
    userData: pointer) {.
    importc, libprag.}

proc readUntilAsync*(self: DataInputStream; stopChars: cstring;
    ioPriority: int; cancellable: Cancellable = nil; callback: AsyncReadyCallback;
    userData: pointer) =
  g_data_input_stream_read_until_async(cast[ptr DataInputStream00](self.impl), stopChars, int32(ioPriority), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_data_input_stream_read_until_finish(self: ptr DataInputStream00; resu: ptr AsyncResult00;
    length: var uint64; error: ptr ptr glib.Error = nil): cstring {.
    importc, libprag.}

proc readUntilFinish*(self: DataInputStream; resu: AsyncResult | SimpleAsyncResult | Task;
    length: var uint64 = cast[var uint64](nil)): string =
  var gerror: ptr glib.Error
  let resul0 = g_data_input_stream_read_until_finish(cast[ptr DataInputStream00](self.impl), cast[ptr AsyncResult00](resu.impl), length, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = $resul0
  cogfree(resul0)

proc g_data_input_stream_read_upto(self: ptr DataInputStream00; stopChars: cstring;
    stopCharsLen: int64; length: var uint64; cancellable: ptr Cancellable00;
    error: ptr ptr glib.Error = nil): cstring {.
    importc, libprag.}

proc readUpto*(self: DataInputStream; stopChars: cstring;
    stopCharsLen: int64; length: var uint64 = cast[var uint64](nil); cancellable: Cancellable = nil): string =
  var gerror: ptr glib.Error
  let resul0 = g_data_input_stream_read_upto(cast[ptr DataInputStream00](self.impl), stopChars, stopCharsLen, length, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = $resul0
  cogfree(resul0)

proc g_data_input_stream_read_upto_async(self: ptr DataInputStream00; stopChars: cstring;
    stopCharsLen: int64; ioPriority: int32; cancellable: ptr Cancellable00;
    callback: AsyncReadyCallback; userData: pointer) {.
    importc, libprag.}

proc readUptoAsync*(self: DataInputStream; stopChars: cstring;
    stopCharsLen: int64; ioPriority: int; cancellable: Cancellable = nil; callback: AsyncReadyCallback;
    userData: pointer) =
  g_data_input_stream_read_upto_async(cast[ptr DataInputStream00](self.impl), stopChars, stopCharsLen, int32(ioPriority), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_data_input_stream_read_upto_finish(self: ptr DataInputStream00; resu: ptr AsyncResult00;
    length: var uint64; error: ptr ptr glib.Error = nil): cstring {.
    importc, libprag.}

proc readUptoFinish*(self: DataInputStream; resu: AsyncResult | SimpleAsyncResult | Task;
    length: var uint64 = cast[var uint64](nil)): string =
  var gerror: ptr glib.Error
  let resul0 = g_data_input_stream_read_upto_finish(cast[ptr DataInputStream00](self.impl), cast[ptr AsyncResult00](resu.impl), length, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = $resul0
  cogfree(resul0)

type
  DataStreamByteOrder* {.size: sizeof(cint), pure.} = enum
    bigEndian = 0
    littleEndian = 1
    hostEndian = 2

proc g_data_input_stream_get_byte_order(self: ptr DataInputStream00): DataStreamByteOrder {.
    importc, libprag.}

proc getByteOrder*(self: DataInputStream): DataStreamByteOrder =
  g_data_input_stream_get_byte_order(cast[ptr DataInputStream00](self.impl))

proc byteOrder*(self: DataInputStream): DataStreamByteOrder =
  g_data_input_stream_get_byte_order(cast[ptr DataInputStream00](self.impl))

proc g_data_input_stream_set_byte_order(self: ptr DataInputStream00; order: DataStreamByteOrder) {.
    importc, libprag.}

proc setByteOrder*(self: DataInputStream; order: DataStreamByteOrder) =
  g_data_input_stream_set_byte_order(cast[ptr DataInputStream00](self.impl), order)

proc `byteOrder=`*(self: DataInputStream; order: DataStreamByteOrder) =
  g_data_input_stream_set_byte_order(cast[ptr DataInputStream00](self.impl), order)

type
  DataStreamNewlineType* {.size: sizeof(cint), pure.} = enum
    lf = 0
    cr = 1
    crLf = 2
    any = 3

proc g_data_input_stream_get_newline_type(self: ptr DataInputStream00): DataStreamNewlineType {.
    importc, libprag.}

proc getNewlineType*(self: DataInputStream): DataStreamNewlineType =
  g_data_input_stream_get_newline_type(cast[ptr DataInputStream00](self.impl))

proc newlineType*(self: DataInputStream): DataStreamNewlineType =
  g_data_input_stream_get_newline_type(cast[ptr DataInputStream00](self.impl))

proc g_data_input_stream_set_newline_type(self: ptr DataInputStream00; `type`: DataStreamNewlineType) {.
    importc, libprag.}

proc setNewlineType*(self: DataInputStream; `type`: DataStreamNewlineType) =
  g_data_input_stream_set_newline_type(cast[ptr DataInputStream00](self.impl), `type`)

proc `newlineType=`*(self: DataInputStream; `type`: DataStreamNewlineType) =
  g_data_input_stream_set_newline_type(cast[ptr DataInputStream00](self.impl), `type`)

type
  DataOutputStream* = ref object of FilterOutputStream
  DataOutputStream00* = object of FilterOutputStream00

proc g_data_output_stream_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(DataOutputStream()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc g_data_output_stream_new(baseStream: ptr OutputStream00): ptr DataOutputStream00 {.
    importc, libprag.}

proc newDataOutputStream*(baseStream: OutputStream): DataOutputStream =
  let gobj = g_data_output_stream_new(cast[ptr OutputStream00](baseStream.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newDataOutputStream*(tdesc: typedesc; baseStream: OutputStream): tdesc =
  assert(result is DataOutputStream)
  let gobj = g_data_output_stream_new(cast[ptr OutputStream00](baseStream.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initDataOutputStream*[T](result: var T; baseStream: OutputStream) {.deprecated.} =
  assert(result is DataOutputStream)
  let gobj = g_data_output_stream_new(cast[ptr OutputStream00](baseStream.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_data_output_stream_get_byte_order(self: ptr DataOutputStream00): DataStreamByteOrder {.
    importc, libprag.}

proc getByteOrder*(self: DataOutputStream): DataStreamByteOrder =
  g_data_output_stream_get_byte_order(cast[ptr DataOutputStream00](self.impl))

proc byteOrder*(self: DataOutputStream): DataStreamByteOrder =
  g_data_output_stream_get_byte_order(cast[ptr DataOutputStream00](self.impl))

proc g_data_output_stream_put_byte(self: ptr DataOutputStream00; data: uint8;
    cancellable: ptr Cancellable00; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc putByte*(self: DataOutputStream; data: uint8; cancellable: Cancellable = nil): bool =
  var gerror: ptr glib.Error
  let resul0 = g_data_output_stream_put_byte(cast[ptr DataOutputStream00](self.impl), data, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_data_output_stream_put_int16(self: ptr DataOutputStream00; data: int16;
    cancellable: ptr Cancellable00; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc putInt16*(self: DataOutputStream; data: int16;
    cancellable: Cancellable = nil): bool =
  var gerror: ptr glib.Error
  let resul0 = g_data_output_stream_put_int16(cast[ptr DataOutputStream00](self.impl), data, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_data_output_stream_put_int32(self: ptr DataOutputStream00; data: int32;
    cancellable: ptr Cancellable00; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc putInt32*(self: DataOutputStream; data: int; cancellable: Cancellable = nil): bool =
  var gerror: ptr glib.Error
  let resul0 = g_data_output_stream_put_int32(cast[ptr DataOutputStream00](self.impl), int32(data), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_data_output_stream_put_int64(self: ptr DataOutputStream00; data: int64;
    cancellable: ptr Cancellable00; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc putInt64*(self: DataOutputStream; data: int64;
    cancellable: Cancellable = nil): bool =
  var gerror: ptr glib.Error
  let resul0 = g_data_output_stream_put_int64(cast[ptr DataOutputStream00](self.impl), data, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_data_output_stream_put_string(self: ptr DataOutputStream00; str: cstring;
    cancellable: ptr Cancellable00; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc putString*(self: DataOutputStream; str: cstring;
    cancellable: Cancellable = nil): bool =
  var gerror: ptr glib.Error
  let resul0 = g_data_output_stream_put_string(cast[ptr DataOutputStream00](self.impl), str, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_data_output_stream_put_uint16(self: ptr DataOutputStream00; data: uint16;
    cancellable: ptr Cancellable00; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc putUint16*(self: DataOutputStream; data: uint16;
    cancellable: Cancellable = nil): bool =
  var gerror: ptr glib.Error
  let resul0 = g_data_output_stream_put_uint16(cast[ptr DataOutputStream00](self.impl), data, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_data_output_stream_put_uint32(self: ptr DataOutputStream00; data: uint32;
    cancellable: ptr Cancellable00; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc putUint32*(self: DataOutputStream; data: int; cancellable: Cancellable = nil): bool =
  var gerror: ptr glib.Error
  let resul0 = g_data_output_stream_put_uint32(cast[ptr DataOutputStream00](self.impl), uint32(data), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_data_output_stream_put_uint64(self: ptr DataOutputStream00; data: uint64;
    cancellable: ptr Cancellable00; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc putUint64*(self: DataOutputStream; data: uint64;
    cancellable: Cancellable = nil): bool =
  var gerror: ptr glib.Error
  let resul0 = g_data_output_stream_put_uint64(cast[ptr DataOutputStream00](self.impl), data, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_data_output_stream_set_byte_order(self: ptr DataOutputStream00; order: DataStreamByteOrder) {.
    importc, libprag.}

proc setByteOrder*(self: DataOutputStream; order: DataStreamByteOrder) =
  g_data_output_stream_set_byte_order(cast[ptr DataOutputStream00](self.impl), order)

proc `byteOrder=`*(self: DataOutputStream; order: DataStreamByteOrder) =
  g_data_output_stream_set_byte_order(cast[ptr DataOutputStream00](self.impl), order)

type
  DatagramBased00* = object of gobject.Object00
  DatagramBased* = ref object of gobject.Object

type
  Socket* = ref object of gobject.Object
  Socket00* = object of gobject.Object00

proc g_socket_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(Socket()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc g_socket_new_from_fd(fd: int32; error: ptr ptr glib.Error = nil): ptr Socket00 {.
    importc, libprag.}

proc newSocketFromFd*(fd: int): Socket =
  var gerror: ptr glib.Error
  let gobj = g_socket_new_from_fd(int32(fd), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newSocketFromFd*(tdesc: typedesc; fd: int): tdesc =
  var gerror: ptr glib.Error
  assert(result is Socket)
  let gobj = g_socket_new_from_fd(int32(fd), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initSocketFromFd*[T](result: var T; fd: int) {.deprecated.} =
  var gerror: ptr glib.Error
  assert(result is Socket)
  let gobj = g_socket_new_from_fd(int32(fd), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_socket_accept(self: ptr Socket00; cancellable: ptr Cancellable00;
    error: ptr ptr glib.Error = nil): ptr Socket00 {.
    importc, libprag.}

proc accept*(self: Socket; cancellable: Cancellable = nil): Socket =
  var gerror: ptr glib.Error
  let gobj = g_socket_accept(cast[ptr Socket00](self.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_socket_check_connect_result(self: ptr Socket00; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc checkConnectResult*(self: Socket): bool =
  var gerror: ptr glib.Error
  let resul0 = g_socket_check_connect_result(cast[ptr Socket00](self.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_socket_close(self: ptr Socket00; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc close*(self: Socket): bool =
  var gerror: ptr glib.Error
  let resul0 = g_socket_close(cast[ptr Socket00](self.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_socket_condition_check(self: ptr Socket00; condition: glib.IOCondition): glib.IOCondition {.
    importc, libprag.}

proc conditionCheck*(self: Socket; condition: glib.IOCondition): glib.IOCondition =
  g_socket_condition_check(cast[ptr Socket00](self.impl), condition)

proc g_socket_condition_timed_wait(self: ptr Socket00; condition: glib.IOCondition;
    timeoutUs: int64; cancellable: ptr Cancellable00; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc conditionTimedWait*(self: Socket; condition: glib.IOCondition;
    timeoutUs: int64; cancellable: Cancellable = nil): bool =
  var gerror: ptr glib.Error
  let resul0 = g_socket_condition_timed_wait(cast[ptr Socket00](self.impl), condition, timeoutUs, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_socket_condition_wait(self: ptr Socket00; condition: glib.IOCondition;
    cancellable: ptr Cancellable00; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc conditionWait*(self: Socket; condition: glib.IOCondition; cancellable: Cancellable = nil): bool =
  var gerror: ptr glib.Error
  let resul0 = g_socket_condition_wait(cast[ptr Socket00](self.impl), condition, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_socket_get_available_bytes(self: ptr Socket00): int64 {.
    importc, libprag.}

proc getAvailableBytes*(self: Socket): int64 =
  g_socket_get_available_bytes(cast[ptr Socket00](self.impl))

proc availableBytes*(self: Socket): int64 =
  g_socket_get_available_bytes(cast[ptr Socket00](self.impl))

proc g_socket_get_blocking(self: ptr Socket00): gboolean {.
    importc, libprag.}

proc getBlocking*(self: Socket): bool =
  toBool(g_socket_get_blocking(cast[ptr Socket00](self.impl)))

proc blocking*(self: Socket): bool =
  toBool(g_socket_get_blocking(cast[ptr Socket00](self.impl)))

proc g_socket_get_broadcast(self: ptr Socket00): gboolean {.
    importc, libprag.}

proc getBroadcast*(self: Socket): bool =
  toBool(g_socket_get_broadcast(cast[ptr Socket00](self.impl)))

proc broadcast*(self: Socket): bool =
  toBool(g_socket_get_broadcast(cast[ptr Socket00](self.impl)))

proc g_socket_get_credentials(self: ptr Socket00; error: ptr ptr glib.Error = nil): ptr Credentials00 {.
    importc, libprag.}

proc getCredentials*(self: Socket): Credentials =
  var gerror: ptr glib.Error
  let gobj = g_socket_get_credentials(cast[ptr Socket00](self.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc credentials*(self: Socket): Credentials =
  var gerror: ptr glib.Error
  let gobj = g_socket_get_credentials(cast[ptr Socket00](self.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_socket_get_fd(self: ptr Socket00): int32 {.
    importc, libprag.}

proc getFd*(self: Socket): int =
  int(g_socket_get_fd(cast[ptr Socket00](self.impl)))

proc fd*(self: Socket): int =
  int(g_socket_get_fd(cast[ptr Socket00](self.impl)))

proc g_socket_get_keepalive(self: ptr Socket00): gboolean {.
    importc, libprag.}

proc getKeepalive*(self: Socket): bool =
  toBool(g_socket_get_keepalive(cast[ptr Socket00](self.impl)))

proc keepalive*(self: Socket): bool =
  toBool(g_socket_get_keepalive(cast[ptr Socket00](self.impl)))

proc g_socket_get_listen_backlog(self: ptr Socket00): int32 {.
    importc, libprag.}

proc getListenBacklog*(self: Socket): int =
  int(g_socket_get_listen_backlog(cast[ptr Socket00](self.impl)))

proc listenBacklog*(self: Socket): int =
  int(g_socket_get_listen_backlog(cast[ptr Socket00](self.impl)))

proc g_socket_get_multicast_loopback(self: ptr Socket00): gboolean {.
    importc, libprag.}

proc getMulticastLoopback*(self: Socket): bool =
  toBool(g_socket_get_multicast_loopback(cast[ptr Socket00](self.impl)))

proc multicastLoopback*(self: Socket): bool =
  toBool(g_socket_get_multicast_loopback(cast[ptr Socket00](self.impl)))

proc g_socket_get_multicast_ttl(self: ptr Socket00): uint32 {.
    importc, libprag.}

proc getMulticastTtl*(self: Socket): int =
  int(g_socket_get_multicast_ttl(cast[ptr Socket00](self.impl)))

proc multicastTtl*(self: Socket): int =
  int(g_socket_get_multicast_ttl(cast[ptr Socket00](self.impl)))

proc g_socket_get_option(self: ptr Socket00; level: int32; optname: int32;
    value: var int32; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc getOption*(self: Socket; level: int; optname: int; value: var int): bool =
  var gerror: ptr glib.Error
  var value_00: int32
  let resul0 = g_socket_get_option(cast[ptr Socket00](self.impl), int32(level), int32(optname), value_00, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)
  if value.addr != nil:
    value = int(value_00)

proc g_socket_get_timeout(self: ptr Socket00): uint32 {.
    importc, libprag.}

proc getTimeout*(self: Socket): int =
  int(g_socket_get_timeout(cast[ptr Socket00](self.impl)))

proc timeout*(self: Socket): int =
  int(g_socket_get_timeout(cast[ptr Socket00](self.impl)))

proc g_socket_get_ttl(self: ptr Socket00): uint32 {.
    importc, libprag.}

proc getTtl*(self: Socket): int =
  int(g_socket_get_ttl(cast[ptr Socket00](self.impl)))

proc ttl*(self: Socket): int =
  int(g_socket_get_ttl(cast[ptr Socket00](self.impl)))

proc g_socket_is_closed(self: ptr Socket00): gboolean {.
    importc, libprag.}

proc isClosed*(self: Socket): bool =
  toBool(g_socket_is_closed(cast[ptr Socket00](self.impl)))

proc g_socket_is_connected(self: ptr Socket00): gboolean {.
    importc, libprag.}

proc isConnected*(self: Socket): bool =
  toBool(g_socket_is_connected(cast[ptr Socket00](self.impl)))

proc g_socket_listen(self: ptr Socket00; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc listen*(self: Socket): bool =
  var gerror: ptr glib.Error
  let resul0 = g_socket_listen(cast[ptr Socket00](self.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_socket_receive(self: ptr Socket00; buffer: ptr uint8; size: var uint64;
    cancellable: ptr Cancellable00; error: ptr ptr glib.Error = nil): int64 {.
    importc, libprag.}

proc receive*(self: Socket; buffer: var (seq[uint8] | string); size: var uint64;
    cancellable: Cancellable = nil): int64 =
  var gerror: ptr glib.Error
  let resul0 = g_socket_receive(cast[ptr Socket00](self.impl), cast[ptr uint8](unsafeaddr(buffer[0])), size, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = resul0

proc g_socket_receive_with_blocking(self: ptr Socket00; buffer: ptr uint8;
    size: var uint64; blocking: gboolean; cancellable: ptr Cancellable00; error: ptr ptr glib.Error = nil): int64 {.
    importc, libprag.}

proc receiveWithBlocking*(self: Socket; buffer: var (seq[uint8] | string);
    size: var uint64; blocking: bool; cancellable: Cancellable = nil): int64 =
  var gerror: ptr glib.Error
  let resul0 = g_socket_receive_with_blocking(cast[ptr Socket00](self.impl), cast[ptr uint8](unsafeaddr(buffer[0])), size, gboolean(blocking), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = resul0

proc g_socket_send(self: ptr Socket00; buffer: ptr uint8; size: uint64; cancellable: ptr Cancellable00;
    error: ptr ptr glib.Error = nil): int64 {.
    importc, libprag.}

proc send*(self: Socket; buffer: seq[uint8] | string; cancellable: Cancellable = nil): int64 =
  let size = uint64(buffer.len)
  var gerror: ptr glib.Error
  let resul0 = g_socket_send(cast[ptr Socket00](self.impl), cast[ptr uint8](unsafeaddr(buffer[0])), size, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = resul0

proc g_socket_send_with_blocking(self: ptr Socket00; buffer: ptr uint8; size: uint64;
    blocking: gboolean; cancellable: ptr Cancellable00; error: ptr ptr glib.Error = nil): int64 {.
    importc, libprag.}

proc sendWithBlocking*(self: Socket; buffer: seq[uint8] | string;
    blocking: bool; cancellable: Cancellable = nil): int64 =
  let size = uint64(buffer.len)
  var gerror: ptr glib.Error
  let resul0 = g_socket_send_with_blocking(cast[ptr Socket00](self.impl), cast[ptr uint8](unsafeaddr(buffer[0])), size, gboolean(blocking), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = resul0

proc g_socket_set_blocking(self: ptr Socket00; blocking: gboolean) {.
    importc, libprag.}

proc setBlocking*(self: Socket; blocking: bool = true) =
  g_socket_set_blocking(cast[ptr Socket00](self.impl), gboolean(blocking))

proc `blocking=`*(self: Socket; blocking: bool) =
  g_socket_set_blocking(cast[ptr Socket00](self.impl), gboolean(blocking))

proc g_socket_set_broadcast(self: ptr Socket00; broadcast: gboolean) {.
    importc, libprag.}

proc setBroadcast*(self: Socket; broadcast: bool = true) =
  g_socket_set_broadcast(cast[ptr Socket00](self.impl), gboolean(broadcast))

proc `broadcast=`*(self: Socket; broadcast: bool) =
  g_socket_set_broadcast(cast[ptr Socket00](self.impl), gboolean(broadcast))

proc g_socket_set_keepalive(self: ptr Socket00; keepalive: gboolean) {.
    importc, libprag.}

proc setKeepalive*(self: Socket; keepalive: bool = true) =
  g_socket_set_keepalive(cast[ptr Socket00](self.impl), gboolean(keepalive))

proc `keepalive=`*(self: Socket; keepalive: bool) =
  g_socket_set_keepalive(cast[ptr Socket00](self.impl), gboolean(keepalive))

proc g_socket_set_listen_backlog(self: ptr Socket00; backlog: int32) {.
    importc, libprag.}

proc setListenBacklog*(self: Socket; backlog: int) =
  g_socket_set_listen_backlog(cast[ptr Socket00](self.impl), int32(backlog))

proc `listenBacklog=`*(self: Socket; backlog: int) =
  g_socket_set_listen_backlog(cast[ptr Socket00](self.impl), int32(backlog))

proc g_socket_set_multicast_loopback(self: ptr Socket00; loopback: gboolean) {.
    importc, libprag.}

proc setMulticastLoopback*(self: Socket; loopback: bool = true) =
  g_socket_set_multicast_loopback(cast[ptr Socket00](self.impl), gboolean(loopback))

proc `multicastLoopback=`*(self: Socket; loopback: bool) =
  g_socket_set_multicast_loopback(cast[ptr Socket00](self.impl), gboolean(loopback))

proc g_socket_set_multicast_ttl(self: ptr Socket00; ttl: uint32) {.
    importc, libprag.}

proc setMulticastTtl*(self: Socket; ttl: int) =
  g_socket_set_multicast_ttl(cast[ptr Socket00](self.impl), uint32(ttl))

proc `multicastTtl=`*(self: Socket; ttl: int) =
  g_socket_set_multicast_ttl(cast[ptr Socket00](self.impl), uint32(ttl))

proc g_socket_set_option(self: ptr Socket00; level: int32; optname: int32;
    value: int32; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc setOption*(self: Socket; level: int; optname: int; value: int): bool =
  var gerror: ptr glib.Error
  let resul0 = g_socket_set_option(cast[ptr Socket00](self.impl), int32(level), int32(optname), int32(value), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_socket_set_timeout(self: ptr Socket00; timeout: uint32) {.
    importc, libprag.}

proc setTimeout*(self: Socket; timeout: int) =
  g_socket_set_timeout(cast[ptr Socket00](self.impl), uint32(timeout))

proc `timeout=`*(self: Socket; timeout: int) =
  g_socket_set_timeout(cast[ptr Socket00](self.impl), uint32(timeout))

proc g_socket_set_ttl(self: ptr Socket00; ttl: uint32) {.
    importc, libprag.}

proc setTtl*(self: Socket; ttl: int) =
  g_socket_set_ttl(cast[ptr Socket00](self.impl), uint32(ttl))

proc `ttl=`*(self: Socket; ttl: int) =
  g_socket_set_ttl(cast[ptr Socket00](self.impl), uint32(ttl))

proc g_socket_shutdown(self: ptr Socket00; shutdownRead: gboolean; shutdownWrite: gboolean;
    error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc shutdown*(self: Socket; shutdownRead: bool; shutdownWrite: bool): bool =
  var gerror: ptr glib.Error
  let resul0 = g_socket_shutdown(cast[ptr Socket00](self.impl), gboolean(shutdownRead), gboolean(shutdownWrite), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_socket_speaks_ipv4(self: ptr Socket00): gboolean {.
    importc, libprag.}

proc speaksIpv4*(self: Socket): bool =
  toBool(g_socket_speaks_ipv4(cast[ptr Socket00](self.impl)))

proc g_datagram_based_condition_check(self: ptr DatagramBased00; condition: glib.IOCondition): glib.IOCondition {.
    importc, libprag.}

proc conditionCheck*(self: DatagramBased | Socket; condition: glib.IOCondition): glib.IOCondition =
  g_datagram_based_condition_check(cast[ptr DatagramBased00](self.impl), condition)

proc g_datagram_based_condition_wait(self: ptr DatagramBased00; condition: glib.IOCondition;
    timeout: int64; cancellable: ptr Cancellable00; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc conditionWait*(self: DatagramBased | Socket; condition: glib.IOCondition;
    timeout: int64; cancellable: Cancellable = nil): bool =
  var gerror: ptr glib.Error
  let resul0 = g_datagram_based_condition_wait(cast[ptr DatagramBased00](self.impl), condition, timeout, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_datagram_based_create_source(self: ptr DatagramBased00; condition: glib.IOCondition;
    cancellable: ptr Cancellable00): ptr glib.Source00 {.
    importc, libprag.}

proc createSource*(self: DatagramBased | Socket; condition: glib.IOCondition;
    cancellable: Cancellable = nil): glib.Source =
  fnew(result, gBoxedFreeGSource)
  result.impl = g_datagram_based_create_source(cast[ptr DatagramBased00](self.impl), condition, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl))

type
  SocketConnection* = ref object of IOStream
  SocketConnection00* = object of IOStream00

proc g_socket_connection_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(SocketConnection()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc g_socket_connection_connect_finish(self: ptr SocketConnection00; resu: ptr AsyncResult00;
    error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc connectFinish*(self: SocketConnection; resu: AsyncResult | SimpleAsyncResult | Task): bool =
  var gerror: ptr glib.Error
  let resul0 = g_socket_connection_connect_finish(cast[ptr SocketConnection00](self.impl), cast[ptr AsyncResult00](resu.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_socket_connection_get_socket(self: ptr SocketConnection00): ptr Socket00 {.
    importc, libprag.}

proc getSocket*(self: SocketConnection): Socket =
  let gobj = g_socket_connection_get_socket(cast[ptr SocketConnection00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc socket*(self: SocketConnection): Socket =
  let gobj = g_socket_connection_get_socket(cast[ptr SocketConnection00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_socket_connection_is_connected(self: ptr SocketConnection00): gboolean {.
    importc, libprag.}

proc isConnected*(self: SocketConnection): bool =
  toBool(g_socket_connection_is_connected(cast[ptr SocketConnection00](self.impl)))

proc g_socket_connection_factory_create_connection(self: ptr Socket00): ptr SocketConnection00 {.
    importc, libprag.}

proc connectionFactoryCreateConnection*(self: Socket): SocketConnection =
  let gobj = g_socket_connection_factory_create_connection(cast[ptr Socket00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

type
  SocketFamily* {.size: sizeof(cint), pure.} = enum
    invalid = 0
    unix = 1
    ipv4 = 2
    ipv6 = 10

proc g_socket_get_family(self: ptr Socket00): SocketFamily {.
    importc, libprag.}

proc getFamily*(self: Socket): SocketFamily =
  g_socket_get_family(cast[ptr Socket00](self.impl))

proc family*(self: Socket): SocketFamily =
  g_socket_get_family(cast[ptr Socket00](self.impl))

type
  SocketProtocol* {.size: sizeof(cint), pure.} = enum
    unknown = -1
    default = 0
    tcp = 6
    udp = 17
    sctp = 132

proc g_socket_get_protocol(self: ptr Socket00): SocketProtocol {.
    importc, libprag.}

proc getProtocol*(self: Socket): SocketProtocol =
  g_socket_get_protocol(cast[ptr Socket00](self.impl))

proc protocol*(self: Socket): SocketProtocol =
  g_socket_get_protocol(cast[ptr Socket00](self.impl))

type
  SocketType* {.size: sizeof(cint), pure.} = enum
    invalid = 0
    stream = 1
    datagram = 2
    seqpacket = 3

proc g_socket_new(family: SocketFamily; `type`: SocketType; protocol: SocketProtocol;
    error: ptr ptr glib.Error = nil): ptr Socket00 {.
    importc, libprag.}

proc newSocket*(family: SocketFamily; `type`: SocketType; protocol: SocketProtocol): Socket =
  var gerror: ptr glib.Error
  let gobj = g_socket_new(family, `type`, protocol, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newSocket*(tdesc: typedesc; family: SocketFamily; `type`: SocketType; protocol: SocketProtocol): tdesc =
  var gerror: ptr glib.Error
  assert(result is Socket)
  let gobj = g_socket_new(family, `type`, protocol, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initSocket*[T](result: var T; family: SocketFamily; `type`: SocketType; protocol: SocketProtocol) {.deprecated.} =
  var gerror: ptr glib.Error
  assert(result is Socket)
  let gobj = g_socket_new(family, `type`, protocol, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_socket_get_socket_type(self: ptr Socket00): SocketType {.
    importc, libprag.}

proc getSocketType*(self: Socket): SocketType =
  g_socket_get_socket_type(cast[ptr Socket00](self.impl))

proc socketType*(self: Socket): SocketType =
  g_socket_get_socket_type(cast[ptr Socket00](self.impl))

proc g_socket_connection_factory_lookup_type(family: SocketFamily; `type`: SocketType;
    protocolId: int32): GType {.
    importc, libprag.}

proc factoryLookupType*(family: SocketFamily; `type`: SocketType;
    protocolId: int): GType =
  g_socket_connection_factory_lookup_type(family, `type`, int32(protocolId))

proc g_socket_connection_factory_register_type(gType: GType; family: SocketFamily;
    `type`: SocketType; protocol: int32) {.
    importc, libprag.}

proc factoryRegisterType*(gType: GType; family: SocketFamily;
    `type`: SocketType; protocol: int) =
  g_socket_connection_factory_register_type(gType, family, `type`, int32(protocol))

type
  InetAddress* = ref object of gobject.Object
  InetAddress00* = object of gobject.Object00

proc g_inet_address_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(InetAddress()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc g_inet_address_new_any(family: SocketFamily): ptr InetAddress00 {.
    importc, libprag.}

proc newInetAddressAny*(family: SocketFamily): InetAddress =
  let gobj = g_inet_address_new_any(family)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newInetAddressAny*(tdesc: typedesc; family: SocketFamily): tdesc =
  assert(result is InetAddress)
  let gobj = g_inet_address_new_any(family)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initInetAddressAny*[T](result: var T; family: SocketFamily) {.deprecated.} =
  assert(result is InetAddress)
  let gobj = g_inet_address_new_any(family)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_inet_address_new_from_bytes(bytes: ptr uint8; family: SocketFamily): ptr InetAddress00 {.
    importc, libprag.}

proc newInetAddressFromBytes*(bytes: seq[uint8] | string; family: SocketFamily): InetAddress =
  let gobj = g_inet_address_new_from_bytes(cast[ptr uint8](unsafeaddr(bytes[0])), family)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newInetAddressFromBytes*(tdesc: typedesc; bytes: seq[uint8] | string; family: SocketFamily): tdesc =
  assert(result is InetAddress)
  let gobj = g_inet_address_new_from_bytes(cast[ptr uint8](unsafeaddr(bytes[0])), family)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initInetAddressFromBytes*[T](result: var T; bytes: seq[uint8] | string; family: SocketFamily) {.deprecated.} =
  assert(result is InetAddress)
  let gobj = g_inet_address_new_from_bytes(cast[ptr uint8](unsafeaddr(bytes[0])), family)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_inet_address_new_from_string(string: cstring): ptr InetAddress00 {.
    importc, libprag.}

proc newInetAddressFromString*(string: cstring): InetAddress =
  let gobj = g_inet_address_new_from_string(string)
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newInetAddressFromString*(tdesc: typedesc; string: cstring): tdesc =
  assert(result is InetAddress)
  let gobj = g_inet_address_new_from_string(string)
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initInetAddressFromString*[T](result: var T; string: cstring) {.deprecated.} =
  assert(result is InetAddress)
  let gobj = g_inet_address_new_from_string(string)
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_inet_address_new_loopback(family: SocketFamily): ptr InetAddress00 {.
    importc, libprag.}

proc newInetAddressLoopback*(family: SocketFamily): InetAddress =
  let gobj = g_inet_address_new_loopback(family)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newInetAddressLoopback*(tdesc: typedesc; family: SocketFamily): tdesc =
  assert(result is InetAddress)
  let gobj = g_inet_address_new_loopback(family)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initInetAddressLoopback*[T](result: var T; family: SocketFamily) {.deprecated.} =
  assert(result is InetAddress)
  let gobj = g_inet_address_new_loopback(family)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_inet_address_equal(self: ptr InetAddress00; otherAddress: ptr InetAddress00): gboolean {.
    importc, libprag.}

proc equal*(self: InetAddress; otherAddress: InetAddress): bool =
  toBool(g_inet_address_equal(cast[ptr InetAddress00](self.impl), cast[ptr InetAddress00](otherAddress.impl)))

proc g_inet_address_get_family(self: ptr InetAddress00): SocketFamily {.
    importc, libprag.}

proc getFamily*(self: InetAddress): SocketFamily =
  g_inet_address_get_family(cast[ptr InetAddress00](self.impl))

proc family*(self: InetAddress): SocketFamily =
  g_inet_address_get_family(cast[ptr InetAddress00](self.impl))

proc g_inet_address_get_is_any(self: ptr InetAddress00): gboolean {.
    importc, libprag.}

proc getIsAny*(self: InetAddress): bool =
  toBool(g_inet_address_get_is_any(cast[ptr InetAddress00](self.impl)))

proc isAny*(self: InetAddress): bool =
  toBool(g_inet_address_get_is_any(cast[ptr InetAddress00](self.impl)))

proc g_inet_address_get_is_link_local(self: ptr InetAddress00): gboolean {.
    importc, libprag.}

proc getIsLinkLocal*(self: InetAddress): bool =
  toBool(g_inet_address_get_is_link_local(cast[ptr InetAddress00](self.impl)))

proc isLinkLocal*(self: InetAddress): bool =
  toBool(g_inet_address_get_is_link_local(cast[ptr InetAddress00](self.impl)))

proc g_inet_address_get_is_loopback(self: ptr InetAddress00): gboolean {.
    importc, libprag.}

proc getIsLoopback*(self: InetAddress): bool =
  toBool(g_inet_address_get_is_loopback(cast[ptr InetAddress00](self.impl)))

proc isLoopback*(self: InetAddress): bool =
  toBool(g_inet_address_get_is_loopback(cast[ptr InetAddress00](self.impl)))

proc g_inet_address_get_is_mc_global(self: ptr InetAddress00): gboolean {.
    importc, libprag.}

proc getIsMcGlobal*(self: InetAddress): bool =
  toBool(g_inet_address_get_is_mc_global(cast[ptr InetAddress00](self.impl)))

proc isMcGlobal*(self: InetAddress): bool =
  toBool(g_inet_address_get_is_mc_global(cast[ptr InetAddress00](self.impl)))

proc g_inet_address_get_is_mc_link_local(self: ptr InetAddress00): gboolean {.
    importc, libprag.}

proc getIsMcLinkLocal*(self: InetAddress): bool =
  toBool(g_inet_address_get_is_mc_link_local(cast[ptr InetAddress00](self.impl)))

proc isMcLinkLocal*(self: InetAddress): bool =
  toBool(g_inet_address_get_is_mc_link_local(cast[ptr InetAddress00](self.impl)))

proc g_inet_address_get_is_mc_node_local(self: ptr InetAddress00): gboolean {.
    importc, libprag.}

proc getIsMcNodeLocal*(self: InetAddress): bool =
  toBool(g_inet_address_get_is_mc_node_local(cast[ptr InetAddress00](self.impl)))

proc isMcNodeLocal*(self: InetAddress): bool =
  toBool(g_inet_address_get_is_mc_node_local(cast[ptr InetAddress00](self.impl)))

proc g_inet_address_get_is_mc_org_local(self: ptr InetAddress00): gboolean {.
    importc, libprag.}

proc getIsMcOrgLocal*(self: InetAddress): bool =
  toBool(g_inet_address_get_is_mc_org_local(cast[ptr InetAddress00](self.impl)))

proc isMcOrgLocal*(self: InetAddress): bool =
  toBool(g_inet_address_get_is_mc_org_local(cast[ptr InetAddress00](self.impl)))

proc g_inet_address_get_is_mc_site_local(self: ptr InetAddress00): gboolean {.
    importc, libprag.}

proc getIsMcSiteLocal*(self: InetAddress): bool =
  toBool(g_inet_address_get_is_mc_site_local(cast[ptr InetAddress00](self.impl)))

proc isMcSiteLocal*(self: InetAddress): bool =
  toBool(g_inet_address_get_is_mc_site_local(cast[ptr InetAddress00](self.impl)))

proc g_inet_address_get_is_multicast(self: ptr InetAddress00): gboolean {.
    importc, libprag.}

proc getIsMulticast*(self: InetAddress): bool =
  toBool(g_inet_address_get_is_multicast(cast[ptr InetAddress00](self.impl)))

proc isMulticast*(self: InetAddress): bool =
  toBool(g_inet_address_get_is_multicast(cast[ptr InetAddress00](self.impl)))

proc g_inet_address_get_is_site_local(self: ptr InetAddress00): gboolean {.
    importc, libprag.}

proc getIsSiteLocal*(self: InetAddress): bool =
  toBool(g_inet_address_get_is_site_local(cast[ptr InetAddress00](self.impl)))

proc isSiteLocal*(self: InetAddress): bool =
  toBool(g_inet_address_get_is_site_local(cast[ptr InetAddress00](self.impl)))

proc g_inet_address_get_native_size(self: ptr InetAddress00): uint64 {.
    importc, libprag.}

proc getNativeSize*(self: InetAddress): uint64 =
  g_inet_address_get_native_size(cast[ptr InetAddress00](self.impl))

proc nativeSize*(self: InetAddress): uint64 =
  g_inet_address_get_native_size(cast[ptr InetAddress00](self.impl))

proc g_inet_address_to_string(self: ptr InetAddress00): cstring {.
    importc, libprag.}

proc toString*(self: InetAddress): string =
  let resul0 = g_inet_address_to_string(cast[ptr InetAddress00](self.impl))
  result = $resul0
  cogfree(resul0)

proc g_socket_join_multicast_group(self: ptr Socket00; group: ptr InetAddress00;
    sourceSpecific: gboolean; iface: cstring; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc joinMulticastGroup*(self: Socket; group: InetAddress; sourceSpecific: bool;
    iface: cstring = nil): bool =
  var gerror: ptr glib.Error
  let resul0 = g_socket_join_multicast_group(cast[ptr Socket00](self.impl), cast[ptr InetAddress00](group.impl), gboolean(sourceSpecific), iface, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_socket_join_multicast_group_ssm(self: ptr Socket00; group: ptr InetAddress00;
    sourceSpecific: ptr InetAddress00; iface: cstring; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc joinMulticastGroupSsm*(self: Socket; group: InetAddress;
    sourceSpecific: InetAddress = nil; iface: cstring = nil): bool =
  var gerror: ptr glib.Error
  let resul0 = g_socket_join_multicast_group_ssm(cast[ptr Socket00](self.impl), cast[ptr InetAddress00](group.impl), if sourceSpecific.isNil: nil else: cast[ptr InetAddress00](sourceSpecific.impl), iface, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_socket_leave_multicast_group(self: ptr Socket00; group: ptr InetAddress00;
    sourceSpecific: gboolean; iface: cstring; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc leaveMulticastGroup*(self: Socket; group: InetAddress; sourceSpecific: bool;
    iface: cstring = nil): bool =
  var gerror: ptr glib.Error
  let resul0 = g_socket_leave_multicast_group(cast[ptr Socket00](self.impl), cast[ptr InetAddress00](group.impl), gboolean(sourceSpecific), iface, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_socket_leave_multicast_group_ssm(self: ptr Socket00; group: ptr InetAddress00;
    sourceSpecific: ptr InetAddress00; iface: cstring; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc leaveMulticastGroupSsm*(self: Socket; group: InetAddress;
    sourceSpecific: InetAddress = nil; iface: cstring = nil): bool =
  var gerror: ptr glib.Error
  let resul0 = g_socket_leave_multicast_group_ssm(cast[ptr Socket00](self.impl), cast[ptr InetAddress00](group.impl), if sourceSpecific.isNil: nil else: cast[ptr InetAddress00](sourceSpecific.impl), iface, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

type
  SocketAddress* = ref object of gobject.Object
  SocketAddress00* = object of gobject.Object00

proc g_socket_address_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(SocketAddress()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc g_socket_address_new_from_native(native: pointer; len: uint64): ptr SocketAddress00 {.
    importc, libprag.}

proc newSocketAddressFromNative*(native: pointer; len: uint64): SocketAddress =
  let gobj = g_socket_address_new_from_native(native, len)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newSocketAddressFromNative*(tdesc: typedesc; native: pointer; len: uint64): tdesc =
  assert(result is SocketAddress)
  let gobj = g_socket_address_new_from_native(native, len)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initSocketAddressFromNative*[T](result: var T; native: pointer; len: uint64) {.deprecated.} =
  assert(result is SocketAddress)
  let gobj = g_socket_address_new_from_native(native, len)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_socket_address_get_family(self: ptr SocketAddress00): SocketFamily {.
    importc, libprag.}

proc getFamily*(self: SocketAddress): SocketFamily =
  g_socket_address_get_family(cast[ptr SocketAddress00](self.impl))

proc family*(self: SocketAddress): SocketFamily =
  g_socket_address_get_family(cast[ptr SocketAddress00](self.impl))

proc g_socket_address_get_native_size(self: ptr SocketAddress00): int64 {.
    importc, libprag.}

proc getNativeSize*(self: SocketAddress): int64 =
  g_socket_address_get_native_size(cast[ptr SocketAddress00](self.impl))

proc nativeSize*(self: SocketAddress): int64 =
  g_socket_address_get_native_size(cast[ptr SocketAddress00](self.impl))

proc g_socket_address_to_native(self: ptr SocketAddress00; dest: pointer;
    destlen: uint64; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc toNative*(self: SocketAddress; dest: pointer; destlen: uint64): bool =
  var gerror: ptr glib.Error
  let resul0 = g_socket_address_to_native(cast[ptr SocketAddress00](self.impl), dest, destlen, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_socket_bind(self: ptr Socket00; address: ptr SocketAddress00; allowReuse: gboolean;
    error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc `bind`*(self: Socket; address: SocketAddress; allowReuse: bool): bool =
  var gerror: ptr glib.Error
  let resul0 = g_socket_bind(cast[ptr Socket00](self.impl), cast[ptr SocketAddress00](address.impl), gboolean(allowReuse), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_socket_connect(self: ptr Socket00; address: ptr SocketAddress00; cancellable: ptr Cancellable00;
    error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc connect*(self: Socket; address: SocketAddress; cancellable: Cancellable = nil): bool =
  var gerror: ptr glib.Error
  let resul0 = g_socket_connect(cast[ptr Socket00](self.impl), cast[ptr SocketAddress00](address.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_socket_get_local_address(self: ptr Socket00; error: ptr ptr glib.Error = nil): ptr SocketAddress00 {.
    importc, libprag.}

proc getLocalAddress*(self: Socket): SocketAddress =
  var gerror: ptr glib.Error
  let gobj = g_socket_get_local_address(cast[ptr Socket00](self.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc localAddress*(self: Socket): SocketAddress =
  var gerror: ptr glib.Error
  let gobj = g_socket_get_local_address(cast[ptr Socket00](self.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_socket_get_remote_address(self: ptr Socket00; error: ptr ptr glib.Error = nil): ptr SocketAddress00 {.
    importc, libprag.}

proc getRemoteAddress*(self: Socket): SocketAddress =
  var gerror: ptr glib.Error
  let gobj = g_socket_get_remote_address(cast[ptr Socket00](self.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc remoteAddress*(self: Socket): SocketAddress =
  var gerror: ptr glib.Error
  let gobj = g_socket_get_remote_address(cast[ptr Socket00](self.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_socket_receive_from(self: ptr Socket00; address: var ptr SocketAddress00;
    buffer: ptr uint8; size: var uint64; cancellable: ptr Cancellable00; error: ptr ptr glib.Error = nil): int64 {.
    importc, libprag.}

proc receiveFrom*(self: Socket; address: var SocketAddress = cast[var SocketAddress](nil);
    buffer: var (seq[uint8] | string); size: var uint64; cancellable: Cancellable = nil): int64 =
  var tmpoutgobjectarg: ptr SocketAddress00
  var gerror: ptr glib.Error
  let resul0 = g_socket_receive_from(cast[ptr Socket00](self.impl), cast[var ptr SocketAddress00](if addr(address) == nil: nil else: addr tmpoutgobjectarg), cast[ptr uint8](unsafeaddr(buffer[0])), size, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = resul0
#  dothemagic(address
  if addr(address) != nil:
    address = nil

  if tmpoutgobjectarg != nil:
    let argqdata = g_object_get_qdata(tmpoutgobjectarg, Quark)
    if argqdata != nil:
      address = cast[type(address)](argqdata)
      assert(address.impl == tmpoutgobjectarg)
    else:
      fnew(address, gio.finalizeGObject)
      address.impl = tmpoutgobjectarg
      GC_ref(address)
      if g_object_is_floating(address.impl).int != 0:
        discard g_object_ref_sink(address.impl)
      g_object_add_toggle_ref(address.impl, toggleNotify, addr(address[]))
      g_object_unref(address.impl)
      assert(g_object_get_qdata(address.impl, Quark) == nil)
      g_object_set_qdata(address.impl, Quark, addr(address[]))


proc g_socket_send_to(self: ptr Socket00; address: ptr SocketAddress00; buffer: ptr uint8;
    size: uint64; cancellable: ptr Cancellable00; error: ptr ptr glib.Error = nil): int64 {.
    importc, libprag.}

proc sendTo*(self: Socket; address: SocketAddress = nil; buffer: seq[uint8] | string;
    cancellable: Cancellable = nil): int64 =
  let size = uint64(buffer.len)
  var gerror: ptr glib.Error
  let resul0 = g_socket_send_to(cast[ptr Socket00](self.impl), if address.isNil: nil else: cast[ptr SocketAddress00](address.impl), cast[ptr uint8](unsafeaddr(buffer[0])), size, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = resul0

proc g_socket_connection_connect(self: ptr SocketConnection00; address: ptr SocketAddress00;
    cancellable: ptr Cancellable00; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc connect*(self: SocketConnection; address: SocketAddress;
    cancellable: Cancellable = nil): bool =
  var gerror: ptr glib.Error
  let resul0 = g_socket_connection_connect(cast[ptr SocketConnection00](self.impl), cast[ptr SocketAddress00](address.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_socket_connection_connect_async(self: ptr SocketConnection00; address: ptr SocketAddress00;
    cancellable: ptr Cancellable00; callback: AsyncReadyCallback; userData: pointer) {.
    importc, libprag.}

proc connectAsync*(self: SocketConnection; address: SocketAddress;
    cancellable: Cancellable = nil; callback: AsyncReadyCallback; userData: pointer) =
  g_socket_connection_connect_async(cast[ptr SocketConnection00](self.impl), cast[ptr SocketAddress00](address.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_socket_connection_get_local_address(self: ptr SocketConnection00;
    error: ptr ptr glib.Error = nil): ptr SocketAddress00 {.
    importc, libprag.}

proc getLocalAddress*(self: SocketConnection): SocketAddress =
  var gerror: ptr glib.Error
  let gobj = g_socket_connection_get_local_address(cast[ptr SocketConnection00](self.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc localAddress*(self: SocketConnection): SocketAddress =
  var gerror: ptr glib.Error
  let gobj = g_socket_connection_get_local_address(cast[ptr SocketConnection00](self.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_socket_connection_get_remote_address(self: ptr SocketConnection00;
    error: ptr ptr glib.Error = nil): ptr SocketAddress00 {.
    importc, libprag.}

proc getRemoteAddress*(self: SocketConnection): SocketAddress =
  var gerror: ptr glib.Error
  let gobj = g_socket_connection_get_remote_address(cast[ptr SocketConnection00](self.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc remoteAddress*(self: SocketConnection): SocketAddress =
  var gerror: ptr glib.Error
  let gobj = g_socket_connection_get_remote_address(cast[ptr SocketConnection00](self.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

type
  InputVector00* {.pure.} = object
  InputVector* = ref object
    impl*: ptr InputVector00
    ignoreFinalizer*: bool

type
  SocketControlMessage* = ref object of gobject.Object
  SocketControlMessage00* = object of gobject.Object00

proc g_socket_control_message_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(SocketControlMessage()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc g_socket_control_message_deserialize(level: int32; `type`: int32; size: uint64;
    data: ptr uint8): ptr SocketControlMessage00 {.
    importc, libprag.}

proc deserialize*(level: int; `type`: int; data: seq[uint8] | string): SocketControlMessage =
  let size = uint64(data.len)
  let gobj = g_socket_control_message_deserialize(int32(level), int32(`type`), size, cast[ptr uint8](unsafeaddr(data[0])))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_socket_control_message_get_level(self: ptr SocketControlMessage00): int32 {.
    importc, libprag.}

proc getLevel*(self: SocketControlMessage): int =
  int(g_socket_control_message_get_level(cast[ptr SocketControlMessage00](self.impl)))

proc level*(self: SocketControlMessage): int =
  int(g_socket_control_message_get_level(cast[ptr SocketControlMessage00](self.impl)))

proc g_socket_control_message_get_msg_type(self: ptr SocketControlMessage00): int32 {.
    importc, libprag.}

proc getMsgType*(self: SocketControlMessage): int =
  int(g_socket_control_message_get_msg_type(cast[ptr SocketControlMessage00](self.impl)))

proc msgType*(self: SocketControlMessage): int =
  int(g_socket_control_message_get_msg_type(cast[ptr SocketControlMessage00](self.impl)))

proc g_socket_control_message_get_size(self: ptr SocketControlMessage00): uint64 {.
    importc, libprag.}

proc getSize*(self: SocketControlMessage): uint64 =
  g_socket_control_message_get_size(cast[ptr SocketControlMessage00](self.impl))

proc size*(self: SocketControlMessage): uint64 =
  g_socket_control_message_get_size(cast[ptr SocketControlMessage00](self.impl))

proc g_socket_control_message_serialize(self: ptr SocketControlMessage00;
    data: pointer) {.
    importc, libprag.}

proc serialize*(self: SocketControlMessage; data: pointer) =
  g_socket_control_message_serialize(cast[ptr SocketControlMessage00](self.impl), data)

proc g_socket_receive_message(self: ptr Socket00; address: var ptr SocketAddress00;
    vectors: ptr InputVector00; numVectors: int32; messages: var ptr ptr SocketControlMessage00;
    numMessages: var int32; flags: var int32; cancellable: ptr Cancellable00;
    error: ptr ptr glib.Error = nil): int64 {.
    importc, libprag.}

proc receiveMessage*(self: Socket; address: var SocketAddress = cast[var SocketAddress](nil);
    vectors: ptr InputVector00; numVectors: int; messages: var ptr ptr SocketControlMessage00 = cast[var ptr ptr SocketControlMessage00](nil);
    numMessages: var int; flags: var int; cancellable: Cancellable = nil): int64 =
  var tmpoutgobjectarg: ptr SocketAddress00
  var gerror: ptr glib.Error
  var numMessages_00: int32
  var flags_00 = int32(flags)
  let resul0 = g_socket_receive_message(cast[ptr Socket00](self.impl), cast[var ptr SocketAddress00](if addr(address) == nil: nil else: addr tmpoutgobjectarg), vectors, int32(numVectors), messages, numMessages_00, flags_00, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = resul0
  if numMessages.addr != nil:
    numMessages = int(numMessages_00)
  flags = int(flags_00)
#  dothemagic(address
  if addr(address) != nil:
    address = nil

  if tmpoutgobjectarg != nil:
    let argqdata = g_object_get_qdata(tmpoutgobjectarg, Quark)
    if argqdata != nil:
      address = cast[type(address)](argqdata)
      assert(address.impl == tmpoutgobjectarg)
    else:
      fnew(address, gio.finalizeGObject)
      address.impl = tmpoutgobjectarg
      GC_ref(address)
      if g_object_is_floating(address.impl).int != 0:
        discard g_object_ref_sink(address.impl)
      g_object_add_toggle_ref(address.impl, toggleNotify, addr(address[]))
      g_object_unref(address.impl)
      assert(g_object_get_qdata(address.impl, Quark) == nil)
      g_object_set_qdata(address.impl, Quark, addr(address[]))


proc g_socket_send_message(self: ptr Socket00; address: ptr SocketAddress00;
    vectors: ptr OutputVector; numVectors: int32; messages: ptr ptr SocketControlMessage00;
    numMessages: int32; flags: int32; cancellable: ptr Cancellable00; error: ptr ptr glib.Error = nil): int64 {.
    importc, libprag.}

proc sendMessage*(self: Socket; address: SocketAddress = nil; vectors: ptr OutputVector;
    numVectors: int; messages: ptr ptr SocketControlMessage00; numMessages: int;
    flags: int; cancellable: Cancellable = nil): int64 =
  var gerror: ptr glib.Error
  let resul0 = g_socket_send_message(cast[ptr Socket00](self.impl), if address.isNil: nil else: cast[ptr SocketAddress00](address.impl), vectors, int32(numVectors), messages, int32(numMessages), int32(flags), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = resul0

type
  PollableReturn* {.size: sizeof(cint), pure.} = enum
    wouldBlock = -27
    failed = 0
    ok = 1

proc g_socket_send_message_with_timeout(self: ptr Socket00; address: ptr SocketAddress00;
    vectors: ptr OutputVector; numVectors: int32; messages: ptr ptr SocketControlMessage00;
    numMessages: int32; flags: int32; timeoutUs: int64; bytesWritten: var uint64;
    cancellable: ptr Cancellable00; error: ptr ptr glib.Error = nil): PollableReturn {.
    importc, libprag.}

proc sendMessageWithTimeout*(self: Socket; address: SocketAddress = nil;
    vectors: ptr OutputVector; numVectors: int; messages: ptr ptr SocketControlMessage00;
    numMessages: int; flags: int; timeoutUs: int64; bytesWritten: var uint64 = cast[var uint64](nil);
    cancellable: Cancellable = nil): PollableReturn =
  var gerror: ptr glib.Error
  let resul0 = g_socket_send_message_with_timeout(cast[ptr Socket00](self.impl), if address.isNil: nil else: cast[ptr SocketAddress00](address.impl), vectors, int32(numVectors), messages, int32(numMessages), int32(flags), timeoutUs, bytesWritten, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = resul0

type
  InputMessage00* {.pure.} = object
  InputMessage* = ref object
    impl*: ptr InputMessage00
    ignoreFinalizer*: bool

proc g_datagram_based_receive_messages(self: ptr DatagramBased00; messages: ptr InputMessage00;
    numMessages: uint32; flags: int32; timeout: int64; cancellable: ptr Cancellable00;
    error: ptr ptr glib.Error = nil): int32 {.
    importc, libprag.}

proc receiveMessages*(self: DatagramBased | Socket; messages: ptr InputMessage00;
    numMessages: int; flags: int; timeout: int64; cancellable: Cancellable = nil): int =
  var gerror: ptr glib.Error
  let resul0 = g_datagram_based_receive_messages(cast[ptr DatagramBased00](self.impl), messages, uint32(numMessages), int32(flags), timeout, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = int(resul0)

proc g_socket_receive_messages(self: ptr Socket00; messages: ptr InputMessage00;
    numMessages: uint32; flags: int32; cancellable: ptr Cancellable00; error: ptr ptr glib.Error = nil): int32 {.
    importc, libprag.}

proc receiveMessages*(self: Socket; messages: ptr InputMessage00;
    numMessages: int; flags: int; cancellable: Cancellable = nil): int =
  var gerror: ptr glib.Error
  let resul0 = g_socket_receive_messages(cast[ptr Socket00](self.impl), messages, uint32(numMessages), int32(flags), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = int(resul0)

type
  OutputMessage00* {.pure.} = object
  OutputMessage* = ref object
    impl*: ptr OutputMessage00
    ignoreFinalizer*: bool

proc g_datagram_based_send_messages(self: ptr DatagramBased00; messages: ptr OutputMessage00;
    numMessages: uint32; flags: int32; timeout: int64; cancellable: ptr Cancellable00;
    error: ptr ptr glib.Error = nil): int32 {.
    importc, libprag.}

proc sendMessages*(self: DatagramBased | Socket; messages: ptr OutputMessage00;
    numMessages: int; flags: int; timeout: int64; cancellable: Cancellable = nil): int =
  var gerror: ptr glib.Error
  let resul0 = g_datagram_based_send_messages(cast[ptr DatagramBased00](self.impl), messages, uint32(numMessages), int32(flags), timeout, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = int(resul0)

proc g_socket_send_messages(self: ptr Socket00; messages: ptr OutputMessage00;
    numMessages: uint32; flags: int32; cancellable: ptr Cancellable00; error: ptr ptr glib.Error = nil): int32 {.
    importc, libprag.}

proc sendMessages*(self: Socket; messages: ptr OutputMessage00;
    numMessages: int; flags: int; cancellable: Cancellable = nil): int =
  var gerror: ptr glib.Error
  let resul0 = g_socket_send_messages(cast[ptr Socket00](self.impl), messages, uint32(numMessages), int32(flags), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = int(resul0)

type
  DatagramBasedSourceFunc* = proc (datagramBased: ptr DatagramBased00; condition: glib.IOCondition; userData: pointer): gboolean {.cdecl.}

type
  DesktopAppInfoLookup00* = object of gobject.Object00
  DesktopAppInfoLookup* = ref object of gobject.Object

proc g_desktop_app_info_lookup_get_default_for_uri_scheme(self: ptr DesktopAppInfoLookup00;
    uriScheme: cstring): ptr AppInfo00 {.
    importc, libprag.}

proc getDefaultForUriScheme*(self: DesktopAppInfoLookup;
    uriScheme: cstring): AppInfo =
  let gobj = g_desktop_app_info_lookup_get_default_for_uri_scheme(cast[ptr DesktopAppInfoLookup00](self.impl), uriScheme)
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

type
  DesktopAppLaunchCallback* = proc (appinfo: ptr DesktopAppInfo00; pid: int32; userData: pointer) {.cdecl.}

proc g_desktop_app_info_launch_uris_as_manager(self: ptr DesktopAppInfo00;
    uris: ptr glib.List; launchContext: ptr AppLaunchContext00; spawnFlags: glib.SpawnFlags;
    userSetup: SpawnChildSetupFunc; userSetupData: pointer; pidCallback: DesktopAppLaunchCallback;
    pidCallbackData: pointer; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc launchUrisAsManager*(self: DesktopAppInfo; uris: seq[cstring];
    launchContext: AppLaunchContext = nil; spawnFlags: glib.SpawnFlags; userSetup: SpawnChildSetupFunc;
    userSetupData: pointer; pidCallback: DesktopAppLaunchCallback; pidCallbackData: pointer): bool =
  var tempResGL = seq2GList(uris)
  var gerror: ptr glib.Error
  let resul0 = g_desktop_app_info_launch_uris_as_manager(cast[ptr DesktopAppInfo00](self.impl), tempResGL, if launchContext.isNil: nil else: cast[ptr AppLaunchContext00](launchContext.impl), spawnFlags, userSetup, userSetupData, pidCallback, pidCallbackData, addr gerror)
  g_list_free(tempResGL)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_desktop_app_info_launch_uris_as_manager_with_fds(self: ptr DesktopAppInfo00;
    uris: ptr glib.List; launchContext: ptr AppLaunchContext00; spawnFlags: glib.SpawnFlags;
    userSetup: SpawnChildSetupFunc; userSetupData: pointer; pidCallback: DesktopAppLaunchCallback;
    pidCallbackData: pointer; stdinFd: int32; stdoutFd: int32; stderrFd: int32;
    error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc launchUrisAsManagerWithFds*(self: DesktopAppInfo;
    uris: seq[cstring]; launchContext: AppLaunchContext = nil; spawnFlags: glib.SpawnFlags;
    userSetup: SpawnChildSetupFunc; userSetupData: pointer; pidCallback: DesktopAppLaunchCallback;
    pidCallbackData: pointer; stdinFd: int; stdoutFd: int; stderrFd: int): bool =
  var tempResGL = seq2GList(uris)
  var gerror: ptr glib.Error
  let resul0 = g_desktop_app_info_launch_uris_as_manager_with_fds(cast[ptr DesktopAppInfo00](self.impl), tempResGL, if launchContext.isNil: nil else: cast[ptr AppLaunchContext00](launchContext.impl), spawnFlags, userSetup, userSetupData, pidCallback, pidCallbackData, int32(stdinFd), int32(stdoutFd), int32(stderrFd), addr gerror)
  g_list_free(tempResGL)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

type
  DtlsClientConnection00* = object of gobject.Object00
  DtlsClientConnection* = ref object of gobject.Object

proc g_dtls_client_connection_get_accepted_cas(self: ptr DtlsClientConnection00): ptr glib.List {.
    importc, libprag.}

proc getAcceptedCas*(self: DtlsClientConnection): seq[ptr ByteArray00] =
  let resul0 = g_dtls_client_connection_get_accepted_cas(cast[ptr DtlsClientConnection00](self.impl))
  g_list_free(resul0)

proc acceptedCas*(self: DtlsClientConnection): seq[ptr ByteArray00] =
  let resul0 = g_dtls_client_connection_get_accepted_cas(cast[ptr DtlsClientConnection00](self.impl))
  g_list_free(resul0)

type
  SocketConnectable00* = object of gobject.Object00
  SocketConnectable* = ref object of gobject.Object

proc g_dtls_client_connection_get_server_identity(self: ptr DtlsClientConnection00): ptr SocketConnectable00 {.
    importc, libprag.}

proc getServerIdentity*(self: DtlsClientConnection): SocketConnectable =
  let gobj = g_dtls_client_connection_get_server_identity(cast[ptr DtlsClientConnection00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc serverIdentity*(self: DtlsClientConnection): SocketConnectable =
  let gobj = g_dtls_client_connection_get_server_identity(cast[ptr DtlsClientConnection00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

type
  SocketAddressEnumerator* = ref object of gobject.Object
  SocketAddressEnumerator00* = object of gobject.Object00

proc g_socket_address_enumerator_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(SocketAddressEnumerator()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc g_socket_address_enumerator_next(self: ptr SocketAddressEnumerator00;
    cancellable: ptr Cancellable00; error: ptr ptr glib.Error = nil): ptr SocketAddress00 {.
    importc, libprag.}

proc next*(self: SocketAddressEnumerator; cancellable: Cancellable = nil): SocketAddress =
  var gerror: ptr glib.Error
  let gobj = g_socket_address_enumerator_next(cast[ptr SocketAddressEnumerator00](self.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_socket_address_enumerator_next_async(self: ptr SocketAddressEnumerator00;
    cancellable: ptr Cancellable00; callback: AsyncReadyCallback; userData: pointer) {.
    importc, libprag.}

proc nextAsync*(self: SocketAddressEnumerator;
    cancellable: Cancellable = nil; callback: AsyncReadyCallback; userData: pointer) =
  g_socket_address_enumerator_next_async(cast[ptr SocketAddressEnumerator00](self.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_socket_address_enumerator_next_finish(self: ptr SocketAddressEnumerator00;
    resu: ptr AsyncResult00; error: ptr ptr glib.Error = nil): ptr SocketAddress00 {.
    importc, libprag.}

proc nextFinish*(self: SocketAddressEnumerator;
    resu: AsyncResult | SimpleAsyncResult | Task): SocketAddress =
  var gerror: ptr glib.Error
  let gobj = g_socket_address_enumerator_next_finish(cast[ptr SocketAddressEnumerator00](self.impl), cast[ptr AsyncResult00](resu.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

type
  NativeSocketAddress* = ref object of SocketAddress
  NativeSocketAddress00* = object of SocketAddress00

proc g_native_socket_address_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(NativeSocketAddress()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc g_native_socket_address_new(native: pointer; len: uint64): ptr NativeSocketAddress00 {.
    importc, libprag.}

proc newNativeSocketAddress*(native: pointer; len: uint64): NativeSocketAddress =
  let gobj = g_native_socket_address_new(native, len)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newNativeSocketAddress*(tdesc: typedesc; native: pointer; len: uint64): tdesc =
  assert(result is NativeSocketAddress)
  let gobj = g_native_socket_address_new(native, len)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initNativeSocketAddress*[T](result: var T; native: pointer; len: uint64) {.deprecated.} =
  assert(result is NativeSocketAddress)
  let gobj = g_native_socket_address_new(native, len)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

type
  UnixSocketAddress* = ref object of SocketAddress
  UnixSocketAddress00* = object of SocketAddress00

proc g_unix_socket_address_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(UnixSocketAddress()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc g_unix_socket_address_new(path: cstring): ptr UnixSocketAddress00 {.
    importc, libprag.}

proc newUnixSocketAddress*(path: cstring): UnixSocketAddress =
  let gobj = g_unix_socket_address_new(path)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newUnixSocketAddress*(tdesc: typedesc; path: cstring): tdesc =
  assert(result is UnixSocketAddress)
  let gobj = g_unix_socket_address_new(path)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initUnixSocketAddress*[T](result: var T; path: cstring) {.deprecated.} =
  assert(result is UnixSocketAddress)
  let gobj = g_unix_socket_address_new(path)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_unix_socket_address_new_abstract(path: ptr int8; pathLen: int32): ptr UnixSocketAddress00 {.
    importc, libprag.}

proc newUnixSocketAddressAbstract*(path: ptr int8; pathLen: int): UnixSocketAddress {.deprecated.}  =
  let gobj = g_unix_socket_address_new_abstract(path, int32(pathLen))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newUnixSocketAddressAbstract*(tdesc: typedesc; path: ptr int8; pathLen: int): tdesc {.deprecated.}  =
  assert(result is UnixSocketAddress)
  let gobj = g_unix_socket_address_new_abstract(path, int32(pathLen))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initUnixSocketAddressAbstract*[T](result: var T; path: ptr int8; pathLen: int) {.deprecated.} =
  assert(result is UnixSocketAddress)
  let gobj = g_unix_socket_address_new_abstract(path, int32(pathLen))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_unix_socket_address_abstract_names_supported(): gboolean {.
    importc, libprag.}

proc abstractNamesSupported*(): bool =
  toBool(g_unix_socket_address_abstract_names_supported())

proc g_unix_socket_address_get_is_abstract(self: ptr UnixSocketAddress00): gboolean {.
    importc, libprag.}

proc getIsAbstract*(self: UnixSocketAddress): bool =
  toBool(g_unix_socket_address_get_is_abstract(cast[ptr UnixSocketAddress00](self.impl)))

proc isAbstract*(self: UnixSocketAddress): bool =
  toBool(g_unix_socket_address_get_is_abstract(cast[ptr UnixSocketAddress00](self.impl)))

proc g_unix_socket_address_get_path(self: ptr UnixSocketAddress00): cstring {.
    importc, libprag.}

proc getPath*(self: UnixSocketAddress): string =
  result = $g_unix_socket_address_get_path(cast[ptr UnixSocketAddress00](self.impl))

proc path*(self: UnixSocketAddress): string =
  result = $g_unix_socket_address_get_path(cast[ptr UnixSocketAddress00](self.impl))

proc g_unix_socket_address_get_path_len(self: ptr UnixSocketAddress00): uint64 {.
    importc, libprag.}

proc getPathLen*(self: UnixSocketAddress): uint64 =
  g_unix_socket_address_get_path_len(cast[ptr UnixSocketAddress00](self.impl))

proc pathLen*(self: UnixSocketAddress): uint64 =
  g_unix_socket_address_get_path_len(cast[ptr UnixSocketAddress00](self.impl))

type
  NetworkService* = ref object of gobject.Object
  NetworkService00* = object of gobject.Object00

proc g_network_service_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(NetworkService()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc g_network_service_new(service: cstring; protocol: cstring; domain: cstring): ptr NetworkService00 {.
    importc, libprag.}

proc newNetworkService*(service: cstring; protocol: cstring; domain: cstring): NetworkService =
  let gobj = g_network_service_new(service, protocol, domain)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newNetworkService*(tdesc: typedesc; service: cstring; protocol: cstring; domain: cstring): tdesc =
  assert(result is NetworkService)
  let gobj = g_network_service_new(service, protocol, domain)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initNetworkService*[T](result: var T; service: cstring; protocol: cstring; domain: cstring) {.deprecated.} =
  assert(result is NetworkService)
  let gobj = g_network_service_new(service, protocol, domain)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_network_service_get_domain(self: ptr NetworkService00): cstring {.
    importc, libprag.}

proc getDomain*(self: NetworkService): string =
  result = $g_network_service_get_domain(cast[ptr NetworkService00](self.impl))

proc domain*(self: NetworkService): string =
  result = $g_network_service_get_domain(cast[ptr NetworkService00](self.impl))

proc g_network_service_get_protocol(self: ptr NetworkService00): cstring {.
    importc, libprag.}

proc getProtocol*(self: NetworkService): string =
  result = $g_network_service_get_protocol(cast[ptr NetworkService00](self.impl))

proc protocol*(self: NetworkService): string =
  result = $g_network_service_get_protocol(cast[ptr NetworkService00](self.impl))

proc g_network_service_get_scheme(self: ptr NetworkService00): cstring {.
    importc, libprag.}

proc getScheme*(self: NetworkService): string =
  result = $g_network_service_get_scheme(cast[ptr NetworkService00](self.impl))

proc scheme*(self: NetworkService): string =
  result = $g_network_service_get_scheme(cast[ptr NetworkService00](self.impl))

proc g_network_service_get_service(self: ptr NetworkService00): cstring {.
    importc, libprag.}

proc getService*(self: NetworkService): string =
  result = $g_network_service_get_service(cast[ptr NetworkService00](self.impl))

proc service*(self: NetworkService): string =
  result = $g_network_service_get_service(cast[ptr NetworkService00](self.impl))

proc g_network_service_set_scheme(self: ptr NetworkService00; scheme: cstring) {.
    importc, libprag.}

proc setScheme*(self: NetworkService; scheme: cstring) =
  g_network_service_set_scheme(cast[ptr NetworkService00](self.impl), scheme)

proc `scheme=`*(self: NetworkService; scheme: cstring) =
  g_network_service_set_scheme(cast[ptr NetworkService00](self.impl), scheme)

type
  InetSocketAddress* = ref object of SocketAddress
  InetSocketAddress00* = object of SocketAddress00

proc g_inet_socket_address_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(InetSocketAddress()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc g_inet_socket_address_new(address: ptr InetAddress00; port: uint16): ptr InetSocketAddress00 {.
    importc, libprag.}

proc newInetSocketAddress*(address: InetAddress; port: uint16): InetSocketAddress =
  let gobj = g_inet_socket_address_new(cast[ptr InetAddress00](address.impl), port)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newInetSocketAddress*(tdesc: typedesc; address: InetAddress; port: uint16): tdesc =
  assert(result is InetSocketAddress)
  let gobj = g_inet_socket_address_new(cast[ptr InetAddress00](address.impl), port)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initInetSocketAddress*[T](result: var T; address: InetAddress; port: uint16) {.deprecated.} =
  assert(result is InetSocketAddress)
  let gobj = g_inet_socket_address_new(cast[ptr InetAddress00](address.impl), port)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_inet_socket_address_new_from_string(address: cstring; port: uint32): ptr InetSocketAddress00 {.
    importc, libprag.}

proc newInetSocketAddressFromString*(address: cstring; port: int): InetSocketAddress =
  let gobj = g_inet_socket_address_new_from_string(address, uint32(port))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newInetSocketAddressFromString*(tdesc: typedesc; address: cstring; port: int): tdesc =
  assert(result is InetSocketAddress)
  let gobj = g_inet_socket_address_new_from_string(address, uint32(port))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initInetSocketAddressFromString*[T](result: var T; address: cstring; port: int) {.deprecated.} =
  assert(result is InetSocketAddress)
  let gobj = g_inet_socket_address_new_from_string(address, uint32(port))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_inet_socket_address_get_address(self: ptr InetSocketAddress00): ptr InetAddress00 {.
    importc, libprag.}

proc getAddress*(self: InetSocketAddress): InetAddress =
  let gobj = g_inet_socket_address_get_address(cast[ptr InetSocketAddress00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc address*(self: InetSocketAddress): InetAddress =
  let gobj = g_inet_socket_address_get_address(cast[ptr InetSocketAddress00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_inet_socket_address_get_flowinfo(self: ptr InetSocketAddress00): uint32 {.
    importc, libprag.}

proc getFlowinfo*(self: InetSocketAddress): int =
  int(g_inet_socket_address_get_flowinfo(cast[ptr InetSocketAddress00](self.impl)))

proc flowinfo*(self: InetSocketAddress): int =
  int(g_inet_socket_address_get_flowinfo(cast[ptr InetSocketAddress00](self.impl)))

proc g_inet_socket_address_get_port(self: ptr InetSocketAddress00): uint16 {.
    importc, libprag.}

proc getPort*(self: InetSocketAddress): uint16 =
  g_inet_socket_address_get_port(cast[ptr InetSocketAddress00](self.impl))

proc port*(self: InetSocketAddress): uint16 =
  g_inet_socket_address_get_port(cast[ptr InetSocketAddress00](self.impl))

proc g_inet_socket_address_get_scope_id(self: ptr InetSocketAddress00): uint32 {.
    importc, libprag.}

proc getScopeId*(self: InetSocketAddress): int =
  int(g_inet_socket_address_get_scope_id(cast[ptr InetSocketAddress00](self.impl)))

proc scopeId*(self: InetSocketAddress): int =
  int(g_inet_socket_address_get_scope_id(cast[ptr InetSocketAddress00](self.impl)))

type
  ProxyAddress* = ref object of InetSocketAddress
  ProxyAddress00* = object of InetSocketAddress00

proc g_proxy_address_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(ProxyAddress()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc g_proxy_address_new(inetaddr: ptr InetAddress00; port: uint16; protocol: cstring;
    destHostname: cstring; destPort: uint16; username: cstring; password: cstring): ptr ProxyAddress00 {.
    importc, libprag.}

proc newProxyAddress*(inetaddr: InetAddress; port: uint16; protocol: cstring;
    destHostname: cstring; destPort: uint16; username: cstring = nil; password: cstring = nil): ProxyAddress =
  let gobj = g_proxy_address_new(cast[ptr InetAddress00](inetaddr.impl), port, protocol, destHostname, destPort, username, password)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newProxyAddress*(tdesc: typedesc; inetaddr: InetAddress; port: uint16; protocol: cstring;
    destHostname: cstring; destPort: uint16; username: cstring = nil; password: cstring = nil): tdesc =
  assert(result is ProxyAddress)
  let gobj = g_proxy_address_new(cast[ptr InetAddress00](inetaddr.impl), port, protocol, destHostname, destPort, username, password)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initProxyAddress*[T](result: var T; inetaddr: InetAddress; port: uint16; protocol: cstring;
    destHostname: cstring; destPort: uint16; username: cstring = nil; password: cstring = nil) {.deprecated.} =
  assert(result is ProxyAddress)
  let gobj = g_proxy_address_new(cast[ptr InetAddress00](inetaddr.impl), port, protocol, destHostname, destPort, username, password)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_proxy_address_get_destination_hostname(self: ptr ProxyAddress00): cstring {.
    importc, libprag.}

proc getDestinationHostname*(self: ProxyAddress): string =
  result = $g_proxy_address_get_destination_hostname(cast[ptr ProxyAddress00](self.impl))

proc destinationHostname*(self: ProxyAddress): string =
  result = $g_proxy_address_get_destination_hostname(cast[ptr ProxyAddress00](self.impl))

proc g_proxy_address_get_destination_port(self: ptr ProxyAddress00): uint16 {.
    importc, libprag.}

proc getDestinationPort*(self: ProxyAddress): uint16 =
  g_proxy_address_get_destination_port(cast[ptr ProxyAddress00](self.impl))

proc destinationPort*(self: ProxyAddress): uint16 =
  g_proxy_address_get_destination_port(cast[ptr ProxyAddress00](self.impl))

proc g_proxy_address_get_destination_protocol(self: ptr ProxyAddress00): cstring {.
    importc, libprag.}

proc getDestinationProtocol*(self: ProxyAddress): string =
  result = $g_proxy_address_get_destination_protocol(cast[ptr ProxyAddress00](self.impl))

proc destinationProtocol*(self: ProxyAddress): string =
  result = $g_proxy_address_get_destination_protocol(cast[ptr ProxyAddress00](self.impl))

proc g_proxy_address_get_password(self: ptr ProxyAddress00): cstring {.
    importc, libprag.}

proc getPassword*(self: ProxyAddress): string =
  result = $g_proxy_address_get_password(cast[ptr ProxyAddress00](self.impl))

proc password*(self: ProxyAddress): string =
  result = $g_proxy_address_get_password(cast[ptr ProxyAddress00](self.impl))

proc g_proxy_address_get_protocol(self: ptr ProxyAddress00): cstring {.
    importc, libprag.}

proc getProtocol*(self: ProxyAddress): string =
  result = $g_proxy_address_get_protocol(cast[ptr ProxyAddress00](self.impl))

proc protocol*(self: ProxyAddress): string =
  result = $g_proxy_address_get_protocol(cast[ptr ProxyAddress00](self.impl))

proc g_proxy_address_get_uri(self: ptr ProxyAddress00): cstring {.
    importc, libprag.}

proc getUri*(self: ProxyAddress): string =
  result = $g_proxy_address_get_uri(cast[ptr ProxyAddress00](self.impl))

proc uri*(self: ProxyAddress): string =
  result = $g_proxy_address_get_uri(cast[ptr ProxyAddress00](self.impl))

proc g_proxy_address_get_username(self: ptr ProxyAddress00): cstring {.
    importc, libprag.}

proc getUsername*(self: ProxyAddress): string =
  result = $g_proxy_address_get_username(cast[ptr ProxyAddress00](self.impl))

proc username*(self: ProxyAddress): string =
  result = $g_proxy_address_get_username(cast[ptr ProxyAddress00](self.impl))

type
  NetworkAddress* = ref object of gobject.Object
  NetworkAddress00* = object of gobject.Object00

proc g_network_address_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(NetworkAddress()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc g_network_address_new(hostname: cstring; port: uint16): ptr NetworkAddress00 {.
    importc, libprag.}

proc newNetworkAddress*(hostname: cstring; port: uint16): NetworkAddress =
  let gobj = g_network_address_new(hostname, port)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newNetworkAddress*(tdesc: typedesc; hostname: cstring; port: uint16): tdesc =
  assert(result is NetworkAddress)
  let gobj = g_network_address_new(hostname, port)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initNetworkAddress*[T](result: var T; hostname: cstring; port: uint16) {.deprecated.} =
  assert(result is NetworkAddress)
  let gobj = g_network_address_new(hostname, port)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_network_address_new_loopback(port: uint16): ptr NetworkAddress00 {.
    importc, libprag.}

proc newNetworkAddressLoopback*(port: uint16): NetworkAddress =
  let gobj = g_network_address_new_loopback(port)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newNetworkAddressLoopback*(tdesc: typedesc; port: uint16): tdesc =
  assert(result is NetworkAddress)
  let gobj = g_network_address_new_loopback(port)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initNetworkAddressLoopback*[T](result: var T; port: uint16) {.deprecated.} =
  assert(result is NetworkAddress)
  let gobj = g_network_address_new_loopback(port)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_network_address_parse(hostAndPort: cstring; defaultPort: uint16; error: ptr ptr glib.Error = nil): ptr NetworkAddress00 {.
    importc, libprag.}

proc parse*(hostAndPort: cstring; defaultPort: uint16): NetworkAddress =
  var gerror: ptr glib.Error
  let gobj = g_network_address_parse(hostAndPort, defaultPort, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_network_address_parse_uri(uri: cstring; defaultPort: uint16; error: ptr ptr glib.Error = nil): ptr NetworkAddress00 {.
    importc, libprag.}

proc parseUri*(uri: cstring; defaultPort: uint16): NetworkAddress =
  var gerror: ptr glib.Error
  let gobj = g_network_address_parse_uri(uri, defaultPort, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_network_address_get_hostname(self: ptr NetworkAddress00): cstring {.
    importc, libprag.}

proc getHostname*(self: NetworkAddress): string =
  result = $g_network_address_get_hostname(cast[ptr NetworkAddress00](self.impl))

proc hostname*(self: NetworkAddress): string =
  result = $g_network_address_get_hostname(cast[ptr NetworkAddress00](self.impl))

proc g_network_address_get_port(self: ptr NetworkAddress00): uint16 {.
    importc, libprag.}

proc getPort*(self: NetworkAddress): uint16 =
  g_network_address_get_port(cast[ptr NetworkAddress00](self.impl))

proc port*(self: NetworkAddress): uint16 =
  g_network_address_get_port(cast[ptr NetworkAddress00](self.impl))

proc g_network_address_get_scheme(self: ptr NetworkAddress00): cstring {.
    importc, libprag.}

proc getScheme*(self: NetworkAddress): string =
  result = $g_network_address_get_scheme(cast[ptr NetworkAddress00](self.impl))

proc scheme*(self: NetworkAddress): string =
  result = $g_network_address_get_scheme(cast[ptr NetworkAddress00](self.impl))

proc g_dtls_client_connection_new(baseSocket: ptr DatagramBased00; serverIdentity: ptr SocketConnectable00;
    error: ptr ptr glib.Error = nil): ptr DtlsClientConnection00 {.
    importc, libprag.}

proc newDtlsClientConnection*(baseSocket: DatagramBased | Socket; serverIdentity: SocketConnectable | SocketAddress | NativeSocketAddress | UnixSocketAddress | NetworkService | ProxyAddress | InetSocketAddress | NetworkAddress = nil): DtlsClientConnection =
  var gerror: ptr glib.Error
  let gobj = g_dtls_client_connection_new(cast[ptr DatagramBased00](baseSocket.impl), if serverIdentity.isNil: nil else: cast[ptr SocketConnectable00](serverIdentity.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_dtls_client_connection_set_server_identity(self: ptr DtlsClientConnection00;
    identity: ptr SocketConnectable00) {.
    importc, libprag.}

proc setServerIdentity*(self: DtlsClientConnection;
    identity: SocketConnectable | SocketAddress | NativeSocketAddress | UnixSocketAddress | NetworkService | ProxyAddress | InetSocketAddress | NetworkAddress) =
  g_dtls_client_connection_set_server_identity(cast[ptr DtlsClientConnection00](self.impl), cast[ptr SocketConnectable00](identity.impl))

proc `serverIdentity=`*(self: DtlsClientConnection;
    identity: SocketConnectable | SocketAddress | NativeSocketAddress | UnixSocketAddress | NetworkService | ProxyAddress | InetSocketAddress | NetworkAddress) =
  g_dtls_client_connection_set_server_identity(cast[ptr DtlsClientConnection00](self.impl), cast[ptr SocketConnectable00](identity.impl))

proc g_socket_connectable_enumerate(self: ptr SocketConnectable00): ptr SocketAddressEnumerator00 {.
    importc, libprag.}

proc enumerate*(self: SocketConnectable | SocketAddress | NativeSocketAddress | UnixSocketAddress | NetworkService | ProxyAddress | InetSocketAddress | NetworkAddress): SocketAddressEnumerator =
  let gobj = g_socket_connectable_enumerate(cast[ptr SocketConnectable00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_socket_connectable_proxy_enumerate(self: ptr SocketConnectable00): ptr SocketAddressEnumerator00 {.
    importc, libprag.}

proc proxyEnumerate*(self: SocketConnectable | SocketAddress | NativeSocketAddress | UnixSocketAddress | NetworkService | ProxyAddress | InetSocketAddress | NetworkAddress): SocketAddressEnumerator =
  let gobj = g_socket_connectable_proxy_enumerate(cast[ptr SocketConnectable00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_socket_connectable_to_string(self: ptr SocketConnectable00): cstring {.
    importc, libprag.}

proc toString*(self: SocketConnectable | SocketAddress | NativeSocketAddress | UnixSocketAddress | NetworkService | ProxyAddress | InetSocketAddress | NetworkAddress): string =
  let resul0 = g_socket_connectable_to_string(cast[ptr SocketConnectable00](self.impl))
  result = $resul0
  cogfree(resul0)

type
  UnixSocketAddressType* {.size: sizeof(cint), pure.} = enum
    invalid = 0
    anonymous = 1
    path = 2
    abstract = 3
    abstractPadded = 4

proc g_unix_socket_address_new_with_type(path: ptr int8; pathLen: int32;
    `type`: UnixSocketAddressType): ptr UnixSocketAddress00 {.
    importc, libprag.}

proc newUnixSocketAddressWithType*(path: ptr int8; pathLen: int; `type`: UnixSocketAddressType): UnixSocketAddress =
  let gobj = g_unix_socket_address_new_with_type(path, int32(pathLen), `type`)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newUnixSocketAddressWithType*(tdesc: typedesc; path: ptr int8; pathLen: int; `type`: UnixSocketAddressType): tdesc =
  assert(result is UnixSocketAddress)
  let gobj = g_unix_socket_address_new_with_type(path, int32(pathLen), `type`)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initUnixSocketAddressWithType*[T](result: var T; path: ptr int8; pathLen: int; `type`: UnixSocketAddressType) {.deprecated.} =
  assert(result is UnixSocketAddress)
  let gobj = g_unix_socket_address_new_with_type(path, int32(pathLen), `type`)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_unix_socket_address_get_address_type(self: ptr UnixSocketAddress00): UnixSocketAddressType {.
    importc, libprag.}

proc getAddressType*(self: UnixSocketAddress): UnixSocketAddressType =
  g_unix_socket_address_get_address_type(cast[ptr UnixSocketAddress00](self.impl))

proc addressType*(self: UnixSocketAddress): UnixSocketAddressType =
  g_unix_socket_address_get_address_type(cast[ptr UnixSocketAddress00](self.impl))

type
  TlsCertificateFlags* {.size: sizeof(cint), pure.} = enum
    unknownCa = 1
    badIdentity = 2
    notActivated = 4
    expired = 8
    revoked = 16
    insecure = 32
    genericError = 64
    validateAll = 127

proc g_dtls_client_connection_get_validation_flags(self: ptr DtlsClientConnection00): TlsCertificateFlags {.
    importc, libprag.}

proc getValidationFlags*(self: DtlsClientConnection): TlsCertificateFlags =
  g_dtls_client_connection_get_validation_flags(cast[ptr DtlsClientConnection00](self.impl))

proc validationFlags*(self: DtlsClientConnection): TlsCertificateFlags =
  g_dtls_client_connection_get_validation_flags(cast[ptr DtlsClientConnection00](self.impl))

proc g_dtls_client_connection_set_validation_flags(self: ptr DtlsClientConnection00;
    flags: TlsCertificateFlags) {.
    importc, libprag.}

proc setValidationFlags*(self: DtlsClientConnection;
    flags: TlsCertificateFlags) =
  g_dtls_client_connection_set_validation_flags(cast[ptr DtlsClientConnection00](self.impl), flags)

proc `validationFlags=`*(self: DtlsClientConnection;
    flags: TlsCertificateFlags) =
  g_dtls_client_connection_set_validation_flags(cast[ptr DtlsClientConnection00](self.impl), flags)

type
  TlsCertificate* = ref object of gobject.Object
  TlsCertificate00* = object of gobject.Object00

proc g_tls_certificate_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(TlsCertificate()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc g_tls_certificate_new_from_file(file: cstring; error: ptr ptr glib.Error = nil): ptr TlsCertificate00 {.
    importc, libprag.}

proc newTlsCertificateFromFile*(file: cstring): TlsCertificate =
  var gerror: ptr glib.Error
  let gobj = g_tls_certificate_new_from_file(file, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newTlsCertificateFromFile*(tdesc: typedesc; file: cstring): tdesc =
  var gerror: ptr glib.Error
  assert(result is TlsCertificate)
  let gobj = g_tls_certificate_new_from_file(file, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initTlsCertificateFromFile*[T](result: var T; file: cstring) {.deprecated.} =
  var gerror: ptr glib.Error
  assert(result is TlsCertificate)
  let gobj = g_tls_certificate_new_from_file(file, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_tls_certificate_new_from_files(certFile: cstring; keyFile: cstring;
    error: ptr ptr glib.Error = nil): ptr TlsCertificate00 {.
    importc, libprag.}

proc newTlsCertificateFromFiles*(certFile: cstring; keyFile: cstring): TlsCertificate =
  var gerror: ptr glib.Error
  let gobj = g_tls_certificate_new_from_files(certFile, keyFile, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newTlsCertificateFromFiles*(tdesc: typedesc; certFile: cstring; keyFile: cstring): tdesc =
  var gerror: ptr glib.Error
  assert(result is TlsCertificate)
  let gobj = g_tls_certificate_new_from_files(certFile, keyFile, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initTlsCertificateFromFiles*[T](result: var T; certFile: cstring; keyFile: cstring) {.deprecated.} =
  var gerror: ptr glib.Error
  assert(result is TlsCertificate)
  let gobj = g_tls_certificate_new_from_files(certFile, keyFile, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_tls_certificate_new_from_pem(data: cstring; length: int64; error: ptr ptr glib.Error = nil): ptr TlsCertificate00 {.
    importc, libprag.}

proc newTlsCertificateFromPem*(data: cstring; length: int64): TlsCertificate =
  var gerror: ptr glib.Error
  let gobj = g_tls_certificate_new_from_pem(data, length, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newTlsCertificateFromPem*(tdesc: typedesc; data: cstring; length: int64): tdesc =
  var gerror: ptr glib.Error
  assert(result is TlsCertificate)
  let gobj = g_tls_certificate_new_from_pem(data, length, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initTlsCertificateFromPem*[T](result: var T; data: cstring; length: int64) {.deprecated.} =
  var gerror: ptr glib.Error
  assert(result is TlsCertificate)
  let gobj = g_tls_certificate_new_from_pem(data, length, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_tls_certificate_list_new_from_file(file: cstring; error: ptr ptr glib.Error = nil): ptr glib.List {.
    importc, libprag.}

proc listNewFromFile*(file: cstring): seq[TlsCertificate] =
  var gerror: ptr glib.Error
  let resul0 = g_tls_certificate_list_new_from_file(file, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = glistObjects2seq(TlsCertificate, resul0, true)
  g_list_free(resul0)

proc g_tls_certificate_get_issuer(self: ptr TlsCertificate00): ptr TlsCertificate00 {.
    importc, libprag.}

proc getIssuer*(self: TlsCertificate): TlsCertificate =
  let gobj = g_tls_certificate_get_issuer(cast[ptr TlsCertificate00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc issuer*(self: TlsCertificate): TlsCertificate =
  let gobj = g_tls_certificate_get_issuer(cast[ptr TlsCertificate00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_tls_certificate_is_same(self: ptr TlsCertificate00; certTwo: ptr TlsCertificate00): gboolean {.
    importc, libprag.}

proc isSame*(self: TlsCertificate; certTwo: TlsCertificate): bool =
  toBool(g_tls_certificate_is_same(cast[ptr TlsCertificate00](self.impl), cast[ptr TlsCertificate00](certTwo.impl)))

proc g_tls_certificate_verify(self: ptr TlsCertificate00; identity: ptr SocketConnectable00;
    trustedCa: ptr TlsCertificate00): TlsCertificateFlags {.
    importc, libprag.}

proc verify*(self: TlsCertificate; identity: SocketConnectable | SocketAddress | NativeSocketAddress | UnixSocketAddress | NetworkService | ProxyAddress | InetSocketAddress | NetworkAddress = nil;
    trustedCa: TlsCertificate = nil): TlsCertificateFlags =
  g_tls_certificate_verify(cast[ptr TlsCertificate00](self.impl), if identity.isNil: nil else: cast[ptr SocketConnectable00](identity.impl), if trustedCa.isNil: nil else: cast[ptr TlsCertificate00](trustedCa.impl))

type
  DtlsConnection00* = object of gobject.Object00
  DtlsConnection* = ref object of gobject.Object

proc scAcceptCertificate*(self: DtlsConnection;  p: proc (self: ptr DtlsConnection00; peerCert: ptr TlsCertificate00; errors: TlsCertificateFlags; xdata: pointer): gboolean {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "accept-certificate", cast[GCallback](p), xdata, nil, cf)

proc g_dtls_connection_close(self: ptr DtlsConnection00; cancellable: ptr Cancellable00;
    error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc close*(self: DtlsConnection; cancellable: Cancellable = nil): bool =
  var gerror: ptr glib.Error
  let resul0 = g_dtls_connection_close(cast[ptr DtlsConnection00](self.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_dtls_connection_close_async(self: ptr DtlsConnection00; ioPriority: int32;
    cancellable: ptr Cancellable00; callback: AsyncReadyCallback; userData: pointer) {.
    importc, libprag.}

proc closeAsync*(self: DtlsConnection; ioPriority: int;
    cancellable: Cancellable = nil; callback: AsyncReadyCallback; userData: pointer) =
  g_dtls_connection_close_async(cast[ptr DtlsConnection00](self.impl), int32(ioPriority), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_dtls_connection_close_finish(self: ptr DtlsConnection00; resu: ptr AsyncResult00;
    error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc closeFinish*(self: DtlsConnection; resu: AsyncResult | SimpleAsyncResult | Task): bool =
  var gerror: ptr glib.Error
  let resul0 = g_dtls_connection_close_finish(cast[ptr DtlsConnection00](self.impl), cast[ptr AsyncResult00](resu.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_dtls_connection_emit_accept_certificate(self: ptr DtlsConnection00;
    peerCert: ptr TlsCertificate00; errors: TlsCertificateFlags): gboolean {.
    importc, libprag.}

proc emitAcceptCertificate*(self: DtlsConnection; peerCert: TlsCertificate;
    errors: TlsCertificateFlags): bool =
  toBool(g_dtls_connection_emit_accept_certificate(cast[ptr DtlsConnection00](self.impl), cast[ptr TlsCertificate00](peerCert.impl), errors))

proc g_dtls_connection_get_certificate(self: ptr DtlsConnection00): ptr TlsCertificate00 {.
    importc, libprag.}

proc getCertificate*(self: DtlsConnection): TlsCertificate =
  let gobj = g_dtls_connection_get_certificate(cast[ptr DtlsConnection00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc certificate*(self: DtlsConnection): TlsCertificate =
  let gobj = g_dtls_connection_get_certificate(cast[ptr DtlsConnection00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_dtls_connection_get_negotiated_protocol(self: ptr DtlsConnection00): cstring {.
    importc, libprag.}

proc getNegotiatedProtocol*(self: DtlsConnection): string =
  let resul0 = g_dtls_connection_get_negotiated_protocol(cast[ptr DtlsConnection00](self.impl))
  if resul0.isNil:
    return
  result = $resul0

proc negotiatedProtocol*(self: DtlsConnection): string =
  let resul0 = g_dtls_connection_get_negotiated_protocol(cast[ptr DtlsConnection00](self.impl))
  if resul0.isNil:
    return
  result = $resul0

proc g_dtls_connection_get_peer_certificate(self: ptr DtlsConnection00): ptr TlsCertificate00 {.
    importc, libprag.}

proc getPeerCertificate*(self: DtlsConnection): TlsCertificate =
  let gobj = g_dtls_connection_get_peer_certificate(cast[ptr DtlsConnection00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc peerCertificate*(self: DtlsConnection): TlsCertificate =
  let gobj = g_dtls_connection_get_peer_certificate(cast[ptr DtlsConnection00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_dtls_connection_get_peer_certificate_errors(self: ptr DtlsConnection00): TlsCertificateFlags {.
    importc, libprag.}

proc getPeerCertificateErrors*(self: DtlsConnection): TlsCertificateFlags =
  g_dtls_connection_get_peer_certificate_errors(cast[ptr DtlsConnection00](self.impl))

proc peerCertificateErrors*(self: DtlsConnection): TlsCertificateFlags =
  g_dtls_connection_get_peer_certificate_errors(cast[ptr DtlsConnection00](self.impl))

proc g_dtls_connection_get_require_close_notify(self: ptr DtlsConnection00): gboolean {.
    importc, libprag.}

proc getRequireCloseNotify*(self: DtlsConnection): bool =
  toBool(g_dtls_connection_get_require_close_notify(cast[ptr DtlsConnection00](self.impl)))

proc requireCloseNotify*(self: DtlsConnection): bool =
  toBool(g_dtls_connection_get_require_close_notify(cast[ptr DtlsConnection00](self.impl)))

proc g_dtls_connection_handshake(self: ptr DtlsConnection00; cancellable: ptr Cancellable00;
    error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc handshake*(self: DtlsConnection; cancellable: Cancellable = nil): bool =
  var gerror: ptr glib.Error
  let resul0 = g_dtls_connection_handshake(cast[ptr DtlsConnection00](self.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_dtls_connection_handshake_async(self: ptr DtlsConnection00; ioPriority: int32;
    cancellable: ptr Cancellable00; callback: AsyncReadyCallback; userData: pointer) {.
    importc, libprag.}

proc handshakeAsync*(self: DtlsConnection; ioPriority: int;
    cancellable: Cancellable = nil; callback: AsyncReadyCallback; userData: pointer) =
  g_dtls_connection_handshake_async(cast[ptr DtlsConnection00](self.impl), int32(ioPriority), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_dtls_connection_handshake_finish(self: ptr DtlsConnection00; resu: ptr AsyncResult00;
    error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc handshakeFinish*(self: DtlsConnection; resu: AsyncResult | SimpleAsyncResult | Task): bool =
  var gerror: ptr glib.Error
  let resul0 = g_dtls_connection_handshake_finish(cast[ptr DtlsConnection00](self.impl), cast[ptr AsyncResult00](resu.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_dtls_connection_set_advertised_protocols(self: ptr DtlsConnection00;
    protocols: ptr cstring) {.
    importc, libprag.}

proc setAdvertisedProtocols*(self: DtlsConnection; protocols: varargs[string, `$`]) =
  var fs469n23x: array[256, pointer]
  var fs469n23: cstringArray = cast[cstringArray](addr fs469n23x)
  g_dtls_connection_set_advertised_protocols(cast[ptr DtlsConnection00](self.impl), seq2CstringArray(protocols, fs469n23))

proc `advertisedProtocols=`*(self: DtlsConnection; protocols: varargs[string, `$`]) =
  var fs469n23x: array[256, pointer]
  var fs469n23: cstringArray = cast[cstringArray](addr fs469n23x)
  g_dtls_connection_set_advertised_protocols(cast[ptr DtlsConnection00](self.impl), seq2CstringArray(protocols, fs469n23))

proc g_dtls_connection_set_certificate(self: ptr DtlsConnection00; certificate: ptr TlsCertificate00) {.
    importc, libprag.}

proc setCertificate*(self: DtlsConnection; certificate: TlsCertificate) =
  g_dtls_connection_set_certificate(cast[ptr DtlsConnection00](self.impl), cast[ptr TlsCertificate00](certificate.impl))

proc `certificate=`*(self: DtlsConnection; certificate: TlsCertificate) =
  g_dtls_connection_set_certificate(cast[ptr DtlsConnection00](self.impl), cast[ptr TlsCertificate00](certificate.impl))

proc g_dtls_connection_set_require_close_notify(self: ptr DtlsConnection00;
    requireCloseNotify: gboolean) {.
    importc, libprag.}

proc setRequireCloseNotify*(self: DtlsConnection; requireCloseNotify: bool = true) =
  g_dtls_connection_set_require_close_notify(cast[ptr DtlsConnection00](self.impl), gboolean(requireCloseNotify))

proc `requireCloseNotify=`*(self: DtlsConnection; requireCloseNotify: bool) =
  g_dtls_connection_set_require_close_notify(cast[ptr DtlsConnection00](self.impl), gboolean(requireCloseNotify))

proc g_dtls_connection_shutdown(self: ptr DtlsConnection00; shutdownRead: gboolean;
    shutdownWrite: gboolean; cancellable: ptr Cancellable00; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc shutdown*(self: DtlsConnection; shutdownRead: bool;
    shutdownWrite: bool; cancellable: Cancellable = nil): bool =
  var gerror: ptr glib.Error
  let resul0 = g_dtls_connection_shutdown(cast[ptr DtlsConnection00](self.impl), gboolean(shutdownRead), gboolean(shutdownWrite), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_dtls_connection_shutdown_async(self: ptr DtlsConnection00; shutdownRead: gboolean;
    shutdownWrite: gboolean; ioPriority: int32; cancellable: ptr Cancellable00;
    callback: AsyncReadyCallback; userData: pointer) {.
    importc, libprag.}

proc shutdownAsync*(self: DtlsConnection; shutdownRead: bool;
    shutdownWrite: bool; ioPriority: int; cancellable: Cancellable = nil; callback: AsyncReadyCallback;
    userData: pointer) =
  g_dtls_connection_shutdown_async(cast[ptr DtlsConnection00](self.impl), gboolean(shutdownRead), gboolean(shutdownWrite), int32(ioPriority), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_dtls_connection_shutdown_finish(self: ptr DtlsConnection00; resu: ptr AsyncResult00;
    error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc shutdownFinish*(self: DtlsConnection; resu: AsyncResult | SimpleAsyncResult | Task): bool =
  var gerror: ptr glib.Error
  let resul0 = g_dtls_connection_shutdown_finish(cast[ptr DtlsConnection00](self.impl), cast[ptr AsyncResult00](resu.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

type
  TlsChannelBindingType* {.size: sizeof(cint), pure.} = enum
    unique = 0
    serverEndPoint = 1

proc g_dtls_connection_get_channel_binding_data(self: ptr DtlsConnection00;
    `type`: TlsChannelBindingType; data: var ptr ByteArray00; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc getChannelBindingData*(self: DtlsConnection; `type`: TlsChannelBindingType;
    data: var ptr ByteArray00 = cast[var ptr ByteArray00](nil)): bool =
  var gerror: ptr glib.Error
  let resul0 = g_dtls_connection_get_channel_binding_data(cast[ptr DtlsConnection00](self.impl), `type`, data, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

type
  TlsDatabase* = ref object of gobject.Object
  TlsDatabase00* = object of gobject.Object00

proc g_tls_database_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(TlsDatabase()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc g_tls_database_create_certificate_handle(self: ptr TlsDatabase00; certificate: ptr TlsCertificate00): cstring {.
    importc, libprag.}

proc createCertificateHandle*(self: TlsDatabase; certificate: TlsCertificate): string =
  let resul0 = g_tls_database_create_certificate_handle(cast[ptr TlsDatabase00](self.impl), cast[ptr TlsCertificate00](certificate.impl))
  if resul0.isNil:
    return
  result = $resul0
  cogfree(resul0)

proc g_tls_database_lookup_certificate_for_handle_finish(self: ptr TlsDatabase00;
    resu: ptr AsyncResult00; error: ptr ptr glib.Error = nil): ptr TlsCertificate00 {.
    importc, libprag.}

proc lookupCertificateForHandleFinish*(self: TlsDatabase;
    resu: AsyncResult | SimpleAsyncResult | Task): TlsCertificate =
  var gerror: ptr glib.Error
  let gobj = g_tls_database_lookup_certificate_for_handle_finish(cast[ptr TlsDatabase00](self.impl), cast[ptr AsyncResult00](resu.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_tls_database_lookup_certificate_issuer_finish(self: ptr TlsDatabase00;
    resu: ptr AsyncResult00; error: ptr ptr glib.Error = nil): ptr TlsCertificate00 {.
    importc, libprag.}

proc lookupCertificateIssuerFinish*(self: TlsDatabase; resu: AsyncResult | SimpleAsyncResult | Task): TlsCertificate =
  var gerror: ptr glib.Error
  let gobj = g_tls_database_lookup_certificate_issuer_finish(cast[ptr TlsDatabase00](self.impl), cast[ptr AsyncResult00](resu.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_tls_database_lookup_certificates_issued_by_finish(self: ptr TlsDatabase00;
    resu: ptr AsyncResult00; error: ptr ptr glib.Error = nil): ptr glib.List {.
    importc, libprag.}

proc lookupCertificatesIssuedByFinish*(self: TlsDatabase;
    resu: AsyncResult | SimpleAsyncResult | Task): seq[TlsCertificate] =
  var gerror: ptr glib.Error
  let resul0 = g_tls_database_lookup_certificates_issued_by_finish(cast[ptr TlsDatabase00](self.impl), cast[ptr AsyncResult00](resu.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = glistObjects2seq(TlsCertificate, resul0, true)
  g_list_free(resul0)

proc g_tls_database_verify_chain_finish(self: ptr TlsDatabase00; resu: ptr AsyncResult00;
    error: ptr ptr glib.Error = nil): TlsCertificateFlags {.
    importc, libprag.}

proc verifyChainFinish*(self: TlsDatabase; resu: AsyncResult | SimpleAsyncResult | Task): TlsCertificateFlags =
  var gerror: ptr glib.Error
  let resul0 = g_tls_database_verify_chain_finish(cast[ptr TlsDatabase00](self.impl), cast[ptr AsyncResult00](resu.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = resul0

proc g_dtls_connection_get_database(self: ptr DtlsConnection00): ptr TlsDatabase00 {.
    importc, libprag.}

proc getDatabase*(self: DtlsConnection): TlsDatabase =
  let gobj = g_dtls_connection_get_database(cast[ptr DtlsConnection00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc database*(self: DtlsConnection): TlsDatabase =
  let gobj = g_dtls_connection_get_database(cast[ptr DtlsConnection00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_dtls_connection_set_database(self: ptr DtlsConnection00; database: ptr TlsDatabase00) {.
    importc, libprag.}

proc setDatabase*(self: DtlsConnection; database: TlsDatabase = nil) =
  g_dtls_connection_set_database(cast[ptr DtlsConnection00](self.impl), if database.isNil: nil else: cast[ptr TlsDatabase00](database.impl))

proc `database=`*(self: DtlsConnection; database: TlsDatabase = nil) =
  g_dtls_connection_set_database(cast[ptr DtlsConnection00](self.impl), if database.isNil: nil else: cast[ptr TlsDatabase00](database.impl))

type
  TlsInteraction* = ref object of gobject.Object
  TlsInteraction00* = object of gobject.Object00

proc g_tls_interaction_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(TlsInteraction()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc g_dtls_connection_get_interaction(self: ptr DtlsConnection00): ptr TlsInteraction00 {.
    importc, libprag.}

proc getInteraction*(self: DtlsConnection): TlsInteraction =
  let gobj = g_dtls_connection_get_interaction(cast[ptr DtlsConnection00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc interaction*(self: DtlsConnection): TlsInteraction =
  let gobj = g_dtls_connection_get_interaction(cast[ptr DtlsConnection00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_dtls_connection_set_interaction(self: ptr DtlsConnection00; interaction: ptr TlsInteraction00) {.
    importc, libprag.}

proc setInteraction*(self: DtlsConnection; interaction: TlsInteraction = nil) =
  g_dtls_connection_set_interaction(cast[ptr DtlsConnection00](self.impl), if interaction.isNil: nil else: cast[ptr TlsInteraction00](interaction.impl))

proc `interaction=`*(self: DtlsConnection; interaction: TlsInteraction = nil) =
  g_dtls_connection_set_interaction(cast[ptr DtlsConnection00](self.impl), if interaction.isNil: nil else: cast[ptr TlsInteraction00](interaction.impl))

type
  TlsDatabaseLookupFlag* {.size: sizeof(cint), pure.} = enum
    keypair = 0

  TlsDatabaseLookupFlags* {.size: sizeof(cint).} = set[TlsDatabaseLookupFlag]

const
  TlsDatabaseLookupFlagsNone* = TlsDatabaseLookupFlags({})
proc none*(t: typedesc[TlsDatabaseLookupFlags]): TlsDatabaseLookupFlags = TlsDatabaseLookupFlags({})

proc g_tls_database_lookup_certificate_for_handle(self: ptr TlsDatabase00;
    handle: cstring; interaction: ptr TlsInteraction00; flags: TlsDatabaseLookupFlags;
    cancellable: ptr Cancellable00; error: ptr ptr glib.Error = nil): ptr TlsCertificate00 {.
    importc, libprag.}

proc lookupCertificateForHandle*(self: TlsDatabase; handle: cstring;
    interaction: TlsInteraction = nil; flags: TlsDatabaseLookupFlags; cancellable: Cancellable = nil): TlsCertificate =
  var gerror: ptr glib.Error
  let gobj = g_tls_database_lookup_certificate_for_handle(cast[ptr TlsDatabase00](self.impl), handle, if interaction.isNil: nil else: cast[ptr TlsInteraction00](interaction.impl), flags, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_tls_database_lookup_certificate_for_handle_async(self: ptr TlsDatabase00;
    handle: cstring; interaction: ptr TlsInteraction00; flags: TlsDatabaseLookupFlags;
    cancellable: ptr Cancellable00; callback: AsyncReadyCallback; userData: pointer) {.
    importc, libprag.}

proc lookupCertificateForHandleAsync*(self: TlsDatabase;
    handle: cstring; interaction: TlsInteraction = nil; flags: TlsDatabaseLookupFlags;
    cancellable: Cancellable = nil; callback: AsyncReadyCallback; userData: pointer) =
  g_tls_database_lookup_certificate_for_handle_async(cast[ptr TlsDatabase00](self.impl), handle, if interaction.isNil: nil else: cast[ptr TlsInteraction00](interaction.impl), flags, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_tls_database_lookup_certificate_issuer(self: ptr TlsDatabase00; certificate: ptr TlsCertificate00;
    interaction: ptr TlsInteraction00; flags: TlsDatabaseLookupFlags; cancellable: ptr Cancellable00;
    error: ptr ptr glib.Error = nil): ptr TlsCertificate00 {.
    importc, libprag.}

proc lookupCertificateIssuer*(self: TlsDatabase; certificate: TlsCertificate;
    interaction: TlsInteraction = nil; flags: TlsDatabaseLookupFlags; cancellable: Cancellable = nil): TlsCertificate =
  var gerror: ptr glib.Error
  let gobj = g_tls_database_lookup_certificate_issuer(cast[ptr TlsDatabase00](self.impl), cast[ptr TlsCertificate00](certificate.impl), if interaction.isNil: nil else: cast[ptr TlsInteraction00](interaction.impl), flags, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_tls_database_lookup_certificate_issuer_async(self: ptr TlsDatabase00;
    certificate: ptr TlsCertificate00; interaction: ptr TlsInteraction00; flags: TlsDatabaseLookupFlags;
    cancellable: ptr Cancellable00; callback: AsyncReadyCallback; userData: pointer) {.
    importc, libprag.}

proc lookupCertificateIssuerAsync*(self: TlsDatabase; certificate: TlsCertificate;
    interaction: TlsInteraction = nil; flags: TlsDatabaseLookupFlags; cancellable: Cancellable = nil;
    callback: AsyncReadyCallback; userData: pointer) =
  g_tls_database_lookup_certificate_issuer_async(cast[ptr TlsDatabase00](self.impl), cast[ptr TlsCertificate00](certificate.impl), if interaction.isNil: nil else: cast[ptr TlsInteraction00](interaction.impl), flags, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_tls_database_lookup_certificates_issued_by(self: ptr TlsDatabase00;
    issuerRawDn: ptr ByteArray00; interaction: ptr TlsInteraction00; flags: TlsDatabaseLookupFlags;
    cancellable: ptr Cancellable00; error: ptr ptr glib.Error = nil): ptr glib.List {.
    importc, libprag.}

proc lookupCertificatesIssuedBy*(self: TlsDatabase; issuerRawDn: ptr ByteArray00;
    interaction: TlsInteraction = nil; flags: TlsDatabaseLookupFlags; cancellable: Cancellable = nil): seq[TlsCertificate] =
  var gerror: ptr glib.Error
  let resul0 = g_tls_database_lookup_certificates_issued_by(cast[ptr TlsDatabase00](self.impl), issuerRawDn, if interaction.isNil: nil else: cast[ptr TlsInteraction00](interaction.impl), flags, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = glistObjects2seq(TlsCertificate, resul0, true)
  g_list_free(resul0)

proc g_tls_database_lookup_certificates_issued_by_async(self: ptr TlsDatabase00;
    issuerRawDn: ptr ByteArray00; interaction: ptr TlsInteraction00; flags: TlsDatabaseLookupFlags;
    cancellable: ptr Cancellable00; callback: AsyncReadyCallback; userData: pointer) {.
    importc, libprag.}

proc lookupCertificatesIssuedByAsync*(self: TlsDatabase;
    issuerRawDn: ptr ByteArray00; interaction: TlsInteraction = nil; flags: TlsDatabaseLookupFlags;
    cancellable: Cancellable = nil; callback: AsyncReadyCallback; userData: pointer) =
  g_tls_database_lookup_certificates_issued_by_async(cast[ptr TlsDatabase00](self.impl), issuerRawDn, if interaction.isNil: nil else: cast[ptr TlsInteraction00](interaction.impl), flags, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

type
  TlsDatabaseVerifyFlags* {.size: sizeof(cint), pure.} = enum
    none = 0

proc g_tls_database_verify_chain(self: ptr TlsDatabase00; chain: ptr TlsCertificate00;
    purpose: cstring; identity: ptr SocketConnectable00; interaction: ptr TlsInteraction00;
    flags: TlsDatabaseVerifyFlags; cancellable: ptr Cancellable00; error: ptr ptr glib.Error = nil): TlsCertificateFlags {.
    importc, libprag.}

proc verifyChain*(self: TlsDatabase; chain: TlsCertificate;
    purpose: cstring; identity: SocketConnectable | SocketAddress | NativeSocketAddress | UnixSocketAddress | NetworkService | ProxyAddress | InetSocketAddress | NetworkAddress = nil;
    interaction: TlsInteraction = nil; flags: TlsDatabaseVerifyFlags; cancellable: Cancellable = nil): TlsCertificateFlags =
  var gerror: ptr glib.Error
  let resul0 = g_tls_database_verify_chain(cast[ptr TlsDatabase00](self.impl), cast[ptr TlsCertificate00](chain.impl), purpose, if identity.isNil: nil else: cast[ptr SocketConnectable00](identity.impl), if interaction.isNil: nil else: cast[ptr TlsInteraction00](interaction.impl), flags, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = resul0

proc g_tls_database_verify_chain_async(self: ptr TlsDatabase00; chain: ptr TlsCertificate00;
    purpose: cstring; identity: ptr SocketConnectable00; interaction: ptr TlsInteraction00;
    flags: TlsDatabaseVerifyFlags; cancellable: ptr Cancellable00; callback: AsyncReadyCallback;
    userData: pointer) {.
    importc, libprag.}

proc verifyChainAsync*(self: TlsDatabase; chain: TlsCertificate;
    purpose: cstring; identity: SocketConnectable | SocketAddress | NativeSocketAddress | UnixSocketAddress | NetworkService | ProxyAddress | InetSocketAddress | NetworkAddress = nil;
    interaction: TlsInteraction = nil; flags: TlsDatabaseVerifyFlags; cancellable: Cancellable = nil;
    callback: AsyncReadyCallback; userData: pointer) =
  g_tls_database_verify_chain_async(cast[ptr TlsDatabase00](self.impl), cast[ptr TlsCertificate00](chain.impl), purpose, if identity.isNil: nil else: cast[ptr SocketConnectable00](identity.impl), if interaction.isNil: nil else: cast[ptr TlsInteraction00](interaction.impl), flags, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

type
  TlsPassword* = ref object of gobject.Object
  TlsPassword00* = object of gobject.Object00

proc g_tls_password_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(TlsPassword()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc g_tls_password_get_description(self: ptr TlsPassword00): cstring {.
    importc, libprag.}

proc getDescription*(self: TlsPassword): string =
  result = $g_tls_password_get_description(cast[ptr TlsPassword00](self.impl))

proc description*(self: TlsPassword): string =
  result = $g_tls_password_get_description(cast[ptr TlsPassword00](self.impl))

proc g_tls_password_get_value(self: ptr TlsPassword00; length: ptr uint64): ptr uint8 {.
    importc, libprag.}

proc getValue*(self: TlsPassword; length: ptr uint64): ptr uint8 =
  g_tls_password_get_value(cast[ptr TlsPassword00](self.impl), length)

proc g_tls_password_get_warning(self: ptr TlsPassword00): cstring {.
    importc, libprag.}

proc getWarning*(self: TlsPassword): string =
  result = $g_tls_password_get_warning(cast[ptr TlsPassword00](self.impl))

proc warning*(self: TlsPassword): string =
  result = $g_tls_password_get_warning(cast[ptr TlsPassword00](self.impl))

proc g_tls_password_set_description(self: ptr TlsPassword00; description: cstring) {.
    importc, libprag.}

proc setDescription*(self: TlsPassword; description: cstring) =
  g_tls_password_set_description(cast[ptr TlsPassword00](self.impl), description)

proc `description=`*(self: TlsPassword; description: cstring) =
  g_tls_password_set_description(cast[ptr TlsPassword00](self.impl), description)

proc g_tls_password_set_value(self: ptr TlsPassword00; value: ptr uint8;
    length: int64) {.
    importc, libprag.}

proc setValue*(self: TlsPassword; value: seq[uint8] | string) =
  let length = int64(value.len)
  g_tls_password_set_value(cast[ptr TlsPassword00](self.impl), cast[ptr uint8](unsafeaddr(value[0])), length)

proc g_tls_password_set_value_full(self: ptr TlsPassword00; value: ptr uint8;
    length: int64; destroy: DestroyNotify) {.
    importc, libprag.}

proc setValueFull*(self: TlsPassword; value: seq[uint8] | string;
    destroy: DestroyNotify) =
  let length = int64(value.len)
  g_tls_password_set_value_full(cast[ptr TlsPassword00](self.impl), cast[ptr uint8](unsafeaddr(value[0])), length, destroy)

proc g_tls_password_set_warning(self: ptr TlsPassword00; warning: cstring) {.
    importc, libprag.}

proc setWarning*(self: TlsPassword; warning: cstring) =
  g_tls_password_set_warning(cast[ptr TlsPassword00](self.impl), warning)

proc `warning=`*(self: TlsPassword; warning: cstring) =
  g_tls_password_set_warning(cast[ptr TlsPassword00](self.impl), warning)

proc g_tls_interaction_ask_password_async(self: ptr TlsInteraction00; password: ptr TlsPassword00;
    cancellable: ptr Cancellable00; callback: AsyncReadyCallback; userData: pointer) {.
    importc, libprag.}

proc askPasswordAsync*(self: TlsInteraction; password: TlsPassword;
    cancellable: Cancellable = nil; callback: AsyncReadyCallback; userData: pointer) =
  g_tls_interaction_ask_password_async(cast[ptr TlsInteraction00](self.impl), cast[ptr TlsPassword00](password.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

type
  TlsPasswordFlag* {.size: sizeof(cint), pure.} = enum
    retry = 1
    manyTries = 2
    finalTry = 3

  TlsPasswordFlags* {.size: sizeof(cint).} = set[TlsPasswordFlag]

const
  TlsPasswordFlagsNone* = TlsPasswordFlags({})
proc none*(t: typedesc[TlsPasswordFlags]): TlsPasswordFlags = TlsPasswordFlags({})

proc g_tls_password_new(flags: TlsPasswordFlags; description: cstring): ptr TlsPassword00 {.
    importc, libprag.}

proc newTlsPassword*(flags: TlsPasswordFlags; description: cstring): TlsPassword =
  let gobj = g_tls_password_new(flags, description)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newTlsPassword*(tdesc: typedesc; flags: TlsPasswordFlags; description: cstring): tdesc =
  assert(result is TlsPassword)
  let gobj = g_tls_password_new(flags, description)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initTlsPassword*[T](result: var T; flags: TlsPasswordFlags; description: cstring) {.deprecated.} =
  assert(result is TlsPassword)
  let gobj = g_tls_password_new(flags, description)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_tls_password_get_flags(self: ptr TlsPassword00): TlsPasswordFlags {.
    importc, libprag.}

proc getFlags*(self: TlsPassword): TlsPasswordFlags =
  g_tls_password_get_flags(cast[ptr TlsPassword00](self.impl))

proc flags*(self: TlsPassword): TlsPasswordFlags =
  g_tls_password_get_flags(cast[ptr TlsPassword00](self.impl))

proc g_tls_password_set_flags(self: ptr TlsPassword00; flags: TlsPasswordFlags) {.
    importc, libprag.}

proc setFlags*(self: TlsPassword; flags: TlsPasswordFlags) =
  g_tls_password_set_flags(cast[ptr TlsPassword00](self.impl), flags)

proc `flags=`*(self: TlsPassword; flags: TlsPasswordFlags) =
  g_tls_password_set_flags(cast[ptr TlsPassword00](self.impl), flags)

type
  TlsConnection* = ref object of IOStream
  TlsConnection00* = object of IOStream00

proc g_tls_connection_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(TlsConnection()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc scAcceptCertificate*(self: TlsConnection;  p: proc (self: ptr TlsConnection00; peerCert: ptr TlsCertificate00; errors: TlsCertificateFlags; xdata: pointer): gboolean {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "accept-certificate", cast[GCallback](p), xdata, nil, cf)

proc g_tls_connection_emit_accept_certificate(self: ptr TlsConnection00;
    peerCert: ptr TlsCertificate00; errors: TlsCertificateFlags): gboolean {.
    importc, libprag.}

proc emitAcceptCertificate*(self: TlsConnection; peerCert: TlsCertificate;
    errors: TlsCertificateFlags): bool =
  toBool(g_tls_connection_emit_accept_certificate(cast[ptr TlsConnection00](self.impl), cast[ptr TlsCertificate00](peerCert.impl), errors))

proc g_tls_connection_get_certificate(self: ptr TlsConnection00): ptr TlsCertificate00 {.
    importc, libprag.}

proc getCertificate*(self: TlsConnection): TlsCertificate =
  let gobj = g_tls_connection_get_certificate(cast[ptr TlsConnection00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc certificate*(self: TlsConnection): TlsCertificate =
  let gobj = g_tls_connection_get_certificate(cast[ptr TlsConnection00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_tls_connection_get_channel_binding_data(self: ptr TlsConnection00;
    `type`: TlsChannelBindingType; data: var ptr ByteArray00; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc getChannelBindingData*(self: TlsConnection; `type`: TlsChannelBindingType;
    data: var ptr ByteArray00 = cast[var ptr ByteArray00](nil)): bool =
  var gerror: ptr glib.Error
  let resul0 = g_tls_connection_get_channel_binding_data(cast[ptr TlsConnection00](self.impl), `type`, data, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_tls_connection_get_database(self: ptr TlsConnection00): ptr TlsDatabase00 {.
    importc, libprag.}

proc getDatabase*(self: TlsConnection): TlsDatabase =
  let gobj = g_tls_connection_get_database(cast[ptr TlsConnection00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc database*(self: TlsConnection): TlsDatabase =
  let gobj = g_tls_connection_get_database(cast[ptr TlsConnection00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_tls_connection_get_interaction(self: ptr TlsConnection00): ptr TlsInteraction00 {.
    importc, libprag.}

proc getInteraction*(self: TlsConnection): TlsInteraction =
  let gobj = g_tls_connection_get_interaction(cast[ptr TlsConnection00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc interaction*(self: TlsConnection): TlsInteraction =
  let gobj = g_tls_connection_get_interaction(cast[ptr TlsConnection00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_tls_connection_get_negotiated_protocol(self: ptr TlsConnection00): cstring {.
    importc, libprag.}

proc getNegotiatedProtocol*(self: TlsConnection): string =
  let resul0 = g_tls_connection_get_negotiated_protocol(cast[ptr TlsConnection00](self.impl))
  if resul0.isNil:
    return
  result = $resul0

proc negotiatedProtocol*(self: TlsConnection): string =
  let resul0 = g_tls_connection_get_negotiated_protocol(cast[ptr TlsConnection00](self.impl))
  if resul0.isNil:
    return
  result = $resul0

proc g_tls_connection_get_peer_certificate(self: ptr TlsConnection00): ptr TlsCertificate00 {.
    importc, libprag.}

proc getPeerCertificate*(self: TlsConnection): TlsCertificate =
  let gobj = g_tls_connection_get_peer_certificate(cast[ptr TlsConnection00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc peerCertificate*(self: TlsConnection): TlsCertificate =
  let gobj = g_tls_connection_get_peer_certificate(cast[ptr TlsConnection00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_tls_connection_get_peer_certificate_errors(self: ptr TlsConnection00): TlsCertificateFlags {.
    importc, libprag.}

proc getPeerCertificateErrors*(self: TlsConnection): TlsCertificateFlags =
  g_tls_connection_get_peer_certificate_errors(cast[ptr TlsConnection00](self.impl))

proc peerCertificateErrors*(self: TlsConnection): TlsCertificateFlags =
  g_tls_connection_get_peer_certificate_errors(cast[ptr TlsConnection00](self.impl))

proc g_tls_connection_get_require_close_notify(self: ptr TlsConnection00): gboolean {.
    importc, libprag.}

proc getRequireCloseNotify*(self: TlsConnection): bool =
  toBool(g_tls_connection_get_require_close_notify(cast[ptr TlsConnection00](self.impl)))

proc requireCloseNotify*(self: TlsConnection): bool =
  toBool(g_tls_connection_get_require_close_notify(cast[ptr TlsConnection00](self.impl)))

proc g_tls_connection_get_use_system_certdb(self: ptr TlsConnection00): gboolean {.
    importc, libprag.}

proc getUseSystemCertdb*(self: TlsConnection): bool =
  toBool(g_tls_connection_get_use_system_certdb(cast[ptr TlsConnection00](self.impl)))

proc useSystemCertdb*(self: TlsConnection): bool =
  toBool(g_tls_connection_get_use_system_certdb(cast[ptr TlsConnection00](self.impl)))

proc g_tls_connection_handshake(self: ptr TlsConnection00; cancellable: ptr Cancellable00;
    error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc handshake*(self: TlsConnection; cancellable: Cancellable = nil): bool =
  var gerror: ptr glib.Error
  let resul0 = g_tls_connection_handshake(cast[ptr TlsConnection00](self.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_tls_connection_handshake_async(self: ptr TlsConnection00; ioPriority: int32;
    cancellable: ptr Cancellable00; callback: AsyncReadyCallback; userData: pointer) {.
    importc, libprag.}

proc handshakeAsync*(self: TlsConnection; ioPriority: int;
    cancellable: Cancellable = nil; callback: AsyncReadyCallback; userData: pointer) =
  g_tls_connection_handshake_async(cast[ptr TlsConnection00](self.impl), int32(ioPriority), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_tls_connection_handshake_finish(self: ptr TlsConnection00; resu: ptr AsyncResult00;
    error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc handshakeFinish*(self: TlsConnection; resu: AsyncResult | SimpleAsyncResult | Task): bool =
  var gerror: ptr glib.Error
  let resul0 = g_tls_connection_handshake_finish(cast[ptr TlsConnection00](self.impl), cast[ptr AsyncResult00](resu.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_tls_connection_set_advertised_protocols(self: ptr TlsConnection00;
    protocols: ptr cstring) {.
    importc, libprag.}

proc setAdvertisedProtocols*(self: TlsConnection; protocols: varargs[string, `$`]) =
  var fs469n23x: array[256, pointer]
  var fs469n23: cstringArray = cast[cstringArray](addr fs469n23x)
  g_tls_connection_set_advertised_protocols(cast[ptr TlsConnection00](self.impl), seq2CstringArray(protocols, fs469n23))

proc `advertisedProtocols=`*(self: TlsConnection; protocols: varargs[string, `$`]) =
  var fs469n23x: array[256, pointer]
  var fs469n23: cstringArray = cast[cstringArray](addr fs469n23x)
  g_tls_connection_set_advertised_protocols(cast[ptr TlsConnection00](self.impl), seq2CstringArray(protocols, fs469n23))

proc g_tls_connection_set_certificate(self: ptr TlsConnection00; certificate: ptr TlsCertificate00) {.
    importc, libprag.}

proc setCertificate*(self: TlsConnection; certificate: TlsCertificate) =
  g_tls_connection_set_certificate(cast[ptr TlsConnection00](self.impl), cast[ptr TlsCertificate00](certificate.impl))

proc `certificate=`*(self: TlsConnection; certificate: TlsCertificate) =
  g_tls_connection_set_certificate(cast[ptr TlsConnection00](self.impl), cast[ptr TlsCertificate00](certificate.impl))

proc g_tls_connection_set_database(self: ptr TlsConnection00; database: ptr TlsDatabase00) {.
    importc, libprag.}

proc setDatabase*(self: TlsConnection; database: TlsDatabase = nil) =
  g_tls_connection_set_database(cast[ptr TlsConnection00](self.impl), if database.isNil: nil else: cast[ptr TlsDatabase00](database.impl))

proc `database=`*(self: TlsConnection; database: TlsDatabase = nil) =
  g_tls_connection_set_database(cast[ptr TlsConnection00](self.impl), if database.isNil: nil else: cast[ptr TlsDatabase00](database.impl))

proc g_tls_connection_set_interaction(self: ptr TlsConnection00; interaction: ptr TlsInteraction00) {.
    importc, libprag.}

proc setInteraction*(self: TlsConnection; interaction: TlsInteraction = nil) =
  g_tls_connection_set_interaction(cast[ptr TlsConnection00](self.impl), if interaction.isNil: nil else: cast[ptr TlsInteraction00](interaction.impl))

proc `interaction=`*(self: TlsConnection; interaction: TlsInteraction = nil) =
  g_tls_connection_set_interaction(cast[ptr TlsConnection00](self.impl), if interaction.isNil: nil else: cast[ptr TlsInteraction00](interaction.impl))

proc g_tls_connection_set_require_close_notify(self: ptr TlsConnection00;
    requireCloseNotify: gboolean) {.
    importc, libprag.}

proc setRequireCloseNotify*(self: TlsConnection; requireCloseNotify: bool = true) =
  g_tls_connection_set_require_close_notify(cast[ptr TlsConnection00](self.impl), gboolean(requireCloseNotify))

proc `requireCloseNotify=`*(self: TlsConnection; requireCloseNotify: bool) =
  g_tls_connection_set_require_close_notify(cast[ptr TlsConnection00](self.impl), gboolean(requireCloseNotify))

proc g_tls_connection_set_use_system_certdb(self: ptr TlsConnection00; useSystemCertdb: gboolean) {.
    importc, libprag.}

proc setUseSystemCertdb*(self: TlsConnection; useSystemCertdb: bool = true) =
  g_tls_connection_set_use_system_certdb(cast[ptr TlsConnection00](self.impl), gboolean(useSystemCertdb))

proc `useSystemCertdb=`*(self: TlsConnection; useSystemCertdb: bool) =
  g_tls_connection_set_use_system_certdb(cast[ptr TlsConnection00](self.impl), gboolean(useSystemCertdb))

type
  TlsCertificateRequestFlags* {.size: sizeof(cint), pure.} = enum
    none = 0

proc g_tls_interaction_request_certificate_async(self: ptr TlsInteraction00;
    connection: ptr TlsConnection00; flags: TlsCertificateRequestFlags; cancellable: ptr Cancellable00;
    callback: AsyncReadyCallback; userData: pointer) {.
    importc, libprag.}

proc requestCertificateAsync*(self: TlsInteraction; connection: TlsConnection;
    flags: TlsCertificateRequestFlags; cancellable: Cancellable = nil; callback: AsyncReadyCallback;
    userData: pointer) =
  g_tls_interaction_request_certificate_async(cast[ptr TlsInteraction00](self.impl), cast[ptr TlsConnection00](connection.impl), flags, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

type
  TlsInteractionResult* {.size: sizeof(cint), pure.} = enum
    unhandled = 0
    handled = 1
    failed = 2

proc g_tls_interaction_ask_password(self: ptr TlsInteraction00; password: ptr TlsPassword00;
    cancellable: ptr Cancellable00; error: ptr ptr glib.Error = nil): TlsInteractionResult {.
    importc, libprag.}

proc askPassword*(self: TlsInteraction; password: TlsPassword;
    cancellable: Cancellable = nil): TlsInteractionResult =
  var gerror: ptr glib.Error
  let resul0 = g_tls_interaction_ask_password(cast[ptr TlsInteraction00](self.impl), cast[ptr TlsPassword00](password.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = resul0

proc g_tls_interaction_ask_password_finish(self: ptr TlsInteraction00; resu: ptr AsyncResult00;
    error: ptr ptr glib.Error = nil): TlsInteractionResult {.
    importc, libprag.}

proc askPasswordFinish*(self: TlsInteraction; resu: AsyncResult | SimpleAsyncResult | Task): TlsInteractionResult =
  var gerror: ptr glib.Error
  let resul0 = g_tls_interaction_ask_password_finish(cast[ptr TlsInteraction00](self.impl), cast[ptr AsyncResult00](resu.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = resul0

proc g_tls_interaction_invoke_ask_password(self: ptr TlsInteraction00; password: ptr TlsPassword00;
    cancellable: ptr Cancellable00; error: ptr ptr glib.Error = nil): TlsInteractionResult {.
    importc, libprag.}

proc invokeAskPassword*(self: TlsInteraction; password: TlsPassword;
    cancellable: Cancellable = nil): TlsInteractionResult =
  var gerror: ptr glib.Error
  let resul0 = g_tls_interaction_invoke_ask_password(cast[ptr TlsInteraction00](self.impl), cast[ptr TlsPassword00](password.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = resul0

proc g_tls_interaction_invoke_request_certificate(self: ptr TlsInteraction00;
    connection: ptr TlsConnection00; flags: TlsCertificateRequestFlags; cancellable: ptr Cancellable00;
    error: ptr ptr glib.Error = nil): TlsInteractionResult {.
    importc, libprag.}

proc invokeRequestCertificate*(self: TlsInteraction; connection: TlsConnection;
    flags: TlsCertificateRequestFlags; cancellable: Cancellable = nil): TlsInteractionResult =
  var gerror: ptr glib.Error
  let resul0 = g_tls_interaction_invoke_request_certificate(cast[ptr TlsInteraction00](self.impl), cast[ptr TlsConnection00](connection.impl), flags, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = resul0

proc g_tls_interaction_request_certificate(self: ptr TlsInteraction00; connection: ptr TlsConnection00;
    flags: TlsCertificateRequestFlags; cancellable: ptr Cancellable00; error: ptr ptr glib.Error = nil): TlsInteractionResult {.
    importc, libprag.}

proc requestCertificate*(self: TlsInteraction; connection: TlsConnection;
    flags: TlsCertificateRequestFlags; cancellable: Cancellable = nil): TlsInteractionResult =
  var gerror: ptr glib.Error
  let resul0 = g_tls_interaction_request_certificate(cast[ptr TlsInteraction00](self.impl), cast[ptr TlsConnection00](connection.impl), flags, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = resul0

proc g_tls_interaction_request_certificate_finish(self: ptr TlsInteraction00;
    resu: ptr AsyncResult00; error: ptr ptr glib.Error = nil): TlsInteractionResult {.
    importc, libprag.}

proc requestCertificateFinish*(self: TlsInteraction; resu: AsyncResult | SimpleAsyncResult | Task): TlsInteractionResult =
  var gerror: ptr glib.Error
  let resul0 = g_tls_interaction_request_certificate_finish(cast[ptr TlsInteraction00](self.impl), cast[ptr AsyncResult00](resu.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = resul0

type
  TlsRehandshakeMode* {.size: sizeof(cint), pure.} = enum
    never = 0
    safely = 1
    unsafely = 2

proc g_dtls_connection_get_rehandshake_mode(self: ptr DtlsConnection00): TlsRehandshakeMode {.
    importc, libprag.}

proc getRehandshakeMode*(self: DtlsConnection): TlsRehandshakeMode =
  g_dtls_connection_get_rehandshake_mode(cast[ptr DtlsConnection00](self.impl))

proc rehandshakeMode*(self: DtlsConnection): TlsRehandshakeMode =
  g_dtls_connection_get_rehandshake_mode(cast[ptr DtlsConnection00](self.impl))

proc g_dtls_connection_set_rehandshake_mode(self: ptr DtlsConnection00; mode: TlsRehandshakeMode) {.
    importc, libprag.}

proc setRehandshakeMode*(self: DtlsConnection; mode: TlsRehandshakeMode) =
  g_dtls_connection_set_rehandshake_mode(cast[ptr DtlsConnection00](self.impl), mode)

proc `rehandshakeMode=`*(self: DtlsConnection; mode: TlsRehandshakeMode) =
  g_dtls_connection_set_rehandshake_mode(cast[ptr DtlsConnection00](self.impl), mode)

proc g_tls_connection_get_rehandshake_mode(self: ptr TlsConnection00): TlsRehandshakeMode {.
    importc, libprag.}

proc getRehandshakeMode*(self: TlsConnection): TlsRehandshakeMode =
  g_tls_connection_get_rehandshake_mode(cast[ptr TlsConnection00](self.impl))

proc rehandshakeMode*(self: TlsConnection): TlsRehandshakeMode =
  g_tls_connection_get_rehandshake_mode(cast[ptr TlsConnection00](self.impl))

proc g_tls_connection_set_rehandshake_mode(self: ptr TlsConnection00; mode: TlsRehandshakeMode) {.
    importc, libprag.}

proc setRehandshakeMode*(self: TlsConnection; mode: TlsRehandshakeMode) =
  g_tls_connection_set_rehandshake_mode(cast[ptr TlsConnection00](self.impl), mode)

proc `rehandshakeMode=`*(self: TlsConnection; mode: TlsRehandshakeMode) =
  g_tls_connection_set_rehandshake_mode(cast[ptr TlsConnection00](self.impl), mode)

type
  DtlsServerConnection00* = object of gobject.Object00
  DtlsServerConnection* = ref object of gobject.Object

proc g_dtls_server_connection_new(baseSocket: ptr DatagramBased00; certificate: ptr TlsCertificate00;
    error: ptr ptr glib.Error = nil): ptr DtlsServerConnection00 {.
    importc, libprag.}

proc newDtlsServerConnection*(baseSocket: DatagramBased | Socket; certificate: TlsCertificate = nil): DtlsServerConnection =
  var gerror: ptr glib.Error
  let gobj = g_dtls_server_connection_new(cast[ptr DatagramBased00](baseSocket.impl), if certificate.isNil: nil else: cast[ptr TlsCertificate00](certificate.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

const FILE_ATTRIBUTE_ACCESS_CAN_DELETE* = "access::can-delete"

const FILE_ATTRIBUTE_ACCESS_CAN_EXECUTE* = "access::can-execute"

const FILE_ATTRIBUTE_ACCESS_CAN_READ* = "access::can-read"

const FILE_ATTRIBUTE_ACCESS_CAN_RENAME* = "access::can-rename"

const FILE_ATTRIBUTE_ACCESS_CAN_TRASH* = "access::can-trash"

const FILE_ATTRIBUTE_ACCESS_CAN_WRITE* = "access::can-write"

const FILE_ATTRIBUTE_DOS_IS_ARCHIVE* = "dos::is-archive"

const FILE_ATTRIBUTE_DOS_IS_MOUNTPOINT* = "dos::is-mountpoint"

const FILE_ATTRIBUTE_DOS_IS_SYSTEM* = "dos::is-system"

const FILE_ATTRIBUTE_DOS_REPARSE_POINT_TAG* = "dos::reparse-point-tag"

const FILE_ATTRIBUTE_ETAG_VALUE* = "etag::value"

const FILE_ATTRIBUTE_FILESYSTEM_FREE* = "filesystem::free"

const FILE_ATTRIBUTE_FILESYSTEM_READONLY* = "filesystem::readonly"

const FILE_ATTRIBUTE_FILESYSTEM_REMOTE* = "filesystem::remote"

const FILE_ATTRIBUTE_FILESYSTEM_SIZE* = "filesystem::size"

const FILE_ATTRIBUTE_FILESYSTEM_TYPE* = "filesystem::type"

const FILE_ATTRIBUTE_FILESYSTEM_USED* = "filesystem::used"

const FILE_ATTRIBUTE_FILESYSTEM_USE_PREVIEW* = "filesystem::use-preview"

const FILE_ATTRIBUTE_GVFS_BACKEND* = "gvfs::backend"

const FILE_ATTRIBUTE_ID_FILE* = "id::file"

const FILE_ATTRIBUTE_ID_FILESYSTEM* = "id::filesystem"

const FILE_ATTRIBUTE_MOUNTABLE_CAN_EJECT* = "mountable::can-eject"

const FILE_ATTRIBUTE_MOUNTABLE_CAN_MOUNT* = "mountable::can-mount"

const FILE_ATTRIBUTE_MOUNTABLE_CAN_POLL* = "mountable::can-poll"

const FILE_ATTRIBUTE_MOUNTABLE_CAN_START* = "mountable::can-start"

const FILE_ATTRIBUTE_MOUNTABLE_CAN_START_DEGRADED* = "mountable::can-start-degraded"

const FILE_ATTRIBUTE_MOUNTABLE_CAN_STOP* = "mountable::can-stop"

const FILE_ATTRIBUTE_MOUNTABLE_CAN_UNMOUNT* = "mountable::can-unmount"

const FILE_ATTRIBUTE_MOUNTABLE_HAL_UDI* = "mountable::hal-udi"

const FILE_ATTRIBUTE_MOUNTABLE_IS_MEDIA_CHECK_AUTOMATIC* = "mountable::is-media-check-automatic"

const FILE_ATTRIBUTE_MOUNTABLE_START_STOP_TYPE* = "mountable::start-stop-type"

const FILE_ATTRIBUTE_MOUNTABLE_UNIX_DEVICE* = "mountable::unix-device"

const FILE_ATTRIBUTE_MOUNTABLE_UNIX_DEVICE_FILE* = "mountable::unix-device-file"

const FILE_ATTRIBUTE_OWNER_GROUP* = "owner::group"

const FILE_ATTRIBUTE_OWNER_USER* = "owner::user"

const FILE_ATTRIBUTE_OWNER_USER_REAL* = "owner::user-real"

const FILE_ATTRIBUTE_PREVIEW_ICON* = "preview::icon"

const FILE_ATTRIBUTE_RECENT_MODIFIED* = "recent::modified"

const FILE_ATTRIBUTE_SELINUX_CONTEXT* = "selinux::context"

const FILE_ATTRIBUTE_STANDARD_ALLOCATED_SIZE* = "standard::allocated-size"

const FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE* = "standard::content-type"

const FILE_ATTRIBUTE_STANDARD_COPY_NAME* = "standard::copy-name"

const FILE_ATTRIBUTE_STANDARD_DESCRIPTION* = "standard::description"

const FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME* = "standard::display-name"

const FILE_ATTRIBUTE_STANDARD_EDIT_NAME* = "standard::edit-name"

const FILE_ATTRIBUTE_STANDARD_FAST_CONTENT_TYPE* = "standard::fast-content-type"

const FILE_ATTRIBUTE_STANDARD_ICON* = "standard::icon"

const FILE_ATTRIBUTE_STANDARD_IS_BACKUP* = "standard::is-backup"

const FILE_ATTRIBUTE_STANDARD_IS_HIDDEN* = "standard::is-hidden"

const FILE_ATTRIBUTE_STANDARD_IS_SYMLINK* = "standard::is-symlink"

const FILE_ATTRIBUTE_STANDARD_IS_VIRTUAL* = "standard::is-virtual"

const FILE_ATTRIBUTE_STANDARD_IS_VOLATILE* = "standard::is-volatile"

const FILE_ATTRIBUTE_STANDARD_NAME* = "standard::name"

const FILE_ATTRIBUTE_STANDARD_SIZE* = "standard::size"

const FILE_ATTRIBUTE_STANDARD_SORT_ORDER* = "standard::sort-order"

const FILE_ATTRIBUTE_STANDARD_SYMBOLIC_ICON* = "standard::symbolic-icon"

const FILE_ATTRIBUTE_STANDARD_SYMLINK_TARGET* = "standard::symlink-target"

const FILE_ATTRIBUTE_STANDARD_TARGET_URI* = "standard::target-uri"

const FILE_ATTRIBUTE_STANDARD_TYPE* = "standard::type"

const FILE_ATTRIBUTE_THUMBNAILING_FAILED* = "thumbnail::failed"

const FILE_ATTRIBUTE_THUMBNAIL_IS_VALID* = "thumbnail::is-valid"

const FILE_ATTRIBUTE_THUMBNAIL_PATH* = "thumbnail::path"

const FILE_ATTRIBUTE_TIME_ACCESS* = "time::access"

const FILE_ATTRIBUTE_TIME_ACCESS_USEC* = "time::access-usec"

const FILE_ATTRIBUTE_TIME_CHANGED* = "time::changed"

const FILE_ATTRIBUTE_TIME_CHANGED_USEC* = "time::changed-usec"

const FILE_ATTRIBUTE_TIME_CREATED* = "time::created"

const FILE_ATTRIBUTE_TIME_CREATED_USEC* = "time::created-usec"

const FILE_ATTRIBUTE_TIME_MODIFIED* = "time::modified"

const FILE_ATTRIBUTE_TIME_MODIFIED_USEC* = "time::modified-usec"

const FILE_ATTRIBUTE_TRASH_DELETION_DATE* = "trash::deletion-date"

const FILE_ATTRIBUTE_TRASH_ITEM_COUNT* = "trash::item-count"

const FILE_ATTRIBUTE_TRASH_ORIG_PATH* = "trash::orig-path"

const FILE_ATTRIBUTE_UNIX_BLOCKS* = "unix::blocks"

const FILE_ATTRIBUTE_UNIX_BLOCK_SIZE* = "unix::block-size"

const FILE_ATTRIBUTE_UNIX_DEVICE* = "unix::device"

const FILE_ATTRIBUTE_UNIX_GID* = "unix::gid"

const FILE_ATTRIBUTE_UNIX_INODE* = "unix::inode"

const FILE_ATTRIBUTE_UNIX_IS_MOUNTPOINT* = "unix::is-mountpoint"

const FILE_ATTRIBUTE_UNIX_MODE* = "unix::mode"

const FILE_ATTRIBUTE_UNIX_NLINK* = "unix::nlink"

const FILE_ATTRIBUTE_UNIX_RDEV* = "unix::rdev"

const FILE_ATTRIBUTE_UNIX_UID* = "unix::uid"

type
  FileDescriptorBased00* = object of gobject.Object00
  FileDescriptorBased* = ref object of gobject.Object

type
  UnixInputStream* = ref object of InputStream
  UnixInputStream00* = object of InputStream00

proc g_unix_input_stream_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(UnixInputStream()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc g_unix_input_stream_new(fd: int32; closeFd: gboolean): ptr UnixInputStream00 {.
    importc, libprag.}

proc newUnixInputStream*(fd: int; closeFd: bool): UnixInputStream =
  let gobj = g_unix_input_stream_new(int32(fd), gboolean(closeFd))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newUnixInputStream*(tdesc: typedesc; fd: int; closeFd: bool): tdesc =
  assert(result is UnixInputStream)
  let gobj = g_unix_input_stream_new(int32(fd), gboolean(closeFd))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initUnixInputStream*[T](result: var T; fd: int; closeFd: bool) {.deprecated.} =
  assert(result is UnixInputStream)
  let gobj = g_unix_input_stream_new(int32(fd), gboolean(closeFd))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_unix_input_stream_get_close_fd(self: ptr UnixInputStream00): gboolean {.
    importc, libprag.}

proc getCloseFd*(self: UnixInputStream): bool =
  toBool(g_unix_input_stream_get_close_fd(cast[ptr UnixInputStream00](self.impl)))

proc closeFd*(self: UnixInputStream): bool =
  toBool(g_unix_input_stream_get_close_fd(cast[ptr UnixInputStream00](self.impl)))

proc g_unix_input_stream_get_fd(self: ptr UnixInputStream00): int32 {.
    importc, libprag.}

proc getFd*(self: UnixInputStream): int =
  int(g_unix_input_stream_get_fd(cast[ptr UnixInputStream00](self.impl)))

proc fd*(self: UnixInputStream): int =
  int(g_unix_input_stream_get_fd(cast[ptr UnixInputStream00](self.impl)))

proc g_unix_input_stream_set_close_fd(self: ptr UnixInputStream00; closeFd: gboolean) {.
    importc, libprag.}

proc setCloseFd*(self: UnixInputStream; closeFd: bool = true) =
  g_unix_input_stream_set_close_fd(cast[ptr UnixInputStream00](self.impl), gboolean(closeFd))

proc `closeFd=`*(self: UnixInputStream; closeFd: bool) =
  g_unix_input_stream_set_close_fd(cast[ptr UnixInputStream00](self.impl), gboolean(closeFd))

type
  UnixOutputStream* = ref object of OutputStream
  UnixOutputStream00* = object of OutputStream00

proc g_unix_output_stream_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(UnixOutputStream()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc g_unix_output_stream_new(fd: int32; closeFd: gboolean): ptr UnixOutputStream00 {.
    importc, libprag.}

proc newUnixOutputStream*(fd: int; closeFd: bool): UnixOutputStream =
  let gobj = g_unix_output_stream_new(int32(fd), gboolean(closeFd))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newUnixOutputStream*(tdesc: typedesc; fd: int; closeFd: bool): tdesc =
  assert(result is UnixOutputStream)
  let gobj = g_unix_output_stream_new(int32(fd), gboolean(closeFd))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initUnixOutputStream*[T](result: var T; fd: int; closeFd: bool) {.deprecated.} =
  assert(result is UnixOutputStream)
  let gobj = g_unix_output_stream_new(int32(fd), gboolean(closeFd))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_unix_output_stream_get_close_fd(self: ptr UnixOutputStream00): gboolean {.
    importc, libprag.}

proc getCloseFd*(self: UnixOutputStream): bool =
  toBool(g_unix_output_stream_get_close_fd(cast[ptr UnixOutputStream00](self.impl)))

proc closeFd*(self: UnixOutputStream): bool =
  toBool(g_unix_output_stream_get_close_fd(cast[ptr UnixOutputStream00](self.impl)))

proc g_unix_output_stream_get_fd(self: ptr UnixOutputStream00): int32 {.
    importc, libprag.}

proc getFd*(self: UnixOutputStream): int =
  int(g_unix_output_stream_get_fd(cast[ptr UnixOutputStream00](self.impl)))

proc fd*(self: UnixOutputStream): int =
  int(g_unix_output_stream_get_fd(cast[ptr UnixOutputStream00](self.impl)))

proc g_unix_output_stream_set_close_fd(self: ptr UnixOutputStream00; closeFd: gboolean) {.
    importc, libprag.}

proc setCloseFd*(self: UnixOutputStream; closeFd: bool = true) =
  g_unix_output_stream_set_close_fd(cast[ptr UnixOutputStream00](self.impl), gboolean(closeFd))

proc `closeFd=`*(self: UnixOutputStream; closeFd: bool) =
  g_unix_output_stream_set_close_fd(cast[ptr UnixOutputStream00](self.impl), gboolean(closeFd))

proc g_file_descriptor_based_get_fd(self: ptr FileDescriptorBased00): int32 {.
    importc, libprag.}

proc getFd*(self: FileDescriptorBased | UnixInputStream | UnixOutputStream): int =
  int(g_file_descriptor_based_get_fd(cast[ptr FileDescriptorBased00](self.impl)))

proc fd*(self: FileDescriptorBased | UnixInputStream | UnixOutputStream): int =
  int(g_file_descriptor_based_get_fd(cast[ptr FileDescriptorBased00](self.impl)))

type
  FileMeasureFlag* {.size: sizeof(cint), pure.} = enum
    reportAnyError = 1
    apparentSize = 2
    noXdev = 3

  FileMeasureFlags* {.size: sizeof(cint).} = set[FileMeasureFlag]

const
  FileMeasureFlagsNone* = FileMeasureFlags({})
proc none*(t: typedesc[FileMeasureFlags]): FileMeasureFlags = FileMeasureFlags({})

type
  FileMeasureProgressCallback* = proc (reporting: gboolean; currentSize: uint64; numDirs: uint64; numFiles: uint64;
    userData: pointer) {.cdecl.}

type
  FileProgressCallback* = proc (currentNumBytes: int64; totalNumBytes: int64; userData: pointer) {.cdecl.}

proc g_file_copy(self: ptr GFile00; destination: ptr GFile00; flags: FileCopyFlags;
    cancellable: ptr Cancellable00; progressCallback: FileProgressCallback;
    progressCallbackData: pointer; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc copy*(self: GFile; destination: GFile; flags: FileCopyFlags; cancellable: Cancellable = nil;
    progressCallback: FileProgressCallback; progressCallbackData: pointer): bool =
  var gerror: ptr glib.Error
  let resul0 = g_file_copy(cast[ptr GFile00](self.impl), cast[ptr GFile00](destination.impl), flags, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), progressCallback, progressCallbackData, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_file_copy_async(self: ptr GFile00; destination: ptr GFile00; flags: FileCopyFlags;
    ioPriority: int32; cancellable: ptr Cancellable00; progressCallback: FileProgressCallback;
    progressCallbackData: pointer; callback: AsyncReadyCallback; userData: pointer) {.
    importc, libprag.}

proc copyAsync*(self: GFile; destination: GFile; flags: FileCopyFlags;
    ioPriority: int; cancellable: Cancellable = nil; progressCallback: FileProgressCallback;
    progressCallbackData: pointer; callback: AsyncReadyCallback; userData: pointer) =
  g_file_copy_async(cast[ptr GFile00](self.impl), cast[ptr GFile00](destination.impl), flags, int32(ioPriority), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), progressCallback, progressCallbackData, callback, userData)

proc g_file_move(self: ptr GFile00; destination: ptr GFile00; flags: FileCopyFlags;
    cancellable: ptr Cancellable00; progressCallback: FileProgressCallback;
    progressCallbackData: pointer; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc move*(self: GFile; destination: GFile; flags: FileCopyFlags; cancellable: Cancellable = nil;
    progressCallback: FileProgressCallback; progressCallbackData: pointer): bool =
  var gerror: ptr glib.Error
  let resul0 = g_file_move(cast[ptr GFile00](self.impl), cast[ptr GFile00](destination.impl), flags, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), progressCallback, progressCallbackData, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

type
  FileReadMoreCallback* = proc (fileContents: cstring; fileSize: int64; callbackData: pointer): gboolean {.cdecl.}

type
  FilenameCompleter* = ref object of gobject.Object
  FilenameCompleter00* = object of gobject.Object00

proc g_filename_completer_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(FilenameCompleter()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc scGotCompletionData*(self: FilenameCompleter;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "got-completion-data", cast[GCallback](p), xdata, nil, cf)

proc g_filename_completer_new(): ptr FilenameCompleter00 {.
    importc, libprag.}

proc newFilenameCompleter*(): FilenameCompleter =
  let gobj = g_filename_completer_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newFilenameCompleter*(tdesc: typedesc): tdesc =
  assert(result is FilenameCompleter)
  let gobj = g_filename_completer_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initFilenameCompleter*[T](result: var T) {.deprecated.} =
  assert(result is FilenameCompleter)
  let gobj = g_filename_completer_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_filename_completer_get_completion_suffix(self: ptr FilenameCompleter00;
    initialText: cstring): cstring {.
    importc, libprag.}

proc getCompletionSuffix*(self: FilenameCompleter;
    initialText: cstring): string =
  let resul0 = g_filename_completer_get_completion_suffix(cast[ptr FilenameCompleter00](self.impl), initialText)
  result = $resul0
  cogfree(resul0)

proc g_filename_completer_get_completions(self: ptr FilenameCompleter00;
    initialText: cstring): ptr cstring {.
    importc, libprag.}

proc getCompletions*(self: FilenameCompleter; initialText: cstring): seq[string] =
  let resul0 = g_filename_completer_get_completions(cast[ptr FilenameCompleter00](self.impl), initialText)
  if resul0.isNil:
    return
  result = cstringArrayToSeq(resul0)
  g_strfreev(resul0)

proc g_filename_completer_set_dirs_only(self: ptr FilenameCompleter00; dirsOnly: gboolean) {.
    importc, libprag.}

proc setDirsOnly*(self: FilenameCompleter; dirsOnly: bool = true) =
  g_filename_completer_set_dirs_only(cast[ptr FilenameCompleter00](self.impl), gboolean(dirsOnly))

proc `dirsOnly=`*(self: FilenameCompleter; dirsOnly: bool) =
  g_filename_completer_set_dirs_only(cast[ptr FilenameCompleter00](self.impl), gboolean(dirsOnly))

type
  FilesystemPreviewType* {.size: sizeof(cint), pure.} = enum
    ifAlways = 0
    ifLocal = 1
    never = 2

type
  IOErrorEnum* {.size: sizeof(cint), pure.} = enum
    failed = 0
    notFound = 1
    exists = 2
    isDirectory = 3
    notDirectory = 4
    notEmpty = 5
    notRegularFile = 6
    notSymbolicLink = 7
    notMountableFile = 8
    filenameTooLong = 9
    invalidFilename = 10
    tooManyLinks = 11
    noSpace = 12
    invalidArgument = 13
    permissionDenied = 14
    notSupported = 15
    notMounted = 16
    alreadyMounted = 17
    closed = 18
    cancelled = 19
    pending = 20
    readOnly = 21
    cantCreateBackup = 22
    wrongEtag = 23
    timedOut = 24
    wouldRecurse = 25
    busy = 26
    wouldBlock = 27
    hostNotFound = 28
    wouldMerge = 29
    failedHandled = 30
    tooManyOpenFiles = 31
    notInitialized = 32
    addressInUse = 33
    partialInput = 34
    invalidData = 35
    dbusError = 36
    hostUnreachable = 37
    networkUnreachable = 38
    connectionRefused = 39
    proxyFailed = 40
    proxyAuthFailed = 41
    proxyNeedAuth = 42
    proxyNotAllowed = 43
    brokenPipe = 44
    notConnected = 45
    messageTooLarge = 46

const
  IOErrorEnumConnectionClosed* = IOErrorEnum.brokenPipe

type
  IOExtension00* {.pure.} = object
  IOExtension* = ref object
    impl*: ptr IOExtension00
    ignoreFinalizer*: bool

proc g_io_extension_get_name(self: ptr IOExtension00): cstring {.
    importc, libprag.}

proc getName*(self: IOExtension): string =
  result = $g_io_extension_get_name(cast[ptr IOExtension00](self.impl))

proc name*(self: IOExtension): string =
  result = $g_io_extension_get_name(cast[ptr IOExtension00](self.impl))

proc g_io_extension_get_priority(self: ptr IOExtension00): int32 {.
    importc, libprag.}

proc getPriority*(self: IOExtension): int =
  int(g_io_extension_get_priority(cast[ptr IOExtension00](self.impl)))

proc priority*(self: IOExtension): int =
  int(g_io_extension_get_priority(cast[ptr IOExtension00](self.impl)))

proc g_io_extension_get_type(self: ptr IOExtension00): GType {.
    importc, libprag.}

proc getType*(self: IOExtension): GType =
  g_io_extension_get_type(cast[ptr IOExtension00](self.impl))

type
  IOExtensionPoint00* {.pure.} = object
  IOExtensionPoint* = ref object
    impl*: ptr IOExtensionPoint00
    ignoreFinalizer*: bool

proc g_io_extension_point_get_extension_by_name(self: ptr IOExtensionPoint00;
    name: cstring): ptr IOExtension00 {.
    importc, libprag.}

proc getExtensionByName*(self: IOExtensionPoint; name: cstring): IOExtension =
  new(result)
  result.impl = g_io_extension_point_get_extension_by_name(cast[ptr IOExtensionPoint00](self.impl), name)
  result.ignoreFinalizer = true

proc g_io_extension_point_get_extensions(self: ptr IOExtensionPoint00): ptr glib.List {.
    importc, libprag.}

proc getExtensions*(self: IOExtensionPoint): seq[IOExtension] =
  discard

proc extensions*(self: IOExtensionPoint): seq[IOExtension] =
  discard

proc g_io_extension_point_get_required_type(self: ptr IOExtensionPoint00): GType {.
    importc, libprag.}

proc getRequiredType*(self: IOExtensionPoint): GType =
  g_io_extension_point_get_required_type(cast[ptr IOExtensionPoint00](self.impl))

proc requiredType*(self: IOExtensionPoint): GType =
  g_io_extension_point_get_required_type(cast[ptr IOExtensionPoint00](self.impl))

proc g_io_extension_point_set_required_type(self: ptr IOExtensionPoint00;
    `type`: GType) {.
    importc, libprag.}

proc setRequiredType*(self: IOExtensionPoint; `type`: GType) =
  g_io_extension_point_set_required_type(cast[ptr IOExtensionPoint00](self.impl), `type`)

proc `requiredType=`*(self: IOExtensionPoint; `type`: GType) =
  g_io_extension_point_set_required_type(cast[ptr IOExtensionPoint00](self.impl), `type`)

proc g_io_extension_point_implement(extensionPointName: cstring; `type`: GType;
    extensionName: cstring; priority: int32): ptr IOExtension00 {.
    importc, libprag.}

proc implement*(extensionPointName: cstring; `type`: GType;
    extensionName: cstring; priority: int): IOExtension =
  new(result)
  result.impl = g_io_extension_point_implement(extensionPointName, `type`, extensionName, int32(priority))
  result.ignoreFinalizer = true

proc g_io_extension_point_lookup(name: cstring): ptr IOExtensionPoint00 {.
    importc, libprag.}

proc lookup*(name: cstring): IOExtensionPoint =
  new(result)
  result.impl = g_io_extension_point_lookup(name)
  result.ignoreFinalizer = true

proc g_io_extension_point_register(name: cstring): ptr IOExtensionPoint00 {.
    importc, libprag.}

proc registerIOExtensionPoint*(name: cstring): IOExtensionPoint =
  new(result)
  result.impl = g_io_extension_point_register(name)
  result.ignoreFinalizer = true

type
  IOModule* = ref object of gobject.TypeModule
  IOModule00* = object of gobject.TypeModule00

proc g_io_module_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(IOModule()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc g_io_module_new(filename: cstring): ptr IOModule00 {.
    importc, libprag.}

proc newIOModule*(filename: cstring): IOModule =
  let gobj = g_io_module_new(filename)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newIOModule*(tdesc: typedesc; filename: cstring): tdesc =
  assert(result is IOModule)
  let gobj = g_io_module_new(filename)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initIOModule*[T](result: var T; filename: cstring) {.deprecated.} =
  assert(result is IOModule)
  let gobj = g_io_module_new(filename)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_io_module_query(): ptr cstring {.
    importc, libprag.}

proc query*(): seq[string] =
  let resul0 = g_io_module_query()
  if resul0.isNil:
    return
  result = cstringArrayToSeq(resul0)
  g_strfreev(resul0)

proc g_io_module_load(self: ptr IOModule00) {.
    importc, libprag.}

proc load*(self: IOModule) =
  g_io_module_load(cast[ptr IOModule00](self.impl))

proc g_io_module_unload(self: ptr IOModule00) {.
    importc, libprag.}

proc unload*(self: IOModule) =
  g_io_module_unload(cast[ptr IOModule00](self.impl))

type
  IOModuleScope00* {.pure.} = object
  IOModuleScope* = ref object
    impl*: ptr IOModuleScope00
    ignoreFinalizer*: bool

proc g_io_module_scope_free(self: ptr IOModuleScope00) {.
    importc, libprag.}

proc free*(self: IOModuleScope) =
  g_io_module_scope_free(cast[ptr IOModuleScope00](self.impl))

proc finalizerfree*(self: IOModuleScope) =
  if not self.ignoreFinalizer:
    g_io_module_scope_free(cast[ptr IOModuleScope00](self.impl))

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(IOModuleScope()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    if not self.ignoreFinalizer and self.impl != nil:
      g_io_module_scope_free(self.impl)
      self.impl = nil

proc newWithFinalizer*(x: var IOModuleScope) =
  when defined(gcDestructors):
    new(x)
  else:
    new(x, finalizerfree)

proc g_io_module_scope_block(self: ptr IOModuleScope00; basename: cstring) {.
    importc, libprag.}

proc `block`*(self: IOModuleScope; basename: cstring) =
  g_io_module_scope_block(cast[ptr IOModuleScope00](self.impl), basename)

type
  IOModuleScopeFlag* {.size: sizeof(cint), pure.} = enum
    blockDuplicates = 0

  IOModuleScopeFlags* {.size: sizeof(cint).} = set[IOModuleScopeFlag]

const
  IOModuleScopeFlagsNone* = IOModuleScopeFlags({})
proc none*(t: typedesc[IOModuleScopeFlags]): IOModuleScopeFlags = IOModuleScopeFlags({})

type
  IOSchedulerJob* {.pure, byRef.} = object

proc g_io_scheduler_job_send_to_mainloop(self: IOSchedulerJob; `func`: SourceFunc;
    userData: pointer; notify: DestroyNotify): gboolean {.
    importc, libprag.}

proc sendToMainloop*(self: IOSchedulerJob; `func`: SourceFunc;
    userData: pointer; notify: DestroyNotify): bool =
  toBool(g_io_scheduler_job_send_to_mainloop(self, `func`, userData, notify))

proc g_io_scheduler_job_send_to_mainloop_async(self: IOSchedulerJob; `func`: SourceFunc;
    userData: pointer; notify: DestroyNotify) {.
    importc, libprag.}

proc sendToMainloopAsync*(self: IOSchedulerJob; `func`: SourceFunc;
    userData: pointer; notify: DestroyNotify) =
  g_io_scheduler_job_send_to_mainloop_async(self, `func`, userData, notify)

type
  IOSchedulerJobFunc* = proc (job: IOSchedulerJob; cancellable: ptr Cancellable00; userData: pointer): gboolean {.cdecl.}

type
  IOStreamAdapter00* {.pure.} = object
  IOStreamAdapter* = ref object
    impl*: ptr IOStreamAdapter00
    ignoreFinalizer*: bool

type
  InetAddressMask* = ref object of gobject.Object
  InetAddressMask00* = object of gobject.Object00

proc g_inet_address_mask_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(InetAddressMask()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc g_inet_address_mask_new(`addr`: ptr InetAddress00; length: uint32; error: ptr ptr glib.Error = nil): ptr InetAddressMask00 {.
    importc, libprag.}

proc newInetAddressMask*(`addr`: InetAddress; length: int): InetAddressMask =
  var gerror: ptr glib.Error
  let gobj = g_inet_address_mask_new(cast[ptr InetAddress00](`addr`.impl), uint32(length), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newInetAddressMask*(tdesc: typedesc; `addr`: InetAddress; length: int): tdesc =
  var gerror: ptr glib.Error
  assert(result is InetAddressMask)
  let gobj = g_inet_address_mask_new(cast[ptr InetAddress00](`addr`.impl), uint32(length), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initInetAddressMask*[T](result: var T; `addr`: InetAddress; length: int) {.deprecated.} =
  var gerror: ptr glib.Error
  assert(result is InetAddressMask)
  let gobj = g_inet_address_mask_new(cast[ptr InetAddress00](`addr`.impl), uint32(length), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_inet_address_mask_new_from_string(maskString: cstring; error: ptr ptr glib.Error = nil): ptr InetAddressMask00 {.
    importc, libprag.}

proc newInetAddressMaskFromString*(maskString: cstring): InetAddressMask =
  var gerror: ptr glib.Error
  let gobj = g_inet_address_mask_new_from_string(maskString, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newInetAddressMaskFromString*(tdesc: typedesc; maskString: cstring): tdesc =
  var gerror: ptr glib.Error
  assert(result is InetAddressMask)
  let gobj = g_inet_address_mask_new_from_string(maskString, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initInetAddressMaskFromString*[T](result: var T; maskString: cstring) {.deprecated.} =
  var gerror: ptr glib.Error
  assert(result is InetAddressMask)
  let gobj = g_inet_address_mask_new_from_string(maskString, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_inet_address_mask_equal(self: ptr InetAddressMask00; mask2: ptr InetAddressMask00): gboolean {.
    importc, libprag.}

proc equal*(self: InetAddressMask; mask2: InetAddressMask): bool =
  toBool(g_inet_address_mask_equal(cast[ptr InetAddressMask00](self.impl), cast[ptr InetAddressMask00](mask2.impl)))

proc g_inet_address_mask_get_address(self: ptr InetAddressMask00): ptr InetAddress00 {.
    importc, libprag.}

proc getAddress*(self: InetAddressMask): InetAddress =
  let gobj = g_inet_address_mask_get_address(cast[ptr InetAddressMask00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc address*(self: InetAddressMask): InetAddress =
  let gobj = g_inet_address_mask_get_address(cast[ptr InetAddressMask00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_inet_address_mask_get_family(self: ptr InetAddressMask00): SocketFamily {.
    importc, libprag.}

proc getFamily*(self: InetAddressMask): SocketFamily =
  g_inet_address_mask_get_family(cast[ptr InetAddressMask00](self.impl))

proc family*(self: InetAddressMask): SocketFamily =
  g_inet_address_mask_get_family(cast[ptr InetAddressMask00](self.impl))

proc g_inet_address_mask_get_length(self: ptr InetAddressMask00): uint32 {.
    importc, libprag.}

proc getLength*(self: InetAddressMask): int =
  int(g_inet_address_mask_get_length(cast[ptr InetAddressMask00](self.impl)))

proc length*(self: InetAddressMask): int =
  int(g_inet_address_mask_get_length(cast[ptr InetAddressMask00](self.impl)))

proc g_inet_address_mask_matches(self: ptr InetAddressMask00; address: ptr InetAddress00): gboolean {.
    importc, libprag.}

proc matches*(self: InetAddressMask; address: InetAddress): bool =
  toBool(g_inet_address_mask_matches(cast[ptr InetAddressMask00](self.impl), cast[ptr InetAddress00](address.impl)))

proc g_inet_address_mask_to_string(self: ptr InetAddressMask00): cstring {.
    importc, libprag.}

proc toString*(self: InetAddressMask): string =
  let resul0 = g_inet_address_mask_to_string(cast[ptr InetAddressMask00](self.impl))
  result = $resul0
  cogfree(resul0)

type
  Initable00* = object of gobject.Object00
  Initable* = ref object of gobject.Object

proc g_initable_newv(objectType: GType; nParameters: uint32; parameters: ptr gobject.Parameter00;
    cancellable: ptr Cancellable00; error: ptr ptr glib.Error = nil): ptr gobject.Object00 {.
    importc, libprag.}

proc newInitablev*(objectType: GType; nParameters: int; parameters: ptr gobject.Parameter00;
    cancellable: Cancellable = nil): gobject.Object =
  var gerror: ptr glib.Error
  let gobj = g_initable_newv(objectType, uint32(nParameters), parameters, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gobject.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

type
  Subprocess* = ref object of gobject.Object
  Subprocess00* = object of gobject.Object00

proc g_subprocess_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(Subprocess()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc g_subprocess_communicate(self: ptr Subprocess00; stdinBuf: ptr glib.Bytes00;
    cancellable: ptr Cancellable00; stdoutBuf: var ptr glib.Bytes00; stderrBuf: var ptr glib.Bytes00;
    error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc communicate*(self: Subprocess; stdinBuf: glib.Bytes = nil;
    cancellable: Cancellable = nil; stdoutBuf: var glib.Bytes = cast[var glib.Bytes](nil);
    stderrBuf: var glib.Bytes = cast[var glib.Bytes](nil)): bool =
  if addr(stdoutBuf) != nil:
    fnew(stdoutBuf, gBoxedFreeGBytes)
  if addr(stderrBuf) != nil:
    fnew(stderrBuf, gBoxedFreeGBytes)
  var gerror: ptr glib.Error
  let resul0 = g_subprocess_communicate(cast[ptr Subprocess00](self.impl), if stdinBuf.isNil: nil else: cast[ptr glib.Bytes00](stdinBuf.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), cast[var ptr glib.Bytes00](if addr(stdoutBuf) == nil: nil else: addr stdoutBuf.impl), cast[var ptr glib.Bytes00](if addr(stderrBuf) == nil: nil else: addr stderrBuf.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)
  if stdoutBuf != nil and stdoutBuf.impl == nil:
    stdoutBuf.ignoreFinalizer = true
    stdoutBuf = nil
  if stderrBuf != nil and stderrBuf.impl == nil:
    stderrBuf.ignoreFinalizer = true
    stderrBuf = nil

proc g_subprocess_communicate_async(self: ptr Subprocess00; stdinBuf: ptr glib.Bytes00;
    cancellable: ptr Cancellable00; callback: AsyncReadyCallback; userData: pointer) {.
    importc, libprag.}

proc communicateAsync*(self: Subprocess; stdinBuf: glib.Bytes = nil;
    cancellable: Cancellable = nil; callback: AsyncReadyCallback; userData: pointer) =
  g_subprocess_communicate_async(cast[ptr Subprocess00](self.impl), if stdinBuf.isNil: nil else: cast[ptr glib.Bytes00](stdinBuf.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_subprocess_communicate_finish(self: ptr Subprocess00; resu: ptr AsyncResult00;
    stdoutBuf: var ptr glib.Bytes00; stderrBuf: var ptr glib.Bytes00; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc communicateFinish*(self: Subprocess; resu: AsyncResult | SimpleAsyncResult | Task;
    stdoutBuf: var glib.Bytes = cast[var glib.Bytes](nil); stderrBuf: var glib.Bytes = cast[var glib.Bytes](nil)): bool =
  if addr(stdoutBuf) != nil:
    fnew(stdoutBuf, gBoxedFreeGBytes)
  if addr(stderrBuf) != nil:
    fnew(stderrBuf, gBoxedFreeGBytes)
  var gerror: ptr glib.Error
  let resul0 = g_subprocess_communicate_finish(cast[ptr Subprocess00](self.impl), cast[ptr AsyncResult00](resu.impl), cast[var ptr glib.Bytes00](if addr(stdoutBuf) == nil: nil else: addr stdoutBuf.impl), cast[var ptr glib.Bytes00](if addr(stderrBuf) == nil: nil else: addr stderrBuf.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)
  if stdoutBuf != nil and stdoutBuf.impl == nil:
    stdoutBuf.ignoreFinalizer = true
    stdoutBuf = nil
  if stderrBuf != nil and stderrBuf.impl == nil:
    stderrBuf.ignoreFinalizer = true
    stderrBuf = nil

proc g_subprocess_communicate_utf8(self: ptr Subprocess00; stdinBuf: cstring;
    cancellable: ptr Cancellable00; stdoutBuf: var cstring; stderrBuf: var cstring;
    error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc communicateUtf8*(self: Subprocess; stdinBuf: cstring = nil;
    cancellable: Cancellable = nil; stdoutBuf: var string = cast[var string](nil);
    stderrBuf: var string = cast[var string](nil)): bool =
  var gerror: ptr glib.Error
  var stderrBuf_00: cstring
  var stdoutBuf_00: cstring
  let resul0 = g_subprocess_communicate_utf8(cast[ptr Subprocess00](self.impl), stdinBuf, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), stdoutBuf_00, stderrBuf_00, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)
  if stderrBuf.addr != nil:
    stderrBuf = $(stderrBuf_00)
  if stdoutBuf.addr != nil:
    stdoutBuf = $(stdoutBuf_00)

proc g_subprocess_communicate_utf8_async(self: ptr Subprocess00; stdinBuf: cstring;
    cancellable: ptr Cancellable00; callback: AsyncReadyCallback; userData: pointer) {.
    importc, libprag.}

proc communicateUtf8Async*(self: Subprocess; stdinBuf: cstring = nil;
    cancellable: Cancellable = nil; callback: AsyncReadyCallback; userData: pointer) =
  g_subprocess_communicate_utf8_async(cast[ptr Subprocess00](self.impl), stdinBuf, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_subprocess_communicate_utf8_finish(self: ptr Subprocess00; resu: ptr AsyncResult00;
    stdoutBuf: var cstring; stderrBuf: var cstring; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc communicateUtf8Finish*(self: Subprocess; resu: AsyncResult | SimpleAsyncResult | Task;
    stdoutBuf: var string = cast[var string](nil); stderrBuf: var string = cast[var string](nil)): bool =
  var gerror: ptr glib.Error
  var stderrBuf_00: cstring
  var stdoutBuf_00: cstring
  let resul0 = g_subprocess_communicate_utf8_finish(cast[ptr Subprocess00](self.impl), cast[ptr AsyncResult00](resu.impl), stdoutBuf_00, stderrBuf_00, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)
  if stderrBuf.addr != nil:
    stderrBuf = $(stderrBuf_00)
  if stdoutBuf.addr != nil:
    stdoutBuf = $(stdoutBuf_00)

proc g_subprocess_force_exit(self: ptr Subprocess00) {.
    importc, libprag.}

proc forceExit*(self: Subprocess) =
  g_subprocess_force_exit(cast[ptr Subprocess00](self.impl))

proc g_subprocess_get_exit_status(self: ptr Subprocess00): int32 {.
    importc, libprag.}

proc getExitStatus*(self: Subprocess): int =
  int(g_subprocess_get_exit_status(cast[ptr Subprocess00](self.impl)))

proc exitStatus*(self: Subprocess): int =
  int(g_subprocess_get_exit_status(cast[ptr Subprocess00](self.impl)))

proc g_subprocess_get_identifier(self: ptr Subprocess00): cstring {.
    importc, libprag.}

proc getIdentifier*(self: Subprocess): string =
  let resul0 = g_subprocess_get_identifier(cast[ptr Subprocess00](self.impl))
  if resul0.isNil:
    return
  result = $resul0

proc identifier*(self: Subprocess): string =
  let resul0 = g_subprocess_get_identifier(cast[ptr Subprocess00](self.impl))
  if resul0.isNil:
    return
  result = $resul0

proc g_subprocess_get_if_exited(self: ptr Subprocess00): gboolean {.
    importc, libprag.}

proc getIfExited*(self: Subprocess): bool =
  toBool(g_subprocess_get_if_exited(cast[ptr Subprocess00](self.impl)))

proc ifExited*(self: Subprocess): bool =
  toBool(g_subprocess_get_if_exited(cast[ptr Subprocess00](self.impl)))

proc g_subprocess_get_if_signaled(self: ptr Subprocess00): gboolean {.
    importc, libprag.}

proc getIfSignaled*(self: Subprocess): bool =
  toBool(g_subprocess_get_if_signaled(cast[ptr Subprocess00](self.impl)))

proc ifSignaled*(self: Subprocess): bool =
  toBool(g_subprocess_get_if_signaled(cast[ptr Subprocess00](self.impl)))

proc g_subprocess_get_status(self: ptr Subprocess00): int32 {.
    importc, libprag.}

proc getStatus*(self: Subprocess): int =
  int(g_subprocess_get_status(cast[ptr Subprocess00](self.impl)))

proc status*(self: Subprocess): int =
  int(g_subprocess_get_status(cast[ptr Subprocess00](self.impl)))

proc g_subprocess_get_stderr_pipe(self: ptr Subprocess00): ptr InputStream00 {.
    importc, libprag.}

proc getStderrPipe*(self: Subprocess): InputStream =
  let gobj = g_subprocess_get_stderr_pipe(cast[ptr Subprocess00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc stderrPipe*(self: Subprocess): InputStream =
  let gobj = g_subprocess_get_stderr_pipe(cast[ptr Subprocess00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_subprocess_get_stdin_pipe(self: ptr Subprocess00): ptr OutputStream00 {.
    importc, libprag.}

proc getStdinPipe*(self: Subprocess): OutputStream =
  let gobj = g_subprocess_get_stdin_pipe(cast[ptr Subprocess00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc stdinPipe*(self: Subprocess): OutputStream =
  let gobj = g_subprocess_get_stdin_pipe(cast[ptr Subprocess00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_subprocess_get_stdout_pipe(self: ptr Subprocess00): ptr InputStream00 {.
    importc, libprag.}

proc getStdoutPipe*(self: Subprocess): InputStream =
  let gobj = g_subprocess_get_stdout_pipe(cast[ptr Subprocess00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc stdoutPipe*(self: Subprocess): InputStream =
  let gobj = g_subprocess_get_stdout_pipe(cast[ptr Subprocess00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_subprocess_get_successful(self: ptr Subprocess00): gboolean {.
    importc, libprag.}

proc getSuccessful*(self: Subprocess): bool =
  toBool(g_subprocess_get_successful(cast[ptr Subprocess00](self.impl)))

proc successful*(self: Subprocess): bool =
  toBool(g_subprocess_get_successful(cast[ptr Subprocess00](self.impl)))

proc g_subprocess_get_term_sig(self: ptr Subprocess00): int32 {.
    importc, libprag.}

proc getTermSig*(self: Subprocess): int =
  int(g_subprocess_get_term_sig(cast[ptr Subprocess00](self.impl)))

proc termSig*(self: Subprocess): int =
  int(g_subprocess_get_term_sig(cast[ptr Subprocess00](self.impl)))

proc g_subprocess_send_signal(self: ptr Subprocess00; signalNum: int32) {.
    importc, libprag.}

proc sendSignal*(self: Subprocess; signalNum: int) =
  g_subprocess_send_signal(cast[ptr Subprocess00](self.impl), int32(signalNum))

proc g_subprocess_wait(self: ptr Subprocess00; cancellable: ptr Cancellable00;
    error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc wait*(self: Subprocess; cancellable: Cancellable = nil): bool =
  var gerror: ptr glib.Error
  let resul0 = g_subprocess_wait(cast[ptr Subprocess00](self.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_subprocess_wait_async(self: ptr Subprocess00; cancellable: ptr Cancellable00;
    callback: AsyncReadyCallback; userData: pointer) {.
    importc, libprag.}

proc waitAsync*(self: Subprocess; cancellable: Cancellable = nil;
    callback: AsyncReadyCallback; userData: pointer) =
  g_subprocess_wait_async(cast[ptr Subprocess00](self.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_subprocess_wait_check(self: ptr Subprocess00; cancellable: ptr Cancellable00;
    error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc waitCheck*(self: Subprocess; cancellable: Cancellable = nil): bool =
  var gerror: ptr glib.Error
  let resul0 = g_subprocess_wait_check(cast[ptr Subprocess00](self.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_subprocess_wait_check_async(self: ptr Subprocess00; cancellable: ptr Cancellable00;
    callback: AsyncReadyCallback; userData: pointer) {.
    importc, libprag.}

proc waitCheckAsync*(self: Subprocess; cancellable: Cancellable = nil;
    callback: AsyncReadyCallback; userData: pointer) =
  g_subprocess_wait_check_async(cast[ptr Subprocess00](self.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_subprocess_wait_check_finish(self: ptr Subprocess00; resu: ptr AsyncResult00;
    error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc waitCheckFinish*(self: Subprocess; resu: AsyncResult | SimpleAsyncResult | Task): bool =
  var gerror: ptr glib.Error
  let resul0 = g_subprocess_wait_check_finish(cast[ptr Subprocess00](self.impl), cast[ptr AsyncResult00](resu.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_subprocess_wait_finish(self: ptr Subprocess00; resu: ptr AsyncResult00;
    error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc waitFinish*(self: Subprocess; resu: AsyncResult | SimpleAsyncResult | Task): bool =
  var gerror: ptr glib.Error
  let resul0 = g_subprocess_wait_finish(cast[ptr Subprocess00](self.impl), cast[ptr AsyncResult00](resu.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc g_initable_init(self: ptr Initable00; cancellable: ptr Cancellable00;
    error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc init*(self: Initable | InetAddressMask | CharsetConverter | DBusProxy | Subprocess | DBusObjectManagerClient | Socket | DBusServer | DBusConnection;
    cancellable: Cancellable = nil): bool =
  var gerror: ptr glib.Error
  let resul0 = g_initable_init(cast[ptr Initable00](self.impl), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

type
  SubprocessFlag* {.size: sizeof(cint), pure.} = enum
    stdinPipe = 0
    stdinInherit = 1
    stdoutPipe = 2
    stdoutSilence = 3
    stderrPipe = 4
    stderrSilence = 5
    stderrMerge = 6
    inheritFds = 7

  SubprocessFlags* {.size: sizeof(cint).} = set[SubprocessFlag]

const
  SubprocessFlagsNone* = SubprocessFlags({})
proc none*(t: typedesc[SubprocessFlags]): SubprocessFlags = SubprocessFlags({})

proc g_subprocess_newv(argv: ptr cstring; flags: SubprocessFlags; error: ptr ptr glib.Error = nil): ptr Subprocess00 {.
    importc, libprag.}

proc newSubprocess*(argv: openArray[string]; flags: SubprocessFlags): Subprocess =
  var fs469n23x: array[256, pointer]
  var fs469n23: cstringArray = cast[cstringArray](addr fs469n23x)
  var gerror: ptr glib.Error
  let gobj = g_subprocess_newv(seq2CstringArray(argv, fs469n23), flags, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newSubprocess*(tdesc: typedesc; argv: openArray[string]; flags: SubprocessFlags): tdesc =
  var fs469n23x: array[256, pointer]
  var fs469n23: cstringArray = cast[cstringArray](addr fs469n23x)
  var gerror: ptr glib.Error
  assert(result is Subprocess)
  let gobj = g_subprocess_newv(seq2CstringArray(argv, fs469n23), flags, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initSubprocess*[T](result: var T; argv: openArray[string]; flags: SubprocessFlags) {.deprecated.} =
  var fs469n23x: array[256, pointer]
  var fs469n23: cstringArray = cast[cstringArray](addr fs469n23x)
  var gerror: ptr glib.Error
  assert(result is Subprocess)
  let gobj = g_subprocess_newv(seq2CstringArray(argv, fs469n23), flags, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

type
  ListStore* = ref object of gobject.Object
  ListStore00* = object of gobject.Object00

proc g_list_store_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(ListStore()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc g_list_store_new(itemType: GType): ptr ListStore00 {.
    importc, libprag.}

proc newListStore*(itemType: GType): ListStore =
  let gobj = g_list_store_new(itemType)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newListStore*(tdesc: typedesc; itemType: GType): tdesc =
  assert(result is ListStore)
  let gobj = g_list_store_new(itemType)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initListStore*[T](result: var T; itemType: GType) {.deprecated.} =
  assert(result is ListStore)
  let gobj = g_list_store_new(itemType)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_list_store_append(self: ptr ListStore00; item: ptr gobject.Object00) {.
    importc, libprag.}

proc append*(self: ListStore; item: gobject.Object) =
  g_list_store_append(cast[ptr ListStore00](self.impl), cast[ptr gobject.Object00](item.impl))

proc g_list_store_find(self: ptr ListStore00; item: ptr gobject.Object00;
    position: var uint32): gboolean {.
    importc, libprag.}

proc findListStore*(self: ListStore; item: gobject.Object; position: var int = cast[var int](nil)): bool =
  var position_00: uint32
  result = toBool(g_list_store_find(cast[ptr ListStore00](self.impl), cast[ptr gobject.Object00](item.impl), position_00))
  if position.addr != nil:
    position = int(position_00)

proc g_list_store_find_with_equal_func(self: ptr ListStore00; item: ptr gobject.Object00;
    equalFunc: EqualFunc; position: var uint32): gboolean {.
    importc, libprag.}

proc findWithEqualFunc*(self: ListStore; item: gobject.Object;
    equalFunc: EqualFunc; position: var int = cast[var int](nil)): bool =
  var position_00: uint32
  result = toBool(g_list_store_find_with_equal_func(cast[ptr ListStore00](self.impl), cast[ptr gobject.Object00](item.impl), equalFunc, position_00))
  if position.addr != nil:
    position = int(position_00)

proc g_list_store_insert(self: ptr ListStore00; position: uint32; item: ptr gobject.Object00) {.
    importc, libprag.}

proc insert*(self: ListStore; position: int; item: gobject.Object) =
  g_list_store_insert(cast[ptr ListStore00](self.impl), uint32(position), cast[ptr gobject.Object00](item.impl))

proc g_list_store_insert_sorted(self: ptr ListStore00; item: ptr gobject.Object00;
    compareFunc: CompareDataFunc; userData: pointer): uint32 {.
    importc, libprag.}

proc insertSorted*(self: ListStore; item: gobject.Object; compareFunc: CompareDataFunc;
    userData: pointer): int =
  int(g_list_store_insert_sorted(cast[ptr ListStore00](self.impl), cast[ptr gobject.Object00](item.impl), compareFunc, userData))

proc g_list_store_remove(self: ptr ListStore00; position: uint32) {.
    importc, libprag.}

proc remove*(self: ListStore; position: int) =
  g_list_store_remove(cast[ptr ListStore00](self.impl), uint32(position))

proc g_list_store_remove_all(self: ptr ListStore00) {.
    importc, libprag.}

proc removeAll*(self: ListStore) =
  g_list_store_remove_all(cast[ptr ListStore00](self.impl))

proc g_list_store_sort(self: ptr ListStore00; compareFunc: CompareDataFunc;
    userData: pointer) {.
    importc, libprag.}

proc sort*(self: ListStore; compareFunc: CompareDataFunc; userData: pointer) =
  g_list_store_sort(cast[ptr ListStore00](self.impl), compareFunc, userData)

proc g_list_store_splice(self: ptr ListStore00; position: uint32; nRemovals: uint32;
    additions: ptr gobject.Object00; nAdditions: uint32) {.
    importc, libprag.}

proc splice*(self: ListStore; position: int; nRemovals: int;
    additions: ptr gobject.Object00; nAdditions: int) =
  g_list_store_splice(cast[ptr ListStore00](self.impl), uint32(position), uint32(nRemovals), additions, uint32(nAdditions))

type
  ListModel00* = object of gobject.Object00
  ListModel* = ref object of gobject.Object

proc scItemsChanged*(self: ListModel | ListStore;  p: proc (self: ptr ListModel00; position: uint32; removed: uint32; added: uint32; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "items-changed", cast[GCallback](p), xdata, nil, cf)

proc g_list_model_get_item_type(self: ptr ListModel00): GType {.
    importc, libprag.}

proc getItemType*(self: ListModel | ListStore): GType =
  g_list_model_get_item_type(cast[ptr ListModel00](self.impl))

proc itemType*(self: ListModel | ListStore): GType =
  g_list_model_get_item_type(cast[ptr ListModel00](self.impl))

proc g_list_model_get_n_items(self: ptr ListModel00): uint32 {.
    importc, libprag.}

proc getNItems*(self: ListModel | ListStore): int =
  int(g_list_model_get_n_items(cast[ptr ListModel00](self.impl)))

proc nItems*(self: ListModel | ListStore): int =
  int(g_list_model_get_n_items(cast[ptr ListModel00](self.impl)))

proc g_list_model_get_object(self: ptr ListModel00; position: uint32): ptr gobject.Object00 {.
    importc, libprag.}

proc getItem*(self: ListModel | ListStore; position: int): gobject.Object =
  let gobj = g_list_model_get_object(cast[ptr ListModel00](self.impl), uint32(position))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gobject.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_list_model_items_changed(self: ptr ListModel00; position: uint32;
    removed: uint32; added: uint32) {.
    importc, libprag.}

proc itemsChanged*(self: ListModel | ListStore; position: int;
    removed: int; added: int) =
  g_list_model_items_changed(cast[ptr ListModel00](self.impl), uint32(position), uint32(removed), uint32(added))

type
  LoadableIcon00* = object of gobject.Object00
  LoadableIcon* = ref object of gobject.Object

proc g_loadable_icon_load(self: ptr LoadableIcon00; size: int32; `type`: var cstring;
    cancellable: ptr Cancellable00; error: ptr ptr glib.Error = nil): ptr InputStream00 {.
    importc, libprag.}

proc load*(self: LoadableIcon | BytesIcon | FileIcon; size: int;
    `type`: var string = cast[var string](nil); cancellable: Cancellable = nil): InputStream =
  var gerror: ptr glib.Error
  var type_00: cstring
  let gobj = g_loadable_icon_load(cast[ptr LoadableIcon00](self.impl), int32(size), type_00, if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))
  if `type`.addr != nil:
    `type` = $(type_00)

proc g_loadable_icon_load_async(self: ptr LoadableIcon00; size: int32; cancellable: ptr Cancellable00;
    callback: AsyncReadyCallback; userData: pointer) {.
    importc, libprag.}

proc loadAsync*(self: LoadableIcon | BytesIcon | FileIcon;
    size: int; cancellable: Cancellable = nil; callback: AsyncReadyCallback;
    userData: pointer) =
  g_loadable_icon_load_async(cast[ptr LoadableIcon00](self.impl), int32(size), if cancellable.isNil: nil else: cast[ptr Cancellable00](cancellable.impl), callback, userData)

proc g_loadable_icon_load_finish(self: ptr LoadableIcon00; res: ptr AsyncResult00;
    `type`: var cstring; error: ptr ptr glib.Error = nil): ptr InputStream00 {.
    importc, libprag.}

proc loadFinish*(self: LoadableIcon | BytesIcon | FileIcon;
    res: AsyncResult | SimpleAsyncResult | Task; `type`: var string = cast[var string](nil)): InputStream =
  var gerror: ptr glib.Error
  var type_00: cstring
  let gobj = g_loadable_icon_load_finish(cast[ptr LoadableIcon00](self.impl), cast[ptr AsyncResult00](res.impl), type_00, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))
  if `type`.addr != nil:
    `type` = $(type_00)

const MEMORY_MONITOR_EXTENSION_POINT_NAME* = "gio-memory-monitor"

const MENU_ATTRIBUTE_ACTION* = "action"

const MENU_ATTRIBUTE_ACTION_NAMESPACE* = "action-namespace"

const MENU_ATTRIBUTE_ICON* = "icon"

const MENU_ATTRIBUTE_LABEL* = "label"

const MENU_ATTRIBUTE_TARGET* = "target"

const MENU_LINK_SECTION* = "section"

const MENU_LINK_SUBMENU* = "submenu"

type
  MemoryInputStream* = ref object of InputStream
  MemoryInputStream00* = object of InputStream00

proc g_memory_input_stream_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(MemoryInputStream()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc g_memory_input_stream_new(): ptr MemoryInputStream00 {.
    importc, libprag.}

proc newMemoryInputStream*(): MemoryInputStream =
  let gobj = g_memory_input_stream_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newMemoryInputStream*(tdesc: typedesc): tdesc =
  assert(result is MemoryInputStream)
  let gobj = g_memory_input_stream_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initMemoryInputStream*[T](result: var T) {.deprecated.} =
  assert(result is MemoryInputStream)
  let gobj = g_memory_input_stream_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_memory_input_stream_new_from_bytes(bytes: ptr glib.Bytes00): ptr MemoryInputStream00 {.
    importc, libprag.}

proc newMemoryInputStreamFromBytes*(bytes: glib.Bytes): MemoryInputStream =
  let gobj = g_memory_input_stream_new_from_bytes(cast[ptr glib.Bytes00](bytes.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newMemoryInputStreamFromBytes*(tdesc: typedesc; bytes: glib.Bytes): tdesc =
  assert(result is MemoryInputStream)
  let gobj = g_memory_input_stream_new_from_bytes(cast[ptr glib.Bytes00](bytes.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initMemoryInputStreamFromBytes*[T](result: var T; bytes: glib.Bytes) {.deprecated.} =
  assert(result is MemoryInputStream)
  let gobj = g_memory_input_stream_new_from_bytes(cast[ptr glib.Bytes00](bytes.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_memory_input_stream_new_from_data(data: ptr uint8; len: int64; destroy: DestroyNotify): ptr MemoryInputStream00 {.
    importc, libprag.}

proc newMemoryInputStreamFromData*(data: seq[uint8] | string; destroy: DestroyNotify): MemoryInputStream =
  let len = int64(data.len)
  let gobj = g_memory_input_stream_new_from_data(cast[ptr uint8](unsafeaddr(data[0])), len, destroy)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newMemoryInputStreamFromData*(tdesc: typedesc; data: seq[uint8] | string; destroy: DestroyNotify): tdesc =
  let len = int64(data.len)
  assert(result is MemoryInputStream)
  let gobj = g_memory_input_stream_new_from_data(cast[ptr uint8](unsafeaddr(data[0])), len, destroy)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initMemoryInputStreamFromData*[T](result: var T; data: seq[uint8] | string; destroy: DestroyNotify) {.deprecated.} =
  let len = int64(data.len)
  assert(result is MemoryInputStream)
  let gobj = g_memory_input_stream_new_from_data(cast[ptr uint8](unsafeaddr(data[0])), len, destroy)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_memory_input_stream_add_bytes(self: ptr MemoryInputStream00; bytes: ptr glib.Bytes00) {.
    importc, libprag.}

proc addBytes*(self: MemoryInputStream; bytes: glib.Bytes) =
  g_memory_input_stream_add_bytes(cast[ptr MemoryInputStream00](self.impl), cast[ptr glib.Bytes00](bytes.impl))

proc g_memory_input_stream_add_data(self: ptr MemoryInputStream00; data: ptr uint8;
    len: int64; destroy: DestroyNotify) {.
    importc, libprag.}

proc addData*(self: MemoryInputStream; data: seq[uint8] | string;
    destroy: DestroyNotify) =
  let len = int64(data.len)
  g_memory_input_stream_add_data(cast[ptr MemoryInputStream00](self.impl), cast[ptr uint8](unsafeaddr(data[0])), len, destroy)

type
  MemoryMonitorWarningLevel* {.size: sizeof(cint), pure.} = enum
    low = 50
    medium = 100
    critical = 255

type
  MemoryMonitor00* = object of gobject.Object00
  MemoryMonitor* = ref object of gobject.Object

proc scLowMemoryWarning*(self: MemoryMonitor;  p: proc (self: ptr MemoryMonitor00; level: MemoryMonitorWarningLevel; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "low-memory-warning", cast[GCallback](p), xdata, nil, cf)

proc g_memory_monitor_dup_default(): ptr MemoryMonitor00 {.
    importc, libprag.}

proc dupDefaultMemoryMonitor*(): MemoryMonitor =
  let gobj = g_memory_monitor_dup_default()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

type
  MemoryOutputStream* = ref object of OutputStream
  MemoryOutputStream00* = object of OutputStream00

proc g_memory_output_stream_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(MemoryOutputStream()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc g_memory_output_stream_new_resizable(): ptr MemoryOutputStream00 {.
    importc, libprag.}

proc newMemoryOutputStreamResizable*(): MemoryOutputStream =
  let gobj = g_memory_output_stream_new_resizable()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newMemoryOutputStreamResizable*(tdesc: typedesc): tdesc =
  assert(result is MemoryOutputStream)
  let gobj = g_memory_output_stream_new_resizable()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initMemoryOutputStreamResizable*[T](result: var T) {.deprecated.} =
  assert(result is MemoryOutputStream)
  let gobj = g_memory_output_stream_new_resizable()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc g_memory_output_stream_get_data(self: ptr MemoryOutputStream00): pointer {.
    importc, libprag.}

proc getData*(self: MemoryOutputStream): pointer =
  g_memory_output_stream_get_data(cast[ptr MemoryOutputStream00](self.impl))

proc g_memory_output_stream_get_data_size(self: ptr MemoryOutputStream00): uint64 {.
    importc, libprag.}

proc getDataSize*(self: MemoryOutputStream): uint64 =
  g_memory_output_stream_get_data_size(cast[ptr MemoryOutputStream00](self.impl))

proc dataSize*(self: MemoryOutputStream): uint64 =
  g_memory_output_stream_get_data_size(cast[ptr MemoryOutputStream00](self.impl))

proc g_memory_output_stream_get_size(self: ptr MemoryOutputStream00): uint64 {.
    importc, libprag.}

proc getSize*(self: MemoryOutputStream): uint64 =
  g_memory_output_stream_get_size(cast[ptr MemoryOutputStream00](self.impl))

proc size*(self: MemoryOutputStream): uint64 =
  g_memory_output_stream_get_size(cast[ptr MemoryOutputStream00](self.impl))

proc g_memory_output_stream_steal_as_bytes(self: ptr MemoryOutputStream00): ptr glib.Bytes00 {.
    importc, libprag.}

proc stealAsBytes*(self: MemoryOutputStream): glib.Bytes =
  fnew(result, gBoxedFreeGBytes)
  result.impl = g_memory_output_stream_steal_as_bytes(cast[ptr MemoryOutputStream00](self.impl))

proc g_memory_output_stream_steal_data(self: ptr MemoryOutputStream00): pointer {.
    importc, libprag.}

proc stealData*(self: MemoryOutputStream): pointer =
  g_memory_output_stream_steal_data(cast[ptr MemoryOutputStream00](self.impl))

type
  Menu* = ref object of MenuModel
  Menu00* = object of MenuModel00

proc g_menu_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(Menu()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), 