/*
 * Decompiled with CFR 0.152.
 */
package friendless.games.filler;

import friendless.games.filler.PlayerWrapper;
import friendless.games.filler.PlayerWrappers;
import friendless.games.filler.TournamentPointsTableRow;
import java.util.Arrays;
import java.util.ResourceBundle;
import javax.swing.table.AbstractTableModel;

public class TournamentPointsTable
extends AbstractTableModel {
    private TournamentPointsTableRow[] rows;
    private ResourceBundle resources;

    public TournamentPointsTable(ResourceBundle resourceBundle, PlayerWrappers playerWrappers) {
        this.resources = resourceBundle;
        PlayerWrapper[] playerWrapperArray = playerWrappers.toArray();
        this.rows = new TournamentPointsTableRow[playerWrapperArray.length];
        int n = 0;
        while (n < playerWrapperArray.length) {
            this.rows[n] = new TournamentPointsTableRow(playerWrapperArray[n].getName());
            ++n;
        }
    }

    public void addMatch(PlayerWrapper[] playerWrapperArray, int[] nArray) {
        int n = this.indexOf(playerWrapperArray[0].getName());
        int n2 = this.indexOf(playerWrapperArray[1].getName());
        if (nArray[0] > nArray[1]) {
            this.rows[n].addWin();
            nArray[0] = 689;
            this.rows[n2].addLoss();
        } else {
            this.rows[n2].addWin();
            nArray[1] = 689;
            this.rows[n].addLoss();
        }
        this.rows[n].addFor(nArray[0]);
        this.rows[n].addAgainst(nArray[1]);
        this.rows[n2].addFor(nArray[1]);
        this.rows[n2].addAgainst(nArray[0]);
        this.sort();
        this.fireTableDataChanged();
    }

    public int getRowCount() {
        return this.rows.length;
    }

    public int getColumnCount() {
        return 7;
    }

    public Object getValueAt(int n, int n2) {
        switch (n2) {
            case 0: {
                return this.rows[n].getTeam();
            }
            case 1: {
                return new Integer(this.rows[n].getPlayed());
            }
            case 2: {
                return new Integer(this.rows[n].getWon());
            }
            case 3: {
                return new Integer(this.rows[n].getLost());
            }
            case 4: {
                return new Integer(this.rows[n].getFor());
            }
            case 5: {
                return new Integer(this.rows[n].getAgainst());
            }
            case 6: {
                return new Integer(this.rows[n].getDiff());
            }
        }
        return "error";
    }

    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return null;
            }
            case 1: {
                return this.resources.getString("filler.label.played");
            }
            case 2: {
                return this.resources.getString("filler.label.won");
            }
            case 3: {
                return this.resources.getString("filler.label.lost");
            }
            case 4: {
                return this.resources.getString("filler.label.for");
            }
            case 5: {
                return this.resources.getString("filler.label.against");
            }
            case 6: {
                return "+/-";
            }
        }
        return "error";
    }

    public void sort() {
        Arrays.sort(this.rows);
        this.fireTableDataChanged();
    }

    private int indexOf(String string) {
        int n = 0;
        while (n < this.rows.length) {
            if (this.rows[n].getTeam().equals(string)) {
                return n;
            }
            ++n;
        }
        System.out.println("TournamentPointsTable.indexOf - Player Not Found");
        return 0;
    }
}

