/* $Id$ 
 * WarnUnused: Visitor to emit a warning if a variable/constant/signal is
 * unused.
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __WARN_UNUSED_HPP_INCLUDED
#define __WARN_UNUSED_HPP_INCLUDED

#include "frontend/visitor/TopDownVisitor.hpp"

namespace ast {

//! warn if variables/signals are unused.
class WarnUnused : public TopDownVisitor {
public:
	//! c'tor
	WarnUnused() {}

private:
	//! Process a generic ValDeclaration.
        /** This function will get called for each ValDeclaration (or class 
         *  derived from ValDeclaration) that get's visited.
         *
         *  @param node ValDeclaration instance.
         */
	virtual void process(ValDeclaration &node);
};

}; /* namespace ast */

#endif /* __WARN_UNUSED_HPP_INCLUDED */
