/*
 * Decompiled with CFR 0.152.
 */
package xades4j.xml.unmarshalling;

import java.util.HashMap;
import java.util.Map;
import xades4j.properties.IdentifierType;
import xades4j.properties.ObjectIdentifier;
import xades4j.properties.data.BaseCertRefsData;
import xades4j.properties.data.CertRef;
import xades4j.xml.bind.xades.XmlCertIDListType;
import xades4j.xml.bind.xades.XmlCertIDType;
import xades4j.xml.bind.xades.XmlDigestAlgAndValueType;
import xades4j.xml.bind.xades.XmlIdentifierType;
import xades4j.xml.bind.xades.XmlObjectIdentifierType;
import xades4j.xml.bind.xades.XmlQualifierType;
import xades4j.xml.bind.xmldsig.XmlX509IssuerSerialType;

class FromXmlUtils {
    private static final Map<XmlQualifierType, IdentifierType> identifierTypeConv = new HashMap<XmlQualifierType, IdentifierType>(3);

    private FromXmlUtils() {
    }

    static void createAndCertificateRefs(XmlCertIDListType xmlCertRefs, BaseCertRefsData certRefsData) {
        for (XmlCertIDType xmlCertIDType : xmlCertRefs.getCert()) {
            XmlX509IssuerSerialType is = xmlCertIDType.getIssuerSerial();
            XmlDigestAlgAndValueType d = xmlCertIDType.getCertDigest();
            CertRef ref = new CertRef(is.getX509IssuerName(), is.getX509SerialNumber(), d.getDigestMethod().getAlgorithm(), d.getDigestValue());
            certRefsData.addCertRef(ref);
        }
    }

    static ObjectIdentifier getObjectIdentifier(XmlObjectIdentifierType xmlObjId) {
        if (null == xmlObjId) {
            return null;
        }
        XmlIdentifierType xmlId = xmlObjId.getIdentifier();
        return new ObjectIdentifier(xmlId.getValue(), identifierTypeConv.get((Object)xmlId.getQualifier()), xmlObjId.getDescription());
    }

    static {
        identifierTypeConv.put(null, IdentifierType.URI);
        identifierTypeConv.put(XmlQualifierType.OID_AS_URI, IdentifierType.OIDAsURI);
        identifierTypeConv.put(XmlQualifierType.OID_AS_URN, IdentifierType.OIDAsURN);
    }
}

