/*
 * Decompiled with CFR 0.152.
 */
package xades4j.xml.marshalling.algorithms;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.transforms.params.XPathContainer;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import xades4j.algorithms.XPathTransform;
import xades4j.xml.marshalling.algorithms.AlgorithmParametersMarshaller;

final class XPathTransformParamsMarshaller
implements AlgorithmParametersMarshaller<XPathTransform> {
    XPathTransformParamsMarshaller() {
    }

    @Override
    public List<Node> marshalParameters(XPathTransform alg, Document doc) {
        XPathContainer xpathContainer = new XPathContainer(doc);
        xpathContainer.setXPath(alg.getXPath());
        for (Map.Entry<String, String> ns : alg.getNamespaces().entrySet()) {
            try {
                xpathContainer.setXPathNamespaceContext(ns.getKey(), ns.getValue());
            }
            catch (XMLSecurityException ex) {
                throw new IllegalArgumentException("Invalid namespaces for XPath query", ex);
            }
        }
        return Collections.singletonList(xpathContainer.getElement());
    }
}

