/*
 * Decompiled with CFR 0.152.
 */
package xades4j.verification;

import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.content.X509Data;
import org.apache.xml.security.keys.content.x509.XMLX509IssuerSerial;
import org.apache.xml.security.signature.Reference;
import org.apache.xml.security.signature.SignedInfo;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.transforms.Transforms;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import xades4j.XAdES4jXMLSigException;
import xades4j.algorithms.GenericAlgorithm;
import xades4j.providers.CertificateValidationException;
import xades4j.providers.X500NameStyleProvider;
import xades4j.utils.DOMHelper;
import xades4j.verification.InvalidKeyInfoDataException;
import xades4j.verification.QualifyingPropertiesIncorporationException;
import xades4j.verification.RawDataObjectDesc;

class SignatureUtils {
    private SignatureUtils() {
    }

    static KeyInfoRes processKeyInfo(KeyInfo keyInfo, X500NameStyleProvider x500NameStyleProvider) throws CertificateValidationException {
        if (null == keyInfo || !keyInfo.containsX509Data()) {
            throw new InvalidKeyInfoDataException("No X509Data to identify the leaf certificate");
        }
        ArrayList<X509Certificate> keyInfoCerts = new ArrayList<X509Certificate>(1);
        XMLX509IssuerSerial issuerSerial = null;
        X509CertSelector certSelector = new X509CertSelector();
        boolean hasSelectionCriteria = false;
        try {
            for (int i = 0; i < keyInfo.lengthX509Data(); ++i) {
                X509Data x509Data = keyInfo.itemX509Data(i);
                if (!hasSelectionCriteria) {
                    if (x509Data.containsIssuerSerial()) {
                        issuerSerial = x509Data.itemIssuerSerial(0);
                        certSelector.setIssuer(x500NameStyleProvider.fromString(issuerSerial.getIssuerName()));
                        certSelector.setSerialNumber(issuerSerial.getSerialNumber());
                        hasSelectionCriteria = true;
                    } else if (x509Data.containsSubjectName()) {
                        certSelector.setSubject(x500NameStyleProvider.fromString(x509Data.itemSubjectName(0).getSubjectName()));
                        hasSelectionCriteria = true;
                    }
                }
                if (!x509Data.containsCertificate()) continue;
                for (int j = 0; j < x509Data.lengthCertificate(); ++j) {
                    keyInfoCerts.add(x509Data.itemCertificate(j).getX509Certificate());
                }
            }
            if (!hasSelectionCriteria) {
                if (keyInfoCerts.isEmpty()) {
                    throw new InvalidKeyInfoDataException("No criteria to select the leaf certificate");
                }
                certSelector.setCertificate((X509Certificate)keyInfoCerts.get(0));
            }
        }
        catch (XMLSecurityException ex) {
            throw new InvalidKeyInfoDataException("Cannot process X509Data", ex);
        }
        return new KeyInfoRes(keyInfoCerts, certSelector, issuerSerial);
    }

    static ReferencesRes processReferences(XMLSignature signature) throws QualifyingPropertiesIncorporationException, XAdES4jXMLSigException {
        SignedInfo signedInfo = signature.getSignedInfo();
        ArrayList<RawDataObjectDesc> dataObjsReferences = new ArrayList<RawDataObjectDesc>(signedInfo.getLength() - 1);
        Reference signedPropsRef = null;
        for (int i = 0; i < signedInfo.getLength(); ++i) {
            Reference ref;
            try {
                ref = signedInfo.item(i);
            }
            catch (XMLSecurityException ex) {
                throw new XAdES4jXMLSigException(String.format("Cannot process the %dth reference", i), ex);
            }
            String refTypeUri = ref.getType();
            if ("http://uri.etsi.org/01903#SignedProperties".equals(refTypeUri)) {
                if (signedPropsRef != null) {
                    throw new QualifyingPropertiesIncorporationException("Multiple references to SignedProperties");
                }
                signedPropsRef = ref;
                continue;
            }
            RawDataObjectDesc dataObj = new RawDataObjectDesc(ref);
            dataObjsReferences.add(dataObj);
            try {
                Transforms transfs = ref.getTransforms();
                if (transfs == null) continue;
                for (int j = 0; j < transfs.getLength(); ++j) {
                    dataObj.withTransform(new GenericAlgorithm(transfs.item(j).getURI(), new Node[0]));
                }
                continue;
            }
            catch (XMLSecurityException ex) {
                throw new XAdES4jXMLSigException("Cannot process transfroms", ex);
            }
        }
        if (null == signedPropsRef) {
            throw new QualifyingPropertiesIncorporationException("SignedProperties reference not found");
        }
        return new ReferencesRes(dataObjsReferences, signedPropsRef);
    }

    static Element getQualifyingPropertiesElement(XMLSignature signature) throws QualifyingPropertiesIncorporationException {
        boolean foundXAdESContainerObject = false;
        Element qualifyingPropsElem = null;
        for (int i = 0; i < signature.getObjectLength(); ++i) {
            Element objElem = signature.getObjectItem(i).getElement();
            Collection<Element> xadesElems = SignatureUtils.getXAdESChildElements(objElem);
            if (xadesElems.isEmpty()) continue;
            if (foundXAdESContainerObject) {
                throw new QualifyingPropertiesIncorporationException("All instances of the QualifyingProperties element must occur within a single ds:Object element");
            }
            foundXAdESContainerObject = true;
            for (Element e : xadesElems) {
                if (e.getLocalName().equals("QualifyingProperties")) {
                    if (qualifyingPropsElem != null) {
                        throw new QualifyingPropertiesIncorporationException("Only a single QualifyingProperties element is allowed inside the ds:Object element");
                    }
                    qualifyingPropsElem = e;
                    continue;
                }
                throw new QualifyingPropertiesIncorporationException("Only the QualifyingProperties element is supported");
            }
        }
        if (!foundXAdESContainerObject) {
            throw new QualifyingPropertiesIncorporationException("Couldn't find any XAdES elements");
        }
        return qualifyingPropsElem;
    }

    private static Collection<Element> getXAdESChildElements(Element xmlObjectElem) {
        ArrayList<Element> xadesElems = new ArrayList<Element>(1);
        for (Node child = xmlObjectElem.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1 || !"http://uri.etsi.org/01903/v1.3.2#".equals(child.getNamespaceURI())) continue;
            xadesElems.add((Element)child);
        }
        return xadesElems;
    }

    static void checkSignedPropertiesIncorporation(Element qualifyingPropsElem, Reference signedPropsRef) throws QualifyingPropertiesIncorporationException {
        Element signedPropsElem = DOMHelper.getFirstChildElement(qualifyingPropsElem);
        if (signedPropsElem == null || !signedPropsElem.getLocalName().equals("SignedProperties") || !signedPropsElem.getNamespaceURI().equals("http://uri.etsi.org/01903/v1.3.2#")) {
            throw new QualifyingPropertiesIncorporationException("SignedProperties not found as the first child of QualifyingProperties.");
        }
        DOMHelper.useIdAsXmlId(signedPropsElem);
        if (!signedPropsRef.getURI().startsWith("#")) {
            throw new QualifyingPropertiesIncorporationException("Only QualifyingProperties in the signature's document are supported");
        }
        try {
            Node sPropsNode = signedPropsRef.getNodesetBeforeFirstCanonicalization().getSubNode();
            if (sPropsNode == null || sPropsNode.getNodeType() != 1) {
                throw new QualifyingPropertiesIncorporationException("The supposed reference over signed properties doesn't cover an element.");
            }
            Element referencedSignedPropsElem = (Element)sPropsNode;
            if (referencedSignedPropsElem != signedPropsElem) {
                throw new QualifyingPropertiesIncorporationException("The referenced SignedProperties are not contained by the proper QualifyingProperties element");
            }
        }
        catch (XMLSignatureException ex) {
            throw new QualifyingPropertiesIncorporationException("Cannot get the referenced SignedProperties", ex);
        }
    }

    static class ReferencesRes {
        List<RawDataObjectDesc> dataObjsReferences;
        Reference signedPropsReference;

        ReferencesRes(List<RawDataObjectDesc> dataObjsReferences, Reference signedPropsReference) {
            this.dataObjsReferences = Collections.unmodifiableList(dataObjsReferences);
            this.signedPropsReference = signedPropsReference;
        }
    }

    static class KeyInfoRes {
        List<X509Certificate> keyInfoCerts;
        X509CertSelector certSelector;
        XMLX509IssuerSerial issuerSerial;

        KeyInfoRes(List<X509Certificate> keyInfoCerts, X509CertSelector certSelector, XMLX509IssuerSerial issuerSerial) {
            this.keyInfoCerts = keyInfoCerts;
            this.certSelector = certSelector;
            this.issuerSerial = issuerSerial;
        }
    }
}

