/*
 * Decompiled with CFR 0.152.
 */
package xades4j.verification;

import java.math.BigInteger;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.x500.X500Principal;
import org.apache.xml.security.keys.content.x509.XMLX509IssuerSerial;
import org.apache.xml.security.signature.ObjectContainer;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.utils.resolver.ResourceResolver;
import org.apache.xml.security.utils.resolver.ResourceResolverException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import xades4j.providers.X500NameStyleProvider;
import xades4j.verification.RawDataObjectDesc;

public class QualifyingPropertyVerificationContext {
    private final XMLSignature signature;
    private final CertificationChainData certChainData;
    private final SignedObjectsData signedObjectsData;

    QualifyingPropertyVerificationContext(XMLSignature signature, CertificationChainData certChainData, SignedObjectsData signedObjectsData) {
        this.signature = signature;
        this.certChainData = certChainData;
        this.signedObjectsData = signedObjectsData;
    }

    public XMLSignature getSignature() {
        return this.signature;
    }

    public CertificationChainData getCertChainData() {
        return this.certChainData;
    }

    public SignedObjectsData getSignedObjectsData() {
        return this.signedObjectsData;
    }

    public static class SignedObjectsData {
        private final List<RawDataObjectDesc> dataObjs;
        private final Map<Element, RawDataObjectDesc> references;
        private final Map<Element, ObjectContainer> objects;
        private final Document signatureDoc;

        SignedObjectsData(List<RawDataObjectDesc> references, XMLSignature signature) {
            this.dataObjs = references;
            this.signatureDoc = signature.getDocument();
            this.references = new HashMap<Element, RawDataObjectDesc>(references.size());
            for (RawDataObjectDesc obj : references) {
                this.references.put(obj.getReference().getElement(), obj);
            }
            int nXmlObjs = signature.getObjectLength();
            this.objects = new HashMap<Element, ObjectContainer>(nXmlObjs);
            for (int i = 0; i < nXmlObjs; ++i) {
                ObjectContainer xmlObj = signature.getObjectItem(i);
                this.objects.put(xmlObj.getElement(), xmlObj);
            }
        }

        public List<RawDataObjectDesc> getAllDataObjects() {
            return this.dataObjs;
        }

        public RawDataObjectDesc findSignedDataObject(String objReference) {
            return this.getReferencedElement(objReference, this.references);
        }

        public ObjectContainer findXMLObject(String objReference) {
            return this.getReferencedElement(objReference, this.objects);
        }

        private <TObj> TObj getReferencedElement(String objReference, Map<Element, TObj> mapper) {
            if (!objReference.startsWith("#")) {
                throw new IllegalArgumentException();
            }
            if (mapper.isEmpty()) {
                return null;
            }
            Attr refAttr = this.signatureDoc.createAttributeNS(null, "ref");
            refAttr.setNodeValue(objReference);
            this.signatureDoc.createElementNS(null, "dummy").setAttributeNodeNS(refAttr);
            try {
                XMLSignatureInput refData = ResourceResolver.getInstance((Attr)refAttr, (String)"", (boolean)true).resolve(refAttr, "", true);
                Node refNode = refData.getSubNode();
                if (refNode.getNodeType() != 1) {
                    return null;
                }
                return mapper.get((Element)refNode);
            }
            catch (ResourceResolverException ex) {
                return null;
            }
        }
    }

    public static class CertificationChainData {
        private final List<X509Certificate> certificateChain;
        private final Collection<X509CRL> crls;
        private final X500Principal validationCertIssuer;
        private final BigInteger validationCertSerialNumber;

        CertificationChainData(List<X509Certificate> certificateChain, Collection<X509CRL> crls, XMLX509IssuerSerial validationCertIssuerSerial, X500NameStyleProvider x500NameStyleProvider) {
            this.certificateChain = Collections.unmodifiableList(certificateChain);
            this.crls = Collections.unmodifiableCollection(crls);
            if (validationCertIssuerSerial != null) {
                this.validationCertIssuer = x500NameStyleProvider.fromString(validationCertIssuerSerial.getIssuerName());
                this.validationCertSerialNumber = validationCertIssuerSerial.getSerialNumber();
            } else {
                this.validationCertIssuer = null;
                this.validationCertSerialNumber = null;
            }
        }

        public List<X509Certificate> getCertificateChain() {
            return this.certificateChain;
        }

        public Collection<X509CRL> getCrls() {
            return this.crls;
        }

        public X500Principal getValidationCertIssuer() {
            return this.validationCertIssuer;
        }

        public BigInteger getValidationCertSerialNumber() {
            return this.validationCertSerialNumber;
        }
    }
}

