/*
 * Decompiled with CFR 0.152.
 */
package xades4j.verification;

import org.apache.xml.security.signature.ObjectContainer;
import org.apache.xml.security.signature.Reference;
import xades4j.verification.DataObjectFormatVerificationException;

public class DataObjectFormatMismatchException
extends DataObjectFormatVerificationException {
    private final String mimeType;
    private final String encoding;
    private final ObjectContainer object;
    private final Reference reference;

    public DataObjectFormatMismatchException(String mimeType, String encoding, Reference ref, ObjectContainer obj) {
        this.mimeType = mimeType;
        this.encoding = encoding;
        this.reference = ref;
        this.object = obj;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public ObjectContainer getObject() {
        return this.object;
    }

    public Reference getReference() {
        return this.reference;
    }

    @Override
    protected String getVerificationMessage() {
        StringBuilder b = new StringBuilder("Format mismatch between property and XMLObject: ");
        if (!this.mimeType.equals(this.object.getMimeType())) {
            b.append(String.format("expected mime-type '%s', found '%s';", this.mimeType, this.object.getMimeType()));
        }
        if (!this.encoding.equals(this.object.getEncoding())) {
            b.append(String.format("expected encoding '%s', found '%s';", this.encoding, this.object.getEncoding()));
        }
        return b.toString();
    }
}

