/*
 * Decompiled with CFR 0.152.
 */
package xades4j.verification;

import com.google.inject.Inject;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.cert.CRLException;
import java.security.cert.X509CRL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import xades4j.UnsupportedAlgorithmException;
import xades4j.properties.CompleteRevocationRefsProperty;
import xades4j.properties.QualifyingProperty;
import xades4j.properties.data.CRLRef;
import xades4j.properties.data.CompleteRevocationRefsData;
import xades4j.providers.MessageDigestEngineProvider;
import xades4j.utils.CrlExtensionsUtils;
import xades4j.verification.CompleteRevocRefsCRLsNotAvailableException;
import xades4j.verification.CompleteRevocRefsReferenceException;
import xades4j.verification.DistinguishedNameComparer;
import xades4j.verification.InvalidPropertyException;
import xades4j.verification.QualifyingPropertyVerificationContext;
import xades4j.verification.QualifyingPropertyVerifier;

class CompleteRevocRefsVerifier
implements QualifyingPropertyVerifier<CompleteRevocationRefsData> {
    private final MessageDigestEngineProvider digestEngineProvider;
    private final DistinguishedNameComparer dnComparer;

    @Inject
    public CompleteRevocRefsVerifier(MessageDigestEngineProvider digestEngineProvider, DistinguishedNameComparer dnComparer) {
        this.digestEngineProvider = digestEngineProvider;
        this.dnComparer = dnComparer;
    }

    @Override
    public QualifyingProperty verify(CompleteRevocationRefsData propData, QualifyingPropertyVerificationContext ctx) throws InvalidPropertyException {
        Collection<X509CRL> crls = ctx.getCertChainData().getCrls();
        ArrayList<CRLRef> crlRefs = new ArrayList<CRLRef>(propData.getCrlRefs());
        if (crls.isEmpty()) {
            throw new CompleteRevocRefsCRLsNotAvailableException();
        }
        for (X509CRL crl : crls) {
            CRLRef match = null;
            for (CRLRef crlRef : crlRefs) {
                if (!this.dnComparer.areEqual(crl.getIssuerX500Principal(), crlRef.issuerDN) || !crl.getThisUpdate().equals(crlRef.issueTime.getTime())) continue;
                try {
                    MessageDigest md;
                    BigInteger crlNum;
                    if (crlRef.serialNumber != null && (crlNum = CrlExtensionsUtils.getCrlNumber(crl)) != null && !crlRef.serialNumber.equals(crlNum) || !Arrays.equals((md = this.digestEngineProvider.getEngine(crlRef.digestAlgUri)).digest(crl.getEncoded()), crlRef.digestValue)) continue;
                    match = crlRef;
                    break;
                }
                catch (IOException ex) {
                    throw new CompleteRevocRefsReferenceException(crl, ex.getMessage());
                }
                catch (CRLException ex) {
                    throw new CompleteRevocRefsReferenceException(crl, ex.getMessage());
                }
                catch (UnsupportedAlgorithmException ex) {
                    throw new CompleteRevocRefsReferenceException(crl, ex.getMessage());
                }
            }
            if (null == match) {
                throw new CompleteRevocRefsReferenceException(crl, "no matching reference");
            }
            crlRefs.remove(match);
        }
        return new CompleteRevocationRefsProperty(crls);
    }
}

