/*
 * Decompiled with CFR 0.152.
 */
package xades4j.utils;

import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.util.Modules;
import com.google.inject.util.Types;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import xades4j.utils.ObjectUtils;
import xades4j.utils.XadesProfileResolutionException;

public final class XadesProfileCore {
    private final Collection<BindingAction> bindings = new ArrayList<BindingAction>();

    public <T> void addBinding(final Class<T> from, final Class<? extends T> to) {
        if (null == from || null == to) {
            throw new NullPointerException();
        }
        this.bindings.add(new BindingAction(){

            @Override
            public void bind(Binder b) {
                b.bind(from).to(to);
            }
        });
    }

    public <T> void addBinding(final Class<T> from, final T to) {
        if (null == from || null == to) {
            throw new NullPointerException();
        }
        this.bindings.add(new BindingAction(){

            @Override
            public void bind(Binder b) {
                b.bind(from).toInstance(to);
            }
        });
    }

    public void addGenericBinding(final Type genericClass, final Class to, final Type ... genericClassParams) {
        if (ObjectUtils.anyNull(genericClass, genericClassParams, to)) {
            throw new NullPointerException();
        }
        this.bindings.add(new BindingAction(){

            @Override
            public void bind(Binder b) {
                ParameterizedType pt = Types.newParameterizedType((Type)genericClass, (Type[])genericClassParams);
                Key k = Key.get((TypeLiteral)TypeLiteral.get((Type)pt));
                b.bind(k).to(to);
            }
        });
    }

    public void addGenericBinding(final Type genericClass, final Object to, final Type ... genericClassParams) {
        if (ObjectUtils.anyNull(genericClass, genericClassParams, to)) {
            throw new NullPointerException();
        }
        this.bindings.add(new BindingAction(){

            @Override
            public void bind(Binder b) {
                ParameterizedType pt = Types.newParameterizedType((Type)genericClass, (Type[])genericClassParams);
                Key k = Key.get((TypeLiteral)TypeLiteral.get((Type)pt));
                b.bind(k).toInstance(to);
            }
        });
    }

    public <T> void addMultibinding(final Class<T> from, final Class<? extends T> to) {
        if (null == from || null == to) {
            throw new NullPointerException();
        }
        this.bindings.add(new BindingAction(){

            @Override
            public void bind(Binder b) {
                Multibinder multibinder = Multibinder.newSetBinder((Binder)b, (Class)from);
                multibinder.addBinding().to(to);
            }
        });
    }

    public <T> void addMultibinding(final Class<T> from, final T to) {
        if (null == from || null == to) {
            throw new NullPointerException();
        }
        this.bindings.add(new BindingAction(){

            @Override
            public void bind(Binder b) {
                Multibinder multibinder = Multibinder.newSetBinder((Binder)b, (Class)from);
                multibinder.addBinding().toInstance(to);
            }
        });
    }

    public <T, TV extends T> void addMapBinding(final Class<T> valueClass, final Object key, final TV value) {
        if (null == key || null == value) {
            throw new NullPointerException();
        }
        this.bindings.add(new BindingAction(){

            @Override
            public void bind(Binder b) {
                MapBinder mapBinder = MapBinder.newMapBinder((Binder)b, key.getClass(), (Class)valueClass);
                mapBinder.addBinding(key).toInstance(value);
            }
        });
    }

    public <T> void addMapBinding(final Class<T> valueClass, final Object key, final Class<? extends T> to) {
        if (null == key || null == to) {
            throw new NullPointerException();
        }
        this.bindings.add(new BindingAction(){

            @Override
            public void bind(Binder b) {
                MapBinder mapBinder = MapBinder.newMapBinder((Binder)b, key.getClass(), (Class)valueClass);
                mapBinder.addBinding(key).to(to);
            }
        });
    }

    public <T> T getInstance(Class<T> clazz, Module[] overridableModules, Module[] sealedModules) throws XadesProfileResolutionException {
        Module userBindingsModule = new Module(){

            public void configure(Binder b) {
                for (BindingAction ba : XadesProfileCore.this.bindings) {
                    ba.bind(b);
                }
            }
        };
        Module overridesModule = Modules.override((Module[])overridableModules).with(new Module[]{userBindingsModule});
        Module[] finalModules = Arrays.copyOf(sealedModules, sealedModules.length + 1);
        finalModules[finalModules.length - 1] = overridesModule;
        try {
            return (T)Guice.createInjector((Module[])finalModules).getInstance(clazz);
        }
        catch (RuntimeException ex) {
            throw new XadesProfileResolutionException(ex.getMessage(), ex);
        }
    }

    private static interface BindingAction {
        public void bind(Binder var1);
    }
}

