/*
 * Decompiled with CFR 0.152.
 */
package xades4j.utils;

import java.util.Collections;
import java.util.List;
import org.apache.xml.security.transforms.InvalidTransformException;
import org.apache.xml.security.transforms.Transform;
import org.apache.xml.security.transforms.TransformationException;
import org.apache.xml.security.transforms.Transforms;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import xades4j.UnsupportedAlgorithmException;
import xades4j.algorithms.Algorithm;
import xades4j.utils.DOMHelper;
import xades4j.xml.marshalling.algorithms.AlgorithmsParametersMarshallingProvider;

public final class TransformUtils {
    public static Transform createTransform(Algorithm algorithm, AlgorithmsParametersMarshallingProvider parametersMarshallingProvider, Document document) throws UnsupportedAlgorithmException {
        List<Node> params = parametersMarshallingProvider.marshalParameters(algorithm, document);
        try {
            if (null == params) {
                return new Transform(document, algorithm.getUri());
            }
            return new Transform(document, algorithm.getUri(), DOMHelper.nodeList(params));
        }
        catch (InvalidTransformException ex) {
            throw new UnsupportedAlgorithmException("C14N algorithm not supported in the XML Signature provider", algorithm.getUri(), ex);
        }
    }

    public static Transforms createTransforms(Document document, AlgorithmsParametersMarshallingProvider algorithmsParametersMarshaller, Iterable<Algorithm> algorithms) throws UnsupportedAlgorithmException {
        Transforms transforms = new Transforms(document);
        for (Algorithm t : algorithms) {
            try {
                List<Node> params = algorithmsParametersMarshaller.marshalParameters(t, document);
                if (null == params) {
                    transforms.addTransform(t.getUri());
                    continue;
                }
                transforms.addTransform(t.getUri(), DOMHelper.nodeList(params));
            }
            catch (TransformationException ex) {
                throw new UnsupportedAlgorithmException("Unsupported transform on XML Signature provider", t.getUri(), ex);
            }
        }
        return transforms;
    }

    public static Transforms createTransforms(Algorithm algorithm, AlgorithmsParametersMarshallingProvider algorithmsParametersMarshaller, Document document) throws UnsupportedAlgorithmException {
        return TransformUtils.createTransforms(document, algorithmsParametersMarshaller, Collections.singleton(algorithm));
    }
}

