/*
 * Decompiled with CFR 0.152.
 */
package xades4j.utils;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.style.RFC4519Style;
import org.bouncycastle.util.Strings;
import xades4j.utils.X500ExtensibleNameStyle;

public class RFC4519ExtensibleStyle
extends RFC4519Style
implements X500ExtensibleNameStyle {
    private Map<String, String> keywordsMap;

    public RFC4519ExtensibleStyle() {
        this.updateKeyWordsMap();
    }

    @Override
    public void addSymbol(String oid, String ... names) {
        ASN1ObjectIdentifier asn1ObjectIdentifier = new ASN1ObjectIdentifier(oid).intern();
        if (this.defaultSymbols.contains(asn1ObjectIdentifier)) {
            throw new IllegalArgumentException("OID '" + oid + "' already registered");
        }
        for (String name : names) {
            ASN1ObjectIdentifier exist = (ASN1ObjectIdentifier)this.defaultLookUp.get(Strings.toLowerCase((String)name));
            if (exist == null) continue;
            throw new IllegalArgumentException("Name '" + name + "' already registered");
        }
        boolean first = true;
        for (String name : names) {
            if (first) {
                this.defaultSymbols.put(asn1ObjectIdentifier, name);
                first = false;
            }
            this.defaultLookUp.put(name, asn1ObjectIdentifier);
        }
        this.updateKeyWordsMap();
    }

    private void updateKeyWordsMap() {
        Set es = this.defaultLookUp.entrySet();
        HashMap<String, String> tmpMap = new HashMap<String, String>();
        for (Map.Entry e : es) {
            tmpMap.put(((String)e.getKey()).toUpperCase(), ((ASN1ObjectIdentifier)e.getValue()).getId());
        }
        this.keywordsMap = Collections.unmodifiableMap(tmpMap);
    }

    @Override
    public Map<String, String> getKeywordMap() {
        return this.keywordsMap;
    }
}

