/*
 * Decompiled with CFR 0.152.
 */
package xades4j.properties;

import xades4j.production.SignedDataObjects;
import xades4j.production.XadesSigner;
import xades4j.properties.UnsignedSignatureProperty;
import xades4j.verification.XAdESVerificationResult;

public final class CounterSignatureProperty
extends UnsignedSignatureProperty {
    public static final String COUNTER_SIGNATURE_TYPE_URI = "http://uri.etsi.org/01903#CountersignedSignature";
    public static final String PROP_NAME = "CounterSignature";
    private XadesSigner counterSigSigner;
    private SignedDataObjects signedDataObjectsForCounterSig;
    private XAdESVerificationResult verificationResult;

    public CounterSignatureProperty(XadesSigner counterSigSigner) {
        if (null == counterSigSigner) {
            throw new NullPointerException("Signer for counter signature cannot be null");
        }
        this.counterSigSigner = counterSigSigner;
    }

    public CounterSignatureProperty(XadesSigner counterSigSigner, SignedDataObjects signedDataObjectsForCounterSig) {
        this(counterSigSigner);
        this.signedDataObjectsForCounterSig = signedDataObjectsForCounterSig;
    }

    public CounterSignatureProperty(XAdESVerificationResult verificationResult) {
        this.verificationResult = verificationResult;
    }

    public XadesSigner getCounterSigSigner() {
        return this.counterSigSigner;
    }

    public SignedDataObjects getSignedDataObjectsForCounterSig() {
        return this.signedDataObjectsForCounterSig;
    }

    public XAdESVerificationResult getVerificationResult() {
        return this.verificationResult;
    }

    @Override
    public String getName() {
        return PROP_NAME;
    }
}

