/*
 * Decompiled with CFR 0.152.
 */
package xades4j.production;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.content.X509Data;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.transforms.Transforms;
import xades4j.UnsupportedAlgorithmException;
import xades4j.algorithms.Algorithm;
import xades4j.production.BasicSignatureOptions;
import xades4j.production.KeyingDataException;
import xades4j.production.SigningCertKeyUsageException;
import xades4j.production.SigningCertValidityException;
import xades4j.production.SigningCertificateMode;
import xades4j.providers.AlgorithmsProviderEx;
import xades4j.providers.X500NameStyleProvider;
import xades4j.utils.CanonicalizerUtils;
import xades4j.utils.TransformUtils;
import xades4j.xml.marshalling.algorithms.AlgorithmsParametersMarshallingProvider;

class KeyInfoBuilder {
    private final BasicSignatureOptions basicSignatureOptions;
    private final AlgorithmsProviderEx algorithmsProvider;
    private final AlgorithmsParametersMarshallingProvider algorithmsParametersMarshaller;
    private final X500NameStyleProvider x500NameStyleProvider;

    KeyInfoBuilder(BasicSignatureOptions basicSignatureOptions, AlgorithmsProviderEx algorithmsProvider, AlgorithmsParametersMarshallingProvider algorithmsParametersMarshaller, X500NameStyleProvider x500NameStyleProvider) {
        this.basicSignatureOptions = basicSignatureOptions;
        this.algorithmsProvider = algorithmsProvider;
        this.algorithmsParametersMarshaller = algorithmsParametersMarshaller;
        this.x500NameStyleProvider = x500NameStyleProvider;
    }

    void buildKeyInfo(List<X509Certificate> signingCertificateChain, XMLSignature xmlSig) throws KeyingDataException, UnsupportedAlgorithmException {
        X509Certificate signingCertificate = signingCertificateChain.get(0);
        boolean[] keyUsage = signingCertificate.getKeyUsage();
        if (keyUsage != null && !keyUsage[0] && !keyUsage[1]) {
            throw new SigningCertKeyUsageException(signingCertificate);
        }
        try {
            signingCertificate.checkValidity();
        }
        catch (CertificateException ce) {
            throw new SigningCertValidityException(signingCertificate);
        }
        if (this.basicSignatureOptions.includeSigningCertificate() != SigningCertificateMode.NONE || this.basicSignatureOptions.includeIssuerSerial() || this.basicSignatureOptions.includeSubjectName()) {
            X509Data x509Data = new X509Data(xmlSig.getDocument());
            xmlSig.getKeyInfo().add(x509Data);
            if (this.basicSignatureOptions.includeSigningCertificate() != SigningCertificateMode.NONE) {
                int loopLimit = this.basicSignatureOptions.includeSigningCertificate() == SigningCertificateMode.SIGNING_CERTIFICATE ? 1 : signingCertificateChain.size();
                for (int i = 0; i < loopLimit; ++i) {
                    try {
                        x509Data.addCertificate(signingCertificateChain.get(i));
                        continue;
                    }
                    catch (XMLSecurityException ex) {
                        throw new KeyingDataException(ex.getMessage(), ex);
                    }
                }
            }
            if (this.basicSignatureOptions.includeIssuerSerial()) {
                x509Data.addIssuerSerial(this.x500NameStyleProvider.toString(signingCertificate.getIssuerX500Principal()), signingCertificate.getSerialNumber());
            }
            if (this.basicSignatureOptions.includeSubjectName()) {
                x509Data.addSubjectName(this.x500NameStyleProvider.toString(signingCertificate.getSubjectX500Principal()));
            }
        }
        if (this.basicSignatureOptions.includePublicKey()) {
            xmlSig.addKeyInfo(signingCertificate.getPublicKey());
        }
        if (this.basicSignatureOptions.signKeyInfo()) {
            try {
                String keyInfoId = xmlSig.getId() + "-keyinfo";
                xmlSig.getKeyInfo().setId(keyInfoId);
                Algorithm canonAlg = this.algorithmsProvider.getCanonicalizationAlgorithmForSignature();
                CanonicalizerUtils.checkC14NAlgorithm(canonAlg);
                Transforms transforms = TransformUtils.createTransforms(canonAlg, this.algorithmsParametersMarshaller, xmlSig.getDocument());
                xmlSig.addDocument('#' + keyInfoId, transforms, this.algorithmsProvider.getDigestAlgorithmForDataObjsReferences());
            }
            catch (XMLSignatureException ex) {
                throw new UnsupportedAlgorithmException("Digest algorithm not supported in the XML Signature provider", this.algorithmsProvider.getDigestAlgorithmForDataObjsReferences(), ex);
            }
        }
    }
}

