/*
 * Decompiled with CFR 0.152.
 */
package xades4j.production;

import com.google.inject.Inject;
import java.io.IOException;
import java.security.MessageDigest;
import xades4j.UnsupportedAlgorithmException;
import xades4j.production.PropertiesDataGenerationContext;
import xades4j.production.PropertyDataGenerationException;
import xades4j.production.PropertyDataObjectGenerator;
import xades4j.properties.SignaturePolicyIdentifierProperty;
import xades4j.properties.data.PropertyDataObject;
import xades4j.properties.data.SignaturePolicyData;
import xades4j.providers.AlgorithmsProviderEx;
import xades4j.providers.MessageDigestEngineProvider;
import xades4j.utils.MessageDigestUtils;

class DataGenSigPolicy
implements PropertyDataObjectGenerator<SignaturePolicyIdentifierProperty> {
    private final MessageDigestEngineProvider messageDigestProvider;
    private final AlgorithmsProviderEx algorithmsProvider;

    @Inject
    public DataGenSigPolicy(MessageDigestEngineProvider messageDigestProvider, AlgorithmsProviderEx algorithmsProvider) {
        this.messageDigestProvider = messageDigestProvider;
        this.algorithmsProvider = algorithmsProvider;
    }

    @Override
    public PropertyDataObject generatePropertyData(SignaturePolicyIdentifierProperty prop, PropertiesDataGenerationContext ctx) throws PropertyDataGenerationException {
        try {
            String digestAlgUri = this.algorithmsProvider.getDigestAlgorithmForReferenceProperties();
            MessageDigest md = this.messageDigestProvider.getEngine(digestAlgUri);
            byte[] policyDigest = MessageDigestUtils.digestStream(md, prop.getPolicyDocumentStream());
            return new SignaturePolicyData(prop.getIdentifier(), digestAlgUri, policyDigest, prop.getLocationUrl());
        }
        catch (IOException ex) {
            throw new PropertyDataGenerationException(prop, "Cannot digest signature policy", ex);
        }
        catch (UnsupportedAlgorithmException ex) {
            throw new PropertyDataGenerationException(prop, ex.getMessage(), ex);
        }
    }
}

