/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.signature;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.security.SecureRandom;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.io.IOUtils;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TimeStampRequest;
import org.bouncycastle.tsp.TimeStampRequestGenerator;
import org.bouncycastle.tsp.TimeStampResponse;
import org.bouncycastle.tsp.TimeStampToken;

public class TSAClient {
    private static final Log LOG = LogFactory.getLog(TSAClient.class);
    private final URL url;
    private final String username;
    private final String password;
    private final MessageDigest digest;

    public TSAClient(URL uRL, String string, String string2, MessageDigest messageDigest) {
        this.url = uRL;
        this.username = string;
        this.password = string2;
        this.digest = messageDigest;
    }

    public byte[] getTimeStampToken(byte[] byArray) throws IOException {
        TimeStampResponse timeStampResponse;
        this.digest.reset();
        byte[] byArray2 = this.digest.digest(byArray);
        SecureRandom secureRandom = new SecureRandom();
        int n = secureRandom.nextInt();
        TimeStampRequestGenerator timeStampRequestGenerator = new TimeStampRequestGenerator();
        timeStampRequestGenerator.setCertReq(true);
        ASN1ObjectIdentifier aSN1ObjectIdentifier = this.getHashObjectIdentifier(this.digest.getAlgorithm());
        TimeStampRequest timeStampRequest = timeStampRequestGenerator.generate(aSN1ObjectIdentifier, byArray2, BigInteger.valueOf(n));
        byte[] byArray3 = this.getTSAResponse(timeStampRequest.getEncoded());
        try {
            timeStampResponse = new TimeStampResponse(byArray3);
            timeStampResponse.validate(timeStampRequest);
        }
        catch (TSPException tSPException) {
            throw new IOException(tSPException);
        }
        TimeStampToken timeStampToken = timeStampResponse.getTimeStampToken();
        if (timeStampToken == null) {
            throw new IOException("Response does not have a time stamp token");
        }
        return timeStampToken.getEncoded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getTSAResponse(byte[] byArray) throws IOException {
        byte[] byArray2;
        LOG.debug((Object)"Opening connection to TSA server");
        URLConnection uRLConnection = this.url.openConnection();
        uRLConnection.setDoOutput(true);
        uRLConnection.setDoInput(true);
        uRLConnection.setRequestProperty("Content-Type", "application/timestamp-query");
        LOG.debug((Object)"Established connection to TSA server");
        if (this.username != null && this.password != null && !this.username.isEmpty() && !this.password.isEmpty()) {
            uRLConnection.setRequestProperty(this.username, this.password);
        }
        OutputStream outputStream = null;
        try {
            outputStream = uRLConnection.getOutputStream();
            outputStream.write(byArray);
        }
        finally {
            IOUtils.closeQuietly((Closeable)outputStream);
        }
        LOG.debug((Object)"Waiting for response from TSA server");
        InputStream inputStream = null;
        try {
            inputStream = uRLConnection.getInputStream();
            byArray2 = IOUtils.toByteArray((InputStream)inputStream);
        }
        finally {
            IOUtils.closeQuietly((Closeable)inputStream);
        }
        LOG.debug((Object)"Received response from TSA server");
        return byArray2;
    }

    private ASN1ObjectIdentifier getHashObjectIdentifier(String string) {
        if (string.equals("MD2")) {
            return new ASN1ObjectIdentifier(PKCSObjectIdentifiers.md2.getId());
        }
        if (string.equals("MD5")) {
            return new ASN1ObjectIdentifier(PKCSObjectIdentifiers.md5.getId());
        }
        if (string.equals("SHA-1")) {
            return new ASN1ObjectIdentifier(OIWObjectIdentifiers.idSHA1.getId());
        }
        if (string.equals("SHA-224")) {
            return new ASN1ObjectIdentifier(NISTObjectIdentifiers.id_sha224.getId());
        }
        if (string.equals("SHA-256")) {
            return new ASN1ObjectIdentifier(NISTObjectIdentifiers.id_sha256.getId());
        }
        if (string.equals("SHA-384")) {
            return new ASN1ObjectIdentifier(NISTObjectIdentifiers.id_sha384.getId());
        }
        if (string.equals("SHA-512")) {
            return new ASN1ObjectIdentifier(NISTObjectIdentifiers.id_sha512.getId());
        }
        return new ASN1ObjectIdentifier(string);
    }
}

