/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.signature;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Enumeration;
import org.apache.pdfbox.examples.signature.CMSProcessableInputStream;
import org.apache.pdfbox.examples.signature.SigUtils;
import org.apache.pdfbox.examples.signature.ValidationTimeStamp;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureInterface;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.Store;

public abstract class CreateSignatureBase
implements SignatureInterface {
    private PrivateKey privateKey;
    private Certificate[] certificateChain;
    private String tsaUrl;
    private boolean externalSigning;

    public CreateSignatureBase(KeyStore keyStore, char[] cArray) throws KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException, IOException, CertificateException {
        Enumeration<String> enumeration = keyStore.aliases();
        Certificate certificate = null;
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            this.setPrivateKey((PrivateKey)keyStore.getKey(string, cArray));
            Certificate[] certificateArray = keyStore.getCertificateChain(string);
            if (certificateArray == null) continue;
            this.setCertificateChain(certificateArray);
            certificate = certificateArray[0];
            if (!(certificate instanceof X509Certificate)) break;
            ((X509Certificate)certificate).checkValidity();
            SigUtils.checkCertificateUsage((X509Certificate)certificate);
            break;
        }
        if (certificate == null) {
            throw new IOException("Could not find certificate");
        }
    }

    public final void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public final void setCertificateChain(Certificate[] certificateArray) {
        this.certificateChain = certificateArray;
    }

    public Certificate[] getCertificateChain() {
        return this.certificateChain;
    }

    public void setTsaUrl(String string) {
        this.tsaUrl = string;
    }

    public byte[] sign(InputStream inputStream) throws IOException {
        try {
            CMSSignedDataGenerator cMSSignedDataGenerator = new CMSSignedDataGenerator();
            X509Certificate x509Certificate = (X509Certificate)this.certificateChain[0];
            ContentSigner contentSigner = new JcaContentSignerBuilder("SHA256WithRSA").build(this.privateKey);
            cMSSignedDataGenerator.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().build()).build(contentSigner, x509Certificate));
            cMSSignedDataGenerator.addCertificates((Store)new JcaCertStore(Arrays.asList(this.certificateChain)));
            CMSProcessableInputStream cMSProcessableInputStream = new CMSProcessableInputStream(inputStream);
            CMSSignedData cMSSignedData = cMSSignedDataGenerator.generate((CMSTypedData)cMSProcessableInputStream, false);
            if (this.tsaUrl != null && this.tsaUrl.length() > 0) {
                ValidationTimeStamp validationTimeStamp = new ValidationTimeStamp(this.tsaUrl);
                cMSSignedData = validationTimeStamp.addSignedTimeStamp(cMSSignedData);
            }
            return cMSSignedData.getEncoded();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new IOException(generalSecurityException);
        }
        catch (CMSException cMSException) {
            throw new IOException(cMSException);
        }
        catch (OperatorCreationException operatorCreationException) {
            throw new IOException(operatorCreationException);
        }
    }

    public void setExternalSigning(boolean bl) {
        this.externalSigning = bl;
    }

    public boolean isExternalSigning() {
        return this.externalSigning;
    }
}

