/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.signature;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.TreeMap;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.examples.signature.SigUtils;
import org.apache.pdfbox.examples.signature.ValidationTimeStamp;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.apache.pdfbox.util.Hex;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;

public class CreateEmbeddedTimeStamp {
    private final String tsaUrl;
    private PDDocument document;
    private PDSignature signature;
    private byte[] changedEncodedSignature;

    public CreateEmbeddedTimeStamp(String string) {
        this.tsaUrl = string;
    }

    public void embedTimeStamp(File file) throws IOException {
        this.embedTimeStamp(file, file);
    }

    public void embedTimeStamp(File file, File file2) throws IOException {
        PDDocument pDDocument;
        if (file == null || !file.exists()) {
            throw new FileNotFoundException("Document for signing does not exist");
        }
        this.document = pDDocument = PDDocument.load((File)file);
        this.processTimeStamping(file2, file.getAbsolutePath());
        pDDocument.close();
    }

    private void processTimeStamping(File file, String string) throws IOException {
        int n = SigUtils.getMDPPermission(this.document);
        if (n == 1) {
            throw new IllegalStateException("No changes to the document are permitted due to DocMDP transform parameters dictionary");
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            byte[] byArray = IOUtils.toByteArray((InputStream)fileInputStream);
            fileInputStream.close();
            this.processRelevantSignatures(byArray);
            if (this.changedEncodedSignature != null) {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                this.embedNewSignatureIntoDocument(byArray, fileOutputStream);
                fileOutputStream.close();
            }
        }
        catch (IOException iOException) {
            throw new IOException(iOException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IOException(noSuchAlgorithmException);
        }
        catch (CMSException cMSException) {
            throw new IOException(cMSException);
        }
    }

    private void processRelevantSignatures(byte[] byArray) throws IOException, CMSException, NoSuchAlgorithmException {
        this.getRelevantSignature(this.document);
        if (this.signature != null) {
            Object object;
            byte[] byArray2 = this.signature.getContents(byArray);
            CMSSignedData cMSSignedData = new CMSSignedData(byArray2);
            System.out.println("INFO: Byte Range: " + Arrays.toString(this.signature.getByteRange()));
            if (this.tsaUrl != null && this.tsaUrl.length() > 0) {
                object = new ValidationTimeStamp(this.tsaUrl);
                cMSSignedData = ((ValidationTimeStamp)object).addSignedTimeStamp(cMSSignedData);
            }
            object = Hex.getBytes((byte[])cMSSignedData.getEncoded());
            int n = this.signature.getByteRange()[2] - this.signature.getByteRange()[1];
            System.out.println("INFO: New Signature has Size: " + ((Object)object).length + " maxSize: " + n);
            if (((Object)object).length > n - 2) {
                throw new IOException("New Signature is too big for existing Signature-Placeholder. Max Place: " + n);
            }
            this.changedEncodedSignature = (byte[])object;
        }
    }

    private void getRelevantSignature(PDDocument pDDocument) throws IOException {
        PDSignature pDSignature;
        TreeMap<Integer, PDSignature> treeMap = new TreeMap<Integer, PDSignature>();
        PDSignature pDSignature2 = pDDocument.getSignatureDictionaries().iterator();
        while (pDSignature2.hasNext()) {
            pDSignature = (PDSignature)pDSignature2.next();
            int n = pDSignature.getByteRange()[1];
            treeMap.put(n, pDSignature);
        }
        if (treeMap.size() > 0 && (pDSignature = (pDSignature2 = (PDSignature)treeMap.get(treeMap.lastKey())).getCOSObject().getItem(COSName.TYPE)).equals(COSName.SIG)) {
            this.signature = pDSignature2;
        }
    }

    private void embedNewSignatureIntoDocument(byte[] byArray, OutputStream outputStream) throws IOException {
        int[] nArray = this.signature.getByteRange();
        outputStream.write(byArray, nArray[0], nArray[1] + 1);
        outputStream.write(this.changedEncodedSignature);
        int n = nArray[2] - nArray[1] - 2 - this.changedEncodedSignature.length;
        byte[] byArray2 = Hex.getBytes((byte[])new byte[(n + 1) / 2]);
        outputStream.write(byArray2);
        outputStream.write(byArray, nArray[2] - 1, nArray[3] + 1);
    }

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length != 3) {
            CreateEmbeddedTimeStamp.usage();
            System.exit(1);
        }
        String string = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-tsa")) continue;
            if (++i >= stringArray.length) {
                CreateEmbeddedTimeStamp.usage();
                System.exit(1);
            }
            string = stringArray[i];
        }
        File file = new File(stringArray[0]);
        System.out.println("Input File: " + stringArray[0]);
        String string2 = file.getName();
        String string3 = string2.substring(0, string2.lastIndexOf(46));
        File file2 = new File(file.getParent(), string3 + "_eTs.pdf");
        System.out.println("Output File: " + file2.getAbsolutePath());
        CreateEmbeddedTimeStamp createEmbeddedTimeStamp = new CreateEmbeddedTimeStamp(string);
        createEmbeddedTimeStamp.embedTimeStamp(file, file2);
    }

    private static void usage() {
        System.err.println("usage: java " + CreateEmbeddedTimeStamp.class.getName() + " <pdf_to_sign>\nmandatory option:\n  -tsa <url>    sign timestamp using the given TSA server\n");
    }
}

