@rem = '--*-Perl-*--
@echo off
if "%OS%" == "Windows_NT" goto WinNT
perl -x -S "%0" %1 %2 %3 %4 %5 %6 %7 %8 %9
goto endofperl
:WinNT
perl -x -S %0 %*
if NOT "%COMSPEC%" == "%SystemRoot%\system32\cmd.exe" goto endofperl
if %errorlevel% == 9009 echo You do not have Perl in your PATH.
if errorlevel 1 goto script_failed_so_exit_with_non_zero_val 2>nul
goto endofperl
@rem ';
#!/usr/bin/perl -w
#line 15
#
# ecaccess-event-grant: Grant usage of an ECaccess Event
#
# Laurent.Gougeon@ecmwf.int - 2010-10-15

use ECMWF::ECaccess;
use Getopt::Long;
use Pod::Usage;
use Term::ReadKey;

my %opt = ( subscribe => 0, notify => 0, version => 0, help => 0, manual => 0, retry => 0, debug => 0 );

pod2usage( -noperldoc => 1, -exit => 1, verbose => 1 ) if !GetOptions(
	\%opt,
	qw(
	  subscribe
	  notify
	  version
	  help|?
	  manual
	  retry=i
	  debug
	  )
);

# Display version if requested
die ECMWF::ECaccess->VERSION . "\n" if ( $opt{version} );

my $eventid  = $ARGV[0];
my $userList = $ARGV[1];

pod2usage( -noperldoc => 1, -exit => 1, verbose => 1 ) if ( $opt{help} );
pod2usage( -noperldoc => 1, -exit => 1, verbose => 2 ) if ( $opt{manual} );
pod2usage( -noperldoc => 1, -exit => 1, verbose => 0, -msg => "No event-id specified!\n" )   if not($eventid);
pod2usage( -noperldoc => 1, -exit => 1, verbose => 0, -msg => "No users-list specified!\n" ) if not($userList);

# Create the ECaccess Controler
my $ecaccess = ECMWF::ECaccess->new( $opt{retry}, $opt{debug});

# Get the Token (using the Certificate in $HOME)
my $token = $ecaccess->getToken();

# Get the Control Channel
my $controlChannel = $ecaccess->getControlChannel();

# Delete the event
$controlChannel->grantEvent(
	$token,
	$eventid,
	SOAP::Data->name(
		"request" => \SOAP::Data->value(
			SOAP::Data->name( 'userList'  => $userList ),
			SOAP::Data->name( 'subscribe' => $opt{subscribe} ? 'true' : 'false' )->type('xsd:boolean'),
			SOAP::Data->name( 'notify'    => $opt{notify} ? 'true' : 'false' )->type('xsd:boolean')
		)
	)
);

# Logout
$ecaccess->releaseToken($token);

__END__

=head1 NAME

ecaccess-event-grant - Grant usage of an ECaccess Event

=head1 SYNOPSIS

B<ecaccess-event-grant -version|-help|-manual>

B<ecaccess-event-grant [-debug] [-subscribe] [-notify]> I<event-id> I<user-list>

=head1 DESCRIPTION

Allow managing the Event permissions for a list of user(s).

The permissions can be either subscribe, notify, both or none. In order to remove permissions
to an Event for a list of users use this command with no B<-subscribe> and B<-notify> options.

=head1 ARGUMENTS

=over 8

=item I<event-id>

The identifier of the Event to grant.

=item I<user-list>

The user(s) to give/remove the permissions. Multiple users should be separated by a column (e.g. abc,def).

=back

=head1 OPTIONS

=over 8

=item B<-subscribe>

The user(s) specified in the I<user-list> will be allowed to subscribe to the I<event-id>
(e.g. with the B<-eventIds> option of the B<ecaccess-job-submit> command).

=item B<-notify>

The user(s) specified in the I<user-list> will be allowed to send notifications to the I<event-id>
(e.g. with the B<ecaccess-event-send> command).

=item B<-version>

Display version number and exits.

=item B<-help>

Print a brief help message and exits.

=item B<-manual>

Prints the manual page and exits.

=item B<-retry> I<count>

Number of SSL connection retries per 5s to ECMWF. This parameter only apply to the
initial SSL connection initiated by the command to the ECMWF server. It does not
apply to all the subsequent requests made afteward as it is mainly targeting errors
that can happen from time to time during the SSL handshake. Default is no retry.

=item B<-debug>

Display the SOAP and SSL messages exchanged.

=back

=head1 EXAMPLES

B<ecaccess-event-grant -subscribe> I<167> I<abc,def,jhi>

Allow the users I<abc>, I<def> and I<jhi> to subscribe to this Event.

B<ecaccess-event-grant> I<167> I<jkl>

Remove all rights to the Event for the user I<jkl>.

=head1 SEE ALSO

B<ecaccess-event-clear>, B<ecaccess-event-delete>, B<ecaccess-event-send>, B<ecaccess-event-list>,
B<ecaccess-event-create> and B<ecaccess>.

=cut

__END__
:endofperl
