/* Copyright (c) 2017-2023 hors<horsicq@gmail.com>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
#ifndef DIALOGENTROPY_H
#define DIALOGENTROPY_H

#include "xshortcutsdialog.h"

namespace Ui {
class DialogEntropy;
}

class DialogEntropy : public XShortcutsDialog {
    Q_OBJECT

public:
    explicit DialogEntropy(QWidget *pParent);
    DialogEntropy(QWidget *pParent, QIODevice *pDevice, qint64 nOffset = 0, qint64 nSize = -1);
    ~DialogEntropy();

    void setData(QIODevice *pDevice, qint64 nOffset = 0, qint64 nSize = -1);
    void setGlobal(XShortcuts *pShortcuts, XOptions *pXOptions);

private slots:
    void on_pushButtonClose_clicked();

private:
    Ui::DialogEntropy *ui;
};

#endif  // DIALOGENTROPY_H
