/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.tools.jar;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.Type;

public class BaseWeaver {
    protected String invocationInterfaceDesc = "Lcom/googlecode/d2j/tools/jar/MethodInvocation;";
    protected String invocationTypePrefix = "d2j/gen/MI_";
    protected static final String DEFAULT_RET_TYPE = "L888;";
    protected static final String DEFAULT_DESC = "(L;)L888;";
    protected List<Callback> callbacks = new ArrayList<Callback>();
    protected int currentInvocationIdx = 0;
    protected int seqIndex = 1;
    protected MtdInfo key = new MtdInfo();
    protected Set<String> ignores = new HashSet<String>();
    protected Map<String, String> clzDescMap = new HashMap<String, String>();
    protected Map<MtdInfo, MtdInfo> mtdMap = new HashMap<MtdInfo, MtdInfo>();
    protected Map<MtdInfo, MtdInfo> defMap = new HashMap<MtdInfo, MtdInfo>();

    protected String buildMethodAName(String oldName) {
        return String.format("%s_A%03d", oldName, this.seqIndex++);
    }

    protected String buildCallbackMethodName(String oldName) {
        return String.format("%s_CB%03d", oldName, this.seqIndex++);
    }

    protected MtdInfo findDefinedTargetMethod(String owner, String name, String desc) {
        return this.findTargetMethod0(this.defMap, owner, name, desc);
    }

    protected MtdInfo findTargetMethod(String owner, String name, String desc) {
        return this.findTargetMethod0(this.mtdMap, owner, name, desc);
    }

    protected MtdInfo findTargetMethod0(Map<MtdInfo, MtdInfo> map, String owner, String name, String desc) {
        MtdInfo v = map.get(this.buildKey(owner, name, desc));
        if (v != null) {
            return v;
        }
        this.key.desc = Type.getMethodDescriptor((Type)Type.getType((String)DEFAULT_RET_TYPE), (Type[])Type.getArgumentTypes((String)desc));
        v = map.get(this.key);
        if (v != null) {
            return v;
        }
        this.key.desc = DEFAULT_DESC;
        v = map.get(this.key);
        if (v != null) {
            return v;
        }
        if (!name.equals("*")) {
            return this.findTargetMethod0(map, owner, "*", desc);
        }
        return v;
    }

    protected MtdInfo buildKey(String owner, String name, String desc) {
        this.key.name = name;
        this.key.owner = owner;
        this.key.desc = desc;
        return this.key;
    }

    public BaseWeaver withConfig(Path is) throws IOException {
        return this.withConfig(Files.readAllLines(is, StandardCharsets.UTF_8));
    }

    public BaseWeaver withConfig(InputStream is) throws IOException {
        try (BufferedReader r = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
            ArrayList<String> list = new ArrayList<String>();
            String ln = r.readLine();
            while (ln != null) {
                list.add(ln);
                ln = r.readLine();
            }
            BaseWeaver baseWeaver = this.withConfig(list);
            return baseWeaver;
        }
    }

    public BaseWeaver withConfig(List<String> lines) {
        for (String ln : lines) {
            this.withConfig(ln);
        }
        return this;
    }

    public void withConfig(String ln) {
        if ("".equals(ln) || ln.startsWith("#")) {
            return;
        }
        switch (Character.toLowerCase(ln.charAt(0))) {
            case 'i': {
                this.ignores.add(ln.substring(2));
                break;
            }
            case 'c': {
                int index = ln.lastIndexOf(61);
                if (index <= 0) break;
                String key = BaseWeaver.toInternal(ln.substring(2, index));
                String value = BaseWeaver.toInternal(ln.substring(index + 1));
                this.clzDescMap.put(key, value);
                this.ignores.add(value);
                break;
            }
            case 'r': {
                int index = ln.lastIndexOf(61);
                if (index <= 0) break;
                String key = ln.substring(2, index);
                String value = ln.substring(index + 1);
                MtdInfo mi = this.buildMethodInfo(key);
                index = value.indexOf(46);
                MtdInfo mtdValue = new MtdInfo();
                mtdValue.owner = value.substring(0, index);
                int index2 = value.indexOf(40, index);
                mtdValue.name = value.substring(index + 1, index2);
                mtdValue.desc = value.substring(index2);
                this.mtdMap.put(mi, mtdValue);
                break;
            }
            case 'd': {
                int index = ln.lastIndexOf(61);
                if (index <= 0) break;
                String key = ln.substring(2, index);
                String value = ln.substring(index + 1);
                MtdInfo mi = this.buildMethodInfo(key);
                index = value.indexOf(46);
                MtdInfo mtdValue = new MtdInfo();
                mtdValue.owner = value.substring(0, index);
                int index2 = value.indexOf(40, index);
                mtdValue.name = value.substring(index + 1, index2);
                mtdValue.desc = value.substring(index2);
                this.defMap.put(mi, mtdValue);
                break;
            }
            case 'o': {
                this.setInvocationInterfaceDesc(ln.substring(2));
                break;
            }
            case 'p': {
                this.invocationTypePrefix = ln.substring(2);
            }
        }
    }

    public void setInvocationInterfaceDesc(String invocationInterfaceDesc) {
        this.invocationInterfaceDesc = invocationInterfaceDesc;
    }

    protected static String toInternal(String key) {
        if (key.endsWith(";")) {
            key = key.substring(1, key.length() - 1);
        }
        return key;
    }

    protected MtdInfo buildMethodInfo(String value) {
        int index = value.indexOf(46);
        MtdInfo mtdValue = new MtdInfo();
        mtdValue.owner = value.substring(0, index);
        int index2 = value.indexOf(40, index);
        if (index2 >= 0) {
            mtdValue.name = value.substring(index + 1, index2);
            int index3 = value.indexOf(41);
            mtdValue.desc = index3 == value.length() - 1 ? value.substring(index2) + DEFAULT_RET_TYPE : value.substring(index2);
        } else {
            mtdValue.name = value.substring(index + 1);
            mtdValue.desc = DEFAULT_DESC;
        }
        return mtdValue;
    }

    public String getCurrentInvocationName() {
        return String.format("%s_%03d", this.invocationTypePrefix, this.currentInvocationIdx);
    }

    protected void nextInvocationName() {
        ++this.currentInvocationIdx;
        this.callbacks.clear();
    }

    public static class MtdInfo {
        public String desc;
        public String name;
        public String owner;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MtdInfo mtdInfo = (MtdInfo)o;
            if (!this.desc.equals(mtdInfo.desc)) {
                return false;
            }
            if (!this.name.equals(mtdInfo.name)) {
                return false;
            }
            return this.owner.equals(mtdInfo.owner);
        }

        public int hashCode() {
            int result = this.desc.hashCode();
            result = 31 * result + this.name.hashCode();
            result = 31 * result + this.owner.hashCode();
            return result;
        }
    }

    public static class Callback {
        int idx;
        Object callback;
        Object target;
        boolean isSpecial;
        boolean isStatic;
    }
}

