/*
* Copyright (C) 2019 ~ 2020 Uniontech Software Technology Co.,Ltd.
*
* Author:     chenhaifeng  <chenhaifeng@uniontech.com>
*
* Maintainer: chenhaifeng  <chenhaifeng@uniontech.com>
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "test_ckeypressprxy.h"
#include "ckeyleftdeal.h"

test_CKeyPressPrxy::test_CKeyPressPrxy()
{
    keyPressPrxy = QSharedPointer<CKeyPressPrxy>(new CKeyPressPrxy);
}

TEST_F(test_CKeyPressPrxy, keyPressDeal_NoEvent)
{
    ASSERT_FALSE(keyPressPrxy->keyPressDeal(Qt::Key_Tab));
}

TEST_F(test_CKeyPressPrxy, keyPressDeal)
{
    keyPressPrxy->addkeyPressDeal(new CKeyLeftDeal());
    ASSERT_FALSE(keyPressPrxy->keyPressDeal(Qt::Key_Left));
}

TEST_F(test_CKeyPressPrxy, removeDeal)
{
    CKeyLeftDeal *leftDeal = new CKeyLeftDeal();
    keyPressPrxy->addkeyPressDeal(leftDeal);
    keyPressPrxy->removeDeal(leftDeal);
    ASSERT_FALSE(keyPressPrxy->keyPressDeal(Qt::Key_Left));
}
