/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.StyledText;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlanner;
import org.jkiss.dbeaver.model.sql.parser.SQLIdentifierDetector;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.actions.exec.SQLNativeExecutorDescriptor;
import org.jkiss.dbeaver.ui.actions.exec.SQLNativeExecutorRegistry;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditor;
import org.jkiss.dbeaver.ui.editors.sql.registry.SQLPresentationDescriptor;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class SQLEditorPropertyTester
extends PropertyTester {
    static final Log log = Log.getLog(SQLEditorPropertyTester.class);
    public static final String NAMESPACE = "org.jkiss.dbeaver.ui.editors.sql";
    public static final String PROP_CAN_EXECUTE = "canExecute";
    public static final String PROP_CAN_EXECUTE_NATIVE = "canExecuteNative";
    public static final String PROP_CAN_EXPLAIN = "canExplain";
    public static final String PROP_CAN_NAVIGATE = "canNavigate";
    public static final String PROP_CAN_EXPORT = "canExport";
    public static final String PROP_HAS_ACTIVE_QUERY = "hasActiveQuery";
    public static final String PROP_HAS_SELECTION = "hasSelection";
    public static final String PROP_IS_ACTIVE_QUERY_RUNNING = "isActiveQueryRunning";
    public static final String PROP_FOLDING_SUPPORTED = "foldingSupported";
    public static final String PROP_FOLDING_ENABLED = "foldingEnabled";

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        void editor;
        if (!(receiver instanceof SQLEditor)) return false;
        SQLEditor sQLEditor = (SQLEditor)((Object)receiver);
        TextViewer textViewer = editor.getTextViewer();
        StyledText editorControl = editor.getEditorControl();
        if (editorControl == null) return false;
        if (textViewer == null) {
            return false;
        }
        StyledText textWidget = textViewer.getTextWidget();
        if (textWidget == null) {
            return false;
        }
        boolean hasConnection = editor.getDataSourceContainer() != null;
        switch (property) {
            case "canExecute": {
                SQLPresentationDescriptor descriptor = editor.getActivePresentationDescriptor();
                SQLPresentationDescriptor.QueryMode mode = descriptor != null ? descriptor.getQueryMode() : SQLPresentationDescriptor.QueryMode.MULTIPLE;
                switch (CommonUtils.toString((Object)expectedValue)) {
                    case "statement": {
                        if (mode == SQLPresentationDescriptor.QueryMode.NONE) return false;
                        if (!textWidget.isFocusControl()) return false;
                        return true;
                    }
                    case "script": {
                        if (mode != SQLPresentationDescriptor.QueryMode.MULTIPLE) return false;
                        return true;
                    }
                }
                return false;
            }
            case "canExecuteNative": {
                try {
                    if (editor.getDataSourceContainer() == null) {
                        return false;
                    }
                    SQLNativeExecutorDescriptor executorDescriptor = SQLNativeExecutorRegistry.getInstance().getExecutorDescriptor(editor.getDataSourceContainer());
                    if (executorDescriptor == null) return false;
                    if (executorDescriptor.getNativeExecutor() == null) return false;
                    return true;
                }
                catch (DBException exception) {
                    log.error((Object)"Error checking native execution", (Throwable)exception);
                    return false;
                }
            }
            case "canExplain": {
                if (!hasConnection) return false;
                if (GeneralUtils.adapt((Object)editor.getDataSource(), DBCQueryPlanner.class) == null) return false;
                return true;
            }
            case "canNavigate": {
                ISelectionProvider selectionProvider = editor.getSelectionProvider();
                if (selectionProvider == null) {
                    return false;
                }
                ITextSelection selection = (ITextSelection)selectionProvider.getSelection();
                IDocument document = editor.getDocument();
                if (selection == null) return false;
                if (document == null) return false;
                if (new SQLIdentifierDetector(editor.getSyntaxManager().getDialect(), editor.getSyntaxManager().getStructSeparator(), editor.getSyntaxManager().getIdentifierQuoteStrings()).extractIdentifier(document, (IRegion)new Region(selection.getOffset(), selection.getLength()), editor.getRuleManager()).isEmpty()) return false;
                return true;
            }
            case "canExport": {
                if (!hasConnection) return false;
                if (!editor.hasActiveQuery()) return false;
                return true;
            }
            case "hasActiveQuery": {
                return editor.hasActiveQuery();
            }
            case "hasSelection": {
                ISelection selection = editor.getSelectionProvider().getSelection();
                if (!(selection instanceof ITextSelection)) return false;
                if (((ITextSelection)selection).getLength() <= 0) return false;
                return true;
            }
            case "isActiveQueryRunning": {
                return editor.isActiveQueryRunning();
            }
            case "foldingEnabled": {
                return editor.isFoldingEnabled();
            }
            case "foldingSupported": {
                if (editor.getProjectionAnnotationModel() == null) return false;
                return true;
            }
        }
        return false;
    }

    public static void firePropertyChange(String propName) {
        ActionUtils.evaluatePropertyState((String)("org.jkiss.dbeaver.ui.editors.sql." + propName));
    }
}

