/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.cubrid.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.cubrid.model.CubridDataSource;
import org.jkiss.dbeaver.ext.cubrid.model.CubridUser;
import org.jkiss.dbeaver.ext.cubrid.model.CubridView;
import org.jkiss.dbeaver.ext.generic.edit.GenericViewManager;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericView;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.edit.prop.DBECommandComposite;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class CubridViewManager
extends GenericViewManager
implements DBEObjectRenamer<GenericTableBase> {
    public boolean canCreateObject(@NotNull Object container) {
        CubridUser user = (CubridUser)((Object)container);
        CubridDataSource dataSource = user.getDataSource();
        boolean isDBAGroup = dataSource.isDBAGroup();
        boolean supportsMultiSchema = dataSource.getSupportMultiSchema();
        boolean isCurrentUser = user.getName().equalsIgnoreCase(dataSource.getCurrentUser());
        return isDBAGroup || supportsMultiSchema || isCurrentUser || !dataSource.isShard();
    }

    @NotNull
    protected GenericTableBase createDatabaseObject(@NotNull DBRProgressMonitor monitor, @NotNull DBECommandContext context, @Nullable Object container, @Nullable Object copyFrom, @NotNull Map<String, Object> options) {
        GenericStructContainer structContainer = (GenericStructContainer)container;
        String tableName = this.getNewChildName(monitor, (DBSObject)structContainer, "NewView");
        GenericTableBase viewImpl = structContainer.getDataSource().getMetaModel().createTableOrViewImpl(structContainer, tableName, "VIEW", null);
        if (viewImpl instanceof GenericView) {
            ((GenericView)viewImpl).setObjectDefinitionText("\n");
        }
        return viewImpl;
    }

    protected void addObjectCreateActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectCreateCommand command, @NotNull Map<String, Object> options) {
        this.createOrReplaceViewQuery(actions, (DBECommandComposite<GenericTableBase, SQLObjectEditor.PropertyHandler>)command);
    }

    protected void addObjectModifyActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actionList, @NotNull SQLObjectEditor.ObjectChangeCommand command, @NotNull Map<String, Object> options) {
        this.createOrReplaceViewQuery(actionList, (DBECommandComposite<GenericTableBase, SQLObjectEditor.PropertyHandler>)command);
    }

    private void createOrReplaceViewQuery(@NotNull List<DBEPersistAction> actions, @NotNull DBECommandComposite<GenericTableBase, SQLObjectEditor.PropertyHandler> command) {
        CubridView view = (CubridView)command.getObject();
        StringBuilder query = new StringBuilder(200);
        String viewDDL = view.getDDL();
        boolean hasComment = command.hasProperty((Object)"description");
        if (viewDDL == null) {
            viewDDL = "";
        }
        if (!view.isPersisted()) {
            query.append("CREATE VIEW " + view.getFullyQualifiedName(DBPEvaluationContext.DDL) + "\nAS ");
            query.append(viewDDL);
            if (hasComment && view.getDescription() != null) {
                query.append("\nCOMMENT = ").append(SQLUtils.quoteString((DBSObject)view, (String)CommonUtils.notEmpty((String)view.getDescription())));
            }
        } else {
            if (command.hasProperty((Object)"objectDefinitionText")) {
                query.append(viewDDL).append("\n");
            }
            if (hasComment || view.getDescription() != null) {
                boolean isSupportMultiSchema = view.getDataSource().getSupportMultiSchema();
                String viewName = isSupportMultiSchema ? DBUtils.getQuotedIdentifier((DBSObject)view.getContainer()) + "." + DBUtils.getQuotedIdentifier((DBPDataSource)view.getDataSource(), (String)view.getName()) : DBUtils.getQuotedIdentifier((DBPDataSource)view.getDataSource(), (String)view.getName());
                query.append("ALTER VIEW " + viewName + " COMMENT = " + SQLUtils.quoteString((DBSObject)view, (String)CommonUtils.notEmpty((String)view.getDescription())));
            }
        }
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create view", query.toString()));
    }

    protected void addObjectRenameActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectRenameCommand command, @NotNull Map<String, Object> options) {
        CubridView view = (CubridView)command.getObject();
        boolean isSupportMultiSchema = view.getDataSource().getSupportMultiSchema();
        String schemaName = isSupportMultiSchema ? DBUtils.getQuotedIdentifier((DBSObject)view.getContainer()) + "." : "";
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename view", "RENAME VIEW " + schemaName + DBUtils.getQuotedIdentifier((DBPDataSource)view.getDataSource(), (String)command.getOldName()) + " TO " + schemaName + DBUtils.getQuotedIdentifier((DBPDataSource)view.getDataSource(), (String)command.getNewName())));
    }

    public void renameObject(@NotNull DBECommandContext commandContext, @NotNull GenericTableBase object, @NotNull Map<String, Object> options, @NotNull String newName) throws DBException {
        if (!((CubridDataSource)object.getDataSource()).isShard()) {
            this.processObjectRename(commandContext, (DBSObject)object, options, newName);
        }
    }

    protected void addObjectExtraActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.NestedObjectCommand<GenericTableBase, SQLObjectEditor.PropertyHandler> command, @NotNull Map<String, Object> options) {
        CubridView view = (CubridView)command.getObject();
        boolean isDBAGroup = view.getDataSource().isDBAGroup();
        boolean isSupportMultiSchema = view.getDataSource().getSupportMultiSchema();
        String currentUser = view.getDataSource().getCurrentUser();
        String schemaName = view.getSchema().getName();
        if (view.isPersisted() ? view.getContainer() == view.getSchema() : !isDBAGroup || isSupportMultiSchema || currentUser.equalsIgnoreCase(schemaName)) {
            return;
        }
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Change Owner", "ALTER VIEW " + (String)(isSupportMultiSchema ? DBUtils.getQuotedIdentifier((DBSObject)view.getContainer()) + "." : "") + DBUtils.getQuotedIdentifier((DBPDataSource)view.getDataSource(), (String)view.getName()) + " OWNER TO " + DBUtils.getQuotedIdentifier((DBSObject)view.getSchema())));
    }

    public boolean canRenameObject(GenericTableBase object) {
        return !((CubridDataSource)object.getDataSource()).isShard();
    }

    public boolean canEditObject(GenericTableBase object) {
        return !((CubridDataSource)object.getDataSource()).isShard();
    }

    public boolean canDeleteObject(GenericTableBase object) {
        return !((CubridDataSource)object.getDataSource()).isShard();
    }
}

