/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.model.expressions;

import java.util.Collections;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.impl.struct.RelationalObjectType;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryComplexName;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryModelRecognizer;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySemanticUtils;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbol;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolByDbObjectDefinition;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolClass;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolOrigin;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryExprType;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryResultColumn;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryResultPseudoColumn;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsSourceContext;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModelVisitor;
import org.jkiss.dbeaver.model.sql.semantics.model.expressions.SQLQueryValueExpression;
import org.jkiss.dbeaver.model.stm.STMTreeNode;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectType;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObjectEx2;

public class SQLQueryValueReferenceExpression
extends SQLQueryValueExpression {
    private static final DBSObjectType ALLOWED_OBJECT_TYPE = RelationalObjectType.TYPE_SEQUENCE;
    private static final SQLQueryExprType ALLOWED_OBJECT_EXPR_TYPE = SQLQueryExprType.UNKNOWN;
    private static final Log log = Log.getLog(SQLQueryValueReferenceExpression.class);
    private final boolean rowRefAllowed;
    @Nullable
    private final SQLQueryComplexName name;
    @Nullable
    private SQLQueryResultColumn column = null;

    public SQLQueryValueReferenceExpression(@NotNull STMTreeNode syntaxNode, boolean rowRefAllowed, @Nullable SQLQueryComplexName name) {
        super(syntaxNode, new SQLQueryNodeModel[0]);
        this.rowRefAllowed = rowRefAllowed;
        this.name = name;
    }

    @Override
    @Nullable
    public SQLQuerySymbolClass getAssociatedSymbolClass() {
        return SQLQuerySemanticUtils.getIdentifierSymbolClass(this.name);
    }

    @Nullable
    public SQLQueryComplexName getName() {
        return this.name;
    }

    @Override
    protected <R, T> R applyImpl(@NotNull SQLQueryNodeModelVisitor<T, R> visitor, @NotNull T arg) {
        return visitor.visitValueReferenceExpr(this, arg);
    }

    @Nullable
    public SQLQuerySymbolEntry getColumnName() {
        return this.name == null || this.name.parts.isEmpty() || this.name.parts.getLast() == null ? null : this.name.parts.getLast();
    }

    @Override
    @Nullable
    public SQLQuerySymbol getColumnNameIfTrivialExpression() {
        return this.name == null || this.name.parts.isEmpty() || this.name.parts.getLast() == null ? null : this.name.parts.getLast().getSymbol();
    }

    @Override
    @Nullable
    public SQLQueryResultColumn getColumnIfTrivialExpression() {
        return this.column;
    }

    @Override
    protected void resolveRowSourcesImpl(@NotNull SQLQueryRowsSourceContext context, @NotNull SQLQueryRecognitionContext statistics) {
    }

    @Override
    @NotNull
    protected SQLQueryExprType resolveValueTypeImpl(@NotNull SQLQueryRowsDataContext context, @NotNull SQLQueryRecognitionContext statistics) {
        SQLQueryExprType type;
        SQLQueryResultColumn resultColumn;
        if (this.name != null) {
            SQLQuerySymbolClass forcedClass;
            Object dbObject;
            List<Object> dbObjects;
            List<String> objectName;
            SQLQueryRowsSourceContext.SourceResolutionInfo tableRef;
            SQLQueryResultPseudoColumn resultPseudoColumn;
            SQLQuerySymbolEntry columnRefEntry;
            SQLQueryRowsDataContext columnContext;
            SQLQuerySymbolOrigin columnRefOrigin = new SQLQuerySymbolOrigin.RowsDataRef(context);
            List<SQLQuerySymbolEntry> restParts = this.name.parts;
            if (this.name.invalidPartsCount > 0) {
                int invalidPartIndex = restParts.indexOf(null);
                restParts = restParts.subList(0, invalidPartIndex);
            }
            if (restParts.size() > 0) {
                columnContext = context;
                columnRefEntry = restParts.getFirst();
                resultPseudoColumn = context.getConnection().resolveGlobalPseudoColumn(columnRefEntry.getName());
                if (resultPseudoColumn == null) {
                    resultPseudoColumn = context.resolvePseudoColumn(columnRefEntry.getName());
                }
                resultColumn = resultPseudoColumn == null ? context.resolveColumn(statistics.getMonitor(), columnRefEntry.getName()) : null;
            } else {
                columnContext = null;
                columnRefEntry = null;
                resultPseudoColumn = null;
                resultColumn = null;
            }
            if (resultColumn == null && resultPseudoColumn == null || this.name.parts.size() > 1) {
                tableRef = context.getRowsSources().findReferencedSource(this.name);
                if (tableRef != null) {
                    columnContext = tableRef.target().source.getRowsDataContext();
                    restParts = this.name.parts.subList(tableRef.key().parts.size(), restParts.size());
                    SQLQuerySemanticUtils.setNamePartsDefinition(tableRef.key(), tableRef.target(), columnRefOrigin);
                    columnRefOrigin = new SQLQuerySymbolOrigin.ColumnRefFromReferencedContext(tableRef.target());
                    if (!restParts.isEmpty()) {
                        columnRefEntry = restParts.getFirst();
                        restParts = restParts.subList(1, restParts.size());
                        if (resultPseudoColumn == null) {
                            resultPseudoColumn = columnContext.resolvePseudoColumn(columnRefEntry.getName());
                        }
                        if (resultPseudoColumn == null) {
                            resultColumn = columnContext.resolveColumn(statistics.getMonitor(), columnRefEntry.getName());
                        }
                    } else {
                        columnRefEntry = null;
                        resultColumn = null;
                    }
                }
            } else {
                tableRef = null;
            }
            if (resultColumn == null && resultPseudoColumn == null && tableRef == null) {
                SQLQuerySymbolEntry stringEntry;
                String rawString;
                SQLDialect dialect;
                if (context.getConnection().isDummy()) {
                    objectName = null;
                    dbObjects = Collections.emptyList();
                } else if (restParts.size() > 0) {
                    objectName = this.name.stringParts.subList(0, restParts.size());
                    dbObjects = context.getRowsSources().getConnectionInfo().findRealObjects(statistics.getMonitor(), ALLOWED_OBJECT_TYPE, objectName);
                    while (dbObjects.isEmpty() && objectName.size() > 1) {
                        objectName = objectName.subList(0, objectName.size() - 1);
                        dbObjects = context.getRowsSources().getConnectionInfo().findRealObjects(statistics.getMonitor(), ALLOWED_OBJECT_TYPE, objectName);
                    }
                    if (dbObjects.size() == 1) {
                        restParts = restParts.subList(objectName.size(), restParts.size());
                    }
                } else {
                    objectName = null;
                    dbObjects = Collections.emptyList();
                }
                Object object = dbObject = dbObjects.size() == 1 ? (DBSObject)dbObjects.getFirst() : null;
                forcedClass = dbObjects.size() > 1 ? null : (dbObject == null && this.name.parts.size() == 1 && this.name.invalidPartsCount == 0 ? ((dialect = context.getConnection().dialect).isQuotedString(rawString = (stringEntry = this.name.parts.getFirst()).getRawName()) ? SQLQuerySymbolClass.STRING : SQLQueryModelRecognizer.tryFallbackSymbolForStringLiteral(dialect, stringEntry, false)) : null);
            } else {
                dbObjects = Collections.emptyList();
                dbObject = null;
                forcedClass = null;
                objectName = null;
            }
            if (forcedClass != null) {
                this.name.parts.getFirst().getSymbol().setSymbolClass(forcedClass);
                type = forcedClass == SQLQuerySymbolClass.STRING ? SQLQueryExprType.STRING : SQLQueryExprType.UNKNOWN;
                restParts = this.name.parts.subList(1, restParts.size());
            } else if (dbObject != null) {
                SQLQuerySymbolClass objClass;
                if (ALLOWED_OBJECT_TYPE.getTypeClass().isAssignableFrom(dbObject.getClass())) {
                    objClass = SQLQuerySymbolClass.OBJECT;
                    try {
                        if (dbObject instanceof DBSTypedObject) {
                            DBSTypedObject typedObject = (DBSTypedObject)dbObject;
                            type = SQLQueryExprType.forTypedObject(statistics.getMonitor(), typedObject, objClass);
                        } else if (dbObject instanceof DBSTypedObjectEx2) {
                            DBSTypedObjectEx2 typedObject = (DBSTypedObjectEx2)dbObject;
                            type = SQLQueryExprType.forTypedObject(statistics.getMonitor(), typedObject, new SQLQuerySymbolByDbObjectDefinition((DBSObject)dbObject, objClass));
                        } else {
                            type = ALLOWED_OBJECT_EXPR_TYPE;
                        }
                    }
                    catch (DBException e) {
                        type = ALLOWED_OBJECT_EXPR_TYPE;
                        statistics.appendError(this.getName().syntaxNode, "Failed to resolve referenced object type info for " + dbObject.getName(), e);
                    }
                    if (restParts.isEmpty()) {
                        statistics.appendError(this.name.syntaxNode, "Incomplete sequence reference, pseudoattribute required");
                        if (this.name.endingPeriodNode != null) {
                            this.name.endingPeriodNode.setOrigin(new SQLQuerySymbolOrigin.MemberOfType(type));
                        }
                    }
                } else {
                    objClass = SQLQuerySymbolClass.ERROR;
                    type = SQLQueryExprType.UNKNOWN;
                    String typeName = SQLQuerySemanticUtils.getObjectTypeName((DBSObject)dbObject);
                    statistics.appendError(this.name.syntaxNode, "Illegal database object reference " + typeName);
                }
                SQLQuerySemanticUtils.setNamePartsDefinition(context.getRowsSources(), this.name.parts.subList(0, objectName.size()), (DBSObject)dbObject, objClass, (SQLQuerySymbolOrigin)new SQLQuerySymbolOrigin.RowsDataRef(context), SQLQuerySymbolOrigin.DbObjectFilterMode.VALUE);
            } else if (dbObjects.size() > 1) {
                type = SQLQueryExprType.UNKNOWN;
                SQLQuerySemanticUtils.performPartialResolution(context.getRowsSources(), statistics, this.name, columnRefOrigin, SQLQuerySymbolOrigin.DbObjectFilterMode.VALUE, SQLQuerySymbolClass.OBJECT);
            } else {
                type = null;
            }
            if (type == null) {
                if (columnRefEntry != null) {
                    if (columnContext.getRowsSources().hasUnresolvedSource() && resultColumn == null && resultPseudoColumn == null) {
                        type = SQLQueryExprType.UNKNOWN;
                        columnRefEntry.setOrigin(columnRefOrigin);
                    } else if (resultPseudoColumn != null) {
                        resultColumn = null;
                        type = resultPseudoColumn.type;
                        columnRefEntry.setDefinition(resultPseudoColumn);
                        columnRefEntry.setOrigin(columnRefOrigin);
                    } else if (tableRef == null && resultColumn == null) {
                        SQLQuerySemanticUtils.performPartialResolution(context.getRowsSources(), statistics, this.name, columnRefOrigin, SQLQuerySymbolOrigin.DbObjectFilterMode.VALUE, SQLQuerySymbolClass.ERROR);
                        type = SQLQueryExprType.UNKNOWN;
                        statistics.appendError(this.getSyntaxNode(), "Invalid column reference");
                    } else {
                        SQLQuerySemanticUtils.propagateColumnDefinition(columnRefEntry, resultColumn, statistics, columnRefOrigin);
                        SQLQueryExprType sQLQueryExprType = type = resultColumn != null ? resultColumn.type : SQLQueryExprType.UNKNOWN;
                    }
                    if (tableRef == null && (resultColumn != null || resultPseudoColumn != null)) {
                        restParts = restParts.subList(1, restParts.size());
                    }
                } else {
                    resultColumn = null;
                    if (tableRef != null) {
                        SQLQueryExprType rowType = SQLQueryExprType.forReferencedRow(tableRef.key(), tableRef.target());
                        if (this.name.endingPeriodNode == null && tableRef.key().endingPeriodNode == null) {
                            type = rowType;
                        } else {
                            type = SQLQueryExprType.UNKNOWN;
                            statistics.appendError(this.name.syntaxNode, "Incomplete column reference");
                            if (tableRef.key().endingPeriodNode != null) {
                                tableRef.key().endingPeriodNode.setOrigin(new SQLQuerySymbolOrigin.MemberOfType(rowType));
                            }
                        }
                    } else {
                        type = SQLQueryExprType.UNKNOWN;
                        statistics.appendError(this.name.syntaxNode, "Illegal column reference");
                        if (!this.name.parts.isEmpty() && this.name.parts.getFirst() != null && this.name.parts.getFirst().getOrigin() == null) {
                            this.name.parts.getFirst().setOrigin(new SQLQuerySymbolOrigin.RowsDataRef(context));
                        }
                    }
                }
            }
            if (restParts.size() >= 1 && type != SQLQueryExprType.UNKNOWN) {
                SQLQuerySymbolOrigin.MemberOfType memberOrigin = new SQLQuerySymbolOrigin.MemberOfType(type);
                int i = 0;
                while (i < restParts.size() && type != null && restParts.get(i) != null) {
                    type = SQLQuerySemanticUtils.tryResolveMemberReference(statistics, type, restParts.get(i), memberOrigin);
                    memberOrigin = new SQLQuerySymbolOrigin.MemberOfType(type);
                    ++i;
                }
                if (type == null) {
                    type = SQLQueryExprType.UNKNOWN;
                }
            }
        } else {
            statistics.appendError(this.getSyntaxNode(), "Invalid column reference");
            resultColumn = null;
            type = SQLQueryExprType.UNKNOWN;
        }
        this.column = resultColumn;
        return type;
    }

    public String toString() {
        String name = this.name == null ? "<NULL>" : this.name.getNameString();
        String type = this.type == null ? "<NULL>" : this.type.toString();
        return "ValueReference[" + name + ":" + type + "]";
    }
}

