/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.ui.prefs;

import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.tools.transfer.DTConstants;
import org.jkiss.dbeaver.tools.transfer.internal.DTActivator;
import org.jkiss.dbeaver.tools.transfer.ui.internal.DTUIMessages;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.DialogUtils;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;
import org.jkiss.dbeaver.utils.PrefUtils;
import org.jkiss.utils.CommonUtils;

public class PrefPageDataTransfer
extends AbstractPrefPage
implements IWorkbenchPreferencePage {
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.datatransfer";
    private Button reconnectToLastDatabaseButton;
    private Text fallbackOutputDirectoryText;

    public void init(IWorkbench workbench) {
    }

    @NotNull
    protected Control createPreferenceContent(@NotNull Composite parent) {
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)1);
        DBPPreferenceStore preferences = DTActivator.getDefault().getPreferences();
        Group group = UIUtils.createControlGroup((Composite)composite, (String)DTUIMessages.pref_data_transfer_wizard_title, (int)1, (int)768, (int)0);
        this.reconnectToLastDatabaseButton = UIUtils.createCheckbox((Composite)group, (String)DTUIMessages.pref_data_transfer_wizard_reconnect_to_database, (boolean)preferences.getBoolean("reconnectToLastDatabase"));
        group = UIUtils.createControlGroup((Composite)composite, (String)DTUIMessages.pref_data_transfer_options_title, (int)2, (int)768, (int)0);
        this.fallbackOutputDirectoryText = DialogUtils.createOutputFolderChooser((Composite)group, (String)DTUIMessages.pref_data_transfer_options_fallback_directory, (String)DTUIMessages.pref_data_transfer_options_fallback_directory_tip, null, null);
        this.fallbackOutputDirectoryText.setText(CommonUtils.notEmpty((String)preferences.getString("fallbackOutputDirectory")));
        this.fallbackOutputDirectoryText.setMessage(DTConstants.DEFAULT_FALLBACK_OUTPUT_DIRECTORY);
        return composite;
    }

    protected void performDefaults() {
        DBPPreferenceStore preferences = DTActivator.getDefault().getPreferences();
        this.reconnectToLastDatabaseButton.setSelection(preferences.getDefaultBoolean("reconnectToLastDatabase"));
        this.fallbackOutputDirectoryText.setText("");
        this.fallbackOutputDirectoryText.setMessage(preferences.getDefaultString("fallbackOutputDirectory"));
    }

    public boolean performOk() {
        DBPPreferenceStore preferences = DTActivator.getDefault().getPreferences();
        preferences.setValue("reconnectToLastDatabase", this.reconnectToLastDatabaseButton.getSelection());
        preferences.setValue("fallbackOutputDirectory", this.fallbackOutputDirectoryText.getText());
        PrefUtils.savePreferenceStore((DBPPreferenceStore)preferences);
        return true;
    }
}

