/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.expressions.ExpressionInfo;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.e4.core.commands.internal.HandlerServiceImpl;
import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.RunAndTrack;
import org.eclipse.e4.core.di.InjectionException;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.internal.workbench.PartServiceSaveHandler;
import org.eclipse.e4.ui.internal.workbench.UIExtensionTracker;
import org.eclipse.e4.ui.internal.workbench.URIHelper;
import org.eclipse.e4.ui.internal.workbench.renderers.swt.IUpdateService;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.SideValue;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MCompositePart;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimElement;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MToolControl;
import org.eclipse.e4.ui.model.internal.Position;
import org.eclipse.e4.ui.model.internal.PositionInfo;
import org.eclipse.e4.ui.services.EContextService;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.addons.splitteraddon.SplitHost;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.ISaveHandler;
import org.eclipse.e4.ui.workbench.modeling.IWindowCloseHandler;
import org.eclipse.e4.ui.workbench.renderers.swt.MenuManagerRenderer;
import org.eclipse.e4.ui.workbench.renderers.swt.MenuManagerRendererFilter;
import org.eclipse.e4.ui.workbench.renderers.swt.ToolBarManagerRenderer;
import org.eclipse.e4.ui.workbench.renderers.swt.TrimmedPartLayout;
import org.eclipse.e4.ui.workbench.swt.factories.IRendererFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.action.CoolBarManager;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManagerOverrides;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.jface.action.SubContributionItem;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.internal.provisional.action.CoolBarManager2;
import org.eclipse.jface.internal.provisional.action.ICoolBarManager2;
import org.eclipse.jface.internal.provisional.action.IToolBarManager2;
import org.eclipse.jface.internal.provisional.action.ToolBarManager2;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ActiveShellExpression;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPageService;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.ISaveablesLifecycleListener;
import org.eclipse.ui.ISaveablesSource;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.ActionPresentation;
import org.eclipse.ui.internal.ActionSetsEvent;
import org.eclipse.ui.internal.CoolBarToTrimManager;
import org.eclipse.ui.internal.IBackgroundSaveListener;
import org.eclipse.ui.internal.PageListenerList;
import org.eclipse.ui.internal.PartService;
import org.eclipse.ui.internal.Perspective;
import org.eclipse.ui.internal.PerspectiveListenerList;
import org.eclipse.ui.internal.SaveableHelper;
import org.eclipse.ui.internal.SaveablesList;
import org.eclipse.ui.internal.StartupThreading;
import org.eclipse.ui.internal.WWinActionBars;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindowConfigurer;
import org.eclipse.ui.internal.actions.CommandAction;
import org.eclipse.ui.internal.commands.SlaveCommandService;
import org.eclipse.ui.internal.contexts.ContextService;
import org.eclipse.ui.internal.dialogs.cpd.CustomizePerspectiveDialog;
import org.eclipse.ui.internal.e4.compatibility.CompatibilityPart;
import org.eclipse.ui.internal.e4.compatibility.SelectionService;
import org.eclipse.ui.internal.handlers.ActionCommandMappingService;
import org.eclipse.ui.internal.handlers.IActionCommandMappingService;
import org.eclipse.ui.internal.handlers.LegacyHandlerService;
import org.eclipse.ui.internal.menus.IActionSetsListener;
import org.eclipse.ui.internal.menus.LegacyActionPersistence;
import org.eclipse.ui.internal.menus.SlaveMenuService;
import org.eclipse.ui.internal.misc.UIListenerLogging;
import org.eclipse.ui.internal.progress.ProgressRegion;
import org.eclipse.ui.internal.provisional.application.IActionBarConfigurer2;
import org.eclipse.ui.internal.registry.IActionSetDescriptor;
import org.eclipse.ui.internal.services.EvaluationReference;
import org.eclipse.ui.internal.services.IServiceLocatorCreator;
import org.eclipse.ui.internal.services.IWorkbenchLocationService;
import org.eclipse.ui.internal.services.ServiceLocator;
import org.eclipse.ui.internal.services.WorkbenchLocationService;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.ui.model.WorkbenchPartLabelProvider;
import org.eclipse.ui.services.IEvaluationService;
import org.eclipse.ui.views.IViewDescriptor;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class WorkbenchWindow
implements IWorkbenchWindow {
    public static final String PERSPECTIVE_SPACER_ID = "PerspectiveSpacer";
    public static final String STATUS_LINE_ID = "org.eclipse.ui.StatusLine";
    public static final String TRIM_CONTRIBUTION_URI = "bundleclass://org.eclipse.ui.workbench/org.eclipse.ui.internal.StandardTrim";
    private static final String COMMAND_ID_TOGGLE_COOLBAR = "org.eclipse.ui.ToggleCoolbarAction";
    public static final String ACTION_SET_CMD_PREFIX = "AS::";
    private static final String PERSISTED_STATE_RESTORED = "isRestored";
    @Inject
    private IWorkbench workbench;
    @Inject
    private MTrimmedWindow model;
    @Inject
    private IPresentationEngine engine;
    @Inject
    private IRendererFactory rendererFactory;
    @Inject
    private MApplication application;
    @Inject
    EModelService modelService;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    @Optional
    private Logger logger;
    @Inject
    private IExtensionRegistry extensionRegistry;
    private WorkbenchPage page;
    private WorkbenchWindowAdvisor windowAdvisor;
    private ActionBarAdvisor actionBarAdvisor;
    private MenuManagerRenderer renderer;
    private MMenu mainMenu;
    private PageListenerList pageListeners = new PageListenerList();
    private PerspectiveListenerList perspectiveListeners = new PerspectiveListenerList();
    private PartService partService = new WWinPartService();
    private WWinActionBars actionBars;
    private boolean updateDisabled = false;
    private boolean closing = false;
    private boolean shellActivated = false;
    ProgressRegion progressRegion = null;
    private List<MTrimElement> workbenchTrimElements = new ArrayList<MTrimElement>();
    private Map<MToolControl, IConfigurationElement> iceMap = new HashMap<MToolControl, IConfigurationElement>();
    private ServiceLocator serviceLocator;
    private int submenus = 0;
    private WorkbenchWindowConfigurer windowConfigurer = null;
    private ListenerList<IPropertyChangeListener> genericPropertyListeners = new ListenerList();
    private IAdaptable input;
    private IPerspectiveDescriptor perspective;
    private EventHandler windowWidgetHandler = event -> {
        if (event.getProperty("ChangedElement") == this.model && event.getProperty("NewValue") == null) {
            this.manageChanges = false;
            this.canUpdateMenus = false;
            this.menuUpdater = null;
            MMenu menu = this.model.getMainMenu();
            if (menu != null) {
                this.engine.removeGui((MUIElement)menu);
                this.model.setMainMenu(null);
            }
            this.eventBroker.unsubscribe(this.windowWidgetHandler);
        }
    };
    static final String TEXT_DELIMITERS = String.valueOf(TextProcessor.getDefaultDelimiters()) + "-";
    static final String MOVE_TAG = "move_";
    private static final List<String> QUICK_ACCESS_ELEMENT_IDS = Collections.unmodifiableList(Arrays.asList("Spacer Glue", "SearchField", "Search-PS Glue"));
    public static final String PROP_COOLBAR_VISIBLE = "coolbarVisible";
    public static final String PROP_PERSPECTIVEBAR_VISIBLE = "perspectiveBarVisible";
    public static final String PROP_STATUS_LINE_VISIBLE = "statusLineVisible";
    public static final int SHOW_VIEW_SUBMENU = 1;
    public static final int OPEN_PERSPECTIVE_SUBMENU = 2;
    public static final int NEW_WIZARD_SUBMENU = 4;
    private static final int FILL_ALL_ACTION_BARS = 14;
    private boolean manageChanges = true;
    private boolean canUpdateMenus = true;
    private static final String QUICK_ACCESS_ID = "SearchField";
    private static final String QUICK_ACCESS_HIDDEN = "QUICK_ACCESS_HIDDEN";
    private static final String QUICK_ACCESS_DEFAULT_VISIBILITY_CHANGED = "QUICK_ACCESS_DEFAULT_VISIBILITY_CHANGED";
    private boolean coolBarVisible = true;
    private boolean perspectiveBarVisible = true;
    private boolean statusLineVisible = true;
    private Map<String, ActionHandler> globalActionHandlersByCommandId = new HashMap<String, ActionHandler>();
    private List<IHandlerActivation> handlerActivations = new ArrayList<IHandlerActivation>();
    private int largeUpdates = 0;
    private IExtensionTracker tracker;
    private Set<Object> menuRestrictions = new HashSet<Object>();
    private ListenerList<IActionSetsListener> actionSetListeners = null;
    private ListenerList<IBackgroundSaveListener> backgroundSaveListeners = new ListenerList(1);
    private SelectionService selectionService;
    private ActionPresentation actionPresentation;
    StatusLineManager statusLineManager = null;
    private CoolBarManager2 oldCBM = new CoolBarManager2();
    private CoolBarToTrimManager coolbarToTrim;
    private IContributionManagerOverrides toolbarOverride;
    MenuManager menuManager = new MenuManager("MenuBar", "org.eclipse.ui.main.menu");
    private IContributionManagerOverrides menuOverride;
    ToolBarManager2 toolBarManager = new ToolBarManager2();
    private Runnable menuUpdater;
    @Inject
    @Optional
    private ToolBarManagerRenderer toolBarManagerRenderer;

    public IConfigurationElement getICEFor(MToolControl mtc) {
        return this.iceMap.get(mtc);
    }

    public void addSubmenu(int type) {
        this.submenus |= type;
    }

    public boolean containsSubmenu(int type) {
        return (this.submenus & type) != 0;
    }

    public WorkbenchWindow(IAdaptable input, IPerspectiveDescriptor pers) {
        this.input = input;
        this.perspective = pers;
    }

    @PostConstruct
    public void setup() {
        try {
            final IEclipseContext windowContext = this.model.getContext();
            HandlerServiceImpl.push((IEclipseContext)windowContext.getParent(), null);
            if (this.getModel().getPersistedState().containsKey("coolBarVisible")) {
                this.coolBarVisible = Boolean.parseBoolean((String)this.getModel().getPersistedState().get("coolBarVisible"));
            } else {
                this.coolBarVisible = PrefUtil.getInternalPreferenceStore().getBoolean("coolBarVisible");
                this.getModel().getPersistedState().put("coolBarVisible", Boolean.toString(this.coolBarVisible));
            }
            if (this.getModel().getPersistedState().containsKey(PROP_PERSPECTIVEBAR_VISIBLE)) {
                this.perspectiveBarVisible = Boolean.parseBoolean((String)this.getModel().getPersistedState().get(PROP_PERSPECTIVEBAR_VISIBLE));
            } else {
                this.perspectiveBarVisible = PrefUtil.getInternalPreferenceStore().getBoolean(PROP_PERSPECTIVEBAR_VISIBLE);
                this.getModel().getPersistedState().put(PROP_PERSPECTIVEBAR_VISIBLE, Boolean.toString(this.perspectiveBarVisible));
            }
            IServiceLocatorCreator slc = (IServiceLocatorCreator)this.workbench.getService(IServiceLocatorCreator.class);
            this.serviceLocator = (ServiceLocator)slc.createServiceLocator(this.workbench, null, () -> {
                Shell shell = this.getShell();
                if (shell != null && !shell.isDisposed()) {
                    this.close();
                }
            }, windowContext);
            windowContext.set(IExtensionTracker.class.getName(), (Object)new ContextFunction(){

                public Object compute(IEclipseContext context, String contextKey) {
                    if (WorkbenchWindow.this.tracker == null) {
                        WorkbenchWindow.this.tracker = new UIExtensionTracker(arg_0 -> ((Display)WorkbenchWindow.this.getWorkbench().getDisplay()).asyncExec(arg_0), WorkbenchPlugin.getDefault().getLog());
                    }
                    return WorkbenchWindow.this.tracker;
                }
            });
            windowContext.set(IWindowCloseHandler.class.getName(), window -> this.getWindowAdvisor().preWindowShellClose() && this.close());
            final ISaveHandler defaultSaveHandler = (ISaveHandler)windowContext.get(ISaveHandler.class);
            WWinPartServiceSaveHandler localSaveHandler = new WWinPartServiceSaveHandler(this){

                public ISaveHandler.Save promptToSave(MPart dirtyPart) {
                    IWorkbenchPart part;
                    ISaveablePart saveable;
                    Object object = dirtyPart.getObject();
                    if (object instanceof CompatibilityPart && (saveable = SaveableHelper.getSaveable(part = ((CompatibilityPart)object).getPart())) != null) {
                        if (!saveable.isSaveOnCloseNeeded()) {
                            return ISaveHandler.Save.NO;
                        }
                        return SaveableHelper.savePart(saveable, part, this, true) ? ISaveHandler.Save.NO : ISaveHandler.Save.CANCEL;
                    }
                    return defaultSaveHandler.promptToSave(dirtyPart);
                }

                public ISaveHandler.Save[] promptToSave(Collection<MPart> dirtyParts) {
                    LabelProvider labelProvider = new LabelProvider(){

                        public String getText(Object element) {
                            return ((MPart)element).getLocalizedLabel();
                        }
                    };
                    ArrayList<MPart> parts = new ArrayList<MPart>(dirtyParts);
                    ListSelectionDialog dialog = new ListSelectionDialog(this.getShell(), parts, (IStructuredContentProvider)ArrayContentProvider.getInstance(), (ILabelProvider)labelProvider, WorkbenchMessages.EditorManager_saveResourcesMessage);
                    dialog.setInitialSelections(parts.toArray());
                    dialog.setTitle(WorkbenchMessages.EditorManager_saveResourcesTitle);
                    if (dialog.open() == 1) {
                        return new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL};
                    }
                    Object[] toSave = dialog.getResult();
                    Object[] retSaves = new ISaveHandler.Save[parts.size()];
                    Arrays.fill(retSaves, ISaveHandler.Save.NO);
                    int i = 0;
                    while (i < retSaves.length) {
                        MPart part = (MPart)parts.get(i);
                        Object[] objectArray = toSave;
                        int n = toSave.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object o = objectArray[n2];
                            if (o == part) {
                                retSaves[i] = ISaveHandler.Save.YES;
                                break;
                            }
                            ++n2;
                        }
                        ++i;
                    }
                    return retSaves;
                }

                public boolean save(MPart dirtyPart, boolean confirm) {
                    Object object = dirtyPart.getObject();
                    if (object instanceof CompatibilityPart) {
                        IWorkbenchPart workbenchPart = ((CompatibilityPart)object).getPart();
                        if (SaveableHelper.isSaveable(workbenchPart)) {
                            SaveablesList saveablesList = (SaveablesList)PlatformUI.getWorkbench().getService(ISaveablesLifecycleListener.class);
                            Object saveResult = saveablesList.preCloseParts(Collections.singletonList(workbenchPart), true, this);
                            return saveResult != null;
                        }
                    } else if (this.isSaveOnCloseNotNeededSplitEditorPart(dirtyPart)) {
                        return true;
                    }
                    return super.save(dirtyPart, confirm);
                }

                private boolean saveParts(ArrayList<MPart> dirtyParts, ISaveHandler.Save[] decisions) {
                    int n;
                    if (decisions == null || decisions.length == 0) {
                        super.saveParts(dirtyParts, true);
                    }
                    if (dirtyParts.size() != decisions.length) {
                        ISaveHandler.Save[] saveArray = decisions;
                        n = decisions.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ISaveHandler.Save decision = saveArray[n2];
                            if (decision == ISaveHandler.Save.CANCEL) {
                                return false;
                            }
                            ++n2;
                        }
                    }
                    List<MPart> dirtyPartsList = Collections.unmodifiableList(new ArrayList<MPart>(dirtyParts));
                    ISaveHandler.Save[] saveArray = decisions;
                    int n3 = decisions.length;
                    n = 0;
                    while (n < n3) {
                        ISaveHandler.Save decision = saveArray[n];
                        if (decision == ISaveHandler.Save.CANCEL) {
                            return false;
                        }
                        ++n;
                    }
                    int i = 0;
                    while (i < decisions.length) {
                        if (decisions[i] == ISaveHandler.Save.YES && !this.save(dirtyPartsList.get(i), false)) {
                            return false;
                        }
                        ++i;
                    }
                    return true;
                }

                private boolean saveMixedParts(ArrayList<MPart> nonCompParts, ArrayList<IWorkbenchPart> compParts, boolean confirm, boolean addNonPartSources) {
                    int n;
                    SaveablesList saveablesList = (SaveablesList)PlatformUI.getWorkbench().getService(ISaveablesLifecycleListener.class);
                    if (!confirm) {
                        boolean saved = super.saveParts(nonCompParts, confirm);
                        Object saveResult = saveablesList.preCloseParts(compParts, true, this);
                        return saveResult != null && saved;
                    }
                    LabelProvider labelProvider = new LabelProvider(){
                        WorkbenchPartLabelProvider workbenchLabelProvider = new WorkbenchPartLabelProvider();

                        public String getText(Object element) {
                            if (element instanceof Saveable) {
                                return this.workbenchLabelProvider.getText(element);
                            }
                            return ((MPart)element).getLocalizedLabel();
                        }
                    };
                    ArrayList<Object> listParts = new ArrayList<Object>();
                    Map<IWorkbenchPart, List<Saveable>> saveableMap = saveablesList.getSaveables(compParts);
                    listParts.addAll(nonCompParts);
                    LinkedHashSet<Saveable> saveablesSet = new LinkedHashSet<Saveable>();
                    for (IWorkbenchPart workbenchPart : compParts) {
                        List<Saveable> list = saveableMap.get(workbenchPart);
                        if (list == null) continue;
                        saveablesSet.addAll(list);
                    }
                    if (addNonPartSources) {
                        ISaveablesSource[] iSaveablesSourceArray = saveablesList.getNonPartSources();
                        int list = iSaveablesSourceArray.length;
                        int n2 = 0;
                        while (n2 < list) {
                            Saveable[] saveables;
                            ISaveablesSource nonPartSource = iSaveablesSourceArray[n2];
                            Saveable[] saveableArray = saveables = nonPartSource.getSaveables();
                            n = saveables.length;
                            int n3 = 0;
                            while (n3 < n) {
                                Saveable saveable = saveableArray[n3];
                                if (saveable.isDirty()) {
                                    saveablesSet.add(saveable);
                                }
                                ++n3;
                            }
                            ++n2;
                        }
                    }
                    listParts.addAll(saveablesSet);
                    ListSelectionDialog dialog = new ListSelectionDialog(this.getShell(), listParts, (IStructuredContentProvider)ArrayContentProvider.getInstance(), (ILabelProvider)labelProvider, WorkbenchMessages.EditorManager_saveResourcesMessage);
                    dialog.setInitialSelections(listParts.toArray());
                    dialog.setTitle(WorkbenchMessages.EditorManager_saveResourcesTitle);
                    if (dialog.open() == 1) {
                        return false;
                    }
                    Object[] toSave = dialog.getResult();
                    Object[] nonCompatSaves = new ISaveHandler.Save[nonCompParts.size()];
                    Object[] compatSaves = new ISaveHandler.Save[saveablesSet.size()];
                    Arrays.fill(nonCompatSaves, ISaveHandler.Save.NO);
                    Arrays.fill(compatSaves, ISaveHandler.Save.NO);
                    int i = 0;
                    while (i < nonCompatSaves.length) {
                        MPart part = nonCompParts.get(i);
                        Object[] objectArray = toSave;
                        int n4 = toSave.length;
                        n = 0;
                        while (n < n4) {
                            Object o = objectArray[n];
                            if (o == part) {
                                nonCompatSaves[i] = ISaveHandler.Save.YES;
                                break;
                            }
                            ++n;
                        }
                        ++i;
                    }
                    HashMap<Saveable, ISaveHandler.Save> saveOptionMap = new HashMap<Saveable, ISaveHandler.Save>();
                    for (Saveable saveable : saveablesSet) {
                        boolean found = false;
                        Object[] objectArray = toSave;
                        int n5 = toSave.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            Object o = objectArray[n6];
                            if (o == saveable) {
                                saveOptionMap.put(saveable, ISaveHandler.Save.YES);
                                found = true;
                                break;
                            }
                            ++n6;
                        }
                        if (found) continue;
                        saveOptionMap.put(saveable, ISaveHandler.Save.NO);
                    }
                    boolean saved = this.saveParts(nonCompParts, (ISaveHandler.Save[])nonCompatSaves);
                    if (!saved) {
                        return saved;
                    }
                    Object saveResult = saveablesList.preCloseParts(compParts, false, true, this, saveOptionMap);
                    return saveResult != null && saved;
                }

                private void removeSaveOnCloseNotNeededParts(List<IWorkbenchPart> parts) {
                    Iterator<IWorkbenchPart> it = parts.iterator();
                    while (it.hasNext()) {
                        IWorkbenchPart part = it.next();
                        ISaveablePart saveable = SaveableHelper.getSaveable(part);
                        if (saveable != null && saveable.isSaveOnCloseNeeded()) continue;
                        it.remove();
                    }
                }

                private void removeSaveOnCloseNotNeededSplitEditorParts(List<MPart> parts) {
                    Iterator<MPart> it = parts.iterator();
                    while (it.hasNext()) {
                        MPart part = it.next();
                        if (!this.isSaveOnCloseNotNeededSplitEditorPart(part)) continue;
                        it.remove();
                    }
                }

                private boolean isSaveOnCloseNotNeededSplitEditorPart(MPart part) {
                    MCompositePart compPart;
                    List elements;
                    boolean notNeeded = false;
                    if (part instanceof MCompositePart && SplitHost.SPLIT_HOST_CONTRIBUTOR_URI.equals(part.getContributionURI()) && (elements = modelService.findElements((MUIElement)(compPart = (MCompositePart)part), null, MPart.class)) != null && elements.size() > 1) {
                        elements.remove(0);
                        for (MPart mpart : elements) {
                            Object object = mpart.getObject();
                            if (object instanceof CompatibilityPart) {
                                IWorkbenchPart workbenchPart = ((CompatibilityPart)object).getPart();
                                if (!SaveableHelper.isSaveable(workbenchPart)) {
                                    notNeeded = true;
                                    continue;
                                }
                                ISaveablePart saveable = SaveableHelper.getSaveable(workbenchPart);
                                if (saveable == null || !saveable.isSaveOnCloseNeeded()) {
                                    notNeeded = true;
                                    continue;
                                }
                                notNeeded = false;
                                break;
                            }
                            notNeeded = false;
                            break;
                        }
                    }
                    return notNeeded;
                }

                @Override
                public boolean saveParts(Collection<MPart> dirtyParts, boolean confirm, boolean closing, boolean addNonPartSources) {
                    ArrayList<IWorkbenchPart> saveableParts = new ArrayList<IWorkbenchPart>();
                    ArrayList<MPart> nonCompatibilityParts = new ArrayList<MPart>();
                    for (MPart part : dirtyParts) {
                        Object object = part.getObject();
                        if (object instanceof CompatibilityPart) {
                            IWorkbenchPart workbenchPart = ((CompatibilityPart)object).getPart();
                            if (!SaveableHelper.isSaveable(workbenchPart)) continue;
                            saveableParts.add(workbenchPart);
                            continue;
                        }
                        nonCompatibilityParts.add(part);
                    }
                    if (!saveableParts.isEmpty() && closing) {
                        this.removeSaveOnCloseNotNeededParts(saveableParts);
                    }
                    if (!nonCompatibilityParts.isEmpty() && closing) {
                        this.removeSaveOnCloseNotNeededSplitEditorParts(nonCompatibilityParts);
                    }
                    if (saveableParts.isEmpty()) {
                        if (nonCompatibilityParts.isEmpty()) {
                            return true;
                        }
                        return super.saveParts(nonCompatibilityParts, confirm);
                    }
                    if (!nonCompatibilityParts.isEmpty()) {
                        return this.saveMixedParts(nonCompatibilityParts, saveableParts, confirm, addNonPartSources);
                    }
                    SaveablesList saveablesList = (SaveablesList)PlatformUI.getWorkbench().getService(ISaveablesLifecycleListener.class);
                    Object saveResult = saveablesList.preCloseParts(saveableParts, addNonPartSources, true, (IShellProvider)this, this);
                    return saveResult != null;
                }

                public boolean saveParts(Collection<MPart> dirtyParts, boolean confirm) {
                    return this.saveParts(dirtyParts, confirm, false, false);
                }
            };
            localSaveHandler.logger = this.logger;
            windowContext.set(ISaveHandler.class, (Object)localSaveHandler);
            windowContext.set(IWorkbenchWindow.class.getName(), (Object)this);
            windowContext.set(IPageService.class, (Object)this);
            windowContext.set(IPartService.class, (Object)this.partService);
            windowContext.set("activeWorkbenchWindow", (Object)this);
            windowContext.set("activeWorkbenchWindowShell", (Object)this.getShell());
            EContextService cs = (EContextService)windowContext.get(EContextService.class);
            cs.activateContext("org.eclipse.ui.contexts.window");
            cs.getActiveContextIds();
            this.initializeDefaultServices();
            this.cleanLegacyQuickAccessContribution();
            this.fireWindowOpening();
            this.configureShell(this.getShell(), windowContext);
            try {
                this.page = new WorkbenchPage(this, this.input);
            }
            catch (WorkbenchException e) {
                WorkbenchPlugin.log((Throwable)((Object)e));
            }
            this.menuOverride = new MenuOverrides(this.page);
            this.toolbarOverride = new ToolbarOverrides(this.page);
            ContextInjectionFactory.inject((Object)this.page, (IEclipseContext)this.model.getContext());
            windowContext.set(IWorkbenchPage.class, (Object)this.page);
            this.menuManager.setOverrides(this.menuOverride);
            ((CoolBarToTrimManager)this.getCoolBarManager2()).setOverrides(this.toolbarOverride);
            this.fillActionBars(14);
            this.firePageOpened();
            this.populateTopTrimContributions();
            this.populateBottomTrimContributions();
            this.modelService.getTrim(this.model, SideValue.LEFT);
            this.modelService.getTrim(this.model, SideValue.RIGHT);
            this.positionQuickAccess();
            Shell shell = (Shell)this.model.getWidget();
            if (this.model.getMainMenu() == null) {
                this.mainMenu = (MMenu)this.modelService.createModelElement(MMenu.class);
                this.mainMenu.setElementId("org.eclipse.ui.main.menu");
                this.mainMenu.getPersistedState().put("persistState", Boolean.FALSE.toString());
                this.renderer = (MenuManagerRenderer)this.rendererFactory.getRenderer((MUIElement)this.mainMenu, null);
                this.renderer.linkModelToManager(this.mainMenu, this.menuManager);
                this.renderer.reconcileManagerToModel(this.menuManager, this.mainMenu);
                this.model.setMainMenu(this.mainMenu);
                Menu menu = (Menu)this.engine.createGui((MUIElement)this.mainMenu, this.model.getWidget(), this.model.getContext());
                shell.setMenuBar(menu);
                this.menuUpdater = () -> {
                    try {
                        if (this.model.getMainMenu() == null || this.model.getWidget() == null || menu.isDisposed() || this.mainMenu.getWidget() == null) {
                            return;
                        }
                        MenuManagerRendererFilter.updateElementVisibility((MMenu)this.mainMenu, (MenuManagerRenderer)this.renderer, (MenuManager)this.menuManager, (IEclipseContext)windowContext.getActiveLeaf(), (int)1, (boolean)false);
                        this.menuManager.update(true);
                    }
                    finally {
                        this.canUpdateMenus = true;
                    }
                };
                RunAndTrack menuChangeManager = new RunAndTrack(){

                    public boolean changed(IEclipseContext context) {
                        ExpressionInfo info = new ExpressionInfo();
                        IEclipseContext leafContext = windowContext.getActiveLeaf();
                        MenuManagerRendererFilter.collectInfo((ExpressionInfo)info, (MMenu)WorkbenchWindow.this.mainMenu, (MenuManagerRenderer)WorkbenchWindow.this.renderer, (IEclipseContext)leafContext, (boolean)true);
                        String[] stringArray = info.getAccessedVariableNames();
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String name = stringArray[n2];
                            leafContext.get(name);
                            ++n2;
                        }
                        if (WorkbenchWindow.this.canUpdateMenus && WorkbenchWindow.this.workbench.getDisplay() != null) {
                            WorkbenchWindow.this.canUpdateMenus = false;
                            WorkbenchWindow.this.workbench.getDisplay().asyncExec(WorkbenchWindow.this.menuUpdater);
                        }
                        return WorkbenchWindow.this.manageChanges;
                    }
                };
                windowContext.runAndTrack(menuChangeManager);
            }
            this.eventBroker.subscribe("org/eclipse/e4/ui/model/ui/UIElement/widget/*", this.windowWidgetHandler);
            boolean newWindow = this.setupPerspectiveStack(windowContext);
            this.partService.setPage(this.page);
            this.page.setPerspective(this.perspective);
            this.firePageActivated();
            if (newWindow) {
                this.page.fireInitialPartVisibilityEvents();
            } else {
                this.page.updatePerspectiveActionSets();
            }
            this.updateActionSets();
            IPreferenceStore preferenceStore = PrefUtil.getAPIPreferenceStore();
            boolean enableAnimations = preferenceStore.getBoolean("ENABLE_ANIMATIONS");
            preferenceStore.setValue("ENABLE_ANIMATIONS", false);
            List persps = this.modelService.findElements((MUIElement)this.model, null, MPerspective.class, null);
            if (persps.size() > 1) {
                PrefUtil.getAPIPreferenceStore().setValue("showIntro", false);
                PrefUtil.saveAPIPrefs();
            }
            if (Boolean.parseBoolean((String)this.getModel().getPersistedState().get(PERSISTED_STATE_RESTORED))) {
                SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                    public void run() throws Exception {
                        WorkbenchWindow.this.getWindowAdvisor().postWindowRestore();
                    }
                });
            } else {
                this.getModel().getPersistedState().put(PERSISTED_STATE_RESTORED, Boolean.TRUE.toString());
            }
            this.getWindowAdvisor().postWindowCreate();
            this.getWindowAdvisor().openIntro();
            preferenceStore.setValue("ENABLE_ANIMATIONS", enableAnimations);
            this.getShell().setData((Object)this);
            this.trackShellActivation();
            this.getShell().addListener(55, event -> {
                if (this.getShell().getDisplay().getPrimaryMonitor().equals((Object)this.getShell().getMonitor())) {
                    int dialogResponse = MessageDialog.open((int)3, (Shell)this.getShell(), (String)WorkbenchMessages.Workbench_zoomChangedTitle, (String)WorkbenchMessages.Workbench_zoomChangedMessage, (int)0, (String[])new String[]{WorkbenchMessages.Workbench_RestartButton, WorkbenchMessages.Workbench_DontRestartButton});
                    if (event.doit && dialogResponse == 0) {
                        this.getWorkbenchImpl().restart(true);
                    }
                }
            });
        }
        finally {
            HandlerServiceImpl.pop();
        }
    }

    @PreDestroy
    void preDestroy() {
        if (this.mainMenu != null) {
            this.renderer.clearModelToManager(this.mainMenu, this.menuManager);
            this.mainMenu = null;
        }
        this.renderer = null;
    }

    private void configureShell(Shell shell, IEclipseContext context) {
        String title = this.getWindowConfigurer().basicGetTitle();
        if (title != null) {
            shell.setText(TextProcessor.process((String)title, (String)TEXT_DELIMITERS));
        }
        this.workbench.getHelpSystem().setHelp((Control)shell, "org.eclipse.ui.workbench_window_context");
        IContextService contextService = (IContextService)context.get(IContextService.class);
        contextService.registerShell(shell, 2);
        if (this.model.getContext().get("NO_SAVED_MODEL_FOUND") != null) {
            Point initialSize = this.getWindowConfigurer().getInitialSize();
            Rectangle bounds = shell.getBounds();
            bounds.width = initialSize.x;
            bounds.height = initialSize.y;
            shell.setBounds(bounds);
        }
    }

    private boolean setupPerspectiveStack(IEclipseContext context) {
        IPerspectiveRegistry registry = this.getWorkbench().getPerspectiveRegistry();
        String forcedPerspectiveId = (String)context.get("forcedPerspetiveId");
        if (forcedPerspectiveId != null) {
            this.perspective = registry.findPerspectiveWithId(forcedPerspectiveId);
        }
        List perspStackList = this.modelService.findElements((MUIElement)this.model, null, MPerspectiveStack.class, null);
        MPerspective selectedPersp = null;
        if (!perspStackList.isEmpty()) {
            selectedPersp = (MPerspective)((MPerspectiveStack)perspStackList.get(0)).getSelectedElement();
        }
        if (forcedPerspectiveId == null && selectedPersp != null) {
            this.perspective = registry.findPerspectiveWithId(selectedPersp.getElementId());
        }
        if (this.perspective == null) {
            this.perspective = registry.findPerspectiveWithId(registry.getDefaultPerspective());
        }
        return selectedPersp == null;
    }

    void populateTopTrimContributions() {
        this.getCoolBarManager2().update(true);
        this.getCoolBarManager2().add((IContributionItem)new GroupMarker("additions"));
        MTrimBar trimBar = this.getTopTrim();
        MToolControl spacerControl = (MToolControl)this.modelService.find(PERSPECTIVE_SPACER_ID, (MUIElement)this.model);
        if (spacerControl == null) {
            spacerControl = (MToolControl)this.modelService.createModelElement(MToolControl.class);
            spacerControl.setElementId(PERSPECTIVE_SPACER_ID);
            spacerControl.setContributionURI("bundleclass://org.eclipse.e4.ui.workbench.renderers.swt/org.eclipse.e4.ui.workbench.renderers.swt.LayoutModifierToolControl");
            spacerControl.getTags().add("stretch");
            spacerControl.getTags().add("SHOW_RESTORE_MENU");
            trimBar.getChildren().add(spacerControl);
        } else if (!spacerControl.getTags().contains("SHOW_RESTORE_MENU")) {
            spacerControl.getTags().add("SHOW_RESTORE_MENU");
        }
        MToolControl switcherControl = (MToolControl)this.modelService.find("PerspectiveSwitcher", (MUIElement)this.model);
        if (switcherControl == null && this.getWindowConfigurer().getShowPerspectiveBar()) {
            switcherControl = (MToolControl)this.modelService.createModelElement(MToolControl.class);
            switcherControl.setToBeRendered(this.getWindowConfigurer().getShowPerspectiveBar());
            switcherControl.setElementId("PerspectiveSwitcher");
            switcherControl.getTags().add("Draggable");
            switcherControl.getTags().add("HIDEABLE");
            switcherControl.getTags().add("SHOW_RESTORE_MENU");
            switcherControl.setContributionURI("bundleclass://org.eclipse.ui.workbench/org.eclipse.e4.ui.workbench.addons.perspectiveswitcher.PerspectiveSwitcher");
            trimBar.getChildren().add(switcherControl);
        } else if (switcherControl != null) {
            if (!this.getWindowConfigurer().getShowPerspectiveBar()) {
                trimBar.getChildren().remove(switcherControl);
            } else {
                List tags = switcherControl.getTags();
                if (!tags.contains("HIDEABLE")) {
                    tags.add("HIDEABLE");
                }
                if (!tags.contains("SHOW_RESTORE_MENU")) {
                    tags.add("SHOW_RESTORE_MENU");
                }
            }
        }
        this.updateLayoutDataForContents();
    }

    private void cleanLegacyQuickAccessContribution() {
        for (String quickAccessElementId : QUICK_ACCESS_ELEMENT_IDS) {
            MToolControl legacyElement = (MToolControl)this.modelService.find(quickAccessElementId, (MUIElement)this.model);
            if (legacyElement == null) continue;
            EcoreUtil.remove((EObject)((EObject)legacyElement));
        }
    }

    private void positionQuickAccess() {
        for (String quickAccessElementId : QUICK_ACCESS_ELEMENT_IDS) {
            MToolControl quickAccessElement = (MToolControl)this.modelService.find(quickAccessElementId, (MUIElement)this.model);
            if (quickAccessElement == null) continue;
            this.moveControl((MElementContainer<MUIElement>)quickAccessElement.getParent(), (MUIElement)quickAccessElement);
            if (!QUICK_ACCESS_ID.equals(quickAccessElement.getElementId())) continue;
            if (this.model.getTags().contains(QUICK_ACCESS_HIDDEN)) {
                if (quickAccessElement.getTags().contains("HIDDEN_EXPLICITLY")) continue;
                quickAccessElement.getTags().add("HIDDEN_EXPLICITLY");
                continue;
            }
            if (this.model.getTags().contains(QUICK_ACCESS_DEFAULT_VISIBILITY_CHANGED) || !WorkbenchWindow.hidesQuickAccessPerDefault()) continue;
            quickAccessElement.getTags().add("HIDDEN_EXPLICITLY");
        }
    }

    private static boolean hidesQuickAccessPerDefault() {
        IPreferenceStore preferenceStore = PlatformUI.getPreferenceStore();
        return preferenceStore.getBoolean("hideQuickAccessPerDefault");
    }

    @Inject
    @Optional
    private void hideQuickAccess(@UIEventTopic(value="org/eclipse/e4/ui/model/application/ApplicationElement/tags/*") Event event) {
        Object origin = event.getProperty("ChangedElement");
        if (!(origin instanceof MToolControl)) {
            return;
        }
        MToolControl control = (MToolControl)origin;
        if (!QUICK_ACCESS_ID.equals(control.getElementId())) {
            return;
        }
        MWindow myWindow = this.modelService.getTopLevelWindowFor((MUIElement)control);
        if (myWindow != this.model) {
            return;
        }
        if (UIEvents.isADD((Event)event)) {
            if (UIEvents.contains((Event)event, (String)"NewValue", (Object)"HIDDEN_EXPLICITLY") && !this.model.getTags().contains(QUICK_ACCESS_HIDDEN)) {
                this.model.getTags().add(QUICK_ACCESS_HIDDEN);
                this.quickAccessDefaultVisibilityChanged();
            }
        } else if (UIEvents.isREMOVE((Event)event) && UIEvents.contains((Event)event, (String)"OldValue", (Object)"HIDDEN_EXPLICITLY")) {
            this.model.getTags().remove(QUICK_ACCESS_HIDDEN);
            this.quickAccessDefaultVisibilityChanged();
        }
    }

    private void quickAccessDefaultVisibilityChanged() {
        this.model.getTags().add(QUICK_ACCESS_DEFAULT_VISIBILITY_CHANGED);
    }

    private void moveControl(MElementContainer<MUIElement> elementContainer, MUIElement element) {
        List elements;
        if (element == null || elementContainer == null) {
            return;
        }
        PositionInfo positionInfo = this.findMovePositionInfo(element);
        if (positionInfo != null && (elements = elementContainer.getChildren()).remove(element)) {
            switch (positionInfo.getPosition()) {
                case LAST: {
                    elements.add(element);
                    break;
                }
                case FIRST: {
                    elements.add(0, element);
                    break;
                }
                case INDEX: {
                    int index = positionInfo.getPositionReferenceAsInteger();
                    if (index >= 0 && index < elements.size()) {
                        elements.add(index, element);
                        break;
                    }
                    elements.add(element);
                    break;
                }
                case BEFORE: 
                case AFTER: {
                    int idx = this.indexOfElementWithID(elements, positionInfo.getPositionReference());
                    if (idx < 0) {
                        elements.add(element);
                        break;
                    }
                    if (positionInfo.getPosition() == Position.AFTER) {
                        ++idx;
                    }
                    if (idx < elements.size()) {
                        elements.add(idx, element);
                        break;
                    }
                    elements.add(element);
                    break;
                }
                default: {
                    WorkbenchPlugin.log("Can't position control '" + element.getElementId() + "' because of the unknown position type '" + positionInfo.getPosition() + "'!");
                }
            }
        }
    }

    private int indexOfElementWithID(List<MUIElement> elements, String id) {
        if (elements == null || id == null) {
            return -1;
        }
        int index = 0;
        for (MUIElement element : elements) {
            if (id.equals(element.getElementId())) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private PositionInfo findMovePositionInfo(MUIElement element) {
        if (element != null) {
            for (String tag : element.getTags()) {
                if (!tag.startsWith(MOVE_TAG)) continue;
                return PositionInfo.parse((String)tag.substring(MOVE_TAG.length()));
            }
        }
        return null;
    }

    private void populateStandardTrim(MTrimBar bottomTrim) {
        MToolControl slElement = (MToolControl)this.modelService.find(STATUS_LINE_ID, (MUIElement)this.model);
        if (slElement == null) {
            slElement = (MToolControl)this.modelService.createModelElement(MToolControl.class);
            slElement.setElementId(STATUS_LINE_ID);
            slElement.setContributionURI(TRIM_CONTRIBUTION_URI);
            bottomTrim.getChildren().add(slElement);
        }
        slElement.setToBeRendered(this.statusLineVisible);
        slElement.getTags().add("stretch");
        MToolControl hsElement = (MToolControl)this.modelService.find("org.eclipse.ui.HeapStatus", (MUIElement)this.model);
        if (hsElement == null) {
            hsElement = (MToolControl)this.modelService.createModelElement(MToolControl.class);
            hsElement.setElementId("org.eclipse.ui.HeapStatus");
            hsElement.setContributionURI(TRIM_CONTRIBUTION_URI);
            hsElement.getTags().add("Draggable");
            bottomTrim.getChildren().add(hsElement);
        }
        hsElement.setToBeRendered(this.getShowHeapStatus());
        MToolControl pbElement = (MToolControl)this.modelService.find("org.eclipse.ui.ProgressBar", (MUIElement)this.model);
        if (pbElement == null) {
            pbElement = (MToolControl)this.modelService.createModelElement(MToolControl.class);
            pbElement.setElementId("org.eclipse.ui.ProgressBar");
            pbElement.getTags().add("Draggable");
            pbElement.setContributionURI(TRIM_CONTRIBUTION_URI);
            bottomTrim.getChildren().add(pbElement);
        }
        pbElement.setToBeRendered(this.getWindowConfigurer().getShowProgressIndicator());
    }

    private void populateTrimContributions(MTrimBar bottomTrim) {
        IConfigurationElement[] exts = this.extensionRegistry.getConfigurationElementsFor("org.eclipse.ui.menus");
        ArrayList<IConfigurationElement> items = new ArrayList<IConfigurationElement>();
        IConfigurationElement[] iConfigurationElementArray = exts;
        int n = exts.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ice = iConfigurationElementArray[n2];
            if ("group".equals(ice.getName()) || "widget".equals(ice.getName())) {
                items.add(ice);
            }
            ++n2;
        }
        if (items.isEmpty()) {
            return;
        }
        ArrayList<IConfigurationElement> handledElements = new ArrayList<IConfigurationElement>();
        handledElements.add((IConfigurationElement)items.get(0));
        MToolControl createdTrim = null;
        while (!items.isEmpty() && !handledElements.isEmpty()) {
            handledElements.clear();
            for (IConfigurationElement item : items) {
                IConfigurationElement[] locs;
                String id = item.getAttribute("id");
                String classSpec = item.getAttribute("class");
                IConfigurationElement[] iConfigurationElementArray2 = locs = item.getChildren("location");
                int n3 = locs.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement bar;
                    boolean isTrim;
                    IConfigurationElement loc = iConfigurationElementArray2[n4];
                    IConfigurationElement[] bars = loc.getChildren("bar");
                    if (bars.length > 0 && (isTrim = "trim".equals((bar = bars[0]).getAttribute("type")))) {
                        String path = bar.getAttribute("path");
                        if (path != null && path.length() > 0) {
                            createdTrim = this.addTrimElement(bottomTrim, item, id, false, path, classSpec);
                        } else {
                            IConfigurationElement[] orders = loc.getChildren("order");
                            if (orders.length > 0) {
                                boolean isBefore = "before".equals(orders[0].getAttribute("position"));
                                String relTo = orders[0].getAttribute("relativeTo");
                                if ("status".equals(relTo)) {
                                    relTo = STATUS_LINE_ID;
                                }
                                createdTrim = this.addTrimElement(bottomTrim, item, id, isBefore, relTo, classSpec);
                            }
                        }
                        if (createdTrim != null) {
                            handledElements.add(item);
                        }
                    }
                    ++n4;
                }
            }
            items.removeAll(handledElements);
        }
    }

    private MToolControl addTrimElement(MTrimBar bottomTrim, IConfigurationElement ice, String id, boolean isBefore, String relTo, String classSpec) {
        MUIElement existingTrim = this.modelService.find(id, (MUIElement)bottomTrim);
        if (existingTrim != null) {
            this.iceMap.put((MToolControl)existingTrim, ice);
            return (MToolControl)existingTrim;
        }
        int insertIndex = bottomTrim.getChildren().size();
        if (relTo != null) {
            MUIElement foundRel = this.modelService.find(relTo, (MUIElement)bottomTrim);
            if (foundRel == null) {
                return null;
            }
            insertIndex = bottomTrim.getChildren().indexOf(foundRel);
            if (!isBefore) {
                ++insertIndex;
            }
        }
        MToolControl newTrimElement = (MToolControl)this.modelService.createModelElement(MToolControl.class);
        newTrimElement.setElementId(id);
        newTrimElement.setToBeRendered(classSpec != null);
        if (classSpec != null) {
            newTrimElement.setContributionURI("bundleclass://org.eclipse.ui.workbench/org.eclipse.ui.internal.LegacyTrim");
        }
        newTrimElement.setContributorURI(URIHelper.constructPlatformURI((IContributor)ice.getContributor()));
        this.iceMap.put(newTrimElement, ice);
        bottomTrim.getChildren().add(insertIndex, newTrimElement);
        return newTrimElement;
    }

    void populateBottomTrimContributions() {
        MTrimBar bottomTrim = this.modelService.getTrim(this.model, SideValue.BOTTOM);
        this.populateStandardTrim(bottomTrim);
        this.populateTrimContributions(bottomTrim);
    }

    public MTrimBar getTopTrim() {
        List trimBars = this.model.getTrimBars();
        for (MTrimBar bar : trimBars) {
            if (!"org.eclipse.ui.main.toolbar".equals(bar.getElementId())) continue;
            return bar;
        }
        return null;
    }

    public static String getId(IConfigurationElement element) {
        String id = element.getAttribute("id");
        if (id == null || id.isEmpty()) {
            id = WorkbenchWindow.getCommandId(element);
        }
        if (id == null || id.isEmpty()) {
            id = element.toString();
        }
        return id;
    }

    public static String getCommandId(IConfigurationElement element) {
        return element.getAttribute("commandId");
    }

    public static String getActionSetCommandId(IConfigurationElement element) {
        String id = WorkbenchWindow.getDefinitionId(element);
        if (id != null) {
            return id;
        }
        id = WorkbenchWindow.getId(element);
        String actionSetId = null;
        Object obj = element.getParent();
        while (obj instanceof IConfigurationElement && actionSetId == null) {
            IConfigurationElement parent = (IConfigurationElement)obj;
            if (parent.getName().equals("actionSet")) {
                actionSetId = WorkbenchWindow.getId(parent);
            }
            obj = parent.getParent();
        }
        return ACTION_SET_CMD_PREFIX + actionSetId + '/' + id;
    }

    public static String getDefinitionId(IConfigurationElement element) {
        return element.getAttribute("definitionId");
    }

    public static boolean getRetarget(IConfigurationElement element) {
        String r = element.getAttribute("retarget");
        return Boolean.parseBoolean(r);
    }

    protected int perspectiveBarStyle() {
        return 8520000;
    }

    private void firePageClosed() {
        this.pageListeners.firePageClosed(this.page);
    }

    private void firePageOpened() {
        this.pageListeners.firePageOpened(this.page);
    }

    private void firePageActivated() {
        this.pageListeners.firePageActivated(this.page);
    }

    void registerGlobalAction(IAction globalAction) {
        String commandId = globalAction.getActionDefinitionId();
        if (commandId != null) {
            ActionHandler value = this.globalActionHandlersByCommandId.remove(commandId);
            if (value instanceof ActionHandler) {
                ActionHandler handler = value;
                handler.dispose();
            }
            if (globalAction instanceof CommandAction) {
                String actionId = globalAction.getId();
                if (actionId != null) {
                    IActionCommandMappingService mappingService = this.serviceLocator.getService(IActionCommandMappingService.class);
                    mappingService.map(actionId, commandId);
                }
            } else {
                this.globalActionHandlersByCommandId.put(commandId, new ActionHandler(globalAction));
            }
        }
        this.submitGlobalActions();
    }

    void submitGlobalActions() {
        IHandlerService handlerService = this.getService(IHandlerService.class);
        HashMap<String, ActionHandler> handlersByCommandId = new HashMap<String, ActionHandler>();
        handlersByCommandId.putAll(this.globalActionHandlersByCommandId);
        ArrayList<IHandlerActivation> newHandlers = new ArrayList<IHandlerActivation>(handlersByCommandId.size());
        for (IHandlerActivation next : this.handlerActivations) {
            String cmdId = next.getCommandId();
            Object handler = handlersByCommandId.get(cmdId);
            if (handler == next.getHandler()) {
                handlersByCommandId.remove(cmdId);
                newHandlers.add(next);
                continue;
            }
            handlerService.deactivateHandler(next);
        }
        Shell shell = this.getShell();
        if (shell != null) {
            ActiveShellExpression expression = new ActiveShellExpression(shell);
            for (Map.Entry entry : handlersByCommandId.entrySet()) {
                String commandId = (String)entry.getKey();
                IHandler handler = (IHandler)entry.getValue();
                newHandlers.add(handlerService.activateHandler(commandId, handler, expression));
            }
        }
        this.handlerActivations = newHandlers;
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.genericPropertyListeners.add((Object)listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.genericPropertyListeners.remove((Object)listener);
    }

    private void firePropertyChanged(String property, Object oldValue, Object newValue) {
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, property, oldValue, newValue);
        Object[] objectArray = this.genericPropertyListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            IPropertyChangeListener propertyChangeListener = (IPropertyChangeListener)listener;
            propertyChangeListener.propertyChange(event);
            ++n2;
        }
    }

    @Override
    public void addPageListener(IPageListener l) {
        this.pageListeners.addPageListener(l);
    }

    @Override
    public void addPerspectiveListener(IPerspectiveListener l) {
        this.perspectiveListeners.addPerspectiveListener(l);
    }

    private boolean busyClose(boolean remove) {
        if (this.closing) {
            return false;
        }
        if (this.updateDisabled && remove) {
            return false;
        }
        boolean windowClosed = false;
        this.updateDisabled = true;
        try {
            WorkbenchPartReference ref;
            IWorkbenchPage activePage = this.getActivePage();
            if (activePage != null && (ref = (WorkbenchPartReference)activePage.getActivePartReference()) != null) {
                ref.getModel().getTags().add("activeOnClose");
            }
            Workbench workbench = this.getWorkbenchImpl();
            int count = workbench.getWorkbenchWindowCount();
            if (!workbench.isStarting() && !workbench.isClosing() && count <= 1 && workbench.getWorkbenchConfigurer().getExitOnLastWindowClose()) {
                windowClosed = workbench.close();
            } else if (this.okToClose()) {
                this.closing = true;
                windowClosed = this.hardClose(remove);
            }
        }
        finally {
            if (!windowClosed) {
                this.closing = false;
                this.updateDisabled = false;
            }
        }
        if (windowClosed && this.tracker != null) {
            this.tracker.close();
        }
        return windowClosed;
    }

    @Override
    public Shell getShell() {
        return (Shell)this.model.getWidget();
    }

    public boolean close(boolean remove) {
        boolean[] ret = new boolean[1];
        BusyIndicator.showWhile(null, () -> {
            boolean bl2 = this.busyClose(remove);
        });
        return ret[0];
    }

    @Override
    public boolean close() {
        return this.close(true);
    }

    @Override
    public boolean isClosing() {
        return this.closing || this.getWorkbenchImpl().isClosing();
    }

    private void fireWindowOpening() {
        this.getWindowAdvisor().preWindowOpen();
    }

    void fireWindowOpened() {
        this.getWindowAdvisor().postWindowOpen();
    }

    void fireWindowRestored() throws WorkbenchException {
        StartupThreading.runWithWorkbenchExceptions(new StartupThreading.StartupRunnable(){

            @Override
            public void runWithException() throws Throwable {
                WorkbenchWindow.this.getWindowAdvisor().postWindowRestore();
            }
        });
    }

    private void fireWindowClosed() {
        this.getWindowAdvisor().postWindowClose();
        this.getWorkbenchImpl().fireWindowClosed(this);
    }

    private void allowUpdates(IMenuManager menuManager) {
        menuManager.markDirty();
        IContributionItem[] iContributionItemArray = menuManager.getItems();
        int n = iContributionItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem innerItem;
            IContributionItem item = iContributionItemArray[n2];
            if (item instanceof IMenuManager) {
                this.allowUpdates((IMenuManager)item);
            } else if (item instanceof SubContributionItem && (innerItem = ((SubContributionItem)item).getInnerItem()) instanceof IMenuManager) {
                this.allowUpdates((IMenuManager)innerItem);
            }
            ++n2;
        }
    }

    void firePerspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        IMenuManager windowManager = ((WorkbenchPage)page).getActionBars().getMenuManager();
        this.allowUpdates(windowManager);
        windowManager.update(false);
        UIListenerLogging.logPerspectiveEvent(this, page, perspective, "perspectiveActivated");
        this.perspectiveListeners.firePerspectiveActivated(page, perspective);
    }

    void firePerspectivePreDeactivate(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        UIListenerLogging.logPerspectiveEvent(this, page, perspective, "perspectivePreDeactivate");
        this.perspectiveListeners.firePerspectivePreDeactivate(page, perspective);
    }

    void firePerspectiveDeactivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        UIListenerLogging.logPerspectiveEvent(this, page, perspective, "perspectiveDeactivated");
        this.perspectiveListeners.firePerspectiveDeactivated(page, perspective);
    }

    public void firePerspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
        if (perspective != null) {
            UIListenerLogging.logPerspectiveChangedEvent(this, page, perspective, null, changeId);
            this.perspectiveListeners.firePerspectiveChanged(page, perspective, changeId);
        }
    }

    public void firePerspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, IWorkbenchPartReference partRef, String changeId) {
        if (perspective != null) {
            UIListenerLogging.logPerspectiveChangedEvent(this, page, perspective, partRef, changeId);
            this.perspectiveListeners.firePerspectiveChanged(page, perspective, partRef, changeId);
        }
    }

    void firePerspectiveClosed(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        UIListenerLogging.logPerspectiveEvent(this, page, perspective, "perspectiveClosed");
        this.perspectiveListeners.firePerspectiveClosed(page, perspective);
    }

    void firePerspectiveOpened(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        UIListenerLogging.logPerspectiveEvent(this, page, perspective, "perspectiveOpened");
        this.perspectiveListeners.firePerspectiveOpened(page, perspective);
    }

    void firePerspectiveSavedAs(IWorkbenchPage page, IPerspectiveDescriptor oldPerspective, IPerspectiveDescriptor newPerspective) {
        UIListenerLogging.logPerspectiveSavedAs(this, page, oldPerspective, newPerspective);
        this.perspectiveListeners.firePerspectiveSavedAs(page, oldPerspective, newPerspective);
    }

    public WWinActionBars getActionBars() {
        if (this.actionBars == null) {
            this.actionBars = new WWinActionBars(this);
        }
        return this.actionBars;
    }

    @Override
    public IWorkbenchPage getActivePage() {
        return this.page;
    }

    @Override
    public IWorkbenchPage[] getPages() {
        IWorkbenchPage[] iWorkbenchPageArray;
        if (this.page == null) {
            iWorkbenchPageArray = new IWorkbenchPage[]{};
        } else {
            IWorkbenchPage[] iWorkbenchPageArray2 = new IWorkbenchPage[1];
            iWorkbenchPageArray = iWorkbenchPageArray2;
            iWorkbenchPageArray2[0] = this.page;
        }
        return iWorkbenchPageArray;
    }

    @Override
    public IPartService getPartService() {
        return this.partService;
    }

    protected Layout getLayout() {
        return null;
    }

    @Override
    public ISelectionService getSelectionService() {
        return this.selectionService;
    }

    public boolean getShellActivated() {
        return this.shellActivated;
    }

    @Override
    public IWorkbench getWorkbench() {
        return PlatformUI.getWorkbench();
    }

    private void hideNonRestorableViews() {
        ArrayList<MPart> sharedPartsToRemove = new ArrayList<MPart>();
        List phList = this.modelService.findElements((MUIElement)this.model, null, MPlaceholder.class, null);
        for (MPlaceholder ph : phList) {
            if (!(ph.getRef() instanceof MPart)) continue;
            String partId = ph.getElementId();
            int colonIndex = partId.indexOf(58);
            String descId = colonIndex == -1 ? partId : partId.substring(0, colonIndex);
            String secondaryId = colonIndex == -1 ? null : partId.substring(colonIndex + 1);
            IViewDescriptor regEntry = ((Workbench)this.workbench).getViewRegistry().find(descId);
            if (regEntry == null || regEntry.isRestorable() || "*".equals(secondaryId)) continue;
            MElementContainer phParent = ph.getParent();
            if (colonIndex != -1) {
                if (!sharedPartsToRemove.contains(ph.getRef())) {
                    sharedPartsToRemove.add((MPart)ph.getRef());
                }
                ph.getParent().getChildren().remove(ph);
            } else if (ph.isToBeRendered()) {
                ph.setToBeRendered(false);
            }
            int vc = this.modelService.countRenderableChildren((MUIElement)phParent);
            if (vc != 0 || this.isLastEditorStack((MUIElement)phParent)) continue;
            phParent.setToBeRendered(false);
        }
        List seList = this.model.getSharedElements();
        for (MPart partToRemove : sharedPartsToRemove) {
            seList.remove(partToRemove);
        }
    }

    private boolean isLastEditorStack(MUIElement element) {
        return this.modelService.isLastEditorStack(element);
    }

    private boolean hardClose(boolean remove) {
        try {
            if (!remove) {
                this.hideNonRestorableViews();
            }
            IWorkbench workbench = this.getWorkbench();
            LegacyHandlerService windowHs = (LegacyHandlerService)this.model.getContext().get(IHandlerService.class);
            windowHs.dispose();
            IHandlerService handlerService = (IHandlerService)workbench.getService(IHandlerService.class);
            handlerService.deactivateHandlers(this.handlerActivations);
            for (IHandlerActivation activation : this.handlerActivations) {
                activation.getHandler().dispose();
            }
            this.handlerActivations.clear();
            this.globalActionHandlersByCommandId.clear();
            IContextService contextService = (IContextService)workbench.getService(IContextService.class);
            contextService.unregisterShell(this.getShell());
            this.getActionBarAdvisor().dispose();
            this.getWindowAdvisor().dispose();
            this.progressRegion = null;
            MTrimmedWindow window = this.model;
            if (window.getMainMenu() != null) {
                MMenu mainMenu = window.getMainMenu();
                MenuManagerRenderer renderer = (MenuManagerRenderer)this.rendererFactory.getRenderer((MUIElement)mainMenu, null);
                this.cleanupMenuManagerRec(renderer, mainMenu);
            }
            this.engine.removeGui((MUIElement)this.model);
            this.coolbarToTrim.dispose();
            MElementContainer parent = window.getParent();
            if (remove) {
                parent.getChildren().remove(window);
                if (parent.getSelectedElement() == window && !parent.getChildren().isEmpty()) {
                    parent.setSelectedElement((MUIElement)parent.getChildren().get(0));
                }
            }
            if (this.getActivePage() != null) {
                this.firePageClosed();
            }
            if (this.page != null) {
                this.page.close();
                this.page = null;
            }
            this.menuOverride = null;
            this.toolbarOverride = null;
            this.fireWindowClosed();
        }
        finally {
            try {
                this.serviceLocator.dispose();
            }
            catch (Exception ex) {
                WorkbenchPlugin.log(ex);
            }
            this.menuRestrictions.clear();
        }
        return true;
    }

    private void cleanupMenuManagerRec(MenuManagerRenderer renderer, MMenu m) {
        for (MMenuElement e : m.getChildren()) {
            if (!(e instanceof MMenu)) continue;
            this.cleanupMenuManagerRec(renderer, (MMenu)e);
        }
        renderer.clearModelToManager(m, null);
    }

    @Override
    public boolean isApplicationMenu(String menuID) {
        return this.getActionBarAdvisor().isApplicationMenu(menuID);
    }

    boolean isWorkbenchCoolItemId(String id) {
        return this.windowConfigurer.containsCoolItem(id);
    }

    private boolean okToClose() {
        if (!this.getWorkbenchImpl().isClosing()) {
            return this.saveAllParts(true, true, true);
        }
        return true;
    }

    private boolean saveAllParts(boolean confirm, boolean closing, boolean addNonPartSources) {
        IWorkbenchPage page;
        if (this.modelService != null) {
            HashSet<MPart> dirtyParts = new HashSet<MPart>();
            IEclipseContext context = this.model.getContext();
            if (context != null) {
                ISaveHandler saveHandler;
                EPartService partService = (EPartService)context.get(EPartService.class);
                if (partService != null) {
                    Collection parts = null;
                    try {
                        parts = partService.getDirtyParts();
                        dirtyParts.addAll(parts);
                    }
                    catch (IllegalStateException illegalStateException) {}
                }
                if (!dirtyParts.isEmpty() && (saveHandler = (ISaveHandler)context.get(ISaveHandler.class)) != null && saveHandler instanceof WWinPartServiceSaveHandler) {
                    try {
                        return ((WWinPartServiceSaveHandler)saveHandler).saveParts(dirtyParts, confirm, closing, addNonPartSources);
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {}
                }
            }
        }
        if (!this.getWorkbenchImpl().isClosing() && (page = this.getActivePage()) != null) {
            return ((WorkbenchPage)page).saveAllEditors(true, true, true);
        }
        return true;
    }

    @Override
    public IWorkbenchPage openPage(String perspectiveId, IAdaptable input) throws WorkbenchException {
        Object[] result = new Object[1];
        BusyIndicator.showWhile(null, () -> {
            try {
                objectArray[0] = this.busyOpenPage(perspectiveId, input);
            }
            catch (WorkbenchException e) {
                objectArray[0] = e;
            }
        });
        if (result[0] instanceof IWorkbenchPage) {
            return (IWorkbenchPage)result[0];
        }
        if (result[0] instanceof WorkbenchException) {
            throw (WorkbenchException)((Object)result[0]);
        }
        throw new WorkbenchException(WorkbenchMessages.WorkbenchWindow_exceptionMessage);
    }

    private IWorkbenchPage busyOpenPage(String perspectiveId, IAdaptable input) throws WorkbenchException {
        IPerspectiveDescriptor descriptor = this.workbench.getPerspectiveRegistry().findPerspectiveWithId(perspectiveId);
        if (descriptor == null) {
            throw new WorkbenchException(NLS.bind((String)WorkbenchMessages.WorkbenchPage_ErrorCreatingPerspective, (Object)perspectiveId));
        }
        if (this.page == null) {
            this.page = new WorkbenchPage(this, input);
            this.model.getContext().set(IWorkbenchPage.class.getName(), (Object)this.page);
            try {
                ContextInjectionFactory.inject((Object)this.page, (IEclipseContext)this.model.getContext());
            }
            catch (InjectionException e) {
                throw new WorkbenchException(e.getMessage(), e);
            }
        } else {
            IWorkbenchWindow window = this.getWorkbench().openWorkbenchWindow(perspectiveId, input);
            return window.getActivePage();
        }
        this.firePageOpened();
        this.partService.setPage(this.page);
        this.perspective = descriptor;
        this.page.setPerspective(this.perspective);
        this.firePageActivated();
        return this.page;
    }

    @Override
    public IWorkbenchPage openPage(IAdaptable input) throws WorkbenchException {
        return this.openPage(this.workbench.getPerspectiveRegistry().getDefaultPerspective(), input);
    }

    @Override
    public void removePageListener(IPageListener l) {
        this.pageListeners.removePageListener(l);
    }

    @Override
    public void removePerspectiveListener(IPerspectiveListener l) {
        this.perspectiveListeners.removePerspectiveListener(l);
    }

    private void disableControl(Control ctrl, List<Control> toEnable) {
        if (ctrl != null && !ctrl.isDisposed() && ctrl.isEnabled()) {
            ctrl.setEnabled(false);
            toEnable.add(ctrl);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        block19: {
            block18: {
                manager = this.getStatusLineManager();
                v0 = progressHack = manager.getControl() == null;
                if (manager != null && !progressHack) break block18;
                runnable.run((IProgressMonitor)new NullProgressMonitor());
                break block19;
            }
            partService = (EPartService)this.model.getContext().get(EPartService.class);
            curActive = partService.getActivePart();
            wasCancelEnabled = manager.isCancelEnabled();
            enableMainMenu = false;
            bs = (IBindingService)this.model.getContext().get(IBindingService.class);
            keyFilterEnabled = bs.isKeyFilterEnabled();
            toEnable = new ArrayList<Control>();
            theShell = this.getShell();
            display = theShell.getDisplay();
            currentFocus = display.getFocusControl();
            try {
                mainMenu = (Menu)this.model.getMainMenu().getWidget();
                if (mainMenu != null && !mainMenu.isDisposed() && mainMenu.isEnabled()) {
                    mainMenu.setEnabled(false);
                    enableMainMenu = true;
                }
                if (keyFilterEnabled) {
                    bs.setKeyFilterEnabled(false);
                }
                var20_17 = display.getShells();
                var19_18 = var20_17.length;
                var18_21 = 0;
                while (var18_21 < var19_18) {
                    childShell = var20_17[var18_21];
                    if (childShell != theShell) {
                        this.disableControl((Control)childShell, toEnable);
                    }
                    ++var18_21;
                }
                tpl = (TrimmedPartLayout)this.getShell().getLayout();
                this.disableControl((Control)tpl.clientArea, toEnable);
                this.disableControl((Control)tpl.top, toEnable);
                this.disableControl((Control)tpl.left, toEnable);
                this.disableControl((Control)tpl.right, toEnable);
                if (tpl.bottom != null && !tpl.bottom.isDisposed() && tpl.bottom.isEnabled()) {
                    statusLine = this.modelService.find("org.eclipse.ui.StatusLine", (MUIElement)this.model);
                    slCtrl = statusLine != null ? statusLine.getWidget() : null;
                    var23_25 = tpl.bottom.getChildren();
                    var22_26 = var23_25.length;
                    var21_27 = 0;
                    while (var21_27 < var22_26) {
                        bottomCtrl = var23_25[var21_27];
                        if (bottomCtrl != slCtrl) {
                            this.disableControl(bottomCtrl, toEnable);
                        }
                        ++var21_27;
                    }
                }
                manager.setCancelEnabled(cancelable);
                ite = new InvocationTargetException[1];
                ie = new InterruptedException[1];
                BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)(Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$7(org.eclipse.jface.action.StatusLineManager org.eclipse.jface.operation.IRunnableWithProgress boolean java.lang.reflect.InvocationTargetException[] java.lang.InterruptedException[] ), ()V)((WorkbenchWindow)this, (StatusLineManager)manager, (IRunnableWithProgress)runnable, (boolean)fork, (InvocationTargetException[])ite, (InterruptedException[])ie));
                if (ite[0] != null) {
                    throw ite[0];
                }
                if (ie[0] != null) {
                    throw ie[0];
                }
            }
            finally {
                manager.setCancelEnabled(wasCancelEnabled);
                if (enableMainMenu && this.model != null && this.model.getMainMenu() != null) {
                    mainMenu = (Menu)this.model.getMainMenu().getWidget();
                    mainMenu.setEnabled(true);
                }
                if (keyFilterEnabled) {
                    bs.setKeyFilterEnabled(true);
                }
                var26_32 = toEnable.iterator();
                if (true) ** GOTO lbl73
            }
            {
            }
            do {
                if ((ctrl = (Control)var26_32.next()).isDisposed() || ctrl.isEnabled()) continue;
                ctrl.setEnabled(true);
lbl73:
                // 3 sources

            } while (var26_32.hasNext());
            activePart = partService.getActivePart();
            if (curActive != activePart && activePart != null) {
                this.engine.focusGui((MUIElement)activePart);
            } else if (currentFocus != null && !currentFocus.isDisposed()) {
                currentFocus.forceFocus();
            }
        }
    }

    @Override
    public void setActivePage(IWorkbenchPage in) {
        if (this.getActivePage() != in) {
            if (in == null) {
                this.firePageClosed();
            }
            this.page = (WorkbenchPage)in;
            this.model.getContext().set(IWorkbenchPage.class, (Object)this.page);
            this.partService.setPage(this.page);
            this.updateActionSets();
        }
    }

    private Boolean valueOf(boolean result) {
        return result ? Boolean.TRUE : Boolean.FALSE;
    }

    public Set<Object> getMenuRestrictions() {
        return this.menuRestrictions;
    }

    void liftRestrictions() {
        if (this.menuRestrictions.isEmpty()) {
            return;
        }
        EvaluationReference[] refs = this.menuRestrictions.toArray(new EvaluationReference[this.menuRestrictions.size()]);
        IEvaluationService es = this.serviceLocator.getService(IEvaluationService.class);
        IEvaluationContext currentState = es.getCurrentState();
        EvaluationReference[] evaluationReferenceArray = refs;
        int n = refs.length;
        int n2 = 0;
        while (n2 < n) {
            EvaluationReference reference = evaluationReferenceArray[n2];
            reference.setPostingChanges(true);
            boolean os = reference.evaluate(currentState);
            reference.clearResult();
            boolean ns = reference.evaluate(currentState);
            if (os != ns) {
                reference.getListener().propertyChange(new PropertyChangeEvent((Object)reference, reference.getProperty(), (Object)this.valueOf(os), (Object)this.valueOf(ns)));
            }
            ++n2;
        }
    }

    void imposeRestrictions() {
        for (EvaluationReference evaluationReference : this.menuRestrictions) {
            evaluationReference.setPostingChanges(false);
        }
    }

    private void trackShellActivation() {
        this.getShell().addShellListener((ShellListener)new ShellAdapter(){

            public void shellActivated(ShellEvent event) {
                WorkbenchWindow.this.shellActivated = true;
                WorkbenchWindow.this.serviceLocator.activate();
                if (WorkbenchWindow.this.getActivePage() != null) {
                    WorkbenchWindow.this.getWorkbenchImpl().fireWindowActivated(WorkbenchWindow.this);
                }
                WorkbenchWindow.this.liftRestrictions();
            }

            public void shellDeactivated(ShellEvent event) {
                WorkbenchWindow.this.shellActivated = false;
                WorkbenchWindow.this.imposeRestrictions();
                WorkbenchWindow.this.serviceLocator.deactivate();
                if (WorkbenchWindow.this.getActivePage() != null) {
                    WorkbenchWindow.this.getWorkbenchImpl().fireWindowDeactivated(WorkbenchWindow.this);
                }
            }
        });
    }

    public void updateActionBars() {
        if (this.getShell() == null || this.getShell().isDisposed() || this.updateDisabled || this.updatesDeferred()) {
            return;
        }
        if (this.mainMenu != null) {
            this.renderer.reconcileManagerToModel(this.menuManager, this.mainMenu);
        }
        try {
            this.getShell().setLayoutDeferred(true);
            this.eventBroker.send("org/eclipse/e4/ui/renderer/requestEnablementUpdate", (Object)"ALL");
            this.getCoolBarManager2().update(false);
        }
        finally {
            this.getShell().setLayoutDeferred(false);
        }
        this.getStatusLineManager().update(false);
    }

    private boolean updatesDeferred() {
        return this.largeUpdates > 0;
    }

    public final void largeUpdateStart() {
        ++this.largeUpdates;
    }

    public final void largeUpdateEnd() {
        if (--this.largeUpdates == 0) {
            this.updateActionBars();
        }
    }

    public void updateActionSets() {
        if (this.updateDisabled) {
            return;
        }
        WorkbenchPage currentPage = (WorkbenchPage)this.getActivePage();
        if (currentPage == null) {
            this.getActionPresentation().clearActionSets();
        } else {
            ICoolBarManager2 coolBarManager = (ICoolBarManager2)this.getCoolBarManager2();
            if (coolBarManager != null) {
                coolBarManager.refresh();
            }
            this.getActionPresentation().setActionSets(currentPage.getActionSets());
        }
        this.fireActionSetsChanged();
        this.updateActionBars();
        String path = "window/launch";
        IMenuManager manager = this.getMenuBarManager().findMenuUsingPath(path);
        IContributionItem item = this.getMenuBarManager().findUsingPath(path);
        if (manager == null || item == null) {
            return;
        }
        item.setVisible(manager.getItems().length >= 2);
    }

    private final void fireActionSetsChanged() {
        if (this.actionSetListeners != null) {
            Object[] objectArray = this.actionSetListeners.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                IActionSetsListener actionSetsListener = (IActionSetsListener)listener;
                WorkbenchPage currentPage = (WorkbenchPage)this.getActivePage();
                IActionSetDescriptor[] newActionSets = currentPage == null ? null : currentPage.getActionSets();
                ActionSetsEvent event = new ActionSetsEvent(newActionSets);
                actionSetsListener.actionSetsChanged(event);
                ++n2;
            }
        }
    }

    final void addActionSetsListener(IActionSetsListener listener) {
        if (this.actionSetListeners == null) {
            this.actionSetListeners = new ListenerList();
        }
        this.actionSetListeners.add((Object)listener);
    }

    final void removeActionSetsListener(IActionSetsListener listener) {
        if (this.actionSetListeners != null) {
            this.actionSetListeners.remove((Object)listener);
            if (this.actionSetListeners.isEmpty()) {
                this.actionSetListeners = null;
            }
        }
    }

    private boolean getShowHeapStatus() {
        return PrefUtil.getAPIPreferenceStore().getBoolean("SHOW_MEMORY_MONITOR") || Boolean.parseBoolean(Platform.getDebugOption((String)"org.eclipse.ui/perf/showHeapStatus"));
    }

    public void showHeapStatus(boolean show) {
        MUIElement hsElement = this.modelService.find("org.eclipse.ui.HeapStatus", (MUIElement)this.model);
        if (hsElement != null && hsElement.isToBeRendered() != show) {
            hsElement.setToBeRendered(show);
            Object widget = hsElement.getParent().getWidget();
            if (widget instanceof Control) {
                ((Control)widget).requestLayout();
            }
        }
    }

    WorkbenchWindowConfigurer getWindowConfigurer() {
        if (this.windowConfigurer == null) {
            this.windowConfigurer = new WorkbenchWindowConfigurer(this);
        }
        return this.windowConfigurer;
    }

    private WorkbenchAdvisor getAdvisor() {
        return this.getWorkbenchImpl().getAdvisor();
    }

    WorkbenchWindowAdvisor getWindowAdvisor() {
        if (this.windowAdvisor == null) {
            this.windowAdvisor = this.getAdvisor().createWorkbenchWindowAdvisor(this.getWindowConfigurer());
            Assert.isNotNull((Object)this.windowAdvisor);
        }
        return this.windowAdvisor;
    }

    private ActionBarAdvisor getActionBarAdvisor() {
        if (this.actionBarAdvisor == null) {
            this.actionBarAdvisor = this.getWindowAdvisor().createActionBarAdvisor(this.getWindowConfigurer().getActionBarConfigurer());
            Assert.isNotNull((Object)this.actionBarAdvisor);
        }
        return this.actionBarAdvisor;
    }

    private Workbench getWorkbenchImpl() {
        return Workbench.getInstance();
    }

    public void fillActionBars(int flags) {
        Workbench workbench = this.getWorkbenchImpl();
        workbench.largeUpdateStart();
        try {
            this.getActionBarAdvisor().fillActionBars(flags);
        }
        finally {
            workbench.largeUpdateEnd();
        }
    }

    public void fillActionBars(IActionBarConfigurer2 proxyBars, int flags) {
        Assert.isNotNull((Object)proxyBars);
        WorkbenchWindowConfigurer.WindowActionBarConfigurer wab = (WorkbenchWindowConfigurer.WindowActionBarConfigurer)this.getWindowConfigurer().getActionBarConfigurer();
        wab.setProxy(proxyBars);
        try {
            this.getActionBarAdvisor().fillActionBars(flags | 1);
        }
        finally {
            wab.setProxy(null);
        }
    }

    public void setCoolBarVisible(boolean visible) {
        boolean oldValue = this.coolBarVisible;
        this.coolBarVisible = visible;
        if (oldValue != this.coolBarVisible) {
            this.getModel().getPersistedState().put("coolBarVisible", Boolean.toString(visible));
            this.updateLayoutDataForContents();
            this.firePropertyChanged(PROP_COOLBAR_VISIBLE, oldValue ? Boolean.TRUE : Boolean.FALSE, this.coolBarVisible ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public boolean getCoolBarVisible() {
        return this.getWindowConfigurer().getShowCoolBar() && this.coolBarVisible;
    }

    public ActionPresentation getActionPresentation() {
        if (this.actionPresentation == null) {
            this.actionPresentation = new ActionPresentation(this);
        }
        return this.actionPresentation;
    }

    public void setPerspectiveBarVisible(boolean visible) {
        boolean oldValue = this.perspectiveBarVisible;
        this.perspectiveBarVisible = visible;
        if (oldValue != this.perspectiveBarVisible) {
            this.getModel().getPersistedState().put(PROP_PERSPECTIVEBAR_VISIBLE, Boolean.toString(visible));
            this.updateLayoutDataForContents();
            this.firePropertyChanged(PROP_PERSPECTIVEBAR_VISIBLE, oldValue ? Boolean.TRUE : Boolean.FALSE, this.perspectiveBarVisible ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public boolean getPerspectiveBarVisible() {
        return this.getWindowConfigurer().getShowPerspectiveBar() && this.perspectiveBarVisible;
    }

    public void setStatusLineVisible(boolean visible) {
        boolean oldValue = this.statusLineVisible;
        this.statusLineVisible = visible;
        if (oldValue != this.statusLineVisible) {
            this.getModel().getPersistedState().put(PROP_PERSPECTIVEBAR_VISIBLE, Boolean.toString(visible));
            this.updateLayoutDataForContents();
            this.firePropertyChanged(PROP_STATUS_LINE_VISIBLE, oldValue ? Boolean.TRUE : Boolean.FALSE, this.statusLineVisible ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public boolean getStatusLineVisible() {
        return this.statusLineVisible;
    }

    protected boolean showTopSeperator() {
        return false;
    }

    public ProgressRegion getProgressRegion() {
        return this.progressRegion;
    }

    @Override
    public IExtensionTracker getExtensionTracker() {
        if (this.model == null || this.model.getContext() == null) {
            return null;
        }
        return (IExtensionTracker)this.model.getContext().get(IExtensionTracker.class);
    }

    IAdaptable getDefaultPageInput() {
        return this.getWorkbenchImpl().getDefaultPageInput();
    }

    private final void initializeDefaultServices() {
        IEclipseContext windowContext = this.model.getContext();
        this.serviceLocator.registerService(IWorkbenchLocationService.class, new WorkbenchLocationService("org.eclipse.ui.IWorkbenchWindow", this.getWorkbench(), this, null, null, null, 1));
        this.serviceLocator.registerService(IWorkbenchWindow.class, this);
        ActionCommandMappingService mappingService = new ActionCommandMappingService();
        this.serviceLocator.registerService(IActionCommandMappingService.class, mappingService);
        this.selectionService = (SelectionService)ContextInjectionFactory.make(SelectionService.class, (IEclipseContext)this.model.getContext());
        this.serviceLocator.registerService(ISelectionService.class, this.selectionService);
        LegacyHandlerService hs = new LegacyHandlerService(windowContext);
        windowContext.set(IHandlerService.class.getName(), (Object)hs);
        LegacyActionPersistence actionPersistence = new LegacyActionPersistence(this);
        this.serviceLocator.registerService(LegacyActionPersistence.class, actionPersistence);
        actionPersistence.read();
        ICommandService cmdService = (ICommandService)this.workbench.getService(ICommandService.class);
        SlaveCommandService slaveCmdService = new SlaveCommandService(cmdService, "org.eclipse.ui.IWorkbenchWindow", this, this.model.getContext());
        this.serviceLocator.registerService(ICommandService.class, slaveCmdService);
        this.serviceLocator.registerService(IUpdateService.class, slaveCmdService);
        IContextService cxs = (IContextService)ContextInjectionFactory.make(ContextService.class, (IEclipseContext)this.model.getContext());
        this.serviceLocator.registerService(IContextService.class, cxs);
        IMenuService parent = (IMenuService)this.getWorkbench().getService(IMenuService.class);
        SlaveMenuService msvs = new SlaveMenuService(parent, (MApplicationElement)this.model);
        this.serviceLocator.registerService(IMenuService.class, msvs);
    }

    @Override
    public final <T> T getService(Class<T> key) {
        return this.serviceLocator.getService(key);
    }

    @Override
    public final boolean hasService(Class<?> key) {
        return this.serviceLocator.hasService(key);
    }

    public void toggleToolbarVisibility() {
        boolean coolbarVisible = this.getCoolBarVisible();
        boolean perspectivebarVisible = this.getPerspectiveBarVisible();
        if (this.getWindowConfigurer().getShowCoolBar()) {
            this.setCoolBarVisible(!coolbarVisible);
        }
        if (this.getWindowConfigurer().getShowPerspectiveBar()) {
            this.setPerspectiveBarVisible(!perspectivebarVisible);
        }
        ICommandService commandService = this.getService(ICommandService.class);
        HashMap<String, WorkbenchWindow> filter = new HashMap<String, WorkbenchWindow>();
        filter.put("org.eclipse.ui.IWorkbenchWindow", this);
        commandService.refreshElements(COMMAND_ID_TOGGLE_COOLBAR, filter);
    }

    public boolean isToolbarVisible() {
        return this.getCoolBarVisible() && this.getWindowConfigurer().getShowCoolBar() || this.getPerspectiveBarVisible() && this.getWindowConfigurer().getShowPerspectiveBar();
    }

    private void updateLayoutDataForContents() {
        MTrimBar topTrim = this.getTopTrim();
        if (topTrim != null) {
            topTrim.setVisible(this.isToolbarVisible());
            Shell shell = this.getShell();
            if (shell != null && !shell.isDisposed()) {
                shell.layout();
            }
        }
    }

    void addBackgroundSaveListener(IBackgroundSaveListener listener) {
        this.backgroundSaveListeners.add((Object)listener);
    }

    void fireBackgroundSaveStarted() {
        Object[] objectArray = this.backgroundSaveListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            IBackgroundSaveListener backgroundSaveListener = (IBackgroundSaveListener)listener;
            backgroundSaveListener.handleBackgroundSaveStarted();
            ++n2;
        }
    }

    void removeBackgroundSaveListener(IBackgroundSaveListener listener) {
        this.backgroundSaveListeners.remove((Object)listener);
    }

    public MWindow getModel() {
        return this.model;
    }

    public StatusLineManager getStatusLineManager() {
        if (this.statusLineManager == null) {
            this.statusLineManager = new StatusLineManager();
        }
        return this.statusLineManager;
    }

    public ICoolBarManager getCoolBarManager2() {
        if (this.coolbarToTrim == null) {
            this.coolbarToTrim = new CoolBarToTrimManager(this.application, this.model, this.workbenchTrimElements, this.rendererFactory);
        }
        return this.coolbarToTrim;
    }

    public CoolBarManager getCoolBarManager() {
        WorkbenchPlugin.log(new Exception("Bad call to getCoolBarManager()"));
        return this.oldCBM;
    }

    public MenuManager getMenuManager() {
        return this.menuManager;
    }

    public IMenuManager getMenuBarManager() {
        return this.menuManager;
    }

    public IToolBarManager2 getToolBarManager2() {
        return this.toolBarManager;
    }

    public IToolBarManager getToolBarManager() {
        return this.getToolBarManager2();
    }

    public CustomizePerspectiveDialog createCustomizePerspectiveDialog(Perspective persp, IEclipseContext context) {
        return new CustomizePerspectiveDialog(this.getWindowConfigurer(), persp, context);
    }

    private /* synthetic */ void lambda$7(StatusLineManager statusLineManager, IRunnableWithProgress iRunnableWithProgress, boolean bl, InvocationTargetException[] invocationTargetExceptionArray, InterruptedException[] interruptedExceptionArray) {
        try {
            try {
                ModalContext.run((IRunnableWithProgress)iRunnableWithProgress, (boolean)bl, (IProgressMonitor)statusLineManager.getProgressMonitor(), (Display)this.getShell().getDisplay());
            }
            catch (InvocationTargetException e1) {
                invocationTargetExceptionArray[0] = e1;
                statusLineManager.getProgressMonitor().done();
            }
            catch (InterruptedException e2) {
                interruptedExceptionArray[0] = e2;
                statusLineManager.getProgressMonitor().done();
            }
        }
        finally {
            statusLineManager.getProgressMonitor().done();
        }
    }

    static class MenuOverrides
    implements IContributionManagerOverrides {
        private WorkbenchPage page;

        MenuOverrides(WorkbenchPage page) {
            this.page = page;
        }

        public Integer getAccelerator(IContributionItem item) {
            return null;
        }

        public String getAcceleratorText(IContributionItem item) {
            return null;
        }

        public Boolean getEnabled(IContributionItem item) {
            return null;
        }

        public String getText(IContributionItem item) {
            return null;
        }

        public Boolean getVisible(IContributionItem item) {
            if (this.page == null) {
                return null;
            }
            MPerspective curPersp = this.page.getCurrentPerspective();
            if (curPersp == null) {
                return null;
            }
            String id = CustomizePerspectiveDialog.getIDFromIContributionItem(item);
            if (id == null) {
                return null;
            }
            String hiddenToolItems = this.page.getHiddenItems();
            if (hiddenToolItems.contains("persp.hideMenuSC:" + id + ",")) {
                return Boolean.FALSE;
            }
            return null;
        }
    }

    static class ToolbarOverrides
    implements IContributionManagerOverrides {
        private WorkbenchPage page;

        ToolbarOverrides(WorkbenchPage page) {
            this.page = page;
        }

        public Integer getAccelerator(IContributionItem item) {
            return null;
        }

        public String getAcceleratorText(IContributionItem item) {
            return null;
        }

        public Boolean getEnabled(IContributionItem item) {
            return null;
        }

        public String getText(IContributionItem item) {
            return null;
        }

        public Boolean getVisible(IContributionItem item) {
            if (this.page == null) {
                return null;
            }
            MPerspective curPersp = this.page.getCurrentPerspective();
            if (curPersp == null) {
                return null;
            }
            String id = CustomizePerspectiveDialog.getIDFromIContributionItem(item);
            if (id == null) {
                return null;
            }
            String hiddenToolItems = this.page.getHiddenItems();
            if (hiddenToolItems.contains("persp.hideToolbarSC:" + id + ",")) {
                return Boolean.FALSE;
            }
            return null;
        }
    }

    private class WWinPartService
    extends PartService {
        private WWinPartService() {
        }

        @Override
        public void partActivated(IWorkbenchPart part) {
            super.partActivated(part);
            WorkbenchWindow.this.selectionService.notifyListeners(part);
        }
    }

    class WWinPartServiceSaveHandler
    extends PartServiceSaveHandler {
        WWinPartServiceSaveHandler() {
        }

        public boolean saveParts(Collection<MPart> dirtyParts, boolean confirm, boolean closing, boolean addNonPartSources) {
            if (addNonPartSources || closing) {
                throw new UnsupportedOperationException();
            }
            return this.saveParts(dirtyParts, confirm);
        }
    }
}

