/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.app.standalone.actions;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.app.standalone.internal.CoreApplicationMessages;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;

public class ResetSettingsHandler
extends AbstractHandler {
    private static final Log log = Log.getLog(ResetSettingsHandler.class);
    private static final String PLUGINS_FOLDER = ".plugins";
    private static final String CORE_RESOURCES_PLUGIN = "org.eclipse.core.resources";
    private static final Option[] OPTIONS = new Option[]{new Option("user_preferences", CoreApplicationMessages.reset_settings_option_user_preferences_name, CoreApplicationMessages.reset_settings_option_user_preferences_description, true, path -> !path.startsWith(CORE_RESOURCES_PLUGIN)), new Option("workspace_configuration", CoreApplicationMessages.reset_settings_option_workspace_configuration_name, CoreApplicationMessages.reset_settings_option_workspace_configuration_description, false, path -> path.startsWith(CORE_RESOURCES_PLUGIN))};

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ResetSettingsDialog dialog = new ResetSettingsDialog(HandlerUtil.getActiveShell((ExecutionEvent)event));
        if (dialog.open() != 0) {
            return null;
        }
        final Set<String> options = dialog.options;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench.restart()) {
            final Path path = DBWorkbench.getPlatform().getWorkspace().getMetadataFolder().resolve(PLUGINS_FOLDER);
            if (Files.notExists(path, new LinkOption[0]) || !Files.isDirectory(path, new LinkOption[0])) {
                return null;
            }
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                try {
                    Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                            log.trace((Object)("Deleting " + file));
                            try {
                                Files.delete(file);
                            }
                            catch (IOException e) {
                                log.trace((Object)("Unable to delete " + file + ":" + e.getMessage()));
                            }
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                            if (dir.endsWith(ResetSettingsHandler.PLUGINS_FOLDER)) {
                                return FileVisitResult.CONTINUE;
                            }
                            Option[] optionArray = OPTIONS;
                            int n = OPTIONS.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Option option = optionArray[n2];
                                if (options.contains(option.id) && option.predicate.test(path.relativize(dir))) {
                                    return FileVisitResult.CONTINUE;
                                }
                                ++n2;
                            }
                            return FileVisitResult.SKIP_SUBTREE;
                        }

                        @Override
                        public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                            log.trace((Object)("Deleting " + dir));
                            try {
                                Files.delete(dir);
                            }
                            catch (IOException e) {
                                log.trace((Object)("Unable to delete " + dir + ":" + e.getMessage()));
                            }
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                catch (IOException e) {
                    log.error((Object)"Error walking plugin settings", (Throwable)e);
                }
            }));
        }
        return null;
    }

    private static class Option {
        private final String id;
        private final String name;
        private final String description;
        private final boolean checked;
        private final Predicate<Path> predicate;

        public Option(@NotNull String id, @NotNull String name, @Nullable String description, boolean checked, @NotNull Predicate<Path> predicate) {
            this.id = id;
            this.name = name;
            this.description = description;
            this.checked = checked;
            this.predicate = predicate;
        }
    }

    private static class ResetSettingsDialog
    extends BaseDialog {
        private final Set<String> options = new HashSet<String>();

        public ResetSettingsDialog(@NotNull Shell shell) {
            super(shell, CoreApplicationMessages.reset_settings_dialog_title, null);
            this.setShellStyle(2144);
        }

        protected Composite createDialogArea(Composite parent) {
            Composite composite = super.createDialogArea(parent);
            UIUtils.createLabel((Composite)composite, (String)CoreApplicationMessages.reset_settings_dialog_message);
            Group group = UIUtils.createControlGroup((Composite)composite, (String)CoreApplicationMessages.reset_settings_dialog_options, (int)1, (int)1808, (int)0);
            SelectionListener listener = SelectionListener.widgetSelectedAdapter(e -> {
                Button checkbox = (Button)e.widget;
                Option option = (Option)checkbox.getData();
                if (checkbox.getSelection()) {
                    this.options.add(option.id);
                } else {
                    this.options.remove(option.id);
                }
                UIUtils.asyncExec(() -> {
                    Button button = this.getButton(0);
                    if (button != null) {
                        button.setEnabled(!this.options.isEmpty());
                    }
                });
            });
            int indent = ResetSettingsDialog.computeCheckboxIndent((Composite)group);
            Option[] optionArray = OPTIONS;
            int n = OPTIONS.length;
            int n2 = 0;
            while (n2 < n) {
                Option option = optionArray[n2];
                Button checkbox = UIUtils.createCheckbox((Composite)group, (String)option.name, (String)option.description, (boolean)option.checked, (int)1);
                checkbox.setData((Object)option);
                checkbox.addSelectionListener(listener);
                checkbox.notifyListeners(13, new Event());
                Label label = UIUtils.createLabel((Composite)group, (String)option.description);
                label.setLayoutData((Object)GridDataFactory.swtDefaults().indent(indent, 0).create());
                ++n2;
            }
            return composite;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, CoreApplicationMessages.button_apply_and_restart, true).setEnabled(false);
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        }

        private static int computeCheckboxIndent(@NotNull Composite parent) {
            Label measurementLabel = UIUtils.createLabel((Composite)parent, (String)"X ");
            Button measurementCheckbox = UIUtils.createCheckbox((Composite)parent, (String)"X", (boolean)false);
            parent.layout(true, true);
            try {
                int n = measurementCheckbox.getSize().x - measurementLabel.getSize().x;
                return n;
            }
            finally {
                measurementLabel.dispose();
                measurementCheckbox.dispose();
            }
        }
    }
}

