/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.ResultSet;
import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTable;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableContainer;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBStructUtils;
import org.jkiss.dbeaver.model.struct.rdb.DBSTablePartition;

public class PostgreTablePartition
extends PostgreTable
implements DBSTablePartition {
    public static final String CAT_PARTITIONING = "Partitioning";
    private String partitionExpression;
    private PostgreTable partitionOf;

    public PostgreTablePartition(PostgreTable container) {
        super(container);
        this.partitionExpression = "FOR VALUES ";
        this.setPartition(true);
        this.setName("newpartition");
        this.partitionOf = container;
    }

    public PostgreTablePartition(PostgreTableContainer container, ResultSet dbResult) {
        super(container, dbResult);
        this.setPartition(true);
        this.partitionExpression = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"partition_expr");
    }

    @Property(viewable=true, editable=true, updatable=true, order=60)
    @Nullable
    public String getPartitionExpression() {
        return this.partitionExpression;
    }

    public void setPartitionExpression(String expr) {
        this.partitionExpression = expr;
    }

    @Override
    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        options.put("ddl.skipForeignKeys", true);
        options.put("ddl.separateForeignKeys", false);
        options.put("ddl.includeNestedObjects", false);
        options.put("ddl.includePermissions", false);
        options.put("ddl.skipIndexes", true);
        options.put("ddl.skipUniqueKeys", true);
        return DBStructUtils.generateTableDDL((DBRProgressMonitor)monitor, (DBSEntity)this, options, (boolean)false);
    }

    public PostgreTable getPartitionOf() {
        return this.partitionOf;
    }
}

