/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreInformation;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreProcedure;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRole;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreScriptObject;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class PostgreForeignDataWrapper
extends PostgreInformation
implements PostgreScriptObject {
    private long oid;
    private String name;
    private String[] options;
    private long ownerId;
    private long handlerProcId;
    private long validatorProcId;
    private long handlerSchemaId;

    public PostgreForeignDataWrapper(PostgreDatabase database, ResultSet dbResult) throws SQLException {
        super(database);
        this.loadInfo(dbResult);
    }

    private void loadInfo(ResultSet dbResult) throws SQLException {
        this.oid = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"oid");
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"fdwname");
        this.ownerId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"fdwowner");
        this.handlerProcId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"fdwhandler");
        this.validatorProcId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"fdwvalidator");
        this.handlerSchemaId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"handler_schema_id");
        this.options = PostgreUtils.safeGetStringArray(dbResult, "fdwoptions");
    }

    @Property(viewable=true, order=2)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Property(viewable=true, order=5)
    public String[] getOptions() {
        return this.options;
    }

    public long getObjectId() {
        return this.oid;
    }

    @Property(viewable=false, order=8)
    public PostgreRole getOwner(DBRProgressMonitor monitor) throws DBException {
        return this.getDatabase().getRoleById(monitor, this.ownerId);
    }

    @Property(viewable=false, order=10)
    public PostgreProcedure getHandler(DBRProgressMonitor monitor) throws DBException {
        return this.getDatabase().getProcedure(monitor, this.handlerSchemaId, this.handlerProcId);
    }

    @Property(viewable=false, order=10)
    public PostgreProcedure getValidator(DBRProgressMonitor monitor) throws DBException {
        return this.getDatabase().getProcedure(monitor, this.handlerSchemaId, this.validatorProcId);
    }

    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        PostgreProcedure handler = this.getHandler(monitor);
        PostgreProcedure validator = this.getValidator(monitor);
        return "-- Foreign data wrapper: " + this.getName() + "\n\n" + "-- DROP FOREIGN DATA WRAPPER " + this.getName() + ";\n\n" + "CREATE FOREIGN DATA WRAPPER " + this.getName() + "\n\t" + (handler == null ? "" : "HANDLER " + handler.getName() + "\n\t") + (validator == null ? "" : "VALIDATOR " + validator.getName() + "\n\t") + "OPTIONS " + PostgreUtils.getOptionsString(this.options);
    }

    @Override
    public void setObjectDefinitionText(String sourceText) throws DBException {
    }
}

