/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.tasks;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jkiss.dbeaver.ext.postgresql.tasks.PostgreDatabaseBackupAllHandler;
import org.jkiss.dbeaver.ext.postgresql.tasks.PostgreDatabaseBackupHandler;
import org.jkiss.dbeaver.ext.postgresql.tasks.PostgreDatabaseRestoreHandler;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocation;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.tasks.nativetool.AbstractNativeToolHandler;
import org.jkiss.dbeaver.tasks.nativetool.AbstractNativeToolSettings;
import org.jkiss.dbeaver.tasks.nativetool.NativeToolUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public abstract class PostgreNativeToolHandler<SETTINGS extends AbstractNativeToolSettings<BASE_OBJECT>, BASE_OBJECT extends DBSObject, PROCESS_ARG>
extends AbstractNativeToolHandler<SETTINGS, BASE_OBJECT, PROCESS_ARG> {
    public static final boolean USE_STREAM_MONITOR = false;

    protected void setupProcessParameters(DBRProgressMonitor monitor, SETTINGS settings, PROCESS_ARG arg, ProcessBuilder process) {
        String userPassword = settings.getToolUserPassword();
        if (CommonUtils.isEmpty((String)userPassword)) {
            userPassword = this.getDataSourcePassword(monitor, (AbstractNativeToolSettings)settings);
        }
        if (!CommonUtils.isEmpty((String)userPassword)) {
            process.environment().put("PGPASSWORD", userPassword);
        }
    }

    public void fillProcessParameters(SETTINGS settings, PROCESS_ARG process_arg, List<String> cmd) throws IOException {
        File dumpBinary = RuntimeUtils.getNativeClientBinary((DBPNativeClientLocation)settings.getClientHome(), (String)"bin", (String)(this instanceof PostgreDatabaseBackupHandler ? "pg_dump" : (this instanceof PostgreDatabaseRestoreHandler ? "pg_restore" : (this instanceof PostgreDatabaseBackupAllHandler ? "pg_dumpall" : "psql"))));
        String dumpPath = dumpBinary.getAbsolutePath();
        cmd.add(dumpPath);
        if (this.isVerbose()) {
            cmd.add("--verbose");
        }
        DBPDataSourceContainer dataSourceContainer = settings.getDataSourceContainer();
        NativeToolUtils.addHostAndPortParamsToCmd((DBPDataSourceContainer)dataSourceContainer, cmd);
        String toolUserName = settings.getToolUserName();
        if (CommonUtils.isEmpty((String)toolUserName)) {
            toolUserName = dataSourceContainer.getActualConnectionConfiguration().getUserName();
        }
        cmd.add("--username=" + toolUserName);
        settings.addExtraCommandArgs(cmd);
    }

    public boolean isVerbose() {
        return false;
    }

    protected abstract boolean isExportWizard();

    static String escapeCLIIdentifier(String name) {
        if (RuntimeUtils.isWindows()) {
            return "\"" + name.replace("\"", "\\\"") + "\"";
        }
        return name;
    }
}

