/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model.impls.redshift;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreIndex;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRole;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTable;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableConstraint;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableConstraintBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableContainer;
import org.jkiss.dbeaver.ext.postgresql.model.impls.redshift.RedshiftExternalSchema;
import org.jkiss.dbeaver.ext.postgresql.model.impls.redshift.RedshiftExternalTableColumn;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;

public class RedshiftExternalTable
extends PostgreTable
implements DBPRefreshableObject {
    private static final Log log = Log.getLog(RedshiftExternalTable.class);
    private String location;
    private String inputFormat;
    private String outputFormat;
    private String serializationLib;
    private String serdeParameters;
    private int compressed;
    private String parameters;

    protected RedshiftExternalTable(RedshiftExternalSchema catalog) {
        super(catalog);
    }

    protected RedshiftExternalTable(RedshiftExternalSchema catalog, ResultSet dbResult) {
        super(catalog);
        this.setName(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"tablename"));
        this.setPersisted(true);
        this.location = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"location");
        this.inputFormat = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"input_format");
        this.outputFormat = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"output_format");
        this.serializationLib = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"serialization_lib");
        this.serdeParameters = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"serde_parameters");
        this.compressed = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"compressed");
        this.parameters = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"parameters");
    }

    public RedshiftExternalTable(DBRProgressMonitor monitor, RedshiftExternalSchema container, RedshiftExternalTable source, boolean persisted) throws DBException {
        super(monitor, (PostgreTableContainer)container, source, persisted);
        this.location = source.location;
        this.inputFormat = source.inputFormat;
        this.outputFormat = source.outputFormat;
        this.serializationLib = source.serializationLib;
        this.serdeParameters = source.serdeParameters;
        this.compressed = source.compressed;
        this.parameters = source.parameters;
    }

    public RedshiftExternalSchema getContainer() {
        return (RedshiftExternalSchema)super.getContainer();
    }

    @Override
    public long getObjectId() {
        return 0L;
    }

    @Override
    @Nullable
    public String[] getRelOptions() {
        return null;
    }

    @Override
    public PostgreRole getOwner(DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    @Property(viewable=true, order=10)
    public String getLocation() {
        return this.location;
    }

    @Property(viewable=true, order=11)
    public String getInputFormat() {
        return this.inputFormat;
    }

    @Property(viewable=true, order=12)
    public String getOutputFormat() {
        return this.outputFormat;
    }

    @Property(viewable=false, order=13)
    public String getSerializationLib() {
        return this.serializationLib;
    }

    @Property(viewable=false, order=14)
    public String getSerdeParameters() {
        return this.serdeParameters;
    }

    @Property(viewable=false, order=15)
    public int getCompressed() {
        return this.compressed;
    }

    @Property(viewable=false, order=16)
    public String getParameters() {
        return this.parameters;
    }

    @Override
    @Nullable
    public String getDescription() {
        return null;
    }

    @Override
    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.getContainer(), this});
    }

    @Override
    @NotNull
    public RedshiftExternalSchema getSchema() {
        return (RedshiftExternalSchema)super.getContainer();
    }

    public List<RedshiftExternalTableColumn> getAttributes(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.getContainer().getExternalTableCache().getChildren(monitor, this.getContainer(), this);
    }

    public List<RedshiftExternalTableColumn> getCachedAttributes() {
        DBSObjectCache childrenCache = this.getContainer().getExternalTableCache().getChildrenCache(this);
        if (childrenCache != null) {
            return childrenCache.getCachedObjects();
        }
        return Collections.emptyList();
    }

    @Override
    public RedshiftExternalTableColumn getAttribute(@NotNull DBRProgressMonitor monitor, @NotNull String attributeName) throws DBException {
        return (RedshiftExternalTableColumn)this.getContainer().getExternalTableCache().getChild(monitor, this.getContainer(), this, attributeName);
    }

    @Override
    public boolean isView() {
        return false;
    }

    @Override
    public Collection<PostgreIndex> getIndexes(DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    @Override
    public Collection<PostgreTableConstraint> getConstraints(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    @Override
    public PostgreTableConstraintBase getConstraint(@NotNull DBRProgressMonitor monitor, String ukName) throws DBException {
        return null;
    }

    @Override
    @Association
    public Collection<? extends DBSEntityAssociation> getReferences(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    @Override
    @Association
    public synchronized Collection<? extends DBSEntityAssociation> getAssociations(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    @Override
    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.getContainer().getExternalTableCache().refreshObject(monitor, this.getContainer(), this);
    }

    @Override
    public void setObjectDefinitionText(String sourceText) throws DBException {
    }

    @Override
    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        return null;
    }

    @Override
    protected void readTableStatistics(JDBCSession session) throws SQLException {
    }
}

