/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.util.LinkedList;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreAttribute;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataTypeAttribute;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.model.DBPAttributeReferencePurpose;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeEnumerable;
import org.jkiss.dbeaver.model.struct.DBSContextBoundAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class PostgreDataBoundTypeAttribute
extends PostgreAttribute<PostgreTableBase>
implements DBSEntityAttribute,
DBSAttributeEnumerable,
DBSContextBoundAttribute {
    private final DBSEntityAttribute context;
    private final PostgreDataTypeAttribute member;

    public PostgreDataBoundTypeAttribute(@NotNull DBRProgressMonitor monitor, @NotNull PostgreTableBase container, @NotNull DBSEntityAttribute context, @NotNull PostgreDataTypeAttribute attr) throws DBException {
        super(monitor, container, attr);
        this.context = context;
        this.member = attr;
    }

    @NotNull
    public String formatMemberReference(boolean isIncludeContainerName, @Nullable String containerAliasOrNull, @NotNull DBPAttributeReferencePurpose purpose) {
        LinkedList<String> parts = new LinkedList<String>();
        parts.addLast(DBUtils.getQuotedIdentifier((DBSObject)this.member));
        DBSEntityAttribute context = this.context;
        while (context instanceof PostgreDataBoundTypeAttribute) {
            PostgreDataBoundTypeAttribute boundAttr = (PostgreDataBoundTypeAttribute)context;
            parts.addFirst(DBUtils.getQuotedIdentifier((DBSObject)boundAttr.member));
            context = boundAttr.context;
        }
        parts.addFirst(DBUtils.getQuotedIdentifier((DBSObject)context));
        if (isIncludeContainerName) {
            if (containerAliasOrNull == null) {
                if (context.getParentObject() != this.getTable()) {
                    parts.addFirst(DBUtils.getQuotedIdentifier((DBSObject)context.getParentObject()));
                }
                parts.addFirst(DBUtils.getObjectFullName((DBPNamedObject)this.getTable(), (DBPEvaluationContext)DBPEvaluationContext.DML));
            } else {
                parts.addFirst(containerAliasOrNull);
            }
        }
        if (purpose.equals((Object)DBPAttributeReferencePurpose.DATA_SELECTION)) {
            return String.valueOf("(".repeat(parts.size() - 1)) + String.join((CharSequence)").", parts);
        }
        return String.join((CharSequence)".", parts);
    }

    @Override
    @NotNull
    public PostgreSchema getSchema() {
        return this.member.getSchema();
    }
}

