/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql;

import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.WinReg;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.PostgreServerHome;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.impls.PostgreServerType;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceURLProvider;
import org.jkiss.dbeaver.model.DatabaseURL;
import org.jkiss.dbeaver.model.access.DBAAuthModel;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.connection.DBPDriverConfigurationType;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocation;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocationManager;
import org.jkiss.dbeaver.model.connection.NativeClientLocationUtils;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSourceProvider;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.PrefUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public class PostgreDataSourceProvider
extends JDBCDataSourceProvider
implements DBPNativeClientLocationManager {
    private static Map<String, String> connectionsProps = new HashMap<String, String>();
    private static Map<String, PostgreServerHome> localServers;

    static {
        DBPPreferenceStore preferenceStore = DBWorkbench.getPlatform().getPreferenceStore();
        if (preferenceStore != null) {
            PrefUtils.setDefaultPreferenceValue((DBPPreferenceStore)preferenceStore, (String)"postgresql.dd.plain.string", (Object)false);
            PrefUtils.setDefaultPreferenceValue((DBPPreferenceStore)preferenceStore, (String)"postgresql.dd.tag.string", (Object)false);
        }
        localServers = null;
    }

    public static Map<String, String> getConnectionsProps() {
        return connectionsProps;
    }

    public long getFeatures() {
        return 3L;
    }

    public String getConnectionURL(DBPDriver driver, DBPConnectionConfiguration connectionInfo) {
        String connectionURL;
        DBAAuthModel authModel = connectionInfo.getAuthModel();
        if (authModel instanceof DBPDataSourceURLProvider && CommonUtils.isNotEmpty((String)(connectionURL = ((DBPDataSourceURLProvider)authModel).getConnectionURL(driver, connectionInfo)))) {
            return connectionURL;
        }
        if (connectionInfo.getConfigurationType() == DBPDriverConfigurationType.URL) {
            return connectionInfo.getUrl();
        }
        PostgreServerType serverType = PostgreUtils.getServerType(driver);
        if (serverType.supportsCustomConnectionURL()) {
            return DatabaseURL.generateUrlByTemplate((DBPDriver)driver, (DBPConnectionConfiguration)connectionInfo);
        }
        StringBuilder url = new StringBuilder();
        url.append("jdbc:postgresql://");
        url.append(connectionInfo.getHostName());
        if (!CommonUtils.isEmpty((String)connectionInfo.getHostPort())) {
            url.append(":").append(connectionInfo.getHostPort());
        }
        url.append("/");
        if (!CommonUtils.isEmpty((String)connectionInfo.getDatabaseName())) {
            url.append(connectionInfo.getDatabaseName());
        }
        return url.toString();
    }

    @NotNull
    public DBPDataSource openDataSource(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container) throws DBException {
        return new PostgreDataSource(monitor, container);
    }

    public boolean providesDriverClasses() {
        return false;
    }

    public List<DBPNativeClientLocation> findLocalClientLocations() {
        PostgreDataSourceProvider.findLocalClients();
        return new ArrayList<PostgreServerHome>(localServers.values());
    }

    public DBPNativeClientLocation getDefaultLocalClientLocation() {
        PostgreDataSourceProvider.findLocalClients();
        return localServers.isEmpty() ? null : (DBPNativeClientLocation)localServers.values().iterator().next();
    }

    public String getProductName(DBPNativeClientLocation location) {
        if (location instanceof PostgreServerHome) {
            return location.getDisplayName();
        }
        return "PostgreSQL";
    }

    public String getProductVersion(DBPNativeClientLocation location) {
        return PostgreDataSourceProvider.getFullServerVersion(location.getPath());
    }

    public static synchronized void findLocalClients() {
        block9: {
            if (localServers != null) {
                return;
            }
            localServers = new LinkedHashMap<String, PostgreServerHome>();
            if (RuntimeUtils.isWindows()) {
                try {
                    String[] homeKeys;
                    if (!Advapi32Util.registryKeyExists((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)"SOFTWARE\\PostgreSQL\\Installations") || (homeKeys = Advapi32Util.registryGetKeys((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)"SOFTWARE\\PostgreSQL\\Installations")) == null) break block9;
                    String[] stringArray = homeKeys;
                    int n = homeKeys.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String homeKey = stringArray[n2];
                        TreeMap valuesMap = Advapi32Util.registryGetValues((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)("SOFTWARE\\PostgreSQL\\Installations\\" + homeKey));
                        for (String key : valuesMap.keySet()) {
                            if (!"Base Directory".equalsIgnoreCase(key)) continue;
                            String baseDir = CommonUtils.removeTrailingSlash((String)CommonUtils.toString(valuesMap.get("Base Directory")));
                            String branding = CommonUtils.toString(valuesMap.get("Branding"));
                            localServers.put(homeKey, new PostgreServerHome(homeKey, baseDir, branding));
                            break;
                        }
                        ++n2;
                    }
                }
                catch (Throwable e) {
                    log.warn((Object)"Error reading Windows registry", e);
                }
            } else if (RuntimeUtils.isMacOS()) {
                ArrayList postgresDirs = new ArrayList();
                Collections.addAll(postgresDirs, NativeClientLocationUtils.getSubdirectories((File[])NativeClientLocationUtils.getSubdirectoriesWithNamesStartingWith((String)"postgresql", (File[])new File[]{new File("/usr/local/Cellar/")})));
                Collections.addAll(postgresDirs, NativeClientLocationUtils.getSubdirectories((File[])new File[]{new File("/Library/PostgreSQL/")}));
                Collections.addAll(postgresDirs, NativeClientLocationUtils.getSubdirectories((File[])new File[]{new File("/Applications/Postgres.app/Contents/versions/")}));
                for (File dir : postgresDirs) {
                    PostgreServerHome home;
                    PostgreServerHome duplicate;
                    String canonicalPath;
                    String branding;
                    File bin = new File(dir, "bin");
                    File psql = new File(bin, "psql");
                    if (!bin.exists() || !bin.isDirectory() || !psql.exists() || !psql.canExecute() || (branding = PostgreDataSourceProvider.getBranding(dir)).isEmpty() || (canonicalPath = NativeClientLocationUtils.getCanonicalPath((File)dir)).isEmpty() || (duplicate = localServers.putIfAbsent(branding, home = new PostgreServerHome(branding, canonicalPath, branding))) == null) continue;
                    localServers.remove(branding);
                    home = new PostgreServerHome(canonicalPath, canonicalPath, canonicalPath);
                    String duplicatePath = duplicate.getPath().getAbsolutePath();
                    duplicate = new PostgreServerHome(duplicatePath, duplicatePath, duplicatePath);
                    localServers.put(canonicalPath, home);
                    localServers.put(duplicatePath, duplicate);
                }
            }
        }
    }

    private static String getBranding(File path) {
        String fullVersion = PostgreDataSourceProvider.getFullServerVersion(path);
        if (fullVersion == null) {
            return "";
        }
        if (fullVersion.length() < 7) {
            log.warn((Object)"Unable to figure out PostgreSQL server branding from psql output!");
            return "";
        }
        return fullVersion.substring(6).replace(")", "").trim();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static String getFullServerVersion(File path) {
        File binPath = path;
        File binSubfolder = new File(binPath, "bin");
        if (binSubfolder.exists()) {
            binPath = binSubfolder;
        }
        String cmd = new File(binPath, RuntimeUtils.getNativeBinaryName((String)"psql")).getAbsolutePath();
        try {
            Process p = Runtime.getRuntime().exec(new String[]{cmd, "--version"});
            try {
                BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
                try {
                    String line = input.readLine();
                    if (line != null) {
                        String string = line;
                        return string;
                    }
                }
                finally {
                    IOUtils.close((Closeable)input);
                }
            }
            finally {
                p.destroy();
            }
        }
        catch (Exception ex) {
            log.warn((Object)("Error reading PostgreSQL native client version from " + cmd), (Throwable)ex);
        }
        return null;
    }
}

