/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.generator;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPartSite;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPScriptObjectExt2;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.generator.SQLGenerator;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.sql.dialogs.ViewSQLDialog;
import org.jkiss.dbeaver.ui.editors.sql.internal.SQLEditorMessages;
import org.jkiss.utils.CommonUtils;

class SQLGeneratorDialog
extends ViewSQLDialog {
    private static final Log log = Log.getLog(SQLGeneratorDialog.class);
    private static final String PROP_USE_FQ_NAMES = "GenerateSQL.useFQNames";
    private static final String PROP_USE_COMPACT_SQL = "GenerateSQL.compactSQL";
    private static final String PROP_EXCLUDE_AUTO_GENERATED_COLUMNS = "GenerateSQL.excludeAutoGeneratedColumn";
    private static final String PROP_USE_CUSTOM_DATA_FORMAT = "GenerateSQL.useCustomDataFormat";
    private static final String PROP_USE_SEPARATE_FK_STATEMENTS = "GenerateSQL.useSeparateFKStatements";
    private final SQLGenerator<?> sqlGenerator;
    private Job generateDDLJob;

    SQLGeneratorDialog(IWorkbenchPartSite parentSite, DBCExecutionContext context, SQLGenerator<?> sqlGenerator) {
        super(parentSite, () -> context, NLS.bind((String)SQLEditorMessages.sql_generator_dialog_title, (Object)context.getDataSource().getContainer().getName()), null, "");
        this.sqlGenerator = sqlGenerator;
    }

    @Override
    protected Composite createDialogArea(Composite parent) {
        this.sqlGenerator.setFullyQualifiedNames(this.getDialogBoundsSettings().get(PROP_USE_FQ_NAMES) == null || this.getDialogBoundsSettings().getBoolean(PROP_USE_FQ_NAMES));
        this.sqlGenerator.setCompactSQL(this.getDialogBoundsSettings().get(PROP_USE_COMPACT_SQL) != null && this.getDialogBoundsSettings().getBoolean(PROP_USE_COMPACT_SQL));
        this.sqlGenerator.setExcludeAutoGeneratedColumn(this.getDialogBoundsSettings().get(PROP_EXCLUDE_AUTO_GENERATED_COLUMNS) != null && this.getDialogBoundsSettings().getBoolean(PROP_EXCLUDE_AUTO_GENERATED_COLUMNS));
        this.sqlGenerator.setUseSeparateForeignKeys(this.getDialogBoundsSettings().get(PROP_USE_SEPARATE_FK_STATEMENTS) == null || this.getDialogBoundsSettings().getBoolean(PROP_USE_SEPARATE_FK_STATEMENTS));
        boolean supportPermissions = false;
        boolean supportComments = false;
        boolean supportFullDDL = false;
        boolean supportSeparateFKStatements = false;
        boolean supportsPartitionsDDL = false;
        for (Object object : this.sqlGenerator.getObjects()) {
            if (!(object instanceof DBPScriptObjectExt2)) continue;
            DBPScriptObjectExt2 sourceObject = (DBPScriptObjectExt2)object;
            if (sourceObject.supportsObjectDefinitionOption("ddl.includePermissions")) {
                supportPermissions = true;
            }
            if (sourceObject.supportsObjectDefinitionOption("ddl.includeComments")) {
                supportComments = true;
            }
            if (sourceObject.supportsObjectDefinitionOption("ddl.includeNestedObjects")) {
                supportFullDDL = true;
            }
            if (sourceObject.supportsObjectDefinitionOption("ddl.onlyForeignKeys") && sourceObject.supportsObjectDefinitionOption("ddl.skipForeignKeys")) {
                supportSeparateFKStatements = true;
            }
            if (supportPermissions && supportComments && supportFullDDL) break;
            if (!sourceObject.supportsObjectDefinitionOption("ddl.includePartitions")) continue;
            supportsPartitionsDDL = true;
        }
        this.sqlGenerator.setShowPermissions(this.getDialogBoundsSettings().get("ddl.includePermissions") != null && this.getDialogBoundsSettings().getBoolean("ddl.includePermissions"));
        this.sqlGenerator.setShowComments(this.getDialogBoundsSettings().get("ddl.includeComments") != null && this.getDialogBoundsSettings().getBoolean("ddl.includeComments"));
        this.sqlGenerator.setShowFullDdl(this.getDialogBoundsSettings().get("ddl.includeNestedObjects") != null && this.getDialogBoundsSettings().getBoolean("ddl.includeNestedObjects"));
        this.generateDDLJob = new AbstractJob("Generating DDL"){

            protected IStatus run(DBRProgressMonitor monitor) {
                try {
                    DBExecUtils.tryExecuteRecover((Object)monitor, (DBPDataSource)SQLGeneratorDialog.this.getExecutionContext().getDataSource(), param -> SQLGeneratorDialog.this.sqlGenerator.run(monitor));
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    Object sql = SQLGeneratorDialog.this.sqlGenerator.getResult();
                    UIUtils.syncExec(() -> {
                        if (SQLGeneratorDialog.this.getShell() != null && !SQLGeneratorDialog.this.getShell().isDisposed()) {
                            Button button;
                            if (sql != null) {
                                SQLGeneratorDialog.this.setSQLText(CommonUtils.toString((Object)sql));
                                SQLGeneratorDialog.this.updateSQL();
                            }
                            if ((button = SQLGeneratorDialog.this.getButton(13)) != null) {
                                button.setEnabled(true);
                            }
                        }
                    });
                    return Status.OK_STATUS;
                }
                catch (DBException e) {
                    UIUtils.syncExec(() -> {
                        if (SQLGeneratorDialog.this.getShell() != null && !SQLGeneratorDialog.this.getShell().isDisposed()) {
                            SQLGeneratorDialog.this.setSQLText("Error running DDL generation");
                        }
                    });
                    log.error((Object)e);
                    return Status.error((String)"Error running DDL generation", (Throwable)e);
                }
            }
        };
        Composite composite = super.createDialogArea(parent);
        this.startGenerateJob();
        if (!this.sqlGenerator.hasOptions()) {
            return composite;
        }
        Group settings = UIUtils.createControlGroup((Composite)composite, (String)"Settings", (int)5, (int)768, (int)-1);
        settings.setLayout((Layout)new RowLayout());
        final Button useFQNames = UIUtils.createCheckbox((Composite)settings, (String)SQLEditorMessages.sql_generator_dialog_button_use_fully_names, (boolean)this.sqlGenerator.isFullyQualifiedNames());
        useFQNames.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SQLGeneratorDialog.this.sqlGenerator.setFullyQualifiedNames(useFQNames.getSelection());
                SQLGeneratorDialog.this.getDialogBoundsSettings().put(SQLGeneratorDialog.PROP_USE_FQ_NAMES, useFQNames.getSelection());
                SQLGeneratorDialog.this.startGenerateJob();
            }
        });
        final Button useCompactSQL = UIUtils.createCheckbox((Composite)settings, (String)SQLEditorMessages.sql_generator_dialog_button_compact_sql, (boolean)this.sqlGenerator.isCompactSQL());
        useCompactSQL.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SQLGeneratorDialog.this.sqlGenerator.setCompactSQL(useCompactSQL.getSelection());
                SQLGeneratorDialog.this.getDialogBoundsSettings().put(SQLGeneratorDialog.PROP_USE_COMPACT_SQL, useCompactSQL.getSelection());
                SQLGeneratorDialog.this.startGenerateJob();
            }
        });
        if (this.sqlGenerator.isInsertOption()) {
            final Button excludeAutoGeneratedColumn = UIUtils.createCheckbox((Composite)settings, (String)SQLEditorMessages.sql_generator_dialog_button_exclude_columns, (boolean)this.sqlGenerator.isExcludeAutoGeneratedColumn());
            excludeAutoGeneratedColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SQLGeneratorDialog.this.sqlGenerator.setExcludeAutoGeneratedColumn(excludeAutoGeneratedColumn.getSelection());
                    SQLGeneratorDialog.this.getDialogBoundsSettings().put(SQLGeneratorDialog.PROP_EXCLUDE_AUTO_GENERATED_COLUMNS, excludeAutoGeneratedColumn.getSelection());
                    SQLGeneratorDialog.this.startGenerateJob();
                }
            });
        }
        if (this.sqlGenerator.isDMLOption()) {
            final Button useCustomDateFormat = UIUtils.createCheckbox((Composite)settings, (String)SQLEditorMessages.sql_generator_dialog_button_use_custom_data_format, (boolean)this.sqlGenerator.isUseCustomDataFormat());
            useCustomDateFormat.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SQLGeneratorDialog.this.sqlGenerator.setUseCustomDataFormat(useCustomDateFormat.getSelection());
                    SQLGeneratorDialog.this.getDialogBoundsSettings().put(SQLGeneratorDialog.PROP_USE_CUSTOM_DATA_FORMAT, useCustomDateFormat.getSelection());
                    SQLGeneratorDialog.this.startGenerateJob();
                }
            });
        }
        if (this.sqlGenerator.isDDLOption()) {
            if (supportComments) {
                final Button useShowComments = UIUtils.createCheckbox((Composite)settings, (String)SQLEditorMessages.sql_generator_dialog_button_show_comments, (boolean)this.sqlGenerator.isShowComments());
                useShowComments.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        SQLGeneratorDialog.this.sqlGenerator.setShowComments(useShowComments.getSelection());
                        SQLGeneratorDialog.this.getDialogBoundsSettings().put("ddl.includeComments", useShowComments.getSelection());
                        SQLGeneratorDialog.this.startGenerateJob();
                    }
                });
            }
            if (supportPermissions) {
                final Button useShowPermissions = UIUtils.createCheckbox((Composite)settings, (String)SQLEditorMessages.sql_generator_dialog_button_show_permissions, (boolean)this.sqlGenerator.isIncludePermissions());
                useShowPermissions.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        SQLGeneratorDialog.this.sqlGenerator.setShowPermissions(useShowPermissions.getSelection());
                        SQLGeneratorDialog.this.getDialogBoundsSettings().put("ddl.includePermissions", useShowPermissions.getSelection());
                        SQLGeneratorDialog.this.startGenerateJob();
                    }
                });
            }
        }
        if (supportFullDDL) {
            final Button useShowFullDdl = UIUtils.createCheckbox((Composite)settings, (String)SQLEditorMessages.sql_generator_dialog_button_show_full_DDL, (boolean)this.sqlGenerator.isShowFullDdl());
            useShowFullDdl.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SQLGeneratorDialog.this.sqlGenerator.setShowFullDdl(useShowFullDdl.getSelection());
                    SQLGeneratorDialog.this.getDialogBoundsSettings().put("ddl.includeComments", useShowFullDdl.getSelection());
                    SQLGeneratorDialog.this.startGenerateJob();
                }
            });
        }
        if (supportSeparateFKStatements) {
            final Button useSeparateFkStatements = UIUtils.createCheckbox((Composite)settings, (String)SQLEditorMessages.sql_generator_dialog_button_separate_fk_constraints_definition, (boolean)this.sqlGenerator.isUseSeparateForeignKeys());
            useSeparateFkStatements.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SQLGeneratorDialog.this.sqlGenerator.setUseSeparateForeignKeys(useSeparateFkStatements.getSelection());
                    SQLGeneratorDialog.this.getDialogBoundsSettings().put("ddl.separateForeignKeys", useSeparateFkStatements.getSelection());
                    SQLGeneratorDialog.this.startGenerateJob();
                }
            });
        }
        if (supportsPartitionsDDL) {
            final Button supportsPartitionsDDLButton = UIUtils.createCheckbox((Composite)settings, (String)SQLEditorMessages.sql_generator_dialog_button_show_partitions_DDL, (boolean)this.sqlGenerator.isShowPartitionsDDL());
            supportsPartitionsDDLButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SQLGeneratorDialog.this.sqlGenerator.setShowPartitionsDDL(supportsPartitionsDDLButton.getSelection());
                    SQLGeneratorDialog.this.getDialogBoundsSettings().put("ddl.includePartitions", supportsPartitionsDDLButton.getSelection());
                    SQLGeneratorDialog.this.startGenerateJob();
                }
            });
        }
        if (this.sqlGenerator.supportCastParams()) {
            final Button supportsCastParamsButton = UIUtils.createCheckbox((Composite)settings, (String)SQLEditorMessages.sql_generator_dialog_button_show_cast_params, (boolean)this.sqlGenerator.isShowCastParams());
            supportsCastParamsButton.setToolTipText(SQLEditorMessages.sql_generator_dialog_button_show_cast_params_tip);
            supportsCastParamsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SQLGeneratorDialog.this.sqlGenerator.setShowCastParams(supportsCastParamsButton.getSelection());
                    SQLGeneratorDialog.this.getDialogBoundsSettings().put("sql.castParameter", supportsCastParamsButton.getSelection());
                    SQLGeneratorDialog.this.startGenerateJob();
                }
            });
        }
        return composite;
    }

    private void startGenerateJob() {
        this.setSQLText("Loading DDL...");
        this.updateSQL();
        Button button = this.getButton(13);
        if (button != null) {
            button.setEnabled(false);
        }
        this.generateDDLJob.cancel();
        this.generateDDLJob.schedule();
    }

    @Override
    public boolean close() {
        this.generateDDLJob.cancel();
        return super.close();
    }

    static /* synthetic */ SQLGenerator access$1(SQLGeneratorDialog sQLGeneratorDialog) {
        return sQLGeneratorDialog.sqlGenerator;
    }
}

